// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_SCIENCE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M18.68,22H5.32a2.31755,2.31755,0,0,1-1.96-3.55L4.27,17,9,9.46V3H7V1H17V3H15V9.46L19.73,17l.91,1.45A2.31755,2.31755,0,0,1,18.68,22Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M13.00011,9.99989,18.94874,19.516a.31747.31747,0,0,1-.2679.48383H5.31938a.31746.31746,0,0,1-.266-.48686l5.94673-9.513v-7L13,3ZM7,1V3H8.99967V9.46L3.359,18.45A2.31755,2.31755,0,0,0,5.31927,22H18.68073A2.31755,2.31755,0,0,0,20.641,18.45L15.00033,9.46,15,3h2V1Z" }))));
}
;
export default EOS_SCIENCE;
