// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_SANDBOX({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "9.54", cy: "8.99", r: "1" }),
                React.createElement("circle", { cx: "11.04", cy: "11.99", r: "1" }),
                React.createElement("circle", { cx: "8.04", cy: "11.99", r: "1" }),
                React.createElement("path", { d: "M19,9.24V15H15a3,3,0,0,1-6,0H5V5h9.77l2-2H5A2,2,0,0,0,3,5V19a2,2,0,0,0,2,2H19a2,2,0,0,0,2-2V7.24Z" }),
                React.createElement("path", { d: "M17,10.1l-.84-.84-.26.26L14.46,8.11l.26-.26-.78-.78c-.37-.38-.88-.17-1.15.31L11.62,9.29a2,2,0,0,1,1.49,1.16,1.54,1.54,0,0,1,.6-.13A1.67,1.67,0,0,1,15.39,12h0l1.25-.74C17.14,11,17.35,10.48,17,10.1Z" }),
                React.createElement("polygon", { points: "15.87 9.53 16.13 9.26 21.41 3.99 19.99 2.57 14.72 7.85 14.46 8.11 15.87 9.53" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "9.53729", cy: "8.98682", r: "1" }),
                React.createElement("path", { d: "M8.03729,10.98682a1,1,0,0,0-1,1,.98411.98411,0,0,0,.48188.83447.97177.97177,0,0,0,.51812.16553,1.00005,1.00005,0,0,0,1-1,1.01586,1.01586,0,0,0-1-1Z" }),
                React.createElement("path", { d: "M3,19a1.99946,1.99946,0,0,0,2,2H19a2.00591,2.00591,0,0,0,2-2h0V7.244l-2,2V15H15a3.00005,3.00005,0,0,1-6,0H5L4.99,5h9.76874l2-2H5A1.9931,1.9931,0,0,0,3,5Zm2,0V17l2.4223.00031A5.10254,5.10254,0,0,0,8.987,19Zm14,0-3.987-.03339a4.99847,4.99847,0,0,0,1.5647-1.9663L19,17Z" }),
                React.createElement("path", { d: "M13.9433,7.07147c-.37665-.37658-.88111-.17022-1.15759.31018L11.62152,9.29492a2.07983,2.07983,0,0,1,1.48706,1.15082,1.6183,1.6183,0,0,1,.5921-.129l.01044-.00122a1.70348,1.70348,0,0,1,1.683,1.67L15.41241,12l.37952-.22479.87128-.516c.47619-.28937.68683-.78095.31018-1.15754L16.133,9.26123l5.27362-5.27362L19.99237,2.57343,14.71881,7.847Z" }),
                React.createElement("circle", { cx: "11.03729", cy: "11.98682", r: "1" }))));
}
;
export default EOS_SANDBOX;
