// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_PUSH_PIN({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "18 13.04 16.01 11.048 16.01 3.017 17.01 3.017 17.01 1.017 7.01 1.017 7.01 3.017 8.01 3.017 8.01 11.04 8.001 11.04 6 13.04 6 15.04 11.01 15.04 11 22 13 22 13.01 15.04 18 15.04 18 13.04" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M18.99591,12.01123A3.00521,3.00521,0,0,1,16,9V4h1l-.01294.01123A1.02319,1.02319,0,0,0,18,3a1.00722,1.00722,0,0,0-1.01532-.98822L17,2H7a.9997.9997,0,0,0-.00293,1.99939L8,4,7.99561,8.99908A2.99117,2.99117,0,0,1,5,12v2h6v7l1,1,1-1V14h6V12ZM9,12a4.941,4.941,0,0,0,1-3V4h4V9a4.99059,4.99059,0,0,0,1,3Z" }))));
}
;
export default EOS_PUSH_PIN;
