// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_PULL_REQUEST({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M6,17.18372V8.81628a3,3,0,1,0-2,0v8.36744a3,3,0,1,0,2,0Z" }),
                React.createElement("path", { d: "M20,17.18372V7a2,2,0,0,0-2-2H12.82837l1.58581-1.58582L13,2,10.41425,4.58575h-.00007L9,6l1.41418,1.41418L13,10l1.41418-1.41425L12.82843,7H18V17.18372a3,3,0,1,0,2,0Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M6,17.18372V8.81628a3,3,0,1,0-2,0v8.36744a3,3,0,1,0,2,0ZM5,5A1,1,0,1,1,4,6,1,1,0,0,1,5,5ZM5,21a1,1,0,1,1,1-1A1,1,0,0,1,5,21Z" }),
                React.createElement("path", { d: "M20,17.18372V7a2,2,0,0,0-2-2H12.82837l1.58581-1.58582L13,2,10.41425,4.58575,9,6l1.41418,1.41418L13,10l1.41418-1.41425L12.82843,7H18V17.18372a3,3,0,1,0,2,0ZM19,21a1,1,0,1,1,1-1A1,1,0,0,1,19,21Z" }))));
}
;
export default EOS_PULL_REQUEST;
