// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_ORGANISMS({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M21.5,11a1.50038,1.50038,0,0,0-.3241.03723L19.66962,8.42865A1.49483,1.49483,0,1,0,17.0918,7H14.9082a1.48288,1.48288,0,0,0-1.73205-.96283L11.67,3.4281A1.49483,1.49483,0,1,0,9.0918,2H6.9082A1.49556,1.49556,0,1,0,4.33,3.4281L2.82385,6.03717a1.5005,1.5005,0,1,0,.01178,2.922l1.50269,2.60254A1.47036,1.47036,0,0,0,4.3299,13.4281l-1.50623,2.609a1.50049,1.50049,0,1,0,.01215,2.92206l1.50256,2.60254A1.49475,1.49475,0,1,0,6.9082,23H9.0918a1.49554,1.49554,0,1,0,2.56976-1.43842l1.50232-2.60253A1.47813,1.47813,0,0,0,14.9082,18h2.1836a1.49554,1.49554,0,1,0,2.56982-1.43835l1.50244-2.60254A1.49876,1.49876,0,1,0,21.5,11Zm-3,5a1.49569,1.49569,0,0,0-1.4082,1H14.9082a1.48879,1.48879,0,0,0-1.72064-.96643L11.678,13.4184a1.47055,1.47055,0,0,0-.01642-1.85675l1.50244-2.60254A1.47822,1.47822,0,0,0,14.9082,8h2.1836a1.48287,1.48287,0,0,0,1.7323.96277l1.50628,2.60858a1.47062,1.47062,0,0,0-.00824,1.84729l-1.50958,2.615A1.50294,1.50294,0,0,0,18.5,16Zm-8,5a1.49569,1.49569,0,0,0-1.4082,1H6.9082a1.489,1.489,0,0,0-1.72-.96661l-1.50989-2.6153a1.47069,1.47069,0,0,0-.00842-1.84637l1.50617-2.60889A1.483,1.483,0,0,0,6.9082,13H9.0918a1.48294,1.48294,0,0,0,1.73236.96277l1.50635,2.6084a1.47072,1.47072,0,0,0-.00885,1.84692l-1.50989,2.6153A1.50278,1.50278,0,0,0,10.5,21ZM3.67,6.5719,5.17615,3.96283A1.48288,1.48288,0,0,0,6.9082,3H9.0918a1.48287,1.48287,0,0,0,1.7323.96277l1.50628,2.60858a1.47065,1.47065,0,0,0-.0086,1.84686l-1.50995,2.61518A1.48906,1.48906,0,0,0,9.0918,12H6.9082a1.48906,1.48906,0,0,0-1.72-.96661l-1.51-2.61518A1.4706,1.4706,0,0,0,3.67,6.5719Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M21.5,11a1.50038,1.50038,0,0,0-.3241.03723L19.66962,8.42865A1.49483,1.49483,0,1,0,17.0918,7H14.9082a1.48288,1.48288,0,0,0-1.73205-.96283L11.67,3.4281A1.49483,1.49483,0,1,0,9.0918,2H6.9082A1.49556,1.49556,0,1,0,4.33,3.4281L2.82385,6.03717a1.5005,1.5005,0,1,0,.01178,2.922l1.50269,2.60254A1.47036,1.47036,0,0,0,4.3299,13.4281l-1.50623,2.609a1.50049,1.50049,0,1,0,.01215,2.92206l1.50256,2.60254A1.49475,1.49475,0,1,0,6.9082,23H9.0918a1.49554,1.49554,0,1,0,2.56976-1.43842l1.50232-2.60253A1.47813,1.47813,0,0,0,14.9082,18h2.1836a1.49554,1.49554,0,1,0,2.56982-1.43835l1.50244-2.60254A1.49876,1.49876,0,1,0,21.5,11Zm-3-4a.5.5,0,1,1-.5.5A.5.5,0,0,1,18.5,7Zm-5,0a.5.5,0,1,1-.5.5A.5.5,0,0,1,13.5,7Zm-3-5a.5.5,0,1,1-.5.5A.5.5,0,0,1,10.5,2Zm-5,0a.5.5,0,1,1-.5.5A.5.5,0,0,1,5.5,2Zm-3,6A.5.5,0,1,1,3,7.5.5.5,0,0,1,2.5,8Zm1.17822.41821A1.4706,1.4706,0,0,0,3.67,6.5719L5.17615,3.96283A1.48288,1.48288,0,0,0,6.9082,3H9.0918a1.48287,1.48287,0,0,0,1.7323.96277l1.50628,2.60858a1.47065,1.47065,0,0,0-.0086,1.84686l-1.50995,2.61518A1.48906,1.48906,0,0,0,9.0918,12H6.9082a1.48906,1.48906,0,0,0-1.72-.96661ZM11,12.5a.5.5,0,1,1-.5-.5A.5.5,0,0,1,11,12.5Zm-5,0a.5.5,0,1,1-.5-.5A.5.5,0,0,1,6,12.5ZM2.5,18a.5.5,0,1,1,.5-.5A.5.5,0,0,1,2.5,18Zm3,5a.5.5,0,1,1,.5-.5A.5.5,0,0,1,5.5,23Zm5,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,10.5,23Zm1.82166-4.58191-1.50989,2.6153A1.489,1.489,0,0,0,9.0918,22H6.9082a1.489,1.489,0,0,0-1.72-.96661l-1.50989-2.6153a1.47069,1.47069,0,0,0-.00842-1.84637l1.50617-2.60889A1.483,1.483,0,0,0,6.9082,13H9.0918a1.48294,1.48294,0,0,0,1.73236.96277l1.50635,2.6084a1.47072,1.47072,0,0,0-.00885,1.84692ZM13.5,18a.5.5,0,1,1,.5-.5A.5.5,0,0,1,13.5,18Zm5,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,18.5,18Zm1.82214-4.58136-1.50958,2.615A1.48859,1.48859,0,0,0,17.0918,17H14.9082a1.48879,1.48879,0,0,0-1.72064-.96643L11.678,13.4184a1.47055,1.47055,0,0,0-.01642-1.85675l1.50244-2.60254A1.47822,1.47822,0,0,0,14.9082,8h2.1836a1.48287,1.48287,0,0,0,1.7323.96277l1.50628,2.60858a1.47062,1.47062,0,0,0-.00824,1.84729ZM21.5,13a.5.5,0,1,1,.5-.5A.5.5,0,0,1,21.5,13Z" }))));
}
;
export default EOS_ORGANISMS;
