// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_NODE({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "12", cy: "3", r: "1" }),
                React.createElement("circle", { cx: "20", cy: "8", r: "1" }),
                React.createElement("circle", { cx: "20", cy: "16", r: "1" }),
                React.createElement("circle", { cx: "4", cy: "8", r: "1" }),
                React.createElement("circle", { cx: "4", cy: "16", r: "1" }),
                React.createElement("path", { d: "M20,14V10a1.99219,1.99219,0,0,1-1.48114-3.33313L13.73553,3.97626a1.983,1.983,0,0,1-3.47106,0L5.48114,6.66687A1.99219,1.99219,0,0,1,4,10v4a1.99214,1.99214,0,0,1,1.48108,3.33313l4.78339,2.69061a1.99146,1.99146,0,0,1,1.23553-.953V13.92926a2,2,0,1,1,1,0v5.14148a1.99146,1.99146,0,0,1,1.23553.953l4.78339-2.69061A1.99214,1.99214,0,0,1,20,14Z" }),
                React.createElement("circle", { cx: "12", cy: "21", r: "1" }),
                React.createElement("circle", { cx: "12", cy: "12", r: "1" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("circle", { cx: "12", cy: "2", r: "1" }),
                React.createElement("circle", { cx: "21", cy: "6", r: "1" }),
                React.createElement("circle", { cx: "21", cy: "17", r: "1" }),
                React.createElement("circle", { cx: "12", cy: "22", r: "1" }),
                React.createElement("path", { d: "M21,8a2.00591,2.00591,0,0,1-2-2,1.94033,1.94033,0,0,1,.26-.96L14,2a2.005,2.005,0,0,1-1.01,1.73,1.94984,1.94984,0,0,1-1.98,0A2.005,2.005,0,0,1,10,2L4.74,5.04A1.94033,1.94033,0,0,1,5,6,2.00591,2.00591,0,0,1,3,8a2.08089,2.08089,0,0,1-.5-.07v7.14A2.0779,2.0779,0,0,1,3,15a1.99136,1.99136,0,0,1,1.5.69,2.19137,2.19137,0,0,1,.39.68A1.89621,1.89621,0,0,1,5,17a1.98722,1.98722,0,0,1-.58,1.41l3.84,2.21,1.78,1.03a1.27772,1.27772,0,0,1,.07-.28.25426.25426,0,0,0,.02-.07,1.78858,1.78858,0,0,1,.12-.24c.01-.03.03-.06.04-.09.05005-.07.09-.14.14-.2.03-.03.05-.06.08-.09a1.21307,1.21307,0,0,1,.16-.16.52542.52542,0,0,1,.11-.1,1.62663,1.62663,0,0,1,.17-.11,1.18938,1.18938,0,0,1,.15-.09c.06-.03.11-.05.17-.08l.21-.06005a.74165.74165,0,0,1,.14-.04,1.82589,1.82589,0,0,1,.76,0,.74165.74165,0,0,1,.14.04l.21.06005c.06.03.11005.05.17.08a1.18938,1.18938,0,0,1,.15.09,1.62663,1.62663,0,0,1,.17.11.52542.52542,0,0,1,.11.1,1.21307,1.21307,0,0,1,.16.16c.03.03.05.06.08.09.05.06.09.13.14.2.00995.03.03.06.04.09a1.78858,1.78858,0,0,1,.12.24.25426.25426,0,0,0,.02.07,1.27772,1.27772,0,0,1,.07.28l1.78-1.03,3.84-2.21A1.98722,1.98722,0,0,1,19,17a1.89621,1.89621,0,0,1,.11-.63,2.19137,2.19137,0,0,1,.39-.68A1.99136,1.99136,0,0,1,21,15a2.0779,2.0779,0,0,1,.5.07V7.93A2.08089,2.08089,0,0,1,21,8Zm-9,5a1,1,0,1,1,1-1A1.003,1.003,0,0,1,12,13Zm7.5.3A4.003,4.003,0,0,0,17,17a3.55369,3.55369,0,0,0,.06.56l-2.47,1.42A3.9929,3.9929,0,0,0,13,18.14V14.82a3,3,0,1,0-2,0v3.32a3.9929,3.9929,0,0,0-1.59.84L6.94,17.56A3.55369,3.55369,0,0,0,7,17a4.003,4.003,0,0,0-2.5-3.7V9.7A4.00409,4.00409,0,0,0,7,6.04L9.15,4.8a3.9843,3.9843,0,0,0,5.7,0L17,6.04A4.00409,4.00409,0,0,0,19.5,9.7Z" }),
                React.createElement("circle", { cx: "3", cy: "17", r: "1" }),
                React.createElement("circle", { cx: "3", cy: "6", r: "1" }))));
}
;
export default EOS_NODE;
