// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_KEYBOARD_DOUBLE_ARROW_UP({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "6,17.59 7.41,19 12,14.42 16.59,19 18,17.59 12,11.59" }),
                React.createElement("polygon", { points: "6,11 7.41,12.41 12,7.83 16.59,12.41 18,11 12,5" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "6,17.59 7.41,19 12,14.42 16.59,19 18,17.59 12,11.59" }),
                React.createElement("polygon", { points: "6,11 7.41,12.41 12,7.83 16.59,12.41 18,11 12,5" }))));
}
;
export default EOS_KEYBOARD_DOUBLE_ARROW_UP;
