// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_HOUSE_SIDING({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19,12h3L12,3L2,12h3v8h2v-2h10v2h2V12z M7.21,10h9.58L17,10.19V12H7v-1.81L7.21,10z M14.57,8H9.43L12,5.69L14.57,8z M7,16 v-2h10v2H7z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19,12h3L12,3L2,12h3v8h2v-2h10v2h2V12z M7.21,10h9.58L17,10.19V12H7v-1.81L7.21,10z M14.57,8H9.43L12,5.69L14.57,8z M7,16 v-2h10v2H7z" }))));
}
;
export default EOS_HOUSE_SIDING;
