// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_FRONT_HAND({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M19.75,8c-0.69,0-1.25,0.56-1.25,1.25V15H18c-1.65,0-3,1.35-3,3h-1c0-2.04,1.53-3.72,3.5-3.97l0-10.78 C17.5,2.56,16.94,2,16.25,2C15.56,2,15,2.56,15,3.25V11h-1V1.25C14,0.56,13.44,0,12.75,0S11.5,0.56,11.5,1.25V11h-1V2.75 c0-0.69-0.56-1.25-1.25-1.25S8,2.06,8,2.75V12H7V5.75C7,5.06,6.44,4.5,5.75,4.5S4.5,5.06,4.5,5.75v10c0,4.56,3.69,8.25,8.25,8.25 S21,20.31,21,15.75v-6.5C21,8.56,20.44,8,19.75,8z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M18.5,8c-0.17,0-0.34,0.02-0.5,0.05V4.5C18,3.12,16.88,2,15.5,2c-0.19,0-0.37,0.02-0.54,0.06C14.75,0.89,13.73,0,12.5,0 c-1.06,0-1.96,0.66-2.33,1.59C9.96,1.53,9.73,1.5,9.5,1.5C8.12,1.5,7,2.62,7,4v0.55C6.84,4.52,6.67,4.5,6.5,4.5C5.12,4.5,4,5.62,4,7 v8.5c0,4.69,3.81,8.5,8.5,8.5s8.5-3.81,8.5-8.5v-5C21,9.12,19.88,8,18.5,8z M19,15.5c0,3.59-2.91,6.5-6.5,6.5S6,19.09,6,15.5V7 c0-0.28,0.22-0.5,0.5-0.5S7,6.72,7,7v5h2V4c0-0.28,0.22-0.5,0.5-0.5S10,3.72,10,4v7h2V2.5C12,2.22,12.22,2,12.5,2S13,2.22,13,2.5V11 h2V4.5C15,4.22,15.22,4,15.5,4S16,4.22,16,4.5v8.92c-1.77,0.77-3,2.53-3,4.58h2c0-1.66,1.34-3,3-3v-4.5c0-0.28,0.22-0.5,0.5-0.5 s0.5,0.22,0.5,0.5V15.5z" }))));
}
;
export default EOS_FRONT_HAND;
