// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_ENDPOINTS({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "3.02", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "6.99", y: "15.01", width: "2", height: "2" }),
                React.createElement("rect", { x: "6.99", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "11", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "15.01", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "19.02", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "15.01", y: "7.01", width: "2", height: "2" }),
                React.createElement("rect", { x: "5.99", y: "17.99", width: "4", height: "4" }),
                React.createElement("rect", { x: "14.01", y: "2.01", width: "4", height: "4" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "3.02", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "6.99", y: "15.01", width: "2", height: "2" }),
                React.createElement("rect", { x: "6.99", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "11", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "15.01", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "19.02", y: "10.98", width: "2", height: "2" }),
                React.createElement("rect", { x: "15.01", y: "7.01", width: "2", height: "2" }),
                React.createElement("rect", { x: "5.99", y: "17.99", width: "4", height: "4" }),
                React.createElement("rect", { x: "14.01", y: "2.01", width: "4", height: "4" }))));
}
;
export default EOS_ENDPOINTS;
