// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_DATABASE_MIGRATION({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M24,11.02107c0,1.01253-2.46242,1.83334-5.5,1.83334S13,12.0336,13,11.02107V9.18774c0,1.01253,2.46242,1.83333,5.5,1.83333s5.5-.8208,5.5-1.83333" }),
                React.createElement("path", { d: "M18.5,6.13728c-3.03517,0-5.5-.825-5.5-1.83332V7.94443c0,1.00833,2.46486,1.83332,5.5,1.83332s5.5-.825,5.5-1.83332V4.304C24,5.31229,21.5352,6.13728,18.5,6.13728Z" }),
                React.createElement("path", { d: "M24,1.83333C24,.82081,21.53758,0,18.5,0S13,.82081,13,1.83333V3.05556c0,1.01252,2.46242,1.83333,5.5,1.83333S24,4.06808,24,3.05556" }),
                React.createElement("path", { d: "M11,22.02107c0,1.01253-2.46242,1.83334-5.5,1.83334S0,23.0336,0,22.02107V20.18774c0,1.01253,2.46242,1.83333,5.5,1.83333s5.5-.8208,5.5-1.83333Z" }),
                React.createElement("path", { d: "M5.5,17.13728c-3.03517,0-5.5-.825-5.5-1.83332v3.64047c0,1.00833,2.46486,1.83332,5.5,1.83332s5.5-.825,5.5-1.83332V15.304C11,16.31229,8.5352,17.13728,5.5,17.13728Z" }),
                React.createElement("path", { d: "M11,12.83333C11,11.82081,8.53758,11,5.5,11S0,11.82081,0,12.83333v1.22223c0,1.01252,2.46242,1.83333,5.5,1.83333s5.5-.82081,5.5-1.83333Z" }),
                React.createElement("polygon", { points: "20 21 18 21 18 18.41 15.41 21 14 19.59 16.59 17 14 17 14 15 20 15 20 21" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("polygon", { points: "20 21 18 21 18 18.41 15.41 21 14 19.59 16.59 17 14 17 14 15 20 15 20 21" }),
                React.createElement("path", { d: "M5.5,12C2,12,0,12.7,0,14v8c0,1.3,2.83,2,5.5,2,2.67,0,5.5-.7,5.5-2V14C11,12.7,9,12,5.5,12Zm0,1c2.48529,0,4.5.67157,4.5,1.5S7.98529,16,5.5,16,1,15.32843,1,14.5,3.01471,13,5.5,13ZM1,20.23792V19.18219A10.95628,10.95628,0,0,0,5.5,20a10.95694,10.95694,0,0,0,4.5-.81775v1.08832A11.46834,11.46834,0,0,1,5.50006,21,11.63978,11.63978,0,0,1,1,20.23792Z" }),
                React.createElement("path", { d: "M18.5,0C15,0,13,.7,13,2v8c0,1.3,2.83,2,5.5,2,2.67,0,5.5-.7,5.5-2V2C24,.7,22,0,18.5,0Zm0,1c2.48529,0,4.5.67157,4.5,1.5S20.98529,4,18.5,4,14,3.32843,14,2.5,16.01471,1,18.5,1ZM14,8.23792V7.18219A10.95628,10.95628,0,0,0,18.5,8,10.95694,10.95694,0,0,0,23,7.18225V8.27057A11.46834,11.46834,0,0,1,18.50006,9,11.63978,11.63978,0,0,1,14,8.23792Z" }))));
}
;
export default EOS_DATABASE_MIGRATION;
