// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_CONTAINER({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M10,5a1.95767,1.95767,0,0,0,.79565,1.55981L5.50128,9.986H3.99689A1.99685,1.99685,0,0,0,2,11.98291v8.02295a1.9969,1.9969,0,0,0,1.99689,1.99689H19.99628A2.00372,2.00372,0,0,0,22,19.999V11.98291A1.99685,1.99685,0,0,0,20.00311,9.986H18.5119L13.21008,6.555A1.95745,1.95745,0,0,0,14,5a2.03035,2.03035,0,0,0-1-1.72119V2H12V4a1,1,0,1,1-1,1m.99481,1.97449L12,6.975l.0166-.00165L16.67206,9.986H7.34113ZM7,18a1,1,0,0,1-2,0V14a1,1,0,0,1,2,0Zm4,0a1,1,0,0,1-2,0V14a1,1,0,0,1,2,0Zm4,0a1,1,0,0,1-2,0V14a1,1,0,0,1,2,0Zm4,0a1,1,0,0,1-2,0V14a1,1,0,0,1,2,0Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20,10H18L13.21008,6.5A1.85387,1.85387,0,0,0,14,5a2.03073,2.03073,0,0,0-1-1.72137V2H12V4a1,1,0,1,1-1,1H10a1.84576,1.84576,0,0,0,.79565,1.5L6,10H4a2.00228,2.00228,0,0,0-2,2v8a2.00231,2.00231,0,0,0,2,2H20a1.99746,1.99746,0,0,0,2-2V12A2.00228,2.00228,0,0,0,20,10ZM12,7h0c.00568,0,4,3,4,3H8Zm8,13H4V12H20Z" }),
                React.createElement("path", { d: "M14,19a1,1,0,0,0,1-1V14a1,1,0,0,0-2,0v4A1,1,0,0,0,14,19Z" }),
                React.createElement("path", { d: "M18,19a1,1,0,0,0,1-1V14a1,1,0,0,0-2,0v4A1,1,0,0,0,18,19Z" }),
                React.createElement("path", { d: "M6,19a1,1,0,0,0,1-1V14a1,1,0,0,0-2,0v4A1,1,0,0,0,6,19Z" }),
                React.createElement("path", { d: "M10,19a1,1,0,0,0,1-1V14a1,1,0,0,0-2,0v4A1,1,0,0,0,10,19Z" }))));
}
;
export default EOS_CONTAINER;
