// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_CLUSTER_ROLE_BINDING({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M5,10h5v2H5ZM8.54047,22H4a2.00591,2.00591,0,0,1-2-2V6A2.00587,2.00587,0,0,1,4,4H8.18a2.98811,2.98811,0,0,1,5.64,0H18a2.00587,2.00587,0,0,1,2,2v6.09033A5.98867,5.98867,0,0,0,19,12H18V9H4v4H9.69043a6.03985,6.03985,0,0,0-1.87866,2H4v4H7.09033A5.97347,5.97347,0,0,0,8.54047,22ZM10,5a1,1,0,1,0,1-1A1.003,1.003,0,0,0,10,5Zm7,6a1,1,0,1,0-1,1A1,1,0,0,0,17,11ZM5,18H7a5.96023,5.96023,0,0,1,.35-2H5Zm9-7a1,1,0,1,0-1,1A1,1,0,0,0,14,11Zm1,9H13a2,2,0,0,1,0-4h2V14H13a4,4,0,0,0,0,8h2Zm8-2a4,4,0,0,1-4,4H17V20h2a2,2,0,0,0,0-4H17V14h2A4,4,0,0,1,23,18Zm-5,1H14V17h4Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M5,10h5v2H5ZM8.54047,22H4a2.00591,2.00591,0,0,1-2-2V6A2.00587,2.00587,0,0,1,4,4H8.18a2.98811,2.98811,0,0,1,5.64,0H18a2.00587,2.00587,0,0,1,2,2v6.09033A5.98867,5.98867,0,0,0,19,12H18V9H4v4H9.69043a6.03985,6.03985,0,0,0-1.87866,2H4v4H7.09033A5.97347,5.97347,0,0,0,8.54047,22ZM10,5a1,1,0,1,0,1-1A1.003,1.003,0,0,0,10,5Zm7,6a1,1,0,1,0-1,1A1,1,0,0,0,17,11ZM5,18H7a5.96023,5.96023,0,0,1,.35-2H5Zm9-7a1,1,0,1,0-1,1A1,1,0,0,0,14,11Zm1,9H13a2,2,0,0,1,0-4h2V14H13a4,4,0,0,0,0,8h2Zm8-2a4,4,0,0,1-4,4H17V20h2a2,2,0,0,0,0-4H17V14h2A4,4,0,0,1,23,18Zm-5,1H14V17h4Z" }))));
}
;
export default EOS_CLUSTER_ROLE_BINDING;
