// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_CLUSTER({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M1,13V23H23V13Zm12,6H4V17h9Zm3,0a1,1,0,1,1,1-1A1,1,0,0,1,16,19Zm3,0a1,1,0,1,1,1-1A1,1,0,0,1,19,19Z" }),
                React.createElement("path", { d: "M1,1V11H23V1ZM13,7H4V5h9Zm3,0a1,1,0,1,1,1-1A1,1,0,0,1,16,7Zm3,0a1,1,0,1,1,1-1A1,1,0,0,1,19,7Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M23,11H1V1H23ZM3,9H21V3H3Z" }),
                React.createElement("path", { d: "M23,23H1V13H23ZM3,21H21V15H3Z" }),
                React.createElement("rect", { x: "4", y: "5", width: "9", height: "2" }),
                React.createElement("circle", { cx: "16", cy: "6", r: "1" }),
                React.createElement("circle", { cx: "19", cy: "6", r: "1" }),
                React.createElement("rect", { x: "4", y: "17", width: "9", height: "2" }),
                React.createElement("circle", { cx: "16", cy: "18", r: "1" }),
                React.createElement("circle", { cx: "19", cy: "18", r: "1" }))));
}
;
export default EOS_CLUSTER;
