// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_CLOUD_COMPUTING({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M6,10v5H18V10Zm7,3H7V12h6Zm1.5,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,14.5,13Zm2,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,16.5,13Z" }),
                React.createElement("path", { d: "M6,17v5H18V17Zm7,3H7V19h6Zm1.5,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,14.5,20Zm2,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,16.5,20Z" }),
                React.createElement("path", { d: "M22.96527,8A5.34924,5.34924,0,0,0,19.35,6.04,7.49246,7.49246,0,0,0,5.35,4.04,5.9039,5.9039,0,0,0,4,4.36505,5.97992,5.97992,0,0,0,4,15.65033V8H20v7.89911A5.00336,5.00336,0,0,0,24,11,4.90837,4.90837,0,0,0,22.96527,8Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20,6.14746A4.97289,4.97289,0,0,0,19.35,6.04,7.49246,7.49246,0,0,0,5.35,4.04,5.9039,5.9039,0,0,0,4,4.36505,5.97992,5.97992,0,0,0,4,15.65033V13.44556A3.97628,3.97628,0,0,1,4,6.5448,3.92951,3.92951,0,0,1,5.56,6.03L6.63,5.92l.5-.95A5.48711,5.48711,0,0,1,17.39,6.43l.3,1.5,1.53.11a2.91321,2.91321,0,0,1,.78.17108,2.96258,2.96258,0,0,1,0,5.6037v2.08435a4.9717,4.9717,0,0,0,0-9.75165Z" }),
                React.createElement("path", { d: "M6,10v5H18V10Zm7,3H7V12h6Zm1.5,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,14.5,13Zm2,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,16.5,13Z" }),
                React.createElement("path", { d: "M6,17v5H18V17Zm7,3H7V19h6Zm1.5,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,14.5,20Zm2,0a.5.5,0,1,1,.5-.5A.5.5,0,0,1,16.5,20Z" }))));
}
;
export default EOS_CLOUD_COMPUTING;
