// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_CLEANUP({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20,15.0163H15v-.01361a1.98389,1.98389,0,0,0-1.97809-1.978h-.03473L16.844,2.63208l-1.732-.64282-4.09546,11.0354h-.03845A1.98389,1.98389,0,0,0,9,15.00269v.01361H4v2H20Z" }),
                React.createElement("polygon", { points: "20 18.018 4 18.018 2 22 4 22 20 22 22 22 20 18.018" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M20,15.0163H15v-.01361a1.98389,1.98389,0,0,0-1.97809-1.978h-.03473L16.844,2.63208l-1.732-.64282-4.09546,11.0354h-.03845A1.98389,1.98389,0,0,0,9,15.00269v.01361H4v2H20Z" }),
                React.createElement("polygon", { points: "20 18.018 4 18.018 2 22 4 22 20 22 22 22 20 18.018" }))));
}
;
export default EOS_CLEANUP;
