// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_AUTOINSTALLATION({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M10.42383,16.5h5.12109v-6h4.44757a9.0044,9.0044,0,1,0-6.4588,9.10986ZM8.51642,10.97357a2.5,2.5,0,1,1,2.5,2.5A2.5,2.5,0,0,1,8.51642,10.97357Z" }),
                React.createElement("polygon", { points: "22.045 18 19.045 18 19.045 12 17.045 12 17.045 18 14.045 18 18.045 22 22.045 18" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M10.42383,16.5h5.12109v-6h4.44757a9.0044,9.0044,0,1,0-6.4588,9.10986ZM8.51642,10.97357a2.5,2.5,0,1,1,2.5,2.5A2.5,2.5,0,0,1,8.51642,10.97357Z" }),
                React.createElement("polygon", { points: "22.045 18 19.045 18 19.045 12 17.045 12 17.045 18 14.045 18 18.045 22 22.045 18" }))));
}
;
export default EOS_AUTOINSTALLATION;
