// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_APPLICATION_WINDOW({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M21,1H3A2,2,0,0,0,1,3l.00012,2H23V3A2,2,0,0,0,21,1ZM4.00006,4.00092a1,1,0,1,1,1-1A1,1,0,0,1,4.00006,4.00092ZM7.00012,4a1,1,0,1,1,1-1A1.003,1.003,0,0,1,7.00012,4Z" }),
                React.createElement("path", { d: "M23,9.99939V6H1V20a1.99946,1.99946,0,0,0,2,2H21a1.99946,1.99946,0,0,0,2-2Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M1,3V5H23V3a2.00118,2.00118,0,0,0-2-2H3A2.00118,2.00118,0,0,0,1,3ZM4,4a.98705.98705,0,0,1-.99254-.99159A1.00144,1.00144,0,0,1,4,2,1.01282,1.01282,0,0,1,5.00585,3.00841.99847.99847,0,0,1,4,4ZM7,4A1,1,0,1,1,8,3,1.00355,1.00355,0,0,1,7,4Z" }),
                React.createElement("path", { d: "M1,6V20a2.0006,2.0006,0,0,0,2,2H21a2.00068,2.00068,0,0,0,2-2V6ZM21,20H3V8H21Z" }))));
}
;
export default EOS_APPLICATION_WINDOW;
