// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_APPLICATION({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M1.00008,3,1,5H23V3a2,2,0,0,0-2-2H3A1.99993,1.99993,0,0,0,1.00008,3ZM4,4.00092a1,1,0,1,1,1-1A1,1,0,0,1,4,4.00092ZM7.00008,4a1,1,0,1,1,1-1A1.003,1.003,0,0,1,7.00008,4Z" }),
                React.createElement("path", { d: "M1,6V20a1.99946,1.99946,0,0,0,2,2H21a1.99943,1.99943,0,0,0,2-2V6Zm8.1,9.3,1.3,1.3-.7.7L9,18,7,16,5,14l2-2,2-2,.7.7.7.7L9.1,12.7,7.8,14ZM17,16l-2,2-.7-.7-.7-.7,1.3-1.3L16.2,14l-1.3-1.3-1.3-1.3.7-.7L15,10l2,2,2,2Z" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M1,3V5H23V3a2.00118,2.00118,0,0,0-2-2H3A2.00118,2.00118,0,0,0,1,3ZM4.00669,4.00758a.99917.99917,0,1,1,.99916-.99917A.99919.99919,0,0,1,4.00669,4.00758Zm2.99756-.00092a.99917.99917,0,1,1,.99917-.99916A1.00212,1.00212,0,0,1,7.00425,4.00666Z" }),
                React.createElement("path", { d: "M1,6V20a2.0006,2.0006,0,0,0,2,2H21a2.00068,2.00068,0,0,0,2-2V6ZM21,20H3V8H21Z" }),
                React.createElement("polygon", { points: "9 18 9.7 17.3 10.4 16.6 9.1 15.3 7.8 14 9.1 12.7 10.4 11.4 9.7 10.7 9 10 7 12 5 14 7 16 9 18" }),
                React.createElement("polygon", { points: "13.6 16.6 14.3 17.3 15 18 17 16 19 14 17 12 15 10 14.3 10.7 13.6 11.4 14.9 12.7 16.2 14 14.9 15.3 13.6 16.6" }),
                React.createElement("polygon", { points: "9 18 9.7 17.3 10.4 16.6 9.1 15.3 7.8 14 9.1 12.7 10.4 11.4 9.7 10.7 9 10 7 12 5 14 7 16 9 18" }),
                React.createElement("polygon", { points: "13.6 16.6 14.3 17.3 15 18 17 16 19 14 17 12 15 10 14.3 10.7 13.6 11.4 14.9 12.7 16.2 14 14.9 15.3 13.6 16.6" }))));
}
;
export default EOS_APPLICATION;
