// GENERATED BY ./scripts/iconScript.ts
import * as React from 'react';
import { valuesMap } from '../helper';
import { flipFunction } from '../flipFunction';
function EOS_API({ size = "m", color = "black", rotate = 0, horizontalFlip = false, verticalFlip = false, theme = "filled", className = "" }) {
    const sizeString = size.toString();
    if (Object.keys(valuesMap).includes(sizeString)) {
        size = valuesMap[size];
    }
    const { scaleX, scaleY, translateX, translateY } = flipFunction({ horizontalFlip, verticalFlip });
    return (React.createElement(React.Fragment, null,
        (theme === "filled") &&
            // Filled version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("rect", { x: "13.26", y: "10.5", width: "2", height: "1" }),
                React.createElement("path", { d: "M20,4H4A2,2,0,0,0,2,6V18a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V6A2,2,0,0,0,20,4ZM8.4,15,8,13.77H6.06L5.62,15H4L6.2,9H7.82L10,15Zm8.36-3.5a1.47,1.47,0,0,1-1.5,1.5h-2v2h-1.5V9h3.5a1.47,1.47,0,0,1,1.5,1.5ZM20,15h-1.5V9H20Z" }),
                React.createElement("polygon", { points: "6.43 12.77 7.59 12.77 7.01 11.18 6.43 12.77" })),
        (theme === "outlined") &&
            // Outlined version
            React.createElement("svg", { className: className, "data-testid": "eos-svg-component", transform: `rotate(${rotate}) translate(${translateX}, ${translateY}) scale(${scaleX}, ${scaleY})`, fill: color, width: size, height: size, xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24" },
                React.createElement("path", { d: "M7.31206,9H5.68794L3.5,15H5.10651l.4469-1.22559H7.44653L7.89349,15H9.5Zm-1.394,3.77441L6.5,11.17865l.58192,1.59576Z" }),
                React.createElement("path", { d: "M14.74432,9h-3.5v6h1.5V13h2a1.47321,1.47321,0,0,0,1.5-1.5v-1A1.47325,1.47325,0,0,0,14.74432,9Zm0,2.5h-2v-1h2Z" }),
                React.createElement("rect", { x: "18", y: "9", width: "1.5", height: "6" }),
                React.createElement("path", { d: "M22,6V18H2V6H22m0-2H2A2,2,0,0,0,0,6V18a2,2,0,0,0,2,2H22a2,2,0,0,0,2-2V6a2,2,0,0,0-2-2Z" }))));
}
;
export default EOS_API;
