import { CompatibleString } from 'storybook/internal/types';
import { StorybookConfigWebpack, BuilderOptions, TypescriptOptions } from '@storybook/builder-webpack5';
import { StorybookConfig as StorybookConfig$1, ReactOptions, TypescriptOptions as TypescriptOptions$1 } from '@storybook/preset-react-webpack';

type FrameworkName = CompatibleString<'@storybook/react-webpack5'>;
type BuilderName = CompatibleString<'@storybook/builder-webpack5'>;
type FrameworkOptions = ReactOptions & {
    builder?: BuilderOptions;
};
type StorybookConfigFramework = {
    framework: FrameworkName | {
        name: FrameworkName;
        options: FrameworkOptions;
    };
    core?: StorybookConfig$1['core'] & {
        builder?: BuilderName | {
            name: BuilderName;
            options: BuilderOptions;
        };
    };
    typescript?: Partial<TypescriptOptions & TypescriptOptions$1> & StorybookConfig$1['typescript'];
};
/** The interface for Storybook configuration in `main.ts` files. */
type StorybookConfig = Omit<StorybookConfig$1, keyof StorybookConfigWebpack | keyof StorybookConfigFramework> & StorybookConfigWebpack & StorybookConfigFramework;

declare function defineMain(config: StorybookConfig): StorybookConfig;

export { defineMain };
