import CJS_COMPAT_NODE_URL_t0rx9m6ohc from 'node:url';
import CJS_COMPAT_NODE_PATH_t0rx9m6ohc from 'node:path';
import CJS_COMPAT_NODE_MODULE_t0rx9m6ohc from "node:module";

var __filename = CJS_COMPAT_NODE_URL_t0rx9m6ohc.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_t0rx9m6ohc.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_t0rx9m6ohc.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });

// src/preset.ts
import { readFile } from "node:fs/promises";
import { isAbsolute as isAbsolute2, join as join2 } from "node:path";

// ../../core/src/shared/utils/module.ts
import { fileURLToPath, pathToFileURL } from "node:url";

// ../../node_modules/exsolve/dist/index.mjs
import assert from "node:assert";
import v8 from "node:v8";
import { format, inspect } from "node:util";
var own$1 = {}.hasOwnProperty;
var classRegExp = /^([A-Z][a-z\d]*)+$/;
var kTypes = /* @__PURE__ */ new Set([
  "string",
  "function",
  "number",
  "object",
  "Function",
  "Object",
  "boolean",
  "bigint",
  "symbol"
]);
var messages = /* @__PURE__ */ new Map();
var nodeInternalPrefix = "__node_internal_";
var userStackTraceLimit;
function formatList(array, type = "and") {
  return array.length < 3 ? array.join(` ${type} `) : `${array.slice(0, -1).join(", ")}, ${type} ${array.at(-1)}`;
}
__name(formatList, "formatList");
function createError(sym, value, constructor) {
  messages.set(sym, value);
  return makeNodeErrorWithCode(constructor, sym);
}
__name(createError, "createError");
function makeNodeErrorWithCode(Base, key) {
  return /* @__PURE__ */ __name(function NodeError(...parameters) {
    const limit = Error.stackTraceLimit;
    if (isErrorStackTraceLimitWritable()) Error.stackTraceLimit = 0;
    const error = new Base();
    if (isErrorStackTraceLimitWritable()) Error.stackTraceLimit = limit;
    const message = getMessage(key, parameters, error);
    Object.defineProperties(error, {
      message: {
        value: message,
        enumerable: false,
        writable: true,
        configurable: true
      },
      toString: {
        value() {
          return `${this.name} [${key}]: ${this.message}`;
        },
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
    captureLargerStackTrace(error);
    error.code = key;
    return error;
  }, "NodeError");
}
__name(makeNodeErrorWithCode, "makeNodeErrorWithCode");
function isErrorStackTraceLimitWritable() {
  try {
    if (v8.startupSnapshot.isBuildingSnapshot()) return false;
  } catch {
  }
  const desc = Object.getOwnPropertyDescriptor(Error, "stackTraceLimit");
  if (desc === void 0) return Object.isExtensible(Error);
  return own$1.call(desc, "writable") && desc.writable !== void 0 ? desc.writable : desc.set !== void 0;
}
__name(isErrorStackTraceLimitWritable, "isErrorStackTraceLimitWritable");
function hideStackFrames(wrappedFunction) {
  const hidden = nodeInternalPrefix + wrappedFunction.name;
  Object.defineProperty(wrappedFunction, "name", { value: hidden });
  return wrappedFunction;
}
__name(hideStackFrames, "hideStackFrames");
var captureLargerStackTrace = hideStackFrames(function(error) {
  const stackTraceLimitIsWritable = isErrorStackTraceLimitWritable();
  if (stackTraceLimitIsWritable) {
    userStackTraceLimit = Error.stackTraceLimit;
    Error.stackTraceLimit = Number.POSITIVE_INFINITY;
  }
  Error.captureStackTrace(error);
  if (stackTraceLimitIsWritable) Error.stackTraceLimit = userStackTraceLimit;
  return error;
});
function getMessage(key, parameters, self) {
  const message = messages.get(key);
  assert.ok(message !== void 0, "expected `message` to be found");
  if (typeof message === "function") {
    assert.ok(message.length <= parameters.length, `Code: ${key}; The provided arguments length (${parameters.length}) does not match the required ones (${message.length}).`);
    return Reflect.apply(message, self, parameters);
  }
  const regex = /%[dfijoOs]/g;
  let expectedLength = 0;
  while (regex.exec(message) !== null) expectedLength++;
  assert.ok(expectedLength === parameters.length, `Code: ${key}; The provided arguments length (${parameters.length}) does not match the required ones (${expectedLength}).`);
  if (parameters.length === 0) return message;
  parameters.unshift(message);
  return Reflect.apply(format, null, parameters);
}
__name(getMessage, "getMessage");
function determineSpecificType(value) {
  if (value === null || value === void 0) return String(value);
  if (typeof value === "function" && value.name) return `function ${value.name}`;
  if (typeof value === "object") {
    if (value.constructor && value.constructor.name) return `an instance of ${value.constructor.name}`;
    return `${inspect(value, { depth: -1 })}`;
  }
  let inspected = inspect(value, { colors: false });
  if (inspected.length > 28) inspected = `${inspected.slice(0, 25)}...`;
  return `type ${typeof value} (${inspected})`;
}
__name(determineSpecificType, "determineSpecificType");
var ERR_INVALID_ARG_TYPE = createError("ERR_INVALID_ARG_TYPE", (name, expected, actual) => {
  assert.ok(typeof name === "string", "'name' must be a string");
  if (!Array.isArray(expected)) expected = [expected];
  let message = "The ";
  if (name.endsWith(" argument")) message += `${name} `;
  else {
    const type = name.includes(".") ? "property" : "argument";
    message += `"${name}" ${type} `;
  }
  message += "must be ";
  const types = [];
  const instances = [];
  const other = [];
  for (const value of expected) {
    assert.ok(typeof value === "string", "All expected entries have to be of type string");
    if (kTypes.has(value)) types.push(value.toLowerCase());
    else if (classRegExp.exec(value) === null) {
      assert.ok(value !== "object", 'The value "object" should be written as "Object"');
      other.push(value);
    } else instances.push(value);
  }
  if (instances.length > 0) {
    const pos = types.indexOf("object");
    if (pos !== -1) {
      types.slice(pos, 1);
      instances.push("Object");
    }
  }
  if (types.length > 0) {
    message += `${types.length > 1 ? "one of type" : "of type"} ${formatList(types, "or")}`;
    if (instances.length > 0 || other.length > 0) message += " or ";
  }
  if (instances.length > 0) {
    message += `an instance of ${formatList(instances, "or")}`;
    if (other.length > 0) message += " or ";
  }
  if (other.length > 0) if (other.length > 1) message += `one of ${formatList(other, "or")}`;
  else {
    if (other[0]?.toLowerCase() !== other[0]) message += "an ";
    message += `${other[0]}`;
  }
  message += `. Received ${determineSpecificType(actual)}`;
  return message;
}, TypeError);
var ERR_INVALID_MODULE_SPECIFIER = createError(
  "ERR_INVALID_MODULE_SPECIFIER",
  /**
  * @param {string} request
  * @param {string} reason
  * @param {string} [base]
  */
  (request, reason, base) => {
    return `Invalid module "${request}" ${reason}${base ? ` imported from ${base}` : ""}`;
  },
  TypeError
);
var ERR_INVALID_PACKAGE_CONFIG = createError("ERR_INVALID_PACKAGE_CONFIG", (path$1, base, message) => {
  return `Invalid package config ${path$1}${base ? ` while importing ${base}` : ""}${message ? `. ${message}` : ""}`;
}, Error);
var ERR_INVALID_PACKAGE_TARGET = createError("ERR_INVALID_PACKAGE_TARGET", (packagePath, key, target, isImport = false, base) => {
  const relatedError = typeof target === "string" && !isImport && target.length > 0 && !target.startsWith("./");
  if (key === ".") {
    assert.ok(isImport === false);
    return `Invalid "exports" main target ${JSON.stringify(target)} defined in the package config ${packagePath}package.json${base ? ` imported from ${base}` : ""}${relatedError ? '; targets must start with "./"' : ""}`;
  }
  return `Invalid "${isImport ? "imports" : "exports"}" target ${JSON.stringify(target)} defined for '${key}' in the package config ${packagePath}package.json${base ? ` imported from ${base}` : ""}${relatedError ? '; targets must start with "./"' : ""}`;
}, Error);
var ERR_MODULE_NOT_FOUND = createError("ERR_MODULE_NOT_FOUND", (path$1, base, exactUrl = false) => {
  return `Cannot find ${exactUrl ? "module" : "package"} '${path$1}' imported from ${base}`;
}, Error);
var ERR_NETWORK_IMPORT_DISALLOWED = createError("ERR_NETWORK_IMPORT_DISALLOWED", "import of '%s' by %s is not supported: %s", Error);
var ERR_PACKAGE_IMPORT_NOT_DEFINED = createError("ERR_PACKAGE_IMPORT_NOT_DEFINED", (specifier, packagePath, base) => {
  return `Package import specifier "${specifier}" is not defined${packagePath ? ` in package ${packagePath || ""}package.json` : ""} imported from ${base}`;
}, TypeError);
var ERR_PACKAGE_PATH_NOT_EXPORTED = createError(
  "ERR_PACKAGE_PATH_NOT_EXPORTED",
  /**
  * @param {string} packagePath
  * @param {string} subpath
  * @param {string} [base]
  */
  (packagePath, subpath, base) => {
    if (subpath === ".") return `No "exports" main defined in ${packagePath}package.json${base ? ` imported from ${base}` : ""}`;
    return `Package subpath '${subpath}' is not defined by "exports" in ${packagePath}package.json${base ? ` imported from ${base}` : ""}`;
  },
  Error
);
var ERR_UNSUPPORTED_DIR_IMPORT = createError("ERR_UNSUPPORTED_DIR_IMPORT", "Directory import '%s' is not supported resolving ES modules imported from %s", Error);
var ERR_UNSUPPORTED_RESOLVE_REQUEST = createError("ERR_UNSUPPORTED_RESOLVE_REQUEST", 'Failed to resolve module specifier "%s" from "%s": Invalid relative URL or base scheme is not hierarchical.', TypeError);
var ERR_UNKNOWN_FILE_EXTENSION = createError("ERR_UNKNOWN_FILE_EXTENSION", (extension, path$1) => {
  return `Unknown file extension "${extension}" for ${path$1}`;
}, TypeError);
var ERR_INVALID_ARG_VALUE = createError("ERR_INVALID_ARG_VALUE", (name, value, reason = "is invalid") => {
  let inspected = inspect(value);
  if (inspected.length > 128) inspected = `${inspected.slice(0, 128)}...`;
  return `The ${name.includes(".") ? "property" : "argument"} '${name}' ${reason}. Received ${inspected}`;
}, TypeError);
var hasOwnProperty$1 = {}.hasOwnProperty;
var hasOwnProperty = {}.hasOwnProperty;
var RegExpPrototypeSymbolReplace = RegExp.prototype[Symbol.replace];
var own = {}.hasOwnProperty;
var isWindows = (() => process.platform === "win32")();
var globalCache = (() => globalThis["__EXSOLVE_CACHE__"] ||= /* @__PURE__ */ new Map())();

// ../../node_modules/pathe/dist/shared/pathe.ff20891b.mjs
var _DRIVE_LETTER_START_RE = /^[A-Za-z]:\//;
function normalizeWindowsPath(input = "") {
  if (!input) {
    return input;
  }
  return input.replace(/\\/g, "/").replace(_DRIVE_LETTER_START_RE, (r) => r.toUpperCase());
}
__name(normalizeWindowsPath, "normalizeWindowsPath");
var _UNC_REGEX = /^[/\\]{2}/;
var _IS_ABSOLUTE_RE = /^[/\\](?![/\\])|^[/\\]{2}(?!\.)|^[A-Za-z]:[/\\]/;
var _DRIVE_LETTER_RE = /^[A-Za-z]:$/;
var normalize = /* @__PURE__ */ __name(function(path2) {
  if (path2.length === 0) {
    return ".";
  }
  path2 = normalizeWindowsPath(path2);
  const isUNCPath = path2.match(_UNC_REGEX);
  const isPathAbsolute = isAbsolute(path2);
  const trailingSeparator = path2[path2.length - 1] === "/";
  path2 = normalizeString(path2, !isPathAbsolute);
  if (path2.length === 0) {
    if (isPathAbsolute) {
      return "/";
    }
    return trailingSeparator ? "./" : ".";
  }
  if (trailingSeparator) {
    path2 += "/";
  }
  if (_DRIVE_LETTER_RE.test(path2)) {
    path2 += "/";
  }
  if (isUNCPath) {
    if (!isPathAbsolute) {
      return `//./${path2}`;
    }
    return `//${path2}`;
  }
  return isPathAbsolute && !isAbsolute(path2) ? `/${path2}` : path2;
}, "normalize");
var join = /* @__PURE__ */ __name(function(...arguments_) {
  if (arguments_.length === 0) {
    return ".";
  }
  let joined;
  for (const argument of arguments_) {
    if (argument && argument.length > 0) {
      if (joined === void 0) {
        joined = argument;
      } else {
        joined += `/${argument}`;
      }
    }
  }
  if (joined === void 0) {
    return ".";
  }
  return normalize(joined.replace(/\/\/+/g, "/"));
}, "join");
function normalizeString(path2, allowAboveRoot) {
  let res = "";
  let lastSegmentLength = 0;
  let lastSlash = -1;
  let dots = 0;
  let char = null;
  for (let index = 0; index <= path2.length; ++index) {
    if (index < path2.length) {
      char = path2[index];
    } else if (char === "/") {
      break;
    } else {
      char = "/";
    }
    if (char === "/") {
      if (lastSlash === index - 1 || dots === 1) ;
      else if (dots === 2) {
        if (res.length < 2 || lastSegmentLength !== 2 || res[res.length - 1] !== "." || res[res.length - 2] !== ".") {
          if (res.length > 2) {
            const lastSlashIndex = res.lastIndexOf("/");
            if (lastSlashIndex === -1) {
              res = "";
              lastSegmentLength = 0;
            } else {
              res = res.slice(0, lastSlashIndex);
              lastSegmentLength = res.length - 1 - res.lastIndexOf("/");
            }
            lastSlash = index;
            dots = 0;
            continue;
          } else if (res.length > 0) {
            res = "";
            lastSegmentLength = 0;
            lastSlash = index;
            dots = 0;
            continue;
          }
        }
        if (allowAboveRoot) {
          res += res.length > 0 ? "/.." : "..";
          lastSegmentLength = 2;
        }
      } else {
        if (res.length > 0) {
          res += `/${path2.slice(lastSlash + 1, index)}`;
        } else {
          res = path2.slice(lastSlash + 1, index);
        }
        lastSegmentLength = index - lastSlash - 1;
      }
      lastSlash = index;
      dots = 0;
    } else if (char === "." && dots !== -1) {
      ++dots;
    } else {
      dots = -1;
    }
  }
  return res;
}
__name(normalizeString, "normalizeString");
var isAbsolute = /* @__PURE__ */ __name(function(p) {
  return _IS_ABSOLUTE_RE.test(p);
}, "isAbsolute");
var dirname = /* @__PURE__ */ __name(function(p) {
  const segments = normalizeWindowsPath(p).replace(/\/$/, "").split("/").slice(0, -1);
  if (segments.length === 1 && _DRIVE_LETTER_RE.test(segments[0])) {
    segments[0] += "/";
  }
  return segments.join("/") || (isAbsolute(p) ? "/" : ".");
}, "dirname");

// ../../core/src/shared/utils/module.ts
var importMetaResolve = /* @__PURE__ */ __name((...args) => {
  if (typeof import.meta.resolve !== "function" && process.env.VITEST === "true") {
    console.warn(
      "importMetaResolve from within Storybook is being used in a Vitest test, but it shouldn't be. Please report this at https://github.com/storybookjs/storybook/issues/new?template=bug_report.yml"
    );
    return pathToFileURL(args[0]).href;
  }
  return import.meta.resolve(...args);
}, "importMetaResolve");
var resolvePackageDir = /* @__PURE__ */ __name((pkg, parent) => {
  return dirname(fileURLToPath(importMetaResolve(join(pkg, "package.json"), parent)));
}, "resolvePackageDir");

// src/preset.ts
var getIsReactVersion18or19 = /* @__PURE__ */ __name(async (options) => {
  const { legacyRootApi } = await options.presets.apply("frameworkOptions") || {};
  if (legacyRootApi) {
    return false;
  }
  const resolvedReact = await options.presets.apply("resolvedReact", {});
  const reactDom = resolvedReact.reactDom || resolvePackageDir("react-dom");
  if (!isAbsolute2(reactDom)) {
    return false;
  }
  const { version } = JSON.parse(await readFile(join2(reactDom, "package.json"), "utf-8"));
  return version.startsWith("18") || version.startsWith("19") || version.startsWith("0.0.0");
}, "getIsReactVersion18or19");
var webpackFinal = /* @__PURE__ */ __name(async (config, options) => {
  const isReactVersion18 = await getIsReactVersion18or19(options);
  if (isReactVersion18) {
    return config;
  }
  return {
    ...config,
    resolve: {
      ...config.resolve,
      alias: {
        ...config.resolve?.alias,
        "@storybook/react-dom-shim": "@storybook/react-dom-shim/react-16"
      }
    }
  };
}, "webpackFinal");
var viteFinal = /* @__PURE__ */ __name(async (config, options) => {
  const isReactVersion18 = await getIsReactVersion18or19(options);
  if (isReactVersion18) {
    return config;
  }
  const alias = Array.isArray(config.resolve?.alias) ? config.resolve.alias.concat({
    find: /^@storybook\/react-dom-shim$/,
    replacement: "@storybook/react-dom-shim/react-16"
  }) : {
    ...config.resolve?.alias,
    "@storybook/react-dom-shim": "@storybook/react-dom-shim/react-16"
  };
  return {
    ...config,
    resolve: {
      ...config.resolve,
      alias
    }
  };
}, "viteFinal");
export {
  viteFinal,
  webpackFinal
};
