import CJS_COMPAT_NODE_URL_arx1yd5uj45 from 'node:url';
import CJS_COMPAT_NODE_PATH_arx1yd5uj45 from 'node:path';
import CJS_COMPAT_NODE_MODULE_arx1yd5uj45 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_arx1yd5uj45.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_arx1yd5uj45.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_arx1yd5uj45.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  __name
} from "../_node-chunks/chunk-2F2ZLGDM.js";

// src/loaders/react-docgen-loader.ts
import { getProjectRoot } from "storybook/internal/common";
import { logger } from "storybook/internal/node-logger";

// ../../node_modules/empathic/find.mjs
import { join as join2 } from "node:path";
import { existsSync, statSync } from "node:fs";

// ../../node_modules/empathic/walk.mjs
import { dirname } from "node:path";

// ../../node_modules/empathic/resolve.mjs
import { isAbsolute, join, resolve } from "node:path";
function absolute(input, root) {
  return isAbsolute(input) ? input : resolve(root || ".", input);
}
__name(absolute, "absolute");

// ../../node_modules/empathic/walk.mjs
function up(base, options) {
  let { last, cwd } = options || {};
  let tmp = absolute(base, cwd);
  let root = absolute(last || "/", cwd);
  let prev, arr = [];
  while (prev !== root) {
    arr.push(tmp);
    tmp = dirname(prev = tmp);
    if (tmp === prev) break;
  }
  return arr;
}
__name(up, "up");

// ../../node_modules/empathic/find.mjs
function up2(name, options) {
  let dir, tmp;
  let start = options && options.cwd || "";
  for (dir of up(start, options)) {
    tmp = join2(dir, name);
    if (existsSync(tmp)) return tmp;
  }
}
__name(up2, "up");

// src/loaders/react-docgen-loader.ts
import MagicString from "magic-string";
import {
  ERROR_CODES,
  builtinHandlers as docgenHandlers,
  builtinResolvers as docgenResolver,
  makeFsImporter,
  parse,
  utils
} from "react-docgen";
import * as TsconfigPaths from "tsconfig-paths";

// src/loaders/docgen-resolver.ts
import { extname } from "node:path";
import resolve2 from "resolve";
var ReactDocgenResolveError = class extends Error {
  constructor(filename) {
    super(`'${filename}' was ignored by react-docgen.`);
    // the magic string that react-docgen uses to check if a module is ignored
    this.code = "MODULE_NOT_FOUND";
  }
  static {
    __name(this, "ReactDocgenResolveError");
  }
};
var RESOLVE_EXTENSIONS = [
  ".js",
  ".cts",
  // These were originally not in the code, I added them
  ".mts",
  // These were originally not in the code, I added them
  ".ctsx",
  // These were originally not in the code, I added them
  ".mtsx",
  // These were originally not in the code, I added them
  ".ts",
  ".tsx",
  ".mjs",
  ".cjs",
  ".mts",
  ".cts",
  ".jsx"
];
function defaultLookupModule(filename, basedir) {
  const resolveOptions = {
    basedir,
    extensions: RESOLVE_EXTENSIONS,
    // we do not need to check core modules as we cannot import them anyway
    includeCoreModules: false
  };
  try {
    return resolve2.sync(filename, resolveOptions);
  } catch (error) {
    const ext = extname(filename);
    let newFilename;
    switch (ext) {
      case ".js":
      case ".mjs":
      case ".cjs":
        newFilename = `${filename.slice(0, -2)}ts`;
        break;
      case ".jsx":
        newFilename = `${filename.slice(0, -3)}tsx`;
        break;
      default:
        throw error;
    }
    return resolve2.sync(newFilename, {
      ...resolveOptions,
      // we already know that there is an extension at this point, so no need to check other extensions
      extensions: []
    });
  }
}
__name(defaultLookupModule, "defaultLookupModule");

// src/loaders/react-docgen-loader.ts
var { getNameOrValue, isReactForwardRefCall } = utils;
var actualNameHandler = /* @__PURE__ */ __name(function actualNameHandler2(documentation, componentDefinition) {
  documentation.set("definedInFile", componentDefinition.hub.file.opts.filename);
  if ((componentDefinition.isClassDeclaration() || componentDefinition.isFunctionDeclaration()) && componentDefinition.has("id")) {
    documentation.set(
      "actualName",
      getNameOrValue(componentDefinition.get("id"))
    );
  } else if (componentDefinition.isArrowFunctionExpression() || componentDefinition.isFunctionExpression() || isReactForwardRefCall(componentDefinition)) {
    let currentPath = componentDefinition;
    while (currentPath.parentPath) {
      if (currentPath.parentPath.isVariableDeclarator()) {
        documentation.set("actualName", getNameOrValue(currentPath.parentPath.get("id")));
        return;
      }
      if (currentPath.parentPath.isAssignmentExpression()) {
        const leftPath = currentPath.parentPath.get("left");
        if (leftPath.isIdentifier() || leftPath.isLiteral()) {
          documentation.set("actualName", getNameOrValue(leftPath));
          return;
        }
      }
      currentPath = currentPath.parentPath;
    }
    documentation.set("actualName", "");
  }
}, "actualNameHandler");
var defaultHandlers = Object.values(docgenHandlers).map((handler) => handler);
var defaultResolver = new docgenResolver.FindExportedDefinitionsResolver();
var handlers = [...defaultHandlers, actualNameHandler];
var tsconfigPathsInitialized = false;
var matchPath;
async function reactDocgenLoader(source, map) {
  const callback = this.async();
  const options = this.getOptions() || {};
  const { debug = false } = options;
  if (!tsconfigPathsInitialized) {
    const tsconfigPath = up2("tsconfig.json", { cwd: process.cwd(), last: getProjectRoot() });
    const tsconfig = TsconfigPaths.loadConfig(tsconfigPath);
    if (tsconfig.resultType === "success") {
      logger.info("Using tsconfig paths for react-docgen");
      matchPath = TsconfigPaths.createMatchPath(tsconfig.absoluteBaseUrl, tsconfig.paths, [
        "browser",
        "module",
        "main"
      ]);
    }
    tsconfigPathsInitialized = true;
  }
  try {
    const docgenResults = parse(source, {
      filename: this.resourcePath,
      resolver: defaultResolver,
      handlers,
      importer: getReactDocgenImporter(matchPath),
      babelOptions: {
        babelrc: false,
        configFile: false
      }
    });
    const magicString = new MagicString(source);
    docgenResults.forEach((info) => {
      const { actualName, definedInFile, ...docgenInfo } = info;
      if (actualName && definedInFile == this.resourcePath) {
        const docNode = JSON.stringify(docgenInfo);
        magicString.append(`;${actualName}.__docgenInfo=${docNode}`);
      }
    });
    callback(
      null,
      magicString.toString(),
      map ?? magicString.generateMap({
        hires: true,
        source: this.resourcePath,
        includeContent: true
      })
    );
  } catch (error) {
    if (error.code === ERROR_CODES.MISSING_DEFINITION) {
      callback(null, source);
    } else {
      if (!debug) {
        logger.warn(
          `Failed to parse ${this.resourcePath} with react-docgen. Rerun Storybook with --loglevel=debug to get more info.`
        );
      } else {
        logger.warn(
          `Failed to parse ${this.resourcePath} with react-docgen. Please use the below error message and the content of the file which causes the error to report the issue to the maintainers of react-docgen. https://github.com/reactjs/react-docgen`
        );
        logger.error(error);
      }
      callback(null, source);
    }
  }
}
__name(reactDocgenLoader, "reactDocgenLoader");
function getReactDocgenImporter(matchingPath) {
  return makeFsImporter((filename, basedir) => {
    const mappedFilenameByPaths = (() => {
      if (matchingPath) {
        const match = matchingPath(filename);
        return match || filename;
      } else {
        return filename;
      }
    })();
    const result = defaultLookupModule(mappedFilenameByPaths, basedir);
    if (RESOLVE_EXTENSIONS.find((ext) => result.endsWith(ext))) {
      return result;
    }
    throw new ReactDocgenResolveError(filename);
  });
}
__name(getReactDocgenImporter, "getReactDocgenImporter");
export {
  reactDocgenLoader as default,
  getReactDocgenImporter
};
