import CJS_COMPAT_NODE_URL_arx1yd5uj45 from 'node:url';
import CJS_COMPAT_NODE_PATH_arx1yd5uj45 from 'node:path';
import CJS_COMPAT_NODE_MODULE_arx1yd5uj45 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_arx1yd5uj45.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_arx1yd5uj45.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_arx1yd5uj45.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  __name
} from "./_node-chunks/chunk-2F2ZLGDM.js";

// src/framework-preset-cra.ts
import { logger as logger2 } from "storybook/internal/node-logger";

// src/cra-config.ts
import { existsSync, readFileSync, realpathSync } from "node:fs";
import { join } from "node:path";
import { pathToFileURL } from "node:url";
import { logger } from "storybook/internal/node-logger";
import semver from "semver";
var appDirectory = realpathSync(process.cwd());
var reactScriptsPath;
function getReactScriptsPath({ noCache } = {}) {
  if (reactScriptsPath && !noCache) {
    return reactScriptsPath;
  }
  let reactScriptsScriptPath = realpathSync(join(appDirectory, "/node_modules/.bin/react-scripts"));
  try {
    const pathIsNotResolved = /node_modules[\\/]\.bin[\\/]react-scripts/i.test(
      reactScriptsScriptPath
    );
    if (pathIsNotResolved) {
      const content = readFileSync(reactScriptsScriptPath, "utf8");
      const packagePathMatch = content.match(
        /"\$basedir[\\/]([^\s]+?[\\/]bin[\\/]react-scripts\.js")/i
      );
      if (packagePathMatch && packagePathMatch.length > 1) {
        reactScriptsScriptPath = join(appDirectory, "/node_modules/.bin/", packagePathMatch[1]);
      }
    }
  } catch (e) {
    logger.warn(`Error occurred during react-scripts package path resolving: ${e}`);
  }
  reactScriptsPath = join(reactScriptsScriptPath, "../..");
  const scriptsPkgJson = join(reactScriptsPath, "package.json");
  if (!existsSync(scriptsPkgJson)) {
    reactScriptsPath = "react-scripts";
  }
  return reactScriptsPath;
}
__name(getReactScriptsPath, "getReactScriptsPath");
async function isReactScriptsInstalled(minimumVersion = "2.0.0") {
  try {
    const { default: reactScriptsJson } = await import(pathToFileURL(join(getReactScriptsPath(), "package.json")).href, {
      with: { type: "json" }
    });
    return !semver.gtr(minimumVersion, reactScriptsJson.version);
  } catch (e) {
    return false;
  }
}
__name(isReactScriptsInstalled, "isReactScriptsInstalled");

// src/framework-preset-cra.ts
var checkForNewPreset = /* @__PURE__ */ __name((presetsList) => {
  const hasNewPreset = presetsList.some((preset) => {
    const presetName = typeof preset === "string" ? preset : preset.name;
    return /@storybook(\/|\\)preset-create-react-app/.test(presetName);
  });
  if (!hasNewPreset) {
    logger2.warn("Storybook support for Create React App is now a separate preset.");
    logger2.warn(
      "To use the new preset, install `@storybook/preset-create-react-app` and add it to the list of `addons` in your `.storybook/main.js` config file."
    );
    logger2.warn("The built-in preset has been disabled in Storybook 6.0.");
  }
}, "checkForNewPreset");
var webpackFinal = /* @__PURE__ */ __name(async (config, { presetsList }) => {
  if (await isReactScriptsInstalled()) {
    if (presetsList) {
      checkForNewPreset(presetsList);
    }
  }
  config.module?.rules?.push(
    ...[
      {
        test: /\.m?js$/,
        type: "javascript/auto"
      },
      {
        test: /\.m?js$/,
        resolve: {
          fullySpecified: false
        }
      }
    ]
  );
  return config;
}, "webpackFinal");
export {
  webpackFinal
};
