import CJS_COMPAT_NODE_URL_9h7gzp711au from 'node:url';
import CJS_COMPAT_NODE_PATH_9h7gzp711au from 'node:path';
import CJS_COMPAT_NODE_MODULE_9h7gzp711au from "node:module";

var __filename = CJS_COMPAT_NODE_URL_9h7gzp711au.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_9h7gzp711au.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_9h7gzp711au.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });

// src/load-custom-webpack-config.ts
import { resolve } from "node:path";
import { serverRequire } from "storybook/internal/common";
var webpackConfigs = ["webpack.config", "webpackfile"];
var loadCustomWebpackConfig = /* @__PURE__ */ __name(async (configDir) => serverRequire(webpackConfigs.map((configName) => resolve(configDir, configName))), "loadCustomWebpackConfig");

// src/check-webpack-version.ts
import { logger } from "storybook/internal/node-logger";
import { dedent } from "ts-dedent";
var checkWebpackVersion = /* @__PURE__ */ __name((webpack, specifier, caption) => {
  if (!webpack.version) {
    logger.info("Skipping webpack version check, no version available");
    return;
  }
  if (webpack.version !== specifier) {
    logger.warn(dedent`
      Unexpected webpack version in ${caption}:
      - Received '${webpack.version}'
      - Expected '${specifier}'

      If you're using Webpack 5 in SB6.2 and upgrading, consider: https://github.com/storybookjs/storybook/blob/next/MIGRATION.md#webpack-5-manager-build

      For more info about Webpack 5 support: https://gist.github.com/shilman/8856ea1786dcd247139b47b270912324#troubleshooting
    `);
  }
}, "checkWebpackVersion");

// src/merge-webpack-config.ts
function mergePluginsField(defaultPlugins = [], customPlugins = []) {
  return [...defaultPlugins, ...customPlugins];
}
__name(mergePluginsField, "mergePluginsField");
function mergeRulesField(defaultRules = [], customRules = []) {
  return [...defaultRules, ...customRules];
}
__name(mergeRulesField, "mergeRulesField");
function mergeExtensionsField({ extensions: defaultExtensions = [] }, { extensions: customExtensions = [] }) {
  return [...defaultExtensions, ...customExtensions];
}
__name(mergeExtensionsField, "mergeExtensionsField");
function mergeAliasField({ alias: defaultAlias = {} }, { alias: customAlias = {} }) {
  return {
    ...defaultAlias,
    ...customAlias
  };
}
__name(mergeAliasField, "mergeAliasField");
function mergeModuleField(a, b) {
  return {
    ...a,
    ...b,
    rules: mergeRulesField(a.rules || [], b.rules || [])
  };
}
__name(mergeModuleField, "mergeModuleField");
function mergeResolveField({ resolve: defaultResolve = {} }, { resolve: customResolve = {} }) {
  return {
    ...defaultResolve,
    ...customResolve,
    alias: mergeAliasField(defaultResolve, customResolve),
    extensions: mergeExtensionsField(defaultResolve, customResolve)
  };
}
__name(mergeResolveField, "mergeResolveField");
function mergeOptimizationField({ optimization: defaultOptimization = {} }, { optimization: customOptimization = {} }) {
  return {
    ...defaultOptimization,
    ...customOptimization
  };
}
__name(mergeOptimizationField, "mergeOptimizationField");
function mergeConfigs(config, customConfig) {
  return {
    // We'll always load our configurations after the custom config.
    // So, we'll always load the stuff we need.
    ...customConfig,
    ...config,
    devtool: customConfig.devtool || config.devtool,
    plugins: mergePluginsField(config.plugins, customConfig.plugins),
    module: mergeModuleField(config.module || {}, customConfig.module || {}),
    resolve: mergeResolveField(config, customConfig),
    optimization: mergeOptimizationField(config, customConfig)
  };
}
__name(mergeConfigs, "mergeConfigs");

// src/to-importFn.ts
import { globToRegexp } from "storybook/internal/common";
import { dedent as dedent2 } from "ts-dedent";

// src/importPipeline.ts
function importPipeline() {
  let importGate = Promise.resolve();
  return async (importFn) => {
    await importGate;
    const moduleExportsPromise = importFn();
    importGate = importGate.then(async () => {
      await moduleExportsPromise;
    });
    return moduleExportsPromise;
  };
}
__name(importPipeline, "importPipeline");

// src/to-importFn.ts
function adjustRegexToExcludeNodeModules(originalRegex) {
  const originalRegexString = originalRegex.source;
  const startsWithCaret = originalRegexString.startsWith("^");
  const excludeNodeModulesPattern = startsWithCaret ? "(?!.*node_modules)" : "^(?!.*node_modules)";
  const adjustedRegexString = startsWithCaret ? `^${excludeNodeModulesPattern}${originalRegexString.substring(1)}` : excludeNodeModulesPattern + originalRegexString;
  return new RegExp(adjustedRegexString);
}
__name(adjustRegexToExcludeNodeModules, "adjustRegexToExcludeNodeModules");
function webpackIncludeRegexp(specifier) {
  const { directory, files } = specifier;
  const directoryWithoutLeadingDots = directory.replace(/^(\.+\/)+/, "/");
  const webpackIncludeGlob = [".", ".."].includes(directory) ? files : `${directoryWithoutLeadingDots}/${files}`;
  const webpackIncludeRegexpWithCaret = webpackIncludeGlob.includes("node_modules") ? globToRegexp(webpackIncludeGlob) : adjustRegexToExcludeNodeModules(globToRegexp(webpackIncludeGlob));
  return new RegExp(webpackIncludeRegexpWithCaret.source.replace(/^\^/, ""));
}
__name(webpackIncludeRegexp, "webpackIncludeRegexp");
function toImportFnPart(specifier) {
  const { directory, importPathMatcher } = specifier;
  return dedent2`
      async (path) => {
        if (!${importPathMatcher}.exec(path)) {
          return;
        }

        const pathRemainder = path.substring(${directory.length + 1});
        return import(
          /* webpackChunkName: "[request]" */
          /* webpackInclude: ${webpackIncludeRegexp(specifier)} */
          '${directory}/' + pathRemainder
        );
      }

  `;
}
__name(toImportFnPart, "toImportFnPart");
function toImportFn(stories, { needPipelinedImport } = {}) {
  let pipelinedImport = `const pipeline = (x) => x();`;
  if (needPipelinedImport) {
    pipelinedImport = `
      const importPipeline = ${importPipeline};
      const pipeline = importPipeline();
    `;
  }
  return dedent2`
    ${pipelinedImport}

    const importers = [
      ${stories.map(toImportFnPart).join(",\n")}
    ];

    export async function importFn(path) {
      for (let i = 0; i < importers.length; i++) {
        const moduleExports = await pipeline(() => importers[i](path));
        if (moduleExports) {
          return moduleExports;
        }
      }
    }
  `;
}
__name(toImportFn, "toImportFn");

// src/to-require-context.ts
import { globToRegexp as globToRegexp2 } from "storybook/internal/common";
var toRequireContext = /* @__PURE__ */ __name((specifier) => {
  const { directory, files } = specifier;
  const match = globToRegexp2(`./${files}`);
  return {
    path: directory,
    recursive: files.includes("**") || files.split("/").length > 1,
    match
  };
}, "toRequireContext");
var toRequireContextString = /* @__PURE__ */ __name((specifier) => {
  const { path: p, recursive: r, match: m } = toRequireContext(specifier);
  const result = `require.context('${p}', ${r}, ${m})`;
  return result;
}, "toRequireContextString");
export {
  checkWebpackVersion,
  loadCustomWebpackConfig,
  mergeConfigs,
  toImportFn,
  toImportFnPart,
  toRequireContext,
  toRequireContextString,
  webpackIncludeRegexp
};
