import CJS_COMPAT_NODE_URL_d53zm9kb3a7 from 'node:url';
import CJS_COMPAT_NODE_PATH_d53zm9kb3a7 from 'node:path';
import CJS_COMPAT_NODE_MODULE_d53zm9kb3a7 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_d53zm9kb3a7.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_d53zm9kb3a7.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_d53zm9kb3a7.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  __name
} from "../_node-chunks/chunk-OZRNAYHU.js";

// src/presets/custom-webpack-preset.ts
import { logger as logger2 } from "storybook/internal/node-logger";
import { loadCustomWebpackConfig } from "@storybook/core-webpack";
import webpackModule from "webpack";

// src/preview/base-webpack.config.ts
import { fileURLToPath } from "node:url";
import { logger } from "storybook/internal/node-logger";
async function createDefaultWebpackConfig(storybookBaseConfig, options) {
  if (options.presetsList?.some(
    (preset) => /@storybook(\/|\\)preset-create-react-app/.test(
      typeof preset === "string" ? preset : preset.name
    )
  )) {
    return storybookBaseConfig;
  }
  const hasPostcssAddon = options.presetsList?.some(
    (preset) => /@storybook(\/|\\)addon-postcss/.test(typeof preset === "string" ? preset : preset.name)
  );
  let cssLoaders = {};
  if (!hasPostcssAddon) {
    logger.info(`=> Using implicit CSS loaders`);
    cssLoaders = {
      test: /\.css$/,
      sideEffects: true,
      use: [
        // TODO: Decide if we want to keep style-loader & css-loader in core
        // Trying to apply style-loader or css-loader to files that already have been
        // processed by them causes webpack to crash, so no one else can add similar
        // loader configurations to the `.css` extension.
        fileURLToPath(import.meta.resolve("style-loader")),
        {
          loader: fileURLToPath(import.meta.resolve("css-loader")),
          options: {
            importLoaders: 1
          }
        }
      ]
    };
  }
  const isProd = storybookBaseConfig.mode !== "development";
  return {
    ...storybookBaseConfig,
    module: {
      ...storybookBaseConfig.module,
      rules: [
        ...storybookBaseConfig.module?.rules || [],
        cssLoaders,
        {
          test: /\.(svg|ico|jpg|jpeg|png|apng|gif|eot|otf|webp|ttf|woff|woff2|cur|ani|pdf)(\?.*)?$/,
          type: "asset/resource",
          generator: {
            filename: isProd ? "static/media/[name].[contenthash:8][ext]" : "static/media/[path][name][ext]"
          }
        },
        {
          test: /\.(mp4|webm|wav|mp3|m4a|aac|oga)(\?.*)?$/,
          type: "asset",
          parser: {
            dataUrlCondition: {
              maxSize: 1e4
            }
          },
          generator: {
            filename: isProd ? "static/media/[name].[contenthash:8][ext]" : "static/media/[path][name][ext]"
          }
        },
        {
          // any imports from './some-file.md?raw' will be imported as raw string
          // see https://webpack.js.org/guides/asset-modules/#replacing-inline-loader-syntax
          // used to support import raw .md files in MDX
          resourceQuery: /raw/,
          type: "asset/source"
        }
      ]
    },
    resolve: {
      ...storybookBaseConfig.resolve,
      // see https://github.com/webpack/webpack/issues/17692#issuecomment-1866272674 for the docs
      conditionNames: [
        ...storybookBaseConfig.resolve?.conditionNames ?? [],
        "storybook",
        "stories",
        "test",
        "..."
      ],
      fallback: {
        crypto: false,
        assert: false,
        ...storybookBaseConfig.resolve?.fallback
      }
    }
  };
}
__name(createDefaultWebpackConfig, "createDefaultWebpackConfig");

// src/presets/custom-webpack-preset.ts
var swc = /* @__PURE__ */ __name((config) => {
  return {
    ...config,
    env: {
      ...config?.env ?? {},
      targets: config?.env?.targets ?? {
        chrome: 100,
        safari: 15,
        firefox: 91
      },
      // Transpiles the broken syntax to the closest non-broken modern syntax.
      // E.g. it won't transpile parameter destructuring in Safari
      // which would break how we detect if the mount context property is used in the play function.
      bugfixes: config?.env?.bugfixes ?? true
    }
  };
}, "swc");
async function webpack(config, options) {
  const { configDir, configType, presets } = options;
  const coreOptions = await presets.apply("core");
  let defaultConfig = config;
  if (!coreOptions?.disableWebpackDefaults) {
    defaultConfig = await createDefaultWebpackConfig(config, options);
  }
  const finalDefaultConfig = await presets.apply("webpackFinal", defaultConfig, options);
  const customConfig = await loadCustomWebpackConfig(configDir);
  if (typeof customConfig === "function") {
    logger2.info("=> Loading custom Webpack config (full-control mode).");
    return customConfig({ config: finalDefaultConfig, mode: configType });
  }
  logger2.info("=> Using default Webpack5 setup");
  return finalDefaultConfig;
}
__name(webpack, "webpack");
var webpackInstance = /* @__PURE__ */ __name(async () => webpackModule, "webpackInstance");
var webpackVersion = /* @__PURE__ */ __name(async () => "5", "webpackVersion");
export {
  swc,
  webpack,
  webpackInstance,
  webpackVersion
};
