import CJS_COMPAT_NODE_URL_d53zm9kb3a7 from 'node:url';
import CJS_COMPAT_NODE_PATH_d53zm9kb3a7 from 'node:path';
import CJS_COMPAT_NODE_MODULE_d53zm9kb3a7 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_d53zm9kb3a7.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_d53zm9kb3a7.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_d53zm9kb3a7.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  __name
} from "../_node-chunks/chunk-OZRNAYHU.js";

// src/loaders/export-order-loader.ts
import assert from "node:assert";
import { init as initCjsParser, parse as parseCjs } from "cjs-module-lexer";
import { parse as parseEs } from "es-module-lexer";
import MagicString from "magic-string";
async function loader(source, map, meta) {
  const callback = this.async();
  try {
    const magicString = new MagicString(source);
    if (!source.includes("__namedExportsOrder")) {
      try {
        const parseResult = await parseEs(source);
        const namedExportsOrder = (parseResult[1] || []).map((e) => source.substring(e.s, e.e)).filter((e) => e !== "default");
        assert(
          namedExportsOrder.length > 0,
          "No named exports found. Very likely that this is not a ES module."
        );
        magicString.append(
          `;export const __namedExportsOrder = ${JSON.stringify(namedExportsOrder)};`
        );
      } catch {
        await initCjsParser();
        const namedExportsOrder = (parseCjs(source).exports || []).filter(
          (e) => e !== "default" && e !== "__esModule"
        );
        assert(
          namedExportsOrder.length > 0,
          "No named exports found. Very likely that this is not a CJS module."
        );
        magicString.append(
          `;module.exports.__namedExportsOrder = ${JSON.stringify(namedExportsOrder)};`
        );
      }
    }
    return callback(null, magicString.toString(), map, meta);
  } catch (err) {
    return callback(null, source, map, meta);
  }
}
__name(loader, "loader");
export {
  loader as default
};
