import CJS_COMPAT_NODE_URL_d53zm9kb3a7 from 'node:url';
import CJS_COMPAT_NODE_PATH_d53zm9kb3a7 from 'node:path';
import CJS_COMPAT_NODE_MODULE_d53zm9kb3a7 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_d53zm9kb3a7.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_d53zm9kb3a7.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_d53zm9kb3a7.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  getVirtualModules
} from "./_node-chunks/chunk-TBFYSXCT.js";
import {
  __commonJS,
  __name,
  __require,
  __toESM
} from "./_node-chunks/chunk-OZRNAYHU.js";

// ../../node_modules/pretty-hrtime/index.js
var require_pretty_hrtime = __commonJS({
  "../../node_modules/pretty-hrtime/index.js"(exports, module) {
    "use strict";
    var minimalDesc = ["h", "min", "s", "ms", "\u03BCs", "ns"];
    var verboseDesc = ["hour", "minute", "second", "millisecond", "microsecond", "nanosecond"];
    var convert = [60 * 60, 60, 1, 1e6, 1e3, 1];
    module.exports = function(source, opts) {
      var verbose, precise, i, spot, sourceAtStep, valAtStep, decimals, strAtStep, results, totalSeconds;
      verbose = false;
      precise = false;
      if (opts) {
        verbose = opts.verbose || false;
        precise = opts.precise || false;
      }
      if (!Array.isArray(source) || source.length !== 2) {
        return "";
      }
      if (typeof source[0] !== "number" || typeof source[1] !== "number") {
        return "";
      }
      if (source[1] < 0) {
        totalSeconds = source[0] + source[1] / 1e9;
        source[0] = parseInt(totalSeconds);
        source[1] = parseFloat((totalSeconds % 1).toPrecision(9)) * 1e9;
      }
      results = "";
      for (i = 0; i < 6; i++) {
        spot = i < 3 ? 0 : 1;
        sourceAtStep = source[spot];
        if (i !== 3 && i !== 0) {
          sourceAtStep = sourceAtStep % convert[i - 1];
        }
        if (i === 2) {
          sourceAtStep += source[1] / 1e9;
        }
        valAtStep = sourceAtStep / convert[i];
        if (valAtStep >= 1) {
          if (verbose) {
            valAtStep = Math.floor(valAtStep);
          }
          if (!precise) {
            decimals = valAtStep >= 10 ? 0 : 2;
            strAtStep = valAtStep.toFixed(decimals);
          } else {
            strAtStep = valAtStep.toString();
          }
          if (strAtStep.indexOf(".") > -1 && strAtStep[strAtStep.length - 1] === "0") {
            strAtStep = strAtStep.replace(/\.?0+$/, "");
          }
          if (results) {
            results += " ";
          }
          results += strAtStep;
          if (verbose) {
            results += " " + verboseDesc[i];
            if (strAtStep !== "1") {
              results += "s";
            }
          } else {
            results += " " + minimalDesc[i];
          }
          if (!verbose) {
            break;
          }
        }
      }
      return results;
    };
  }
});

// ../../node_modules/totalist/sync/index.js
var require_sync = __commonJS({
  "../../node_modules/totalist/sync/index.js"(exports) {
    var { join: join2, resolve: resolve2 } = __require("path");
    var { readdirSync, statSync } = __require("fs");
    function totalist(dir, callback, pre = "") {
      dir = resolve2(".", dir);
      let arr = readdirSync(dir);
      let i = 0, abs, stats;
      for (; i < arr.length; i++) {
        abs = join2(dir, arr[i]);
        stats = statSync(abs);
        stats.isDirectory() ? totalist(abs, callback, join2(pre, arr[i])) : callback(join2(pre, arr[i]), abs, stats);
      }
    }
    __name(totalist, "totalist");
    exports.totalist = totalist;
  }
});

// ../../node_modules/@polka/url/build.js
var require_build = __commonJS({
  "../../node_modules/@polka/url/build.js"(exports) {
    var qs = __require("querystring");
    function parse2(req) {
      let raw = req.url;
      if (raw == null) return;
      let prev = req._parsedUrl;
      if (prev && prev.raw === raw) return prev;
      let pathname = raw, search = "", query, hash;
      if (raw.length > 1) {
        let idx = raw.indexOf("#", 1);
        if (idx !== -1) {
          hash = raw.substring(idx);
          pathname = raw.substring(0, idx);
        }
        idx = pathname.indexOf("?", 1);
        if (idx !== -1) {
          search = pathname.substring(idx);
          pathname = pathname.substring(0, idx);
          if (search.length > 1) {
            query = qs.parse(search.substring(1));
          }
        }
      }
      return req._parsedUrl = { pathname, search, query, hash, raw };
    }
    __name(parse2, "parse");
    exports.parse = parse2;
  }
});

// ../../node_modules/mrmime/index.js
var require_mrmime = __commonJS({
  "../../node_modules/mrmime/index.js"(exports) {
    var mimes = {
      "3g2": "video/3gpp2",
      "3gp": "video/3gpp",
      "3gpp": "video/3gpp",
      "3mf": "model/3mf",
      "aac": "audio/aac",
      "ac": "application/pkix-attr-cert",
      "adp": "audio/adpcm",
      "adts": "audio/aac",
      "ai": "application/postscript",
      "aml": "application/automationml-aml+xml",
      "amlx": "application/automationml-amlx+zip",
      "amr": "audio/amr",
      "apng": "image/apng",
      "appcache": "text/cache-manifest",
      "appinstaller": "application/appinstaller",
      "appx": "application/appx",
      "appxbundle": "application/appxbundle",
      "asc": "application/pgp-keys",
      "atom": "application/atom+xml",
      "atomcat": "application/atomcat+xml",
      "atomdeleted": "application/atomdeleted+xml",
      "atomsvc": "application/atomsvc+xml",
      "au": "audio/basic",
      "avci": "image/avci",
      "avcs": "image/avcs",
      "avif": "image/avif",
      "aw": "application/applixware",
      "bdoc": "application/bdoc",
      "bin": "application/octet-stream",
      "bmp": "image/bmp",
      "bpk": "application/octet-stream",
      "btf": "image/prs.btif",
      "btif": "image/prs.btif",
      "buffer": "application/octet-stream",
      "ccxml": "application/ccxml+xml",
      "cdfx": "application/cdfx+xml",
      "cdmia": "application/cdmi-capability",
      "cdmic": "application/cdmi-container",
      "cdmid": "application/cdmi-domain",
      "cdmio": "application/cdmi-object",
      "cdmiq": "application/cdmi-queue",
      "cer": "application/pkix-cert",
      "cgm": "image/cgm",
      "cjs": "application/node",
      "class": "application/java-vm",
      "coffee": "text/coffeescript",
      "conf": "text/plain",
      "cpl": "application/cpl+xml",
      "cpt": "application/mac-compactpro",
      "crl": "application/pkix-crl",
      "css": "text/css",
      "csv": "text/csv",
      "cu": "application/cu-seeme",
      "cwl": "application/cwl",
      "cww": "application/prs.cww",
      "davmount": "application/davmount+xml",
      "dbk": "application/docbook+xml",
      "deb": "application/octet-stream",
      "def": "text/plain",
      "deploy": "application/octet-stream",
      "dib": "image/bmp",
      "disposition-notification": "message/disposition-notification",
      "dist": "application/octet-stream",
      "distz": "application/octet-stream",
      "dll": "application/octet-stream",
      "dmg": "application/octet-stream",
      "dms": "application/octet-stream",
      "doc": "application/msword",
      "dot": "application/msword",
      "dpx": "image/dpx",
      "drle": "image/dicom-rle",
      "dsc": "text/prs.lines.tag",
      "dssc": "application/dssc+der",
      "dtd": "application/xml-dtd",
      "dump": "application/octet-stream",
      "dwd": "application/atsc-dwd+xml",
      "ear": "application/java-archive",
      "ecma": "application/ecmascript",
      "elc": "application/octet-stream",
      "emf": "image/emf",
      "eml": "message/rfc822",
      "emma": "application/emma+xml",
      "emotionml": "application/emotionml+xml",
      "eps": "application/postscript",
      "epub": "application/epub+zip",
      "exe": "application/octet-stream",
      "exi": "application/exi",
      "exp": "application/express",
      "exr": "image/aces",
      "ez": "application/andrew-inset",
      "fdf": "application/fdf",
      "fdt": "application/fdt+xml",
      "fits": "image/fits",
      "g3": "image/g3fax",
      "gbr": "application/rpki-ghostbusters",
      "geojson": "application/geo+json",
      "gif": "image/gif",
      "glb": "model/gltf-binary",
      "gltf": "model/gltf+json",
      "gml": "application/gml+xml",
      "gpx": "application/gpx+xml",
      "gram": "application/srgs",
      "grxml": "application/srgs+xml",
      "gxf": "application/gxf",
      "gz": "application/gzip",
      "h261": "video/h261",
      "h263": "video/h263",
      "h264": "video/h264",
      "heic": "image/heic",
      "heics": "image/heic-sequence",
      "heif": "image/heif",
      "heifs": "image/heif-sequence",
      "hej2": "image/hej2k",
      "held": "application/atsc-held+xml",
      "hjson": "application/hjson",
      "hlp": "application/winhlp",
      "hqx": "application/mac-binhex40",
      "hsj2": "image/hsj2",
      "htm": "text/html",
      "html": "text/html",
      "ics": "text/calendar",
      "ief": "image/ief",
      "ifb": "text/calendar",
      "iges": "model/iges",
      "igs": "model/iges",
      "img": "application/octet-stream",
      "in": "text/plain",
      "ini": "text/plain",
      "ink": "application/inkml+xml",
      "inkml": "application/inkml+xml",
      "ipfix": "application/ipfix",
      "iso": "application/octet-stream",
      "its": "application/its+xml",
      "jade": "text/jade",
      "jar": "application/java-archive",
      "jhc": "image/jphc",
      "jls": "image/jls",
      "jp2": "image/jp2",
      "jpe": "image/jpeg",
      "jpeg": "image/jpeg",
      "jpf": "image/jpx",
      "jpg": "image/jpeg",
      "jpg2": "image/jp2",
      "jpgm": "image/jpm",
      "jpgv": "video/jpeg",
      "jph": "image/jph",
      "jpm": "image/jpm",
      "jpx": "image/jpx",
      "js": "text/javascript",
      "json": "application/json",
      "json5": "application/json5",
      "jsonld": "application/ld+json",
      "jsonml": "application/jsonml+json",
      "jsx": "text/jsx",
      "jt": "model/jt",
      "jxl": "image/jxl",
      "jxr": "image/jxr",
      "jxra": "image/jxra",
      "jxrs": "image/jxrs",
      "jxs": "image/jxs",
      "jxsc": "image/jxsc",
      "jxsi": "image/jxsi",
      "jxss": "image/jxss",
      "kar": "audio/midi",
      "ktx": "image/ktx",
      "ktx2": "image/ktx2",
      "less": "text/less",
      "lgr": "application/lgr+xml",
      "list": "text/plain",
      "litcoffee": "text/coffeescript",
      "log": "text/plain",
      "lostxml": "application/lost+xml",
      "lrf": "application/octet-stream",
      "m1v": "video/mpeg",
      "m21": "application/mp21",
      "m2a": "audio/mpeg",
      "m2t": "video/mp2t",
      "m2ts": "video/mp2t",
      "m2v": "video/mpeg",
      "m3a": "audio/mpeg",
      "m4a": "audio/mp4",
      "m4p": "application/mp4",
      "m4s": "video/iso.segment",
      "ma": "application/mathematica",
      "mads": "application/mads+xml",
      "maei": "application/mmt-aei+xml",
      "man": "text/troff",
      "manifest": "text/cache-manifest",
      "map": "application/json",
      "mar": "application/octet-stream",
      "markdown": "text/markdown",
      "mathml": "application/mathml+xml",
      "mb": "application/mathematica",
      "mbox": "application/mbox",
      "md": "text/markdown",
      "mdx": "text/mdx",
      "me": "text/troff",
      "mesh": "model/mesh",
      "meta4": "application/metalink4+xml",
      "metalink": "application/metalink+xml",
      "mets": "application/mets+xml",
      "mft": "application/rpki-manifest",
      "mid": "audio/midi",
      "midi": "audio/midi",
      "mime": "message/rfc822",
      "mj2": "video/mj2",
      "mjp2": "video/mj2",
      "mjs": "text/javascript",
      "mml": "text/mathml",
      "mods": "application/mods+xml",
      "mov": "video/quicktime",
      "mp2": "audio/mpeg",
      "mp21": "application/mp21",
      "mp2a": "audio/mpeg",
      "mp3": "audio/mpeg",
      "mp4": "video/mp4",
      "mp4a": "audio/mp4",
      "mp4s": "application/mp4",
      "mp4v": "video/mp4",
      "mpd": "application/dash+xml",
      "mpe": "video/mpeg",
      "mpeg": "video/mpeg",
      "mpf": "application/media-policy-dataset+xml",
      "mpg": "video/mpeg",
      "mpg4": "video/mp4",
      "mpga": "audio/mpeg",
      "mpp": "application/dash-patch+xml",
      "mrc": "application/marc",
      "mrcx": "application/marcxml+xml",
      "ms": "text/troff",
      "mscml": "application/mediaservercontrol+xml",
      "msh": "model/mesh",
      "msi": "application/octet-stream",
      "msix": "application/msix",
      "msixbundle": "application/msixbundle",
      "msm": "application/octet-stream",
      "msp": "application/octet-stream",
      "mtl": "model/mtl",
      "mts": "video/mp2t",
      "musd": "application/mmt-usd+xml",
      "mxf": "application/mxf",
      "mxmf": "audio/mobile-xmf",
      "mxml": "application/xv+xml",
      "n3": "text/n3",
      "nb": "application/mathematica",
      "nq": "application/n-quads",
      "nt": "application/n-triples",
      "obj": "model/obj",
      "oda": "application/oda",
      "oga": "audio/ogg",
      "ogg": "audio/ogg",
      "ogv": "video/ogg",
      "ogx": "application/ogg",
      "omdoc": "application/omdoc+xml",
      "onepkg": "application/onenote",
      "onetmp": "application/onenote",
      "onetoc": "application/onenote",
      "onetoc2": "application/onenote",
      "opf": "application/oebps-package+xml",
      "opus": "audio/ogg",
      "otf": "font/otf",
      "owl": "application/rdf+xml",
      "oxps": "application/oxps",
      "p10": "application/pkcs10",
      "p7c": "application/pkcs7-mime",
      "p7m": "application/pkcs7-mime",
      "p7s": "application/pkcs7-signature",
      "p8": "application/pkcs8",
      "pdf": "application/pdf",
      "pfr": "application/font-tdpfr",
      "pgp": "application/pgp-encrypted",
      "pkg": "application/octet-stream",
      "pki": "application/pkixcmp",
      "pkipath": "application/pkix-pkipath",
      "pls": "application/pls+xml",
      "png": "image/png",
      "prc": "model/prc",
      "prf": "application/pics-rules",
      "provx": "application/provenance+xml",
      "ps": "application/postscript",
      "pskcxml": "application/pskc+xml",
      "pti": "image/prs.pti",
      "qt": "video/quicktime",
      "raml": "application/raml+yaml",
      "rapd": "application/route-apd+xml",
      "rdf": "application/rdf+xml",
      "relo": "application/p2p-overlay+xml",
      "rif": "application/reginfo+xml",
      "rl": "application/resource-lists+xml",
      "rld": "application/resource-lists-diff+xml",
      "rmi": "audio/midi",
      "rnc": "application/relax-ng-compact-syntax",
      "rng": "application/xml",
      "roa": "application/rpki-roa",
      "roff": "text/troff",
      "rq": "application/sparql-query",
      "rs": "application/rls-services+xml",
      "rsat": "application/atsc-rsat+xml",
      "rsd": "application/rsd+xml",
      "rsheet": "application/urc-ressheet+xml",
      "rss": "application/rss+xml",
      "rtf": "text/rtf",
      "rtx": "text/richtext",
      "rusd": "application/route-usd+xml",
      "s3m": "audio/s3m",
      "sbml": "application/sbml+xml",
      "scq": "application/scvp-cv-request",
      "scs": "application/scvp-cv-response",
      "sdp": "application/sdp",
      "senmlx": "application/senml+xml",
      "sensmlx": "application/sensml+xml",
      "ser": "application/java-serialized-object",
      "setpay": "application/set-payment-initiation",
      "setreg": "application/set-registration-initiation",
      "sgi": "image/sgi",
      "sgm": "text/sgml",
      "sgml": "text/sgml",
      "shex": "text/shex",
      "shf": "application/shf+xml",
      "shtml": "text/html",
      "sieve": "application/sieve",
      "sig": "application/pgp-signature",
      "sil": "audio/silk",
      "silo": "model/mesh",
      "siv": "application/sieve",
      "slim": "text/slim",
      "slm": "text/slim",
      "sls": "application/route-s-tsid+xml",
      "smi": "application/smil+xml",
      "smil": "application/smil+xml",
      "snd": "audio/basic",
      "so": "application/octet-stream",
      "spdx": "text/spdx",
      "spp": "application/scvp-vp-response",
      "spq": "application/scvp-vp-request",
      "spx": "audio/ogg",
      "sql": "application/sql",
      "sru": "application/sru+xml",
      "srx": "application/sparql-results+xml",
      "ssdl": "application/ssdl+xml",
      "ssml": "application/ssml+xml",
      "stk": "application/hyperstudio",
      "stl": "model/stl",
      "stpx": "model/step+xml",
      "stpxz": "model/step-xml+zip",
      "stpz": "model/step+zip",
      "styl": "text/stylus",
      "stylus": "text/stylus",
      "svg": "image/svg+xml",
      "svgz": "image/svg+xml",
      "swidtag": "application/swid+xml",
      "t": "text/troff",
      "t38": "image/t38",
      "td": "application/urc-targetdesc+xml",
      "tei": "application/tei+xml",
      "teicorpus": "application/tei+xml",
      "text": "text/plain",
      "tfi": "application/thraud+xml",
      "tfx": "image/tiff-fx",
      "tif": "image/tiff",
      "tiff": "image/tiff",
      "toml": "application/toml",
      "tr": "text/troff",
      "trig": "application/trig",
      "ts": "video/mp2t",
      "tsd": "application/timestamped-data",
      "tsv": "text/tab-separated-values",
      "ttc": "font/collection",
      "ttf": "font/ttf",
      "ttl": "text/turtle",
      "ttml": "application/ttml+xml",
      "txt": "text/plain",
      "u3d": "model/u3d",
      "u8dsn": "message/global-delivery-status",
      "u8hdr": "message/global-headers",
      "u8mdn": "message/global-disposition-notification",
      "u8msg": "message/global",
      "ubj": "application/ubjson",
      "uri": "text/uri-list",
      "uris": "text/uri-list",
      "urls": "text/uri-list",
      "vcard": "text/vcard",
      "vrml": "model/vrml",
      "vtt": "text/vtt",
      "vxml": "application/voicexml+xml",
      "war": "application/java-archive",
      "wasm": "application/wasm",
      "wav": "audio/wav",
      "weba": "audio/webm",
      "webm": "video/webm",
      "webmanifest": "application/manifest+json",
      "webp": "image/webp",
      "wgsl": "text/wgsl",
      "wgt": "application/widget",
      "wif": "application/watcherinfo+xml",
      "wmf": "image/wmf",
      "woff": "font/woff",
      "woff2": "font/woff2",
      "wrl": "model/vrml",
      "wsdl": "application/wsdl+xml",
      "wspolicy": "application/wspolicy+xml",
      "x3d": "model/x3d+xml",
      "x3db": "model/x3d+fastinfoset",
      "x3dbz": "model/x3d+binary",
      "x3dv": "model/x3d-vrml",
      "x3dvz": "model/x3d+vrml",
      "x3dz": "model/x3d+xml",
      "xaml": "application/xaml+xml",
      "xav": "application/xcap-att+xml",
      "xca": "application/xcap-caps+xml",
      "xcs": "application/calendar+xml",
      "xdf": "application/xcap-diff+xml",
      "xdssc": "application/dssc+xml",
      "xel": "application/xcap-el+xml",
      "xenc": "application/xenc+xml",
      "xer": "application/patch-ops-error+xml",
      "xfdf": "application/xfdf",
      "xht": "application/xhtml+xml",
      "xhtml": "application/xhtml+xml",
      "xhvml": "application/xv+xml",
      "xlf": "application/xliff+xml",
      "xm": "audio/xm",
      "xml": "text/xml",
      "xns": "application/xcap-ns+xml",
      "xop": "application/xop+xml",
      "xpl": "application/xproc+xml",
      "xsd": "application/xml",
      "xsf": "application/prs.xsf+xml",
      "xsl": "application/xml",
      "xslt": "application/xml",
      "xspf": "application/xspf+xml",
      "xvm": "application/xv+xml",
      "xvml": "application/xv+xml",
      "yaml": "text/yaml",
      "yang": "application/yang",
      "yin": "application/yin+xml",
      "yml": "text/yaml",
      "zip": "application/zip"
    };
    function lookup(extn) {
      let tmp = ("" + extn).trim().toLowerCase();
      let idx = tmp.lastIndexOf(".");
      return mimes[!~idx ? tmp : tmp.substring(++idx)];
    }
    __name(lookup, "lookup");
    exports.mimes = mimes;
    exports.lookup = lookup;
  }
});

// ../../node_modules/sirv/build.js
var require_build2 = __commonJS({
  "../../node_modules/sirv/build.js"(exports, module) {
    var fs = __require("fs");
    var { join: join2, normalize: normalize2, resolve: resolve2 } = __require("path");
    var { totalist } = require_sync();
    var { parse: parse2 } = require_build();
    var { lookup } = require_mrmime();
    var noop = /* @__PURE__ */ __name(() => {
    }, "noop");
    function isMatch(uri, arr) {
      for (let i = 0; i < arr.length; i++) {
        if (arr[i].test(uri)) return true;
      }
    }
    __name(isMatch, "isMatch");
    function toAssume(uri, extns) {
      let i = 0, x, len = uri.length - 1;
      if (uri.charCodeAt(len) === 47) {
        uri = uri.substring(0, len);
      }
      let arr = [], tmp = `${uri}/index`;
      for (; i < extns.length; i++) {
        x = extns[i] ? `.${extns[i]}` : "";
        if (uri) arr.push(uri + x);
        arr.push(tmp + x);
      }
      return arr;
    }
    __name(toAssume, "toAssume");
    function viaCache(cache, uri, extns) {
      let i = 0, data, arr = toAssume(uri, extns);
      for (; i < arr.length; i++) {
        if (data = cache[arr[i]]) return data;
      }
    }
    __name(viaCache, "viaCache");
    function viaLocal(dir, isEtag, uri, extns) {
      let i = 0, arr = toAssume(uri, extns);
      let abs, stats, name, headers;
      for (; i < arr.length; i++) {
        abs = normalize2(join2(dir, name = arr[i]));
        if (abs.startsWith(dir) && fs.existsSync(abs)) {
          stats = fs.statSync(abs);
          if (stats.isDirectory()) continue;
          headers = toHeaders(name, stats, isEtag);
          headers["Cache-Control"] = isEtag ? "no-cache" : "no-store";
          return { abs, stats, headers };
        }
      }
    }
    __name(viaLocal, "viaLocal");
    function is404(req, res) {
      return res.statusCode = 404, res.end();
    }
    __name(is404, "is404");
    function send(req, res, file, stats, headers) {
      let code = 200, tmp, opts = {};
      headers = { ...headers };
      for (let key in headers) {
        tmp = res.getHeader(key);
        if (tmp) headers[key] = tmp;
      }
      if (tmp = res.getHeader("content-type")) {
        headers["Content-Type"] = tmp;
      }
      if (req.headers.range) {
        code = 206;
        let [x, y] = req.headers.range.replace("bytes=", "").split("-");
        let end = opts.end = parseInt(y, 10) || stats.size - 1;
        let start2 = opts.start = parseInt(x, 10) || 0;
        if (end >= stats.size) {
          end = stats.size - 1;
        }
        if (start2 >= stats.size) {
          res.setHeader("Content-Range", `bytes */${stats.size}`);
          res.statusCode = 416;
          return res.end();
        }
        headers["Content-Range"] = `bytes ${start2}-${end}/${stats.size}`;
        headers["Content-Length"] = end - start2 + 1;
        headers["Accept-Ranges"] = "bytes";
      }
      res.writeHead(code, headers);
      fs.createReadStream(file, opts).pipe(res);
    }
    __name(send, "send");
    var ENCODING = {
      ".br": "br",
      ".gz": "gzip"
    };
    function toHeaders(name, stats, isEtag) {
      let enc = ENCODING[name.slice(-3)];
      let ctype = lookup(name.slice(0, enc && -3)) || "";
      if (ctype === "text/html") ctype += ";charset=utf-8";
      let headers = {
        "Content-Length": stats.size,
        "Content-Type": ctype,
        "Last-Modified": stats.mtime.toUTCString()
      };
      if (enc) headers["Content-Encoding"] = enc;
      if (isEtag) headers["ETag"] = `W/"${stats.size}-${stats.mtime.getTime()}"`;
      return headers;
    }
    __name(toHeaders, "toHeaders");
    module.exports = function(dir, opts = {}) {
      dir = resolve2(dir || ".");
      let isNotFound = opts.onNoMatch || is404;
      let setHeaders = opts.setHeaders || noop;
      let extensions = opts.extensions || ["html", "htm"];
      let gzips = opts.gzip && extensions.map((x) => `${x}.gz`).concat("gz");
      let brots = opts.brotli && extensions.map((x) => `${x}.br`).concat("br");
      const FILES = {};
      let fallback = "/";
      let isEtag = !!opts.etag;
      let isSPA = !!opts.single;
      if (typeof opts.single === "string") {
        let idx = opts.single.lastIndexOf(".");
        fallback += !!~idx ? opts.single.substring(0, idx) : opts.single;
      }
      let ignores = [];
      if (opts.ignores !== false) {
        ignores.push(/[/]([A-Za-z\s\d~$._-]+\.\w+){1,}$/);
        if (opts.dotfiles) ignores.push(/\/\.\w/);
        else ignores.push(/\/\.well-known/);
        [].concat(opts.ignores || []).forEach((x) => {
          ignores.push(new RegExp(x, "i"));
        });
      }
      let cc = opts.maxAge != null && `public,max-age=${opts.maxAge}`;
      if (cc && opts.immutable) cc += ",immutable";
      else if (cc && opts.maxAge === 0) cc += ",must-revalidate";
      if (!opts.dev) {
        totalist(dir, (name, abs, stats) => {
          if (/\.well-known[\\+\/]/.test(name)) {
          } else if (!opts.dotfiles && /(^\.|[\\+|\/+]\.)/.test(name)) return;
          let headers = toHeaders(name, stats, isEtag);
          if (cc) headers["Cache-Control"] = cc;
          FILES["/" + name.normalize().replace(/\\+/g, "/")] = { abs, stats, headers };
        });
      }
      let lookup2 = opts.dev ? viaLocal.bind(0, dir, isEtag) : viaCache.bind(0, FILES);
      return function(req, res, next) {
        let extns = [""];
        let pathname = parse2(req).pathname;
        let val = req.headers["accept-encoding"] || "";
        if (gzips && val.includes("gzip")) extns.unshift(...gzips);
        if (brots && /(br|brotli)/i.test(val)) extns.unshift(...brots);
        extns.push(...extensions);
        if (pathname.indexOf("%") !== -1) {
          try {
            pathname = decodeURI(pathname);
          } catch (err) {
          }
        }
        let data = lookup2(pathname, extns) || isSPA && !isMatch(pathname, ignores) && lookup2(fallback, extns);
        if (!data) return next ? next() : isNotFound(req, res);
        if (isEtag && req.headers["if-none-match"] === data.headers["ETag"]) {
          res.writeHead(304);
          return res.end();
        }
        if (gzips || brots) {
          res.setHeader("Vary", "Accept-Encoding");
        }
        setHeaders(res, pathname, data.stats);
        send(req, res, data.abs, data.stats, data.headers);
      };
    };
  }
});

// src/index.ts
import { cp } from "node:fs/promises";
import { fileURLToPath } from "node:url";
import { PREVIEW_BUILDER_PROGRESS } from "storybook/internal/core-events";
import { logger } from "storybook/internal/node-logger";
import {
  WebpackCompilationError,
  WebpackInvocationError,
  WebpackMissingStatsError
} from "storybook/internal/server-errors";
import { checkWebpackVersion } from "@storybook/core-webpack";

// ../../node_modules/pathe/dist/shared/pathe.ff20891b.mjs
var _DRIVE_LETTER_START_RE = /^[A-Za-z]:\//;
function normalizeWindowsPath(input = "") {
  if (!input) {
    return input;
  }
  return input.replace(/\\/g, "/").replace(_DRIVE_LETTER_START_RE, (r) => r.toUpperCase());
}
__name(normalizeWindowsPath, "normalizeWindowsPath");
var _UNC_REGEX = /^[/\\]{2}/;
var _IS_ABSOLUTE_RE = /^[/\\](?![/\\])|^[/\\]{2}(?!\.)|^[A-Za-z]:[/\\]/;
var _DRIVE_LETTER_RE = /^[A-Za-z]:$/;
var normalize = /* @__PURE__ */ __name(function(path2) {
  if (path2.length === 0) {
    return ".";
  }
  path2 = normalizeWindowsPath(path2);
  const isUNCPath = path2.match(_UNC_REGEX);
  const isPathAbsolute = isAbsolute(path2);
  const trailingSeparator = path2[path2.length - 1] === "/";
  path2 = normalizeString(path2, !isPathAbsolute);
  if (path2.length === 0) {
    if (isPathAbsolute) {
      return "/";
    }
    return trailingSeparator ? "./" : ".";
  }
  if (trailingSeparator) {
    path2 += "/";
  }
  if (_DRIVE_LETTER_RE.test(path2)) {
    path2 += "/";
  }
  if (isUNCPath) {
    if (!isPathAbsolute) {
      return `//./${path2}`;
    }
    return `//${path2}`;
  }
  return isPathAbsolute && !isAbsolute(path2) ? `/${path2}` : path2;
}, "normalize");
var join = /* @__PURE__ */ __name(function(...arguments_) {
  if (arguments_.length === 0) {
    return ".";
  }
  let joined;
  for (const argument of arguments_) {
    if (argument && argument.length > 0) {
      if (joined === void 0) {
        joined = argument;
      } else {
        joined += `/${argument}`;
      }
    }
  }
  if (joined === void 0) {
    return ".";
  }
  return normalize(joined.replace(/\/\/+/g, "/"));
}, "join");
function normalizeString(path2, allowAboveRoot) {
  let res = "";
  let lastSegmentLength = 0;
  let lastSlash = -1;
  let dots = 0;
  let char = null;
  for (let index = 0; index <= path2.length; ++index) {
    if (index < path2.length) {
      char = path2[index];
    } else if (char === "/") {
      break;
    } else {
      char = "/";
    }
    if (char === "/") {
      if (lastSlash === index - 1 || dots === 1) ;
      else if (dots === 2) {
        if (res.length < 2 || lastSegmentLength !== 2 || res[res.length - 1] !== "." || res[res.length - 2] !== ".") {
          if (res.length > 2) {
            const lastSlashIndex = res.lastIndexOf("/");
            if (lastSlashIndex === -1) {
              res = "";
              lastSegmentLength = 0;
            } else {
              res = res.slice(0, lastSlashIndex);
              lastSegmentLength = res.length - 1 - res.lastIndexOf("/");
            }
            lastSlash = index;
            dots = 0;
            continue;
          } else if (res.length > 0) {
            res = "";
            lastSegmentLength = 0;
            lastSlash = index;
            dots = 0;
            continue;
          }
        }
        if (allowAboveRoot) {
          res += res.length > 0 ? "/.." : "..";
          lastSegmentLength = 2;
        }
      } else {
        if (res.length > 0) {
          res += `/${path2.slice(lastSlash + 1, index)}`;
        } else {
          res = path2.slice(lastSlash + 1, index);
        }
        lastSegmentLength = index - lastSlash - 1;
      }
      lastSlash = index;
      dots = 0;
    } else if (char === "." && dots !== -1) {
      ++dots;
    } else {
      dots = -1;
    }
  }
  return res;
}
__name(normalizeString, "normalizeString");
var isAbsolute = /* @__PURE__ */ __name(function(p) {
  return _IS_ABSOLUTE_RE.test(p);
}, "isAbsolute");
var _EXTNAME_RE = /.(\.[^./]+)$/;
var extname = /* @__PURE__ */ __name(function(p) {
  const match = _EXTNAME_RE.exec(normalizeWindowsPath(p));
  return match && match[1] || "";
}, "extname");
var dirname = /* @__PURE__ */ __name(function(p) {
  const segments = normalizeWindowsPath(p).replace(/\/$/, "").split("/").slice(0, -1);
  if (segments.length === 1 && _DRIVE_LETTER_RE.test(segments[0])) {
    segments[0] += "/";
  }
  return segments.join("/") || (isAbsolute(p) ? "/" : ".");
}, "dirname");
var basename = /* @__PURE__ */ __name(function(p, extension) {
  const lastSegment = normalizeWindowsPath(p).split("/").pop();
  return extension && lastSegment.endsWith(extension) ? lastSegment.slice(0, -extension.length) : lastSegment;
}, "basename");
var parse = /* @__PURE__ */ __name(function(p) {
  const root = normalizeWindowsPath(p).split("/").shift() || "/";
  const base = basename(p);
  const extension = extname(base);
  return {
    root,
    dir: dirname(p),
    base,
    ext: extension,
    name: base.slice(0, base.length - extension.length)
  };
}, "parse");

// src/index.ts
var import_pretty_hrtime = __toESM(require_pretty_hrtime(), 1);
var import_sirv = __toESM(require_build2(), 1);
import webpackModule from "webpack";
import webpackDevMiddleware from "webpack-dev-middleware";
import webpackHotMiddleware from "webpack-hot-middleware";
var { DefinePlugin, IgnorePlugin, ProgressPlugin } = webpackModule;
var WebpackDefinePlugin = DefinePlugin;
var WebpackIgnorePlugin = IgnorePlugin;
var printDuration = /* @__PURE__ */ __name((startTime) => (0, import_pretty_hrtime.default)(process.hrtime(startTime)).replace(" ms", " milliseconds").replace(" s", " seconds").replace(" min", " minutes"), "printDuration");
var corePath = dirname(fileURLToPath(import.meta.resolve("storybook/package.json")));
var compilation;
var reject;
var executor = {
  get: /* @__PURE__ */ __name(async (options) => {
    const version = await options.presets.apply("webpackVersion") || "5";
    const webpackInstance = (await options.presets.apply("webpackInstance"))?.default || webpackModule;
    checkWebpackVersion({ version }, "5", "builder-webpack5");
    return webpackInstance;
  }, "get")
};
var getConfig = /* @__PURE__ */ __name(async (options) => {
  const { presets } = options;
  const typescriptOptions = await presets.apply("typescript", {}, options);
  const frameworkOptions = await presets.apply("frameworkOptions");
  return presets.apply(
    "webpack",
    {},
    {
      ...options,
      typescriptOptions,
      frameworkOptions
    }
  );
}, "getConfig");
var asyncIterator;
var bail = /* @__PURE__ */ __name(async () => {
  if (asyncIterator) {
    try {
      await asyncIterator.throw(new Error());
    } catch (e) {
    }
  }
  if (reject) {
    reject();
  }
  return new Promise((res, rej) => {
    if (process && compilation) {
      try {
        compilation.close(() => res());
        logger.warn("Force closed preview build");
      } catch (err) {
        logger.warn("Unable to close preview build!");
        res();
      }
    } else {
      res();
    }
  });
}, "bail");
var starter = /* @__PURE__ */ __name(async function* starterGeneratorFn({
  startTime,
  options,
  router,
  channel
}) {
  const webpackInstance = await executor.get(options);
  yield;
  const config = await getConfig(options);
  if (config.stats === "none" || config.stats === "summary") {
    throw new WebpackMissingStatsError();
  }
  yield;
  const compiler = webpackInstance(config);
  if (!compiler) {
    throw new WebpackInvocationError({
      // eslint-disable-next-line local-rules/no-uncategorized-errors
      error: new Error(`Missing Webpack compiler at runtime!`)
    });
  }
  yield;
  const modulesCount = await options.cache?.get("modulesCount", 1e3);
  let totalModules;
  let value = 0;
  new ProgressPlugin({
    handler: /* @__PURE__ */ __name((newValue, message, arg3) => {
      value = Math.max(newValue, value);
      const progress = { value, message: message.charAt(0).toUpperCase() + message.slice(1) };
      if (message === "building") {
        const counts = arg3 && arg3.match(/entries (\d+)\/(\d+)/) || [];
        const complete = parseInt(counts[1], 10);
        const total = parseInt(counts[2], 10);
        if (!Number.isNaN(complete) && !Number.isNaN(total)) {
          progress.modules = { complete, total };
          totalModules = total;
        }
      }
      if (value === 1) {
        if (options.cache) {
          options.cache.set("modulesCount", totalModules);
        }
        if (!progress.message) {
          progress.message = `Completed in ${printDuration(startTime)}.`;
        }
      }
      channel.emit(PREVIEW_BUILDER_PROGRESS, progress);
    }, "handler"),
    modulesCount
  }).apply(compiler);
  const middlewareOptions = {
    publicPath: config.output?.publicPath,
    writeToDisk: true,
    stats: "errors-only"
  };
  compilation = webpackDevMiddleware(compiler, middlewareOptions);
  const previewResolvedDir = join(corePath, "dist/preview");
  router.use(
    "/sb-preview",
    (0, import_sirv.default)(previewResolvedDir, {
      maxAge: 3e5,
      dev: true,
      immutable: true
    })
  );
  router.use(compilation);
  router.use(webpackHotMiddleware(compiler, { log: false }));
  const stats = await new Promise((res, rej) => {
    compilation?.waitUntilValid(res);
    reject = rej;
  });
  yield;
  if (!stats) {
    throw new WebpackMissingStatsError();
  }
  const { warnings, errors } = getWebpackStats({ config, stats });
  if (warnings.length > 0) {
    warnings?.forEach((e) => logger.warn(e.message));
  }
  if (errors.length > 0) {
    throw new WebpackCompilationError({ errors });
  }
  return {
    bail,
    stats,
    totalTime: process.hrtime(startTime)
  };
}, "starterGeneratorFn");
function getWebpackStats({ config, stats }) {
  const statsOptions = typeof config.stats === "string" ? config.stats : {
    ...config.stats,
    warnings: true,
    errors: true
  };
  const { warnings = [], errors = [] } = stats?.toJson(statsOptions) || {};
  return {
    warnings,
    errors
  };
}
__name(getWebpackStats, "getWebpackStats");
var builder = /* @__PURE__ */ __name(async function* builderGeneratorFn({ startTime, options }) {
  const webpackInstance = await executor.get(options);
  yield;
  const config = await getConfig(options);
  if (config.stats === "none" || config.stats === "summary") {
    throw new WebpackMissingStatsError();
  }
  yield;
  const compiler = webpackInstance(config);
  if (!compiler) {
    throw new WebpackInvocationError({
      // eslint-disable-next-line local-rules/no-uncategorized-errors
      error: new Error(`Missing Webpack compiler at runtime!`)
    });
  }
  const webpackCompilation = new Promise((succeed, fail) => {
    compiler.run((error, stats) => {
      if (error) {
        compiler.close(() => fail(new WebpackInvocationError({ error })));
        return;
      }
      if (!stats) {
        throw new WebpackMissingStatsError();
      }
      const { warnings, errors } = getWebpackStats({ config, stats });
      if (warnings.length > 0) {
        warnings?.forEach((e) => logger.warn(e.message));
      }
      if (errors.length > 0) {
        errors.forEach((e) => logger.error(e.message));
        compiler.close(() => fail(new WebpackCompilationError({ errors })));
        return;
      }
      compiler.close((closeErr) => {
        if (closeErr) {
          return fail(new WebpackInvocationError({ error: closeErr }));
        }
        return succeed(stats);
      });
    });
  });
  const previewResolvedDir = join(corePath, "dist/preview");
  const previewDirTarget = join(options.outputDir || "", `sb-preview`);
  const previewFiles = cp(previewResolvedDir, previewDirTarget, {
    filter: /* @__PURE__ */ __name((src) => {
      const { ext } = parse(src);
      if (ext) {
        return ext === ".js";
      }
      return true;
    }, "filter"),
    recursive: true
  });
  const [webpackCompilationOutput] = await Promise.all([webpackCompilation, previewFiles]);
  return webpackCompilationOutput;
}, "builderGeneratorFn");
var start = /* @__PURE__ */ __name(async (options) => {
  asyncIterator = starter(options);
  let result;
  do {
    result = await asyncIterator.next();
  } while (!result.done);
  return result.value;
}, "start");
var build = /* @__PURE__ */ __name(async (options) => {
  asyncIterator = builder(options);
  let result;
  do {
    result = await asyncIterator.next();
  } while (!result.done);
  return result.value;
}, "build");
var corePresets = [
  import.meta.resolve("@storybook/builder-webpack5/presets/preview-preset")
];
var overridePresets = [
  import.meta.resolve("@storybook/builder-webpack5/presets/custom-webpack-preset")
];
export {
  WebpackDefinePlugin,
  WebpackIgnorePlugin,
  bail,
  build,
  corePresets,
  executor,
  getConfig,
  getVirtualModules,
  overridePresets,
  printDuration,
  start
};
