import CJS_COMPAT_NODE_URL_d53zm9kb3a7 from 'node:url';
import CJS_COMPAT_NODE_PATH_d53zm9kb3a7 from 'node:path';
import CJS_COMPAT_NODE_MODULE_d53zm9kb3a7 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_d53zm9kb3a7.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_d53zm9kb3a7.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_d53zm9kb3a7.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  __name
} from "./chunk-OZRNAYHU.js";

// src/preview/virtual-module-mapping.ts
import { join, resolve } from "node:path";
import { fileURLToPath } from "node:url";
import {
  getBuilderOptions,
  loadPreviewOrConfigFile,
  normalizeStories,
  readTemplate
} from "storybook/internal/common";
import { toImportFn } from "@storybook/core-webpack";

// ../../node_modules/slash/index.js
function slash(path) {
  const isExtendedLengthPath = path.startsWith("\\\\?\\");
  if (isExtendedLengthPath) {
    return path;
  }
  return path.replace(/\\/g, "/");
}
__name(slash, "slash");

// src/preview/virtual-module-mapping.ts
var getVirtualModules = /* @__PURE__ */ __name(async (options) => {
  const virtualModules = {};
  const builderOptions = await getBuilderOptions(options);
  const workingDir = process.cwd();
  const isProd = options.configType === "PRODUCTION";
  const nonNormalizedStories = await options.presets.apply("stories", []);
  const entries = [];
  const stories = normalizeStories(nonNormalizedStories, {
    configDir: options.configDir,
    workingDir
  });
  const previewAnnotations = [
    ...(await options.presets.apply("previewAnnotations", [], options)).map(
      (entry) => {
        if (typeof entry === "object") {
          return entry.absolute;
        }
        return slash(entry);
      }
    ),
    loadPreviewOrConfigFile(options)
  ].filter(Boolean);
  const storiesFilename = "storybook-stories.js";
  const storiesPath = resolve(join(workingDir, storiesFilename));
  const needPipelinedImport = !!builderOptions.lazyCompilation && !isProd;
  virtualModules[storiesPath] = toImportFn(stories, { needPipelinedImport });
  const configEntryPath = resolve(join(workingDir, "storybook-config-entry.js"));
  virtualModules[configEntryPath] = (await readTemplate(
    fileURLToPath(
      import.meta.resolve("@storybook/builder-webpack5/templates/virtualModuleModernEntry.js")
    )
  )).replaceAll(`'{{storiesFilename}}'`, `'./${storiesFilename}'`).replaceAll(
    `'{{previewAnnotations}}'`,
    previewAnnotations.filter(Boolean).map((entry) => `'${entry}'`).join(",")
  ).replaceAll(
    `'{{previewAnnotations_requires}}'`,
    previewAnnotations.filter(Boolean).map((entry) => `require('${entry}')`).join(",")
  ).replace(/\\/g, "\\\\");
  entries.push(configEntryPath);
  return {
    virtualModules,
    entries
  };
}, "getVirtualModules");

export {
  getVirtualModules
};
