import CJS_COMPAT_NODE_URL_vnbcdrn4e08 from 'node:url';
import CJS_COMPAT_NODE_PATH_vnbcdrn4e08 from 'node:path';
import CJS_COMPAT_NODE_MODULE_vnbcdrn4e08 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_vnbcdrn4e08.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_vnbcdrn4e08.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_vnbcdrn4e08.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  __name
} from "./_node-chunks/chunk-DYJN5OTB.js";

// src/webpack-loader.ts
import { readFile } from "node:fs/promises";
import { enrichCsf, formatCsf, loadCsf } from "storybook/internal/csf-tools";
async function loader(content, map) {
  const callback = this.async();
  const options = this.getOptions();
  const id = this.resourcePath;
  const sourceCode = await readFile(id, "utf-8");
  try {
    const makeTitle = /* @__PURE__ */ __name((userTitle) => userTitle || "default", "makeTitle");
    const csf = loadCsf(content, { makeTitle }).parse();
    const csfSource = loadCsf(sourceCode, { makeTitle }).parse();
    enrichCsf(csf, csfSource, options);
    const formattedCsf = formatCsf(
      csf,
      { sourceMaps: true, inputSourceMap: map, sourceFileName: id },
      content
    );
    if (typeof formattedCsf === "string") {
      return callback(null, formattedCsf, map);
    }
    callback(null, formattedCsf.code, formattedCsf.map);
  } catch (err) {
    if (!err.message?.startsWith("CSF:")) {
      console.warn(err.message);
    }
    callback(null, content, map);
  }
}
__name(loader, "loader");
var webpack_loader_default = loader;
export {
  webpack_loader_default as default
};
