import CJS_COMPAT_NODE_URL_vnbcdrn4e08 from 'node:url';
import CJS_COMPAT_NODE_PATH_vnbcdrn4e08 from 'node:path';
import CJS_COMPAT_NODE_MODULE_vnbcdrn4e08 from "node:module";

var __filename = CJS_COMPAT_NODE_URL_vnbcdrn4e08.fileURLToPath(import.meta.url);
var __dirname = CJS_COMPAT_NODE_PATH_vnbcdrn4e08.dirname(__filename);
var require = CJS_COMPAT_NODE_MODULE_vnbcdrn4e08.createRequire(import.meta.url);

// ------------------------------------------------------------
// end of CJS compatibility banner, injected by Storybook's esbuild configuration
// ------------------------------------------------------------
import {
  __name
} from "./_node-chunks/chunk-DYJN5OTB.js";

// src/index.ts
import { fileURLToPath } from "node:url";
import { createUnplugin } from "unplugin";

// src/constants.ts
var STORIES_REGEX = /(?<!node_modules.*)\.(story|stories)\.[tj]sx?$/;

// src/rollup-based-plugin.ts
import { readFile } from "node:fs/promises";
import { enrichCsf, formatCsf, loadCsf } from "storybook/internal/csf-tools";
import { logger } from "storybook/internal/node-logger";
function rollupBasedPlugin(options) {
  return {
    name: "plugin-csf",
    async transform(code, id) {
      if (!STORIES_REGEX.test(id)) {
        return;
      }
      const sourceCode = await readFile(id, "utf-8");
      try {
        const makeTitle = /* @__PURE__ */ __name((userTitle) => userTitle || "default", "makeTitle");
        const csf = loadCsf(code, { makeTitle }).parse();
        const csfSource = loadCsf(sourceCode, {
          makeTitle
        }).parse();
        enrichCsf(csf, csfSource, options);
        const inputSourceMap = this.getCombinedSourcemap();
        return formatCsf(csf, { sourceMaps: true, inputSourceMap }, code);
      } catch (err) {
        if (!err.message?.startsWith("CSF:")) {
          logger.warn(err.message);
        }
        return code;
      }
    }
  };
}
__name(rollupBasedPlugin, "rollupBasedPlugin");

// src/index.ts
var unpluginFactory = /* @__PURE__ */ __name((options) => {
  return {
    name: "unplugin-csf",
    rollup: {
      ...rollupBasedPlugin(options)
    },
    vite: {
      enforce: "pre",
      ...rollupBasedPlugin(options)
    },
    webpack(compiler) {
      compiler.options.module.rules.unshift({
        test: STORIES_REGEX,
        enforce: "post",
        use: {
          options,
          loader: fileURLToPath(import.meta.resolve("@storybook/csf-plugin/webpack-loader"))
        }
      });
    },
    rspack(compiler) {
      compiler.options.module.rules.unshift({
        test: STORIES_REGEX,
        enforce: "post",
        use: {
          options,
          loader: fileURLToPath(import.meta.resolve("@storybook/csf-plugin/webpack-loader"))
        }
      });
    }
  };
}, "unpluginFactory");
var unplugin = createUnplugin(unpluginFactory);
var { esbuild } = unplugin;
var { webpack } = unplugin;
var { rollup } = unplugin;
var { vite } = unplugin;
export {
  esbuild,
  rollup,
  unplugin,
  unpluginFactory,
  vite,
  webpack
};
