# Changelog

## [2.5.0](https://github.com/trento-project/web/tree/2.4.0/compare/2.4.0...2.5.0) - 2025-05-20

### What's Changed

* Test flakiness analysis for backend. (#3483) @vicenteqa
* Fix PR env pre-flight check for forks (#3497) @stefanotorresi
* Edit ansible inventory in CI (#3474) @balanza
* Reorder start ordering (#3485) @gagandeepb
* Add checks execution with custom values test e2e (#3476) @EMaksy
* Increase timeout for SUSE Multi Linux Manager API (#3435) @balanza
* PO Refactor checks execution & other tests dependent on wanda (#3471) @vicenteqa
* Checks customization e2e (#3460) @EMaksy
* Add a GenericError for displaying non-recoverable errors (#3459) @janvhs
* Fix margins (#3446) @janvhs
* Using checks in pr env (#3456) @nelsonkopliku
* Apply PO pattern to Settings test suite (#3442) @vicenteqa
* Apply PO Pattern to Saptune-SSO-SUMA test suites (#3428) @vicenteqa
* Apply PageObject pattern sap systems overview e2e tests (#3408) @vicenteqa
* Allow Usage Of Podman (#3400) @janvhs
* Run regression and integration e2e tests always in CI (#3411) @arbulu89
* Identify clustered sap instances (#3397) @arbulu89
* Use custom function to check if data is loaded (#3405) @arbulu89
* Apply page object pattern Sap System Details tests. (#3392) @vicenteqa
* Apply page object pattern to hosts overview tests (#3389) @vicenteqa
* Review & fix users e2e tests flakiness (#3378) @vicenteqa
* Rename current_value to default_value (#3380) @nelsonkopliku
* Apply PO Pattern host details e2e tests. (#3348) @vicenteqa
* Add Trento documentation to navigation bar (#3294) @janvhs
* Apply po pattern home tests (#3344) @vicenteqa
* Refactor checkable warning message (#3332) @EMaksy
* Apply PageObject pattern to Hana DB Details E2E tests (#3330) @vicenteqa
* Apply PageObject pattern Hana Cluster Details E2E tests (#3300) @vicenteqa
* Create checkable warning messages (#3313) @EMaksy
* Saptune solution apply endpoint (#3305) @arbulu89
* Apply PageObject pattern to databases overview tests. (#3281) @vicenteqa
* Apply PageObject pattern Clusters Overview tests. (#3266) @vicenteqa
* Apply PageObject pattern 'activity log' e2e tests (#3259) @vicenteqa
* Add check customization ability (#3258) @nelsonkopliku
* Fix Jest warnings on FE tests (#3254) @vicenteqa
* Apply page object pattern to 'about' and 'check catalog' tests (#3248) @vicenteqa
* Fixes typo (#3245) @gagandeepb
* Fix for nil values in severity (#3244) @gagandeepb
* Add page object structure for User creation tests (#3219) @vicenteqa
* add job conditional to ensure secret availability (#3234) @stefanotorresi
* move some workflow env variables to GHA variables (#3233) @stefanotorresi
* Refactor activity log settings (#3223) @nelsonkopliku
* update license notice (#3226) @stefanotorresi
* Pin Chromatic action (#3227) @balanza
* Revert "Add e2e test for hana scale up cost optimized scenario" (#3213) @arbulu89
* Remove SUMA feature flag (#3205) @janvhs
* Improve e2e tests on Activity log (#3200) @balanza
* Fixup #3198 (#3199) @balanza
* Add a PR comment when a preview environment is created (#3198) @balanza
* Show password toggle on login (#3191) @balanza
* Fix activity log e2e test (#3179) @nelsonkopliku
* Add info tooltip for metadata search (#3186) @balanza
* Activity log autorefresh e2e (#3169) @nelsonkopliku
* Add sap hana scale up cost optimized and performance optimized discovery (#3152) @EMaksy

#### Features

* Reset modal options on cancel (#3504) @arbulu89
* SMTP allows talking to unauthenticated servers (#3489) @skrech
* Add cluster maintenance change modal (#3487) @arbulu89
* Request saptune discovery when saptune solution apply operation is completed (#3443) @arbulu89
* Add wanda to ci for e2e (#3455) @EMaksy
* Log checks selected as connection activity (#3450) @nelsonkopliku
* Implements newly defined severity level conditions (#3445) @gagandeepb
* Log user coming from messages (#3440) @nelsonkopliku
* Backend for User Analytics Settings (#3372) @jagabomb
* Parse current instance field (#3416) @arbulu89
* Support AWS without metadata scenarios (#3412) @nelsonkopliku
* Log checks customizations activities (#3424) @nelsonkopliku
* Handle unmounted clustered sap instance (#3422) @arbulu89
* Expose cluster sap instances frontend (#3410) @arbulu89
* Discovery HANA+ASCS/ERS ers clusters (#3394) @arbulu89
* Use operation forbidden modal in host details (#3381) @arbulu89
* Add OperationForbiddenModal (#3331) @arbulu89
* Operation policy messages (#3364) @arbulu89
* Operation user authorization frontend (#3369) @arbulu89
* Operation user authorization (#3368) @arbulu89
* Add hostname field to activity log metadata for operation entries (#3377) @arbulu89
* Checks customization modal save (#3352) @EMaksy
* Fetch running operation on page load (#3355) @arbulu89
* Activity log severity levels UI (#3306) @gagandeepb
* Operation completed activity log (#3360) @arbulu89
* Add modified check pill in checks execution results an detail (#3358) @nelsonkopliku
* Log operation requested in activity log (#3354) @arbulu89
* Rabbitmq explicit ssl support (#3353) @CDimonaco
* Add operations button host view (#3345) @arbulu89
* Add boolean input for checks customization modal (#3310) @EMaksy
* Running operations redux (#3339) @arbulu89
* Request and process operation events (#3333) @arbulu89
* Add operations messaging queue (#3320) @arbulu89
* Actions button (#3319) @arbulu89
* Saptune solution apply modal (#3311) @arbulu89
* Add reset customization cta inside modal (#3323) @nelsonkopliku
* Wire up check customization reset (#3309) @nelsonkopliku
* Add reset customization cta (#3308) @nelsonkopliku
* Add operations policy plug (#3304) @arbulu89
* Foundation for Basic Analytics Implementation (#3301) @jagabomb
* Operation policies (#3293) @arbulu89
* Adjust checks selection route (#3299) @nelsonkopliku
* Parameterized ecto payload (#3286) @arbulu89
* Improve read models associations (#3284) @arbulu89
* Activity log severity levels filter (#3285) @gagandeepb
* Add Checks customization modal (#3277) @EMaksy
* Add parent cluster resource (#3276) @arbulu89
* Load checks selection with customizations (#3278) @nelsonkopliku
* Add modified pill for customized checks (#3274) @nelsonkopliku
* Rename suse manager labeling (#3279) @arbulu89
* Use embeds software updates (#3275) @arbulu89
* Add check customization call to action in checks selection (#3256) @nelsonkopliku
* Adds Encapsulation for Dashboard Page (#3242) @jagabomb
* Refactor checks_catalog ui test (#3247) @EMaksy
* Expose abilities as jwt claims (#3240) @nelsonkopliku
* Activity log severity levels  (#3222) @gagandeepb
* Add hana scale up scenario as selection in checks catalog (#3210) @EMaksy
* Add job for flaky e2e tests detection (#3215) @vicenteqa
* Cypress E2E Tests parallelization (#3208) @vicenteqa
* Hana Scale up cost opt checks in the trento console (#3206) @EMaksy
* Add e2e test for hana scale up cost optimized scenario (#3184) @EMaksy
* Redact users in activity log (#3195) @nelsonkopliku
* Limit user access in activity log filters (#3183) @nelsonkopliku
* Add new ability permitting access to users in activity log (#3180) @nelsonkopliku
* Activity log autorefresh (#3161) @nelsonkopliku
* Use prometheus targets (#3165) @arbulu89
* Activity Log search by metadata (#3056) @nelsonkopliku
* ActivityLog searching by metadata BE implementation (#3059) @gagandeepb
* Replaces Empty Favicon with Trento Logo (#3144) @jagabomb

#### Bug Fixes

* Bugfix for web as it fails to start when no IPV6 is available (#3490) @EMaksy
* Show tooltip only when hoovered over the start execution button (#3470) @EMaksy
* Relax timeouts (#3477) @janvhs
* Fix references to activity log settings (#3463) @nelsonkopliku
* Deduplicate targets for ascs cluster checks executions (#3447) @nelsonkopliku
* Fix width on Select (#3418) @janvhs
* Fix Save button after saving a check in the checks customization modal (#3417) @EMaksy
* Fix database profile payload validation (#3398) @arbulu89
* Enable reset customization when check is customized (#3328) @nelsonkopliku
* Update `date-fns` to 4.1.0 and DateFilter refactoring (#3312) @skrech
* Use embeds software updates (#3275) @arbulu89
* Fix cluster json view adapt_v1 function (#3273) @arbulu89
* Fix discovery dispatch accumulating errors (#3272) @arbulu89
* Remaps specific activity log type unconditionally to warning (#3271) @gagandeepb
* Fix selected cluster type ui in Checks catalog view (#3229) @EMaksy
* change base image and update dependencies (#3232) @stefanotorresi
* Update community container image to use fixed versions from leap15.6 (#3217) @arbulu89
* Upgrade tzdata to 1.1.2 to avoid error log (#3216) @arbulu89
* Handle ApplicationInstanceMoved event in deregistration (#3125) @arbulu89
* Allow the scheduled execution to check also ascs/ers clusters (#3156) @nelsonkopliku

#### Maintenance

* Version bump automation (#3509) @stefanotorresi
* Add menu position to operations button (#3503) @arbulu89
* Automate changelog generation (#3496) @stefanotorresi
* Remove legacy catalog list coming from `runner` implementation (#3494) @nelsonkopliku
* add .editorconfig (#3492) @stefanotorresi
* Fix wanda initdb permissions (#3479) @nelsonkopliku
* Recreate and not remove checks container in PR env ci (#3458) @arbulu89
* Add wanda to ci for e2e (#3455) @EMaksy
* Use rolling checks image in demo (#3451) @nelsonkopliku
* Differentiate checks execution requested label (#3441) @nelsonkopliku
* Minor adjustments to check customization (#3439) @nelsonkopliku
* Fix year range (#3426) @nelsonkopliku
* Fix operation_completed activity log severity level (#3371) @arbulu89
* Remove unnecessary div (#3370) @nelsonkopliku
* Upgrade github actions runner ubuntu version (#3361) @arbulu89
* Center severity icon in table cell (#3363) @nelsonkopliku
* Fix: Verify mocks in settings_test.ex (#3359) @skrech
* Rename ActionsButton to OperationsButton (#3329) @arbulu89
* Update `date-fns` to 4.1.0 and DateFilter refactoring (#3312) @skrech
* Fix operations policy get_params usage (#3321) @arbulu89
* Reduce modal padding (#3292) @nelsonkopliku
* Adds Encapsulation for Dashboard Page (#3242) @jagabomb
* Cost opt e2e (#3212) @arbulu89
* Order users query (#3196) @nelsonkopliku
* Use different clear icon (#3190) @nelsonkopliku
* Pin k3s version in CI workflow (#3185) @stefanotorresi
* Fix Activity Log type filter width (#3164) @nelsonkopliku
* Upgrade to Headless UI 2 (#3140) @dottorblaster
* Omit an unnecessary query when requesting cluster checks execution (#3159) @nelsonkopliku
* Replaces Empty Favicon with Trento Logo (#3144) @jagabomb

#### Dependencies

<details>
<summary>39 changes</summary>
* Bump posthog-js from 1.53.2 to 1.227.0 in /assets (#3362) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump trento contracts 0.2.0 (#3343) @CDimonaco
* Bump serialize-javascript from 6.0.1 to 6.0.2 in /assets (#3296) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump esbuild from 0.24.0 to 0.25.0 in /assets (#3295) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump chromaui/action from 11.25.1 to 11.25.2 (#3265) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump react-hot-toast from 2.4.1 to 2.5.1 in /assets (#3250) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump @faker-js/faker from 9.3.0 to 9.4.0 in /assets (#3249) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump chromaui/action from 11.25.0 to 11.25.1 (#3253) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump @babel/preset-react from 7.25.9 to 7.26.3 in /assets (#3209) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump react-select from 5.8.3 to 5.9.0 in /assets (#3201) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump actions/setup-python from 4 to 5 (#3220) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump chromatic from 11.22.2 to 11.25.0 in /assets (#3237) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump chromaui/action from 11.22.2 to 11.25.0 (#3238) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump undici from 5.28.4 to 5.28.5 in /test/e2e (#3243) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump isbang/compose-action from 2.0.2 to 2.1.0 (#3241) @[dependabot[bot]](https://github.com/apps/dependabot)
* Update gen_rmq to cdimonaco/gen_rmq version 5 (#3246) @CDimonaco
* Bump chromatic from 11.20.0 to 11.22.2 in /assets (#3221) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump qrcode.react from 4.1.0 to 4.2.0 in /assets (#3202) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump nanoid from 3.3.7 to 3.3.8 in /assets (#3207) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump docker/metadata-action from 5.5.1 to 5.6.1 (#3155) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump @faker-js/faker from 9.2.0 to 9.3.0 in /assets (#3194) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump @heroicons/react from 2.1.5 to 2.2.0 in /assets (#3192) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump @babel/plugin-transform-modules-commonjs from 7.25.9 to 7.26.3 in /assets (#3189) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump @testing-library/react from 16.0.1 to 16.1.0 in /assets (#3193) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump rc-input from 1.6.3 to 1.7.1 in /assets (#3171) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump @storybook/preview-api from 8.4.6 to 8.4.7 in /assets (#3188) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump eslint-plugin-storybook from 0.11.0 to 0.11.1 in /assets (#3187) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump rc-tooltip from 6.2.1 to 6.3.1 in /assets (#3178) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump tailwindcss from 3.4.15 to 3.4.16 in /assets (#3182) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump axios from 1.7.7 to 1.7.9 in /assets (#3181) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump chromatic from 11.19.0 to 11.20.0 in /assets (#3177) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump chart.js from 4.4.6 to 4.4.7 in /assets (#3170) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump chartjs-plugin-zoom from 2.0.1 to 2.2.0 in /assets (#3174) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump tailwindcss from 3.4.14 to 3.4.15 in /assets (#3151) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump cross-spawn from 7.0.3 to 7.0.6 in /test/e2e (#3154) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump @storybook/test from 8.4.2 to 8.4.6 in /assets (#3166) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump jaxxstorm/action-install-gh-release from 1.13.0 to 1.14.0 (#3163) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump chromatic from 11.18.0 to 11.19.0 in /assets (#3162) @[dependabot[bot]](https://github.com/apps/dependabot)
* Bump @storybook/preview-api from 8.4.2 to 8.4.6 in /assets (#3168) @[dependabot[bot]](https://github.com/apps/dependabot)

</details>
**Full Changelog**: https://github.com/trento-project/web/compare/2.4.0...2.5.0

## [2.4.0](https://github.com/trento-project/web/tree/2.4.0) (2024-11-12)

[Full Changelog](https://github.com/trento-project/web/compare/2.3.2...2.4.0)

**Merged pull requests:**

- Add SUMA credentials e2e [#2637](https://github.com/trento-project/web/pull/2637) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add validation tooltip on tag creation [#2696](https://github.com/trento-project/web/pull/2696) ([balanza](https://github.com/balanza))
- Use css style on component testing [#2701](https://github.com/trento-project/web/pull/2701) ([balanza](https://github.com/balanza))
- Refactor settings page section [#2704](https://github.com/trento-project/web/pull/2704) ([balanza](https://github.com/balanza))
- Fix format after #2704 [#2707](https://github.com/trento-project/web/pull/2707) ([balanza](https://github.com/balanza))
- Improve tag validation msg show up [#2708](https://github.com/trento-project/web/pull/2708) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add a docs section to pr template [#2663](https://github.com/trento-project/web/pull/2663) ([EMaksy](https://github.com/EMaksy))
- Activity log retention time [#2690](https://github.com/trento-project/web/pull/2690) ([nelsonkopliku](https://github.com/nelsonkopliku))
- User management [#2711](https://github.com/trento-project/web/pull/2711) ([arbulu89](https://github.com/arbulu89))
- Apply fix in the PR cleanup as well [#2714](https://github.com/trento-project/web/pull/2714) ([arbulu89](https://github.com/arbulu89))
- Watch channel events [#2692](https://github.com/trento-project/web/pull/2692) ([arbulu89](https://github.com/arbulu89))
- Activity log retention time endpoint [#2702](https://github.com/trento-project/web/pull/2702) ([gagandeepb](https://github.com/gagandeepb))
- Singularize Activity Log retention period unit [#2709](https://github.com/trento-project/web/pull/2709) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add migration and schema for ActivityLog [#2717](https://github.com/trento-project/web/pull/2717) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Navigate on sap system deregistration [#2716](https://github.com/trento-project/web/pull/2716) ([arbulu89](https://github.com/arbulu89))
- Add migration to restart the abilities sequence from 3 [#2719](https://github.com/trento-project/web/pull/2719) ([CDimonaco](https://github.com/CDimonaco))
- Add missing resource type assigns for tagging/untagging [#2718](https://github.com/trento-project/web/pull/2718) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Switch to 404 for SUSE Manager settings [#2722](https://github.com/trento-project/web/pull/2722) ([dottorblaster](https://github.com/dottorblaster))
- Components for Activity Logs settings [#2706](https://github.com/trento-project/web/pull/2706) ([balanza](https://github.com/balanza))
- Check selection abilities permissions [#2721](https://github.com/trento-project/web/pull/2721) ([arbulu89](https://github.com/arbulu89))
- SUSE Manager overviews [#2725](https://github.com/trento-project/web/pull/2725) ([dottorblaster](https://github.com/dottorblaster))
- Bump esbuild from 0.21.1 to 0.22.0 in /assets [#2728](https://github.com/trento-project/web/pull/2728) ([dependabot](https://github.com/dependabot))
- Bump react-router-dom from 6.23.0 to 6.24.0 in /assets [#2710](https://github.com/trento-project/web/pull/2710) ([dependabot](https://github.com/dependabot))
- Activity logger plug [#2726](https://github.com/trento-project/web/pull/2726) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump docker/build-push-action from 5 to 6 [#2698](https://github.com/trento-project/web/pull/2698) ([dependabot](https://github.com/dependabot))
- Bump docker/login-action from 3.1.0 to 3.2.0 [#2659](https://github.com/trento-project/web/pull/2659) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.3.2 to 11.5.4 in /assets [#2691](https://github.com/trento-project/web/pull/2691) ([dependabot](https://github.com/dependabot))
- Upgrade Node.js to version 20.14.0 LTS [#2660](https://github.com/trento-project/web/pull/2660) ([janvhs](https://github.com/janvhs))
- Remove navigate usage in redux action dispatching [#2720](https://github.com/trento-project/web/pull/2720) ([arbulu89](https://github.com/arbulu89))
- Bump isbang/compose-action from 2.0.0 to 2.0.1 [#2697](https://github.com/trento-project/web/pull/2697) ([dependabot](https://github.com/dependabot))
- Bump jaxxstorm/action-install-gh-release from 1.11.0 to 1.12.0 [#2635](https://github.com/trento-project/web/pull/2635) ([dependabot](https://github.com/dependabot))
- E2e check selection abilities [#2723](https://github.com/trento-project/web/pull/2723) ([arbulu89](https://github.com/arbulu89))
- Checks execution abilities [#2724](https://github.com/trento-project/web/pull/2724) ([CDimonaco](https://github.com/CDimonaco))
- Fixes DBConnection checkout related flakiness [#2731](https://github.com/trento-project/web/pull/2731) ([gagandeepb](https://github.com/gagandeepb))
- Fix non existent path [#2732](https://github.com/trento-project/web/pull/2732) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Cleanup abilities/permissions [#2734](https://github.com/trento-project/web/pull/2734) ([arbulu89](https://github.com/arbulu89))
- Activity log settings UI state [#2727](https://github.com/trento-project/web/pull/2727) ([balanza](https://github.com/balanza))
- Tags policy permissions [#2738](https://github.com/trento-project/web/pull/2738) ([CDimonaco](https://github.com/CDimonaco))
- Return CVEs from `Errata Details` endpoint [#2733](https://github.com/trento-project/web/pull/2733) ([jamie-suse](https://github.com/jamie-suse))
- Activity log endpoint [#2739](https://github.com/trento-project/web/pull/2739) ([gagandeepb](https://github.com/gagandeepb))
- Checks execution policy addendum [#2744](https://github.com/trento-project/web/pull/2744) ([CDimonaco](https://github.com/CDimonaco))
- Add cleanup abilities e2e tests [#2740](https://github.com/trento-project/web/pull/2740) ([arbulu89](https://github.com/arbulu89))
- Display CVEs and fixes in the advisory details page [#2735](https://github.com/trento-project/web/pull/2735) ([janvhs](https://github.com/janvhs))
- Check execution policy e2e tests [#2742](https://github.com/trento-project/web/pull/2742) ([CDimonaco](https://github.com/CDimonaco))
- Bump braces from 3.0.2 to 3.0.3 in /assets [#2695](https://github.com/trento-project/web/pull/2695) ([dependabot](https://github.com/dependabot))
- Bump ws from 6.2.2 to 6.2.3 in /assets [#2703](https://github.com/trento-project/web/pull/2703) ([dependabot](https://github.com/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.24.1 to 7.24.7 in /assets [#2748](https://github.com/trento-project/web/pull/2748) ([dependabot](https://github.com/dependabot))
- Bump @testing-library/react from 15.0.7 to 16.0.0 in /assets [#2749](https://github.com/trento-project/web/pull/2749) ([dependabot](https://github.com/dependabot))
- Tags abilities e2e tests [#2747](https://github.com/trento-project/web/pull/2747) ([CDimonaco](https://github.com/CDimonaco))
- ExistingTag component renamed to DeleteTagButton [#2754](https://github.com/trento-project/web/pull/2754) ([CDimonaco](https://github.com/CDimonaco))
- Minor css fixes for activity log settings [#2752](https://github.com/trento-project/web/pull/2752) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Validation global error [#2743](https://github.com/trento-project/web/pull/2743) ([balanza](https://github.com/balanza))
- Fix advisory details story [#2755](https://github.com/trento-project/web/pull/2755) ([dottorblaster](https://github.com/dottorblaster))
- Add sequence usage to factories [#2756](https://github.com/trento-project/web/pull/2756) ([dottorblaster](https://github.com/dottorblaster))
- Add sequences to table component's tests factories [#2759](https://github.com/trento-project/web/pull/2759) ([dottorblaster](https://github.com/dottorblaster))
- Activity Log settings e2e [#2753](https://github.com/trento-project/web/pull/2753) ([balanza](https://github.com/balanza))
- Bump rc-input-number from 9.0.0 to 9.1.0 in /assets [#2633](https://github.com/trento-project/web/pull/2633) ([dependabot](https://github.com/dependabot))
- Provide explicit ordering for CSV file columns [#2757](https://github.com/trento-project/web/pull/2757) ([jamie-suse](https://github.com/jamie-suse))
- Use uuids for usernames in user factory [#2762](https://github.com/trento-project/web/pull/2762) ([dottorblaster](https://github.com/dottorblaster))
- Bump eslint-plugin-react from 7.34.1 to 7.34.3 in /assets [#2764](https://github.com/trento-project/web/pull/2764) ([dependabot](https://github.com/dependabot))
- Add activity log default ordering by occurrence date [#2758](https://github.com/trento-project/web/pull/2758) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Discover angi architecture [#2761](https://github.com/trento-project/web/pull/2761) ([arbulu89](https://github.com/arbulu89))
- Add Persistent Activity Logger [#2730](https://github.com/trento-project/web/pull/2730) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add permissions to the Settings View [#2760](https://github.com/trento-project/web/pull/2760) ([EMaksy](https://github.com/EMaksy))
- Group abilities frontend [#2745](https://github.com/trento-project/web/pull/2745) ([arbulu89](https://github.com/arbulu89))
- Angi architecture frontend [#2766](https://github.com/trento-project/web/pull/2766) ([arbulu89](https://github.com/arbulu89))
- Affected packages [#2763](https://github.com/trento-project/web/pull/2763) ([janvhs](https://github.com/janvhs))
- Bump react-accessible-treeview from 2.9.0 to 2.9.1 in /assets [#2767](https://github.com/trento-project/web/pull/2767) ([dependabot](https://github.com/dependabot))
- Send HANA architecture to wanda [#2768](https://github.com/trento-project/web/pull/2768) ([arbulu89](https://github.com/arbulu89))
- Link to patch detail [#2741](https://github.com/trento-project/web/pull/2741) ([dottorblaster](https://github.com/dottorblaster))
- Bump @babel/preset-env from 7.24.5 to 7.24.8 in /assets [#2771](https://github.com/trento-project/web/pull/2771) ([dependabot](https://github.com/dependabot))
- Bump tailwindcss from 3.4.3 to 3.4.4 in /assets [#2737](https://github.com/trento-project/web/pull/2737) ([dependabot](https://github.com/dependabot))
- Fix typo in DeregistrationModal tests [#2765](https://github.com/trento-project/web/pull/2765) ([dottorblaster](https://github.com/dottorblaster))
- Expose id as part of an activity log entry [#2773](https://github.com/trento-project/web/pull/2773) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump eslint-plugin-jsx-a11y from 6.8.0 to 6.9.0 in /assets [#2778](https://github.com/trento-project/web/pull/2778) ([dependabot](https://github.com/dependabot))
- Bump @babel/core from 7.24.5 to 7.24.8 in /assets [#2777](https://github.com/trento-project/web/pull/2777) ([dependabot](https://github.com/dependabot))
- Bump axios from 1.6.8 to 1.7.2 in /assets [#2775](https://github.com/trento-project/web/pull/2775) ([dependabot](https://github.com/dependabot))
- Add e2e test for settings view to test abilities/permissions [#2772](https://github.com/trento-project/web/pull/2772) ([EMaksy](https://github.com/EMaksy))
- Angi architecture e2e tests and demo update [#2770](https://github.com/trento-project/web/pull/2770) ([arbulu89](https://github.com/arbulu89))
- Bump chart.js from 4.4.2 to 4.4.3 in /assets [#2781](https://github.com/trento-project/web/pull/2781) ([dependabot](https://github.com/dependabot))
- Fix navigation form relevant patches to advisory details [#2787](https://github.com/trento-project/web/pull/2787) ([janvhs](https://github.com/janvhs))
- Open api spex object refactor [#2780](https://github.com/trento-project/web/pull/2780) ([CDimonaco](https://github.com/CDimonaco))
- Bump @testing-library/jest-dom from 6.4.5 to 6.4.6 in /assets [#2782](https://github.com/trento-project/web/pull/2782) ([dependabot](https://github.com/dependabot))
- Suse manager settings refactor [#2788](https://github.com/trento-project/web/pull/2788) ([CDimonaco](https://github.com/CDimonaco))
- Bump @babel/core from 7.24.8 to 7.24.9 in /assets [#2790](https://github.com/trento-project/web/pull/2790) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-jest from 28.5.0 to 28.6.0 in /assets [#2784](https://github.com/trento-project/web/pull/2784) ([dependabot](https://github.com/dependabot))
- Bump esbuild from 0.22.0 to 0.23.0 in /assets [#2785](https://github.com/trento-project/web/pull/2785) ([dependabot](https://github.com/dependabot))
- Bump @heroicons/react from 2.1.3 to 2.1.5 in /assets [#2783](https://github.com/trento-project/web/pull/2783) ([dependabot](https://github.com/dependabot))
- Bump rc-input from 1.5.1 to 1.6.1 in /assets [#2794](https://github.com/trento-project/web/pull/2794) ([dependabot](https://github.com/dependabot))
- Bump tailwindcss from 3.4.4 to 3.4.6 in /assets [#2795](https://github.com/trento-project/web/pull/2795) ([dependabot](https://github.com/dependabot))
- Fix flickering in `Available Software Updates` panel [#2789](https://github.com/trento-project/web/pull/2789) ([jamie-suse](https://github.com/jamie-suse))
- Bump react-router-dom from 6.24.0 to 6.25.1 in /assets [#2796](https://github.com/trento-project/web/pull/2796) ([dependabot](https://github.com/dependabot))
- Bump postcss from 8.4.38 to 8.4.39 in /assets [#2800](https://github.com/trento-project/web/pull/2800) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.5.4 to 11.5.5 in /assets [#2802](https://github.com/trento-project/web/pull/2802) ([dependabot](https://github.com/dependabot))
- Bump rc-input-number from 9.1.0 to 9.2.0 in /assets [#2799](https://github.com/trento-project/web/pull/2799) ([dependabot](https://github.com/dependabot))
- Bump semver from 7.6.2 to 7.6.3 in /assets [#2797](https://github.com/trento-project/web/pull/2797) ([dependabot](https://github.com/dependabot))
- Add IP addresses netmask discovery and visualization [#2793](https://github.com/trento-project/web/pull/2793) ([arbulu89](https://github.com/arbulu89))
- Bump chromatic from 11.5.5 to 11.5.6 in /assets [#2807](https://github.com/trento-project/web/pull/2807) ([dependabot](https://github.com/dependabot))
- Activity log overview [#2769](https://github.com/trento-project/web/pull/2769) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @testing-library/jest-dom from 6.4.6 to 6.4.7 in /assets [#2811](https://github.com/trento-project/web/pull/2811) ([dependabot](https://github.com/dependabot))
- Bump docker/login-action from 3.2.0 to 3.3.0 [#2813](https://github.com/trento-project/web/pull/2813) ([dependabot](https://github.com/dependabot))
- Bump @babel/preset-react from 7.24.1 to 7.24.7 in /assets [#2810](https://github.com/trento-project/web/pull/2810) ([dependabot](https://github.com/dependabot))
- Bump rc-input from 1.6.1 to 1.6.2 in /assets [#2808](https://github.com/trento-project/web/pull/2808) ([dependabot](https://github.com/dependabot))
- Schedule activity log cleaning job [#2792](https://github.com/trento-project/web/pull/2792) ([balanza](https://github.com/balanza))
- Bump eslint-plugin-react from 7.34.3 to 7.35.0 in /assets [#2806](https://github.com/trento-project/web/pull/2806) ([dependabot](https://github.com/dependabot))
- Discover host vulnerabilities only if SUSE Manager is enabled [#2803](https://github.com/trento-project/web/pull/2803) ([dottorblaster](https://github.com/dottorblaster))
- Bump @testing-library/jest-dom from 6.4.7 to 6.4.8 in /assets [#2815](https://github.com/trento-project/web/pull/2815) ([dependabot](https://github.com/dependabot))
- Activity log page [#2774](https://github.com/trento-project/web/pull/2774) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump postcss from 8.4.39 to 8.4.40 in /assets [#2818](https://github.com/trento-project/web/pull/2818) ([dependabot](https://github.com/dependabot))
- Remove unused prop in `<Table />` component [#2824](https://github.com/trento-project/web/pull/2824) ([balanza](https://github.com/balanza))
- Upgrade to Storybook 8 [#2822](https://github.com/trento-project/web/pull/2822) ([dottorblaster](https://github.com/dottorblaster))
- Activity log pagination and filtering [#2786](https://github.com/trento-project/web/pull/2786) ([gagandeepb](https://github.com/gagandeepb))
- Refactor: move `<Filter />` component [#2823](https://github.com/trento-project/web/pull/2823) ([balanza](https://github.com/balanza))
- Bump tailwindcss from 3.4.6 to 3.4.7 in /assets [#2825](https://github.com/trento-project/web/pull/2825) ([dependabot](https://github.com/dependabot))
- Handle unexpected successful api response [#2827](https://github.com/trento-project/web/pull/2827) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @babel/preset-env from 7.24.8 to 7.25.0 in /assets [#2829](https://github.com/trento-project/web/pull/2829) ([dependabot](https://github.com/dependabot))
- Extend `AvailableSoftwareUpdates` to display arbitrary errors [#2821](https://github.com/trento-project/web/pull/2821) ([jamie-suse](https://github.com/jamie-suse))
- Upgrade to Phoenix 1.7 [#2831](https://github.com/trento-project/web/pull/2831) ([CDimonaco](https://github.com/CDimonaco))
- Address flakiness in Activity Log tests [#2836](https://github.com/trento-project/web/pull/2836) ([balanza](https://github.com/balanza))
- Add `<ComposedFilter />` component [#2834](https://github.com/trento-project/web/pull/2834) ([balanza](https://github.com/balanza))
- Default to activity type as a message for unrecognized activities [#2828](https://github.com/trento-project/web/pull/2828) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Suse Manager Settings - Frontend refactoring [#2819](https://github.com/trento-project/web/pull/2819) ([CDimonaco](https://github.com/CDimonaco))
- Bump @babel/core from 7.24.9 to 7.25.2 in /assets [#2838](https://github.com/trento-project/web/pull/2838) ([dependabot](https://github.com/dependabot))
- Discover SAP system running on a JAVA stack [#2820](https://github.com/trento-project/web/pull/2820) ([EMaksy](https://github.com/EMaksy))
- E2E tests for java system discovery [#2839](https://github.com/trento-project/web/pull/2839) ([EMaksy](https://github.com/EMaksy))
- Cluster Details Action Buttons Fixes [#2826](https://github.com/trento-project/web/pull/2826) ([jagabomb](https://github.com/jagabomb))
- Default admin check with username [#2840](https://github.com/trento-project/web/pull/2840) ([CDimonaco](https://github.com/CDimonaco))
- Add a global config variable to Storybook [#2842](https://github.com/trento-project/web/pull/2842) ([dottorblaster](https://github.com/dottorblaster))
- Bump chromatic from 11.5.6 to 11.7.0 in /assets [#2843](https://github.com/trento-project/web/pull/2843) ([dependabot](https://github.com/dependabot))
- Bump @babel/preset-env from 7.25.0 to 7.25.3 in /assets [#2844](https://github.com/trento-project/web/pull/2844) ([dependabot](https://github.com/dependabot))
- Pagination improvements, choice of items per page [#2832](https://github.com/trento-project/web/pull/2832) ([janvhs](https://github.com/janvhs))
- Fix schedule of `activity_log_cleaning` job [#2835](https://github.com/trento-project/web/pull/2835) ([balanza](https://github.com/balanza))
- E2E SUSE Manager integration [#2798](https://github.com/trento-project/web/pull/2798) ([dottorblaster](https://github.com/dottorblaster))
- Log domain events [#2817](https://github.com/trento-project/web/pull/2817) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @storybook/preview-api from 8.2.6 to 8.2.7 in /assets [#2847](https://github.com/trento-project/web/pull/2847) ([dependabot](https://github.com/dependabot))
- Bump @storybook/test from 8.2.6 to 8.2.7 in /assets [#2848](https://github.com/trento-project/web/pull/2848) ([dependabot](https://github.com/dependabot))
- Bump react-router-dom from 6.25.1 to 6.26.0 in /assets [#2845](https://github.com/trento-project/web/pull/2845) ([dependabot](https://github.com/dependabot))
- Bump axios from 1.7.2 to 1.7.3 in /assets [#2846](https://github.com/trento-project/web/pull/2846) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-jest from 28.6.0 to 28.7.0 in /assets [#2851](https://github.com/trento-project/web/pull/2851) ([dependabot](https://github.com/dependabot))
- Bump autoprefixer from 10.4.19 to 10.4.20 in /assets [#2850](https://github.com/trento-project/web/pull/2850) ([dependabot](https://github.com/dependabot))
- Fix items-per-page table footer's CSS [#2852](https://github.com/trento-project/web/pull/2852) ([dottorblaster](https://github.com/dottorblaster))
- Adjust filtering [#2853](https://github.com/trento-project/web/pull/2853) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Change format of ABAP JAVA system type in SapSystemOverview [#2855](https://github.com/trento-project/web/pull/2855) ([EMaksy](https://github.com/EMaksy))
- Bump postcss from 8.4.40 to 8.4.41 in /assets [#2861](https://github.com/trento-project/web/pull/2861) ([dependabot](https://github.com/dependabot))
- Log retention time changes [#2858](https://github.com/trento-project/web/pull/2858) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Domain events activity frontend [#2841](https://github.com/trento-project/web/pull/2841) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Map changes to activity log settings entries in the UI [#2862](https://github.com/trento-project/web/pull/2862) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Update Storybook Stories for `AvailableSoftwareUpdates` [#2857](https://github.com/trento-project/web/pull/2857) ([jamie-suse](https://github.com/jamie-suse))
- Fix cluster type tooltip message formatting [#2864](https://github.com/trento-project/web/pull/2864) ([EMaksy](https://github.com/EMaksy))
- Release/2.3.2 [#2872](https://github.com/trento-project/web/pull/2872) ([arbulu89](https://github.com/arbulu89))
- Add `<DateFilter >` component [#2849](https://github.com/trento-project/web/pull/2849) ([balanza](https://github.com/balanza))
- Bump @storybook/preview-api from 8.2.7 to 8.2.8 in /assets [#2878](https://github.com/trento-project/web/pull/2878) ([dependabot](https://github.com/dependabot))
- Bump rc-input from 1.6.2 to 1.6.3 in /assets [#2875](https://github.com/trento-project/web/pull/2875) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-jest from 28.7.0 to 28.8.0 in /assets [#2876](https://github.com/trento-project/web/pull/2876) ([dependabot](https://github.com/dependabot))
- Add date and time picker to `<DateFilter />` [#2867](https://github.com/trento-project/web/pull/2867) ([balanza](https://github.com/balanza))
- Advisory details fixes [#2873](https://github.com/trento-project/web/pull/2873) ([dottorblaster](https://github.com/dottorblaster))
- Expose info about existence of prev/next page [#2882](https://github.com/trento-project/web/pull/2882) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Remove id from CSV export [#2888](https://github.com/trento-project/web/pull/2888) ([janvhs](https://github.com/janvhs))
- Bump @storybook/test from 8.2.7 to 8.2.8 in /assets [#2885](https://github.com/trento-project/web/pull/2885) ([dependabot](https://github.com/dependabot))
- Bump tailwindcss from 3.4.7 to 3.4.9 in /assets [#2884](https://github.com/trento-project/web/pull/2884) ([dependabot](https://github.com/dependabot))
- Bump axios-mock-adapter from 1.22.0 to 2.0.0 in /assets [#2860](https://github.com/trento-project/web/pull/2860) ([dependabot](https://github.com/dependabot))
- Use `EOS_CHECK` icon [#2870](https://github.com/trento-project/web/pull/2870) ([balanza](https://github.com/balanza))
- Bump tailwindcss from 3.4.9 to 3.4.10 in /assets [#2897](https://github.com/trento-project/web/pull/2897) ([dependabot](https://github.com/dependabot))
- Bump axios from 1.7.3 to 1.7.4 in /assets [#2895](https://github.com/trento-project/web/pull/2895) ([dependabot](https://github.com/dependabot))
- Bump @storybook/preview-api from 8.2.8 to 8.2.9 in /assets [#2896](https://github.com/trento-project/web/pull/2896) ([dependabot](https://github.com/dependabot))
- Fix styling of relevant patches overview [#2889](https://github.com/trento-project/web/pull/2889) ([janvhs](https://github.com/janvhs))
- Bump @storybook/test from 8.2.8 to 8.2.9 in /assets [#2894](https://github.com/trento-project/web/pull/2894) ([dependabot](https://github.com/dependabot))
- Add labeling opportunity to `<Filter>` component [#2892](https://github.com/trento-project/web/pull/2892) ([balanza](https://github.com/balanza))
- Bump chromatic from 11.7.0 to 11.7.1 in /assets [#2900](https://github.com/trento-project/web/pull/2900) ([dependabot](https://github.com/dependabot))
- Update maintainer list in the PR env workflow [#2899](https://github.com/trento-project/web/pull/2899) ([balanza](https://github.com/balanza))
- Add filters to Activity log page [#2898](https://github.com/trento-project/web/pull/2898) ([balanza](https://github.com/balanza))
- Review CI job dependencies for faster execution. [#2901](https://github.com/trento-project/web/pull/2901) ([balanza](https://github.com/balanza))
- Swap filters position [#2909](https://github.com/trento-project/web/pull/2909) ([balanza](https://github.com/balanza))
- User management logs segregation [#2903](https://github.com/trento-project/web/pull/2903) ([gagandeepb](https://github.com/gagandeepb))
- Renaming PolicyHelper to AbilitiesHelper [#2910](https://github.com/trento-project/web/pull/2910) ([gagandeepb](https://github.com/gagandeepb))
- Fix E2E tests [#2911](https://github.com/trento-project/web/pull/2911) ([balanza](https://github.com/balanza))
- OIDC integration [#2905](https://github.com/trento-project/web/pull/2905) ([arbulu89](https://github.com/arbulu89))
- Bump react-router-dom from 6.26.0 to 6.26.1 in /assets [#2902](https://github.com/trento-project/web/pull/2902) ([dependabot](https://github.com/dependabot))
- Bump esbuild from 0.23.0 to 0.23.1 in /assets [#2904](https://github.com/trento-project/web/pull/2904) ([dependabot](https://github.com/dependabot))
- Fetch patches for packages only if list is populated [#2893](https://github.com/trento-project/web/pull/2893) ([dottorblaster](https://github.com/dottorblaster))
- Add oidc strategy in runtime [#2913](https://github.com/trento-project/web/pull/2913) ([arbulu89](https://github.com/arbulu89))
- Fix flacky UserPage test [#2914](https://github.com/trento-project/web/pull/2914) ([EMaksy](https://github.com/EMaksy))
- Add developer guide for oidc [#2907](https://github.com/trento-project/web/pull/2907) ([EMaksy](https://github.com/EMaksy))
- Bump @babel/preset-env from 7.25.3 to 7.25.4 in /assets [#2917](https://github.com/trento-project/web/pull/2917) ([dependabot](https://github.com/dependabot))
- Move `<Pagination>` component to dedicated folder [#2915](https://github.com/trento-project/web/pull/2915) ([balanza](https://github.com/balanza))
- Bump @testing-library/jest-dom from 6.4.8 to 6.5.0 in /assets [#2921](https://github.com/trento-project/web/pull/2921) ([dependabot](https://github.com/dependabot))
- Bump axios from 1.7.4 to 1.7.5 in /assets [#2919](https://github.com/trento-project/web/pull/2919) ([dependabot](https://github.com/dependabot))
- Bump chart.js from 4.4.3 to 4.4.4 in /assets [#2912](https://github.com/trento-project/web/pull/2912) ([dependabot](https://github.com/dependabot))
- Fix patches for packages' request too long [#2916](https://github.com/trento-project/web/pull/2916) ([dottorblaster](https://github.com/dottorblaster))
- Refactor pagination tests [#2923](https://github.com/trento-project/web/pull/2923) ([balanza](https://github.com/balanza))
- Refactor pagination tests [#2925](https://github.com/trento-project/web/pull/2925) ([balanza](https://github.com/balanza))
- Enhance `<Pagination>` component [#2918](https://github.com/trento-project/web/pull/2918) ([balanza](https://github.com/balanza))
- Bump qrcode.react from 3.1.0 to 4.0.0 in /assets [#2927](https://github.com/trento-project/web/pull/2927) ([dependabot](https://github.com/dependabot))
- Bump webpack from 5.76.1 to 5.94.0 in /test/e2e [#2928](https://github.com/trento-project/web/pull/2928) ([dependabot](https://github.com/dependabot))
- Bump webpack from 5.76.1 to 5.94.0 in /assets [#2929](https://github.com/trento-project/web/pull/2929) ([dependabot](https://github.com/dependabot))
- Bump qrcode.react from 4.0.0 to 4.0.1 in /assets [#2931](https://github.com/trento-project/web/pull/2931) ([dependabot](https://github.com/dependabot))
- Add `<PaginationPrevNext>` component [#2926](https://github.com/trento-project/web/pull/2926) ([balanza](https://github.com/balanza))
- Bump eslint-plugin-jest from 28.8.0 to 28.8.1 in /assets [#2933](https://github.com/trento-project/web/pull/2933) ([dependabot](https://github.com/dependabot))
- Bump @testing-library/react from 16.0.0 to 16.0.1 in /assets [#2932](https://github.com/trento-project/web/pull/2932) ([dependabot](https://github.com/dependabot))
- Bump postcss from 8.4.41 to 8.4.43 in /assets [#2936](https://github.com/trento-project/web/pull/2936) ([dependabot](https://github.com/dependabot))
- Bump axios from 1.7.5 to 1.7.7 in /assets [#2934](https://github.com/trento-project/web/pull/2934) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-jest from 28.8.1 to 28.8.2 in /assets [#2935](https://github.com/trento-project/web/pull/2935) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-react from 7.35.0 to 7.35.1 in /assets [#2937](https://github.com/trento-project/web/pull/2937) ([dependabot](https://github.com/dependabot))
- Bump postcss from 8.4.43 to 8.4.44 in /assets [#2938](https://github.com/trento-project/web/pull/2938) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-import from 2.29.1 to 2.30.0 in /assets [#2941](https://github.com/trento-project/web/pull/2941) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-jsx-a11y from 6.9.0 to 6.10.0 in /assets [#2942](https://github.com/trento-project/web/pull/2942) ([dependabot](https://github.com/dependabot))
- Bump @faker-js/faker from 8.4.1 to 9.0.0 in /assets [#2944](https://github.com/trento-project/web/pull/2944) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-jest from 28.8.2 to 28.8.3 in /assets [#2943](https://github.com/trento-project/web/pull/2943) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-react from 7.35.1 to 7.35.2 in /assets [#2940](https://github.com/trento-project/web/pull/2940) ([dependabot](https://github.com/dependabot))
- Bump postcss from 8.4.44 to 8.4.45 in /assets [#2945](https://github.com/trento-project/web/pull/2945) ([dependabot](https://github.com/dependabot))
- Fix advisory detail icon missing in advisory detail page [#2947](https://github.com/trento-project/web/pull/2947) ([dottorblaster](https://github.com/dottorblaster))
- Fix SUSE Manager settings CTA not showing up [#2952](https://github.com/trento-project/web/pull/2952) ([dottorblaster](https://github.com/dottorblaster))
- Filter out unnecessary options [#2946](https://github.com/trento-project/web/pull/2946) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump react-router-dom from 6.26.1 to 6.26.2 in /assets [#2955](https://github.com/trento-project/web/pull/2955) ([dependabot](https://github.com/dependabot))
- Oauth2 integration [#2953](https://github.com/trento-project/web/pull/2953) ([CDimonaco](https://github.com/CDimonaco))
- Fix scopes usage in runtime for oauth2 [#2956](https://github.com/trento-project/web/pull/2956) ([arbulu89](https://github.com/arbulu89))
- Bump chromatic from 11.7.1 to 11.8.0 in /assets [#2962](https://github.com/trento-project/web/pull/2962) ([dependabot](https://github.com/dependabot))
- E2E oauth2 integration [#2958](https://github.com/trento-project/web/pull/2958) ([arbulu89](https://github.com/arbulu89))
- Add default pagination values [#2961](https://github.com/trento-project/web/pull/2961) ([balanza](https://github.com/balanza))
- Bump send and express in /assets [#2963](https://github.com/trento-project/web/pull/2963) ([dependabot](https://github.com/dependabot))
- Refactor `<DateFilter>` [#2960](https://github.com/trento-project/web/pull/2960) ([balanza](https://github.com/balanza))
- Bump tailwindcss from 3.4.10 to 3.4.11 in /assets [#2973](https://github.com/trento-project/web/pull/2973) ([dependabot](https://github.com/dependabot))
- General Form Label Alignment Fixes [#2959](https://github.com/trento-project/web/pull/2959) ([jagabomb](https://github.com/jagabomb))
- Table Header Alignment [#2949](https://github.com/trento-project/web/pull/2949) ([jagabomb](https://github.com/jagabomb))
- Bump chromatic from 11.8.0 to 11.9.0 in /assets [#2970](https://github.com/trento-project/web/pull/2970) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.9.0 to 11.10.1 in /assets [#2976](https://github.com/trento-project/web/pull/2976) ([dependabot](https://github.com/dependabot))
- Activity log filter by user [#2924](https://github.com/trento-project/web/pull/2924) ([gagandeepb](https://github.com/gagandeepb))
- Filter out non-registered hosts from affected systems in SUMA patch [#2978](https://github.com/trento-project/web/pull/2978) ([dottorblaster](https://github.com/dottorblaster))
- Fix `<ComposedFilter>` behavior as controlled component [#2977](https://github.com/trento-project/web/pull/2977) ([balanza](https://github.com/balanza))
- Bump @storybook/test from 8.2.9 to 8.3.0 in /assets [#2971](https://github.com/trento-project/web/pull/2971) ([dependabot](https://github.com/dependabot))
- Bump @storybook/preview-api from 8.2.9 to 8.3.0 in /assets [#2969](https://github.com/trento-project/web/pull/2969) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-react from 7.35.2 to 7.36.1 in /assets [#2974](https://github.com/trento-project/web/pull/2974) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.10.1 to 11.10.2 in /assets [#2981](https://github.com/trento-project/web/pull/2981) ([dependabot](https://github.com/dependabot))
- Activity log add pagination (rework) [#2967](https://github.com/trento-project/web/pull/2967) ([balanza](https://github.com/balanza))
- Bump @faker-js/faker from 9.0.0 to 9.0.1 in /assets [#2980](https://github.com/trento-project/web/pull/2980) ([dependabot](https://github.com/dependabot))
- Fix typo [#2982](https://github.com/trento-project/web/pull/2982) ([balanza](https://github.com/balanza))
- Bump postcss from 8.4.45 to 8.4.47 in /assets [#2979](https://github.com/trento-project/web/pull/2979) ([dependabot](https://github.com/dependabot))
- Improve e2e test lint [#2984](https://github.com/trento-project/web/pull/2984) ([balanza](https://github.com/balanza))
- Adjust activity log columns width [#2986](https://github.com/trento-project/web/pull/2986) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Reset pagination when filter changes [#2983](https://github.com/trento-project/web/pull/2983) ([balanza](https://github.com/balanza))
- Adjust length of "Results per page"-field [#2968](https://github.com/trento-project/web/pull/2968) ([janvhs](https://github.com/janvhs))
- Bump @storybook/preview-api from 8.3.0 to 8.3.1 in /assets [#2991](https://github.com/trento-project/web/pull/2991) ([dependabot](https://github.com/dependabot))
- Bump @storybook/test from 8.3.0 to 8.3.1 in /assets [#2989](https://github.com/trento-project/web/pull/2989) ([dependabot](https://github.com/dependabot))
- Log host checks execution request [#2957](https://github.com/trento-project/web/pull/2957) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump babel-loader from 9.1.3 to 9.2.1 in /assets [#2990](https://github.com/trento-project/web/pull/2990) ([dependabot](https://github.com/dependabot))
- Bump tailwindcss from 3.4.11 to 3.4.12 in /assets [#2993](https://github.com/trento-project/web/pull/2993) ([dependabot](https://github.com/dependabot))
- Do not show page stats when data set is empty [#2994](https://github.com/trento-project/web/pull/2994) ([nelsonkopliku](https://github.com/nelsonkopliku))
- SAML integration [#2985](https://github.com/trento-project/web/pull/2985) ([arbulu89](https://github.com/arbulu89))
- Add first and last page button [#2987](https://github.com/trento-project/web/pull/2987) ([balanza](https://github.com/balanza))
- Implement first and last pagination buttons to Activity Log page [#2988](https://github.com/trento-project/web/pull/2988) ([balanza](https://github.com/balanza))
- Bump @storybook/preview-api from 8.3.1 to 8.3.2 in /assets [#3000](https://github.com/trento-project/web/pull/3000) ([dependabot](https://github.com/dependabot))
- Expose components retrieval by id [#2992](https://github.com/trento-project/web/pull/2992) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Improve domain event activity detection [#2998](https://github.com/trento-project/web/pull/2998) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Activity log metadata enrichment [#2996](https://github.com/trento-project/web/pull/2996) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Wire up MetadataEnricher [#2997](https://github.com/trento-project/web/pull/2997) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump react-select from 5.8.0 to 5.8.1 in /assets [#3003](https://github.com/trento-project/web/pull/3003) ([dependabot](https://github.com/dependabot))
- Bump @storybook/test from 8.3.1 to 8.3.2 in /assets [#3002](https://github.com/trento-project/web/pull/3002) ([dependabot](https://github.com/dependabot))
- Bump rc-tooltip from 6.2.0 to 6.2.1 in /assets [#3001](https://github.com/trento-project/web/pull/3001) ([dependabot](https://github.com/dependabot))
- Bump esbuild from 0.23.1 to 0.24.0 in /assets [#3008](https://github.com/trento-project/web/pull/3008) ([dependabot](https://github.com/dependabot))
- Bump isbang/compose-action from 2.0.1 to 2.0.2 [#3007](https://github.com/trento-project/web/pull/3007) ([dependabot](https://github.com/dependabot))
- SAML runtime operations [#2999](https://github.com/trento-project/web/pull/2999) ([arbulu89](https://github.com/arbulu89))
- Bump send and express in /assets [#3006](https://github.com/trento-project/web/pull/3006) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.10.2 to 11.10.3 in /assets [#3012](https://github.com/trento-project/web/pull/3012) ([dependabot](https://github.com/dependabot))
- Bump tailwindcss from 3.4.12 to 3.4.13 in /assets [#3013](https://github.com/trento-project/web/pull/3013) ([dependabot](https://github.com/dependabot))
- Enhance messages for tagging/untagging activities [#3019](https://github.com/trento-project/web/pull/3019) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @faker-js/faker from 9.0.1 to 9.0.2 in /assets [#3015](https://github.com/trento-project/web/pull/3015) ([dependabot](https://github.com/dependabot))
- Enable SAML messages signing [#2995](https://github.com/trento-project/web/pull/2995) ([arbulu89](https://github.com/arbulu89))
- SAML configurable attr fields [#3011](https://github.com/trento-project/web/pull/3011) ([arbulu89](https://github.com/arbulu89))
- Bump @storybook/preview-api from 8.3.2 to 8.3.3 in /assets [#3017](https://github.com/trento-project/web/pull/3017) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.10.3 to 11.10.4 in /assets [#3018](https://github.com/trento-project/web/pull/3018) ([dependabot](https://github.com/dependabot))
- Bump @storybook/test from 8.3.2 to 8.3.3 in /assets [#3023](https://github.com/trento-project/web/pull/3023) ([dependabot](https://github.com/dependabot))
- Add a refresh button to the Activity Log page [#3020](https://github.com/trento-project/web/pull/3020) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Table Component Rounded Corners Fix [#3010](https://github.com/trento-project/web/pull/3010) ([jagabomb](https://github.com/jagabomb))
- Add back scenario loading for Activity Log e2e [#3025](https://github.com/trento-project/web/pull/3025) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix pagination css glitch [#3024](https://github.com/trento-project/web/pull/3024) ([balanza](https://github.com/balanza))
- Bump @faker-js/faker from 9.0.2 to 9.0.3 in /assets [#3027](https://github.com/trento-project/web/pull/3027) ([dependabot](https://github.com/dependabot))
- Streamline Pagination [#3026](https://github.com/trento-project/web/pull/3026) ([nelsonkopliku](https://github.com/nelsonkopliku))
- No More Premium [#2869](https://github.com/trento-project/web/pull/2869) ([janvhs](https://github.com/janvhs))
- Improve Activity Log page request lifecycle [#3016](https://github.com/trento-project/web/pull/3016) ([balanza](https://github.com/balanza))
- Bump eslint-plugin-react from 7.36.1 to 7.37.0 in /assets [#3028](https://github.com/trento-project/web/pull/3028) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-storybook from 0.8.0 to 0.9.0 in /assets [#3029](https://github.com/trento-project/web/pull/3029) ([dependabot](https://github.com/dependabot))
- Bump @storybook/preview-api from 8.3.3 to 8.3.4 in /assets [#3033](https://github.com/trento-project/web/pull/3033) ([dependabot](https://github.com/dependabot))
- Bump @storybook/test from 8.3.3 to 8.3.4 in /assets [#3034](https://github.com/trento-project/web/pull/3034) ([dependabot](https://github.com/dependabot))
- Fix table overflow and pagination rounded border [#3031](https://github.com/trento-project/web/pull/3031) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Adds indexes [#3035](https://github.com/trento-project/web/pull/3035) ([gagandeepb](https://github.com/gagandeepb))
- Fix swagger ui action [#3032](https://github.com/trento-project/web/pull/3032) ([dottorblaster](https://github.com/dottorblaster))
- Bump chromatic from 11.10.4 to 11.11.0 in /assets [#3036](https://github.com/trento-project/web/pull/3036) ([dependabot](https://github.com/dependabot))
- Adjust maintainers in ci files [#3039](https://github.com/trento-project/web/pull/3039) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Do not expose level info for activity log entries [#3038](https://github.com/trento-project/web/pull/3038) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Clean up unused PageNumberPagination [#3030](https://github.com/trento-project/web/pull/3030) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump date-fns-tz from 3.1.3 to 3.2.0 in /assets [#3037](https://github.com/trento-project/web/pull/3037) ([dependabot](https://github.com/dependabot))
- Patches for packages alternative approach [#3005](https://github.com/trento-project/web/pull/3005) ([dottorblaster](https://github.com/dottorblaster))
- Bump eslint-plugin-react from 7.37.0 to 7.37.1 in /assets [#3041](https://github.com/trento-project/web/pull/3041) ([dependabot](https://github.com/dependabot))
- Raise an error during SAML init if decryption fails [#3021](https://github.com/trento-project/web/pull/3021) ([arbulu89](https://github.com/arbulu89))
- Bump @babel/core from 7.25.2 to 7.25.7 in /assets [#3046](https://github.com/trento-project/web/pull/3046) ([dependabot](https://github.com/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.24.8 to 7.25.7 in /assets [#3044](https://github.com/trento-project/web/pull/3044) ([dependabot](https://github.com/dependabot))
- Discarded discovery events to be recorded  [#3040](https://github.com/trento-project/web/pull/3040) ([balanza](https://github.com/balanza))
- Bump @babel/preset-react from 7.24.7 to 7.25.7 in /assets [#3043](https://github.com/trento-project/web/pull/3043) ([dependabot](https://github.com/dependabot))
- Bump @babel/preset-env from 7.25.4 to 7.25.7 in /assets [#3045](https://github.com/trento-project/web/pull/3045) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-import from 2.30.0 to 2.31.0 in /assets [#3048](https://github.com/trento-project/web/pull/3048) ([dependabot](https://github.com/dependabot))
- Bump @storybook/preview-api from 8.3.4 to 8.3.5 in /assets [#3051](https://github.com/trento-project/web/pull/3051) ([dependabot](https://github.com/dependabot))
- Bump @storybook/test from 8.3.4 to 8.3.5 in /assets [#3050](https://github.com/trento-project/web/pull/3050) ([dependabot](https://github.com/dependabot))
- Flaky test detection & analysis [#2809](https://github.com/trento-project/web/pull/2809) ([gagandeepb](https://github.com/gagandeepb))
- Bump chromatic from 11.11.0 to 11.12.0 in /assets [#3054](https://github.com/trento-project/web/pull/3054) ([dependabot](https://github.com/dependabot))
- SUSE Manager - Navigate from patch detail to previews pages [#3053](https://github.com/trento-project/web/pull/3053) ([dottorblaster](https://github.com/dottorblaster))
- Improve usability of select search on large options content [#3052](https://github.com/trento-project/web/pull/3052) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump chromatic from 11.12.0 to 11.12.5 in /assets [#3057](https://github.com/trento-project/web/pull/3057) ([dependabot](https://github.com/dependabot))
- Bump axios-mock-adapter from 2.0.0 to 2.1.0 in /assets [#3058](https://github.com/trento-project/web/pull/3058) ([dependabot](https://github.com/dependabot))
- Remove Phoenix.View and use the new Phoenix.Component structure [#3055](https://github.com/trento-project/web/pull/3055) ([EMaksy](https://github.com/EMaksy))
- Bump react-router-dom from 6.26.2 to 6.27.0 in /assets [#3065](https://github.com/trento-project/web/pull/3065) ([dependabot](https://github.com/dependabot))
- Add junit.xml to gitignore [#3060](https://github.com/trento-project/web/pull/3060) ([dottorblaster](https://github.com/dottorblaster))
- Updates jest config for Junit files [#3067](https://github.com/trento-project/web/pull/3067) ([gagandeepb](https://github.com/gagandeepb))
- Bump @babel/preset-env from 7.25.7 to 7.25.8 in /assets [#3064](https://github.com/trento-project/web/pull/3064) ([dependabot](https://github.com/dependabot))
- Bump @babel/core from 7.25.7 to 7.25.8 in /assets [#3063](https://github.com/trento-project/web/pull/3063) ([dependabot](https://github.com/dependabot))
- Adjust filters section in activity log [#3066](https://github.com/trento-project/web/pull/3066) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump tailwindcss from 3.4.13 to 3.4.14 in /assets [#3072](https://github.com/trento-project/web/pull/3072) ([dependabot](https://github.com/dependabot))
- Fix the loading spinner for related patches misbehaving [#3068](https://github.com/trento-project/web/pull/3068) ([dottorblaster](https://github.com/dottorblaster))
- Bump react-error-boundary from 4.0.13 to 4.1.0 in /assets [#3070](https://github.com/trento-project/web/pull/3070) ([dependabot](https://github.com/dependabot))
- Bump react-error-boundary from 4.1.0 to 4.1.1 in /assets [#3076](https://github.com/trento-project/web/pull/3076) ([dependabot](https://github.com/dependabot))
- Bump html-webpack-plugin from 5.6.0 to 5.6.2 in /assets [#3077](https://github.com/trento-project/web/pull/3077) ([dependabot](https://github.com/dependabot))
- Handle `associated_database_not_found` as accepted event. [#3074](https://github.com/trento-project/web/pull/3074) ([balanza](https://github.com/balanza))
- Bump chromatic from 11.12.5 to 11.12.6 in /assets [#3079](https://github.com/trento-project/web/pull/3079) ([dependabot](https://github.com/dependabot))
- Bump @testing-library/jest-dom from 6.5.0 to 6.6.2 in /assets [#3078](https://github.com/trento-project/web/pull/3078) ([dependabot](https://github.com/dependabot))
- Bump chart.js from 4.4.4 to 4.4.5 in /assets [#3071](https://github.com/trento-project/web/pull/3071) ([dependabot](https://github.com/dependabot))
- Bump @storybook/test from 8.3.5 to 8.3.6 in /assets [#3082](https://github.com/trento-project/web/pull/3082) ([dependabot](https://github.com/dependabot))
- Bump @storybook/preview-api from 8.3.5 to 8.3.6 in /assets [#3080](https://github.com/trento-project/web/pull/3080) ([dependabot](https://github.com/dependabot))
- Bump react-error-boundary from 4.1.1 to 4.1.2 in /assets [#3081](https://github.com/trento-project/web/pull/3081) ([dependabot](https://github.com/dependabot))
- Fix navigation still possible from host details to SUSE Manager pages in case of error [#3061](https://github.com/trento-project/web/pull/3061) ([dottorblaster](https://github.com/dottorblaster))
- Bump redux-mock-store from 1.5.4 to 1.5.5 in /assets [#3086](https://github.com/trento-project/web/pull/3086) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-jsx-a11y from 6.10.0 to 6.10.1 in /assets [#3089](https://github.com/trento-project/web/pull/3089) ([dependabot](https://github.com/dependabot))
- Update README.md [#3090](https://github.com/trento-project/web/pull/3090) ([stefanotorresi](https://github.com/stefanotorresi))
- Display active users only in Activity Log filter [#3084](https://github.com/trento-project/web/pull/3084) ([gagandeepb](https://github.com/gagandeepb))
- Bump eslint-plugin-storybook from 0.9.0 to 0.10.1 in /assets [#3087](https://github.com/trento-project/web/pull/3087) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.12.6 to 11.14.0 in /assets [#3088](https://github.com/trento-project/web/pull/3088) ([dependabot](https://github.com/dependabot))
- Bump qrcode.react from 4.0.1 to 4.1.0 in /assets [#3097](https://github.com/trento-project/web/pull/3097) ([dependabot](https://github.com/dependabot))
- Bump @babel/preset-env from 7.25.8 to 7.25.9 in /assets [#3096](https://github.com/trento-project/web/pull/3096) ([dependabot](https://github.com/dependabot))
- Bump @babel/preset-react from 7.25.7 to 7.25.9 in /assets [#3093](https://github.com/trento-project/web/pull/3093) ([dependabot](https://github.com/dependabot))
- Bump @babel/core from 7.25.8 to 7.25.9 in /assets [#3095](https://github.com/trento-project/web/pull/3095) ([dependabot](https://github.com/dependabot))
- Bump html-webpack-plugin from 5.6.2 to 5.6.3 in /assets [#3101](https://github.com/trento-project/web/pull/3101) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-react from 7.37.1 to 7.37.2 in /assets [#3099](https://github.com/trento-project/web/pull/3099) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.14.0 to 11.15.0 in /assets [#3100](https://github.com/trento-project/web/pull/3100) ([dependabot](https://github.com/dependabot))
- Fix SUSE Manager errors label computation [#3092](https://github.com/trento-project/web/pull/3092) ([dottorblaster](https://github.com/dottorblaster))
- Fix indicator tooltip presence even when unknown [#3103](https://github.com/trento-project/web/pull/3103) ([dottorblaster](https://github.com/dottorblaster))
- Second attempt to fix empty tooltip showing up in host details [#3104](https://github.com/trento-project/web/pull/3104) ([dottorblaster](https://github.com/dottorblaster))
- Change SAML_SP_DIR default location [#3102](https://github.com/trento-project/web/pull/3102) ([arbulu89](https://github.com/arbulu89))
- Bump @babel/core from 7.25.9 to 7.26.0 in /assets [#3107](https://github.com/trento-project/web/pull/3107) ([dependabot](https://github.com/dependabot))
- Bump @babel/preset-env from 7.25.9 to 7.26.0 in /assets [#3105](https://github.com/trento-project/web/pull/3105) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-jsx-a11y from 6.10.1 to 6.10.2 in /assets [#3108](https://github.com/trento-project/web/pull/3108) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.15.0 to 11.16.3 in /assets [#3110](https://github.com/trento-project/web/pull/3110) ([dependabot](https://github.com/dependabot))
- Reduce ClusterDetailsUpdated events [#3112](https://github.com/trento-project/web/pull/3112) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add username to activity log metadata on user deletion [#3091](https://github.com/trento-project/web/pull/3091) ([balanza](https://github.com/balanza))
- Add back the tooltip for SUSE Manager's unknown state [#3113](https://github.com/trento-project/web/pull/3113) ([dottorblaster](https://github.com/dottorblaster))
- Bump rc-input-number from 9.2.0 to 9.3.0 in /assets [#3118](https://github.com/trento-project/web/pull/3118) ([dependabot](https://github.com/dependabot))
- Bump @storybook/test from 8.3.6 to 8.4.2 in /assets [#3117](https://github.com/trento-project/web/pull/3117) ([dependabot](https://github.com/dependabot))
- Bump @testing-library/jest-dom from 6.6.2 to 6.6.3 in /assets [#3115](https://github.com/trento-project/web/pull/3115) ([dependabot](https://github.com/dependabot))
- Bump react-select from 5.8.1 to 5.8.2 in /assets [#3114](https://github.com/trento-project/web/pull/3114) ([dependabot](https://github.com/dependabot))
- Bump chromatic from 11.16.3 to 11.16.5 in /assets [#3121](https://github.com/trento-project/web/pull/3121) ([dependabot](https://github.com/dependabot))
- Upgrade to Storybook 8.4 [#3119](https://github.com/trento-project/web/pull/3119) ([dottorblaster](https://github.com/dottorblaster))
- Bump @faker-js/faker from 9.0.3 to 9.2.0 in /assets [#3124](https://github.com/trento-project/web/pull/3124) ([dependabot](https://github.com/dependabot))
- Add a button to download upgradable packages as CSV [#3098](https://github.com/trento-project/web/pull/3098) ([janvhs](https://github.com/janvhs))
- Add support for chained certificates [#3134](https://github.com/trento-project/web/pull/3134) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump chromatic from 11.16.5 to 11.18.0 in /assets [#3133](https://github.com/trento-project/web/pull/3133) ([dependabot](https://github.com/dependabot))
- Bump eslint-plugin-jest from 28.8.3 to 28.9.0 in /assets [#3130](https://github.com/trento-project/web/pull/3130) ([dependabot](https://github.com/dependabot))
- Bump react-accessible-treeview from 2.9.1 to 2.10.0 in /assets [#3120](https://github.com/trento-project/web/pull/3120) ([dependabot](https://github.com/dependabot))
- Bump react-router-dom from 6.27.0 to 6.28.0 in /assets [#3129](https://github.com/trento-project/web/pull/3129) ([dependabot](https://github.com/dependabot))
- Bump react-select from 5.8.2 to 5.8.3 in /assets [#3137](https://github.com/trento-project/web/pull/3137) ([dependabot](https://github.com/dependabot))
- Bump postcss from 8.4.47 to 8.4.48 in /assets [#3136](https://github.com/trento-project/web/pull/3136) ([dependabot](https://github.com/dependabot))
- Bump jaxxstorm/action-install-gh-release from 1.12.0 to 1.13.0 [#3138](https://github.com/trento-project/web/pull/3138) ([dependabot](https://github.com/dependabot))
- Bump chart.js from 4.4.5 to 4.4.6 in /assets [#3128](https://github.com/trento-project/web/pull/3128) ([dependabot](https://github.com/dependabot))
- Sort csv content by alphabet [#3135](https://github.com/trento-project/web/pull/3135) ([EMaksy](https://github.com/EMaksy))
- Bump `photofinish` to v1.4.1 [#3139](https://github.com/trento-project/web/pull/3139) ([balanza](https://github.com/balanza))
- Bump postcss from 8.4.48 to 8.4.49 in /assets [#3141](https://github.com/trento-project/web/pull/3141) ([dependabot](https://github.com/dependabot))

## [2.3.2](https://github.com/trento-project/web/tree/2.3.2) (2024-07-24)

[Full Changelog](https://github.com/trento-project/web/compare/2.3.1...2.3.2)

**Fixed bugs:**

- Fix process manager rename [#2814](https://github.com/trento-project/web/pull/2814) ([arbulu89](https://github.com/arbulu89))

## [2.3.1](https://github.com/trento-project/web/tree/2.3.1) (2024-06-10)

[Full Changelog](https://github.com/trento-project/web/compare/2.3.0...2.3.1)

**Fixed bugs:**

- Default empty string for smtp server [#2681](https://github.com/trento-project/web/pull/2681) ([CDimonaco](https://github.com/CDimonaco))
- Fix SAP systems policy receiving an empty list of instances [#2677](https://github.com/trento-project/web/pull/2677) ([dottorblaster](https://github.com/dottorblaster))
- Fix SMTP usage in runtime configuration [#2675](https://github.com/trento-project/web/pull/2675) ([CDimonaco](https://github.com/CDimonaco))
- Fix Websocket usage with https [#2671](https://github.com/trento-project/web/pull/2671) ([CDimonaco](https://github.com/CDimonaco))
- Make discovery payload nullable in schema [#2638](https://github.com/trento-project/web/pull/2638) ([arbulu89](https://github.com/arbulu89))

**Merged pull requests:**

- Rename `TRENTO_DOMAIN` to `TRENTO_WEB_ORIGIN` [#2682](https://github.com/trento-project/web/pull/2682) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Allow to continue when cert-manager has already been installed in the CI [#2680](https://github.com/trento-project/web/pull/2680) ([rtorrero](https://github.com/rtorrero))
- Fix misspelling of resource in a test [#2678](https://github.com/trento-project/web/pull/2678) ([dottorblaster](https://github.com/dottorblaster))
- Add HTTPS using cert-manager for demo env [#2632](https://github.com/trento-project/web/pull/2632) ([rtorrero](https://github.com/rtorrero))

## [2.3.0](https://github.com/trento-project/web/tree/2.3.0) (2024-05-22)

[Full Changelog](https://github.com/trento-project/web/compare/2.2.0...2.3.0)

**Implemented enhancements:**

- Require elixir>=1.15 in dockerfiles [#2644](https://github.com/trento-project/web/pull/2644) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Pin erlang version to 26.2.1 [#2641](https://github.com/trento-project/web/pull/2641) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Specify elixir version >= 1.15 in rpm spec [#2639](https://github.com/trento-project/web/pull/2639) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Use plain string certificates [#2596](https://github.com/trento-project/web/pull/2596) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Make SUSE Manager section in Host Details page reactive [#2593](https://github.com/trento-project/web/pull/2593) ([jamie-suse](https://github.com/jamie-suse))
- Validation of CA certificate inside SUSE Manager settings [#2581](https://github.com/trento-project/web/pull/2581) ([dottorblaster](https://github.com/dottorblaster))
- Read tracked software updates discoveries [#2561](https://github.com/trento-project/web/pull/2561) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Avoid SUMA health complete on settings not configured error [#2547](https://github.com/trento-project/web/pull/2547) ([arbulu89](https://github.com/arbulu89))
- Fix hana scale out no hooks [#2541](https://github.com/trento-project/web/pull/2541) ([arbulu89](https://github.com/arbulu89))
- Track software update discoveries [#2540](https://github.com/trento-project/web/pull/2540) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Extend error handling of `AvailableSoftwareUpdates` component [#2538](https://github.com/trento-project/web/pull/2538) ([jamie-suse](https://github.com/jamie-suse))
- Adjust suma timeouts [#2535](https://github.com/trento-project/web/pull/2535) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Deregister sap system on tenant removal [#2534](https://github.com/trento-project/web/pull/2534) ([arbulu89](https://github.com/arbulu89))
- Asynchronously run software updates discovery when applying settings [#2533](https://github.com/trento-project/web/pull/2533) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Handle software updates discovery errors [#2532](https://github.com/trento-project/web/pull/2532) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Improve suma authentication concurrency [#2531](https://github.com/trento-project/web/pull/2531) ([arbulu89](https://github.com/arbulu89))
- Change `software_updates_discovery_health` default value [#2528](https://github.com/trento-project/web/pull/2528) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Parallelize SUMA queries using ParallelStream [#2525](https://github.com/trento-project/web/pull/2525) ([arbulu89](https://github.com/arbulu89))
- Multi tenant support [#2523](https://github.com/trento-project/web/pull/2523) ([arbulu89](https://github.com/arbulu89))
- Issue software updates discoveries on save/change settings [#2519](https://github.com/trento-project/web/pull/2519) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Software updates event handler [#2515](https://github.com/trento-project/web/pull/2515) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add intermediate confirmation step in ApiKeySettingsModal [#2514](https://github.com/trento-project/web/pull/2514) ([CDimonaco](https://github.com/CDimonaco))
- Handle requests for software updates discoveries from Host aggregate [#2507](https://github.com/trento-project/web/pull/2507) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add initiation for software updates discovery process [#2498](https://github.com/trento-project/web/pull/2498) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add CopyButton component [#2476](https://github.com/trento-project/web/pull/2476) ([CDimonaco](https://github.com/CDimonaco))
- Dynamic catalog filters [#2475](https://github.com/trento-project/web/pull/2475) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Update Redux Toolkit to version 2.0 [#2471](https://github.com/trento-project/web/pull/2471) ([jamie-suse](https://github.com/jamie-suse))
- Make `Software Updates` service handle no SUMA settings saved [#2457](https://github.com/trento-project/web/pull/2457) ([jamie-suse](https://github.com/jamie-suse))
- Display errors in SUSE Manager settings form [#2455](https://github.com/trento-project/web/pull/2455) ([dottorblaster](https://github.com/dottorblaster))
- Test suma connection UI [#2453](https://github.com/trento-project/web/pull/2453) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add a test suma connection endpoint [#2444](https://github.com/trento-project/web/pull/2444) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Clear software updates discovered health on host deregistration [#2436](https://github.com/trento-project/web/pull/2436) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Display SUMA updates in Host Details page [#2430](https://github.com/trento-project/web/pull/2430) ([jamie-suse](https://github.com/jamie-suse))
- Add Redux Sagas for getting SUSE Manager software updates [#2416](https://github.com/trento-project/web/pull/2416) ([jamie-suse](https://github.com/jamie-suse))
- Endpoint available software updates [#2415](https://github.com/trento-project/web/pull/2415) ([dottorblaster](https://github.com/dottorblaster))
- Refactor Banner component [#2409](https://github.com/trento-project/web/pull/2409) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Api Key settings frontend [#2403](https://github.com/trento-project/web/pull/2403) ([CDimonaco](https://github.com/CDimonaco))
- Clear suma discoveries [#2394](https://github.com/trento-project/web/pull/2394) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Clear suma discovery domain [#2393](https://github.com/trento-project/web/pull/2393) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add ability to provide a CA cert when making requests to SUMA [#2391](https://github.com/trento-project/web/pull/2391) ([jamie-suse](https://github.com/jamie-suse))
- Add wrap prop to tooltip [#2389](https://github.com/trento-project/web/pull/2389) ([dottorblaster](https://github.com/dottorblaster))
- Api key expiration frontend notifications [#2388](https://github.com/trento-project/web/pull/2388) ([CDimonaco](https://github.com/CDimonaco))
- Add empty state to sbd details [#2387](https://github.com/trento-project/web/pull/2387) ([EMaksy](https://github.com/EMaksy))
- Add a clear operation to suma service [#2386](https://github.com/trento-project/web/pull/2386) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add Api key expiration checking routine [#2384](https://github.com/trento-project/web/pull/2384) ([CDimonaco](https://github.com/CDimonaco))
- Handle failing authentication [#2382](https://github.com/trento-project/web/pull/2382) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Redact sensitive data in SUMA GenServer state [#2381](https://github.com/trento-project/web/pull/2381) ([jamie-suse](https://github.com/jamie-suse))
- Add the ability to get relevant patches given a SUMA system ID [#2378](https://github.com/trento-project/web/pull/2378) ([jamie-suse](https://github.com/jamie-suse))
- VMware Logo Update [#2377](https://github.com/trento-project/web/pull/2377) ([jagabomb](https://github.com/jagabomb))
- Add a scheduled software updates discovery job [#2376](https://github.com/trento-project/web/pull/2376) ([nelsonkopliku](https://github.com/nelsonkopliku))
- JWT Api Key [#2371](https://github.com/trento-project/web/pull/2371) ([CDimonaco](https://github.com/CDimonaco))
- Add expect enum usage [#2370](https://github.com/trento-project/web/pull/2370) ([arbulu89](https://github.com/arbulu89))
- Change host's health based on software updates discovery result [#2368](https://github.com/trento-project/web/pull/2368) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add `managed` field in Cluster resources [#2366](https://github.com/trento-project/web/pull/2366) ([rtorrero](https://github.com/rtorrero))
- Add missing timestamps to ecto schemas [#2365](https://github.com/trento-project/web/pull/2365) ([CDimonaco](https://github.com/CDimonaco))
- Integrate suma get system id [#2363](https://github.com/trento-project/web/pull/2363) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add flag for "SUSE Manager config enabled" [#2362](https://github.com/trento-project/web/pull/2362) ([jamie-suse](https://github.com/jamie-suse))
- Change KVM provider label to "on-premise / KVM" [#2358](https://github.com/trento-project/web/pull/2358) ([jamie-suse](https://github.com/jamie-suse))
- Openapi schemas no additional properties [#2355](https://github.com/trento-project/web/pull/2355) ([CDimonaco](https://github.com/CDimonaco))
- Add `Clear Software Updates settings` Saga [#2346](https://github.com/trento-project/web/pull/2346) ([jamie-suse](https://github.com/jamie-suse))
- Cluster node status frontend [#2345](https://github.com/trento-project/web/pull/2345) ([arbulu89](https://github.com/arbulu89))
- Cluster node status [#2341](https://github.com/trento-project/web/pull/2341) ([arbulu89](https://github.com/arbulu89))
- Add SUSE Manager `Clear Settings` dialog [#2339](https://github.com/trento-project/web/pull/2339) ([jamie-suse](https://github.com/jamie-suse))
- Implement sagas for save and upsate of SUMA settings [#2338](https://github.com/trento-project/web/pull/2338) ([dottorblaster](https://github.com/dottorblaster))
- Add header prop to table [#2337](https://github.com/trento-project/web/pull/2337) ([arbulu89](https://github.com/arbulu89))
- Cluster details updates [#2328](https://github.com/trento-project/web/pull/2328) ([rtorrero](https://github.com/rtorrero))
- Fetch credentials and feed SUMA Config [#2326](https://github.com/trento-project/web/pull/2326) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Initial software updates settings state and saga [#2318](https://github.com/trento-project/web/pull/2318) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Handle concurrent settings saving operations [#2317](https://github.com/trento-project/web/pull/2317) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add network operations for SUMA credentials [#2312](https://github.com/trento-project/web/pull/2312) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Indexserver & nameserver roles in cluster sites [#2311](https://github.com/trento-project/web/pull/2311) ([CDimonaco](https://github.com/CDimonaco))
- Add support to PATCH requests in network client [#2310](https://github.com/trento-project/web/pull/2310) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add hana diskless sbd scenario [#2309](https://github.com/trento-project/web/pull/2309) ([arbulu89](https://github.com/arbulu89))
- Discover diskless SBD clusters [#2308](https://github.com/trento-project/web/pull/2308) ([arbulu89](https://github.com/arbulu89))
- Add an error property to inputs for user feedback [#2307](https://github.com/trento-project/web/pull/2307) ([dottorblaster](https://github.com/dottorblaster))
- Add endpoint to update SUSE Manager credentials [#2306](https://github.com/trento-project/web/pull/2306) ([jamie-suse](https://github.com/jamie-suse))
- Add SUSE Manager settings dialog component [#2300](https://github.com/trento-project/web/pull/2300) ([dottorblaster](https://github.com/dottorblaster))
- Add Label component [#2298](https://github.com/trento-project/web/pull/2298) ([dottorblaster](https://github.com/dottorblaster))
- Cluster maintenance mode [#2297](https://github.com/trento-project/web/pull/2297) ([CDimonaco](https://github.com/CDimonaco))
- Hana details other site nodes [#2296](https://github.com/trento-project/web/pull/2296) ([arbulu89](https://github.com/arbulu89))
- Hana scale out scenario for photofinish [#2291](https://github.com/trento-project/web/pull/2291) ([arbulu89](https://github.com/arbulu89))
- Validate ca_cert when it was provided different than null [#2290](https://github.com/trento-project/web/pull/2290) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Hana details sites frontend [#2278](https://github.com/trento-project/web/pull/2278) ([arbulu89](https://github.com/arbulu89))
- Hana cluster find sites [#2277](https://github.com/trento-project/web/pull/2277) ([arbulu89](https://github.com/arbulu89))
- Add change settings feature to software updates [#2273](https://github.com/trento-project/web/pull/2273) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add endpoint to clear SUMA credentials [#2272](https://github.com/trento-project/web/pull/2272) ([jamie-suse](https://github.com/jamie-suse))
- Add endpoint to save SUMA credentials [#2271](https://github.com/trento-project/web/pull/2271) ([jamie-suse](https://github.com/jamie-suse))
- Add clear settings feature to software updates [#2263](https://github.com/trento-project/web/pull/2263) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Apply software updates settings [#2259](https://github.com/trento-project/web/pull/2259) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add endpoint to retrieve software update settings [#2250](https://github.com/trento-project/web/pull/2250) ([jamie-suse](https://github.com/jamie-suse))
- Add ability to read software update settings [#2248](https://github.com/trento-project/web/pull/2248) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add SUSE Manager config component [#2247](https://github.com/trento-project/web/pull/2247) ([dottorblaster](https://github.com/dottorblaster))
- Add software updates settings schema [#2234](https://github.com/trento-project/web/pull/2234) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Button type danger [#2232](https://github.com/trento-project/web/pull/2232) ([dottorblaster](https://github.com/dottorblaster))
- Updated logo assets [#2229](https://github.com/trento-project/web/pull/2229) ([jagabomb](https://github.com/jagabomb))
- Hana scale out discovery [#2220](https://github.com/trento-project/web/pull/2220) ([arbulu89](https://github.com/arbulu89))
- Input fields [#2213](https://github.com/trento-project/web/pull/2213) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add ability to encrypt and decrypt plain content [#2212](https://github.com/trento-project/web/pull/2212) ([jamie-suse](https://github.com/jamie-suse))
- Project host FQDN [#2204](https://github.com/trento-project/web/pull/2204) ([dottorblaster](https://github.com/dottorblaster))
- Elixir upgrade dockerfiles [#2196](https://github.com/trento-project/web/pull/2196) ([arbulu89](https://github.com/arbulu89))
- Upgrade elixir 1.15.7 otp 26 [#2186](https://github.com/trento-project/web/pull/2186) ([arbulu89](https://github.com/arbulu89))
- Add ENSA version info to Checks execution [#2177](https://github.com/trento-project/web/pull/2177) ([jamie-suse](https://github.com/jamie-suse))
- Differentiate env build between HANA and ASCS/ERS cluster details [#2176](https://github.com/trento-project/web/pull/2176) ([dottorblaster](https://github.com/dottorblaster))
- Remove Reset Filters button in Checks selection [#2154](https://github.com/trento-project/web/pull/2154) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Enable/disable charts feature [#2147](https://github.com/trento-project/web/pull/2147) ([CDimonaco](https://github.com/CDimonaco))
- Send filesystem type to Wanda [#2126](https://github.com/trento-project/web/pull/2126) ([dottorblaster](https://github.com/dottorblaster))
- New catalog error state [#2093](https://github.com/trento-project/web/pull/2093) ([dottorblaster](https://github.com/dottorblaster))
- Catalog empty state new illustration [#2091](https://github.com/trento-project/web/pull/2091) ([dottorblaster](https://github.com/dottorblaster))
- Provide ENSA version info to Wanda [#2088](https://github.com/trento-project/web/pull/2088) ([jamie-suse](https://github.com/jamie-suse))
- New empty state for catalog [#2079](https://github.com/trento-project/web/pull/2079) ([dottorblaster](https://github.com/dottorblaster))
- Aggregated target health does not take into account checks selection status [#2050](https://github.com/trento-project/web/pull/2050) ([jamie-suse](https://github.com/jamie-suse))
- Charts Without Grafana [#2049](https://github.com/trento-project/web/pull/2049) ([CDimonaco](https://github.com/CDimonaco))
- Improved catalog filtering [#2035](https://github.com/trento-project/web/pull/2035) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix leftover Domain.SapSystem [#2030](https://github.com/trento-project/web/pull/2030) ([arbulu89](https://github.com/arbulu89))
- Interdependent catalog filters [#2028](https://github.com/trento-project/web/pull/2028) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Context extraction from infra [#2027](https://github.com/trento-project/web/pull/2027) ([CDimonaco](https://github.com/CDimonaco))
- Refactor remaining leftovers [#2026](https://github.com/trento-project/web/pull/2026) ([arbulu89](https://github.com/arbulu89))
- Infrastructure context [#2022](https://github.com/trento-project/web/pull/2022) ([CDimonaco](https://github.com/CDimonaco))
- Sapsystems context [#2021](https://github.com/trento-project/web/pull/2021) ([arbulu89](https://github.com/arbulu89))
- Hosts context [#2017](https://github.com/trento-project/web/pull/2017) ([arbulu89](https://github.com/arbulu89))
- Generic selection component [#2013](https://github.com/trento-project/web/pull/2013) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Use catalog API version 2 [#2010](https://github.com/trento-project/web/pull/2010) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Extend Catalog filtering [#2009](https://github.com/trento-project/web/pull/2009) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Supersede events [#2006](https://github.com/trento-project/web/pull/2006) ([arbulu89](https://github.com/arbulu89))
- ASCS/ERS checks [#2003](https://github.com/trento-project/web/pull/2003) ([dottorblaster](https://github.com/dottorblaster))
- Tags context [#2002](https://github.com/trento-project/web/pull/2002) ([arbulu89](https://github.com/arbulu89))
- Iconify check's target type in catalog [#1998](https://github.com/trento-project/web/pull/1998) ([nelsonkopliku](https://github.com/nelsonkopliku))

**Fixed bugs:**

- Fix SUMA settings error handling [#2610](https://github.com/trento-project/web/pull/2610) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Properly clear suma genserver state when clearing software updates settings [#2530](https://github.com/trento-project/web/pull/2530) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add a generate sid function and fix bug [#2526](https://github.com/trento-project/web/pull/2526) ([EMaksy](https://github.com/EMaksy))
- Fix empty relevant patches visualization [#2520](https://github.com/trento-project/web/pull/2520) ([arbulu89](https://github.com/arbulu89))
- Api key Expiration Label fix [#2495](https://github.com/trento-project/web/pull/2495) ([CDimonaco](https://github.com/CDimonaco))
- Fix checking existence of certain checks in the catalog [#2494](https://github.com/trento-project/web/pull/2494) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix suma url overlap [#2488](https://github.com/trento-project/web/pull/2488) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix suma ca cert options [#2487](https://github.com/trento-project/web/pull/2487) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix incorrect alias in database value object [#2478](https://github.com/trento-project/web/pull/2478) ([arbulu89](https://github.com/arbulu89))
- Fix typespec for `get software updates` service [#2464](https://github.com/trento-project/web/pull/2464) ([jamie-suse](https://github.com/jamie-suse))
- Fix Start Execution button margin in checks execution [#2443](https://github.com/trento-project/web/pull/2443) ([dottorblaster](https://github.com/dottorblaster))
- Fix start execution button height [#2435](https://github.com/trento-project/web/pull/2435) ([dottorblaster](https://github.com/dottorblaster))
- Don't return error when deleting non-existent CA cert file [#2395](https://github.com/trento-project/web/pull/2395) ([jamie-suse](https://github.com/jamie-suse))
- Fix :nxdomain crashing when SMTP server was wrongly set up [#2369](https://github.com/trento-project/web/pull/2369) ([dottorblaster](https://github.com/dottorblaster))
- Fix software updates patching idempotency [#2354](https://github.com/trento-project/web/pull/2354) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix HostDetails story [#2320](https://github.com/trento-project/web/pull/2320) ([arbulu89](https://github.com/arbulu89))
- Fix charts tests increasing prometheus retention time in dev docker compose [#2246](https://github.com/trento-project/web/pull/2246) ([arbulu89](https://github.com/arbulu89))
- Fix ENSA version calculation [#2222](https://github.com/trento-project/web/pull/2222) ([jamie-suse](https://github.com/jamie-suse))
- Fix required fields usage [#2214](https://github.com/trento-project/web/pull/2214) ([arbulu89](https://github.com/arbulu89))
- Fix playbook usage in pr_env [#2195](https://github.com/trento-project/web/pull/2195) ([CDimonaco](https://github.com/CDimonaco))
- Rename node exporter service in compose file for cross docker version compatibility [#2145](https://github.com/trento-project/web/pull/2145) ([CDimonaco](https://github.com/CDimonaco))
- Fix ascs ers detection in checks selection [#2144](https://github.com/trento-project/web/pull/2144) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Run `run-photofinish-demo-env` job when receiving `demo-deploy` action [#2029](https://github.com/trento-project/web/pull/2029) ([jamie-suse](https://github.com/jamie-suse))
- Deploy to demo env when receives `deploy-demo` action from `wanda` [#2025](https://github.com/trento-project/web/pull/2025) ([jamie-suse](https://github.com/jamie-suse))
- Ensure event modules are loaded during deserialization [#2020](https://github.com/trento-project/web/pull/2020) ([arbulu89](https://github.com/arbulu89))

**Merged pull requests:**

- Update alerting.md [#2629](https://github.com/trento-project/web/pull/2629) ([stefanotorresi](https://github.com/stefanotorresi))
- Release 2.3.0 [#2621](https://github.com/trento-project/web/pull/2621) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump semver from 7.6.1 to 7.6.2 in /assets [#2617](https://github.com/trento-project/web/pull/2617) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 11.3.0 to 11.3.2 in /assets [#2614](https://github.com/trento-project/web/pull/2614) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump semver from 7.6.0 to 7.6.1 in /assets [#2606](https://github.com/trento-project/web/pull/2606) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/react from 15.0.6 to 15.0.7 in /assets [#2604](https://github.com/trento-project/web/pull/2604) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.21.0 to 0.21.1 in /assets [#2603](https://github.com/trento-project/web/pull/2603) ([dependabot[bot]](https://github.com/apps/dependabot))
- Ensure SUMA related controllers return 403 when credentials were not set [#2602](https://github.com/trento-project/web/pull/2602) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump esbuild from 0.20.2 to 0.21.0 in /assets [#2598](https://github.com/trento-project/web/pull/2598) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update installation instructions [#2594](https://github.com/trento-project/web/pull/2594) ([janvhs](https://github.com/janvhs))
- Bump @testing-library/jest-dom from 6.4.2 to 6.4.5 in /assets [#2589](https://github.com/trento-project/web/pull/2589) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 28.3.0 to 28.5.0 in /assets [#2585](https://github.com/trento-project/web/pull/2585) ([dependabot[bot]](https://github.com/apps/dependabot))
- Manage npm dependencies [#2582](https://github.com/trento-project/web/pull/2582) ([janvhs](https://github.com/janvhs))
- Bump @testing-library/react from 15.0.5 to 15.0.6 in /assets [#2580](https://github.com/trento-project/web/pull/2580) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove package-lock.json in main dir [#2575](https://github.com/trento-project/web/pull/2575) ([dottorblaster](https://github.com/dottorblaster))
- Bump ejs from 3.1.9 to 3.1.10 in /assets [#2574](https://github.com/trento-project/web/pull/2574) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.8.3 to 2.9.0 in /assets [#2572](https://github.com/trento-project/web/pull/2572) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.22.3 to 6.23.0 in /assets [#2570](https://github.com/trento-project/web/pull/2570) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.24.4 to 7.24.5 in /assets [#2569](https://github.com/trento-project/web/pull/2569) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove "SUSE Manager connection failed" error message [#2567](https://github.com/trento-project/web/pull/2567) ([jamie-suse](https://github.com/jamie-suse))
- Bump @babel/core from 7.24.4 to 7.24.5 in /assets [#2565](https://github.com/trento-project/web/pull/2565) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react-hooks from 4.6.0 to 4.6.2 in /assets [#2564](https://github.com/trento-project/web/pull/2564) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/react from 15.0.4 to 15.0.5 in /assets [#2562](https://github.com/trento-project/web/pull/2562) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove `DiscoverSoftwareUpdates` command [#2560](https://github.com/trento-project/web/pull/2560) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump eslint-plugin-jest from 28.2.0 to 28.3.0 in /assets [#2559](https://github.com/trento-project/web/pull/2559) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-dom from 18.2.0 to 18.3.1 in /assets [#2557](https://github.com/trento-project/web/pull/2557) ([dependabot[bot]](https://github.com/apps/dependabot))
- Change the tooltip message for SUMA's fallback scenario [#2555](https://github.com/trento-project/web/pull/2555) ([dottorblaster](https://github.com/dottorblaster))
- Bump tar and npm in /test/e2e [#2554](https://github.com/trento-project/web/pull/2554) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add factories to eslint dev list [#2551](https://github.com/trento-project/web/pull/2551) ([arbulu89](https://github.com/arbulu89))
- Bump @testing-library/react from 15.0.2 to 15.0.4 in /assets [#2546](https://github.com/trento-project/web/pull/2546) ([dependabot[bot]](https://github.com/apps/dependabot))
- Raise when waiting for tasks completion times out [#2537](https://github.com/trento-project/web/pull/2537) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add missed permission check [#2527](https://github.com/trento-project/web/pull/2527) ([rtorrero](https://github.com/rtorrero))
- Bump @headlessui/react from 1.7.18 to 1.7.19 in /assets [#2522](https://github.com/trento-project/web/pull/2522) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix fqdn nil transition on host restoration and host detail changes [#2518](https://github.com/trento-project/web/pull/2518) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @testing-library/react from 14.2.2 to 15.0.2 in /assets [#2517](https://github.com/trento-project/web/pull/2517) ([dependabot[bot]](https://github.com/apps/dependabot))
- Removed eula popup notification [#2512](https://github.com/trento-project/web/pull/2512) ([chrisb1s](https://github.com/chrisb1s))
- Bump tar from 6.2.0 to 6.2.1 in /assets [#2511](https://github.com/trento-project/web/pull/2511) ([dependabot[bot]](https://github.com/apps/dependabot))
- Pin docker-compose postgres to 15 [#2503](https://github.com/trento-project/web/pull/2503) ([arbulu89](https://github.com/arbulu89))
- Bump peaceiris/actions-gh-pages from 3 to 4 [#2502](https://github.com/trento-project/web/pull/2502) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.9.0 to 28.2.0 in /assets [#2496](https://github.com/trento-project/web/pull/2496) ([dependabot[bot]](https://github.com/apps/dependabot))
- Hide misleading navigation icon from software updates indicator [#2493](https://github.com/trento-project/web/pull/2493) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @babel/preset-env from 7.24.3 to 7.24.4 in /assets [#2491](https://github.com/trento-project/web/pull/2491) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.24.3 to 7.24.4 in /assets [#2490](https://github.com/trento-project/web/pull/2490) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump isbang/compose-action from 1.5.1 to 2.0.0 [#2489](https://github.com/trento-project/web/pull/2489) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 11.2.0 to 11.3.0 in /assets [#2484](https://github.com/trento-project/web/pull/2484) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump express from 4.18.2 to 4.19.2 in /assets [#2483](https://github.com/trento-project/web/pull/2483) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.4.1 to 3.4.3 in /assets [#2482](https://github.com/trento-project/web/pull/2482) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add extra events triggering host rollup [#2481](https://github.com/trento-project/web/pull/2481) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add fqdns to photofinish fixtures [#2479](https://github.com/trento-project/web/pull/2479) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Read `SUSE Manager Enabled` flag from config in `HostDetailsPage` [#2477](https://github.com/trento-project/web/pull/2477) ([jamie-suse](https://github.com/jamie-suse))
- Handle network error for SUSE Manager settings [#2470](https://github.com/trento-project/web/pull/2470) ([dottorblaster](https://github.com/dottorblaster))
- Bump @heroicons/react from 2.1.1 to 2.1.3 in /assets [#2466](https://github.com/trento-project/web/pull/2466) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.18 to 10.4.19 in /assets [#2465](https://github.com/trento-project/web/pull/2465) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.36 to 8.4.38 in /assets [#2461](https://github.com/trento-project/web/pull/2461) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss-import from 16.0.1 to 16.1.0 in /assets [#2460](https://github.com/trento-project/web/pull/2460) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump webpack-dev-middleware from 6.1.1 to 6.1.2 in /assets [#2459](https://github.com/trento-project/web/pull/2459) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove `cursor: pointer` style on Available Software Updates component [#2458](https://github.com/trento-project/web/pull/2458) ([jamie-suse](https://github.com/jamie-suse))
- Bump chromatic from 11.0.8 to 11.2.0 in /assets [#2451](https://github.com/trento-project/web/pull/2451) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/react from 14.2.1 to 14.2.2 in /assets [#2450](https://github.com/trento-project/web/pull/2450) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.24.1 to 7.24.3 in /assets [#2449](https://github.com/trento-project/web/pull/2449) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.24.0 to 7.24.3 in /assets [#2448](https://github.com/trento-project/web/pull/2448) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-react from 7.23.3 to 7.24.1 in /assets [#2447](https://github.com/trento-project/web/pull/2447) ([dependabot[bot]](https://github.com/apps/dependabot))
- Removed source code and db table of telemetry submodul [#2446](https://github.com/trento-project/web/pull/2446) ([chrisb1s](https://github.com/chrisb1s))
- Bump @babel/preset-env from 7.24.0 to 7.24.1 in /assets [#2441](https://github.com/trento-project/web/pull/2441) ([dependabot[bot]](https://github.com/apps/dependabot))
- Turn on SUMA integration flag [#2437](https://github.com/trento-project/web/pull/2437) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Set docker as install method in `env` CI job [#2429](https://github.com/trento-project/web/pull/2429) ([arbulu89](https://github.com/arbulu89))
- Update photofinish version to 1.3.0 in CI [#2428](https://github.com/trento-project/web/pull/2428) ([arbulu89](https://github.com/arbulu89))
- Bump axios from 1.6.7 to 1.6.8 in /assets [#2427](https://github.com/trento-project/web/pull/2427) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.35 to 8.4.36 in /assets [#2426](https://github.com/trento-project/web/pull/2426) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 3.5.0 to 3.6.0 in /assets [#2425](https://github.com/trento-project/web/pull/2425) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.34.0 to 7.34.1 in /assets [#2424](https://github.com/trento-project/web/pull/2424) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump follow-redirects from 1.15.4 to 1.15.6 in /assets [#2423](https://github.com/trento-project/web/pull/2423) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 3.4.0 to 3.5.0 in /assets [#2422](https://github.com/trento-project/web/pull/2422) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.20.1 to 0.20.2 in /assets [#2421](https://github.com/trento-project/web/pull/2421) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add notifications playground [#2420](https://github.com/trento-project/web/pull/2420) ([CDimonaco](https://github.com/CDimonaco))
- Bump docker/login-action from 3.0.0 to 3.1.0 [#2419](https://github.com/trento-project/web/pull/2419) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump rc-input from 1.4.4 to 1.4.5 in /assets [#2418](https://github.com/trento-project/web/pull/2418) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 3.3.1 to 3.4.0 in /assets [#2411](https://github.com/trento-project/web/pull/2411) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove warning banner for HANA Scale Up performance optimized clusters on VMware [#2408](https://github.com/trento-project/web/pull/2408) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump chromatic from 11.0.6 to 11.0.8 in /assets [#2405](https://github.com/trento-project/web/pull/2405) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump rc-tooltip from 6.1.3 to 6.2.0 in /assets [#2402](https://github.com/trento-project/web/pull/2402) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump rc-input from 1.4.3 to 1.4.4 in /assets [#2401](https://github.com/trento-project/web/pull/2401) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 11.0.4 to 11.0.6 in /assets [#2399](https://github.com/trento-project/web/pull/2399) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.22.2 to 6.22.3 in /assets [#2398](https://github.com/trento-project/web/pull/2398) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove duplicated redux state `database_instances` field from the SAP system reducer [#2397](https://github.com/trento-project/web/pull/2397) ([arbulu89](https://github.com/arbulu89))
- Use derived state `use_ca_cert` in SUMA GenServer [#2396](https://github.com/trento-project/web/pull/2396) ([jamie-suse](https://github.com/jamie-suse))
- Bump chromatic from 11.0.3 to 11.0.4 in /assets [#2392](https://github.com/trento-project/web/pull/2392) ([dependabot[bot]](https://github.com/apps/dependabot))
- Available software updates component [#2390](https://github.com/trento-project/web/pull/2390) ([dottorblaster](https://github.com/dottorblaster))
- Bump chromatic from 11.0.0 to 11.0.3 in /assets [#2385](https://github.com/trento-project/web/pull/2385) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.33.2 to 7.34.0 in /assets [#2383](https://github.com/trento-project/web/pull/2383) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.17 to 10.4.18 in /assets [#2380](https://github.com/trento-project/web/pull/2380) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 4.0.12 to 4.0.13 in /assets [#2379](https://github.com/trento-project/web/pull/2379) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chart.js from 4.4.1 to 4.4.2 in /assets [#2375](https://github.com/trento-project/web/pull/2375) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.23.9 to 7.24.0 in /assets [#2374](https://github.com/trento-project/web/pull/2374) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.22.1 to 6.22.2 in /assets [#2373](https://github.com/trento-project/web/pull/2373) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.23.9 to 7.24.0 in /assets [#2372](https://github.com/trento-project/web/pull/2372) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix host view to include timestamps [#2367](https://github.com/trento-project/web/pull/2367) ([CDimonaco](https://github.com/CDimonaco))
- Bump eslint from 8.56.0 to 8.57.0 in /assets [#2364](https://github.com/trento-project/web/pull/2364) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.9.6 to 11.0.0 in /assets [#2361](https://github.com/trento-project/web/pull/2361) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromaui/action from 10 to 11 [#2360](https://github.com/trento-project/web/pull/2360) ([dependabot[bot]](https://github.com/apps/dependabot))
- Change KVM label to "On-premises / KVM" [#2359](https://github.com/trento-project/web/pull/2359) ([jamie-suse](https://github.com/jamie-suse))
- Bump @storybook/addon-links from 7.6.16 to 7.6.17 in /assets [#2357](https://github.com/trento-project/web/pull/2357) ([dependabot[bot]](https://github.com/apps/dependabot))
- Connect sagas to the actual SUSE Manager config UI [#2356](https://github.com/trento-project/web/pull/2356) ([dottorblaster](https://github.com/dottorblaster))
- Connect `Clear Settings` dialog to `SUSE Manager config` [#2353](https://github.com/trento-project/web/pull/2353) ([jamie-suse](https://github.com/jamie-suse))
- Bump @storybook/addon-essentials from 7.6.16 to 7.6.17 in /assets [#2352](https://github.com/trento-project/web/pull/2352) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.16 to 7.6.17 in /assets [#2351](https://github.com/trento-project/web/pull/2351) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.6.16 to 7.6.17 in /assets [#2350](https://github.com/trento-project/web/pull/2350) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.6.16 to 7.6.17 in /assets [#2349](https://github.com/trento-project/web/pull/2349) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.16 to 7.6.17 in /assets [#2348](https://github.com/trento-project/web/pull/2348) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump ip from 2.0.0 to 2.0.1 in /assets [#2347](https://github.com/trento-project/web/pull/2347) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update license year to 2024 [#2344](https://github.com/trento-project/web/pull/2344) ([EMaksy](https://github.com/EMaksy))
- Remove API check json output in CI [#2343](https://github.com/trento-project/web/pull/2343) ([arbulu89](https://github.com/arbulu89))
- Bump httpoison version [#2342](https://github.com/trento-project/web/pull/2342) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump esbuild from 0.20.0 to 0.20.1 in /assets [#2340](https://github.com/trento-project/web/pull/2340) ([dependabot[bot]](https://github.com/apps/dependabot))
- Clean tgzs after `service manualrun` [#2336](https://github.com/trento-project/web/pull/2336) ([rtorrero](https://github.com/rtorrero))
- Bump react-router-dom from 6.22.0 to 6.22.1 in /assets [#2335](https://github.com/trento-project/web/pull/2335) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.8.0 to 27.9.0 in /assets [#2334](https://github.com/trento-project/web/pull/2334) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.9.5 to 10.9.6 in /assets [#2333](https://github.com/trento-project/web/pull/2333) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.6.15 to 7.6.16 in /assets [#2332](https://github.com/trento-project/web/pull/2332) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-storybook from 0.6.15 to 0.8.0 in /assets [#2331](https://github.com/trento-project/web/pull/2331) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix tiny typo in errors logic for input field [#2329](https://github.com/trento-project/web/pull/2329) ([dottorblaster](https://github.com/dottorblaster))
- Bump @storybook/addon-essentials from 7.6.15 to 7.6.16 in /assets [#2325](https://github.com/trento-project/web/pull/2325) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.15 to 7.6.16 in /assets [#2324](https://github.com/trento-project/web/pull/2324) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.15 to 7.6.16 in /assets [#2323](https://github.com/trento-project/web/pull/2323) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.6.15 to 7.6.16 in /assets [#2322](https://github.com/trento-project/web/pull/2322) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.6.15 to 7.6.16 in /assets [#2321](https://github.com/trento-project/web/pull/2321) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add tooltip for non-compliant saptune [#2319](https://github.com/trento-project/web/pull/2319) ([rtorrero](https://github.com/rtorrero))
- Bump chromatic from 10.9.3 to 10.9.5 in /assets [#2316](https://github.com/trento-project/web/pull/2316) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss-import from 16.0.0 to 16.0.1 in /assets [#2315](https://github.com/trento-project/web/pull/2315) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.6.14 to 7.6.15 in /assets [#2314](https://github.com/trento-project/web/pull/2314) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.14 to 7.6.15 in /assets [#2313](https://github.com/trento-project/web/pull/2313) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.14 to 7.6.15 in /assets [#2305](https://github.com/trento-project/web/pull/2305) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.6.14 to 7.6.15 in /assets [#2304](https://github.com/trento-project/web/pull/2304) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.6.14 to 7.6.15 in /assets [#2303](https://github.com/trento-project/web/pull/2303) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.6.3 to 27.8.0 in /assets [#2301](https://github.com/trento-project/web/pull/2301) ([dependabot[bot]](https://github.com/apps/dependabot))
- Pass className through to Textarea component [#2299](https://github.com/trento-project/web/pull/2299) ([dottorblaster](https://github.com/dottorblaster))
- Bump @storybook/addon-links from 7.6.13 to 7.6.14 in /assets [#2295](https://github.com/trento-project/web/pull/2295) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.13 to 7.6.14 in /assets [#2294](https://github.com/trento-project/web/pull/2294) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.6.13 to 7.6.14 in /assets [#2293](https://github.com/trento-project/web/pull/2293) ([dependabot[bot]](https://github.com/apps/dependabot))
- Cleanup .tgz(s) from previous runs [#2292](https://github.com/trento-project/web/pull/2292) ([rtorrero](https://github.com/rtorrero))
- Bump jaxxstorm/action-install-gh-release from 1.10.0 to 1.11.0 [#2289](https://github.com/trento-project/web/pull/2289) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.6.13 to 7.6.14 in /assets [#2288](https://github.com/trento-project/web/pull/2288) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.6.13 to 7.6.14 in /assets [#2287](https://github.com/trento-project/web/pull/2287) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.13 to 7.6.14 in /assets [#2286](https://github.com/trento-project/web/pull/2286) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.9.2 to 10.9.3 in /assets [#2285](https://github.com/trento-project/web/pull/2285) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.6.13 to 7.6.14 in /assets [#2284](https://github.com/trento-project/web/pull/2284) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add missed CI step name [#2283](https://github.com/trento-project/web/pull/2283) ([rtorrero](https://github.com/rtorrero))
- Remove unnecessary tar arguments [#2282](https://github.com/trento-project/web/pull/2282) ([rtorrero](https://github.com/rtorrero))
- Bump chromatic from 10.9.0 to 10.9.2 in /assets [#2281](https://github.com/trento-project/web/pull/2281) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @faker-js/faker from 8.4.0 to 8.4.1 in /assets [#2280](https://github.com/trento-project/web/pull/2280) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add missed local-npm-registry dep [#2279](https://github.com/trento-project/web/pull/2279) ([rtorrero](https://github.com/rtorrero))
- Bump chromatic from 10.8.0 to 10.9.0 in /assets [#2276](https://github.com/trento-project/web/pull/2276) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.34 to 8.4.35 in /assets [#2275](https://github.com/trento-project/web/pull/2275) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.12 to 7.6.13 in /assets [#2274](https://github.com/trento-project/web/pull/2274) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.12 to 7.6.13 in /assets [#2270](https://github.com/trento-project/web/pull/2270) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.7.1 to 10.8.0 in /assets [#2269](https://github.com/trento-project/web/pull/2269) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.6.12 to 7.6.13 in /assets [#2268](https://github.com/trento-project/web/pull/2268) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.6.12 to 7.6.13 in /assets [#2267](https://github.com/trento-project/web/pull/2267) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.6.12 to 7.6.13 in /assets [#2266](https://github.com/trento-project/web/pull/2266) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add saptune discovery payloads to the healthy clusters scenario [#2265](https://github.com/trento-project/web/pull/2265) ([arbulu89](https://github.com/arbulu89))
- Rename route: `/software_updates/settings` -> `/settings/suma_credentials` [#2264](https://github.com/trento-project/web/pull/2264) ([jamie-suse](https://github.com/jamie-suse))
- Bump postcss from 8.4.33 to 8.4.34 in /assets [#2262](https://github.com/trento-project/web/pull/2262) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump semver from 7.5.4 to 7.6.0 in /assets [#2261](https://github.com/trento-project/web/pull/2261) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.4.1 to 6.4.2 in /assets [#2260](https://github.com/trento-project/web/pull/2260) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add RPM package generation [#2258](https://github.com/trento-project/web/pull/2258) ([rtorrero](https://github.com/rtorrero))
- Bump chromatic from 10.7.0 to 10.7.1 in /assets [#2257](https://github.com/trento-project/web/pull/2257) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/react from 14.2.0 to 14.2.1 in /assets [#2256](https://github.com/trento-project/web/pull/2256) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.6.1 to 10.7.0 in /assets [#2255](https://github.com/trento-project/web/pull/2255) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.4.0 to 6.4.1 in /assets [#2254](https://github.com/trento-project/web/pull/2254) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.21.3 to 6.22.0 in /assets [#2253](https://github.com/trento-project/web/pull/2253) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix typo in software updates settings schema [#2251](https://github.com/trento-project/web/pull/2251) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Upgrade to Storybook 7.6.12 [#2249](https://github.com/trento-project/web/pull/2249) ([dottorblaster](https://github.com/dottorblaster))
- Bump docker/metadata-action from 5.5.0 to 5.5.1 [#2245](https://github.com/trento-project/web/pull/2245) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.6.10 to 7.6.12 in /assets [#2240](https://github.com/trento-project/web/pull/2240) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/react from 14.1.2 to 14.2.0 in /assets [#2238](https://github.com/trento-project/web/pull/2238) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.3.0 to 6.4.0 in /assets [#2233](https://github.com/trento-project/web/pull/2233) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.19.12 to 0.20.0 in /assets [#2231](https://github.com/trento-project/web/pull/2231) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.6.0 to 10.6.1 in /assets [#2230](https://github.com/trento-project/web/pull/2230) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump styfle/cancel-workflow-action from 0.12.0 to 0.12.1 [#2228](https://github.com/trento-project/web/pull/2228) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @faker-js/faker from 8.3.1 to 8.4.0 in /assets [#2227](https://github.com/trento-project/web/pull/2227) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.6.6 to 1.6.7 in /assets [#2226](https://github.com/trento-project/web/pull/2226) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.23.7 to 7.23.9 in /assets [#2225](https://github.com/trento-project/web/pull/2225) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.5.0 to 10.6.0 in /assets [#2224](https://github.com/trento-project/web/pull/2224) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.23.8 to 7.23.9 in /assets [#2223](https://github.com/trento-project/web/pull/2223) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix TargetIcon test containing a typo [#2221](https://github.com/trento-project/web/pull/2221) ([dottorblaster](https://github.com/dottorblaster))
- Update LICENSE [#2219](https://github.com/trento-project/web/pull/2219) ([stefanotorresi](https://github.com/stefanotorresi))
- Bump @testing-library/jest-dom from 6.2.1 to 6.3.0 in /assets [#2218](https://github.com/trento-project/web/pull/2218) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.6.5 to 1.6.6 in /assets [#2217](https://github.com/trento-project/web/pull/2217) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.19.11 to 0.19.12 in /assets [#2216](https://github.com/trento-project/web/pull/2216) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.3.1 to 10.5.0 in /assets [#2215](https://github.com/trento-project/web/pull/2215) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.2.0 to 6.2.1 in /assets [#2211](https://github.com/trento-project/web/pull/2211) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 3.3.0 to 3.3.1 in /assets [#2210](https://github.com/trento-project/web/pull/2210) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update README, by adding more references to installation options [#2209](https://github.com/trento-project/web/pull/2209) ([EMaksy](https://github.com/EMaksy))
- Bump @storybook/react from 7.6.7 to 7.6.10 in /assets [#2208](https://github.com/trento-project/web/pull/2208) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 3.2.0 to 3.3.0 in /assets [#2207](https://github.com/trento-project/web/pull/2207) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.7 to 7.6.10 in /assets [#2206](https://github.com/trento-project/web/pull/2206) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.6.7 to 7.6.10 in /assets [#2205](https://github.com/trento-project/web/pull/2205) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.6.7 to 7.6.10 in /assets [#2203](https://github.com/trento-project/web/pull/2203) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.7 to 7.6.10 in /assets [#2202](https://github.com/trento-project/web/pull/2202) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.21.2 to 6.21.3 in /assets [#2201](https://github.com/trento-project/web/pull/2201) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.6.7 to 7.6.10 in /assets [#2200](https://github.com/trento-project/web/pull/2200) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.6.9 to 7.6.10 in /assets [#2199](https://github.com/trento-project/web/pull/2199) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add exporter_name to prometheus dev config file [#2198](https://github.com/trento-project/web/pull/2198) ([arbulu89](https://github.com/arbulu89))
- Restore github actions removed during elixir upgrade [#2194](https://github.com/trento-project/web/pull/2194) ([arbulu89](https://github.com/arbulu89))
- Bump actions/cache from 3 to 4 [#2193](https://github.com/trento-project/web/pull/2193) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.6.7 to 7.6.9 in /assets [#2191](https://github.com/trento-project/web/pull/2191) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.16 to 10.4.17 in /assets [#2190](https://github.com/trento-project/web/pull/2190) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.3.0 to 10.3.1 in /assets [#2188](https://github.com/trento-project/web/pull/2188) ([dependabot[bot]](https://github.com/apps/dependabot))
- Saptune summary warning icon [#2187](https://github.com/trento-project/web/pull/2187) ([EMaksy](https://github.com/EMaksy))
- Bump chromatic from 10.2.2 to 10.3.0 in /assets [#2185](https://github.com/trento-project/web/pull/2185) ([dependabot[bot]](https://github.com/apps/dependabot))
- Docker compose utility adapt [#2184](https://github.com/trento-project/web/pull/2184) ([CDimonaco](https://github.com/CDimonaco))
- Bump react-accessible-treeview from 2.8.2 to 2.8.3 in /assets [#2181](https://github.com/trento-project/web/pull/2181) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.2.1 to 10.2.2 in /assets [#2180](https://github.com/trento-project/web/pull/2180) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove grafana last references [#2178](https://github.com/trento-project/web/pull/2178) ([arbulu89](https://github.com/arbulu89))
- Bump eslint-plugin-jest from 27.6.2 to 27.6.3 in /assets [#2174](https://github.com/trento-project/web/pull/2174) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jupyterhub/action-k3s-helm from 3 to 4 [#2170](https://github.com/trento-project/web/pull/2170) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 3.1.0 to 3.2.0 in /assets [#2169](https://github.com/trento-project/web/pull/2169) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.21.1 to 6.21.2 in /assets [#2168](https://github.com/trento-project/web/pull/2168) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.1.6 to 6.2.0 in /assets [#2167](https://github.com/trento-project/web/pull/2167) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.2.0 to 10.2.1 in /assets [#2166](https://github.com/trento-project/web/pull/2166) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.6.1 to 27.6.2 in /assets [#2165](https://github.com/trento-project/web/pull/2165) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix sequence usage in sles subscription factory [#2164](https://github.com/trento-project/web/pull/2164) ([dottorblaster](https://github.com/dottorblaster))
- Bump postcss-import from 15.1.0 to 16.0.0 in /assets [#2163](https://github.com/trento-project/web/pull/2163) ([dependabot[bot]](https://github.com/apps/dependabot))
- Include new cert variables required by the ansible playbook [#2162](https://github.com/trento-project/web/pull/2162) ([rtorrero](https://github.com/rtorrero))
- Bump postcss from 8.4.32 to 8.4.33 in /assets [#2161](https://github.com/trento-project/web/pull/2161) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.17 to 1.7.18 in /assets [#2160](https://github.com/trento-project/web/pull/2160) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.4.0 to 3.4.1 in /assets [#2159](https://github.com/trento-project/web/pull/2159) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.8.1 to 2.8.2 in /assets [#2158](https://github.com/trento-project/web/pull/2158) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.23.7 to 7.23.8 in /assets [#2157](https://github.com/trento-project/web/pull/2157) ([dependabot[bot]](https://github.com/apps/dependabot))
- Hotfix MockPrometheusApi as host data fetcher in demo env [#2156](https://github.com/trento-project/web/pull/2156) ([CDimonaco](https://github.com/CDimonaco))
- Random chart data in demo environment [#2155](https://github.com/trento-project/web/pull/2155) ([CDimonaco](https://github.com/CDimonaco))
- Fix ENSA version computation run only over application instances [#2153](https://github.com/trento-project/web/pull/2153) ([dottorblaster](https://github.com/dottorblaster))
- Bump follow-redirects from 1.15.2 to 1.15.4 in /assets [#2152](https://github.com/trento-project/web/pull/2152) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump redux-saga from 1.2.3 to 1.3.0 in /assets [#2151](https://github.com/trento-project/web/pull/2151) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 3.0.6 to 3.1.0 in /assets [#2150](https://github.com/trento-project/web/pull/2150) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.6.0 to 27.6.1 in /assets [#2149](https://github.com/trento-project/web/pull/2149) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.6.3 to 1.6.5 in /assets [#2148](https://github.com/trento-project/web/pull/2148) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade to Storybook 7.6.7 [#2146](https://github.com/trento-project/web/pull/2146) ([dottorblaster](https://github.com/dottorblaster))
- Fix SLES subscription identifier in host tests [#2143](https://github.com/trento-project/web/pull/2143) ([dottorblaster](https://github.com/dottorblaster))
- Bump docker/metadata-action from 5.4.0 to 5.5.0 [#2142](https://github.com/trento-project/web/pull/2142) ([dependabot[bot]](https://github.com/apps/dependabot))
- minor: improve error message [#2141](https://github.com/trento-project/web/pull/2141) ([isimluk](https://github.com/isimluk))
- Bump @babel/core from 7.23.6 to 7.23.7 in /assets [#2139](https://github.com/trento-project/web/pull/2139) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.23.6 to 7.23.7 in /assets [#2138](https://github.com/trento-project/web/pull/2138) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump classnames from 2.5.0 to 2.5.1 in /assets [#2137](https://github.com/trento-project/web/pull/2137) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/user-event from 14.5.1 to 14.5.2 in /assets [#2136](https://github.com/trento-project/web/pull/2136) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.19.10 to 0.19.11 in /assets [#2135](https://github.com/trento-project/web/pull/2135) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix Jest test for ASCS details table [#2134](https://github.com/trento-project/web/pull/2134) ([dottorblaster](https://github.com/dottorblaster))
- Bump classnames from 2.3.2 to 2.5.0 in /assets [#2133](https://github.com/trento-project/web/pull/2133) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.1.5 to 6.1.6 in /assets [#2132](https://github.com/trento-project/web/pull/2132) ([dependabot[bot]](https://github.com/apps/dependabot))
- Get rid of dayjs [#2131](https://github.com/trento-project/web/pull/2131) ([dottorblaster](https://github.com/dottorblaster))
- Bump axios from 1.6.2 to 1.6.3 in /assets [#2130](https://github.com/trento-project/web/pull/2130) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chart.js from 4.4.0 to 4.4.1 in /assets [#2127](https://github.com/trento-project/web/pull/2127) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 2.30.0 to 3.0.6 in /assets [#2125](https://github.com/trento-project/web/pull/2125) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.1.0 to 10.2.0 in /assets [#2124](https://github.com/trento-project/web/pull/2124) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.21.0 to 6.21.1 in /assets [#2123](https://github.com/trento-project/web/pull/2123) ([dependabot[bot]](https://github.com/apps/dependabot))
- Use docker compose instead of action services in ci [#2122](https://github.com/trento-project/web/pull/2122) ([CDimonaco](https://github.com/CDimonaco))
- Remove dayjs usage and use date-fns instead [#2119](https://github.com/trento-project/web/pull/2119) ([dottorblaster](https://github.com/dottorblaster))
- Upgrade to Storybook 7.6.6 [#2118](https://github.com/trento-project/web/pull/2118) ([dottorblaster](https://github.com/dottorblaster))
- Fix ASCS/ERS cluster details classnames usage [#2117](https://github.com/trento-project/web/pull/2117) ([dottorblaster](https://github.com/dottorblaster))
- Bump html-webpack-plugin from 5.5.4 to 5.6.0 in /assets [#2116](https://github.com/trento-project/web/pull/2116) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.3.7 to 3.4.0 in /assets [#2115](https://github.com/trento-project/web/pull/2115) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix classNames usage in HanaClusterDetails [#2112](https://github.com/trento-project/web/pull/2112) ([dottorblaster](https://github.com/dottorblaster))
- Bump rc-tooltip from 6.1.2 to 6.1.3 in /assets [#2110](https://github.com/trento-project/web/pull/2110) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @heroicons/react from 2.0.18 to 2.1.1 in /assets [#2109](https://github.com/trento-project/web/pull/2109) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.3.6 to 3.3.7 in /assets [#2108](https://github.com/trento-project/web/pull/2108) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.19.9 to 0.19.10 in /assets [#2107](https://github.com/trento-project/web/pull/2107) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 5.3.0 to 5.4.0 [#2106](https://github.com/trento-project/web/pull/2106) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix classnames usage in HostDetails [#2105](https://github.com/trento-project/web/pull/2105) ([dottorblaster](https://github.com/dottorblaster))
- Upgrade Storybook to 7.6.5 [#2104](https://github.com/trento-project/web/pull/2104) ([dottorblaster](https://github.com/dottorblaster))
- Bump eslint from 8.55.0 to 8.56.0 in /assets [#2101](https://github.com/trento-project/web/pull/2101) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 4.0.11 to 4.0.12 in /assets [#2099](https://github.com/trento-project/web/pull/2099) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix start execution button size for host details [#2098](https://github.com/trento-project/web/pull/2098) ([dottorblaster](https://github.com/dottorblaster))
- Fix start execution button size for ASCS/ERS [#2097](https://github.com/trento-project/web/pull/2097) ([dottorblaster](https://github.com/dottorblaster))
- Fix Start Execution button size in cluster details [#2096](https://github.com/trento-project/web/pull/2096) ([dottorblaster](https://github.com/dottorblaster))
- Bump eslint-plugin-import from 2.29.0 to 2.29.1 in /assets [#2095](https://github.com/trento-project/web/pull/2095) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/upload-artifact from 3 to 4 [#2094](https://github.com/trento-project/web/pull/2094) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.20.1 to 6.21.0 in /assets [#2092](https://github.com/trento-project/web/pull/2092) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.19.8 to 0.19.9 in /assets [#2090](https://github.com/trento-project/web/pull/2090) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.23.5 to 7.23.6 in /assets [#2089](https://github.com/trento-project/web/pull/2089) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade to Storybook 7.6.4 [#2087](https://github.com/trento-project/web/pull/2087) ([dottorblaster](https://github.com/dottorblaster))
- Bump @babel/core from 7.23.5 to 7.23.6 in /assets [#2086](https://github.com/trento-project/web/pull/2086) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.3 to 7.6.4 in /assets [#2084](https://github.com/trento-project/web/pull/2084) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.6.3 to 7.6.4 in /assets [#2083](https://github.com/trento-project/web/pull/2083) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 10.0.0 to 10.1.0 in /assets [#2082](https://github.com/trento-project/web/pull/2082) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.3 to 7.6.4 in /assets [#2081](https://github.com/trento-project/web/pull/2081) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump html-webpack-plugin from 5.5.3 to 5.5.4 in /assets [#2078](https://github.com/trento-project/web/pull/2078) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.6.1 to 7.6.3 in /assets [#2076](https://github.com/trento-project/web/pull/2076) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.8.0 to 2.8.1 in /assets [#2075](https://github.com/trento-project/web/pull/2075) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.6.1 to 7.6.3 in /assets [#2074](https://github.com/trento-project/web/pull/2074) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.3.5 to 3.3.6 in /assets [#2072](https://github.com/trento-project/web/pull/2072) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.1.4 to 6.1.5 in /assets [#2071](https://github.com/trento-project/web/pull/2071) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.2 to 7.6.3 in /assets [#2070](https://github.com/trento-project/web/pull/2070) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-config-prettier from 9.0.0 to 9.1.0 in /assets [#2069](https://github.com/trento-project/web/pull/2069) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.31 to 8.4.32 in /assets [#2068](https://github.com/trento-project/web/pull/2068) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.20.0 to 6.20.1 in /assets [#2067](https://github.com/trento-project/web/pull/2067) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.6.1 to 7.6.3 in /assets [#2066](https://github.com/trento-project/web/pull/2066) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.54.0 to 8.55.0 in /assets [#2065](https://github.com/trento-project/web/pull/2065) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 5.2.0 to 5.3.0 [#2064](https://github.com/trento-project/web/pull/2064) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.23.3 to 7.23.5 in /assets [#2062](https://github.com/trento-project/web/pull/2062) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 9.1.0 to 10.0.0 in /assets [#2060](https://github.com/trento-project/web/pull/2060) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.2 to 7.6.3 in /assets [#2059](https://github.com/trento-project/web/pull/2059) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.6.2 to 7.6.3 in /assets [#2058](https://github.com/trento-project/web/pull/2058) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromaui/action from 1 to 10 [#2057](https://github.com/trento-project/web/pull/2057) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 5.0.0 to 5.2.0 [#2056](https://github.com/trento-project/web/pull/2056) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.1 to 7.6.2 in /assets [#2055](https://github.com/trento-project/web/pull/2055) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.1 to 7.6.2 in /assets [#2054](https://github.com/trento-project/web/pull/2054) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.6.1 to 7.6.2 in /assets [#2053](https://github.com/trento-project/web/pull/2053) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.23.3 to 7.23.5 in /assets [#2052](https://github.com/trento-project/web/pull/2052) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @adobe/css-tools from 4.3.1 to 4.3.2 in /assets [#2051](https://github.com/trento-project/web/pull/2051) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.6.0 to 7.6.1 in /assets [#2048](https://github.com/trento-project/web/pull/2048) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.6.0 to 7.6.1 in /assets [#2047](https://github.com/trento-project/web/pull/2047) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.6.0 to 7.6.1 in /assets [#2046](https://github.com/trento-project/web/pull/2046) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.5.3 to 7.6.1 in /assets [#2045](https://github.com/trento-project/web/pull/2045) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.5.3 to 7.6.1 in /assets [#2044](https://github.com/trento-project/web/pull/2044) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.5.3 to 7.6.1 in /assets [#2043](https://github.com/trento-project/web/pull/2043) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.5.3 to 7.6.0 in /assets [#2041](https://github.com/trento-project/web/pull/2041) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.5.3 to 7.6.0 in /assets [#2040](https://github.com/trento-project/web/pull/2040) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.5.3 to 7.6.0 in /assets [#2039](https://github.com/trento-project/web/pull/2039) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.5.3 to 7.6.0 in /assets [#2038](https://github.com/trento-project/web/pull/2038) ([dependabot[bot]](https://github.com/apps/dependabot))
- Refactor React components directory structure [#2037](https://github.com/trento-project/web/pull/2037) ([EMaksy](https://github.com/EMaksy))
- Split saga functions context [#2036](https://github.com/trento-project/web/pull/2036) ([arbulu89](https://github.com/arbulu89))
- Refactor to createOptionRenderer helper [#2034](https://github.com/trento-project/web/pull/2034) ([dottorblaster](https://github.com/dottorblaster))
- Refactor mix docs groups after creating the contexts [#2033](https://github.com/trento-project/web/pull/2033) ([arbulu89](https://github.com/arbulu89))
- Bump esbuild from 0.19.7 to 0.19.8 in /assets [#2032](https://github.com/trento-project/web/pull/2032) ([dependabot[bot]](https://github.com/apps/dependabot))
- Redux state directory restructure [#2024](https://github.com/trento-project/web/pull/2024) ([EMaksy](https://github.com/EMaksy))
- Bump react-router-dom from 6.19.0 to 6.20.0 in /assets [#2023](https://github.com/trento-project/web/pull/2023) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/react from 14.1.0 to 14.1.2 in /assets [#2019](https://github.com/trento-project/web/pull/2019) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.19.6 to 0.19.7 in /assets [#2018](https://github.com/trento-project/web/pull/2018) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 9.0.0 to 9.1.0 in /assets [#2016](https://github.com/trento-project/web/pull/2016) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.19.5 to 0.19.6 in /assets [#2015](https://github.com/trento-project/web/pull/2015) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.53.0 to 8.54.0 in /assets [#2014](https://github.com/trento-project/web/pull/2014) ([dependabot[bot]](https://github.com/apps/dependabot))
- Reorganize directory structure for clusters context [#2012](https://github.com/trento-project/web/pull/2012) ([rtorrero](https://github.com/rtorrero))
- Add default props for AscsErsClusterDetails [#2011](https://github.com/trento-project/web/pull/2011) ([dottorblaster](https://github.com/dottorblaster))
- Bump react-router-dom from 6.18.0 to 6.19.0 in /assets [#2008](https://github.com/trento-project/web/pull/2008) ([dependabot[bot]](https://github.com/apps/dependabot))
- Revert "Remove Check-related action buttons from Host Details view (#… [#2007](https://github.com/trento-project/web/pull/2007) ([dottorblaster](https://github.com/dottorblaster))
- Improve Error notification box usage [#2005](https://github.com/trento-project/web/pull/2005) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Increase timeout for Rabbit consumer tests [#2004](https://github.com/trento-project/web/pull/2004) ([dottorblaster](https://github.com/dottorblaster))
- Bump @faker-js/faker from 8.2.0 to 8.3.1 in /assets [#2001](https://github.com/trento-project/web/pull/2001) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.6.1 to 1.6.2 in /assets [#2000](https://github.com/trento-project/web/pull/2000) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-markdown from 9.0.0 to 9.0.1 in /assets [#1995](https://github.com/trento-project/web/pull/1995) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jsx-a11y from 6.7.1 to 6.8.0 in /assets [#1972](https://github.com/trento-project/web/pull/1972) ([dependabot[bot]](https://github.com/apps/dependabot))

## [2.2.0](https://github.com/trento-project/web/tree/2.2.0) (2023-11-14)

[Full Changelog](https://github.com/trento-project/web/compare/2.1.0...2.2.0)

**Implemented enhancements:**

- Update tooltip texts [#1979](https://github.com/trento-project/web/pull/1979) ([arbulu89](https://github.com/arbulu89))
- Handle when no checks available in the checks results overview [#1959](https://github.com/trento-project/web/pull/1959) ([jamie-suse](https://github.com/jamie-suse))
- Checks catalog only first group expanded [#1958](https://github.com/trento-project/web/pull/1958) ([arbulu89](https://github.com/arbulu89))
- Fix ip address ui in host details [#1944](https://github.com/trento-project/web/pull/1944) ([EMaksy](https://github.com/EMaksy))
- Replace "SAP INSTANCES" title in Trento dashboard/home page [#1935](https://github.com/trento-project/web/pull/1935) ([EMaksy](https://github.com/EMaksy))
- Added 3 categories for Storybook structure [#1918](https://github.com/trento-project/web/pull/1918) ([jagabomb](https://github.com/jagabomb))
- Improve renderSolution function if solution is empty [#1909](https://github.com/trento-project/web/pull/1909) ([EMaksy](https://github.com/EMaksy))
- Notify user when cluster health changes [#1908](https://github.com/trento-project/web/pull/1908) ([jamie-suse](https://github.com/jamie-suse))
- Saptune services status icons [#1906](https://github.com/trento-project/web/pull/1906) ([EMaksy](https://github.com/EMaksy))
- Update host health state based on saptune data [#1905](https://github.com/trento-project/web/pull/1905) ([arbulu89](https://github.com/arbulu89))
- Send email notification on host health going critical [#1900](https://github.com/trento-project/web/pull/1900) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Update outdated Agent message [#1883](https://github.com/trento-project/web/pull/1883) ([stefanotorresi](https://github.com/stefanotorresi))
- Use aggregated host health in the UI [#1877](https://github.com/trento-project/web/pull/1877) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add health to host read model [#1871](https://github.com/trento-project/web/pull/1871) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Saptune details view [#1865](https://github.com/trento-project/web/pull/1865) ([arbulu89](https://github.com/arbulu89))
- Checks results overview inside host details [#1864](https://github.com/trento-project/web/pull/1864) ([dottorblaster](https://github.com/dottorblaster))
- Dispatch host checks execution completion command [#1859](https://github.com/trento-project/web/pull/1859) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Exclude checks result from host's health when empty selection is saved [#1858](https://github.com/trento-project/web/pull/1858) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Determine host health [#1848](https://github.com/trento-project/web/pull/1848) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Set solutions to nil if not found [#1833](https://github.com/trento-project/web/pull/1833) ([arbulu89](https://github.com/arbulu89))
- Listen to saptune update broadcast messages in frontend [#1822](https://github.com/trento-project/web/pull/1822) ([arbulu89](https://github.com/arbulu89))
- Saptune status projection [#1821](https://github.com/trento-project/web/pull/1821) ([arbulu89](https://github.com/arbulu89))
- Host Check result detail [#1809](https://github.com/trento-project/web/pull/1809) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add tooltip above `Start Execution` button [#1802](https://github.com/trento-project/web/pull/1802) ([jamie-suse](https://github.com/jamie-suse))
- Handle saptune payload [#1801](https://github.com/trento-project/web/pull/1801) ([CDimonaco](https://github.com/CDimonaco))
- Saptune domain [#1800](https://github.com/trento-project/web/pull/1800) ([arbulu89](https://github.com/arbulu89))
- Saptune summary frontend [#1796](https://github.com/trento-project/web/pull/1796) ([arbulu89](https://github.com/arbulu89))
- Host Checks Results overview [#1794](https://github.com/trento-project/web/pull/1794) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Make frontend listen for events when instances' presence changes [#1779](https://github.com/trento-project/web/pull/1779) ([jamie-suse](https://github.com/jamie-suse))
- Dispatch deregistering actions on clean up flow [#1776](https://github.com/trento-project/web/pull/1776) ([arbulu89](https://github.com/arbulu89))
- Add `absent_at` field to projectors and broadcast events [#1775](https://github.com/trento-project/web/pull/1775) ([jamie-suse](https://github.com/jamie-suse))
- Update deregistration modal to include instances content [#1772](https://github.com/trento-project/web/pull/1772) ([arbulu89](https://github.com/arbulu89))
- Host checks execution frontend [#1753](https://github.com/trento-project/web/pull/1753) ([EMaksy](https://github.com/EMaksy))
- Implement instance style changes on absent case [#1747](https://github.com/trento-project/web/pull/1747) ([rtorrero](https://github.com/rtorrero))
- Instance deregistration sagas [#1746](https://github.com/trento-project/web/pull/1746) ([arbulu89](https://github.com/arbulu89))
- Host checks execution api [#1740](https://github.com/trento-project/web/pull/1740) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump contracts version to latest containing target type [#1739](https://github.com/trento-project/web/pull/1739) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Allow additional classes to be specified on the clean up button [#1737](https://github.com/trento-project/web/pull/1737) ([rtorrero](https://github.com/rtorrero))
- Forbid not registered instances deregistration [#1733](https://github.com/trento-project/web/pull/1733) ([arbulu89](https://github.com/arbulu89))
- Add ability to mark instances as absent [#1731](https://github.com/trento-project/web/pull/1731) ([jamie-suse](https://github.com/jamie-suse))
- Instance deregistration endpoint [#1730](https://github.com/trento-project/web/pull/1730) ([arbulu89](https://github.com/arbulu89))
- Add wanda demo to pr env [#1707](https://github.com/trento-project/web/pull/1707) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Pull request environment [#1704](https://github.com/trento-project/web/pull/1704) ([CDimonaco](https://github.com/CDimonaco))
- Add API backward compatibility check in pipeline [#1690](https://github.com/trento-project/web/pull/1690) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Host Checks selection [#1669](https://github.com/trento-project/web/pull/1669) ([nelsonkopliku](https://github.com/nelsonkopliku))

**Fixed bugs:**

- Use databasesList slice properly to get db instances [#1980](https://github.com/trento-project/web/pull/1980) ([arbulu89](https://github.com/arbulu89))
- Fix saptune domain clause [#1975](https://github.com/trento-project/web/pull/1975) ([arbulu89](https://github.com/arbulu89))
- Fix redirection when a query string is involved [#1954](https://github.com/trento-project/web/pull/1954) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add missing cluster type when loading checks in cluster checks selection [#1945](https://github.com/trento-project/web/pull/1945) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix "no tuning" value by "not tuned" [#1913](https://github.com/trento-project/web/pull/1913) ([arbulu89](https://github.com/arbulu89))
- Handle fact value with null value [#1878](https://github.com/trento-project/web/pull/1878) ([arbulu89](https://github.com/arbulu89))
- Downgrade remark-gfm until it gets fixed upstream [#1866](https://github.com/trento-project/web/pull/1866) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix typo on tuning word [#1836](https://github.com/trento-project/web/pull/1836) ([arbulu89](https://github.com/arbulu89))
- Improve app instance present toast [#1811](https://github.com/trento-project/web/pull/1811) ([arbulu89](https://github.com/arbulu89))
- Fix instance movement logic [#1810](https://github.com/trento-project/web/pull/1810) ([arbulu89](https://github.com/arbulu89))
- Use rowKey in sap system and database overview tables [#1782](https://github.com/trento-project/web/pull/1782) ([arbulu89](https://github.com/arbulu89))
- Node details label for ASCS/ERS cluster details [#1752](https://github.com/trento-project/web/pull/1752) ([dottorblaster](https://github.com/dottorblaster))
- Use ProviderLabel on sap and db detail views [#1738](https://github.com/trento-project/web/pull/1738) ([arbulu89](https://github.com/arbulu89))
- Restore a SAP system only when the database is present [#1706](https://github.com/trento-project/web/pull/1706) ([CDimonaco](https://github.com/CDimonaco))

**Merged pull requests:**

- Update e2e package lock [#1997](https://github.com/trento-project/web/pull/1997) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Restrict SUSE Dockerfile target arch to x86_64 [#1994](https://github.com/trento-project/web/pull/1994) ([rtorrero](https://github.com/rtorrero))
- Bump chromatic from 8.0.0 to 9.0.0 in /assets [#1993](https://github.com/trento-project/web/pull/1993) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.23.2 to 7.23.3 in /assets [#1992](https://github.com/trento-project/web/pull/1992) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.23.2 to 7.23.3 in /assets [#1991](https://github.com/trento-project/web/pull/1991) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.23.0 to 7.23.3 in /assets [#1990](https://github.com/trento-project/web/pull/1990) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 7.6.0 to 8.0.0 in /assets [#1989](https://github.com/trento-project/web/pull/1989) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-react from 7.22.15 to 7.23.3 in /assets [#1988](https://github.com/trento-project/web/pull/1988) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.6.0 to 1.6.1 in /assets [#1986](https://github.com/trento-project/web/pull/1986) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/react from 14.0.0 to 14.1.0 in /assets [#1985](https://github.com/trento-project/web/pull/1985) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.5.2 to 7.5.3 in /assets [#1984](https://github.com/trento-project/web/pull/1984) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.5.2 to 7.5.3 in /assets [#1983](https://github.com/trento-project/web/pull/1983) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.5.2 to 7.5.3 in /assets [#1982](https://github.com/trento-project/web/pull/1982) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.5.2 to 7.5.3 in /assets [#1981](https://github.com/trento-project/web/pull/1981) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.5.2 to 7.5.3 in /assets [#1978](https://github.com/trento-project/web/pull/1978) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.5.2 to 7.5.3 in /assets [#1977](https://github.com/trento-project/web/pull/1977) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.5.2 to 7.5.3 in /assets [#1976](https://github.com/trento-project/web/pull/1976) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.52.0 to 8.53.0 in /assets [#1974](https://github.com/trento-project/web/pull/1974) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove Check-related action buttons from Host Details page [#1973](https://github.com/trento-project/web/pull/1973) ([jamie-suse](https://github.com/jamie-suse))
- Bump @storybook/react-webpack5 from 7.5.1 to 7.5.2 in /assets [#1971](https://github.com/trento-project/web/pull/1971) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.17.0 to 6.18.0 in /assets [#1970](https://github.com/trento-project/web/pull/1970) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 7.5.4 to 7.6.0 in /assets [#1969](https://github.com/trento-project/web/pull/1969) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.5.1 to 7.5.2 in /assets [#1968](https://github.com/trento-project/web/pull/1968) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.5.1 to 7.5.2 in /assets [#1967](https://github.com/trento-project/web/pull/1967) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.5.1 to 7.5.2 in /assets [#1966](https://github.com/trento-project/web/pull/1966) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.5.1 to 7.5.2 in /assets [#1965](https://github.com/trento-project/web/pull/1965) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.5.1 to 7.5.2 in /assets [#1964](https://github.com/trento-project/web/pull/1964) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.5.1 to 1.6.0 in /assets [#1963](https://github.com/trento-project/web/pull/1963) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 7.5.0 to 7.5.4 in /assets [#1962](https://github.com/trento-project/web/pull/1962) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump rc-tooltip from 6.1.1 to 6.1.2 in /assets [#1961](https://github.com/trento-project/web/pull/1961) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.4.3 to 27.6.0 in /assets [#1960](https://github.com/trento-project/web/pull/1960) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.3.4 to 3.3.5 in /assets [#1957](https://github.com/trento-project/web/pull/1957) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.3.3 to 3.3.4 in /assets [#1956](https://github.com/trento-project/web/pull/1956) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 7.4.0 to 7.5.0 in /assets [#1955](https://github.com/trento-project/web/pull/1955) ([dependabot[bot]](https://github.com/apps/dependabot))
- Checks catalog stories [#1953](https://github.com/trento-project/web/pull/1953) ([arbulu89](https://github.com/arbulu89))
- Bump actions/setup-node from 3 to 4 [#1952](https://github.com/trento-project/web/pull/1952) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-import from 2.28.1 to 2.29.0 in /assets [#1951](https://github.com/trento-project/web/pull/1951) ([dependabot[bot]](https://github.com/apps/dependabot))
- Normalize redux state content as snake_case [#1950](https://github.com/trento-project/web/pull/1950) ([arbulu89](https://github.com/arbulu89))
- Bump storybook from 7.5.0 to 7.5.1 in /assets [#1949](https://github.com/trento-project/web/pull/1949) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.4.2 to 27.4.3 in /assets [#1948](https://github.com/trento-project/web/pull/1948) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.5.0 to 7.5.1 in /assets [#1947](https://github.com/trento-project/web/pull/1947) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.51.0 to 8.52.0 in /assets [#1946](https://github.com/trento-project/web/pull/1946) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.5.0 to 7.5.1 in /assets [#1943](https://github.com/trento-project/web/pull/1943) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.5.0 to 7.5.1 in /assets [#1942](https://github.com/trento-project/web/pull/1942) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.5.0 to 7.5.1 in /assets [#1941](https://github.com/trento-project/web/pull/1941) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.5.0 to 7.5.1 in /assets [#1939](https://github.com/trento-project/web/pull/1939) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.4.6 to 7.5.0 in /assets [#1938](https://github.com/trento-project/web/pull/1938) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.4.6 to 7.5.0 in /assets [#1937](https://github.com/trento-project/web/pull/1937) ([dependabot[bot]](https://github.com/apps/dependabot))
- Modify expand check e2e test to fix flakiness [#1936](https://github.com/trento-project/web/pull/1936) ([arbulu89](https://github.com/arbulu89))
- Bump @storybook/react-webpack5 from 7.4.6 to 7.5.0 in /assets [#1934](https://github.com/trento-project/web/pull/1934) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.4.6 to 7.5.0 in /assets [#1933](https://github.com/trento-project/web/pull/1933) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.4.6 to 7.5.0 in /assets [#1932](https://github.com/trento-project/web/pull/1932) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.4.6 to 7.5.0 in /assets [#1931](https://github.com/trento-project/web/pull/1931) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.4.6 to 7.5.0 in /assets [#1930](https://github.com/trento-project/web/pull/1930) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/traverse from 7.20.12 to 7.23.2 in /test/e2e [#1929](https://github.com/trento-project/web/pull/1929) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.16.0 to 6.17.0 in /assets [#1928](https://github.com/trento-project/web/pull/1928) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.19.4 to 0.19.5 in /assets [#1927](https://github.com/trento-project/web/pull/1927) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 7.3.0 to 7.4.0 in /assets [#1926](https://github.com/trento-project/web/pull/1926) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @faker-js/faker from 8.1.0 to 8.2.0 in /assets [#1925](https://github.com/trento-project/web/pull/1925) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump prettier-eslint-cli from 7.1.0 to 8.0.1 in /assets [#1924](https://github.com/trento-project/web/pull/1924) ([dependabot[bot]](https://github.com/apps/dependabot))
- Saptune details view e2e test [#1923](https://github.com/trento-project/web/pull/1923) ([EMaksy](https://github.com/EMaksy))
- Update rabbitmq image in docker-compose [#1922](https://github.com/trento-project/web/pull/1922) ([dottorblaster](https://github.com/dottorblaster))
- Bump @babel/preset-env from 7.22.20 to 7.23.2 in /assets [#1921](https://github.com/trento-project/web/pull/1921) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.1.3 to 6.1.4 in /assets [#1920](https://github.com/trento-project/web/pull/1920) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.23.0 to 7.23.2 in /assets [#1919](https://github.com/trento-project/web/pull/1919) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add e2e tests for hosts health affected by saptune data [#1917](https://github.com/trento-project/web/pull/1917) ([arbulu89](https://github.com/arbulu89))
- Bump rc-tooltip from 6.1.0 to 6.1.1 in /assets [#1916](https://github.com/trento-project/web/pull/1916) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 7.2.3 to 7.3.0 in /assets [#1915](https://github.com/trento-project/web/pull/1915) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update 27 nodes scenario to use 2.1.0 agent version [#1914](https://github.com/trento-project/web/pull/1914) ([arbulu89](https://github.com/arbulu89))
- Bump eslint-plugin-storybook from 0.6.14 to 0.6.15 in /assets [#1912](https://github.com/trento-project/web/pull/1912) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.50.0 to 8.51.0 in /assets [#1911](https://github.com/trento-project/web/pull/1911) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 7.2.2 to 7.2.3 in /assets [#1910](https://github.com/trento-project/web/pull/1910) ([dependabot[bot]](https://github.com/apps/dependabot))
- UI updates to _Checks Selection_ pages [#1907](https://github.com/trento-project/web/pull/1907) ([jamie-suse](https://github.com/jamie-suse))
- Bump @storybook/react-webpack5 from 7.4.5 to 7.4.6 in /assets [#1904](https://github.com/trento-project/web/pull/1904) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 7.2.0 to 7.2.2 in /assets [#1903](https://github.com/trento-project/web/pull/1903) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.4.5 to 7.4.6 in /assets [#1902](https://github.com/trento-project/web/pull/1902) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.9.6 to 1.9.7 in /assets [#1901](https://github.com/trento-project/web/pull/1901) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.4.5 to 7.4.6 in /assets [#1899](https://github.com/trento-project/web/pull/1899) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.4.5 to 7.4.6 in /assets [#1898](https://github.com/trento-project/web/pull/1898) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.4.5 to 7.4.6 in /assets [#1897](https://github.com/trento-project/web/pull/1897) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.4.5 to 7.4.6 in /assets [#1896](https://github.com/trento-project/web/pull/1896) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.4.5 to 7.4.6 in /assets [#1895](https://github.com/trento-project/web/pull/1895) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump styfle/cancel-workflow-action from 0.11.0 to 0.12.0 [#1894](https://github.com/trento-project/web/pull/1894) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/testing-library from 0.2.1 to 0.2.2 in /assets [#1893](https://github.com/trento-project/web/pull/1893) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade react-markdown to 9.0.0 and remark-gfm to 4.0.0 [#1892](https://github.com/trento-project/web/pull/1892) ([dottorblaster](https://github.com/dottorblaster))
- Fix test after behaviour change [#1891](https://github.com/trento-project/web/pull/1891) ([arbulu89](https://github.com/arbulu89))
- Fix CI behaviour when on `main` branch [#1890](https://github.com/trento-project/web/pull/1890) ([jamie-suse](https://github.com/jamie-suse))
- Bump eslint-plugin-jest from 27.4.0 to 27.4.2 in /assets [#1889](https://github.com/trento-project/web/pull/1889) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-redux from 8.1.2 to 8.1.3 in /assets [#1888](https://github.com/trento-project/web/pull/1888) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update storybook control type from string to text [#1887](https://github.com/trento-project/web/pull/1887) ([EMaksy](https://github.com/EMaksy))
- Bump postcss from 8.4.30 to 8.4.31 in /assets [#1886](https://github.com/trento-project/web/pull/1886) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix cache-miss in CI pipeline [#1885](https://github.com/trento-project/web/pull/1885) ([jamie-suse](https://github.com/jamie-suse))
- Bump eslint from 8.49.0 to 8.50.0 in /assets [#1881](https://github.com/trento-project/web/pull/1881) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.19.3 to 0.19.4 in /assets [#1879](https://github.com/trento-project/web/pull/1879) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.5.0 to 1.5.1 in /assets [#1876](https://github.com/trento-project/web/pull/1876) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.4.3 to 7.4.5 in /assets [#1875](https://github.com/trento-project/web/pull/1875) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.4.3 to 7.4.5 in /assets [#1874](https://github.com/trento-project/web/pull/1874) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.4.3 to 7.4.5 in /assets [#1873](https://github.com/trento-project/web/pull/1873) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.4.2 to 7.4.5 in /assets [#1872](https://github.com/trento-project/web/pull/1872) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.20 to 7.23.0 in /assets [#1870](https://github.com/trento-project/web/pull/1870) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/testing-library from 0.2.0 to 0.2.1 in /assets [#1869](https://github.com/trento-project/web/pull/1869) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.4.3 to 7.4.5 in /assets [#1868](https://github.com/trento-project/web/pull/1868) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.22.15 to 7.23.0 in /assets [#1867](https://github.com/trento-project/web/pull/1867) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump rc-tooltip from 6.0.1 to 6.1.0 in /assets [#1863](https://github.com/trento-project/web/pull/1863) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.4.3 to 7.4.5 in /assets [#1862](https://github.com/trento-project/web/pull/1862) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.9.5 to 1.9.6 in /assets [#1861](https://github.com/trento-project/web/pull/1861) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.4.3 to 7.4.5 in /assets [#1860](https://github.com/trento-project/web/pull/1860) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-storybook from 0.6.13 to 0.6.14 in /assets [#1857](https://github.com/trento-project/web/pull/1857) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump remark-gfm from 3.0.1 to 4.0.0 in /assets [#1856](https://github.com/trento-project/web/pull/1856) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.4.2 to 7.4.3 in /assets [#1855](https://github.com/trento-project/web/pull/1855) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @faker-js/faker from 7.6.0 to 8.1.0 in /assets [#1854](https://github.com/trento-project/web/pull/1854) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.4.1 to 7.4.3 in /assets [#1853](https://github.com/trento-project/web/pull/1853) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.15 to 10.4.16 in /assets [#1852](https://github.com/trento-project/web/pull/1852) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.4.2 to 7.4.3 in /assets [#1851](https://github.com/trento-project/web/pull/1851) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.4.2 to 7.4.3 in /assets [#1850](https://github.com/trento-project/web/pull/1850) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.4.2 to 7.4.3 in /assets [#1849](https://github.com/trento-project/web/pull/1849) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.11.9 to 1.11.10 in /assets [#1847](https://github.com/trento-project/web/pull/1847) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.22.15 to 7.22.20 in /assets [#1846](https://github.com/trento-project/web/pull/1846) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 7.1.0 to 7.2.0 in /assets [#1845](https://github.com/trento-project/web/pull/1845) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.4.1 to 7.4.2 in /assets [#1844](https://github.com/trento-project/web/pull/1844) ([dependabot[bot]](https://github.com/apps/dependabot))
- Port check results detail page selectors to reselect [#1843](https://github.com/trento-project/web/pull/1843) ([dottorblaster](https://github.com/dottorblaster))
- Uniform Target Checks Selection [#1842](https://github.com/trento-project/web/pull/1842) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @testing-library/user-event from 14.5.0 to 14.5.1 in /assets [#1841](https://github.com/trento-project/web/pull/1841) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.29 to 8.4.30 in /assets [#1840](https://github.com/trento-project/web/pull/1840) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.4.1 to 7.4.2 in /assets [#1839](https://github.com/trento-project/web/pull/1839) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump semver and npm in /test/e2e [#1838](https://github.com/trento-project/web/pull/1838) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @cypress/request and cypress in /test/e2e [#1835](https://github.com/trento-project/web/pull/1835) ([dependabot[bot]](https://github.com/apps/dependabot))
- Align `primary` button style `disabled` state with UI proposal [#1834](https://github.com/trento-project/web/pull/1834) ([jamie-suse](https://github.com/jamie-suse))
- Bump @storybook/addon-links from 7.4.1 to 7.4.2 in /assets [#1832](https://github.com/trento-project/web/pull/1832) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.4.1 to 7.4.2 in /assets [#1831](https://github.com/trento-project/web/pull/1831) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.2.3 to 27.4.0 in /assets [#1830](https://github.com/trento-project/web/pull/1830) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.19 to 7.22.20 in /assets [#1829](https://github.com/trento-project/web/pull/1829) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.4.1 to 7.4.2 in /assets [#1828](https://github.com/trento-project/web/pull/1828) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.17 to 7.22.19 in /assets [#1827](https://github.com/trento-project/web/pull/1827) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/user-event from 14.4.3 to 14.5.0 in /assets [#1826](https://github.com/trento-project/web/pull/1826) ([dependabot[bot]](https://github.com/apps/dependabot))
- Enable navigation from host details to check results [#1825](https://github.com/trento-project/web/pull/1825) ([dottorblaster](https://github.com/dottorblaster))
- Bump esbuild from 0.19.2 to 0.19.3 in /assets [#1824](https://github.com/trento-project/web/pull/1824) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.15.0 to 6.16.0 in /assets [#1823](https://github.com/trento-project/web/pull/1823) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.6.4 to 29.7.0 in /assets [#1820](https://github.com/trento-project/web/pull/1820) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios-mock-adapter from 1.21.5 to 1.22.0 in /assets [#1819](https://github.com/trento-project/web/pull/1819) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.6.4 to 29.7.0 in /assets [#1818](https://github.com/trento-project/web/pull/1818) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.4.0 to 7.4.1 in /assets [#1817](https://github.com/trento-project/web/pull/1817) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.6.4 to 29.7.0 in /assets [#1816](https://github.com/trento-project/web/pull/1816) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/build-push-action from 4 to 5 [#1815](https://github.com/trento-project/web/pull/1815) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/setup-buildx-action from 2 to 3 [#1814](https://github.com/trento-project/web/pull/1814) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 4.6.0 to 5.0.0 [#1813](https://github.com/trento-project/web/pull/1813) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/login-action from 2.2.0 to 3.0.0 [#1812](https://github.com/trento-project/web/pull/1812) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.4.0 to 7.4.1 in /assets [#1808](https://github.com/trento-project/web/pull/1808) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.4.0 to 7.4.1 in /assets [#1807](https://github.com/trento-project/web/pull/1807) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.4.0 to 7.4.1 in /assets [#1806](https://github.com/trento-project/web/pull/1806) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.4.0 to 7.4.1 in /assets [#1804](https://github.com/trento-project/web/pull/1804) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.15 to 7.22.17 in /assets [#1799](https://github.com/trento-project/web/pull/1799) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.48.0 to 8.49.0 in /assets [#1798](https://github.com/trento-project/web/pull/1798) ([dependabot[bot]](https://github.com/apps/dependabot))
- Split FE and BE tests in the CI [#1797](https://github.com/trento-project/web/pull/1797) ([rtorrero](https://github.com/rtorrero))
- Bump chromatic from 7.0.0 to 7.1.0 in /assets [#1795](https://github.com/trento-project/web/pull/1795) ([dependabot[bot]](https://github.com/apps/dependabot))
- Host details storybook [#1793](https://github.com/trento-project/web/pull/1793) ([arbulu89](https://github.com/arbulu89))
- Wire up clean up modal [#1792](https://github.com/trento-project/web/pull/1792) ([rtorrero](https://github.com/rtorrero))
- Bump @testing-library/jest-dom from 6.1.2 to 6.1.3 in /assets [#1791](https://github.com/trento-project/web/pull/1791) ([dependabot[bot]](https://github.com/apps/dependabot))
- Application Instance Move only if clustered [#1790](https://github.com/trento-project/web/pull/1790) ([CDimonaco](https://github.com/CDimonaco))
- Bump chromatic from 6.24.1 to 7.0.0 in /assets [#1789](https://github.com/trento-project/web/pull/1789) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-react from 7.22.5 to 7.22.15 in /assets [#1787](https://github.com/trento-project/web/pull/1787) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.22.14 to 7.22.15 in /assets [#1786](https://github.com/trento-project/web/pull/1786) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.11 to 7.22.15 in /assets [#1785](https://github.com/trento-project/web/pull/1785) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/checkout from 3 to 4 [#1784](https://github.com/trento-project/web/pull/1784) ([dependabot[bot]](https://github.com/apps/dependabot))
- Instance cleanup e2e [#1783](https://github.com/trento-project/web/pull/1783) ([arbulu89](https://github.com/arbulu89))
- rowKey function for table rows [#1781](https://github.com/trento-project/web/pull/1781) ([dottorblaster](https://github.com/dottorblaster))
- Host checks execution scheduler [#1780](https://github.com/trento-project/web/pull/1780) ([EMaksy](https://github.com/EMaksy))
- Delta dereg details [#1778](https://github.com/trento-project/web/pull/1778) ([rtorrero](https://github.com/rtorrero))
- Add instance absent commands to commanded router [#1777](https://github.com/trento-project/web/pull/1777) ([arbulu89](https://github.com/arbulu89))
- Bump postcss from 8.4.28 to 8.4.29 in /assets [#1774](https://github.com/trento-project/web/pull/1774) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.22.10 to 7.22.14 in /assets [#1773](https://github.com/trento-project/web/pull/1773) ([dependabot[bot]](https://github.com/apps/dependabot))
- Clean up e2e tests from unnecessary content [#1771](https://github.com/trento-project/web/pull/1771) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump storybook from 7.3.2 to 7.4.0 in /assets [#1770](https://github.com/trento-project/web/pull/1770) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.3.2 to 7.4.0 in /assets [#1769](https://github.com/trento-project/web/pull/1769) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.3.2 to 7.4.0 in /assets [#1768](https://github.com/trento-project/web/pull/1768) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.3.2 to 7.4.0 in /assets [#1767](https://github.com/trento-project/web/pull/1767) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.3.2 to 7.4.0 in /assets [#1766](https://github.com/trento-project/web/pull/1766) ([dependabot[bot]](https://github.com/apps/dependabot))
- Speed up demo pipeline [#1765](https://github.com/trento-project/web/pull/1765) ([nelsonkopliku](https://github.com/nelsonkopliku))
- SapSystemsOverview and DatabasesOverview storybook [#1764](https://github.com/trento-project/web/pull/1764) ([arbulu89](https://github.com/arbulu89))
- Bump jest from 29.6.3 to 29.6.4 in /assets [#1763](https://github.com/trento-project/web/pull/1763) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.4.0 to 1.5.0 in /assets [#1762](https://github.com/trento-project/web/pull/1762) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.6.3 to 2.8.0 in /assets [#1761](https://github.com/trento-project/web/pull/1761) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.46.0 to 8.48.0 in /assets [#1760](https://github.com/trento-project/web/pull/1760) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.6.3 to 29.6.4 in /assets [#1759](https://github.com/trento-project/web/pull/1759) ([dependabot[bot]](https://github.com/apps/dependabot))
- Refactor sap system selectors [#1758](https://github.com/trento-project/web/pull/1758) ([arbulu89](https://github.com/arbulu89))
- Bump babel-jest from 29.6.3 to 29.6.4 in /assets [#1757](https://github.com/trento-project/web/pull/1757) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.10 to 7.22.11 in /assets [#1756](https://github.com/trento-project/web/pull/1756) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-config-prettier from 8.8.0 to 9.0.0 in /assets [#1755](https://github.com/trento-project/web/pull/1755) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 6.22.0 to 6.24.1 in /assets [#1754](https://github.com/trento-project/web/pull/1754) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.3.1 to 7.3.2 in /assets [#1751](https://github.com/trento-project/web/pull/1751) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.22.5 to 7.22.11 in /assets [#1750](https://github.com/trento-project/web/pull/1750) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.3.1 to 7.3.2 in /assets [#1749](https://github.com/trento-project/web/pull/1749) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.1.1 to 6.1.2 in /assets [#1748](https://github.com/trento-project/web/pull/1748) ([dependabot[bot]](https://github.com/apps/dependabot))
- Refactor sap system and database reducers [#1745](https://github.com/trento-project/web/pull/1745) ([arbulu89](https://github.com/arbulu89))
- Bump autoprefixer from 10.4.14 to 10.4.15 in /assets [#1744](https://github.com/trento-project/web/pull/1744) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.6.2 to 29.6.3 in /assets [#1743](https://github.com/trento-project/web/pull/1743) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 6.0.0 to 6.1.1 in /assets [#1742](https://github.com/trento-project/web/pull/1742) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.6.2 to 29.6.3 in /assets [#1741](https://github.com/trento-project/web/pull/1741) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.3.1 to 7.3.2 in /assets [#1736](https://github.com/trento-project/web/pull/1736) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.3.1 to 7.3.2 in /assets [#1735](https://github.com/trento-project/web/pull/1735) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.6.2 to 29.6.3 in /assets [#1734](https://github.com/trento-project/web/pull/1734) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump cypress-io/github-action from 5 to 6 [#1729](https://github.com/trento-project/web/pull/1729) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.14.2 to 6.15.0 in /assets [#1728](https://github.com/trento-project/web/pull/1728) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.3.1 to 7.3.2 in /assets [#1727](https://github.com/trento-project/web/pull/1727) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-import from 2.27.5 to 2.28.1 in /assets [#1726](https://github.com/trento-project/web/pull/1726) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.3.1 to 7.3.2 in /assets [#1725](https://github.com/trento-project/web/pull/1725) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.33.1 to 7.33.2 in /assets [#1724](https://github.com/trento-project/web/pull/1724) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.9 to 7.22.10 in /assets [#1723](https://github.com/trento-project/web/pull/1723) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 6.21.0 to 6.22.0 in /assets [#1722](https://github.com/trento-project/web/pull/1722) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.11 to 1.7.17 in /assets [#1721](https://github.com/trento-project/web/pull/1721) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 5.17.0 to 6.0.0 in /assets [#1720](https://github.com/trento-project/web/pull/1720) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 4.0.10 to 4.0.11 in /assets [#1719](https://github.com/trento-project/web/pull/1719) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.27 to 8.4.28 in /assets [#1718](https://github.com/trento-project/web/pull/1718) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade to Storybook 7.3.1 [#1717](https://github.com/trento-project/web/pull/1717) ([dottorblaster](https://github.com/dottorblaster))
- Bump @storybook/addon-essentials from 7.1.1 to 7.3.1 in /assets [#1716](https://github.com/trento-project/web/pull/1716) ([dependabot[bot]](https://github.com/apps/dependabot))
- Sid linking from clusters [#1715](https://github.com/trento-project/web/pull/1715) ([rtorrero](https://github.com/rtorrero))
- Bump esbuild from 0.18.20 to 0.19.2 in /assets [#1712](https://github.com/trento-project/web/pull/1712) ([dependabot[bot]](https://github.com/apps/dependabot))
- Reselect [#1711](https://github.com/trento-project/web/pull/1711) ([dottorblaster](https://github.com/dottorblaster))
- Fix host checks selection ui [#1710](https://github.com/trento-project/web/pull/1710) ([EMaksy](https://github.com/EMaksy))
- Bump bots-house/ghcr-delete-image-action from 1.0.0 to 1.1.0 [#1708](https://github.com/trento-project/web/pull/1708) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 6.20.0 to 6.21.0 in /assets [#1705](https://github.com/trento-project/web/pull/1705) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.22.9 to 7.22.10 in /assets [#1702](https://github.com/trento-project/web/pull/1702) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-redux from 8.1.1 to 8.1.2 in /assets [#1700](https://github.com/trento-project/web/pull/1700) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tough-cookie and @cypress/request in /test/e2e [#1699](https://github.com/trento-project/web/pull/1699) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.45.0 to 8.46.0 in /assets [#1698](https://github.com/trento-project/web/pull/1698) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.1.1 to 7.2.1 in /assets [#1697](https://github.com/trento-project/web/pull/1697) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.18.17 to 0.18.20 in /assets [#1696](https://github.com/trento-project/web/pull/1696) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.1.1 to 7.2.1 in /assets [#1695](https://github.com/trento-project/web/pull/1695) ([dependabot[bot]](https://github.com/apps/dependabot))
- Switch check to allow for future check groups increase [#1692](https://github.com/trento-project/web/pull/1692) ([rtorrero](https://github.com/rtorrero))
- Lodash [#1691](https://github.com/trento-project/web/pull/1691) ([dottorblaster](https://github.com/dottorblaster))
- Reduce flakiness [#1689](https://github.com/trento-project/web/pull/1689) ([rtorrero](https://github.com/rtorrero))
- Bump eslint-plugin-react from 7.32.2 to 7.33.1 in /assets [#1684](https://github.com/trento-project/web/pull/1684) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.6.1 to 29.6.2 in /assets [#1683](https://github.com/trento-project/web/pull/1683) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.6.1 to 29.6.2 in /assets [#1680](https://github.com/trento-project/web/pull/1680) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.6.1 to 29.6.2 in /assets [#1679](https://github.com/trento-project/web/pull/1679) ([dependabot[bot]](https://github.com/apps/dependabot))

## [2.1.0](https://github.com/trento-project/web/tree/2.1.0) (2023-08-02)

[Full Changelog](https://github.com/trento-project/web/compare/2.0.0...2.1.0)

**Implemented enhancements:**

- Use centralized checks selection for both hosts and clusters [#1641](https://github.com/trento-project/web/pull/1641) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Refactor check selection saga [#1635](https://github.com/trento-project/web/pull/1635) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add 'Clean up' button to Host Details page [#1623](https://github.com/trento-project/web/pull/1623) ([jamie-suse](https://github.com/jamie-suse))
- Host Checks selection saga [#1618](https://github.com/trento-project/web/pull/1618) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Broadcast tags and value objects in restore events [#1602](https://github.com/trento-project/web/pull/1602) ([arbulu89](https://github.com/arbulu89))
- Deregister hosts list frontend [#1601](https://github.com/trento-project/web/pull/1601) ([arbulu89](https://github.com/arbulu89))
- Load selectable checks for a host [#1600](https://github.com/trento-project/web/pull/1600) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add cleanup button component [#1599](https://github.com/trento-project/web/pull/1599) ([arbulu89](https://github.com/arbulu89))
- ApplicationInstanceMoved FE side-effects [#1579](https://github.com/trento-project/web/pull/1579) ([fabriziosestito](https://github.com/fabriziosestito))
- Project broadcast application instance moved [#1570](https://github.com/trento-project/web/pull/1570) ([fabriziosestito](https://github.com/fabriziosestito))
- Update contracts usage [#1567](https://github.com/trento-project/web/pull/1567) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add ensa version to sap systems overview entries [#1561](https://github.com/trento-project/web/pull/1561) ([arbulu89](https://github.com/arbulu89))
- Handle linking to unregistered hosts [#1560](https://github.com/trento-project/web/pull/1560) ([rtorrero](https://github.com/rtorrero))
- Add ensa version sap system details [#1559](https://github.com/trento-project/web/pull/1559) ([arbulu89](https://github.com/arbulu89))
- Add application cluster column to health summary view [#1552](https://github.com/trento-project/web/pull/1552) ([arbulu89](https://github.com/arbulu89))
- Add select host checks endpoint [#1544](https://github.com/trento-project/web/pull/1544) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Sap system link cluster details [#1543](https://github.com/trento-project/web/pull/1543) ([arbulu89](https://github.com/arbulu89))
- Add projector for host checks selection [#1542](https://github.com/trento-project/web/pull/1542) ([EMaksy](https://github.com/EMaksy))
- Add Host Check Selection Domain logic [#1524](https://github.com/trento-project/web/pull/1524) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Display ENSA version frontend [#1515](https://github.com/trento-project/web/pull/1515) ([arbulu89](https://github.com/arbulu89))
- Add CheckResultsOverview story [#1511](https://github.com/trento-project/web/pull/1511) ([EMaksy](https://github.com/EMaksy))
- Add text to loading state cluster details [#1510](https://github.com/trento-project/web/pull/1510) ([EMaksy](https://github.com/EMaksy))
- Add resource type when filtering the catalog [#1509](https://github.com/trento-project/web/pull/1509) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add resourceType when querying for checks in cluster checks selection [#1506](https://github.com/trento-project/web/pull/1506) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Disable check execution button while loading [#1503](https://github.com/trento-project/web/pull/1503) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Send cluster type to wanda [#1480](https://github.com/trento-project/web/pull/1480) ([arbulu89](https://github.com/arbulu89))
- UX improvements in ASCS/ERS and HANA cluster details view [#1479](https://github.com/trento-project/web/pull/1479) ([arbulu89](https://github.com/arbulu89))
- Add cluster nodes details to ASCS/ERS cluster details view [#1472](https://github.com/trento-project/web/pull/1472) ([arbulu89](https://github.com/arbulu89))
- ASCS/ERS cluster details component [#1466](https://github.com/trento-project/web/pull/1466) ([arbulu89](https://github.com/arbulu89))
- Display cluster details by type [#1456](https://github.com/trento-project/web/pull/1456) ([arbulu89](https://github.com/arbulu89))
- Display check failure message [#1451](https://github.com/trento-project/web/pull/1451) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Persist selected filters in checks results inside Redux [#1445](https://github.com/trento-project/web/pull/1445) ([dottorblaster](https://github.com/dottorblaster))
- Dotted pagination [#1443](https://github.com/trento-project/web/pull/1443) ([arbulu89](https://github.com/arbulu89))
- Refactor cluster details [#1428](https://github.com/trento-project/web/pull/1428) ([arbulu89](https://github.com/arbulu89))
- Do not render Values section when no values are available [#1415](https://github.com/trento-project/web/pull/1415) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix 404 page when wrong filtered catalog is being used in execution results page [#1414](https://github.com/trento-project/web/pull/1414) ([EMaksy](https://github.com/EMaksy))
- Allow custom css in table rows [#1410](https://github.com/trento-project/web/pull/1410) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Checks results grouped by category [#1397](https://github.com/trento-project/web/pull/1397) ([EMaksy](https://github.com/EMaksy))

**Fixed bugs:**

- Fix SR status broadcast on database instance registration [#1687](https://github.com/trento-project/web/pull/1687) ([arbulu89](https://github.com/arbulu89))
- Return whole host read model in registered projection [#1678](https://github.com/trento-project/web/pull/1678) ([arbulu89](https://github.com/arbulu89))
- Remove app db instances state [#1672](https://github.com/trento-project/web/pull/1672) ([arbulu89](https://github.com/arbulu89))
- Listen to deregistration events to update home view state [#1653](https://github.com/trento-project/web/pull/1653) ([arbulu89](https://github.com/arbulu89))
- Fix database sid display [#1639](https://github.com/trento-project/web/pull/1639) ([arbulu89](https://github.com/arbulu89))
- Fix application instance deletion after_update [#1616](https://github.com/trento-project/web/pull/1616) ([arbulu89](https://github.com/arbulu89))
- Remove host aggregate changeset [#1592](https://github.com/trento-project/web/pull/1592) ([arbulu89](https://github.com/arbulu89))
- Fix ApplicationInstanceMoved notifications [#1586](https://github.com/trento-project/web/pull/1586) ([fabriziosestito](https://github.com/fabriziosestito))
- Pin correct contracts version [#1580](https://github.com/trento-project/web/pull/1580) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add missing target_type query param to catalog when loading execution results page [#1568](https://github.com/trento-project/web/pull/1568) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Handle evaluation errors [#1486](https://github.com/trento-project/web/pull/1486) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix navigation to a running execution detail [#1457](https://github.com/trento-project/web/pull/1457) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Improve scalar values support in FactValue [#1416](https://github.com/trento-project/web/pull/1416) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix text size rendering expectation results [#1383](https://github.com/trento-project/web/pull/1383) ([dottorblaster](https://github.com/dottorblaster))
- Fix wrong filtered catalog being used in execution results page [#1375](https://github.com/trento-project/web/pull/1375) ([nelsonkopliku](https://github.com/nelsonkopliku))

**Closed issues:**

- Installation script points to wrong rpm repository [#1370](https://github.com/trento-project/web/issues/1370)
- Extract usecases for Checks selection and Connection settings [#429](https://github.com/trento-project/web/issues/429)
- Refactor Tagging [#222](https://github.com/trento-project/web/issues/222)
- Add an Arrow icon to the expandable tables [#220](https://github.com/trento-project/web/issues/220)

**Merged pull requests:**

- Skip tests that are still missing bugfixes [#1686](https://github.com/trento-project/web/pull/1686) ([rtorrero](https://github.com/rtorrero))
- Bump @storybook/addon-links from 7.1.0 to 7.1.1 in /assets [#1677](https://github.com/trento-project/web/pull/1677) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.1.0 to 7.1.1 in /assets [#1676](https://github.com/trento-project/web/pull/1676) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.18.16 to 0.18.17 in /assets [#1675](https://github.com/trento-project/web/pull/1675) ([dependabot[bot]](https://github.com/apps/dependabot))
- Send and receive explicit restoration events [#1673](https://github.com/trento-project/web/pull/1673) ([jamie-suse](https://github.com/jamie-suse))
- Bump @storybook/react-webpack5 from 7.1.0 to 7.1.1 in /assets [#1671](https://github.com/trento-project/web/pull/1671) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.1.0 to 7.1.1 in /assets [#1670](https://github.com/trento-project/web/pull/1670) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.6.2 to 2.6.3 in /assets [#1668](https://github.com/trento-project/web/pull/1668) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.1.0 to 7.1.1 in /assets [#1666](https://github.com/trento-project/web/pull/1666) ([dependabot[bot]](https://github.com/apps/dependabot))
- E2e restoration [#1665](https://github.com/trento-project/web/pull/1665) ([rtorrero](https://github.com/rtorrero))
- Switch to UUIDs inside catalog Jest testing [#1664](https://github.com/trento-project/web/pull/1664) ([dottorblaster](https://github.com/dottorblaster))
- Bump esbuild from 0.18.14 to 0.18.16 in /assets [#1663](https://github.com/trento-project/web/pull/1663) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 6.19.9 to 6.20.0 in /assets [#1662](https://github.com/trento-project/web/pull/1662) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.26 to 8.4.27 in /assets [#1660](https://github.com/trento-project/web/pull/1660) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/jest-dom from 5.16.5 to 5.17.0 in /assets [#1657](https://github.com/trento-project/web/pull/1657) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.6.1 to 2.6.2 in /assets [#1656](https://github.com/trento-project/web/pull/1656) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-storybook from 0.6.12 to 0.6.13 in /assets [#1655](https://github.com/trento-project/web/pull/1655) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.8 to 7.22.9 in /assets [#1654](https://github.com/trento-project/web/pull/1654) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade Storybook to 7.1 [#1650](https://github.com/trento-project/web/pull/1650) ([dottorblaster](https://github.com/dottorblaster))
- Add end-to-end deregistration tests for Host Details page [#1649](https://github.com/trento-project/web/pull/1649) ([jamie-suse](https://github.com/jamie-suse))
- Bump word-wrap from 1.2.3 to 1.2.4 in /test/e2e [#1648](https://github.com/trento-project/web/pull/1648) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump word-wrap from 1.2.3 to 1.2.4 in /assets [#1647](https://github.com/trento-project/web/pull/1647) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove obsolete live feed FE code [#1646](https://github.com/trento-project/web/pull/1646) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump eslint-plugin-jest from 27.2.2 to 27.2.3 in /assets [#1645](https://github.com/trento-project/web/pull/1645) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.0.27 to 7.1.0 in /assets [#1644](https://github.com/trento-project/web/pull/1644) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.27 to 7.1.0 in /assets [#1643](https://github.com/trento-project/web/pull/1643) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.27 to 7.1.0 in /assets [#1642](https://github.com/trento-project/web/pull/1642) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.18.11 to 0.18.14 in /assets [#1638](https://github.com/trento-project/web/pull/1638) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.44.0 to 8.45.0 in /assets [#1637](https://github.com/trento-project/web/pull/1637) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.14.1 to 6.14.2 in /assets [#1636](https://github.com/trento-project/web/pull/1636) ([dependabot[bot]](https://github.com/apps/dependabot))
- E2e test deregistration cascading [#1634](https://github.com/trento-project/web/pull/1634) ([rtorrero](https://github.com/rtorrero))
- Bump @storybook/addon-interactions from 7.0.26 to 7.0.27 in /assets [#1633](https://github.com/trento-project/web/pull/1633) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.25 to 8.4.26 in /assets [#1632](https://github.com/trento-project/web/pull/1632) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.22.7 to 7.22.9 in /assets [#1631](https://github.com/trento-project/web/pull/1631) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.3.2 to 3.3.3 in /assets [#1630](https://github.com/trento-project/web/pull/1630) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add test to check for Clean up button visibility [#1629](https://github.com/trento-project/web/pull/1629) ([rtorrero](https://github.com/rtorrero))
- Bump @storybook/addon-essentials from 7.0.26 to 7.0.27 in /assets [#1628](https://github.com/trento-project/web/pull/1628) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.26 to 7.0.27 in /assets [#1627](https://github.com/trento-project/web/pull/1627) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.26 to 7.0.27 in /assets [#1626](https://github.com/trento-project/web/pull/1626) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.0.26 to 7.0.27 in /assets [#1625](https://github.com/trento-project/web/pull/1625) ([dependabot[bot]](https://github.com/apps/dependabot))
- Projectors refactor [#1624](https://github.com/trento-project/web/pull/1624) ([CDimonaco](https://github.com/CDimonaco))
- Bump semver from 7.5.3 to 7.5.4 in /assets [#1622](https://github.com/trento-project/web/pull/1622) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.24 to 8.4.25 in /assets [#1621](https://github.com/trento-project/web/pull/1621) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.13.0 to 6.14.1 in /assets [#1620](https://github.com/trento-project/web/pull/1620) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.0.25 to 7.0.26 in /assets [#1619](https://github.com/trento-project/web/pull/1619) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.5.0 to 29.6.1 in /assets [#1615](https://github.com/trento-project/web/pull/1615) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.22.5 to 7.22.7 in /assets [#1614](https://github.com/trento-project/web/pull/1614) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.25 to 7.0.26 in /assets [#1613](https://github.com/trento-project/web/pull/1613) ([dependabot[bot]](https://github.com/apps/dependabot))
- Only broadcast `HostRemovedFromCluster` when a host is part of a cluster [#1611](https://github.com/trento-project/web/pull/1611) ([jamie-suse](https://github.com/jamie-suse))
- Bump babel-loader from 9.1.2 to 9.1.3 in /assets [#1610](https://github.com/trento-project/web/pull/1610) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.0.25 to 7.0.26 in /assets [#1609](https://github.com/trento-project/web/pull/1609) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.25 to 7.0.26 in /assets [#1608](https://github.com/trento-project/web/pull/1608) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tough-cookie from 4.1.2 to 4.1.3 in /assets [#1607](https://github.com/trento-project/web/pull/1607) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.43.0 to 8.44.0 in /assets [#1606](https://github.com/trento-project/web/pull/1606) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-redux from 8.1.0 to 8.1.1 in /assets [#1605](https://github.com/trento-project/web/pull/1605) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.6.0 to 29.6.1 in /assets [#1604](https://github.com/trento-project/web/pull/1604) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.5 to 7.22.8 in /assets [#1603](https://github.com/trento-project/web/pull/1603) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 6.19.7 to 6.19.9 in /assets [#1598](https://github.com/trento-project/web/pull/1598) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.0.25 to 7.0.26 in /assets [#1597](https://github.com/trento-project/web/pull/1597) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.0.25 to 7.0.26 in /assets [#1595](https://github.com/trento-project/web/pull/1595) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add database deregistered event usage to redux [#1594](https://github.com/trento-project/web/pull/1594) ([arbulu89](https://github.com/arbulu89))
- Filter out deregistered hosts from heartbeat failed checking [#1593](https://github.com/trento-project/web/pull/1593) ([arbulu89](https://github.com/arbulu89))
- Bump @storybook/addon-essentials from 7.0.23 to 7.0.25 in /assets [#1591](https://github.com/trento-project/web/pull/1591) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.11.8 to 1.11.9 in /assets [#1590](https://github.com/trento-project/web/pull/1590) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.18.9 to 0.18.11 in /assets [#1589](https://github.com/trento-project/web/pull/1589) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.5.0 to 29.6.0 in /assets [#1588](https://github.com/trento-project/web/pull/1588) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add ability to mark Hosts as `deregisterable` [#1587](https://github.com/trento-project/web/pull/1587) ([jamie-suse](https://github.com/jamie-suse))
- Bump @storybook/addon-links from 7.0.21 to 7.0.25 in /assets [#1585](https://github.com/trento-project/web/pull/1585) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.0.23 to 7.0.25 in /assets [#1584](https://github.com/trento-project/web/pull/1584) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.20 to 7.0.25 in /assets [#1583](https://github.com/trento-project/web/pull/1583) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.22 to 7.0.25 in /assets [#1582](https://github.com/trento-project/web/pull/1582) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add ChecksSelection component [#1577](https://github.com/trento-project/web/pull/1577) ([dottorblaster](https://github.com/dottorblaster))
- Bump semver from 7.5.2 to 7.5.3 in /assets [#1574](https://github.com/trento-project/web/pull/1574) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.0.23 to 7.0.24 in /assets [#1572](https://github.com/trento-project/web/pull/1572) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.18.6 to 0.18.9 in /assets [#1569](https://github.com/trento-project/web/pull/1569) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.0.20 to 7.0.23 in /assets [#1566](https://github.com/trento-project/web/pull/1566) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.2.1 to 27.2.2 in /assets [#1565](https://github.com/trento-project/web/pull/1565) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.0.18 to 7.0.23 in /assets [#1564](https://github.com/trento-project/web/pull/1564) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-react from 7.22.3 to 7.22.5 in /assets [#1562](https://github.com/trento-project/web/pull/1562) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump html-webpack-plugin from 5.5.1 to 5.5.3 in /assets [#1557](https://github.com/trento-project/web/pull/1557) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/testing-library from 0.1.0 to 0.2.0 in /assets [#1556](https://github.com/trento-project/web/pull/1556) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.18.5 to 0.18.6 in /assets [#1555](https://github.com/trento-project/web/pull/1555) ([dependabot[bot]](https://github.com/apps/dependabot))
- Enforce fact and value name uniqueness [#1553](https://github.com/trento-project/web/pull/1553) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Enforce expectation names uniqueness in CheckResultOutline test [#1549](https://github.com/trento-project/web/pull/1549) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @storybook/react-webpack5 from 7.0.18 to 7.0.22 in /assets [#1548](https://github.com/trento-project/web/pull/1548) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.42.0 to 8.43.0 in /assets [#1547](https://github.com/trento-project/web/pull/1547) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.19 to 0.18.5 in /assets [#1546](https://github.com/trento-project/web/pull/1546) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.22.4 to 7.22.5 in /assets [#1541](https://github.com/trento-project/web/pull/1541) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.6.0 to 2.6.1 in /assets [#1540](https://github.com/trento-project/web/pull/1540) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios-mock-adapter from 1.21.4 to 1.21.5 in /assets [#1539](https://github.com/trento-project/web/pull/1539) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.0.20 to 7.0.22 in /assets [#1538](https://github.com/trento-project/web/pull/1538) ([dependabot[bot]](https://github.com/apps/dependabot))
- Avoid duplicated expectation names from catalog factories [#1536](https://github.com/trento-project/web/pull/1536) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @storybook/addon-links from 7.0.20 to 7.0.21 in /assets [#1535](https://github.com/trento-project/web/pull/1535) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.22.1 to 7.22.5 in /assets [#1534](https://github.com/trento-project/web/pull/1534) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump semver from 7.5.1 to 7.5.2 in /assets [#1533](https://github.com/trento-project/web/pull/1533) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.5.6 to 2.6.0 in /assets [#1532](https://github.com/trento-project/web/pull/1532) ([dependabot[bot]](https://github.com/apps/dependabot))
- Move databases/sapsystems sagas functions to separate files following adr 0009 [#1531](https://github.com/trento-project/web/pull/1531) ([rtorrero](https://github.com/rtorrero))
- Add HomeHealthSummary storybook [#1529](https://github.com/trento-project/web/pull/1529) ([arbulu89](https://github.com/arbulu89))
- Bump react-router-dom from 6.11.2 to 6.13.0 in /assets [#1528](https://github.com/trento-project/web/pull/1528) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 6.18.0 to 6.19.7 in /assets [#1527](https://github.com/trento-project/web/pull/1527) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-redux from 8.0.7 to 8.1.0 in /assets [#1526](https://github.com/trento-project/web/pull/1526) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 4.0.9 to 4.0.10 in /assets [#1525](https://github.com/trento-project/web/pull/1525) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.21.5 to 7.22.5 in /assets [#1519](https://github.com/trento-project/web/pull/1519) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 4.5.0 to 4.6.0 [#1518](https://github.com/trento-project/web/pull/1518) ([dependabot[bot]](https://github.com/apps/dependabot))
- Rename resource_type to target_type in catalog interaction [#1514](https://github.com/trento-project/web/pull/1514) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @storybook/addon-essentials from 7.0.18 to 7.0.20 in /assets [#1502](https://github.com/trento-project/web/pull/1502) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.0.18 to 7.0.20 in /assets [#1501](https://github.com/trento-project/web/pull/1501) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.0.18 to 7.0.20 in /assets [#1500](https://github.com/trento-project/web/pull/1500) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.18 to 7.0.20 in /assets [#1499](https://github.com/trento-project/web/pull/1499) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/login-action from 2.1.0 to 2.2.0 [#1498](https://github.com/trento-project/web/pull/1498) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 4.4.0 to 4.5.0 [#1497](https://github.com/trento-project/web/pull/1497) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.41.0 to 8.42.0 in /assets [#1494](https://github.com/trento-project/web/pull/1494) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.11.7 to 1.11.8 in /assets [#1490](https://github.com/trento-project/web/pull/1490) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-react from 7.18.6 to 7.22.3 in /assets [#1485](https://github.com/trento-project/web/pull/1485) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.21.8 to 7.22.1 in /assets [#1484](https://github.com/trento-project/web/pull/1484) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-redux from 8.0.5 to 8.0.7 in /assets [#1482](https://github.com/trento-project/web/pull/1482) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.21.5 to 7.22.4 in /assets [#1481](https://github.com/trento-project/web/pull/1481) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 6.17.4 to 6.18.0 in /assets [#1478](https://github.com/trento-project/web/pull/1478) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.17 to 7.0.18 in /assets [#1477](https://github.com/trento-project/web/pull/1477) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.0.17 to 7.0.18 in /assets [#1476](https://github.com/trento-project/web/pull/1476) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 4.0.4 to 4.0.9 in /assets [#1475](https://github.com/trento-project/web/pull/1475) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.0.17 to 7.0.18 in /assets [#1471](https://github.com/trento-project/web/pull/1471) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.0.17 to 7.0.18 in /assets [#1470](https://github.com/trento-project/web/pull/1470) ([dependabot[bot]](https://github.com/apps/dependabot))
- Improve tooltip styling [#1469](https://github.com/trento-project/web/pull/1469) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Self host Lato font [#1467](https://github.com/trento-project/web/pull/1467) ([dottorblaster](https://github.com/dottorblaster))
- Bump @storybook/addon-links from 7.0.17 to 7.0.18 in /assets [#1465](https://github.com/trento-project/web/pull/1465) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.23 to 8.4.24 in /assets [#1464](https://github.com/trento-project/web/pull/1464) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.5.4 to 2.5.6 in /assets [#1463](https://github.com/trento-project/web/pull/1463) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.17 to 7.0.18 in /assets [#1462](https://github.com/trento-project/web/pull/1462) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.0.12 to 7.0.17 in /assets [#1460](https://github.com/trento-project/web/pull/1460) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.12 to 7.0.17 in /assets [#1459](https://github.com/trento-project/web/pull/1459) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.0.12 to 7.0.17 in /assets [#1458](https://github.com/trento-project/web/pull/1458) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.0.15 to 7.0.17 in /assets [#1455](https://github.com/trento-project/web/pull/1455) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.15 to 7.0.17 in /assets [#1454](https://github.com/trento-project/web/pull/1454) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.0.15 to 7.0.17 in /assets [#1453](https://github.com/trento-project/web/pull/1453) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.5.3 to 2.5.4 in /assets [#1452](https://github.com/trento-project/web/pull/1452) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.12 to 7.0.15 in /assets [#1449](https://github.com/trento-project/web/pull/1449) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.0.12 to 7.0.15 in /assets [#1447](https://github.com/trento-project/web/pull/1447) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.0.12 to 7.0.15 in /assets [#1446](https://github.com/trento-project/web/pull/1446) ([dependabot[bot]](https://github.com/apps/dependabot))
- Rename sections in Expectations Details view [#1444](https://github.com/trento-project/web/pull/1444) ([EMaksy](https://github.com/EMaksy))
- Bump storybook from 7.0.11 to 7.0.12 in /assets [#1437](https://github.com/trento-project/web/pull/1437) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.40.0 to 8.41.0 in /assets [#1436](https://github.com/trento-project/web/pull/1436) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.5.2 to 2.5.3 in /assets [#1435](https://github.com/trento-project/web/pull/1435) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.3.1 to 3.3.2 in /assets [#1434](https://github.com/trento-project/web/pull/1434) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.4.0 to 2.5.2 in /assets [#1433](https://github.com/trento-project/web/pull/1433) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.11.1 to 6.11.2 in /assets [#1431](https://github.com/trento-project/web/pull/1431) ([dependabot[bot]](https://github.com/apps/dependabot))
- Deregistration [#1430](https://github.com/trento-project/web/pull/1430) ([arbulu89](https://github.com/arbulu89))
- Bump @storybook/addon-links from 7.0.11 to 7.0.12 in /assets [#1427](https://github.com/trento-project/web/pull/1427) ([dependabot[bot]](https://github.com/apps/dependabot))
- Use absolute urls for documentation assets [#1426](https://github.com/trento-project/web/pull/1426) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Update copyright message in UI bottom left to include year 2023 [#1423](https://github.com/trento-project/web/pull/1423) ([EMaksy](https://github.com/EMaksy))
- Bump @storybook/react-webpack5 from 7.0.11 to 7.0.12 in /assets [#1421](https://github.com/trento-project/web/pull/1421) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.0.11 to 7.0.12 in /assets [#1420](https://github.com/trento-project/web/pull/1420) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.0.11 to 7.0.12 in /assets [#1419](https://github.com/trento-project/web/pull/1419) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump semver from 7.5.0 to 7.5.1 in /assets [#1418](https://github.com/trento-project/web/pull/1418) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upgrade to storybook 7.0.11 as a whole [#1412](https://github.com/trento-project/web/pull/1412) ([dottorblaster](https://github.com/dottorblaster))
- Bump @storybook/addon-actions from 7.0.7 to 7.0.11 in /assets [#1409](https://github.com/trento-project/web/pull/1409) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.0.7 to 7.0.11 in /assets [#1408](https://github.com/trento-project/web/pull/1408) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.0.8 to 7.0.11 in /assets [#1407](https://github.com/trento-project/web/pull/1407) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.16 to 0.17.19 in /assets [#1406](https://github.com/trento-project/web/pull/1406) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.21.4 to 7.21.8 in /assets [#1402](https://github.com/trento-project/web/pull/1402) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-hot-toast from 2.4.0 to 2.4.1 in /assets [#1401](https://github.com/trento-project/web/pull/1401) ([dependabot[bot]](https://github.com/apps/dependabot))
- Automatically accept changes on Chromatic [#1399](https://github.com/trento-project/web/pull/1399) ([dottorblaster](https://github.com/dottorblaster))
- Bump @heroicons/react from 2.0.17 to 2.0.18 in /assets [#1396](https://github.com/trento-project/web/pull/1396) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.3.6 to 1.4.0 in /assets [#1393](https://github.com/trento-project/web/pull/1393) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-accessible-treeview from 2.3.4 to 2.4.0 in /assets [#1391](https://github.com/trento-project/web/pull/1391) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 2.29.3 to 2.30.0 in /assets [#1390](https://github.com/trento-project/web/pull/1390) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.8 to 7.0.9 in /assets [#1389](https://github.com/trento-project/web/pull/1389) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.10.0 to 6.11.1 in /assets [#1388](https://github.com/trento-project/web/pull/1388) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.38.0 to 8.40.0 in /assets [#1385](https://github.com/trento-project/web/pull/1385) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix flaky e2e test [#1384](https://github.com/trento-project/web/pull/1384) ([dottorblaster](https://github.com/dottorblaster))
- Bump @babel/preset-env from 7.21.4 to 7.21.5 in /assets [#1382](https://github.com/trento-project/web/pull/1382) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-storybook from 0.6.11 to 0.6.12 in /assets [#1381](https://github.com/trento-project/web/pull/1381) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump chromatic from 6.17.3 to 6.17.4 in /assets [#1380](https://github.com/trento-project/web/pull/1380) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 7.0.4 to 7.0.8 in /assets [#1378](https://github.com/trento-project/web/pull/1378) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.6 to 7.0.8 in /assets [#1376](https://github.com/trento-project/web/pull/1376) ([dependabot[bot]](https://github.com/apps/dependabot))
- Use trento-project/trento-e2e and plain OpenSUSE AMI in e2e tests [#1374](https://github.com/trento-project/web/pull/1374) ([fabriziosestito](https://github.com/fabriziosestito))
- Chromatic [#1373](https://github.com/trento-project/web/pull/1373) ([dottorblaster](https://github.com/dottorblaster))
- Bump docker/metadata-action from 4.3.0 to 4.4.0 [#1344](https://github.com/trento-project/web/pull/1344) ([dependabot[bot]](https://github.com/apps/dependabot))
- New checks UI [#1253](https://github.com/trento-project/web/pull/1253) ([nelsonkopliku](https://github.com/nelsonkopliku))

## [2.0.0](https://github.com/trento-project/web/tree/2.0.0) (2023-04-27)

[Full Changelog](https://github.com/trento-project/web/compare/1.2.0...2.0.0)

**Implemented enhancements:**

- Add stories for Eula subcomponents [#1316](https://github.com/trento-project/web/pull/1316) ([EMaksy](https://github.com/EMaksy))
- Add stories for the AboutPage components [#1310](https://github.com/trento-project/web/pull/1310) ([EMaksy](https://github.com/EMaksy))
- Add a story for the WarningBanner component [#1304](https://github.com/trento-project/web/pull/1304) ([EMaksy](https://github.com/EMaksy))
- Sapsystem rollup [#1272](https://github.com/trento-project/web/pull/1272) ([rtorrero](https://github.com/rtorrero))
- Agent version warning [#1259](https://github.com/trento-project/web/pull/1259) ([arbulu89](https://github.com/arbulu89))
- Jest table filter tests on the overview pages [#1212](https://github.com/trento-project/web/pull/1212) ([arbulu89](https://github.com/arbulu89))
- Tidy up notifications saga [#1211](https://github.com/trento-project/web/pull/1211) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Cleanup Cluster selectors [#1210](https://github.com/trento-project/web/pull/1210) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix start execution interaction [#1206](https://github.com/trento-project/web/pull/1206) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix Check selection hint style [#1202](https://github.com/trento-project/web/pull/1202) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Page components enhancements [#1141](https://github.com/trento-project/web/pull/1141) ([rtorrero](https://github.com/rtorrero))
- Add a checks provider filter for catalog_new view [#1136](https://github.com/trento-project/web/pull/1136) ([EMaksy](https://github.com/EMaksy))
- Bump BCI base image to 15.4 [#1130](https://github.com/trento-project/web/pull/1130) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add premium pill to the check selection view [#1115](https://github.com/trento-project/web/pull/1115) ([arbulu89](https://github.com/arbulu89))
- Add remediation content [#1114](https://github.com/trento-project/web/pull/1114) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Allow getCatalog wanda call to filter by provider [#1098](https://github.com/trento-project/web/pull/1098) ([rtorrero](https://github.com/rtorrero))
- Add provider icon host views [#1097](https://github.com/trento-project/web/pull/1097) ([arbulu89](https://github.com/arbulu89))
- Remove connection settings when using wanda [#1094](https://github.com/trento-project/web/pull/1094) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Remove redux logic from  TriggerChecksExecutionRequest component [#1076](https://github.com/trento-project/web/pull/1076) ([EMaksy](https://github.com/EMaksy))
- Add ChecksSelectionHints in the ExecutionResults [#1071](https://github.com/trento-project/web/pull/1071) ([EMaksy](https://github.com/EMaksy))
- Transition start execution running [#1056](https://github.com/trento-project/web/pull/1056) ([arbulu89](https://github.com/arbulu89))
- Jwt authentication [#1042](https://github.com/trento-project/web/pull/1042) ([CDimonaco](https://github.com/CDimonaco))
- Broadcast execution completed [#1023](https://github.com/trento-project/web/pull/1023) ([fabriziosestito](https://github.com/fabriziosestito))
- Add SBD_OPTS to cluster discovery events [#996](https://github.com/trento-project/web/pull/996) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Checks results coming from Wanda [#987](https://github.com/trento-project/web/pull/987) ([dottorblaster](https://github.com/dottorblaster))
- Checks selection from wanda [#976](https://github.com/trento-project/web/pull/976) ([arbulu89](https://github.com/arbulu89))
- Improve catalog container usability [#968](https://github.com/trento-project/web/pull/968) ([arbulu89](https://github.com/arbulu89))
- Make SAP Instances status icon interactive [#961](https://github.com/trento-project/web/pull/961) ([EMaksy](https://github.com/EMaksy))
- Catalog from wanda [#960](https://github.com/trento-project/web/pull/960) ([arbulu89](https://github.com/arbulu89))

**Fixed bugs:**

- Handle properly the not found scenario in exporters_status [#1277](https://github.com/trento-project/web/pull/1277) ([arbulu89](https://github.com/arbulu89))
- Fix remaining act warning [#1247](https://github.com/trento-project/web/pull/1247) ([arbulu89](https://github.com/arbulu89))
- Add extra second to heartbeat interval to avoid glitches [#1243](https://github.com/trento-project/web/pull/1243) ([arbulu89](https://github.com/arbulu89))
- Fix some act wrapping warnings [#1236](https://github.com/trento-project/web/pull/1236) ([arbulu89](https://github.com/arbulu89))
- Filter Component UI fixes [#1230](https://github.com/trento-project/web/pull/1230) ([jagabomb](https://github.com/jagabomb))
- Fix margin between filter elements [#1226](https://github.com/trento-project/web/pull/1226) ([EMaksy](https://github.com/EMaksy))
- Fix flag short option in the dump script [#1214](https://github.com/trento-project/web/pull/1214) ([arbulu89](https://github.com/arbulu89))
- Fix home page filters background color on selected [#1205](https://github.com/trento-project/web/pull/1205) ([arbulu89](https://github.com/arbulu89))
- Fix css bugs [#1197](https://github.com/trento-project/web/pull/1197) ([EMaksy](https://github.com/EMaksy))
- Fix layout rendering when not logged-in [#1138](https://github.com/trento-project/web/pull/1138) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix prettier checker [#1121](https://github.com/trento-project/web/pull/1121) ([dottorblaster](https://github.com/dottorblaster))
- Socket Initialization on user login [#1109](https://github.com/trento-project/web/pull/1109) ([CDimonaco](https://github.com/CDimonaco))
- Fix frontend formatting tasks [#1041](https://github.com/trento-project/web/pull/1041) ([CDimonaco](https://github.com/CDimonaco))
- Fix AboutPage test console error output [#1031](https://github.com/trento-project/web/pull/1031) ([EMaksy](https://github.com/EMaksy))
- Add fix cluster details overview date format [#1030](https://github.com/trento-project/web/pull/1030) ([arbulu89](https://github.com/arbulu89))
- Eslint fix [#1016](https://github.com/trento-project/web/pull/1016) ([CDimonaco](https://github.com/CDimonaco))
- Disable link to unavailable pacemaker cluster detail in home/health summary [#1007](https://github.com/trento-project/web/pull/1007) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Help tailwind's JIT figure which classes we need [#1005](https://github.com/trento-project/web/pull/1005) ([rtorrero](https://github.com/rtorrero))
- Fix tagging test in hosts overview e2e suite [#975](https://github.com/trento-project/web/pull/975) ([arbulu89](https://github.com/arbulu89))

**Merged pull requests:**

- Bump @storybook/addon-essentials from 7.0.5 to 7.0.7 in /assets [#1362](https://github.com/trento-project/web/pull/1362) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.5 to 7.0.7 in /assets [#1361](https://github.com/trento-project/web/pull/1361) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.0.5 to 7.0.7 in /assets [#1360](https://github.com/trento-project/web/pull/1360) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.3.5 to 1.3.6 in /assets [#1351](https://github.com/trento-project/web/pull/1351) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.21 to 8.4.23 in /assets [#1350](https://github.com/trento-project/web/pull/1350) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 4.0.3 to 4.0.4 in /assets [#1349](https://github.com/trento-project/web/pull/1349) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add single-hana-single-app dumped scenario [#1348](https://github.com/trento-project/web/pull/1348) ([arbulu89](https://github.com/arbulu89))
- Bump @storybook/react-webpack5 from 7.0.4 to 7.0.6 in /assets [#1346](https://github.com/trento-project/web/pull/1346) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 7.0.4 to 7.0.6 in /assets [#1345](https://github.com/trento-project/web/pull/1345) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove dependabot auto merge action [#1342](https://github.com/trento-project/web/pull/1342) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump @reduxjs/toolkit from 1.9.3 to 1.9.5 in /assets [#1341](https://github.com/trento-project/web/pull/1341) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump semver from 7.4.0 to 7.5.0 in /assets [#1338](https://github.com/trento-project/web/pull/1338) ([dependabot[bot]](https://github.com/apps/dependabot))
- [POC] HANA scale-up e2e tests with a real cluster  [#1337](https://github.com/trento-project/web/pull/1337) ([fabriziosestito](https://github.com/fabriziosestito))
- Make api key enablement configurable in runtime [#1335](https://github.com/trento-project/web/pull/1335) ([arbulu89](https://github.com/arbulu89))
- Bump @storybook/addon-essentials from 7.0.4 to 7.0.5 in /assets [#1334](https://github.com/trento-project/web/pull/1334) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.4 to 7.0.5 in /assets [#1332](https://github.com/trento-project/web/pull/1332) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 7.0.2 to 7.0.5 in /assets [#1331](https://github.com/trento-project/web/pull/1331) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-markdown from 8.0.6 to 8.0.7 in /assets [#1330](https://github.com/trento-project/web/pull/1330) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.3 to 7.0.4 in /assets [#1329](https://github.com/trento-project/web/pull/1329) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.0.3 to 7.0.4 in /assets [#1328](https://github.com/trento-project/web/pull/1328) ([dependabot[bot]](https://github.com/apps/dependabot))
- Idempotent user seeding [#1327](https://github.com/trento-project/web/pull/1327) ([CDimonaco](https://github.com/CDimonaco))
- Bump @storybook/addon-links from 7.0.2 to 7.0.4 in /assets [#1323](https://github.com/trento-project/web/pull/1323) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 7.0.3 to 7.0.4 in /assets [#1322](https://github.com/trento-project/web/pull/1322) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.3 to 7.0.4 in /assets [#1321](https://github.com/trento-project/web/pull/1321) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 7.0.2 to 7.0.3 in /assets [#1320](https://github.com/trento-project/web/pull/1320) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump storybook from 7.0.2 to 7.0.3 in /assets [#1319](https://github.com/trento-project/web/pull/1319) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react-webpack5 from 7.0.2 to 7.0.3 in /assets [#1318](https://github.com/trento-project/web/pull/1318) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump semver from 7.3.8 to 7.4.0 in /assets [#1313](https://github.com/trento-project/web/pull/1313) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.37.0 to 8.38.0 in /assets [#1312](https://github.com/trento-project/web/pull/1312) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.15 to 0.17.16 in /assets [#1311](https://github.com/trento-project/web/pull/1311) ([dependabot[bot]](https://github.com/apps/dependabot))
- Added ListView story [#1309](https://github.com/trento-project/web/pull/1309) ([jagabomb](https://github.com/jagabomb))
- Add PremiumPill directory with a story [#1308](https://github.com/trento-project/web/pull/1308) ([EMaksy](https://github.com/EMaksy))
- Added Tooltip story [#1307](https://github.com/trento-project/web/pull/1307) ([jagabomb](https://github.com/jagabomb))
- Bump axios from 1.3.4 to 1.3.5 in /assets [#1306](https://github.com/trento-project/web/pull/1306) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.14 to 0.17.15 in /assets [#1305](https://github.com/trento-project/web/pull/1305) ([dependabot[bot]](https://github.com/apps/dependabot))
- Button stories [#1303](https://github.com/trento-project/web/pull/1303) ([dottorblaster](https://github.com/dottorblaster))
- Upgrade to Storybook 7 [#1302](https://github.com/trento-project/web/pull/1302) ([dottorblaster](https://github.com/dottorblaster))
- Bump axios-mock-adapter from 1.21.2 to 1.21.4 in /assets [#1300](https://github.com/trento-project/web/pull/1300) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.20.2 to 7.21.4 in /assets [#1299](https://github.com/trento-project/web/pull/1299) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.21.3 to 7.21.4 in /assets [#1298](https://github.com/trento-project/web/pull/1298) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @heroicons/react from 2.0.16 to 2.0.17 in /assets [#1297](https://github.com/trento-project/web/pull/1297) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.2.7 to 3.3.1 in /assets [#1296](https://github.com/trento-project/web/pull/1296) ([dependabot[bot]](https://github.com/apps/dependabot))
- Capture tests logs [#1295](https://github.com/trento-project/web/pull/1295) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump react-router-dom from 6.9.0 to 6.10.0 in /assets [#1294](https://github.com/trento-project/web/pull/1294) ([dependabot[bot]](https://github.com/apps/dependabot))
- Refactor controllers and contexts error handling [#1290](https://github.com/trento-project/web/pull/1290) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump eslint from 8.36.0 to 8.37.0 in /assets [#1289](https://github.com/trento-project/web/pull/1289) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 4.0.2 to 4.0.3 in /assets [#1287](https://github.com/trento-project/web/pull/1287) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add healthcheck and readiness endpoints [#1286](https://github.com/trento-project/web/pull/1286) ([jamie-suse](https://github.com/jamie-suse))
- Bump esbuild from 0.17.12 to 0.17.14 in /assets [#1285](https://github.com/trento-project/web/pull/1285) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 4.0.1 to 4.0.2 in /assets [#1281](https://github.com/trento-project/web/pull/1281) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 4.0.0 to 4.0.1 in /assets [#1276](https://github.com/trento-project/web/pull/1276) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-error-boundary from 3.1.4 to 4.0.0 in /assets [#1273](https://github.com/trento-project/web/pull/1273) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add dev.local.exs usage [#1271](https://github.com/trento-project/web/pull/1271) ([arbulu89](https://github.com/arbulu89))
- Bump react-markdown from 8.0.5 to 8.0.6 in /assets [#1270](https://github.com/trento-project/web/pull/1270) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-config-prettier from 8.7.0 to 8.8.0 in /assets [#1269](https://github.com/trento-project/web/pull/1269) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump redux-saga from 1.2.2 to 1.2.3 in /assets [#1267](https://github.com/trento-project/web/pull/1267) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.11 to 0.17.12 in /assets [#1266](https://github.com/trento-project/web/pull/1266) ([dependabot[bot]](https://github.com/apps/dependabot))
- Disable snapshotting for the Host aggregate [#1265](https://github.com/trento-project/web/pull/1265) ([fabriziosestito](https://github.com/fabriziosestito))
- Add Openapi spec to prometheus controller [#1263](https://github.com/trento-project/web/pull/1263) ([CDimonaco](https://github.com/CDimonaco))
- Bump webpack from 5.75.0 to 5.76.1 in /test/e2e [#1262](https://github.com/trento-project/web/pull/1262) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump webpack from 5.74.0 to 5.76.1 in /assets [#1261](https://github.com/trento-project/web/pull/1261) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.21.0 to 7.21.3 in /assets [#1260](https://github.com/trento-project/web/pull/1260) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jaxxstorm/action-install-gh-release from 1.9.0 to 1.10.0 [#1258](https://github.com/trento-project/web/pull/1258) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add ErrorView test [#1257](https://github.com/trento-project/web/pull/1257) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump eslint from 8.35.0 to 8.36.0 in /assets [#1255](https://github.com/trento-project/web/pull/1255) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.8.2 to 6.9.0 in /assets [#1254](https://github.com/trento-project/web/pull/1254) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump photofinish to v1.2.2 in CI [#1251](https://github.com/trento-project/web/pull/1251) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump autoprefixer from 10.4.13 to 10.4.14 in /assets [#1250](https://github.com/trento-project/web/pull/1250) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add Checks warning banner when provider is VMware [#1244](https://github.com/trento-project/web/pull/1244) ([jamie-suse](https://github.com/jamie-suse))
- Refactor API errors [#1242](https://github.com/trento-project/web/pull/1242) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump jest-environment-jsdom from 29.4.3 to 29.5.0 in /assets [#1241](https://github.com/trento-project/web/pull/1241) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.4.3 to 29.5.0 in /assets [#1240](https://github.com/trento-project/web/pull/1240) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.4.3 to 29.5.0 in /assets [#1239](https://github.com/trento-project/web/pull/1239) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-config-prettier from 8.6.0 to 8.7.0 in /assets [#1238](https://github.com/trento-project/web/pull/1238) ([dependabot[bot]](https://github.com/apps/dependabot))
- Host rollup [#1237](https://github.com/trento-project/web/pull/1237) ([CDimonaco](https://github.com/CDimonaco))
- Bump esbuild from 0.17.10 to 0.17.11 in /assets [#1233](https://github.com/trento-project/web/pull/1233) ([dependabot[bot]](https://github.com/apps/dependabot))
- Compile and test with --warnings-as-errors flag [#1229](https://github.com/trento-project/web/pull/1229) ([fabriziosestito](https://github.com/fabriziosestito))
- Update commanded and commanded_ecto_projections [#1227](https://github.com/trento-project/web/pull/1227) ([fabriziosestito](https://github.com/fabriziosestito))
- Remove router warnings [#1225](https://github.com/trento-project/web/pull/1225) ([fabriziosestito](https://github.com/fabriziosestito))
- Vmware provider [#1224](https://github.com/trento-project/web/pull/1224) ([CDimonaco](https://github.com/CDimonaco))
- Bump react-router-dom from 6.8.1 to 6.8.2 in /assets [#1222](https://github.com/trento-project/web/pull/1222) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.34.0 to 8.35.0 in /assets [#1220](https://github.com/trento-project/web/pull/1220) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/checkout from 2 to 3 [#1219](https://github.com/trento-project/web/pull/1219) ([dependabot[bot]](https://github.com/apps/dependabot))
- Refactor AMQP adapters and Check integration service [#1218](https://github.com/trento-project/web/pull/1218) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump @babel/plugin-transform-modules-commonjs from 7.20.11 to 7.21.2 in /assets [#1217](https://github.com/trento-project/web/pull/1217) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add generic Table filtering tests on jest [#1216](https://github.com/trento-project/web/pull/1216) ([arbulu89](https://github.com/arbulu89))
- Remove table filtering tests from cypress suite [#1215](https://github.com/trento-project/web/pull/1215) ([arbulu89](https://github.com/arbulu89))
- Bump axios from 1.3.3 to 1.3.4 in /assets [#1213](https://github.com/trento-project/web/pull/1213) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.20.12 to 7.21.0 in /assets [#1209](https://github.com/trento-project/web/pull/1209) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.9.2 to 1.9.3 in /assets [#1208](https://github.com/trento-project/web/pull/1208) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.9 to 0.17.10 in /assets [#1207](https://github.com/trento-project/web/pull/1207) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @heroicons/react from 2.0.15 to 2.0.16 in /assets [#1204](https://github.com/trento-project/web/pull/1204) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.8 to 0.17.9 in /assets [#1203](https://github.com/trento-project/web/pull/1203) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add new demo-deploy dispatch action [#1201](https://github.com/trento-project/web/pull/1201) ([rtorrero](https://github.com/rtorrero))
- Bump tailwindcss from 3.2.6 to 3.2.7 in /assets [#1200](https://github.com/trento-project/web/pull/1200) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/react from 13.4.0 to 14.0.0 in /assets [#1199](https://github.com/trento-project/web/pull/1199) ([dependabot[bot]](https://github.com/apps/dependabot))
- Check base url injected into the client via global config object [#1198](https://github.com/trento-project/web/pull/1198) ([CDimonaco](https://github.com/CDimonaco))
- Setup ci demo wanda [#1196](https://github.com/trento-project/web/pull/1196) ([arbulu89](https://github.com/arbulu89))
- Bump jest from 29.4.2 to 29.4.3 in /assets [#1195](https://github.com/trento-project/web/pull/1195) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.4.2 to 29.4.3 in /assets [#1194](https://github.com/trento-project/web/pull/1194) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.4.2 to 29.4.3 in /assets [#1193](https://github.com/trento-project/web/pull/1193) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.10 to 1.7.11 in /assets [#1192](https://github.com/trento-project/web/pull/1192) ([dependabot[bot]](https://github.com/apps/dependabot))
- Prevent e2e tests to run twice [#1191](https://github.com/trento-project/web/pull/1191) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix team name in dependabot reviewers [#1190](https://github.com/trento-project/web/pull/1190) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump esbuild from 0.17.7 to 0.17.8 in /assets [#1189](https://github.com/trento-project/web/pull/1189) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.3.2 to 1.3.3 in /assets [#1188](https://github.com/trento-project/web/pull/1188) ([dependabot[bot]](https://github.com/apps/dependabot))
- Checks Api pinned to v1 in frontend client [#1187](https://github.com/trento-project/web/pull/1187) ([CDimonaco](https://github.com/CDimonaco))
- Fix docs creation [#1186](https://github.com/trento-project/web/pull/1186) ([arbulu89](https://github.com/arbulu89))
- Remove architecture docs [#1185](https://github.com/trento-project/web/pull/1185) ([arbulu89](https://github.com/arbulu89))
- Bump eslint from 8.33.0 to 8.34.0 in /assets [#1184](https://github.com/trento-project/web/pull/1184) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.6 to 0.17.7 in /assets [#1183](https://github.com/trento-project/web/pull/1183) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @heroicons/react from 2.0.14 to 2.0.15 in /assets [#1182](https://github.com/trento-project/web/pull/1182) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.2.4 to 3.2.6 in /assets [#1181](https://github.com/trento-project/web/pull/1181) ([dependabot[bot]](https://github.com/apps/dependabot))
- Pin Api version v1 [#1180](https://github.com/trento-project/web/pull/1180) ([CDimonaco](https://github.com/CDimonaco))
- Run CI `test` step on different versions of Elixir & OTP [#1179](https://github.com/trento-project/web/pull/1179) ([jamie-suse](https://github.com/jamie-suse))
- Add reviewers to dependabot [#1178](https://github.com/trento-project/web/pull/1178) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump babel-jest from 29.4.1 to 29.4.2 in /assets [#1177](https://github.com/trento-project/web/pull/1177) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.4.1 to 29.4.2 in /assets [#1176](https://github.com/trento-project/web/pull/1176) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.4.1 to 29.4.2 in /assets [#1175](https://github.com/trento-project/web/pull/1175) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.5 to 0.17.6 in /assets [#1174](https://github.com/trento-project/web/pull/1174) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.9 to 1.7.10 in /assets [#1173](https://github.com/trento-project/web/pull/1173) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.8.0 to 6.8.1 in /assets [#1172](https://github.com/trento-project/web/pull/1172) ([dependabot[bot]](https://github.com/apps/dependabot))
- Disable CronJobs when run from IEx in `dev` [#1171](https://github.com/trento-project/web/pull/1171) ([jamie-suse](https://github.com/jamie-suse))
- Remove legacy runner events [#1170](https://github.com/trento-project/web/pull/1170) ([arbulu89](https://github.com/arbulu89))
- Bump axios from 1.3.1 to 1.3.2 in /assets [#1169](https://github.com/trento-project/web/pull/1169) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.8 to 1.7.9 in /assets [#1168](https://github.com/trento-project/web/pull/1168) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.3.0 to 1.3.1 in /assets [#1167](https://github.com/trento-project/web/pull/1167) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.2.4 to 1.3.0 in /assets [#1166](https://github.com/trento-project/web/pull/1166) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.4.0 to 29.4.1 in /assets [#1164](https://github.com/trento-project/web/pull/1164) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.7 to 1.7.8 in /assets [#1163](https://github.com/trento-project/web/pull/1163) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.15 to 6.5.16 in /assets [#1162](https://github.com/trento-project/web/pull/1162) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/build-push-action from 3 to 4 [#1161](https://github.com/trento-project/web/pull/1161) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.15 to 6.5.16 in /assets [#1160](https://github.com/trento-project/web/pull/1160) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.32.1 to 7.32.2 in /assets [#1159](https://github.com/trento-project/web/pull/1159) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.9.1 to 1.9.2 in /assets [#1158](https://github.com/trento-project/web/pull/1158) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.4 to 0.17.5 in /assets [#1157](https://github.com/trento-project/web/pull/1157) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.32.0 to 8.33.0 in /assets [#1156](https://github.com/trento-project/web/pull/1156) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.7.0 to 6.8.0 in /assets [#1155](https://github.com/trento-project/web/pull/1155) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.4.0 to 29.4.1 in /assets [#1154](https://github.com/trento-project/web/pull/1154) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.15 to 6.5.16 in /assets [#1153](https://github.com/trento-project/web/pull/1153) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.15 to 6.5.16 in /assets [#1151](https://github.com/trento-project/web/pull/1151) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update the Readme and hack_on_trento guide [#1150](https://github.com/trento-project/web/pull/1150) ([EMaksy](https://github.com/EMaksy))
- Bump @heroicons/react from 2.0.13 to 2.0.14 in /assets [#1149](https://github.com/trento-project/web/pull/1149) ([dependabot[bot]](https://github.com/apps/dependabot))
- Chore: auth clean-up [#1148](https://github.com/trento-project/web/pull/1148) ([fabriziosestito](https://github.com/fabriziosestito))
- Remove legacy cluster details [#1147](https://github.com/trento-project/web/pull/1147) ([arbulu89](https://github.com/arbulu89))
- Bump jest from 29.3.1 to 29.4.0 in /assets [#1146](https://github.com/trento-project/web/pull/1146) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.3.1 to 29.4.0 in /assets [#1145](https://github.com/trento-project/web/pull/1145) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.3.1 to 29.4.0 in /assets [#1144](https://github.com/trento-project/web/pull/1144) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.2.3 to 1.2.4 in /assets [#1143](https://github.com/trento-project/web/pull/1143) ([dependabot[bot]](https://github.com/apps/dependabot))
- Skip temporarily the hana cluster e2e tests [#1142](https://github.com/trento-project/web/pull/1142) ([arbulu89](https://github.com/arbulu89))
- Execution started event [#1140](https://github.com/trento-project/web/pull/1140) ([CDimonaco](https://github.com/CDimonaco))
- Fix login error [#1139](https://github.com/trento-project/web/pull/1139) ([fabriziosestito](https://github.com/fabriziosestito))
- Remove legacy runner backend [#1137](https://github.com/trento-project/web/pull/1137) ([arbulu89](https://github.com/arbulu89))
- Rename wanda -> checks [#1135](https://github.com/trento-project/web/pull/1135) ([fabriziosestito](https://github.com/fabriziosestito))
- Remove legacy catalog frontend [#1134](https://github.com/trento-project/web/pull/1134) ([arbulu89](https://github.com/arbulu89))
- Frontend wanda client with authentication interceptors [#1133](https://github.com/trento-project/web/pull/1133) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump esbuild from 0.17.3 to 0.17.4 in /assets [#1131](https://github.com/trento-project/web/pull/1131) ([dependabot[bot]](https://github.com/apps/dependabot))
- Freeze demo deployment stages in ci [#1129](https://github.com/trento-project/web/pull/1129) ([arbulu89](https://github.com/arbulu89))
- Bump react-router-dom from 6.6.2 to 6.7.0 in /assets [#1128](https://github.com/trento-project/web/pull/1128) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.2 to 0.17.3 in /assets [#1127](https://github.com/trento-project/web/pull/1127) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove ssh address references [#1126](https://github.com/trento-project/web/pull/1126) ([arbulu89](https://github.com/arbulu89))
- Bump axios from 1.2.2 to 1.2.3 in /assets [#1124](https://github.com/trento-project/web/pull/1124) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.17.1 to 0.17.2 in /assets [#1123](https://github.com/trento-project/web/pull/1123) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-markdown from 8.0.4 to 8.0.5 in /assets [#1122](https://github.com/trento-project/web/pull/1122) ([dependabot[bot]](https://github.com/apps/dependabot))
- Adjust markdown component in execution results [#1120](https://github.com/trento-project/web/pull/1120) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump esbuild from 0.16.17 to 0.17.1 in /assets [#1119](https://github.com/trento-project/web/pull/1119) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.32.0 to 7.32.1 in /assets [#1118](https://github.com/trento-project/web/pull/1118) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-import from 2.27.4 to 2.27.5 in /assets [#1117](https://github.com/trento-project/web/pull/1117) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add Authentication Documentation as ExDoc guide [#1116](https://github.com/trento-project/web/pull/1116) ([CDimonaco](https://github.com/CDimonaco))
- Bump eslint from 8.31.0 to 8.32.0 in /assets [#1113](https://github.com/trento-project/web/pull/1113) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 4.2.0 to 4.3.0 [#1111](https://github.com/trento-project/web/pull/1111) ([dependabot[bot]](https://github.com/apps/dependabot))
- Rollup fixes [#1110](https://github.com/trento-project/web/pull/1110) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump axios from 1.2.1 to 1.2.2 in /assets [#1108](https://github.com/trento-project/web/pull/1108) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-import from 2.27.2 to 2.27.4 in /assets [#1107](https://github.com/trento-project/web/pull/1107) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios-auth-refresh from 3.3.4 to 3.3.6 in /assets [#1106](https://github.com/trento-project/web/pull/1106) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix e2e [#1105](https://github.com/trento-project/web/pull/1105) ([dottorblaster](https://github.com/dottorblaster))
- Bump json5 from 1.0.1 to 1.0.2 in /assets [#1104](https://github.com/trento-project/web/pull/1104) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.31.11 to 7.32.0 in /assets [#1103](https://github.com/trento-project/web/pull/1103) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-import from 2.26.0 to 2.27.2 in /assets [#1102](https://github.com/trento-project/web/pull/1102) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jsx-a11y from 6.7.0 to 6.7.1 in /assets [#1101](https://github.com/trento-project/web/pull/1101) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.16.16 to 0.16.17 in /assets [#1100](https://github.com/trento-project/web/pull/1100) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 4.1.1 to 4.2.0 [#1099](https://github.com/trento-project/web/pull/1099) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.6.1 to 6.6.2 in /assets [#1096](https://github.com/trento-project/web/pull/1096) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jsx-a11y from 6.6.1 to 6.7.0 in /assets [#1095](https://github.com/trento-project/web/pull/1095) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.20 to 8.4.21 in /assets [#1093](https://github.com/trento-project/web/pull/1093) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.2.0 to 27.2.1 in /assets [#1092](https://github.com/trento-project/web/pull/1092) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.16.13 to 0.16.16 in /assets [#1091](https://github.com/trento-project/web/pull/1091) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump json5 from 1.0.1 to 1.0.2 in /assets [#1090](https://github.com/trento-project/web/pull/1090) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-loader from 9.1.0 to 9.1.2 in /assets [#1089](https://github.com/trento-project/web/pull/1089) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.20.7 to 7.20.12 in /assets [#1087](https://github.com/trento-project/web/pull/1087) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.16.12 to 0.16.13 in /assets [#1086](https://github.com/trento-project/web/pull/1086) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-config-prettier from 8.5.0 to 8.6.0 in /assets [#1085](https://github.com/trento-project/web/pull/1085) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.30.0 to 8.31.0 in /assets [#1084](https://github.com/trento-project/web/pull/1084) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.1.7 to 27.2.0 in /assets [#1083](https://github.com/trento-project/web/pull/1083) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.2.1 to 1.2.2 in /assets [#1082](https://github.com/trento-project/web/pull/1082) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.16.11 to 0.16.12 in /assets [#1081](https://github.com/trento-project/web/pull/1081) ([dependabot[bot]](https://github.com/apps/dependabot))
- Tooltip, SomethingWentWrong unit tests [#1080](https://github.com/trento-project/web/pull/1080) ([dottorblaster](https://github.com/dottorblaster))
- Bump esbuild from 0.16.10 to 0.16.11 in /assets [#1079](https://github.com/trento-project/web/pull/1079) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.6.0 to 6.6.1 in /assets [#1078](https://github.com/trento-project/web/pull/1078) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.20.7 to 7.20.11 in /assets [#1077](https://github.com/trento-project/web/pull/1077) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.20.5 to 7.20.7 in /assets [#1075](https://github.com/trento-project/web/pull/1075) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.19.6 to 7.20.7 in /assets [#1074](https://github.com/trento-project/web/pull/1074) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix Checks results filters [#1073](https://github.com/trento-project/web/pull/1073) ([jamie-suse](https://github.com/jamie-suse))
- Bump react-router-dom from 6.5.0 to 6.6.0 in /assets [#1072](https://github.com/trento-project/web/pull/1072) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.14 to 6.5.15 in /assets [#1070](https://github.com/trento-project/web/pull/1070) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.14 to 6.5.15 in /assets [#1069](https://github.com/trento-project/web/pull/1069) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.14 to 6.5.15 in /assets [#1067](https://github.com/trento-project/web/pull/1067) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.14 to 6.5.15 in /assets [#1066](https://github.com/trento-project/web/pull/1066) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.16.9 to 0.16.10 in /assets [#1065](https://github.com/trento-project/web/pull/1065) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add filter to Execution Results page [#1064](https://github.com/trento-project/web/pull/1064) ([jamie-suse](https://github.com/jamie-suse))
- Add cluster info box to execution view [#1063](https://github.com/trento-project/web/pull/1063) ([arbulu89](https://github.com/arbulu89))
- Bump react-router-dom from 6.4.5 to 6.5.0 in /assets [#1062](https://github.com/trento-project/web/pull/1062) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.29.0 to 8.30.0 in /assets [#1061](https://github.com/trento-project/web/pull/1061) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.6 to 1.7.7 in /assets [#1060](https://github.com/trento-project/web/pull/1060) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.16.7 to 0.16.9 in /assets [#1059](https://github.com/trento-project/web/pull/1059) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.1.6 to 27.1.7 in /assets [#1058](https://github.com/trento-project/web/pull/1058) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.5 to 1.7.6 in /assets [#1057](https://github.com/trento-project/web/pull/1057) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.16.5 to 0.16.7 in /assets [#1055](https://github.com/trento-project/web/pull/1055) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix ESLint warning about unnamed function [#1054](https://github.com/trento-project/web/pull/1054) ([dottorblaster](https://github.com/dottorblaster))
- Bump esbuild from 0.15.18 to 0.16.5 in /assets [#1053](https://github.com/trento-project/web/pull/1053) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jaxxstorm/action-install-gh-release from 1.8.0 to 1.9.0 [#1052](https://github.com/trento-project/web/pull/1052) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump redux-saga from 1.2.1 to 1.2.2 in /assets [#1051](https://github.com/trento-project/web/pull/1051) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.19 to 8.4.20 in /assets [#1050](https://github.com/trento-project/web/pull/1050) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jaxxstorm/action-install-gh-release from 1.7.1 to 1.8.0 [#1048](https://github.com/trento-project/web/pull/1048) ([dependabot[bot]](https://github.com/apps/dependabot))
- Read `ExecutionResults` state from Redux store [#1047](https://github.com/trento-project/web/pull/1047) ([EMaksy](https://github.com/EMaksy))
- Bump @headlessui/react from 1.7.4 to 1.7.5 in /assets [#1045](https://github.com/trento-project/web/pull/1045) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss-import from 15.0.1 to 15.1.0 in /assets [#1044](https://github.com/trento-project/web/pull/1044) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.4.4 to 6.4.5 in /assets [#1043](https://github.com/trento-project/web/pull/1043) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.11.6 to 1.11.7 in /assets [#1040](https://github.com/trento-project/web/pull/1040) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.13 to 6.5.14 in /assets [#1038](https://github.com/trento-project/web/pull/1038) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.13 to 6.5.14 in /assets [#1037](https://github.com/trento-project/web/pull/1037) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.15.16 to 0.15.18 in /assets [#1036](https://github.com/trento-project/web/pull/1036) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.2.0 to 1.2.1 in /assets [#1035](https://github.com/trento-project/web/pull/1035) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.28.0 to 8.29.0 in /assets [#1034](https://github.com/trento-project/web/pull/1034) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump cypress-io/github-action from 4 to 5 [#1033](https://github.com/trento-project/web/pull/1033) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix get health [#1032](https://github.com/trento-project/web/pull/1032) ([arbulu89](https://github.com/arbulu89))
- Bump decode-uri-component from 0.2.0 to 0.2.2 in /assets [#1029](https://github.com/trento-project/web/pull/1029) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.5.13 to 6.5.14 in /assets [#1028](https://github.com/trento-project/web/pull/1028) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-markdown from 8.0.3 to 8.0.4 in /assets [#1027](https://github.com/trento-project/web/pull/1027) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.13 to 6.5.14 in /assets [#1026](https://github.com/trento-project/web/pull/1026) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.13 to 6.5.14 in /assets [#1025](https://github.com/trento-project/web/pull/1025) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss-import from 15.0.0 to 15.0.1 in /assets [#1024](https://github.com/trento-project/web/pull/1024) ([dependabot[bot]](https://github.com/apps/dependabot))
- Make check executions factory more dynamic [#1022](https://github.com/trento-project/web/pull/1022) ([arbulu89](https://github.com/arbulu89))
- Bump react-router-dom from 6.4.3 to 6.4.4 in /assets [#1021](https://github.com/trento-project/web/pull/1021) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.9.0 to 1.9.1 in /assets [#1020](https://github.com/trento-project/web/pull/1020) ([dependabot[bot]](https://github.com/apps/dependabot))
- New checks overview in cluster details [#1019](https://github.com/trento-project/web/pull/1019) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump @babel/core from 7.20.2 to 7.20.5 in /assets [#1018](https://github.com/trento-project/web/pull/1018) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jaxxstorm/action-install-gh-release from 1.5.0 to 1.7.1 [#1017](https://github.com/trento-project/web/pull/1017) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix docker-compose ports and config [#1015](https://github.com/trento-project/web/pull/1015) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump esbuild from 0.15.15 to 0.15.16 in /assets [#1014](https://github.com/trento-project/web/pull/1014) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add test and refactor the  AboutPage component [#1013](https://github.com/trento-project/web/pull/1013) ([EMaksy](https://github.com/EMaksy))
- Add photofinish to the cache [#1012](https://github.com/trento-project/web/pull/1012) ([rtorrero](https://github.com/rtorrero))
- Bump eslint-plugin-jest from 27.1.5 to 27.1.6 in /assets [#1011](https://github.com/trento-project/web/pull/1011) ([dependabot[bot]](https://github.com/apps/dependabot))
- Unified Api Response for errors [#1010](https://github.com/trento-project/web/pull/1010) ([CDimonaco](https://github.com/CDimonaco))
- Roll-up cluster aggregate stream after X events [#1009](https://github.com/trento-project/web/pull/1009) ([fabriziosestito](https://github.com/fabriziosestito))
- Prevent flaky tests by using UUIDs on the tags values [#1008](https://github.com/trento-project/web/pull/1008) ([rtorrero](https://github.com/rtorrero))
- Reduce vertical padding in `ClusterInfoBox` component [#1004](https://github.com/trento-project/web/pull/1004) ([jamie-suse](https://github.com/jamie-suse))
- Bump prettier from 2.7.1 to 2.8.0 in /assets [#1003](https://github.com/trento-project/web/pull/1003) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 1.1.3 to 1.2.0 in /assets [#1002](https://github.com/trento-project/web/pull/1002) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.27.0 to 8.28.0 in /assets [#1000](https://github.com/trento-project/web/pull/1000) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.31.10 to 7.31.11 in /assets [#999](https://github.com/trento-project/web/pull/999) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.15.14 to 0.15.15 in /assets [#998](https://github.com/trento-project/web/pull/998) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump contracts [#997](https://github.com/trento-project/web/pull/997) ([fabriziosestito](https://github.com/fabriziosestito))
- Add HA scenario & provider to `Cluster Checks Results` & `Cluster Settings` views [#995](https://github.com/trento-project/web/pull/995) ([jamie-suse](https://github.com/jamie-suse))
- Bump cypress-io/github-action from 2 to 4 [#994](https://github.com/trento-project/web/pull/994) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update CONTRIBUTING.md [#993](https://github.com/trento-project/web/pull/993) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump asdf erlang version to 24.3.4 [#992](https://github.com/trento-project/web/pull/992) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Phoenix channels broadcasting testing [#991](https://github.com/trento-project/web/pull/991) ([CDimonaco](https://github.com/CDimonaco))
- Bump loader-utils from 1.4.1 to 1.4.2 in /assets [#990](https://github.com/trento-project/web/pull/990) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add coveralls [#989](https://github.com/trento-project/web/pull/989) ([fabriziosestito](https://github.com/fabriziosestito))
- Document SAP system aggregate [#988](https://github.com/trento-project/web/pull/988) ([arbulu89](https://github.com/arbulu89))
- Tests refactoring [#986](https://github.com/trento-project/web/pull/986) ([CDimonaco](https://github.com/CDimonaco))
- Document the cluster aggregate module [#985](https://github.com/trento-project/web/pull/985) ([arbulu89](https://github.com/arbulu89))
- Add Provider icons to `Cluster Details View` [#984](https://github.com/trento-project/web/pull/984) ([jamie-suse](https://github.com/jamie-suse))
- Bump esbuild from 0.15.13 to 0.15.14 in /assets [#983](https://github.com/trento-project/web/pull/983) ([dependabot[bot]](https://github.com/apps/dependabot))
- Setup structured docs [#982](https://github.com/trento-project/web/pull/982) ([arbulu89](https://github.com/arbulu89))
- Setup elixir docs generation [#981](https://github.com/trento-project/web/pull/981) ([arbulu89](https://github.com/arbulu89))
- Bump jest-environment-jsdom from 29.2.2 to 29.3.1 in /assets [#980](https://github.com/trento-project/web/pull/980) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.2.3 to 3.2.4 in /assets [#979](https://github.com/trento-project/web/pull/979) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.18 to 8.4.19 in /assets [#978](https://github.com/trento-project/web/pull/978) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.1.3 to 27.1.5 in /assets [#977](https://github.com/trento-project/web/pull/977) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.2.1 to 3.2.3 in /assets [#974](https://github.com/trento-project/web/pull/974) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.2.2 to 29.3.1 in /assets [#973](https://github.com/trento-project/web/pull/973) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.19.6 to 7.20.2 in /assets [#972](https://github.com/trento-project/web/pull/972) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.8.6 to 1.9.0 in /assets [#971](https://github.com/trento-project/web/pull/971) ([dependabot[bot]](https://github.com/apps/dependabot))
- Use mocked redux store [#970](https://github.com/trento-project/web/pull/970) ([arbulu89](https://github.com/arbulu89))
- Add dbsid dashboard host filtering [#969](https://github.com/trento-project/web/pull/969) ([rtorrero](https://github.com/rtorrero))
- Bump @babel/preset-env from 7.19.4 to 7.20.2 in /assets [#967](https://github.com/trento-project/web/pull/967) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.26.0 to 8.27.0 in /assets [#965](https://github.com/trento-project/web/pull/965) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump loader-utils from 1.4.0 to 1.4.1 in /assets [#964](https://github.com/trento-project/web/pull/964) ([dependabot[bot]](https://github.com/apps/dependabot))
- Phoenix views refactoring [#963](https://github.com/trento-project/web/pull/963) ([CDimonaco](https://github.com/CDimonaco))
- Add licensing metadata to SUSE Dockerfile [#962](https://github.com/trento-project/web/pull/962) ([rtorrero](https://github.com/rtorrero))
- Add hover style to health icon [#959](https://github.com/trento-project/web/pull/959) ([CDimonaco](https://github.com/CDimonaco))
- Add the possibility to add environment configuration to the bundle [#958](https://github.com/trento-project/web/pull/958) ([dottorblaster](https://github.com/dottorblaster))
- Update CHANGELOG.md [#957](https://github.com/trento-project/web/pull/957) ([rtorrero](https://github.com/rtorrero))
- Bump esbuild from 0.15.12 to 0.15.13 in /assets [#954](https://github.com/trento-project/web/pull/954) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.3 to 1.7.4 in /assets [#951](https://github.com/trento-project/web/pull/951) ([dependabot[bot]](https://github.com/apps/dependabot))

## [1.2.0](https://github.com/trento-project/web/tree/1.2.0) (2022-11-04)

[Full Changelog](https://github.com/trento-project/web/compare/1.1.0...1.2.0)

**Implemented enhancements:**

- Enable query string filtering in existing views [#943](https://github.com/trento-project/web/pull/943) ([CDimonaco](https://github.com/CDimonaco))
- Frontend table filters from query string [#925](https://github.com/trento-project/web/pull/925) ([CDimonaco](https://github.com/CDimonaco))
- Process execution completed [#922](https://github.com/trento-project/web/pull/922) ([arbulu89](https://github.com/arbulu89))
- Remove events from checks execution [#918](https://github.com/trento-project/web/pull/918) ([arbulu89](https://github.com/arbulu89))
- Added Clear button to Filter component when one or more values are selected. [#915](https://github.com/trento-project/web/pull/915) ([jagabomb](https://github.com/jagabomb))
- Add filtering through search params [#908](https://github.com/trento-project/web/pull/908) ([rtorrero](https://github.com/rtorrero))
- Publish execution requested [#906](https://github.com/trento-project/web/pull/906) ([arbulu89](https://github.com/arbulu89))
- Lift off rabbitmq [#896](https://github.com/trento-project/web/pull/896) ([arbulu89](https://github.com/arbulu89))
- Make Database status icon interactive [#890](https://github.com/trento-project/web/pull/890) ([EMaksy](https://github.com/EMaksy))
- Make Pacemaker Clusters status icon interactive [#886](https://github.com/trento-project/web/pull/886) ([EMaksy](https://github.com/EMaksy))
- Navigate filtered checkresults [#883](https://github.com/trento-project/web/pull/883) ([rtorrero](https://github.com/rtorrero))
- Health summary with clusters and databases [#878](https://github.com/trento-project/web/pull/878) ([CDimonaco](https://github.com/CDimonaco))
- Aggregates snapshot [#857](https://github.com/trento-project/web/pull/857) ([fabriziosestito](https://github.com/fabriziosestito))
- Add tag validation [#855](https://github.com/trento-project/web/pull/855) ([EMaksy](https://github.com/EMaksy))
- Community eula [#854](https://github.com/trento-project/web/pull/854) ([arbulu89](https://github.com/arbulu89))
- Remove PR type choice [#842](https://github.com/trento-project/web/pull/842) ([dottorblaster](https://github.com/dottorblaster))
- Set version with git [#735](https://github.com/trento-project/web/pull/735) ([arbulu89](https://github.com/arbulu89))
- Add installation_source field to the host telemetry [#728](https://github.com/trento-project/web/pull/728) ([arbulu89](https://github.com/arbulu89))
- Highlight check result row on hover and id in green [#725](https://github.com/trento-project/web/pull/725) ([arbulu89](https://github.com/arbulu89))

**Fixed bugs:**

- Table views not being updated when last tag is removed [#416](https://github.com/trento-project/web/issues/416)
- Include missing file for CI [#956](https://github.com/trento-project/web/pull/956) ([arbulu89](https://github.com/arbulu89))
- General browser fixes for collapsed sidebar [#914](https://github.com/trento-project/web/pull/914) ([jagabomb](https://github.com/jagabomb))
- Fix active style matching inside navlink usage [#848](https://github.com/trento-project/web/pull/848) ([dottorblaster](https://github.com/dottorblaster))
- Set the version properly in the suse container dockerfile [#743](https://github.com/trento-project/web/pull/743) ([arbulu89](https://github.com/arbulu89))
- Run CI on release event [#711](https://github.com/trento-project/web/pull/711) ([arbulu89](https://github.com/arbulu89))
- Reset pagination when a filter is selected [#704](https://github.com/trento-project/web/pull/704) ([arbulu89](https://github.com/arbulu89))

**Closed issues:**

- Disallow certain chars in tags [#464](https://github.com/trento-project/web/issues/464)

**Merged pull requests:**

- Release 1.2.0 and update changelog [#955](https://github.com/trento-project/web/pull/955) ([rtorrero](https://github.com/rtorrero))
- Bump react-redux from 8.0.4 to 8.0.5 in /assets [#953](https://github.com/trento-project/web/pull/953) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-loader from 9.0.1 to 9.1.0 in /assets [#952](https://github.com/trento-project/web/pull/952) ([dependabot[bot]](https://github.com/apps/dependabot))
- Enable box health filters on Dashboard [#950](https://github.com/trento-project/web/pull/950) ([CDimonaco](https://github.com/CDimonaco))
- Use uuid format for id fields [#949](https://github.com/trento-project/web/pull/949) ([arbulu89](https://github.com/arbulu89))
- fix obs-commit ci job [#948](https://github.com/trento-project/web/pull/948) ([stefanotorresi](https://github.com/stefanotorresi))
- Mock DateTime using a custom date service and mox [#947](https://github.com/trento-project/web/pull/947) ([arbulu89](https://github.com/arbulu89))
- Replace mock usage for dispatch [#946](https://github.com/trento-project/web/pull/946) ([arbulu89](https://github.com/arbulu89))
- Bump @heroicons/react from 2.0.12 to 2.0.13 in /assets [#945](https://github.com/trento-project/web/pull/945) ([dependabot[bot]](https://github.com/apps/dependabot))
- Ui restyle of Health box in HealthSummary [#944](https://github.com/trento-project/web/pull/944) ([CDimonaco](https://github.com/CDimonaco))
- Add a test using Fishery and Faker [#942](https://github.com/trento-project/web/pull/942) ([dottorblaster](https://github.com/dottorblaster))
- Remove container name from rabbitmq container in docker compose [#941](https://github.com/trento-project/web/pull/941) ([CDimonaco](https://github.com/CDimonaco))
- Bump react-router-dom from 6.4.2 to 6.4.3 in /assets [#940](https://github.com/trento-project/web/pull/940) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-loader from 9.0.0 to 9.0.1 in /assets [#939](https://github.com/trento-project/web/pull/939) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-loader from 8.2.5 to 9.0.0 in /assets [#938](https://github.com/trento-project/web/pull/938) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.12 to 10.4.13 in /assets [#937](https://github.com/trento-project/web/pull/937) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.12 to 6.5.13 in /assets [#935](https://github.com/trento-project/web/pull/935) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.2.1 to 29.2.2 in /assets [#934](https://github.com/trento-project/web/pull/934) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.2.1 to 29.2.2 in /assets [#933](https://github.com/trento-project/web/pull/933) ([dependabot[bot]](https://github.com/apps/dependabot))
- Encapsulated About content with a white container [#932](https://github.com/trento-project/web/pull/932) ([jagabomb](https://github.com/jagabomb))
- Bump eslint from 8.25.0 to 8.26.0 in /assets [#931](https://github.com/trento-project/web/pull/931) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.2.0 to 3.2.1 in /assets [#930](https://github.com/trento-project/web/pull/930) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.12 to 6.5.13 in /assets [#929](https://github.com/trento-project/web/pull/929) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.12 to 6.5.13 in /assets [#928](https://github.com/trento-project/web/pull/928) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.12 to 6.5.13 in /assets [#927](https://github.com/trento-project/web/pull/927) ([dependabot[bot]](https://github.com/apps/dependabot))
- Removed restart strategy from docker-compose file [#926](https://github.com/trento-project/web/pull/926) ([CDimonaco](https://github.com/CDimonaco))
- Checks results refactor part two [#924](https://github.com/trento-project/web/pull/924) ([dottorblaster](https://github.com/dottorblaster))
- Bump @babel/core from 7.19.3 to 7.19.6 in /assets [#921](https://github.com/trento-project/web/pull/921) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.18.6 to 7.19.6 in /assets [#920](https://github.com/trento-project/web/pull/920) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.11.5 to 1.11.6 in /assets [#919](https://github.com/trento-project/web/pull/919) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.1.8 to 3.2.0 in /assets [#917](https://github.com/trento-project/web/pull/917) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.15.11 to 0.15.12 in /assets [#916](https://github.com/trento-project/web/pull/916) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eos-icons-react from 2.3.0 to 2.4.0 in /assets [#913](https://github.com/trento-project/web/pull/913) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.2.0 to 29.2.1 in /assets [#912](https://github.com/trento-project/web/pull/912) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.2.0 to 29.2.1 in /assets [#911](https://github.com/trento-project/web/pull/911) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.1.2 to 27.1.3 in /assets [#910](https://github.com/trento-project/web/pull/910) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.2.0 to 29.2.1 in /assets [#909](https://github.com/trento-project/web/pull/909) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 4.1.0 to 4.1.1 [#907](https://github.com/trento-project/web/pull/907) ([dependabot[bot]](https://github.com/apps/dependabot))
- Initial proposal for a collapsed sidebar. [#905](https://github.com/trento-project/web/pull/905) ([jagabomb](https://github.com/jagabomb))
- Refactor frontend events mapping [#904](https://github.com/trento-project/web/pull/904) ([jamie-suse](https://github.com/jamie-suse))
- Bump axios from 0.27.2 to 1.1.3 in /assets [#902](https://github.com/trento-project/web/pull/902) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.15.10 to 0.15.11 in /assets [#901](https://github.com/trento-project/web/pull/901) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.1.2 to 29.2.0 in /assets [#900](https://github.com/trento-project/web/pull/900) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.1.1 to 27.1.2 in /assets [#899](https://github.com/trento-project/web/pull/899) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.1.2 to 29.2.0 in /assets [#898](https://github.com/trento-project/web/pull/898) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add end-to-end tests for KVM & Nutanix cloud providers [#897](https://github.com/trento-project/web/pull/897) ([jamie-suse](https://github.com/jamie-suse))
- Bump postcss from 8.4.17 to 8.4.18 in /assets [#895](https://github.com/trento-project/web/pull/895) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump styfle/cancel-workflow-action from 0.10.1 to 0.11.0 [#894](https://github.com/trento-project/web/pull/894) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/login-action from 2.0.0 to 2.1.0 [#893](https://github.com/trento-project/web/pull/893) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 4.0.1 to 4.1.0 [#892](https://github.com/trento-project/web/pull/892) ([dependabot[bot]](https://github.com/apps/dependabot))
- Checks results refactor [#891](https://github.com/trento-project/web/pull/891) ([dottorblaster](https://github.com/dottorblaster))
- Bump eslint-plugin-react from 7.31.9 to 7.31.10 in /assets [#888](https://github.com/trento-project/web/pull/888) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.19.3 to 7.19.4 in /assets [#887](https://github.com/trento-project/web/pull/887) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add providers KVM & Nutanix to Host Details view [#885](https://github.com/trento-project/web/pull/885) ([jamie-suse](https://github.com/jamie-suse))
- Fix HealthSummaryDto's required fields [#884](https://github.com/trento-project/web/pull/884) ([dottorblaster](https://github.com/dottorblaster))
- Bump @reduxjs/toolkit from 1.8.5 to 1.8.6 in /assets [#882](https://github.com/trento-project/web/pull/882) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.31.8 to 7.31.9 in /assets [#880](https://github.com/trento-project/web/pull/880) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.24.0 to 8.25.0 in /assets [#879](https://github.com/trento-project/web/pull/879) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.1.0 to 27.1.1 in /assets [#876](https://github.com/trento-project/web/pull/876) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @heroicons/react from 2.0.11 to 2.0.12 in /assets [#875](https://github.com/trento-project/web/pull/875) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.4.1 to 6.4.2 in /assets [#874](https://github.com/trento-project/web/pull/874) ([dependabot[bot]](https://github.com/apps/dependabot))
- Move the check for unused deps to static code analysis step [#873](https://github.com/trento-project/web/pull/873) ([dottorblaster](https://github.com/dottorblaster))
- Add mix deps.unlock --check-unused to CI [#872](https://github.com/trento-project/web/pull/872) ([dottorblaster](https://github.com/dottorblaster))
- Bump eslint-plugin-jest from 27.0.4 to 27.1.0 in /assets [#870](https://github.com/trento-project/web/pull/870) ([dependabot[bot]](https://github.com/apps/dependabot))
- Enable single pipe check on credo [#869](https://github.com/trento-project/web/pull/869) ([arbulu89](https://github.com/arbulu89))
- Bump esbuild from 0.14.54 to 0.15.10 in /assets [#868](https://github.com/trento-project/web/pull/868) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.1.0 to 29.1.2 in /assets [#867](https://github.com/trento-project/web/pull/867) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.1.1 to 29.1.2 in /assets [#866](https://github.com/trento-project/web/pull/866) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.2 to 1.7.3 in /assets [#865](https://github.com/trento-project/web/pull/865) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.16 to 8.4.17 in /assets [#864](https://github.com/trento-project/web/pull/864) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.1.1 to 29.1.2 in /assets [#863](https://github.com/trento-project/web/pull/863) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump styfle/cancel-workflow-action from 0.10.0 to 0.10.1 [#862](https://github.com/trento-project/web/pull/862) ([dependabot[bot]](https://github.com/apps/dependabot))
- Premium EULA page content update [#861](https://github.com/trento-project/web/pull/861) ([abravosuse](https://github.com/abravosuse))
- Rename .Enum.* to .Enums.* in module paths for consistency [#860](https://github.com/trento-project/web/pull/860) ([rtorrero](https://github.com/rtorrero))
- Bump esbuild-plugin-path-alias from 1.0.6 to 1.0.7 in /assets [#859](https://github.com/trento-project/web/pull/859) ([dependabot[bot]](https://github.com/apps/dependabot))
- Use new enum type for cluster types [#858](https://github.com/trento-project/web/pull/858) ([rtorrero](https://github.com/rtorrero))
- Use new enum type for Health [#856](https://github.com/trento-project/web/pull/856) ([rtorrero](https://github.com/rtorrero))
- Bump babel-jest from 29.0.3 to 29.1.0 in /assets [#853](https://github.com/trento-project/web/pull/853) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.0.3 to 29.1.1 in /assets [#852](https://github.com/trento-project/web/pull/852) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.0.3 to 29.1.1 in /assets [#851](https://github.com/trento-project/web/pull/851) ([dependabot[bot]](https://github.com/apps/dependabot))
- Added margin to the bottom of each result/host container. [#850](https://github.com/trento-project/web/pull/850) ([jagabomb](https://github.com/jagabomb))
- Add provider enum [#849](https://github.com/trento-project/web/pull/849) ([rtorrero](https://github.com/rtorrero))
- Bump @babel/core from 7.19.1 to 7.19.3 in /assets [#847](https://github.com/trento-project/web/pull/847) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.19.1 to 7.19.3 in /assets [#846](https://github.com/trento-project/web/pull/846) ([dependabot[bot]](https://github.com/apps/dependabot))
- Changed Warning border to 8px [#845](https://github.com/trento-project/web/pull/845) ([jagabomb](https://github.com/jagabomb))
- Bump eslint from 8.23.1 to 8.24.0 in /assets [#844](https://github.com/trento-project/web/pull/844) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add acceptance test [#843](https://github.com/trento-project/web/pull/843) ([fabriziosestito](https://github.com/fabriziosestito))
- Test default catalog usage in the backend [#841](https://github.com/trento-project/web/pull/841) ([arbulu89](https://github.com/arbulu89))
- Show warning unknown check selection [#840](https://github.com/trento-project/web/pull/840) ([arbulu89](https://github.com/arbulu89))
- Bump react-redux from 8.0.2 to 8.0.4 in /assets [#839](https://github.com/trento-project/web/pull/839) ([dependabot[bot]](https://github.com/apps/dependabot))
- Return default catalog if the provider is unknown [#838](https://github.com/trento-project/web/pull/838) ([arbulu89](https://github.com/arbulu89))
- Create BackToCluster button component [#837](https://github.com/trento-project/web/pull/837) ([arbulu89](https://github.com/arbulu89))
- Add missing :kvm and :nutanix atoms to the provider field in events/commands/read models [#836](https://github.com/trento-project/web/pull/836) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump react-router-dom from 6.4.0 to 6.4.1 in /assets [#835](https://github.com/trento-project/web/pull/835) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add kvm and nutanix providers [#834](https://github.com/trento-project/web/pull/834) ([fabriziosestito](https://github.com/fabriziosestito))
- Update mock catalog [#833](https://github.com/trento-project/web/pull/833) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump autoprefixer from 10.4.11 to 10.4.12 in /assets [#832](https://github.com/trento-project/web/pull/832) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.1 to 1.7.2 in /assets [#831](https://github.com/trento-project/web/pull/831) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.10 to 10.4.11 in /assets [#830](https://github.com/trento-project/web/pull/830) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.19.0 to 7.19.1 in /assets [#829](https://github.com/trento-project/web/pull/829) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.19.0 to 7.19.1 in /assets [#828](https://github.com/trento-project/web/pull/828) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump date-fns from 2.29.2 to 2.29.3 in /assets [#826](https://github.com/trento-project/web/pull/826) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.9 to 10.4.10 in /assets [#825](https://github.com/trento-project/web/pull/825) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-hot-toast from 2.3.0 to 2.4.0 in /assets [#824](https://github.com/trento-project/web/pull/824) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.3.0 to 6.4.0 in /assets [#823](https://github.com/trento-project/web/pull/823) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.11 to 6.5.12 in /assets [#822](https://github.com/trento-project/web/pull/822) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.5.11 to 6.5.12 in /assets [#821](https://github.com/trento-project/web/pull/821) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.11 to 6.5.12 in /assets [#820](https://github.com/trento-project/web/pull/820) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.11 to 6.5.12 in /assets [#819](https://github.com/trento-project/web/pull/819) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump classnames from 2.3.1 to 2.3.2 in /assets [#818](https://github.com/trento-project/web/pull/818) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.11 to 6.5.12 in /assets [#817](https://github.com/trento-project/web/pull/817) ([dependabot[bot]](https://github.com/apps/dependabot))
- Improve contribution documentations and add templates [#816](https://github.com/trento-project/web/pull/816) ([rtorrero](https://github.com/rtorrero))
- Bump @storybook/addon-actions from 6.5.10 to 6.5.11 in /assets [#815](https://github.com/trento-project/web/pull/815) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.10 to 6.5.11 in /assets [#814](https://github.com/trento-project/web/pull/814) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.10 to 6.5.11 in /assets [#813](https://github.com/trento-project/web/pull/813) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.10 to 6.5.11 in /assets [#812](https://github.com/trento-project/web/pull/812) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @heroicons/react from 2.0.10 to 2.0.11 in /assets [#811](https://github.com/trento-project/web/pull/811) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.10 to 6.5.11 in /assets [#810](https://github.com/trento-project/web/pull/810) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.7.0 to 1.7.1 in /assets [#809](https://github.com/trento-project/web/pull/809) ([dependabot[bot]](https://github.com/apps/dependabot))
- Check Result Overview in Cluster Details [#808](https://github.com/trento-project/web/pull/808) ([CDimonaco](https://github.com/CDimonaco))
- Bump eslint-plugin-react from 7.31.7 to 7.31.8 in /assets [#807](https://github.com/trento-project/web/pull/807) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.0.2 to 29.0.3 in /assets [#806](https://github.com/trento-project/web/pull/806) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.8 to 10.4.9 in /assets [#805](https://github.com/trento-project/web/pull/805) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.0.2 to 27.0.4 in /assets [#804](https://github.com/trento-project/web/pull/804) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.0.2 to 29.0.3 in /assets [#803](https://github.com/trento-project/web/pull/803) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.0.2 to 29.0.3 in /assets [#802](https://github.com/trento-project/web/pull/802) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.23.0 to 8.23.1 in /assets [#801](https://github.com/trento-project/web/pull/801) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 27.0.1 to 27.0.2 in /assets [#800](https://github.com/trento-project/web/pull/800) ([dependabot[bot]](https://github.com/apps/dependabot))
- Check results filtering [#799](https://github.com/trento-project/web/pull/799) ([CDimonaco](https://github.com/CDimonaco))
- Bump @headlessui/react from 1.6.6 to 1.7.0 in /assets [#798](https://github.com/trento-project/web/pull/798) ([dependabot[bot]](https://github.com/apps/dependabot))
- Refactor docker compose to add named volume for postgres persistence [#797](https://github.com/trento-project/web/pull/797) ([CDimonaco](https://github.com/CDimonaco))
- Bump eslint-plugin-react from 7.31.6 to 7.31.7 in /assets [#796](https://github.com/trento-project/web/pull/796) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.18.13 to 7.19.0 in /assets [#795](https://github.com/trento-project/web/pull/795) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.18.10 to 7.19.0 in /assets [#794](https://github.com/trento-project/web/pull/794) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.0.1 to 29.0.2 in /assets [#793](https://github.com/trento-project/web/pull/793) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.0.1 to 29.0.2 in /assets [#792](https://github.com/trento-project/web/pull/792) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.31.1 to 7.31.6 in /assets [#791](https://github.com/trento-project/web/pull/791) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @testing-library/react from 13.3.0 to 13.4.0 in /assets [#790](https://github.com/trento-project/web/pull/790) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 29.0.1 to 29.0.2 in /assets [#789](https://github.com/trento-project/web/pull/789) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @heroicons/react from 1.0.6 to 2.0.10 in /assets [#787](https://github.com/trento-project/web/pull/787) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss-import from 14.1.0 to 15.0.0 in /assets [#786](https://github.com/trento-project/web/pull/786) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add option to unselect the removed tag fix #416 [#785](https://github.com/trento-project/web/pull/785) ([EMaksy](https://github.com/EMaksy))
- Bump babel-jest from 29.0.0 to 29.0.1 in /assets [#784](https://github.com/trento-project/web/pull/784) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 29.0.0 to 29.0.1 in /assets [#783](https://github.com/trento-project/web/pull/783) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.8.7 to 27.0.1 in /assets [#782](https://github.com/trento-project/web/pull/782) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 29.0.0 to 29.0.1 in /assets [#781](https://github.com/trento-project/web/pull/781) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.22.0 to 8.23.0 in /assets [#780](https://github.com/trento-project/web/pull/780) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.31.0 to 7.31.1 in /assets [#779](https://github.com/trento-project/web/pull/779) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 28.1.3 to 29.0.0 in /assets [#776](https://github.com/trento-project/web/pull/776) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 28.1.3 to 29.0.0 in /assets [#775](https://github.com/trento-project/web/pull/775) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 28.1.3 to 29.0.0 in /assets [#774](https://github.com/trento-project/web/pull/774) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.30.1 to 7.31.0 in /assets [#772](https://github.com/trento-project/web/pull/772) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.18.10 to 7.18.13 in /assets [#770](https://github.com/trento-project/web/pull/770) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix some typos since the CI breaks otherwise [#769](https://github.com/trento-project/web/pull/769) ([dottorblaster](https://github.com/dottorblaster))
- Bump eslint-plugin-jest from 26.8.3 to 26.8.7 in /assets [#768](https://github.com/trento-project/web/pull/768) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump redux-saga from 1.2.0 to 1.2.1 in /assets [#767](https://github.com/trento-project/web/pull/767) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.8.4 to 1.8.5 in /assets [#766](https://github.com/trento-project/web/pull/766) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.8.2 to 26.8.3 in /assets [#765](https://github.com/trento-project/web/pull/765) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.11.4 to 1.11.5 in /assets [#764](https://github.com/trento-project/web/pull/764) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.21.0 to 8.22.0 in /assets [#763](https://github.com/trento-project/web/pull/763) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump redux-saga from 1.1.3 to 1.2.0 in /assets [#762](https://github.com/trento-project/web/pull/762) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update fixtures to reflect a recent agent version [#761](https://github.com/trento-project/web/pull/761) ([rtorrero](https://github.com/rtorrero))
- Bump @reduxjs/toolkit from 1.8.3 to 1.8.4 in /assets [#760](https://github.com/trento-project/web/pull/760) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add value files support inside the Cypress testing suite [#759](https://github.com/trento-project/web/pull/759) ([dottorblaster](https://github.com/dottorblaster))
- Bump eslint-plugin-jest from 26.8.1 to 26.8.2 in /assets [#758](https://github.com/trento-project/web/pull/758) ([dependabot[bot]](https://github.com/apps/dependabot))
- add nodejs to .tools-versions [#757](https://github.com/trento-project/web/pull/757) ([stefanotorresi](https://github.com/stefanotorresi))
- Bump eslint-plugin-jest from 26.8.0 to 26.8.1 in /assets [#756](https://github.com/trento-project/web/pull/756) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.53 to 0.14.54 in /assets [#755](https://github.com/trento-project/web/pull/755) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.7.0 to 26.8.0 in /assets [#754](https://github.com/trento-project/web/pull/754) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.1.7 to 3.1.8 in /assets [#753](https://github.com/trento-project/web/pull/753) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.14 to 8.4.16 in /assets [#752](https://github.com/trento-project/web/pull/752) ([dependabot[bot]](https://github.com/apps/dependabot))
- Upcasting [#751](https://github.com/trento-project/web/pull/751) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump @testing-library/jest-dom from 5.16.4 to 5.16.5 in /assets [#750](https://github.com/trento-project/web/pull/750) ([dependabot[bot]](https://github.com/apps/dependabot))
- Set expectations for the about.js from cypress.env [#749](https://github.com/trento-project/web/pull/749) ([mpagot](https://github.com/mpagot))
- Bump @storybook/addon-essentials from 6.5.9 to 6.5.10 in /assets [#748](https://github.com/trento-project/web/pull/748) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.9 to 6.5.10 in /assets [#747](https://github.com/trento-project/web/pull/747) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.5.9 to 6.5.10 in /assets [#746](https://github.com/trento-project/web/pull/746) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.9 to 6.5.10 in /assets [#745](https://github.com/trento-project/web/pull/745) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.9 to 6.5.10 in /assets [#744](https://github.com/trento-project/web/pull/744) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.51 to 0.14.53 in /assets [#742](https://github.com/trento-project/web/pull/742) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add missing env vars required for photofinish [#741](https://github.com/trento-project/web/pull/741) ([rtorrero](https://github.com/rtorrero))
- Fix nil provider broadcast [#740](https://github.com/trento-project/web/pull/740) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump @babel/core from 7.18.9 to 7.18.10 in /assets [#739](https://github.com/trento-project/web/pull/739) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.18.9 to 7.18.10 in /assets [#738](https://github.com/trento-project/web/pull/738) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove gettext compiler from project configuration [#737](https://github.com/trento-project/web/pull/737) ([dottorblaster](https://github.com/dottorblaster))
- Increase the z-index for modals and modal backdrops [#736](https://github.com/trento-project/web/pull/736) ([dottorblaster](https://github.com/dottorblaster))
- Bump autoprefixer from 10.4.7 to 10.4.8 in /assets [#734](https://github.com/trento-project/web/pull/734) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.1.6 to 3.1.7 in /assets [#733](https://github.com/trento-project/web/pull/733) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.6.0 to 26.7.0 in /assets [#732](https://github.com/trento-project/web/pull/732) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump credo from 1.6.5 to 1.6.6 [#731](https://github.com/trento-project/web/pull/731) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.20.0 to 8.21.0 in /assets [#730](https://github.com/trento-project/web/pull/730) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postgrex from 0.16.3 to 0.16.4 [#729](https://github.com/trento-project/web/pull/729) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.50 to 0.14.51 in /assets [#727](https://github.com/trento-project/web/pull/727) ([dependabot[bot]](https://github.com/apps/dependabot))
- Enable telemetry community [#726](https://github.com/trento-project/web/pull/726) ([arbulu89](https://github.com/arbulu89))
- Bump esbuild from 0.14.49 to 0.14.50 in /assets [#724](https://github.com/trento-project/web/pull/724) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add automated deployments to the demo environment [#723](https://github.com/trento-project/web/pull/723) ([rtorrero](https://github.com/rtorrero))
- Bump open_api_spex from 3.11.0 to 3.12.0 [#722](https://github.com/trento-project/web/pull/722) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dialyxir from 1.1.0 to 1.2.0 [#721](https://github.com/trento-project/web/pull/721) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump gettext from 0.19.1 to 0.20.0 [#720](https://github.com/trento-project/web/pull/720) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump terser from 4.8.0 to 4.8.1 in /assets [#719](https://github.com/trento-project/web/pull/719) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.11.3 to 1.11.4 in /assets [#718](https://github.com/trento-project/web/pull/718) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.18.6 to 7.18.9 in /assets [#717](https://github.com/trento-project/web/pull/717) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.18.6 to 7.18.9 in /assets [#716](https://github.com/trento-project/web/pull/716) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.19.0 to 8.20.0 in /assets [#715](https://github.com/trento-project/web/pull/715) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump credo from 1.6.4 to 1.6.5 [#714](https://github.com/trento-project/web/pull/714) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.5.3 to 26.6.0 in /assets [#713](https://github.com/trento-project/web/pull/713) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump polymorphic_embed from 1.9.0 to 2.0.0 [#712](https://github.com/trento-project/web/pull/712) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump swoosh from 1.7.1 to 1.7.3 [#710](https://github.com/trento-project/web/pull/710) ([dependabot[bot]](https://github.com/apps/dependabot))

## [1.1.0](https://github.com/trento-project/web/tree/1.1.0) (2022-07-14)

[Full Changelog](https://github.com/trento-project/web/compare/1.0.0...1.1.0)

**Implemented enhancements:**

- Allow custom email sender [#695](https://github.com/trento-project/web/pull/695) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add a modal to display remediation info on check results [#680](https://github.com/trento-project/web/pull/680) ([rtorrero](https://github.com/rtorrero))
- Add icons to health status indicators [#677](https://github.com/trento-project/web/pull/677) ([rtorrero](https://github.com/rtorrero))
- Display gcp metadata frontend [#662](https://github.com/trento-project/web/pull/662) ([arbulu89](https://github.com/arbulu89))
- Handle gcp details [#654](https://github.com/trento-project/web/pull/654) ([arbulu89](https://github.com/arbulu89))
- Add AWS metadata openapi schema [#651](https://github.com/trento-project/web/pull/651) ([arbulu89](https://github.com/arbulu89))
- Display aws metadata frontend [#650](https://github.com/trento-project/web/pull/650) ([arbulu89](https://github.com/arbulu89))
- Ecto decode clusters discovery [#649](https://github.com/trento-project/web/pull/649) ([rtorrero](https://github.com/rtorrero))
- Handle aws details [#648](https://github.com/trento-project/web/pull/648) ([arbulu89](https://github.com/arbulu89))
- Provide a proper name for Target Infrastructure related APIs [#618](https://github.com/trento-project/web/pull/618) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Use failure context rollup event handler [#616](https://github.com/trento-project/web/pull/616) ([fabriziosestito](https://github.com/fabriziosestito))
- Expose a valid OpenApi specification [#613](https://github.com/trento-project/web/pull/613) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Implement the SAP systems payload decoding and usage [#602](https://github.com/trento-project/web/pull/602) ([arbulu89](https://github.com/arbulu89))
- About openapi [#586](https://github.com/trento-project/web/pull/586) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Adds Platform Settings OpenApi spec [#584](https://github.com/trento-project/web/pull/584) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add Accept Eula openapi spec [#581](https://github.com/trento-project/web/pull/581) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add SapSystems Health overview OpenApi spec [#579](https://github.com/trento-project/web/pull/579) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Adds openapi doc for ApiKey retriveal [#570](https://github.com/trento-project/web/pull/570) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Runner callback api [#569](https://github.com/trento-project/web/pull/569) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Expose Execution Request API documentation [#558](https://github.com/trento-project/web/pull/558) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Cluster health when no checks are selected [#555](https://github.com/trento-project/web/pull/555) ([arbulu89](https://github.com/arbulu89))
- Select checks openapi [#546](https://github.com/trento-project/web/pull/546) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Cluster Aggregate rollup part 1 [#544](https://github.com/trento-project/web/pull/544) ([fabriziosestito](https://github.com/fabriziosestito))
- Dump discarded discovery events [#542](https://github.com/trento-project/web/pull/542) ([arbulu89](https://github.com/arbulu89))
- Checks catalog openapi [#536](https://github.com/trento-project/web/pull/536) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Sap system details e2e [#529](https://github.com/trento-project/web/pull/529) ([arbulu89](https://github.com/arbulu89))
- Sap systems and Databases openapi [#528](https://github.com/trento-project/web/pull/528) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Clusters list openapi doc [#522](https://github.com/trento-project/web/pull/522) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Debounce Homepage health overview refresh [#515](https://github.com/trento-project/web/pull/515) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Initial Swagger integration [#512](https://github.com/trento-project/web/pull/512) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Exporter status endpoint [#505](https://github.com/trento-project/web/pull/505) ([fabriziosestito](https://github.com/fabriziosestito))
- Reactive subscription [#495](https://github.com/trento-project/web/pull/495) ([fabriziosestito](https://github.com/fabriziosestito))

**Fixed bugs:**

- Handle DAA and unknown sap system payloads [#702](https://github.com/trento-project/web/pull/702) ([arbulu89](https://github.com/arbulu89))
- Allow a failover payload to pass validations [#663](https://github.com/trento-project/web/pull/663) ([rtorrero](https://github.com/rtorrero))
- Use NavLink in the navigation elements [#623](https://github.com/trento-project/web/pull/623) ([arbulu89](https://github.com/arbulu89))
- Persist cib last written field [#622](https://github.com/trento-project/web/pull/622) ([arbulu89](https://github.com/arbulu89))
- Handle empty list in from_list function [#619](https://github.com/trento-project/web/pull/619) ([arbulu89](https://github.com/arbulu89))
- Correct log replication and log operation mode names [#517](https://github.com/trento-project/web/pull/517) ([arbulu89](https://github.com/arbulu89))
- Include premium field handling [#504](https://github.com/trento-project/web/pull/504) ([arbulu89](https://github.com/arbulu89))
- Adjust z-index inside the Modal component [#503](https://github.com/trento-project/web/pull/503) ([dottorblaster](https://github.com/dottorblaster))
- Handle unnamed cluster event [#497](https://github.com/trento-project/web/pull/497) ([arbulu89](https://github.com/arbulu89))
- Completely skip alerting feature steps when alerting is disabled [#494](https://github.com/trento-project/web/pull/494) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Use get-latest action to avoid issues with git after CVE-2022-24765 [#492](https://github.com/trento-project/web/pull/492) ([arbulu89](https://github.com/arbulu89))
- Fix Development documentation link [#488](https://github.com/trento-project/web/pull/488) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Include cluster field in the host details view [#476](https://github.com/trento-project/web/pull/476) ([arbulu89](https://github.com/arbulu89))

**Closed issues:**

- Footer causes double scrolling [#360](https://github.com/trento-project/web/issues/360)
- Cluster projection leftovers [#233](https://github.com/trento-project/web/issues/233)
- sap_systems or sap-systems [#190](https://github.com/trento-project/web/issues/190)
- Proposal: use ExMachina for factories [#147](https://github.com/trento-project/web/issues/147)

**Merged pull requests:**

- Upgrade to release 1.1.0 and update changelog [#709](https://github.com/trento-project/web/pull/709) ([arbulu89](https://github.com/arbulu89))
- Bump jest from 28.1.2 to 28.1.3 in /assets [#708](https://github.com/trento-project/web/pull/708) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 28.1.2 to 28.1.3 in /assets [#707](https://github.com/trento-project/web/pull/707) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 28.1.2 to 28.1.3 in /assets [#706](https://github.com/trento-project/web/pull/706) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-hot-toast from 2.2.0 to 2.3.0 in /assets [#703](https://github.com/trento-project/web/pull/703) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.1.5 to 3.1.6 in /assets [#700](https://github.com/trento-project/web/pull/700) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix_live_view from 0.17.10 to 0.17.11 [#699](https://github.com/trento-project/web/pull/699) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.48 to 0.14.49 in /assets [#698](https://github.com/trento-project/web/pull/698) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.6.5 to 1.6.6 in /assets [#697](https://github.com/trento-project/web/pull/697) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.1.4 to 3.1.5 in /assets [#696](https://github.com/trento-project/web/pull/696) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.18.0 to 8.19.0 in /assets [#693](https://github.com/trento-project/web/pull/693) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 28.1.1 to 28.1.2 in /assets [#692](https://github.com/trento-project/web/pull/692) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 28.1.1 to 28.1.2 in /assets [#691](https://github.com/trento-project/web/pull/691) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.47 to 0.14.48 in /assets [#690](https://github.com/trento-project/web/pull/690) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.8.2 to 1.8.3 in /assets [#689](https://github.com/trento-project/web/pull/689) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 28.1.1 to 28.1.2 in /assets [#688](https://github.com/trento-project/web/pull/688) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump floki from 0.32.1 to 0.33.1 [#687](https://github.com/trento-project/web/pull/687) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.18.5 to 7.18.6 in /assets [#686](https://github.com/trento-project/web/pull/686) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-react from 7.17.12 to 7.18.6 in /assets [#685](https://github.com/trento-project/web/pull/685) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.18.2 to 7.18.6 in /assets [#684](https://github.com/trento-project/web/pull/684) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.18.2 to 7.18.6 in /assets [#683](https://github.com/trento-project/web/pull/683) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump styfle/cancel-workflow-action from 0.9.1 to 0.10.0 [#682](https://github.com/trento-project/web/pull/682) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.29.4 to 7.30.1 in /assets [#681](https://github.com/trento-project/web/pull/681) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add hosts_execution to cluster_registered broadcast [#679](https://github.com/trento-project/web/pull/679) ([rtorrero](https://github.com/rtorrero))
- Bump tailwindcss from 3.1.3 to 3.1.4 in /assets [#678](https://github.com/trento-project/web/pull/678) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.46 to 0.14.47 in /assets [#676](https://github.com/trento-project/web/pull/676) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.6.4 to 1.6.5 in /assets [#675](https://github.com/trento-project/web/pull/675) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.45 to 0.14.46 in /assets [#673](https://github.com/trento-project/web/pull/673) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.17.0 to 8.18.0 in /assets [#672](https://github.com/trento-project/web/pull/672) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.44 to 0.14.45 in /assets [#671](https://github.com/trento-project/web/pull/671) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump prettier from 2.7.0 to 2.7.1 in /assets [#670](https://github.com/trento-project/web/pull/670) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.43 to 0.14.44 in /assets [#669](https://github.com/trento-project/web/pull/669) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.1.2 to 3.1.3 in /assets [#668](https://github.com/trento-project/web/pull/668) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump prettier from 2.6.2 to 2.7.0 in /assets [#667](https://github.com/trento-project/web/pull/667) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-dom from 18.1.0 to 18.2.0 in /assets [#666](https://github.com/trento-project/web/pull/666) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react from 18.1.0 to 18.2.0 in /assets [#665](https://github.com/trento-project/web/pull/665) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update and add additional information to hack_on_the_trento documentation [#664](https://github.com/trento-project/web/pull/664) ([EMaksy](https://github.com/EMaksy))
- Bump @storybook/testing-library from 0.0.12 to 0.0.13 in /assets [#661](https://github.com/trento-project/web/pull/661) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.18.2 to 7.18.5 in /assets [#659](https://github.com/trento-project/web/pull/659) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.8 to 6.5.9 in /assets [#658](https://github.com/trento-project/web/pull/658) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.8 to 6.5.9 in /assets [#657](https://github.com/trento-project/web/pull/657) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.8 to 6.5.9 in /assets [#656](https://github.com/trento-project/web/pull/656) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.8 to 6.5.9 in /assets [#655](https://github.com/trento-project/web/pull/655) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.24 to 3.1.2 in /assets [#653](https://github.com/trento-project/web/pull/653) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/testing-library from 0.0.11 to 0.0.12 in /assets [#652](https://github.com/trento-project/web/pull/652) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump fun_with_flags_ui from 0.8.0 to 0.8.1 [#647](https://github.com/trento-project/web/pull/647) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix a broken link in the Installation part of README.md [#645](https://github.com/trento-project/web/pull/645) ([EMaksy](https://github.com/EMaksy))
- Bump @storybook/addon-interactions from 6.5.7 to 6.5.8 in /assets [#644](https://github.com/trento-project/web/pull/644) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.7 to 6.5.8 in /assets [#643](https://github.com/trento-project/web/pull/643) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.5.7 to 6.5.8 in /assets [#642](https://github.com/trento-project/web/pull/642) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.7 to 6.5.8 in /assets [#641](https://github.com/trento-project/web/pull/641) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.7 to 6.5.8 in /assets [#640](https://github.com/trento-project/web/pull/640) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add jest tests utility [#639](https://github.com/trento-project/web/pull/639) ([dottorblaster](https://github.com/dottorblaster))
- Bump esbuild from 0.14.42 to 0.14.43 in /assets [#638](https://github.com/trento-project/web/pull/638) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eos-icons-react from 2.2.0 to 2.3.0 in /assets [#637](https://github.com/trento-project/web/pull/637) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest-environment-jsdom from 28.1.0 to 28.1.1 in /assets [#636](https://github.com/trento-project/web/pull/636) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 28.1.0 to 28.1.1 in /assets [#635](https://github.com/trento-project/web/pull/635) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 28.1.0 to 28.1.1 in /assets [#634](https://github.com/trento-project/web/pull/634) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.6 to 6.5.7 in /assets [#633](https://github.com/trento-project/web/pull/633) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.6 to 6.5.7 in /assets [#632](https://github.com/trento-project/web/pull/632) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.6 to 6.5.7 in /assets [#631](https://github.com/trento-project/web/pull/631) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.11.2 to 1.11.3 in /assets [#630](https://github.com/trento-project/web/pull/630) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.5.6 to 6.5.7 in /assets [#629](https://github.com/trento-project/web/pull/629) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.4.6 to 26.5.3 in /assets [#628](https://github.com/trento-project/web/pull/628) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.16.0 to 8.17.0 in /assets [#627](https://github.com/trento-project/web/pull/627) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.6 to 6.5.7 in /assets [#626](https://github.com/trento-project/web/pull/626) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump ecto_sql from 3.8.2 to 3.8.3 [#625](https://github.com/trento-project/web/pull/625) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump npm from 8.10.0 to 8.11.0 in /test/e2e [#624](https://github.com/trento-project/web/pull/624) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix from 1.6.9 to 1.6.10 [#621](https://github.com/trento-project/web/pull/621) ([dependabot[bot]](https://github.com/apps/dependabot))
- Refactor from_list in new [#620](https://github.com/trento-project/web/pull/620) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump swoosh from 1.7.0 to 1.7.1 [#617](https://github.com/trento-project/web/pull/617) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.4.5 to 26.4.6 in /assets [#615](https://github.com/trento-project/web/pull/615) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump mox from 1.0.1 to 1.0.2 [#614](https://github.com/trento-project/web/pull/614) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.5 to 6.5.6 in /assets [#612](https://github.com/trento-project/web/pull/612) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.5 to 6.5.6 in /assets [#611](https://github.com/trento-project/web/pull/611) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.2.2 to 26.4.5 in /assets [#610](https://github.com/trento-project/web/pull/610) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.39 to 0.14.42 in /assets [#609](https://github.com/trento-project/web/pull/609) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.6.3 to 1.6.4 in /assets [#608](https://github.com/trento-project/web/pull/608) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.5 to 6.5.6 in /assets [#607](https://github.com/trento-project/web/pull/607) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.5.5 to 6.5.6 in /assets [#606](https://github.com/trento-project/web/pull/606) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.5 to 6.5.6 in /assets [#605](https://github.com/trento-project/web/pull/605) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.4.0 to 0.5.0 [#604](https://github.com/trento-project/web/pull/604) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump swoosh from 1.6.6 to 1.7.0 [#603](https://github.com/trento-project/web/pull/603) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add the possibility to decode lists of items with deftype [#601](https://github.com/trento-project/web/pull/601) ([dottorblaster](https://github.com/dottorblaster))
- Bump @babel/preset-env from 7.18.0 to 7.18.2 in /assets [#599](https://github.com/trento-project/web/pull/599) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.6.2 to 1.6.3 in /assets [#598](https://github.com/trento-project/web/pull/598) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.18.0 to 7.18.2 in /assets [#597](https://github.com/trento-project/web/pull/597) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix_live_view from 0.17.9 to 0.17.10 [#596](https://github.com/trento-project/web/pull/596) ([dependabot[bot]](https://github.com/apps/dependabot))
- Decode subscription discovery payload through Ecto [#595](https://github.com/trento-project/web/pull/595) ([dottorblaster](https://github.com/dottorblaster))
- Refactor checks catalog operation tagging [#594](https://github.com/trento-project/web/pull/594) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @storybook/react from 6.5.4 to 6.5.5 in /assets [#593](https://github.com/trento-project/web/pull/593) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.4 to 6.5.5 in /assets [#592](https://github.com/trento-project/web/pull/592) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.4 to 6.5.5 in /assets [#590](https://github.com/trento-project/web/pull/590) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.8.1 to 1.8.2 in /assets [#589](https://github.com/trento-project/web/pull/589) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.4 to 6.5.5 in /assets [#588](https://github.com/trento-project/web/pull/588) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add e2e tests clusters overview [#587](https://github.com/trento-project/web/pull/587) ([rtorrero](https://github.com/rtorrero))
- Hosts overview e2e [#585](https://github.com/trento-project/web/pull/585) ([arbulu89](https://github.com/arbulu89))
- Bump quantum from 3.4.0 to 3.5.0 [#583](https://github.com/trento-project/web/pull/583) ([dependabot[bot]](https://github.com/apps/dependabot))
- Ecto decode cloud discovery [#582](https://github.com/trento-project/web/pull/582) ([dottorblaster](https://github.com/dottorblaster))
- Rollup integration test [#580](https://github.com/trento-project/web/pull/580) ([fabriziosestito](https://github.com/fabriziosestito))
- Improve the host details view E2E to cover more data [#578](https://github.com/trento-project/web/pull/578) ([arbulu89](https://github.com/arbulu89))
- Bump @storybook/addon-links from 6.5.3 to 6.5.4 in /assets [#577](https://github.com/trento-project/web/pull/577) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.3 to 6.5.4 in /assets [#576](https://github.com/trento-project/web/pull/576) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.15.0 to 8.16.0 in /assets [#575](https://github.com/trento-project/web/pull/575) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.3 to 6.5.4 in /assets [#574](https://github.com/trento-project/web/pull/574) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-redux from 8.0.1 to 8.0.2 in /assets [#573](https://github.com/trento-project/web/pull/573) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.5.3 to 6.5.4 in /assets [#572](https://github.com/trento-project/web/pull/572) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.3 to 6.5.4 in /assets [#571](https://github.com/trento-project/web/pull/571) ([dependabot[bot]](https://github.com/apps/dependabot))
- Event handlers failure context  [#568](https://github.com/trento-project/web/pull/568) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump @babel/core from 7.17.12 to 7.18.0 in /assets [#567](https://github.com/trento-project/web/pull/567) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.6.1 to 1.6.2 in /assets [#566](https://github.com/trento-project/web/pull/566) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.5.0 to 6.5.3 in /assets [#565](https://github.com/trento-project/web/pull/565) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.5.0 to 6.5.3 in /assets [#564](https://github.com/trento-project/web/pull/564) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.5.0 to 6.5.3 in /assets [#563](https://github.com/trento-project/web/pull/563) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.17.12 to 7.18.0 in /assets [#561](https://github.com/trento-project/web/pull/561) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.5.0 to 6.5.3 in /assets [#560](https://github.com/trento-project/web/pull/560) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.5.0 to 6.5.3 in /assets [#559](https://github.com/trento-project/web/pull/559) ([dependabot[bot]](https://github.com/apps/dependabot))
- Refactor cluster hosts executions state [#557](https://github.com/trento-project/web/pull/557) ([fabriziosestito](https://github.com/fabriziosestito))
- Speed up CI process [#556](https://github.com/trento-project/web/pull/556) ([arbulu89](https://github.com/arbulu89))
- Bump @storybook/addon-actions from 6.4.22 to 6.5.0 in /assets [#554](https://github.com/trento-project/web/pull/554) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.4.22 to 6.5.0 in /assets [#553](https://github.com/trento-project/web/pull/553) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.4.22 to 6.5.0 in /assets [#551](https://github.com/trento-project/web/pull/551) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.4.22 to 6.5.0 in /assets [#550](https://github.com/trento-project/web/pull/550) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.4.22 to 6.5.0 in /assets [#549](https://github.com/trento-project/web/pull/549) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.13 to 8.4.14 in /assets [#548](https://github.com/trento-project/web/pull/548) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump ecto_sql from 3.8.1 to 3.8.2 [#547](https://github.com/trento-project/web/pull/547) ([dependabot[bot]](https://github.com/apps/dependabot))
- About page e2e [#545](https://github.com/trento-project/web/pull/545) ([arbulu89](https://github.com/arbulu89))
- Add HANA details page e2e tests [#543](https://github.com/trento-project/web/pull/543) ([arbulu89](https://github.com/arbulu89))
- Bump @babel/preset-env from 7.17.10 to 7.17.12 in /assets [#541](https://github.com/trento-project/web/pull/541) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.17.10 to 7.17.12 in /assets [#539](https://github.com/trento-project/web/pull/539) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-react from 7.16.7 to 7.17.12 in /assets [#538](https://github.com/trento-project/web/pull/538) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix from 1.6.8 to 1.6.9 [#537](https://github.com/trento-project/web/pull/537) ([dependabot[bot]](https://github.com/apps/dependabot))
- Use exmachina factory generation [#535](https://github.com/trento-project/web/pull/535) ([arbulu89](https://github.com/arbulu89))
- Fix validate required for embedded fields [#534](https://github.com/trento-project/web/pull/534) ([fabriziosestito](https://github.com/fabriziosestito))
- Decode host discovery payload with Ecto [#533](https://github.com/trento-project/web/pull/533) ([dottorblaster](https://github.com/dottorblaster))
- Use ExMachina as test data generation factory for host telemetry [#532](https://github.com/trento-project/web/pull/532) ([arbulu89](https://github.com/arbulu89))
- Bump eslint-plugin-jest from 26.1.5 to 26.2.2 in /assets [#531](https://github.com/trento-project/web/pull/531) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add codespell job to the ci [#530](https://github.com/trento-project/web/pull/530) ([arbulu89](https://github.com/arbulu89))
- Format e2e js code [#527](https://github.com/trento-project/web/pull/527) ([arbulu89](https://github.com/arbulu89))
- Add default value to os_version [#526](https://github.com/trento-project/web/pull/526) ([fabriziosestito](https://github.com/fabriziosestito))
- Migrate sap overview e2e [#525](https://github.com/trento-project/web/pull/525) ([arbulu89](https://github.com/arbulu89))
- Add obs disk constraints to avoid out of space issue [#524](https://github.com/trento-project/web/pull/524) ([arbulu89](https://github.com/arbulu89))
- Exporters status badges [#523](https://github.com/trento-project/web/pull/523) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump esbuild from 0.14.38 to 0.14.39 in /assets [#521](https://github.com/trento-project/web/pull/521) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add complete e2e testing for the cluster details view [#520](https://github.com/trento-project/web/pull/520) ([rtorrero](https://github.com/rtorrero))
- Add checks catalog e2e tests [#519](https://github.com/trento-project/web/pull/519) ([arbulu89](https://github.com/arbulu89))
- Change CI cache key [#518](https://github.com/trento-project/web/pull/518) ([fabriziosestito](https://github.com/fabriziosestito))
- Upgrade to React 18 [#516](https://github.com/trento-project/web/pull/516) ([dottorblaster](https://github.com/dottorblaster))
- Revert config development [#514](https://github.com/trento-project/web/pull/514) ([arbulu89](https://github.com/arbulu89))
- Bump jest from 28.0.3 to 28.1.0 in /assets [#511](https://github.com/trento-project/web/pull/511) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.11.1 to 1.11.2 in /assets [#510](https://github.com/trento-project/web/pull/510) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 28.0.3 to 28.1.0 in /assets [#509](https://github.com/trento-project/web/pull/509) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.14.0 to 8.15.0 in /assets [#508](https://github.com/trento-project/web/pull/508) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.6.0 to 1.6.1 in /assets [#507](https://github.com/trento-project/web/pull/507) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add e2e tests for the host details view [#506](https://github.com/trento-project/web/pull/506) ([rtorrero](https://github.com/rtorrero))
- Bump phoenix from 1.6.7 to 1.6.8 [#502](https://github.com/trento-project/web/pull/502) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 3.8.0 to 4.0.1 [#501](https://github.com/trento-project/web/pull/501) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/setup-buildx-action from 1 to 2 [#500](https://github.com/trento-project/web/pull/500) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/build-push-action from 2 to 3 [#499](https://github.com/trento-project/web/pull/499) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/login-action from 1.14.1 to 2 [#498](https://github.com/trento-project/web/pull/498) ([dependabot[bot]](https://github.com/apps/dependabot))
- Snake case all the routes [#496](https://github.com/trento-project/web/pull/496) ([rtorrero](https://github.com/rtorrero))
- Bump timex from 3.7.7 to 3.7.8 [#491](https://github.com/trento-project/web/pull/491) ([dependabot[bot]](https://github.com/apps/dependabot))
- Rename axios wrapper calls [#490](https://github.com/trento-project/web/pull/490) ([rtorrero](https://github.com/rtorrero))
- Add development docker-compose service [#489](https://github.com/trento-project/web/pull/489) ([stefanotorresi](https://github.com/stefanotorresi))
- Bump autoprefixer from 10.4.6 to 10.4.7 in /assets [#487](https://github.com/trento-project/web/pull/487) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update dockerfile and add missing nodejs to tools [#486](https://github.com/trento-project/web/pull/486) ([stefanotorresi](https://github.com/stefanotorresi))
- Update pow to 1.0.27 [#485](https://github.com/trento-project/web/pull/485) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump @babel/core from 7.17.9 to 7.17.10 in /assets [#483](https://github.com/trento-project/web/pull/483) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 28.0.2 to 28.0.3 in /assets [#482](https://github.com/trento-project/web/pull/482) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.12 to 8.4.13 in /assets [#481](https://github.com/trento-project/web/pull/481) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/preset-env from 7.16.11 to 7.17.10 in /assets [#480](https://github.com/trento-project/web/pull/480) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.5 to 10.4.6 in /assets [#479](https://github.com/trento-project/web/pull/479) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump ecto_sql from 3.7.2 to 3.8.1 [#478](https://github.com/trento-project/web/pull/478) ([dependabot[bot]](https://github.com/apps/dependabot))
- Redirect to login on 401 status responses [#472](https://github.com/trento-project/web/pull/472) ([rtorrero](https://github.com/rtorrero))
- Bump phoenix from 1.6.6 to 1.6.7 [#367](https://github.com/trento-project/web/pull/367) ([dependabot[bot]](https://github.com/apps/dependabot))

## [1.0.0](https://github.com/trento-project/web/tree/1.0.0) (2022-04-29)

[Full Changelog](https://github.com/trento-project/web/compare/df6d355b2b955d6902f279cda3cd63f0865ab95c...1.0.0)

**Implemented enhancements:**

- EULA is only showed after a page refresh [#397](https://github.com/trento-project/web/issues/397)
- Add mailer for important alerts [#58](https://github.com/trento-project/web/issues/58)
- Fix html element hierarchy [#471](https://github.com/trento-project/web/pull/471) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Suse delivery [#408](https://github.com/trento-project/web/pull/408) ([arbulu89](https://github.com/arbulu89))
- Implement the collapsible sidebar [#344](https://github.com/trento-project/web/pull/344) ([arbulu89](https://github.com/arbulu89))
- Update execution request payload to use one cluster [#336](https://github.com/trento-project/web/pull/336) ([arbulu89](https://github.com/arbulu89))
- Handle unreachable checks execution scenario [#304](https://github.com/trento-project/web/pull/304) ([arbulu89](https://github.com/arbulu89))
- Integrate real runner execution usage [#300](https://github.com/trento-project/web/pull/300) ([arbulu89](https://github.com/arbulu89))
- Add query parameters for catalog controller [#296](https://github.com/trento-project/web/pull/296) ([arbulu89](https://github.com/arbulu89))
- Get catalog from runner [#257](https://github.com/trento-project/web/pull/257) ([arbulu89](https://github.com/arbulu89))
- Add checks catalog view [#241](https://github.com/trento-project/web/pull/241) ([arbulu89](https://github.com/arbulu89))

**Fixed bugs:**

- "cloudadmin" set as default as connection settings user in azure [#419](https://github.com/trento-project/web/issues/419)
- Connection settings switch doing funky things [#410](https://github.com/trento-project/web/issues/410)
- Improve sap instance parsing to use the hostname to get the fields [#475](https://github.com/trento-project/web/pull/475) ([arbulu89](https://github.com/arbulu89))
- Fix double scrollbar layout, take two [#470](https://github.com/trento-project/web/pull/470) ([dottorblaster](https://github.com/dottorblaster))
- Update the usage of the spinner icon during checks execution [#467](https://github.com/trento-project/web/pull/467) ([arbulu89](https://github.com/arbulu89))
- Fixes start execution trigger [#463](https://github.com/trento-project/web/pull/463) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Filter correctly the check results by host [#451](https://github.com/trento-project/web/pull/451) ([arbulu89](https://github.com/arbulu89))
- Fix connection settings switch for when the input is empty [#449](https://github.com/trento-project/web/pull/449) ([arbulu89](https://github.com/arbulu89))
- Handle aws clusters empty lists [#448](https://github.com/trento-project/web/pull/448) ([arbulu89](https://github.com/arbulu89))
- Fix regression in Dockerfile [#427](https://github.com/trento-project/web/pull/427) ([arbulu89](https://github.com/arbulu89))
- Fix sap system column usage in the host list overview [#387](https://github.com/trento-project/web/pull/387) ([arbulu89](https://github.com/arbulu89))
- Fix cloud details fields [#370](https://github.com/trento-project/web/pull/370) ([arbulu89](https://github.com/arbulu89))

**Closed issues:**

- Checks catalog error message on unknown provider is not meaningful enough [#433](https://github.com/trento-project/web/issues/433)
- Detect and show Virtual IP in Pacemaker Site details (Cluster detail page) [#389](https://github.com/trento-project/web/issues/389)
- If System replication has changed in a database instance, we should emit an event and project the new values [#384](https://github.com/trento-project/web/issues/384)
- Pushing data for the first time with photofinish while on the host overview results in an error [#382](https://github.com/trento-project/web/issues/382)
- Correctly detect Pacemaker Site details in ClusterDetails [#381](https://github.com/trento-project/web/issues/381)
- use cluster discovered provider in checks execution request [#380](https://github.com/trento-project/web/issues/380)
- Host overview could reuse the already existing getInstancesOnHost selector [#375](https://github.com/trento-project/web/issues/375)
- CIB last written command enrichment broadcasted event resets checks selection redux state [#366](https://github.com/trento-project/web/issues/366)
- Missing error boundary for the single-page app [#319](https://github.com/trento-project/web/issues/319)
- Guard against empty tags [#305](https://github.com/trento-project/web/issues/305)
- Display prominent notification messages [#258](https://github.com/trento-project/web/issues/258)
- Using new! in case of nested errors raises without reporting the actual error [#251](https://github.com/trento-project/web/issues/251)
- Add links to cluster detail, when possible [#242](https://github.com/trento-project/web/issues/242)
- Add System Replication to HANA databases overview. [#219](https://github.com/trento-project/web/issues/219)
- Remove extra query in projectors when updating read models [#207](https://github.com/trento-project/web/issues/207)
- Add read_model suffix to read model tables [#201](https://github.com/trento-project/web/issues/201)
- Add the missing tests for the tags creation/deletion [#198](https://github.com/trento-project/web/issues/198)
- Cluster checks related, command and aggregate logic are not tested [#101](https://github.com/trento-project/web/issues/101)
- HostDetailsUpdated is missing from host_projector tests [#80](https://github.com/trento-project/web/issues/80)
- Add discovery integration event parsing tests [#69](https://github.com/trento-project/web/issues/69)
- Filter ipv6 and loopbacks from host ip addresses [#63](https://github.com/trento-project/web/issues/63)
- Add factory/fixtures library to the mix [#57](https://github.com/trento-project/web/issues/57)
- Add HostDetailsUpdated events [#56](https://github.com/trento-project/web/issues/56)
- Emit HostRegistered when UpdateHeartbeatStatus is received before the host registration [#55](https://github.com/trento-project/web/issues/55)
- Update configuration for Tailwind v3.0 [#54](https://github.com/trento-project/web/issues/54)
- Enable Phoenix hot reload and double check Domo compile time structs [#53](https://github.com/trento-project/web/issues/53)
- Proposal: Switch to domo instead of middleware for command validation [#52](https://github.com/trento-project/web/issues/52)
- Check enum libraries for compile time enums [#49](https://github.com/trento-project/web/issues/49)
- Add test for monitoring context [#47](https://github.com/trento-project/web/issues/47)
- Add validate middleware tests [#40](https://github.com/trento-project/web/issues/40)
- Use credo strict [#35](https://github.com/trento-project/web/issues/35)

**Merged pull requests:**

- Add CHANGELOG, bump version in mix.exs [#477](https://github.com/trento-project/web/pull/477) ([dottorblaster](https://github.com/dottorblaster))
- Bump docker/metadata-action from 3.7.0 to 3.8.0 [#473](https://github.com/trento-project/web/pull/473) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump swoosh from 1.6.5 to 1.6.6 [#469](https://github.com/trento-project/web/pull/469) ([dependabot[bot]](https://github.com/apps/dependabot))
- Prune old events [#468](https://github.com/trento-project/web/pull/468) ([fabriziosestito](https://github.com/fabriziosestito))
- Rename dev environment by default [#466](https://github.com/trento-project/web/pull/466) ([arbulu89](https://github.com/arbulu89))
- Update CD job [#465](https://github.com/trento-project/web/pull/465) ([stefanotorresi](https://github.com/stefanotorresi))
- Fix dashboard [#462](https://github.com/trento-project/web/pull/462) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump jest from 28.0.1 to 28.0.2 in /assets [#461](https://github.com/trento-project/web/pull/461) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 28.0.1 to 28.0.2 in /assets [#459](https://github.com/trento-project/web/pull/459) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eventstore from `085602a` to `9883f4a` [#458](https://github.com/trento-project/web/pull/458) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 0.27.1 to 0.27.2 in /assets [#457](https://github.com/trento-project/web/pull/457) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postgrex from 0.16.2 to 0.16.3 [#456](https://github.com/trento-project/web/pull/456) ([dependabot[bot]](https://github.com/apps/dependabot))
- Revert "Fix double scrollbars" [#455](https://github.com/trento-project/web/pull/455) ([dottorblaster](https://github.com/dottorblaster))
- Fix alerts event handler ArgumentError when disabled [#454](https://github.com/trento-project/web/pull/454) ([fabriziosestito](https://github.com/fabriziosestito))
- Change discovery notification icon [#453](https://github.com/trento-project/web/pull/453) ([fabriziosestito](https://github.com/fabriziosestito))
- Add sign out link [#452](https://github.com/trento-project/web/pull/452) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix double scrollbars [#450](https://github.com/trento-project/web/pull/450) ([dottorblaster](https://github.com/dottorblaster))
- fix instance identification when only hana db available [#447](https://github.com/trento-project/web/pull/447) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix System Replication nil values projection [#446](https://github.com/trento-project/web/pull/446) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump jest from 28.0.0 to 28.0.1 in /assets [#445](https://github.com/trento-project/web/pull/445) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 0.27.0 to 0.27.1 in /assets [#444](https://github.com/trento-project/web/pull/444) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump swoosh from 1.6.4 to 1.6.5 [#443](https://github.com/trento-project/web/pull/443) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 28.0.0 to 28.0.1 in /assets [#441](https://github.com/trento-project/web/pull/441) ([dependabot[bot]](https://github.com/apps/dependabot))
- Forward cluster_details_updated event to the FE [#440](https://github.com/trento-project/web/pull/440) ([fabriziosestito](https://github.com/fabriziosestito))
- Read database instances from the proper slice of state [#438](https://github.com/trento-project/web/pull/438) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Use real sites instead of placeholders [#437](https://github.com/trento-project/web/pull/437) ([fabriziosestito](https://github.com/fabriziosestito))
- Add notification message for non supported providers for checks [#436](https://github.com/trento-project/web/pull/436) ([arbulu89](https://github.com/arbulu89))
- Selected checks are now reactive [#435](https://github.com/trento-project/web/pull/435) ([fabriziosestito](https://github.com/fabriziosestito))
- Apply markdown rendering in check selection and result views [#434](https://github.com/trento-project/web/pull/434) ([arbulu89](https://github.com/arbulu89))
- Include AWS and GCP handling [#432](https://github.com/trento-project/web/pull/432) ([rtorrero](https://github.com/rtorrero))
- Show only results of selected checks [#431](https://github.com/trento-project/web/pull/431) ([fabriziosestito](https://github.com/fabriziosestito))
- Discover azure admin user [#430](https://github.com/trento-project/web/pull/430) ([fabriziosestito](https://github.com/fabriziosestito))
- Refactored user determination on checks execution request [#428](https://github.com/trento-project/web/pull/428) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump axios from 0.26.1 to 0.27.0 in /assets [#425](https://github.com/trento-project/web/pull/425) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.5.0 to 1.6.0 in /assets [#424](https://github.com/trento-project/web/pull/424) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump jest from 27.5.1 to 28.0.0 in /assets [#423](https://github.com/trento-project/web/pull/423) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-jest from 27.5.1 to 28.0.0 in /assets [#422](https://github.com/trento-project/web/pull/422) ([dependabot[bot]](https://github.com/apps/dependabot))
- Split back again the dockerfiles for gh and obs registries [#421](https://github.com/trento-project/web/pull/421) ([arbulu89](https://github.com/arbulu89))
- Improve checks selection [#420](https://github.com/trento-project/web/pull/420) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix error in CI file included in prev PR [#417](https://github.com/trento-project/web/pull/417) ([arbulu89](https://github.com/arbulu89))
- Add virtual ip parsing [#415](https://github.com/trento-project/web/pull/415) ([rtorrero](https://github.com/rtorrero))
- Bump eslint from 8.13.0 to 8.14.0 in /assets [#414](https://github.com/trento-project/web/pull/414) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.4 to 10.4.5 in /assets [#413](https://github.com/trento-project/web/pull/413) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.1.4 to 26.1.5 in /assets [#412](https://github.com/trento-project/web/pull/412) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix wrong system replication status [#411](https://github.com/trento-project/web/pull/411) ([fabriziosestito](https://github.com/fabriziosestito))
- Add scheduled clusters checks execution [#409](https://github.com/trento-project/web/pull/409) ([fabriziosestito](https://github.com/fabriziosestito))
- Host connection settings UI - missing commit [#407](https://github.com/trento-project/web/pull/407) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Host connection settings UI [#405](https://github.com/trento-project/web/pull/405) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Update system replication [#404](https://github.com/trento-project/web/pull/404) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump @storybook/testing-library from 0.0.10 to 0.0.11 in /assets [#402](https://github.com/trento-project/web/pull/402) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.37 to 0.14.38 in /assets [#401](https://github.com/trento-project/web/pull/401) ([dependabot[bot]](https://github.com/apps/dependabot))
- Remove heartbeat command deduplication [#400](https://github.com/trento-project/web/pull/400) ([fabriziosestito](https://github.com/fabriziosestito))
- Refactor register database instance handler by using multi [#399](https://github.com/trento-project/web/pull/399) ([fabriziosestito](https://github.com/fabriziosestito))
- Make the premium EULA rely entirely on the flavor [#398](https://github.com/trento-project/web/pull/398) ([dottorblaster](https://github.com/dottorblaster))
- remove Phoenix Framework suffix from root html title [#396](https://github.com/trento-project/web/pull/396) ([stefanotorresi](https://github.com/stefanotorresi))
- Fix effect triggering in Checks selection [#395](https://github.com/trento-project/web/pull/395) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add connection settings api [#394](https://github.com/trento-project/web/pull/394) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump react-markdown from 8.0.2 to 8.0.3 in /assets [#393](https://github.com/trento-project/web/pull/393) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.36 to 0.14.37 in /assets [#392](https://github.com/trento-project/web/pull/392) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-redux from 8.0.0 to 8.0.1 in /assets [#391](https://github.com/trento-project/web/pull/391) ([dependabot[bot]](https://github.com/apps/dependabot))
- Don't do anything with  duplicated or empty tags [#390](https://github.com/trento-project/web/pull/390) ([rtorrero](https://github.com/rtorrero))
- Comment out top right buttons [#388](https://github.com/trento-project/web/pull/388) ([fabriziosestito](https://github.com/fabriziosestito))
- Use provider checks execution [#386](https://github.com/trento-project/web/pull/386) ([fabriziosestito](https://github.com/fabriziosestito))
- Cluster Details and Settings Part 1 [#385](https://github.com/trento-project/web/pull/385) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add system replication / status [#383](https://github.com/trento-project/web/pull/383) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump @storybook/testing-library from 0.0.9 to 0.0.10 in /assets [#379](https://github.com/trento-project/web/pull/379) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump babel-loader from 8.2.4 to 8.2.5 in /assets [#378](https://github.com/trento-project/web/pull/378) ([dependabot[bot]](https://github.com/apps/dependabot))
- Refactor CloudProvider to Provider during Cluster discovery [#377](https://github.com/trento-project/web/pull/377) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Parse flat map format lists in SAP systems discovery payload [#376](https://github.com/trento-project/web/pull/376) ([arbulu89](https://github.com/arbulu89))
- Ingest the published cloud service provider of a pacemaker cluster [#373](https://github.com/trento-project/web/pull/373) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Generate admin user on init [#372](https://github.com/trento-project/web/pull/372) ([fabriziosestito](https://github.com/fabriziosestito))
- Add checks health to checks execution completed [#371](https://github.com/trento-project/web/pull/371) ([fabriziosestito](https://github.com/fabriziosestito))
- Add sap-system/databases linking from host overview [#369](https://github.com/trento-project/web/pull/369) ([rtorrero](https://github.com/rtorrero))
- Bump react-redux from 7.2.8 to 8.0.0 in /assets [#368](https://github.com/trento-project/web/pull/368) ([dependabot[bot]](https://github.com/apps/dependabot))
- Build and push containers depends on e2e test [#365](https://github.com/trento-project/web/pull/365) ([fabriziosestito](https://github.com/fabriziosestito))
- Disallow empty tags [#364](https://github.com/trento-project/web/pull/364) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump dayjs from 1.11.0 to 1.11.1 in /assets [#363](https://github.com/trento-project/web/pull/363) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix Dialyzer CI cache [#362](https://github.com/trento-project/web/pull/362) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix HostDetailsUpdated event broadcast to frontend [#361](https://github.com/trento-project/web/pull/361) ([fabriziosestito](https://github.com/fabriziosestito))
- Put accept_eula and settings endpoints under apikey_auth pipeline [#359](https://github.com/trento-project/web/pull/359) ([dottorblaster](https://github.com/dottorblaster))
- Moved routes in the correct authenticated pipes [#358](https://github.com/trento-project/web/pull/358) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @storybook/react from 6.4.21 to 6.4.22 in /assets [#357](https://github.com/trento-project/web/pull/357) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.4.21 to 6.4.22 in /assets [#356](https://github.com/trento-project/web/pull/356) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.4.21 to 6.4.22 in /assets [#355](https://github.com/trento-project/web/pull/355) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.4.21 to 6.4.22 in /assets [#354](https://github.com/trento-project/web/pull/354) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.4.21 to 6.4.22 in /assets [#353](https://github.com/trento-project/web/pull/353) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump gen_smtp from 1.1.1 to 1.2.0 [#352](https://github.com/trento-project/web/pull/352) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add api key settings [#351](https://github.com/trento-project/web/pull/351) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump tailwindcss from 3.0.23 to 3.0.24 in /assets [#350](https://github.com/trento-project/web/pull/350) ([dependabot[bot]](https://github.com/apps/dependabot))
- Eula [#349](https://github.com/trento-project/web/pull/349) ([dottorblaster](https://github.com/dottorblaster))
- Add api auth [#348](https://github.com/trento-project/web/pull/348) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Update e2e to use the navigation bar [#347](https://github.com/trento-project/web/pull/347) ([arbulu89](https://github.com/arbulu89))
- Jungle green primary buttons [#346](https://github.com/trento-project/web/pull/346) ([fabriziosestito](https://github.com/fabriziosestito))
- Add footer [#345](https://github.com/trento-project/web/pull/345) ([fabriziosestito](https://github.com/fabriziosestito))
- Add something went wrong page [#343](https://github.com/trento-project/web/pull/343) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump esbuild from 0.14.34 to 0.14.36 in /assets [#342](https://github.com/trento-project/web/pull/342) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/upload-artifact from 2 to 3 [#341](https://github.com/trento-project/web/pull/341) ([dependabot[bot]](https://github.com/apps/dependabot))
- Enable the CI back on main push [#340](https://github.com/trento-project/web/pull/340) ([rtorrero](https://github.com/rtorrero))
- Add cypress e2e tests to GH Actions [#339](https://github.com/trento-project/web/pull/339) ([rtorrero](https://github.com/rtorrero))
- Add not found page [#338](https://github.com/trento-project/web/pull/338) ([fabriziosestito](https://github.com/fabriziosestito))
- Pin erlang version in .tool-versions [#335](https://github.com/trento-project/web/pull/335) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add missing field to cluster projection [#334](https://github.com/trento-project/web/pull/334) ([fabriziosestito](https://github.com/fabriziosestito))
- Added some documentation [#333](https://github.com/trento-project/web/pull/333) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump @storybook/addon-interactions from 6.4.20 to 6.4.21 in /assets [#332](https://github.com/trento-project/web/pull/332) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.4.20 to 6.4.21 in /assets [#331](https://github.com/trento-project/web/pull/331) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-jest from 26.1.3 to 26.1.4 in /assets [#330](https://github.com/trento-project/web/pull/330) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/react from 6.4.20 to 6.4.21 in /assets [#329](https://github.com/trento-project/web/pull/329) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.4.20 to 6.4.21 in /assets [#328](https://github.com/trento-project/web/pull/328) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.4.20 to 6.4.21 in /assets [#327](https://github.com/trento-project/web/pull/327) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint from 8.12.0 to 8.13.0 in /assets [#326](https://github.com/trento-project/web/pull/326) ([dependabot[bot]](https://github.com/apps/dependabot))
- Ensure better key presence check in the catalog reducer [#325](https://github.com/trento-project/web/pull/325) ([dottorblaster](https://github.com/dottorblaster))
- Bump phoenix_live_view from 0.17.8 to 0.17.9 [#323](https://github.com/trento-project/web/pull/323) ([dependabot[bot]](https://github.com/apps/dependabot))
- Tags animations and click outside [#322](https://github.com/trento-project/web/pull/322) ([fabriziosestito](https://github.com/fabriziosestito))
- Cluster-e2e-tests [#321](https://github.com/trento-project/web/pull/321) ([rtorrero](https://github.com/rtorrero))
- Health overviews [#320](https://github.com/trento-project/web/pull/320) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Various tags component fixes [#318](https://github.com/trento-project/web/pull/318) ([fabriziosestito](https://github.com/fabriziosestito))
- Add e2e tests [#317](https://github.com/trento-project/web/pull/317) ([rtorrero](https://github.com/rtorrero))
- Fix tags [#316](https://github.com/trento-project/web/pull/316) ([fabriziosestito](https://github.com/fabriziosestito))
- Do not shrink sidebar [#315](https://github.com/trento-project/web/pull/315) ([fabriziosestito](https://github.com/fabriziosestito))
- Homepage overview UI [#314](https://github.com/trento-project/web/pull/314) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add missing columns and uniform links [#313](https://github.com/trento-project/web/pull/313) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump esbuild from 0.14.32 to 0.14.34 in /assets [#312](https://github.com/trento-project/web/pull/312) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix_live_view from 0.17.7 to 0.17.8 [#310](https://github.com/trento-project/web/pull/310) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.17.8 to 7.17.9 in /assets [#311](https://github.com/trento-project/web/pull/311) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/plugin-transform-modules-commonjs from 7.17.7 to 7.17.9 in /assets [#309](https://github.com/trento-project/web/pull/309) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump swoosh from 1.6.3 to 1.6.4 [#308](https://github.com/trento-project/web/pull/308) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump docker/metadata-action from 3.6.2 to 3.7.0 [#307](https://github.com/trento-project/web/pull/307) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add cluster discovered health  [#306](https://github.com/trento-project/web/pull/306) ([fabriziosestito](https://github.com/fabriziosestito))
- Homepage overview [#302](https://github.com/trento-project/web/pull/302) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump esbuild from 0.14.31 to 0.14.32 in /assets [#301](https://github.com/trento-project/web/pull/301) ([dependabot[bot]](https://github.com/apps/dependabot))
- Optional alerting config [#298](https://github.com/trento-project/web/pull/298) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add grafana iframe [#297](https://github.com/trento-project/web/pull/297) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix boolean usage in docker compose [#295](https://github.com/trento-project/web/pull/295) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add database tag endpoint [#294](https://github.com/trento-project/web/pull/294) ([rtorrero](https://github.com/rtorrero))
- Init grafana dashboard [#293](https://github.com/trento-project/web/pull/293) ([fabriziosestito](https://github.com/fabriziosestito))
- Email alerting [#291](https://github.com/trento-project/web/pull/291) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump react-redux from 7.2.7 to 7.2.8 in /assets [#290](https://github.com/trento-project/web/pull/290) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-links from 6.4.19 to 6.4.20 in /assets [#288](https://github.com/trento-project/web/pull/288) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-essentials from 6.4.19 to 6.4.20 in /assets [#287](https://github.com/trento-project/web/pull/287) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-actions from 6.4.19 to 6.4.20 in /assets [#286](https://github.com/trento-project/web/pull/286) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump prettier from 2.6.1 to 2.6.2 in /assets [#285](https://github.com/trento-project/web/pull/285) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @storybook/addon-interactions from 6.4.19 to 6.4.20 in /assets [#284](https://github.com/trento-project/web/pull/284) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.29 to 0.14.31 in /assets [#283](https://github.com/trento-project/web/pull/283) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update catalog frontend [#281](https://github.com/trento-project/web/pull/281) ([arbulu89](https://github.com/arbulu89))
- Paginated tables [#280](https://github.com/trento-project/web/pull/280) ([dottorblaster](https://github.com/dottorblaster))
- Bump react-redux from 7.2.6 to 7.2.7 in /assets [#279](https://github.com/trento-project/web/pull/279) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.8.0 to 1.8.1 in /assets [#278](https://github.com/trento-project/web/pull/278) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.2.2 to 6.3.0 in /assets [#277](https://github.com/trento-project/web/pull/277) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-markdown from 8.0.1 to 8.0.2 in /assets [#276](https://github.com/trento-project/web/pull/276) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump httpoison from 1.8.0 to 1.8.1 [#275](https://github.com/trento-project/web/pull/275) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add prometheus target discovery endpoint [#274](https://github.com/trento-project/web/pull/274) ([fabriziosestito](https://github.com/fabriziosestito))
- Add ssh address to host [#273](https://github.com/trento-project/web/pull/273) ([fabriziosestito](https://github.com/fabriziosestito))
- Rename and clean-up dtos [#272](https://github.com/trento-project/web/pull/272) ([fabriziosestito](https://github.com/fabriziosestito))
- CibLastWritten broadcast [#271](https://github.com/trento-project/web/pull/271) ([dottorblaster](https://github.com/dottorblaster))
- Fix typo [#270](https://github.com/trento-project/web/pull/270) ([ajaeger](https://github.com/ajaeger))
- Fix heartbeat channel broadcast [#269](https://github.com/trento-project/web/pull/269) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix heartbeat icon [#268](https://github.com/trento-project/web/pull/268) ([fabriziosestito](https://github.com/fabriziosestito))
- Remove unused feature flag [#266](https://github.com/trento-project/web/pull/266) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix filters, links and cluster actions [#265](https://github.com/trento-project/web/pull/265) ([fabriziosestito](https://github.com/fabriziosestito))
- Store tags state [#264](https://github.com/trento-project/web/pull/264) ([rtorrero](https://github.com/rtorrero))
- Use proper navbar icons [#262](https://github.com/trento-project/web/pull/262) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump esbuild from 0.14.28 to 0.14.29 in /assets [#261](https://github.com/trento-project/web/pull/261) ([dependabot[bot]](https://github.com/apps/dependabot))
- Close filters when clicking outside [#260](https://github.com/trento-project/web/pull/260) ([fabriziosestito](https://github.com/fabriziosestito))
- Add checks execution domain logic [#256](https://github.com/trento-project/web/pull/256) ([fabriziosestito](https://github.com/fabriziosestito))
- Cluster details with IPs and filters enabled app-wide [#254](https://github.com/trento-project/web/pull/254) ([dottorblaster](https://github.com/dottorblaster))
- Fix Trento.Type error handling and adds tests [#252](https://github.com/trento-project/web/pull/252) ([fabriziosestito](https://github.com/fabriziosestito))
- Flavor determination in about api [#250](https://github.com/trento-project/web/pull/250) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump eslint from 8.11.0 to 8.12.0 in /assets [#247](https://github.com/trento-project/web/pull/247) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.27 to 0.14.28 in /assets [#246](https://github.com/trento-project/web/pull/246) ([dependabot[bot]](https://github.com/apps/dependabot))
- Fix dump scenario [#245](https://github.com/trento-project/web/pull/245) ([fabriziosestito](https://github.com/fabriziosestito))
- Sap system details improvements [#244](https://github.com/trento-project/web/pull/244) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Serialize events in json and add DSL [#243](https://github.com/trento-project/web/pull/243) ([fabriziosestito](https://github.com/fabriziosestito))
- Sap system detail UI [#240](https://github.com/trento-project/web/pull/240) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump minimist from 1.2.5 to 1.2.6 in /assets [#239](https://github.com/trento-project/web/pull/239) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump floki from 0.32.0 to 0.32.1 [#238](https://github.com/trento-project/web/pull/238) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump prettier from 2.6.0 to 2.6.1 in /assets [#237](https://github.com/trento-project/web/pull/237) ([dependabot[bot]](https://github.com/apps/dependabot))
- More tests [#236](https://github.com/trento-project/web/pull/236) ([rtorrero](https://github.com/rtorrero))
- Sap system detail backend [#235](https://github.com/trento-project/web/pull/235) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix HostAddedToCluster projection [#234](https://github.com/trento-project/web/pull/234) ([fabriziosestito](https://github.com/fabriziosestito))
- Add tags tests [#232](https://github.com/trento-project/web/pull/232) ([rtorrero](https://github.com/rtorrero))
- Add checks integration service and mock runner (part 1) [#231](https://github.com/trento-project/web/pull/231) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump babel-loader from 8.2.3 to 8.2.4 in /assets [#230](https://github.com/trento-project/web/pull/230) ([dependabot[bot]](https://github.com/apps/dependabot))
- Cluster details [#229](https://github.com/trento-project/web/pull/229) ([dottorblaster](https://github.com/dottorblaster))
- Live sap systems health [#228](https://github.com/trento-project/web/pull/228) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Use table component for livefeed [#227](https://github.com/trento-project/web/pull/227) ([dottorblaster](https://github.com/dottorblaster))
- Project details when cluster is registered [#226](https://github.com/trento-project/web/pull/226) ([fabriziosestito](https://github.com/fabriziosestito))
- Databases overview reactiveness [#225](https://github.com/trento-project/web/pull/225) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump peter-evans/repository-dispatch from 1 to 2 [#224](https://github.com/trento-project/web/pull/224) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/cache from 2 to 3 [#223](https://github.com/trento-project/web/pull/223) ([dependabot[bot]](https://github.com/apps/dependabot))
- Databases overview [#218](https://github.com/trento-project/web/pull/218) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Publish telemetry [#217](https://github.com/trento-project/web/pull/217) ([fabriziosestito](https://github.com/fabriziosestito))
- Remove unnecessary query when updating read models [#216](https://github.com/trento-project/web/pull/216) ([rtorrero](https://github.com/rtorrero))
- Fix SapSystems Tags existence checking [#215](https://github.com/trento-project/web/pull/215) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fix eslint execution [#214](https://github.com/trento-project/web/pull/214) ([dottorblaster](https://github.com/dottorblaster))
- Fix sap systems state [#213](https://github.com/trento-project/web/pull/213) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Add UI tagging for hosts, clusters and sapsystems [#212](https://github.com/trento-project/web/pull/212) ([rtorrero](https://github.com/rtorrero))
- Bump @babel/core from 7.17.7 to 7.17.8 in /assets [#211](https://github.com/trento-project/web/pull/211) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump fun_with_flags_ui from 0.7.2 to 0.8.0 [#210](https://github.com/trento-project/web/pull/210) ([dependabot[bot]](https://github.com/apps/dependabot))
- Enable warnings as errors in CI build step [#208](https://github.com/trento-project/web/pull/208) ([fabriziosestito](https://github.com/fabriziosestito))
- Project Database and SAP System health changed event [#206](https://github.com/trento-project/web/pull/206) ([fabriziosestito](https://github.com/fabriziosestito))
- Extreme makeover filters edition [#205](https://github.com/trento-project/web/pull/205) ([dottorblaster](https://github.com/dottorblaster))
- Fixed state nullability check [#203](https://github.com/trento-project/web/pull/203) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Fixed element indexing in react components [#202](https://github.com/trento-project/web/pull/202) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Clean-up architecture and project structure [#199](https://github.com/trento-project/web/pull/199) ([fabriziosestito](https://github.com/fabriziosestito))
- Rename application [#197](https://github.com/trento-project/web/pull/197) ([fabriziosestito](https://github.com/fabriziosestito))
- Add Live update to SAP Systems Overview [#196](https://github.com/trento-project/web/pull/196) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Order instances by instance number [#195](https://github.com/trento-project/web/pull/195) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump autoprefixer from 10.4.3 to 10.4.4 in /assets [#194](https://github.com/trento-project/web/pull/194) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.11 to 8.4.12 in /assets [#193](https://github.com/trento-project/web/pull/193) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild-plugin-path-alias from 1.0.5 to 1.0.6 in /assets [#192](https://github.com/trento-project/web/pull/192) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add onAdd and onRemove callbacks to Tags [#191](https://github.com/trento-project/web/pull/191) ([rtorrero](https://github.com/rtorrero))
- Host details [#188](https://github.com/trento-project/web/pull/188) ([dottorblaster](https://github.com/dottorblaster))
- Collapsible sap system overview details [#187](https://github.com/trento-project/web/pull/187) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Minor ui improvements on SAP systems overview [#182](https://github.com/trento-project/web/pull/182) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Project  host telemetry data [#181](https://github.com/trento-project/web/pull/181) ([fabriziosestito](https://github.com/fabriziosestito))
- Sap system overview details [#180](https://github.com/trento-project/web/pull/180) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump prettier from 2.5.1 to 2.6.0 in /assets [#179](https://github.com/trento-project/web/pull/179) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.8 to 8.4.11 in /assets [#178](https://github.com/trento-project/web/pull/178) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump autoprefixer from 10.4.2 to 10.4.3 in /assets [#177](https://github.com/trento-project/web/pull/177) ([dependabot[bot]](https://github.com/apps/dependabot))
- Store discovery events and add dump scenario task/script [#176](https://github.com/trento-project/web/pull/176) ([fabriziosestito](https://github.com/fabriziosestito))
- Refactor discovery [#174](https://github.com/trento-project/web/pull/174) ([fabriziosestito](https://github.com/fabriziosestito))
- Reactive sap systems overview - listing [#173](https://github.com/trento-project/web/pull/173) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump dayjs from 1.10.8 to 1.11.0 in /assets [#172](https://github.com/trento-project/web/pull/172) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.25 to 0.14.27 in /assets [#171](https://github.com/trento-project/web/pull/171) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @babel/core from 7.17.5 to 7.17.7 in /assets [#170](https://github.com/trento-project/web/pull/170) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add HANA cluster details [#168](https://github.com/trento-project/web/pull/168) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix sles subscriptions count [#167](https://github.com/trento-project/web/pull/167) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Bump eslint from 8.10.0 to 8.11.0 in /assets [#166](https://github.com/trento-project/web/pull/166) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.29.3 to 7.29.4 in /assets [#165](https://github.com/trento-project/web/pull/165) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add designated controller field [#164](https://github.com/trento-project/web/pull/164) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix application instance registration [#163](https://github.com/trento-project/web/pull/163) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Switch to erlang term event serializer [#162](https://github.com/trento-project/web/pull/162) ([fabriziosestito](https://github.com/fabriziosestito))
- Add feature flags [#161](https://github.com/trento-project/web/pull/161) ([fabriziosestito](https://github.com/fabriziosestito))
- New layout [#160](https://github.com/trento-project/web/pull/160) ([dottorblaster](https://github.com/dottorblaster))
- Make tables automatically filter themselves [#159](https://github.com/trento-project/web/pull/159) ([dottorblaster](https://github.com/dottorblaster))
- Several fix and cleanup galore [#158](https://github.com/trento-project/web/pull/158) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump axios from 0.26.0 to 0.26.1 in /assets [#157](https://github.com/trento-project/web/pull/157) ([dependabot[bot]](https://github.com/apps/dependabot))
- Adds scenario fixtures [#156](https://github.com/trento-project/web/pull/156) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Use table cluster lists [#154](https://github.com/trento-project/web/pull/154) ([rtorrero](https://github.com/rtorrero))
- Use the new react table component in hosts list [#153](https://github.com/trento-project/web/pull/153) ([rtorrero](https://github.com/rtorrero))
- Tags component [#150](https://github.com/trento-project/web/pull/150) ([dottorblaster](https://github.com/dottorblaster))
- Bump postcss from 8.4.7 to 8.4.8 in /assets [#149](https://github.com/trento-project/web/pull/149) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump esbuild from 0.14.24 to 0.14.25 in /assets [#148](https://github.com/trento-project/web/pull/148) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add provider details data [#145](https://github.com/trento-project/web/pull/145) ([arbulu89](https://github.com/arbulu89))
- Add an about page [#144](https://github.com/trento-project/web/pull/144) ([dottorblaster](https://github.com/dottorblaster))
- Bump esbuild from 0.14.23 to 0.14.24 in /assets [#143](https://github.com/trento-project/web/pull/143) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump eslint-plugin-react from 7.29.2 to 7.29.3 in /assets [#142](https://github.com/trento-project/web/pull/142) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add SAP systems [#141](https://github.com/trento-project/web/pull/141) ([fabriziosestito](https://github.com/fabriziosestito))
- Add provider updated event and frontend updates [#140](https://github.com/trento-project/web/pull/140) ([arbulu89](https://github.com/arbulu89))
- Bump @heroicons/react from 1.0.5 to 1.0.6 in /assets [#139](https://github.com/trento-project/web/pull/139) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add subscriptions projection [#138](https://github.com/trento-project/web/pull/138) ([dottorblaster](https://github.com/dottorblaster))
- Bump actions/checkout from 2 to 3 [#137](https://github.com/trento-project/web/pull/137) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.2.1 to 6.2.2 in /assets [#136](https://github.com/trento-project/web/pull/136) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump dayjs from 1.10.7 to 1.10.8 in /assets [#135](https://github.com/trento-project/web/pull/135) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump actions/setup-node from 2 to 3 [#134](https://github.com/trento-project/web/pull/134) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add eslint config [#132](https://github.com/trento-project/web/pull/132) ([dottorblaster](https://github.com/dottorblaster))
- Add prod release [#131](https://github.com/trento-project/web/pull/131) ([fabriziosestito](https://github.com/fabriziosestito))
- Storybook and a table component [#130](https://github.com/trento-project/web/pull/130) ([dottorblaster](https://github.com/dottorblaster))
- Some login page fixes [#129](https://github.com/trento-project/web/pull/129) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump credo from 1.6.3 to 1.6.4 [#128](https://github.com/trento-project/web/pull/128) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.7.2 to 1.8.0 in /assets [#127](https://github.com/trento-project/web/pull/127) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add Tronto.AggregateCase and Tronto.Factory and refactor tests [#126](https://github.com/trento-project/web/pull/126) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix for gigalixir which I inadvertently broke [#125](https://github.com/trento-project/web/pull/125) ([dottorblaster](https://github.com/dottorblaster))
- Fix static assets deployment using the new config [#124](https://github.com/trento-project/web/pull/124) ([dottorblaster](https://github.com/dottorblaster))
- Add dockerfiles [#122](https://github.com/trento-project/web/pull/122) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump postcss from 8.4.6 to 8.4.7 in /assets [#121](https://github.com/trento-project/web/pull/121) ([dependabot[bot]](https://github.com/apps/dependabot))
- Switch esbuild to a build script [#120](https://github.com/trento-project/web/pull/120) ([dottorblaster](https://github.com/dottorblaster))
- Bump postgrex from 0.16.1 to 0.16.2 [#119](https://github.com/trento-project/web/pull/119) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix_live_dashboard from 0.6.4 to 0.6.5 [#118](https://github.com/trento-project/web/pull/118) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.4.3 to 1.5.0 in /assets [#117](https://github.com/trento-project/web/pull/117) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.22 to 3.0.23 in /assets [#116](https://github.com/trento-project/web/pull/116) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump typed_struct from 0.2.1 to 0.3.0 [#115](https://github.com/trento-project/web/pull/115) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump swoosh from 1.6.2 to 1.6.3 [#114](https://github.com/trento-project/web/pull/114) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump axios from 0.25.0 to 0.26.0 in /assets [#113](https://github.com/trento-project/web/pull/113) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.21 to 3.0.22 in /assets [#112](https://github.com/trento-project/web/pull/112) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.19 to 3.0.21 in /assets [#111](https://github.com/trento-project/web/pull/111) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add basic mail alerting [#110](https://github.com/trento-project/web/pull/110) ([fabriziosestito](https://github.com/fabriziosestito))
- Add cluster health feature [#109](https://github.com/trento-project/web/pull/109) ([dottorblaster](https://github.com/dottorblaster))
- Bump credo from 1.6.2 to 1.6.3 [#108](https://github.com/trento-project/web/pull/108) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix_live_view from 0.17.6 to 0.17.7 [#107](https://github.com/trento-project/web/pull/107) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.18 to 3.0.19 in /assets [#106](https://github.com/trento-project/web/pull/106) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add hammering Stefano and add a margin to host health [#105](https://github.com/trento-project/web/pull/105) ([dottorblaster](https://github.com/dottorblaster))
- Add a new clusters count [#104](https://github.com/trento-project/web/pull/104) ([dottorblaster](https://github.com/dottorblaster))
- Implement hamburger menu for clusters table [#103](https://github.com/trento-project/web/pull/103) ([dottorblaster](https://github.com/dottorblaster))
- Bump gettext from 0.19.0 to 0.19.1 [#102](https://github.com/trento-project/web/pull/102) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix_live_dashboard from 0.6.3 to 0.6.4 [#100](https://github.com/trento-project/web/pull/100) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump swoosh from 1.6.1 to 1.6.2 [#99](https://github.com/trento-project/web/pull/99) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @reduxjs/toolkit from 1.7.1 to 1.7.2 in /assets [#98](https://github.com/trento-project/web/pull/98) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.5 to 8.4.6 in /assets [#97](https://github.com/trento-project/web/pull/97) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add checks execution [#96](https://github.com/trento-project/web/pull/96) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump phoenix_live_dashboard from 0.6.2 to 0.6.3 [#95](https://github.com/trento-project/web/pull/95) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump swoosh from 1.6.0 to 1.6.1 [#94](https://github.com/trento-project/web/pull/94) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.17 to 3.0.18 in /assets [#93](https://github.com/trento-project/web/pull/93) ([dependabot[bot]](https://github.com/apps/dependabot))
- Rename id variables [#92](https://github.com/trento-project/web/pull/92) ([fabriziosestito](https://github.com/fabriziosestito))
- Format the date in the live feed and make the whole thing smaller [#91](https://github.com/trento-project/web/pull/91) ([dottorblaster](https://github.com/dottorblaster))
- Bump nanoid from 3.1.30 to 3.2.0 in /assets [#90](https://github.com/trento-project/web/pull/90) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.16 to 3.0.17 in /assets [#89](https://github.com/trento-project/web/pull/89) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postgrex from 0.16.0 to 0.16.1 [#88](https://github.com/trento-project/web/pull/88) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.15 to 3.0.16 in /assets [#87](https://github.com/trento-project/web/pull/87) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump ecto_sql from 3.7.1 to 3.7.2 [#86](https://github.com/trento-project/web/pull/86) ([dependabot[bot]](https://github.com/apps/dependabot))
- Pin Elixir version to 1.13 minor, without patches [#85](https://github.com/trento-project/web/pull/85) ([dottorblaster](https://github.com/dottorblaster))
- Add HostDetailsUpdated host_projector tests [#84](https://github.com/trento-project/web/pull/84) ([rtorrero](https://github.com/rtorrero))
- Add cluster view [#83](https://github.com/trento-project/web/pull/83) ([fabriziosestito](https://github.com/fabriziosestito))
- Add EventStore dashboard [#82](https://github.com/trento-project/web/pull/82) ([fabriziosestito](https://github.com/fabriziosestito))
- Add a live feed implementation for host registration [#81](https://github.com/trento-project/web/pull/81) ([dottorblaster](https://github.com/dottorblaster))
- Bump axios from 0.24.0 to 0.25.0 in /assets [#79](https://github.com/trento-project/web/pull/79) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump credo from 1.6.1 to 1.6.2 [#78](https://github.com/trento-project/web/pull/78) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump swoosh from 1.5.2 to 1.6.0 [#77](https://github.com/trento-project/web/pull/77) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.13 to 3.0.15 in /assets [#76](https://github.com/trento-project/web/pull/76) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump @headlessui/react from 1.4.2 to 1.4.3 in /assets [#75](https://github.com/trento-project/web/pull/75) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add cluster discovery [#74](https://github.com/trento-project/web/pull/74) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump tailwindcss from 3.0.12 to 3.0.13 in /assets [#73](https://github.com/trento-project/web/pull/73) ([dependabot[bot]](https://github.com/apps/dependabot))
- Emit host details updated event [#72](https://github.com/trento-project/web/pull/72) ([fabriziosestito](https://github.com/fabriziosestito))
- Fix host heartbeat status stuck to unknown if heartbeat arrives prior registration [#71](https://github.com/trento-project/web/pull/71) ([fabriziosestito](https://github.com/fabriziosestito))
- Add Trento logo [#70](https://github.com/trento-project/web/pull/70) ([dottorblaster](https://github.com/dottorblaster))
- Add heartbeat domain events,  endpoint, and reactive frontend [#67](https://github.com/trento-project/web/pull/67) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump autoprefixer from 10.4.1 to 10.4.2 in /assets [#66](https://github.com/trento-project/web/pull/66) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.11 to 3.0.12 in /assets [#65](https://github.com/trento-project/web/pull/65) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-hot-toast from 2.1.1 to 2.2.0 in /assets [#64](https://github.com/trento-project/web/pull/64) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump elixir version to 1.13.1 [#62](https://github.com/trento-project/web/pull/62) ([fabriziosestito](https://github.com/fabriziosestito))
- Rename purge in content [#61](https://github.com/trento-project/web/pull/61) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump tailwindcss from 3.0.10 to 3.0.11 in /assets [#59](https://github.com/trento-project/web/pull/59) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix from 1.6.5 to 1.6.6 [#51](https://github.com/trento-project/web/pull/51) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.9 to 3.0.10 in /assets [#50](https://github.com/trento-project/web/pull/50) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 3.0.8 to 3.0.9 in /assets [#44](https://github.com/trento-project/web/pull/44) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump domo from 1.5.1 to 1.5.2 [#43](https://github.com/trento-project/web/pull/43) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add RegisterHost command test [#42](https://github.com/trento-project/web/pull/42) ([fabriziosestito](https://github.com/fabriziosestito))
- Add validate middleware tests [#41](https://github.com/trento-project/web/pull/41) ([fabriziosestito](https://github.com/fabriziosestito))
- Switch to credo strict [#39](https://github.com/trento-project/web/pull/39) ([fabriziosestito](https://github.com/fabriziosestito))
- Add commands validation [#38](https://github.com/trento-project/web/pull/38) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump autoprefixer from 10.4.0 to 10.4.1 in /assets [#36](https://github.com/trento-project/web/pull/36) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add collector endpoint, host discovery integration event handler and monitoring context [#34](https://github.com/trento-project/web/pull/34) ([fabriziosestito](https://github.com/fabriziosestito))
- Bump tailwindcss from 3.0.7 to 3.0.8 in /assets [#33](https://github.com/trento-project/web/pull/33) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump phoenix from 1.6.2 to 1.6.5 [#31](https://github.com/trento-project/web/pull/31) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump gettext from 0.18.2 to 0.19.0 [#30](https://github.com/trento-project/web/pull/30) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump postcss from 8.4.4 to 8.4.5 in /assets [#27](https://github.com/trento-project/web/pull/27) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump tailwindcss from 2.2.19 to 3.0.7 in /assets [#26](https://github.com/trento-project/web/pull/26) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump react-router-dom from 6.0.2 to 6.2.1 in /assets [#25](https://github.com/trento-project/web/pull/25) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump styfle/cancel-workflow-action from 0.6.0 to 0.9.1 [#24](https://github.com/trento-project/web/pull/24) ([dependabot[bot]](https://github.com/apps/dependabot))
- Bump mhanberg/gigalixir-action from 0.6.1 to 0.6.2 [#23](https://github.com/trento-project/web/pull/23) ([dependabot[bot]](https://github.com/apps/dependabot))
- Add persistent session [#22](https://github.com/trento-project/web/pull/22) ([fabriziosestito](https://github.com/fabriziosestito))
- Add Host aggregate and Host registration command/event [#21](https://github.com/trento-project/web/pull/21) ([fabriziosestito](https://github.com/fabriziosestito))
- Make the sidebar behave like a real one, plus JS refactor [#20](https://github.com/trento-project/web/pull/20) ([dottorblaster](https://github.com/dottorblaster))
- Adds a mix start task to setup the local environment [#19](https://github.com/trento-project/web/pull/19) ([nelsonkopliku](https://github.com/nelsonkopliku))
- Heartbeat part I [#18](https://github.com/trento-project/web/pull/18) ([fabriziosestito](https://github.com/fabriziosestito))
- Add routes and links to them [#17](https://github.com/trento-project/web/pull/17) ([dottorblaster](https://github.com/dottorblaster))
- Add login page [#15](https://github.com/trento-project/web/pull/15) ([fabriziosestito](https://github.com/fabriziosestito))
- Add branding colors [#14](https://github.com/trento-project/web/pull/14) ([fabriziosestito](https://github.com/fabriziosestito))
- Cleanup layout, use EOS typography [#11](https://github.com/trento-project/web/pull/11) ([fabriziosestito](https://github.com/fabriziosestito))
- Remove JIT from tailwind, add layout, add react router home [#8](https://github.com/trento-project/web/pull/8) ([dottorblaster](https://github.com/dottorblaster))
- Single page app [#7](https://github.com/trento-project/web/pull/7) ([dottorblaster](https://github.com/dottorblaster))
- Add ci [#3](https://github.com/trento-project/web/pull/3) ([fabriziosestito](https://github.com/fabriziosestito))
- First setup [#2](https://github.com/trento-project/web/pull/2) ([fabriziosestito](https://github.com/fabriziosestito))

* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
