defmodule WandaWeb.HealthControllerTest do
  @moduledoc false

  use WandaWeb.ConnCase, async: true

  import OpenApiSpex.TestAssertions

  alias WandaWeb.Schemas.Unversioned.ApiSpec

  setup do
    %{api_spec: ApiSpec.spec()}
  end

  describe "Health" do
    test "report healthy state when database is up for /healthz endpoint", %{
      conn: conn,
      api_spec: api_spec
    } do
      response =
        conn
        |> get("/api/healthz")
        |> json_response(200)

      assert_schema(response, "HealthV1", api_spec)
    end

    test "report healthy state for /readyz endpoint", %{
      conn: conn,
      api_spec: api_spec
    } do
      response =
        conn
        |> get("/api/readyz")
        |> json_response(200)

      assert_schema(response, "ReadyV1", api_spec)
    end
  end
end
