Migrating to version 4.0.0
==========================

Since version `4.0.0` we have introduced a couple of non-backwards compatible changes. This guide 
helps you migrate from previous versions (< `4.0.0`).

# Migration steps

## Upgrade Elixir and OTP

* Ensure you are using at least `Elixir 1.11`
* Ensure you are using at least `OTP 22.1`

## Stop using removed config options

* `uri` - replaced with `connection`
* `queue_ttl` - replaced with `queue_options.arguments`
* `queue_max_priority` - replaced with `queue_options.arguments`

Check [our guide](../guides/consumer/with_custom_queue_configuration.md) for detailed examples.

## Stop using removed `state` attribute from [GenRMQ.Message](../../lib/message.ex)` struct

* `state` attribute has been removed from `GenRMQ.Message` struct
* `channel` attribute has been added to `GenRMQ.Message` struct

So, if your application has been dependant on input channel from `state.in`, now
you can get it from `channel` property.
