/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.writers;

import com.sun.xml.stream.xerces.util.XMLChar;
import java.io.IOException;
import java.io.Writer;

public class WriterUtility {
    public static final String START_COMMENT = "<!--";
    public static final String END_COMMENT = "-->";
    public static final String DEFAULT_ENCODING = " encoding=\"utf-8\"";
    public static final String DEFAULT_XMLDECL = "<?xml version=\"1.0\" ?>";
    public static final String DEFAULT_XML_VERSION = "1.0";
    public static final char CLOSE_START_TAG = '>';
    public static final char OPEN_START_TAG = '<';
    public static final String OPEN_END_TAG = "</";
    public static final char CLOSE_END_TAG = '>';
    public static final String START_CDATA = "<![CDATA[";
    public static final String END_CDATA = "]]>";
    public static final String CLOSE_EMPTY_ELEMENT = "/>";
    public static final String SPACE = " ";
    public static final String UTF_8 = "utf-8";
    boolean fEscapeCharacters = true;
    Writer fWriter = null;

    public WriterUtility() {
    }

    public boolean getEscapeCharacters() {
        return this.fEscapeCharacters;
    }

    public int getSupplementalChar(int n, int n2) throws IOException {
        if (XMLChar.isHighSurrogate(n)) {
            if (!XMLChar.isLowSurrogate(n2)) {
                System.err.println("The character '" + (char)n2 + "' is an invalid XML character");
                throw new IOException("The character '" + (char)n2 + "' is an invalid XML character");
            }
            return XMLChar.supplemental((char)n, (char)n2);
        }
        System.err.println("The character '" + (char)n + "' is an invalid XML character");
        throw new IOException("The character '" + (char)n2 + "' is an invalid XML character");
    }

    public void setEscapeCharacters(boolean bl) {
        this.fEscapeCharacters = bl;
    }

    public void writeXMLContent(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            char c = cArray[n4];
            if (!XMLChar.isValid(c)) {
                if (++n4 < n2) {
                    int n5 = this.getSupplementalChar(c, cArray[n4]);
                    this.fWriter.write("&#x");
                    this.fWriter.write(Integer.toHexString(n5));
                    this.fWriter.write(59);
                } else {
                    System.err.println("The character '" + c + "' is an invalid XML character");
                }
            } else {
                switch (c) {
                    case '<': {
                        if (this.fEscapeCharacters) {
                            this.fWriter.write("&lt;");
                            break;
                        }
                        this.fWriter.write(c);
                        break;
                    }
                    case '&': {
                        if (this.fEscapeCharacters) {
                            this.fWriter.write("&amp;");
                            break;
                        }
                        this.fWriter.write(c);
                        break;
                    }
                    case '>': {
                        if (this.fEscapeCharacters) {
                            this.fWriter.write("&gt;");
                            break;
                        }
                        this.fWriter.write(c);
                        break;
                    }
                    default: {
                        this.fWriter.write(c);
                    }
                }
            }
            ++n4;
        }
    }

    public WriterUtility(Writer writer) {
        this.fWriter = writer;
    }

    public void setWriter(Writer writer) {
        this.fWriter = writer;
    }

    public void writeXMLAttributeValue(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!XMLChar.isValid(c)) {
                if (++n2 < n) {
                    int n3 = this.getSupplementalChar(c, string.charAt(n2));
                    this.fWriter.write("&#x");
                    this.fWriter.write(Integer.toHexString(n3));
                    this.fWriter.write(59);
                } else {
                    System.out.println("The character '" + (char)c + "' is an invalid XML character");
                }
            } else {
                switch (c) {
                    case '<': {
                        this.fWriter.write("&lt;");
                        break;
                    }
                    case '&': {
                        this.fWriter.write("&amp;");
                        break;
                    }
                    case '>': {
                        this.fWriter.write("&gt;");
                        break;
                    }
                    case '\"': {
                        this.fWriter.write("&quot;");
                        break;
                    }
                    default: {
                        this.fWriter.write(c);
                    }
                }
            }
            ++n2;
        }
    }

    public void writeXMLContent(String string) throws IOException {
        if (string == null || string.length() == 0) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!XMLChar.isValid(c)) {
                if (++n2 < n) {
                    int n3 = this.getSupplementalChar(c, string.charAt(n2));
                    this.fWriter.write("&#x");
                    this.fWriter.write(Integer.toHexString(n3));
                    this.fWriter.write(59);
                } else {
                    System.err.println("The character '" + c + "' is an invalid XML character");
                }
            } else {
                switch (c) {
                    case '<': {
                        if (this.fEscapeCharacters) {
                            this.fWriter.write("&lt;");
                            break;
                        }
                        this.fWriter.write(c);
                        break;
                    }
                    case '&': {
                        if (this.fEscapeCharacters) {
                            this.fWriter.write("&amp;");
                            break;
                        }
                        this.fWriter.write(c);
                        break;
                    }
                    case '>': {
                        if (this.fEscapeCharacters) {
                            this.fWriter.write("&gt;");
                            break;
                        }
                        this.fWriter.write(c);
                        break;
                    }
                    default: {
                        this.fWriter.write(c);
                    }
                }
            }
            ++n2;
        }
    }
}

