.\"
.\" man page klogconsole for SuSE Linux
.\"
.\" Author: Werner Fink <werner@suse.de>
.\"
.TH Bla 8 "August 20, 2001" "1996/07/20" "Kernel tools"
.\"
.UC 8
.SH NAME
.\"
klogconsole \- Tells the kernel to what terminal it should copy messages
.SH SYNOPSIS
.\"
.B klogconsole
.RB [ \-l
.IR <console_loglevel> ]
.RB [ \-r
.IR <virtual_console> ]
.\"
.SH DESCRIPTION
The program
.I klogconsole
tells the kernel to what terminal and starting from what level
it should copy
.B printk(9)
messages.
.PP
.\"
.SS General Options
.TP
.BI \-l\  <console_loglevel>
This option sets the console log level.
.TP
.BI \-r\  <virtual_console>
This option sets the virtual console which
is used by the kernel for its messages,
.IP
.\"
.SH EXAMPLE
.PP
klogconsole -r10
.\"
.SH FILES
.TP
.I /proc/kmsg
.TP
.I /proc/sys/kernel/printk
.\"
.SH SEE ALSO
.BR printk (9),
.BR klogd (8).
.\"
.SH AUTHOR
.B klogconsole
was written by Hans Lermen <lermen@elserv.ffm.fgan.de> in 1996 and
published under GPL.  Parts of the routine switch_printk_console()
was taken from Kevin Buhr <buhr@stat.wisc.edu>.
