// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// FloatHistogram FloatHistogram is similar to Histogram but uses float64 for all
// counts. Additionally, bucket counts are absolute and not deltas.
//
// A FloatHistogram is needed by PromQL to handle operations that might result
// in fractional counts. Since the counts in a histogram are unlikely to be too
// large to be represented precisely by a float64, a FloatHistogram can also be
// used to represent a histogram with integer counts and thus serves as a more
// generalized representation.
//
// swagger:model FloatHistogram
type FloatHistogram struct {

	// Total number of observations. Must be zero or positive.
	Count float64 `json:"Count,omitempty"`

	// counter reset hint
	CounterResetHint CounterResetHint `json:"CounterResetHint,omitempty"`

	// Observation counts in buckets. Each represents an absolute count and
	// must be zero or positive.
	PositiveBuckets []float64 `json:"PositiveBuckets"`

	// Spans for positive and negative buckets (see Span below).
	PositiveSpans []*Span `json:"PositiveSpans"`

	// Currently valid schema numbers are -4 <= n <= 8.  They are all for
	// base-2 bucket schemas, where 1 is a bucket boundary in each case, and
	// then each power of two is divided into 2^n logarithmic buckets.  Or
	// in other words, each bucket boundary is the previous boundary times
	// 2^(2^-n).
	Schema int32 `json:"Schema,omitempty"`

	// Sum of observations. This is also used as the stale marker.
	Sum float64 `json:"Sum,omitempty"`

	// Observations falling into the zero bucket. Must be zero or positive.
	ZeroCount float64 `json:"ZeroCount,omitempty"`

	// Width of the zero bucket.
	ZeroThreshold float64 `json:"ZeroThreshold,omitempty"`
}

// Validate validates this float histogram
func (m *FloatHistogram) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCounterResetHint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePositiveSpans(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FloatHistogram) validateCounterResetHint(formats strfmt.Registry) error {
	if swag.IsZero(m.CounterResetHint) { // not required
		return nil
	}

	if err := m.CounterResetHint.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("CounterResetHint")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("CounterResetHint")
		}
		return err
	}

	return nil
}

func (m *FloatHistogram) validatePositiveSpans(formats strfmt.Registry) error {
	if swag.IsZero(m.PositiveSpans) { // not required
		return nil
	}

	for i := 0; i < len(m.PositiveSpans); i++ {
		if swag.IsZero(m.PositiveSpans[i]) { // not required
			continue
		}

		if m.PositiveSpans[i] != nil {
			if err := m.PositiveSpans[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("PositiveSpans" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("PositiveSpans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this float histogram based on the context it is used
func (m *FloatHistogram) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCounterResetHint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePositiveSpans(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *FloatHistogram) contextValidateCounterResetHint(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.CounterResetHint) { // not required
		return nil
	}

	if err := m.CounterResetHint.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("CounterResetHint")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("CounterResetHint")
		}
		return err
	}

	return nil
}

func (m *FloatHistogram) contextValidatePositiveSpans(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PositiveSpans); i++ {

		if m.PositiveSpans[i] != nil {

			if swag.IsZero(m.PositiveSpans[i]) { // not required
				return nil
			}

			if err := m.PositiveSpans[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("PositiveSpans" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("PositiveSpans" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *FloatHistogram) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *FloatHistogram) UnmarshalBinary(b []byte) error {
	var res FloatHistogram
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
