// Package domain provides primitives to interact with the openapi HTTP API.
//
// Code generated by  version  DO NOT EDIT.
package domain

import (
	"encoding/json"
	"fmt"
	"time"
)

const (
	BasicAuthenticationScopes = "BasicAuthentication.Scopes"
	TokenAuthenticationScopes = "TokenAuthentication.Scopes"
)

// Defines values for AuthorizationUpdateRequestStatus.
const (
	AuthorizationUpdateRequestStatusActive AuthorizationUpdateRequestStatus = "active"

	AuthorizationUpdateRequestStatusInactive AuthorizationUpdateRequestStatus = "inactive"
)

// Defines values for AxisBase.
const (
	AxisBaseEmpty AxisBase = ""

	AxisBaseN10 AxisBase = "10"

	AxisBaseN2 AxisBase = "2"
)

// Defines values for AxisScale.
const (
	AxisScaleLinear AxisScale = "linear"

	AxisScaleLog AxisScale = "log"
)

// Defines values for BandViewPropertiesHoverDimension.
const (
	BandViewPropertiesHoverDimensionAuto BandViewPropertiesHoverDimension = "auto"

	BandViewPropertiesHoverDimensionX BandViewPropertiesHoverDimension = "x"

	BandViewPropertiesHoverDimensionXy BandViewPropertiesHoverDimension = "xy"

	BandViewPropertiesHoverDimensionY BandViewPropertiesHoverDimension = "y"
)

// Defines values for BandViewPropertiesShape.
const (
	BandViewPropertiesShapeChronografV2 BandViewPropertiesShape = "chronograf-v2"
)

// Defines values for BandViewPropertiesType.
const (
	BandViewPropertiesTypeBand BandViewPropertiesType = "band"
)

// Defines values for BucketType.
const (
	BucketTypeSystem BucketType = "system"

	BucketTypeUser BucketType = "user"
)

// Defines values for BuilderAggregateFunctionType.
const (
	BuilderAggregateFunctionTypeFilter BuilderAggregateFunctionType = "filter"

	BuilderAggregateFunctionTypeGroup BuilderAggregateFunctionType = "group"
)

// Defines values for CheckBaseLastRunStatus.
const (
	CheckBaseLastRunStatusCanceled CheckBaseLastRunStatus = "canceled"

	CheckBaseLastRunStatusFailed CheckBaseLastRunStatus = "failed"

	CheckBaseLastRunStatusSuccess CheckBaseLastRunStatus = "success"
)

// Defines values for CheckPatchStatus.
const (
	CheckPatchStatusActive CheckPatchStatus = "active"

	CheckPatchStatusInactive CheckPatchStatus = "inactive"
)

// Defines values for CheckStatusLevel.
const (
	CheckStatusLevelCRIT CheckStatusLevel = "CRIT"

	CheckStatusLevelINFO CheckStatusLevel = "INFO"

	CheckStatusLevelOK CheckStatusLevel = "OK"

	CheckStatusLevelUNKNOWN CheckStatusLevel = "UNKNOWN"

	CheckStatusLevelWARN CheckStatusLevel = "WARN"
)

// Defines values for CheckViewPropertiesShape.
const (
	CheckViewPropertiesShapeChronografV2 CheckViewPropertiesShape = "chronograf-v2"
)

// Defines values for CheckViewPropertiesType.
const (
	CheckViewPropertiesTypeCheck CheckViewPropertiesType = "check"
)

// Defines values for ConstantVariablePropertiesType.
const (
	ConstantVariablePropertiesTypeConstant ConstantVariablePropertiesType = "constant"
)

// Defines values for CustomCheckType.
const (
	CustomCheckTypeCustom CustomCheckType = "custom"
)

// Defines values for DashboardColorType.
const (
	DashboardColorTypeBackground DashboardColorType = "background"

	DashboardColorTypeMax DashboardColorType = "max"

	DashboardColorTypeMin DashboardColorType = "min"

	DashboardColorTypeScale DashboardColorType = "scale"

	DashboardColorTypeText DashboardColorType = "text"

	DashboardColorTypeThreshold DashboardColorType = "threshold"
)

// Defines values for DeadmanCheckType.
const (
	DeadmanCheckTypeDeadman DeadmanCheckType = "deadman"
)

// Defines values for DialectAnnotations.
const (
	DialectAnnotationsDatatype DialectAnnotations = "datatype"

	DialectAnnotationsDefault DialectAnnotations = "default"

	DialectAnnotationsGroup DialectAnnotations = "group"
)

// Defines values for DialectDateTimeFormat.
const (
	DialectDateTimeFormatRFC3339 DialectDateTimeFormat = "RFC3339"

	DialectDateTimeFormatRFC3339Nano DialectDateTimeFormat = "RFC3339Nano"
)

// Defines values for ErrorCode.
const (
	ErrorCodeConflict ErrorCode = "conflict"

	ErrorCodeEmptyValue ErrorCode = "empty value"

	ErrorCodeForbidden ErrorCode = "forbidden"

	ErrorCodeInternalError ErrorCode = "internal error"

	ErrorCodeInvalid ErrorCode = "invalid"

	ErrorCodeMethodNotAllowed ErrorCode = "method not allowed"

	ErrorCodeNotFound ErrorCode = "not found"

	ErrorCodeRequestTooLarge ErrorCode = "request too large"

	ErrorCodeTooManyRequests ErrorCode = "too many requests"

	ErrorCodeUnauthorized ErrorCode = "unauthorized"

	ErrorCodeUnavailable ErrorCode = "unavailable"

	ErrorCodeUnprocessableEntity ErrorCode = "unprocessable entity"

	ErrorCodeUnsupportedMediaType ErrorCode = "unsupported media type"
)

// Defines values for FieldType.
const (
	FieldTypeField FieldType = "field"

	FieldTypeFunc FieldType = "func"

	FieldTypeInteger FieldType = "integer"

	FieldTypeNumber FieldType = "number"

	FieldTypeRegex FieldType = "regex"

	FieldTypeWildcard FieldType = "wildcard"
)

// Defines values for GaugeViewPropertiesShape.
const (
	GaugeViewPropertiesShapeChronografV2 GaugeViewPropertiesShape = "chronograf-v2"
)

// Defines values for GaugeViewPropertiesType.
const (
	GaugeViewPropertiesTypeGauge GaugeViewPropertiesType = "gauge"
)

// Defines values for GeoViewLayerPropertiesType.
const (
	GeoViewLayerPropertiesTypeCircleMap GeoViewLayerPropertiesType = "circleMap"

	GeoViewLayerPropertiesTypeHeatmap GeoViewLayerPropertiesType = "heatmap"

	GeoViewLayerPropertiesTypePointMap GeoViewLayerPropertiesType = "pointMap"

	GeoViewLayerPropertiesTypeTrackMap GeoViewLayerPropertiesType = "trackMap"
)

// Defines values for GeoViewPropertiesShape.
const (
	GeoViewPropertiesShapeChronografV2 GeoViewPropertiesShape = "chronograf-v2"
)

// Defines values for GeoViewPropertiesType.
const (
	GeoViewPropertiesTypeGeo GeoViewPropertiesType = "geo"
)

// Defines values for GreaterThresholdType.
const (
	GreaterThresholdTypeGreater GreaterThresholdType = "greater"
)

// Defines values for HTTPNotificationEndpointAuthMethod.
const (
	HTTPNotificationEndpointAuthMethodBasic HTTPNotificationEndpointAuthMethod = "basic"

	HTTPNotificationEndpointAuthMethodBearer HTTPNotificationEndpointAuthMethod = "bearer"

	HTTPNotificationEndpointAuthMethodNone HTTPNotificationEndpointAuthMethod = "none"
)

// Defines values for HTTPNotificationEndpointMethod.
const (
	HTTPNotificationEndpointMethodGET HTTPNotificationEndpointMethod = "GET"

	HTTPNotificationEndpointMethodPOST HTTPNotificationEndpointMethod = "POST"

	HTTPNotificationEndpointMethodPUT HTTPNotificationEndpointMethod = "PUT"
)

// Defines values for HTTPNotificationRuleBaseType.
const (
	HTTPNotificationRuleBaseTypeHttp HTTPNotificationRuleBaseType = "http"
)

// Defines values for HealthCheckStatus.
const (
	HealthCheckStatusFail HealthCheckStatus = "fail"

	HealthCheckStatusPass HealthCheckStatus = "pass"
)

// Defines values for HeatmapViewPropertiesShape.
const (
	HeatmapViewPropertiesShapeChronografV2 HeatmapViewPropertiesShape = "chronograf-v2"
)

// Defines values for HeatmapViewPropertiesType.
const (
	HeatmapViewPropertiesTypeHeatmap HeatmapViewPropertiesType = "heatmap"
)

// Defines values for HistogramViewPropertiesPosition.
const (
	HistogramViewPropertiesPositionOverlaid HistogramViewPropertiesPosition = "overlaid"

	HistogramViewPropertiesPositionStacked HistogramViewPropertiesPosition = "stacked"
)

// Defines values for HistogramViewPropertiesShape.
const (
	HistogramViewPropertiesShapeChronografV2 HistogramViewPropertiesShape = "chronograf-v2"
)

// Defines values for HistogramViewPropertiesType.
const (
	HistogramViewPropertiesTypeHistogram HistogramViewPropertiesType = "histogram"
)

// Defines values for LesserThresholdType.
const (
	LesserThresholdTypeLesser LesserThresholdType = "lesser"
)

// Defines values for LinePlusSingleStatPropertiesHoverDimension.
const (
	LinePlusSingleStatPropertiesHoverDimensionAuto LinePlusSingleStatPropertiesHoverDimension = "auto"

	LinePlusSingleStatPropertiesHoverDimensionX LinePlusSingleStatPropertiesHoverDimension = "x"

	LinePlusSingleStatPropertiesHoverDimensionXy LinePlusSingleStatPropertiesHoverDimension = "xy"

	LinePlusSingleStatPropertiesHoverDimensionY LinePlusSingleStatPropertiesHoverDimension = "y"
)

// Defines values for LinePlusSingleStatPropertiesPosition.
const (
	LinePlusSingleStatPropertiesPositionOverlaid LinePlusSingleStatPropertiesPosition = "overlaid"

	LinePlusSingleStatPropertiesPositionStacked LinePlusSingleStatPropertiesPosition = "stacked"
)

// Defines values for LinePlusSingleStatPropertiesShape.
const (
	LinePlusSingleStatPropertiesShapeChronografV2 LinePlusSingleStatPropertiesShape = "chronograf-v2"
)

// Defines values for LinePlusSingleStatPropertiesType.
const (
	LinePlusSingleStatPropertiesTypeLinePlusSingleStat LinePlusSingleStatPropertiesType = "line-plus-single-stat"
)

// Defines values for LineProtocolErrorCode.
const (
	LineProtocolErrorCodeConflict LineProtocolErrorCode = "conflict"

	LineProtocolErrorCodeEmptyValue LineProtocolErrorCode = "empty value"

	LineProtocolErrorCodeInternalError LineProtocolErrorCode = "internal error"

	LineProtocolErrorCodeInvalid LineProtocolErrorCode = "invalid"

	LineProtocolErrorCodeNotFound LineProtocolErrorCode = "not found"

	LineProtocolErrorCodeUnavailable LineProtocolErrorCode = "unavailable"
)

// Defines values for LineProtocolLengthErrorCode.
const (
	LineProtocolLengthErrorCodeInvalid LineProtocolLengthErrorCode = "invalid"
)

// Defines values for MapVariablePropertiesType.
const (
	MapVariablePropertiesTypeMap MapVariablePropertiesType = "map"
)

// Defines values for MarkdownViewPropertiesShape.
const (
	MarkdownViewPropertiesShapeChronografV2 MarkdownViewPropertiesShape = "chronograf-v2"
)

// Defines values for MarkdownViewPropertiesType.
const (
	MarkdownViewPropertiesTypeMarkdown MarkdownViewPropertiesType = "markdown"
)

// Defines values for MosaicViewPropertiesHoverDimension.
const (
	MosaicViewPropertiesHoverDimensionAuto MosaicViewPropertiesHoverDimension = "auto"

	MosaicViewPropertiesHoverDimensionX MosaicViewPropertiesHoverDimension = "x"

	MosaicViewPropertiesHoverDimensionXy MosaicViewPropertiesHoverDimension = "xy"

	MosaicViewPropertiesHoverDimensionY MosaicViewPropertiesHoverDimension = "y"
)

// Defines values for MosaicViewPropertiesShape.
const (
	MosaicViewPropertiesShapeChronografV2 MosaicViewPropertiesShape = "chronograf-v2"
)

// Defines values for MosaicViewPropertiesType.
const (
	MosaicViewPropertiesTypeMosaic MosaicViewPropertiesType = "mosaic"
)

// Defines values for NotificationEndpointBaseStatus.
const (
	NotificationEndpointBaseStatusActive NotificationEndpointBaseStatus = "active"

	NotificationEndpointBaseStatusInactive NotificationEndpointBaseStatus = "inactive"
)

// Defines values for NotificationEndpointType.
const (
	NotificationEndpointTypeHttp NotificationEndpointType = "http"

	NotificationEndpointTypePagerduty NotificationEndpointType = "pagerduty"

	NotificationEndpointTypeSlack NotificationEndpointType = "slack"

	NotificationEndpointTypeTelegram NotificationEndpointType = "telegram"
)

// Defines values for NotificationEndpointUpdateStatus.
const (
	NotificationEndpointUpdateStatusActive NotificationEndpointUpdateStatus = "active"

	NotificationEndpointUpdateStatusInactive NotificationEndpointUpdateStatus = "inactive"
)

// Defines values for NotificationRuleBaseLastRunStatus.
const (
	NotificationRuleBaseLastRunStatusCanceled NotificationRuleBaseLastRunStatus = "canceled"

	NotificationRuleBaseLastRunStatusFailed NotificationRuleBaseLastRunStatus = "failed"

	NotificationRuleBaseLastRunStatusSuccess NotificationRuleBaseLastRunStatus = "success"
)

// Defines values for NotificationRuleUpdateStatus.
const (
	NotificationRuleUpdateStatusActive NotificationRuleUpdateStatus = "active"

	NotificationRuleUpdateStatusInactive NotificationRuleUpdateStatus = "inactive"
)

// Defines values for OrganizationStatus.
const (
	OrganizationStatusActive OrganizationStatus = "active"

	OrganizationStatusInactive OrganizationStatus = "inactive"
)

// Defines values for PagerDutyNotificationRuleBaseType.
const (
	PagerDutyNotificationRuleBaseTypePagerduty PagerDutyNotificationRuleBaseType = "pagerduty"
)

// Defines values for PatchRetentionRuleType.
const (
	PatchRetentionRuleTypeExpire PatchRetentionRuleType = "expire"
)

// Defines values for PermissionAction.
const (
	PermissionActionRead PermissionAction = "read"

	PermissionActionWrite PermissionAction = "write"
)

// Defines values for QueryType.
const (
	QueryTypeFlux QueryType = "flux"
)

// Defines values for QueryEditMode.
const (
	QueryEditModeAdvanced QueryEditMode = "advanced"

	QueryEditModeBuilder QueryEditMode = "builder"
)

// Defines values for QueryVariablePropertiesType.
const (
	QueryVariablePropertiesTypeQuery QueryVariablePropertiesType = "query"
)

// Defines values for RangeThresholdType.
const (
	RangeThresholdTypeRange RangeThresholdType = "range"
)

// Defines values for ReadyStatus.
const (
	ReadyStatusReady ReadyStatus = "ready"
)

// Defines values for ResourceType.
const (
	ResourceTypeAnnotations ResourceType = "annotations"

	ResourceTypeAuthorizations ResourceType = "authorizations"

	ResourceTypeBuckets ResourceType = "buckets"

	ResourceTypeChecks ResourceType = "checks"

	ResourceTypeDashboards ResourceType = "dashboards"

	ResourceTypeDbrp ResourceType = "dbrp"

	ResourceTypeDocuments ResourceType = "documents"

	ResourceTypeInstance ResourceType = "instance"

	ResourceTypeLabels ResourceType = "labels"

	ResourceTypeNotebooks ResourceType = "notebooks"

	ResourceTypeNotificationEndpoints ResourceType = "notificationEndpoints"

	ResourceTypeNotificationRules ResourceType = "notificationRules"

	ResourceTypeOrgs ResourceType = "orgs"

	ResourceTypeRemotes ResourceType = "remotes"

	ResourceTypeReplications ResourceType = "replications"

	ResourceTypeScrapers ResourceType = "scrapers"

	ResourceTypeSecrets ResourceType = "secrets"

	ResourceTypeSources ResourceType = "sources"

	ResourceTypeTasks ResourceType = "tasks"

	ResourceTypeTelegrafs ResourceType = "telegrafs"

	ResourceTypeUsers ResourceType = "users"

	ResourceTypeVariables ResourceType = "variables"

	ResourceTypeViews ResourceType = "views"
)

// Defines values for ResourceMemberRole.
const (
	ResourceMemberRoleMember ResourceMemberRole = "member"
)

// Defines values for ResourceOwnerRole.
const (
	ResourceOwnerRoleOwner ResourceOwnerRole = "owner"
)

// Defines values for RetentionRuleType.
const (
	RetentionRuleTypeExpire RetentionRuleType = "expire"
)

// Defines values for RuleStatusLevel.
const (
	RuleStatusLevelANY RuleStatusLevel = "ANY"

	RuleStatusLevelCRIT RuleStatusLevel = "CRIT"

	RuleStatusLevelINFO RuleStatusLevel = "INFO"

	RuleStatusLevelOK RuleStatusLevel = "OK"

	RuleStatusLevelUNKNOWN RuleStatusLevel = "UNKNOWN"

	RuleStatusLevelWARN RuleStatusLevel = "WARN"
)

// Defines values for RunStatus.
const (
	RunStatusCanceled RunStatus = "canceled"

	RunStatusFailed RunStatus = "failed"

	RunStatusScheduled RunStatus = "scheduled"

	RunStatusStarted RunStatus = "started"

	RunStatusSuccess RunStatus = "success"
)

// Defines values for SMTPNotificationRuleBaseType.
const (
	SMTPNotificationRuleBaseTypeSmtp SMTPNotificationRuleBaseType = "smtp"
)

// Defines values for ScatterViewPropertiesShape.
const (
	ScatterViewPropertiesShapeChronografV2 ScatterViewPropertiesShape = "chronograf-v2"
)

// Defines values for ScatterViewPropertiesType.
const (
	ScatterViewPropertiesTypeScatter ScatterViewPropertiesType = "scatter"
)

// Defines values for SchemaType.
const (
	SchemaTypeExplicit SchemaType = "explicit"

	SchemaTypeImplicit SchemaType = "implicit"
)

// Defines values for ScraperTargetRequestType.
const (
	ScraperTargetRequestTypePrometheus ScraperTargetRequestType = "prometheus"
)

// Defines values for SimpleTableViewPropertiesShape.
const (
	SimpleTableViewPropertiesShapeChronografV2 SimpleTableViewPropertiesShape = "chronograf-v2"
)

// Defines values for SimpleTableViewPropertiesType.
const (
	SimpleTableViewPropertiesTypeSimpleTable SimpleTableViewPropertiesType = "simple-table"
)

// Defines values for SingleStatViewPropertiesShape.
const (
	SingleStatViewPropertiesShapeChronografV2 SingleStatViewPropertiesShape = "chronograf-v2"
)

// Defines values for SingleStatViewPropertiesType.
const (
	SingleStatViewPropertiesTypeSingleStat SingleStatViewPropertiesType = "single-stat"
)

// Defines values for SlackNotificationRuleBaseType.
const (
	SlackNotificationRuleBaseTypeSlack SlackNotificationRuleBaseType = "slack"
)

// Defines values for SourceLanguages.
const (
	SourceLanguagesFlux SourceLanguages = "flux"

	SourceLanguagesInfluxql SourceLanguages = "influxql"
)

// Defines values for SourceType.
const (
	SourceTypeSelf SourceType = "self"

	SourceTypeV1 SourceType = "v1"

	SourceTypeV2 SourceType = "v2"
)

// Defines values for TableViewPropertiesShape.
const (
	TableViewPropertiesShapeChronografV2 TableViewPropertiesShape = "chronograf-v2"
)

// Defines values for TableViewPropertiesTableOptionsWrapping.
const (
	TableViewPropertiesTableOptionsWrappingSingleLine TableViewPropertiesTableOptionsWrapping = "single-line"

	TableViewPropertiesTableOptionsWrappingTruncate TableViewPropertiesTableOptionsWrapping = "truncate"

	TableViewPropertiesTableOptionsWrappingWrap TableViewPropertiesTableOptionsWrapping = "wrap"
)

// Defines values for TableViewPropertiesType.
const (
	TableViewPropertiesTypeTable TableViewPropertiesType = "table"
)

// Defines values for TagRuleOperator.
const (
	TagRuleOperatorEqual TagRuleOperator = "equal"

	TagRuleOperatorEqualregex TagRuleOperator = "equalregex"

	TagRuleOperatorNotequal TagRuleOperator = "notequal"

	TagRuleOperatorNotequalregex TagRuleOperator = "notequalregex"
)

// Defines values for TaskLastRunStatus.
const (
	TaskLastRunStatusCanceled TaskLastRunStatus = "canceled"

	TaskLastRunStatusFailed TaskLastRunStatus = "failed"

	TaskLastRunStatusSuccess TaskLastRunStatus = "success"
)

// Defines values for TaskStatusType.
const (
	TaskStatusTypeActive TaskStatusType = "active"

	TaskStatusTypeInactive TaskStatusType = "inactive"
)

// Defines values for TelegramNotificationRuleBaseParseMode.
const (
	TelegramNotificationRuleBaseParseModeHTML TelegramNotificationRuleBaseParseMode = "HTML"

	TelegramNotificationRuleBaseParseModeMarkdown TelegramNotificationRuleBaseParseMode = "Markdown"

	TelegramNotificationRuleBaseParseModeMarkdownV2 TelegramNotificationRuleBaseParseMode = "MarkdownV2"
)

// Defines values for TelegramNotificationRuleBaseType.
const (
	TelegramNotificationRuleBaseTypeTelegram TelegramNotificationRuleBaseType = "telegram"
)

// Defines values for TemplateKind.
const (
	TemplateKindBucket TemplateKind = "Bucket"

	TemplateKindCheck TemplateKind = "Check"

	TemplateKindCheckDeadman TemplateKind = "CheckDeadman"

	TemplateKindCheckThreshold TemplateKind = "CheckThreshold"

	TemplateKindDashboard TemplateKind = "Dashboard"

	TemplateKindLabel TemplateKind = "Label"

	TemplateKindNotificationEndpoint TemplateKind = "NotificationEndpoint"

	TemplateKindNotificationEndpointHTTP TemplateKind = "NotificationEndpointHTTP"

	TemplateKindNotificationEndpointPagerDuty TemplateKind = "NotificationEndpointPagerDuty"

	TemplateKindNotificationEndpointSlack TemplateKind = "NotificationEndpointSlack"

	TemplateKindNotificationRule TemplateKind = "NotificationRule"

	TemplateKindTask TemplateKind = "Task"

	TemplateKindTelegraf TemplateKind = "Telegraf"

	TemplateKindVariable TemplateKind = "Variable"
)

// Defines values for ThresholdCheckType.
const (
	ThresholdCheckTypeThreshold ThresholdCheckType = "threshold"
)

// Defines values for UserStatus.
const (
	UserStatusActive UserStatus = "active"

	UserStatusInactive UserStatus = "inactive"
)

// Defines values for UserResponseStatus.
const (
	UserResponseStatusActive UserResponseStatus = "active"

	UserResponseStatusInactive UserResponseStatus = "inactive"
)

// Defines values for WritePrecision.
const (
	WritePrecisionMs WritePrecision = "ms"

	WritePrecisionNs WritePrecision = "ns"

	WritePrecisionS WritePrecision = "s"

	WritePrecisionUs WritePrecision = "us"
)

// Defines values for XYGeom.
const (
	XYGeomBar XYGeom = "bar"

	XYGeomLine XYGeom = "line"

	XYGeomMonotoneX XYGeom = "monotoneX"

	XYGeomStacked XYGeom = "stacked"

	XYGeomStep XYGeom = "step"

	XYGeomStepAfter XYGeom = "stepAfter"

	XYGeomStepBefore XYGeom = "stepBefore"
)

// Defines values for XYViewPropertiesHoverDimension.
const (
	XYViewPropertiesHoverDimensionAuto XYViewPropertiesHoverDimension = "auto"

	XYViewPropertiesHoverDimensionX XYViewPropertiesHoverDimension = "x"

	XYViewPropertiesHoverDimensionXy XYViewPropertiesHoverDimension = "xy"

	XYViewPropertiesHoverDimensionY XYViewPropertiesHoverDimension = "y"
)

// Defines values for XYViewPropertiesPosition.
const (
	XYViewPropertiesPositionOverlaid XYViewPropertiesPosition = "overlaid"

	XYViewPropertiesPositionStacked XYViewPropertiesPosition = "stacked"
)

// Defines values for XYViewPropertiesShape.
const (
	XYViewPropertiesShapeChronografV2 XYViewPropertiesShape = "chronograf-v2"
)

// Defines values for XYViewPropertiesType.
const (
	XYViewPropertiesTypeXy XYViewPropertiesType = "xy"
)

// Defines values for AuthorizationErrorCode.
const (
	AuthorizationErrorCodeUnauthorized AuthorizationErrorCode = "unauthorized"
)

// Contains the AST for the supplied Flux query
type ASTResponse struct {
	// Represents a complete package source tree.
	Ast *Package `json:"ast,omitempty"`
}

// AddResourceMemberRequestBody defines model for AddResourceMemberRequestBody.
type AddResourceMemberRequestBody struct {
	// The ID of the user to add to the resource.
	Id string `json:"id"`

	// The name of the user to add to the resource.
	Name *string `json:"name,omitempty"`
}

// AnalyzeQueryResponse defines model for AnalyzeQueryResponse.
type AnalyzeQueryResponse struct {
	Errors *[]struct {
		Character *int    `json:"character,omitempty"`
		Column    *int    `json:"column,omitempty"`
		Line      *int    `json:"line,omitempty"`
		Message   *string `json:"message,omitempty"`
	} `json:"errors,omitempty"`
}

// Used to create and directly specify the elements of an array object
type ArrayExpression struct {
	// Elements of the array
	Elements *[]Expression `json:"elements,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Authorization defines model for Authorization.
type Authorization struct {
	// Embedded struct due to allOf(#/components/schemas/AuthorizationUpdateRequest)
	AuthorizationUpdateRequest `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	CreatedAt *time.Time `json:"createdAt,omitempty"`
	Id        *string    `json:"id,omitempty"`
	Links     *struct {
		// URI of resource.
		Self *Link `json:"self,omitempty"`

		// URI of resource.
		User *Link `json:"user,omitempty"`
	} `json:"links,omitempty"`

	// The name of the organization that the token is scoped to.
	Org *string `json:"org,omitempty"`

	// The ID of the organization.
	OrgID *string `json:"orgID,omitempty"`

	// A list of permissions for an authorization.
	// An authorization must have at least one permission.
	Permissions *[]Permission `json:"permissions,omitempty"`

	// The API token for authenticating InfluxDB API and CLI requests.
	Token     *string    `json:"token,omitempty"`
	UpdatedAt *time.Time `json:"updatedAt,omitempty"`

	// The name of the user that created and owns the token.
	User *string `json:"user,omitempty"`

	// The ID of the user that created and owns the token.
	UserID *string `json:"userID,omitempty"`
}

// AuthorizationPostRequest defines model for AuthorizationPostRequest.
type AuthorizationPostRequest struct {
	// Embedded struct due to allOf(#/components/schemas/AuthorizationUpdateRequest)
	AuthorizationUpdateRequest `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// The ID of the organization that owns the authorization.
	OrgID *string `json:"orgID,omitempty"`

	// A list of permissions for an authorization.
	// An authorization must have at least one permission.
	Permissions *[]Permission `json:"permissions,omitempty"`

	// The ID of the user that the authorization is scoped to.
	UserID *string `json:"userID,omitempty"`
}

// AuthorizationUpdateRequest defines model for AuthorizationUpdateRequest.
type AuthorizationUpdateRequest struct {
	// A description of the token.
	Description *string `json:"description,omitempty"`

	// Status of the token. If `inactive`, requests using the token will be rejected.
	Status *AuthorizationUpdateRequestStatus `json:"status,omitempty"`
}

// Status of the token. If `inactive`, requests using the token will be rejected.
type AuthorizationUpdateRequestStatus string

// Authorizations defines model for Authorizations.
type Authorizations struct {
	Authorizations *[]Authorization `json:"authorizations,omitempty"`

	// URI pointers for additional paged results.
	Links *Links `json:"links,omitempty"`
}

// The viewport for a View's visualizations
type Axes struct {
	// Axis used in a visualization.
	X Axis `json:"x"`

	// Axis used in a visualization.
	Y Axis `json:"y"`
}

// Axis used in a visualization.
type Axis struct {
	// Radix for formatting axis values.
	Base *AxisBase `json:"base,omitempty"`

	// The extents of the axis in the form [lower, upper]. Clients determine whether bounds are inclusive or exclusive of their limits.
	Bounds *[]string `json:"bounds,omitempty"`

	// Description of the axis.
	Label *string `json:"label,omitempty"`

	// Label prefix for formatting axis values.
	Prefix *string `json:"prefix,omitempty"`

	// Scale is the axis formatting scale. Supported: "log", "linear"
	Scale *AxisScale `json:"scale,omitempty"`

	// Label suffix for formatting axis values.
	Suffix *string `json:"suffix,omitempty"`
}

// Radix for formatting axis values.
type AxisBase string

// Scale is the axis formatting scale. Supported: "log", "linear"
type AxisScale string

// A placeholder for statements for which no correct statement nodes can be created
type BadStatement struct {
	// Raw source text
	Text *string `json:"text,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// BandViewProperties defines model for BandViewProperties.
type BandViewProperties struct {
	AdaptiveZoomHide *bool `json:"adaptiveZoomHide,omitempty"`

	// The viewport for a View's visualizations
	Axes Axes `json:"axes"`

	// Colors define color encoding of data into a visualization
	Colors                     []DashboardColor                  `json:"colors"`
	GenerateXAxisTicks         *[]string                         `json:"generateXAxisTicks,omitempty"`
	GenerateYAxisTicks         *[]string                         `json:"generateYAxisTicks,omitempty"`
	Geom                       XYGeom                            `json:"geom"`
	HoverDimension             *BandViewPropertiesHoverDimension `json:"hoverDimension,omitempty"`
	LegendColorizeRows         *bool                             `json:"legendColorizeRows,omitempty"`
	LegendHide                 *bool                             `json:"legendHide,omitempty"`
	LegendOpacity              *float32                          `json:"legendOpacity,omitempty"`
	LegendOrientationThreshold *int                              `json:"legendOrientationThreshold,omitempty"`
	LowerColumn                *string                           `json:"lowerColumn,omitempty"`
	MainColumn                 *string                           `json:"mainColumn,omitempty"`
	Note                       string                            `json:"note"`
	Queries                    []DashboardQuery                  `json:"queries"`
	Shape                      BandViewPropertiesShape           `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool `json:"showNoteWhenEmpty"`

	// StaticLegend represents the options specific to the static legend
	StaticLegend *StaticLegend          `json:"staticLegend,omitempty"`
	TimeFormat   *string                `json:"timeFormat,omitempty"`
	Type         BandViewPropertiesType `json:"type"`
	UpperColumn  *string                `json:"upperColumn,omitempty"`
	XColumn      *string                `json:"xColumn,omitempty"`
	XTickStart   *float32               `json:"xTickStart,omitempty"`
	XTickStep    *float32               `json:"xTickStep,omitempty"`
	XTotalTicks  *int                   `json:"xTotalTicks,omitempty"`
	YColumn      *string                `json:"yColumn,omitempty"`
	YTickStart   *float32               `json:"yTickStart,omitempty"`
	YTickStep    *float32               `json:"yTickStep,omitempty"`
	YTotalTicks  *int                   `json:"yTotalTicks,omitempty"`
}

// BandViewPropertiesHoverDimension defines model for BandViewProperties.HoverDimension.
type BandViewPropertiesHoverDimension string

// BandViewPropertiesShape defines model for BandViewProperties.Shape.
type BandViewPropertiesShape string

// BandViewPropertiesType defines model for BandViewProperties.Type.
type BandViewPropertiesType string

// uses binary operators to act on two operands in an expression
type BinaryExpression struct {
	Left     *Expression `json:"left,omitempty"`
	Operator *string     `json:"operator,omitempty"`
	Right    *Expression `json:"right,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// A set of statements
type Block struct {
	// Block body
	Body *[]Statement `json:"body,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Represents boolean values
type BooleanLiteral struct {
	// Type of AST node
	Type  *NodeType `json:"type,omitempty"`
	Value *bool     `json:"value,omitempty"`
}

// Bucket defines model for Bucket.
type Bucket struct {
	CreatedAt   *time.Time `json:"createdAt,omitempty"`
	Description *string    `json:"description,omitempty"`
	Id          *string    `json:"id,omitempty"`
	Labels      *Labels    `json:"labels,omitempty"`
	Links       *struct {
		// URI of resource.
		Labels *Link `json:"labels,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Org *Link `json:"org,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`

		// URI of resource.
		Write *Link `json:"write,omitempty"`
	} `json:"links,omitempty"`
	Name  string  `json:"name"`
	OrgID *string `json:"orgID,omitempty"`

	// Retention rules to expire or retain data.
	// #### InfluxDB Cloud
	//
	// - `retentionRules` is required.
	//
	// #### InfluxDB OSS
	//
	// - `retentionRules` isn't required.
	RetentionRules RetentionRules `json:"retentionRules"`
	Rp             *string        `json:"rp,omitempty"`
	SchemaType     *SchemaType    `json:"schemaType,omitempty"`
	Type           *BucketType    `json:"type,omitempty"`
	UpdatedAt      *time.Time     `json:"updatedAt,omitempty"`
}

// BucketType defines model for Bucket.Type.
type BucketType string

// BucketMetadataManifest defines model for BucketMetadataManifest.
type BucketMetadataManifest struct {
	BucketID               string                   `json:"bucketID"`
	BucketName             string                   `json:"bucketName"`
	DefaultRetentionPolicy string                   `json:"defaultRetentionPolicy"`
	Description            *string                  `json:"description,omitempty"`
	OrganizationID         string                   `json:"organizationID"`
	OrganizationName       string                   `json:"organizationName"`
	RetentionPolicies      RetentionPolicyManifests `json:"retentionPolicies"`
}

// BucketMetadataManifests defines model for BucketMetadataManifests.
type BucketMetadataManifests []BucketMetadataManifest

// BucketShardMapping defines model for BucketShardMapping.
type BucketShardMapping struct {
	NewId int64 `json:"newId"`
	OldId int64 `json:"oldId"`
}

// BucketShardMappings defines model for BucketShardMappings.
type BucketShardMappings []BucketShardMapping

// Buckets defines model for Buckets.
type Buckets struct {
	Buckets *[]Bucket `json:"buckets,omitempty"`

	// URI pointers for additional paged results.
	Links *Links `json:"links,omitempty"`
}

// BuilderAggregateFunctionType defines model for BuilderAggregateFunctionType.
type BuilderAggregateFunctionType string

// BuilderConfig defines model for BuilderConfig.
type BuilderConfig struct {
	AggregateWindow *struct {
		FillValues *bool   `json:"fillValues,omitempty"`
		Period     *string `json:"period,omitempty"`
	} `json:"aggregateWindow,omitempty"`
	Buckets   *[]string               `json:"buckets,omitempty"`
	Functions *[]BuilderFunctionsType `json:"functions,omitempty"`
	Tags      *[]BuilderTagsType      `json:"tags,omitempty"`
}

// BuilderFunctionsType defines model for BuilderFunctionsType.
type BuilderFunctionsType struct {
	Name *string `json:"name,omitempty"`
}

// BuilderTagsType defines model for BuilderTagsType.
type BuilderTagsType struct {
	AggregateFunctionType *BuilderAggregateFunctionType `json:"aggregateFunctionType,omitempty"`
	Key                   *string                       `json:"key,omitempty"`
	Values                *[]string                     `json:"values,omitempty"`
}

// Declares a builtin identifier and its type
type BuiltinStatement struct {
	// A valid Flux identifier
	Id *Identifier `json:"id,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Represents a function call
type CallExpression struct {
	// Function arguments
	Arguments *[]Expression `json:"arguments,omitempty"`
	Callee    *Expression   `json:"callee,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Cell defines model for Cell.
type Cell struct {
	H     *int32  `json:"h,omitempty"`
	Id    *string `json:"id,omitempty"`
	Links *struct {
		Self *string `json:"self,omitempty"`
		View *string `json:"view,omitempty"`
	} `json:"links,omitempty"`

	// The reference to a view from the views API.
	ViewID *string `json:"viewID,omitempty"`
	W      *int32  `json:"w,omitempty"`
	X      *int32  `json:"x,omitempty"`
	Y      *int32  `json:"y,omitempty"`
}

// CellUpdate defines model for CellUpdate.
type CellUpdate struct {
	H *int32 `json:"h,omitempty"`
	W *int32 `json:"w,omitempty"`
	X *int32 `json:"x,omitempty"`
	Y *int32 `json:"y,omitempty"`
}

// CellWithViewProperties defines model for CellWithViewProperties.
type CellWithViewProperties struct {
	// Embedded struct due to allOf(#/components/schemas/Cell)
	Cell `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Name       *string         `json:"name,omitempty"`
	Properties *ViewProperties `json:"properties,omitempty"`
}

// Cells defines model for Cells.
type Cells []Cell

// CellsWithViewProperties defines model for CellsWithViewProperties.
type CellsWithViewProperties []CellWithViewProperties

// Check defines model for Check.
type Check struct {
	// Embedded struct due to allOf(#/components/schemas/CheckDiscriminator)
	CheckDiscriminator `yaml:",inline"`
}

// CheckBase defines model for CheckBase.
type CheckBase struct {
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// An optional description of the check.
	Description   *string                 `json:"description,omitempty"`
	Id            *string                 `json:"id,omitempty"`
	Labels        *Labels                 `json:"labels,omitempty"`
	LastRunError  *string                 `json:"lastRunError,omitempty"`
	LastRunStatus *CheckBaseLastRunStatus `json:"lastRunStatus,omitempty"`

	// A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)) of the latest scheduled and completed run.
	LatestCompleted *time.Time `json:"latestCompleted,omitempty"`
	Links           *struct {
		// URI of resource.
		Labels *Link `json:"labels,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Query *Link `json:"query,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Name string `json:"name"`

	// The ID of the organization that owns this check.
	OrgID string `json:"orgID"`

	// The ID of creator used to create this check.
	OwnerID *string        `json:"ownerID,omitempty"`
	Query   DashboardQuery `json:"query"`

	// `inactive` cancels scheduled runs and prevents manual runs of the task.
	Status *TaskStatusType `json:"status,omitempty"`

	// The ID of the task associated with this check.
	TaskID    *string    `json:"taskID,omitempty"`
	UpdatedAt *time.Time `json:"updatedAt,omitempty"`
}

// CheckBaseLastRunStatus defines model for CheckBase.LastRunStatus.
type CheckBaseLastRunStatus string

// CheckDiscriminator defines model for CheckDiscriminator.
type CheckDiscriminator interface{}

// CheckPatch defines model for CheckPatch.
type CheckPatch struct {
	Description *string           `json:"description,omitempty"`
	Name        *string           `json:"name,omitempty"`
	Status      *CheckPatchStatus `json:"status,omitempty"`
}

// CheckPatchStatus defines model for CheckPatch.Status.
type CheckPatchStatus string

// The state to record if check matches a criteria.
type CheckStatusLevel string

// CheckViewProperties defines model for CheckViewProperties.
type CheckViewProperties struct {
	AdaptiveZoomHide *bool  `json:"adaptiveZoomHide,omitempty"`
	Check            *Check `json:"check,omitempty"`
	CheckID          string `json:"checkID"`

	// Colors define color encoding of data into a visualization
	Colors                     []DashboardColor         `json:"colors"`
	LegendColorizeRows         *bool                    `json:"legendColorizeRows,omitempty"`
	LegendHide                 *bool                    `json:"legendHide,omitempty"`
	LegendOpacity              *float32                 `json:"legendOpacity,omitempty"`
	LegendOrientationThreshold *int                     `json:"legendOrientationThreshold,omitempty"`
	Queries                    []DashboardQuery         `json:"queries"`
	Shape                      CheckViewPropertiesShape `json:"shape"`
	Type                       CheckViewPropertiesType  `json:"type"`
}

// CheckViewPropertiesShape defines model for CheckViewProperties.Shape.
type CheckViewPropertiesShape string

// CheckViewPropertiesType defines model for CheckViewProperties.Type.
type CheckViewPropertiesType string

// Checks defines model for Checks.
type Checks struct {
	Checks *[]Check `json:"checks,omitempty"`

	// URI pointers for additional paged results.
	Links *Links `json:"links,omitempty"`
}

// A color mapping is an object that maps time series data to a UI color scheme to allow the UI to render graphs consistent colors across reloads.
type ColorMapping struct {
	AdditionalProperties map[string]string `json:"-"`
}

// Selects one of two expressions, `Alternate` or `Consequent`, depending on a third boolean expression, `Test`
type ConditionalExpression struct {
	Alternate  *Expression `json:"alternate,omitempty"`
	Consequent *Expression `json:"consequent,omitempty"`
	Test       *Expression `json:"test,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Config defines model for Config.
type Config struct {
	Config *map[string]interface{} `json:"config,omitempty"`
}

// ConstantVariableProperties defines model for ConstantVariableProperties.
type ConstantVariableProperties struct {
	Type   *ConstantVariablePropertiesType `json:"type,omitempty"`
	Values *[]string                       `json:"values,omitempty"`
}

// ConstantVariablePropertiesType defines model for ConstantVariableProperties.Type.
type ConstantVariablePropertiesType string

// CreateCell defines model for CreateCell.
type CreateCell struct {
	H    *int32  `json:"h,omitempty"`
	Name *string `json:"name,omitempty"`

	// Makes a copy of the provided view.
	UsingView *string `json:"usingView,omitempty"`
	W         *int32  `json:"w,omitempty"`
	X         *int32  `json:"x,omitempty"`
	Y         *int32  `json:"y,omitempty"`
}

// CreateDashboardRequest defines model for CreateDashboardRequest.
type CreateDashboardRequest struct {
	// The user-facing description of the dashboard.
	Description *string `json:"description,omitempty"`

	// The user-facing name of the dashboard.
	Name string `json:"name"`

	// The ID of the organization that owns the dashboard.
	OrgID string `json:"orgID"`
}

// CustomCheck defines model for CustomCheck.
type CustomCheck struct {
	// Embedded struct due to allOf(#/components/schemas/CheckBase)
	CheckBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Type CustomCheckType `json:"type"`
}

// CustomCheckType defines model for CustomCheck.Type.
type CustomCheckType string

// DBRP defines model for DBRP.
type DBRP struct {
	// The ID of the bucket used as the target for the translation.
	BucketID string `json:"bucketID"`

	// InfluxDB v1 database
	Database string `json:"database"`

	// Mapping represents the default retention policy for the database specified.
	Default bool `json:"default"`

	// The ID of the DBRP mapping.
	Id string `json:"id"`

	// URI pointers for additional paged results.
	Links *Links `json:"links,omitempty"`

	// The ID of the organization.
	OrgID string `json:"orgID"`

	// InfluxDB v1 retention policy
	RetentionPolicy string `json:"retention_policy"`

	// Indicates an autogenerated, virtual mapping based on the bucket name. Currently only available in OSS.
	Virtual *bool `json:"virtual,omitempty"`
}

// DBRPCreate defines model for DBRPCreate.
type DBRPCreate struct {
	// The ID of the bucket used as the target for the translation.
	BucketID string `json:"bucketID"`

	// InfluxDB v1 database
	Database string `json:"database"`

	// Mapping represents the default retention policy for the database specified.
	Default *bool `json:"default,omitempty"`

	// The name of the organization that owns this mapping.
	Org *string `json:"org,omitempty"`

	// The ID of the organization.
	OrgID *string `json:"orgID,omitempty"`

	// InfluxDB v1 retention policy
	RetentionPolicy string `json:"retention_policy"`
}

// DBRPGet defines model for DBRPGet.
type DBRPGet struct {
	Content *DBRP `json:"content,omitempty"`
}

// DBRPUpdate defines model for DBRPUpdate.
type DBRPUpdate struct {
	Default *bool `json:"default,omitempty"`

	// InfluxDB v1 retention policy
	RetentionPolicy *string `json:"retention_policy,omitempty"`
}

// DBRPs defines model for DBRPs.
type DBRPs struct {
	Content *[]DBRP `json:"content,omitempty"`
}

// Dashboard defines model for Dashboard.
type Dashboard struct {
	// Embedded struct due to allOf(#/components/schemas/CreateDashboardRequest)
	CreateDashboardRequest `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Cells  *Cells  `json:"cells,omitempty"`
	Id     *string `json:"id,omitempty"`
	Labels *Labels `json:"labels,omitempty"`
	Links  *struct {
		// URI of resource.
		Cells *Link `json:"cells,omitempty"`

		// URI of resource.
		Labels *Link `json:"labels,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Org *Link `json:"org,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Meta *struct {
		CreatedAt *time.Time `json:"createdAt,omitempty"`
		UpdatedAt *time.Time `json:"updatedAt,omitempty"`
	} `json:"meta,omitempty"`
}

// Defines an encoding of data value into color space.
type DashboardColor struct {
	// The hex number of the color
	Hex string `json:"hex"`

	// The unique ID of the view color.
	Id string `json:"id"`

	// The user-facing name of the hex color.
	Name string `json:"name"`

	// Type is how the color is used.
	Type DashboardColorType `json:"type"`

	// The data value mapped to this color.
	Value float32 `json:"value"`
}

// Type is how the color is used.
type DashboardColorType string

// DashboardQuery defines model for DashboardQuery.
type DashboardQuery struct {
	BuilderConfig *BuilderConfig `json:"builderConfig,omitempty"`
	EditMode      *QueryEditMode `json:"editMode,omitempty"`
	Name          *string        `json:"name,omitempty"`

	// The text of the Flux query.
	Text *string `json:"text,omitempty"`
}

// DashboardWithViewProperties defines model for DashboardWithViewProperties.
type DashboardWithViewProperties struct {
	// Embedded struct due to allOf(#/components/schemas/CreateDashboardRequest)
	CreateDashboardRequest `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Cells  *CellsWithViewProperties `json:"cells,omitempty"`
	Id     *string                  `json:"id,omitempty"`
	Labels *Labels                  `json:"labels,omitempty"`
	Links  *struct {
		// URI of resource.
		Cells *Link `json:"cells,omitempty"`

		// URI of resource.
		Labels *Link `json:"labels,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Org *Link `json:"org,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Meta *struct {
		CreatedAt *time.Time `json:"createdAt,omitempty"`
		UpdatedAt *time.Time `json:"updatedAt,omitempty"`
	} `json:"meta,omitempty"`
}

// Dashboards defines model for Dashboards.
type Dashboards struct {
	Dashboards *[]Dashboard `json:"dashboards,omitempty"`

	// URI pointers for additional paged results.
	Links *Links `json:"links,omitempty"`
}

// Represents an instant in time with nanosecond precision in [RFC3339Nano date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339nano-timestamp).
type DateTimeLiteral struct {
	// Type of AST node
	Type  *NodeType  `json:"type,omitempty"`
	Value *time.Time `json:"value,omitempty"`
}

// DeadmanCheck defines model for DeadmanCheck.
type DeadmanCheck struct {
	// Embedded struct due to allOf(#/components/schemas/CheckBase)
	CheckBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// Check repetition interval.
	Every *string `json:"every,omitempty"`

	// The state to record if check matches a criteria.
	Level *CheckStatusLevel `json:"level,omitempty"`

	// Duration to delay after the schedule, before executing check.
	Offset *string `json:"offset,omitempty"`

	// If only zero values reported since time, trigger an alert
	ReportZero *bool `json:"reportZero,omitempty"`

	// String duration for time that a series is considered stale and should not trigger deadman.
	StaleTime *string `json:"staleTime,omitempty"`

	// The template used to generate and write a status message.
	StatusMessageTemplate *string `json:"statusMessageTemplate,omitempty"`

	// List of tags to write to each status.
	Tags *[]struct {
		Key   *string `json:"key,omitempty"`
		Value *string `json:"value,omitempty"`
	} `json:"tags,omitempty"`

	// String duration before deadman triggers.
	TimeSince *string          `json:"timeSince,omitempty"`
	Type      DeadmanCheckType `json:"type"`
}

// DeadmanCheckType defines model for DeadmanCheck.Type.
type DeadmanCheckType string

// Indicates whether decimal places should be enforced, and how many digits it should show.
type DecimalPlaces struct {
	// The number of digits after decimal to display
	Digits *int32 `json:"digits,omitempty"`

	// Indicates whether decimal point setting should be enforced
	IsEnforced *bool `json:"isEnforced,omitempty"`
}

// The delete predicate request.
type DeletePredicateRequest struct {
	// An expression in [delete predicate syntax](https://docs.influxdata.com/influxdb/v2.3/reference/syntax/delete-predicate/).
	Predicate *string `json:"predicate,omitempty"`

	// A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)).
	// The earliest time to delete from.
	Start time.Time `json:"start"`

	// A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)).
	// The latest time to delete from.
	Stop time.Time `json:"stop"`
}

// Options for tabular data output.
// Default output is [annotated CSV](https://docs.influxdata.com/influxdb/v2.3/reference/syntax/annotated-csv/#csv-response-format) with headers.
//
// For more information about tabular data **dialect**,
// see [W3 metadata vocabulary for tabular data](https://www.w3.org/TR/2015/REC-tabular-metadata-20151217/#dialect-descriptions).
type Dialect struct {
	// Annotation rows to include in the results.
	// An _annotation_ is metadata associated with an object (column) in the data model.
	//
	// #### Related guides
	//
	// - See [Annotated CSV annotations](https://docs.influxdata.com/influxdb/v2.3/reference/syntax/annotated-csv/#annotations) for examples and more information.
	//
	// For more information about **annotations** in tabular data,
	// see [W3 metadata vocabulary for tabular data](https://www.w3.org/TR/2015/REC-tabular-data-model-20151217/#columns).
	Annotations *[]DialectAnnotations `json:"annotations,omitempty"`

	// The character prefixed to comment strings. Default is a number sign (`#`).
	CommentPrefix *string `json:"commentPrefix,omitempty"`

	// The format for timestamps in results.
	// Default is [`RFC3339` date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp).
	// To include nanoseconds in timestamps, use `RFC3339Nano`.
	//
	// #### Example formatted date/time values
	//
	// | Format      | Value                       |
	// |:------------|:----------------------------|
	// | `RFC3339`    | `"2006-01-02T15:04:05Z07:00"` |
	// | `RFC3339Nano` | `"2006-01-02T15:04:05.999999999Z07:00"` |
	DateTimeFormat *DialectDateTimeFormat `json:"dateTimeFormat,omitempty"`

	// The separator used between cells. Default is a comma (`,`).
	Delimiter *string `json:"delimiter,omitempty"`

	// If true, the results contain a header row.
	Header *bool `json:"header,omitempty"`
}

// DialectAnnotations defines model for Dialect.Annotations.
type DialectAnnotations string

// The format for timestamps in results.
// Default is [`RFC3339` date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp).
// To include nanoseconds in timestamps, use `RFC3339Nano`.
//
// #### Example formatted date/time values
//
// | Format      | Value                       |
// |:------------|:----------------------------|
// | `RFC3339`    | `"2006-01-02T15:04:05Z07:00"` |
// | `RFC3339Nano` | `"2006-01-02T15:04:05.999999999Z07:00"` |
type DialectDateTimeFormat string

// Used to create and directly specify the elements of a dictionary
type DictExpression struct {
	// Elements of the dictionary
	Elements *[]DictItem `json:"elements,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// A key-value pair in a dictionary.
type DictItem struct {
	Key *Expression `json:"key,omitempty"`

	// Type of AST node
	Type *NodeType   `json:"type,omitempty"`
	Val  *Expression `json:"val,omitempty"`
}

// A pair consisting of length of time and the unit of time measured. It is the atomic unit from which all duration literals are composed.
type Duration struct {
	Magnitude *int `json:"magnitude,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
	Unit *string   `json:"unit,omitempty"`
}

// Represents the elapsed time between two instants as an int64 nanosecond count with syntax of golang's time.Duration
type DurationLiteral struct {
	// Type of AST node
	Type *NodeType `json:"type,omitempty"`

	// Duration values
	Values *[]Duration `json:"values,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// code is the machine-readable error code.
	Code ErrorCode `json:"code"`

	// Stack of errors that occurred during processing of the request. Useful for debugging.
	Err *string `json:"err,omitempty"`

	// Human-readable message.
	Message *string `json:"message,omitempty"`

	// Describes the logical code operation when the error occurred. Useful for debugging.
	Op *string `json:"op,omitempty"`
}

// code is the machine-readable error code.
type ErrorCode string

// Expression defines model for Expression.
type Expression interface{}

// May consist of an expression that doesn't return a value and is executed solely for its side-effects
type ExpressionStatement struct {
	Expression *Expression `json:"expression,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Field defines model for Field.
type Field struct {
	// Alias overrides the field name in the returned response.  Applies only if type is `func`
	Alias *string `json:"alias,omitempty"`

	// Args are the arguments to the function
	Args *[]Field `json:"args,omitempty"`

	// `type` describes the field type. `func` is a function. `field` is a field reference.
	Type *FieldType `json:"type,omitempty"`

	// value is the value of the field.  Meaning of the value is implied by the `type` key
	Value *string `json:"value,omitempty"`
}

// `type` describes the field type. `func` is a function. `field` is a field reference.
type FieldType string

// Represents a source from a single file
type File struct {
	// List of Flux statements
	Body *[]Statement `json:"body,omitempty"`

	// A list of package imports
	Imports *[]ImportDeclaration `json:"imports,omitempty"`

	// The name of the file.
	Name *string `json:"name,omitempty"`

	// Defines a package identifier
	Package *PackageClause `json:"package,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Flags defines model for Flags.
type Flags struct {
	AdditionalProperties map[string]interface{} `json:"-"`
}

// Represents floating point numbers according to the double representations defined by the IEEE-754-1985
type FloatLiteral struct {
	// Type of AST node
	Type  *NodeType `json:"type,omitempty"`
	Value *float32  `json:"value,omitempty"`
}

// Rendered flux that backs the check or notification.
type FluxResponse struct {
	Flux *string `json:"flux,omitempty"`
}

// FluxSuggestion defines model for FluxSuggestion.
type FluxSuggestion struct {
	Name   *string                `json:"name,omitempty"`
	Params *FluxSuggestion_Params `json:"params,omitempty"`
}

// FluxSuggestion_Params defines model for FluxSuggestion.Params.
type FluxSuggestion_Params struct {
	AdditionalProperties map[string]string `json:"-"`
}

// FluxSuggestions defines model for FluxSuggestions.
type FluxSuggestions struct {
	Funcs *[]FluxSuggestion `json:"funcs,omitempty"`
}

// Function expression
type FunctionExpression struct {
	Body *Node `json:"body,omitempty"`

	// Function parameters
	Params *[]Property `json:"params,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// GaugeViewProperties defines model for GaugeViewProperties.
type GaugeViewProperties struct {
	// Colors define color encoding of data into a visualization
	Colors []DashboardColor `json:"colors"`

	// Indicates whether decimal places should be enforced, and how many digits it should show.
	DecimalPlaces DecimalPlaces            `json:"decimalPlaces"`
	Note          string                   `json:"note"`
	Prefix        string                   `json:"prefix"`
	Queries       []DashboardQuery         `json:"queries"`
	Shape         GaugeViewPropertiesShape `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool                    `json:"showNoteWhenEmpty"`
	Suffix            string                  `json:"suffix"`
	TickPrefix        string                  `json:"tickPrefix"`
	TickSuffix        string                  `json:"tickSuffix"`
	Type              GaugeViewPropertiesType `json:"type"`
}

// GaugeViewPropertiesShape defines model for GaugeViewProperties.Shape.
type GaugeViewPropertiesShape string

// GaugeViewPropertiesType defines model for GaugeViewProperties.Type.
type GaugeViewPropertiesType string

// GeoCircleViewLayer defines model for GeoCircleViewLayer.
type GeoCircleViewLayer struct {
	// Embedded struct due to allOf(#/components/schemas/GeoViewLayerProperties)
	GeoViewLayerProperties `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// Axis used in a visualization.
	ColorDimension Axis `json:"colorDimension"`

	// Circle color field
	ColorField string `json:"colorField"`

	// Colors define color encoding of data into a visualization
	Colors []DashboardColor `json:"colors"`

	// Interpolate circle color based on displayed value
	InterpolateColors *bool `json:"interpolateColors,omitempty"`

	// Maximum radius size in pixels
	Radius *int `json:"radius,omitempty"`

	// Axis used in a visualization.
	RadiusDimension Axis `json:"radiusDimension"`

	// Radius field
	RadiusField string `json:"radiusField"`
}

// GeoHeatMapViewLayer defines model for GeoHeatMapViewLayer.
type GeoHeatMapViewLayer struct {
	// Embedded struct due to allOf(#/components/schemas/GeoViewLayerProperties)
	GeoViewLayerProperties `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// Blur for heatmap points
	Blur int `json:"blur"`

	// Colors define color encoding of data into a visualization
	Colors []DashboardColor `json:"colors"`

	// Axis used in a visualization.
	IntensityDimension Axis `json:"intensityDimension"`

	// Intensity field
	IntensityField string `json:"intensityField"`

	// Radius size in pixels
	Radius int `json:"radius"`
}

// GeoPointMapViewLayer defines model for GeoPointMapViewLayer.
type GeoPointMapViewLayer struct {
	// Embedded struct due to allOf(#/components/schemas/GeoViewLayerProperties)
	GeoViewLayerProperties `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// Axis used in a visualization.
	ColorDimension Axis `json:"colorDimension"`

	// Marker color field
	ColorField string `json:"colorField"`

	// Colors define color encoding of data into a visualization
	Colors []DashboardColor `json:"colors"`

	// Cluster close markers together
	IsClustered *bool `json:"isClustered,omitempty"`

	// An array for which columns to display in tooltip
	TooltipColumns *[]string `json:"tooltipColumns,omitempty"`
}

// GeoTrackMapViewLayer defines model for GeoTrackMapViewLayer.
type GeoTrackMapViewLayer struct {
	// Embedded struct due to allOf(#/components/schemas/GeoViewLayerProperties)
	GeoViewLayerProperties `yaml:",inline"`
	// Embedded fields due to inline allOf schema
}

// GeoViewLayer defines model for GeoViewLayer.
type GeoViewLayer interface{}

// GeoViewLayerProperties defines model for GeoViewLayerProperties.
type GeoViewLayerProperties struct {
	Type GeoViewLayerPropertiesType `json:"type"`
}

// GeoViewLayerPropertiesType defines model for GeoViewLayerProperties.Type.
type GeoViewLayerPropertiesType string

// GeoViewProperties defines model for GeoViewProperties.
type GeoViewProperties struct {
	// If true, map zoom and pan controls are enabled on the dashboard view
	AllowPanAndZoom bool `json:"allowPanAndZoom"`

	// Coordinates of the center of the map
	Center struct {
		// Latitude of the center of the map
		Lat float64 `json:"lat"`

		// Longitude of the center of the map
		Lon float64 `json:"lon"`
	} `json:"center"`

	// Colors define color encoding of data into a visualization
	Colors *[]DashboardColor `json:"colors,omitempty"`

	// If true, search results get automatically regroupped so that lon,lat and value are treated as columns
	DetectCoordinateFields bool `json:"detectCoordinateFields"`

	// Object type to define lat/lon columns
	LatLonColumns *LatLonColumns `json:"latLonColumns,omitempty"`

	// List of individual layers shown in the map
	Layers []GeoViewLayer `json:"layers"`

	// Define map type - regular, satellite etc.
	MapStyle *string          `json:"mapStyle,omitempty"`
	Note     string           `json:"note"`
	Queries  []DashboardQuery `json:"queries"`

	// String to define the column
	S2Column *string                `json:"s2Column,omitempty"`
	Shape    GeoViewPropertiesShape `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool                  `json:"showNoteWhenEmpty"`
	Type              GeoViewPropertiesType `json:"type"`

	// If true, S2 column is used to calculate lat/lon
	UseS2CellID *bool `json:"useS2CellID,omitempty"`

	// Zoom level used for initial display of the map
	Zoom float64 `json:"zoom"`
}

// GeoViewPropertiesShape defines model for GeoViewProperties.Shape.
type GeoViewPropertiesShape string

// GeoViewPropertiesType defines model for GeoViewProperties.Type.
type GeoViewPropertiesType string

// GreaterThreshold defines model for GreaterThreshold.
type GreaterThreshold struct {
	// Embedded struct due to allOf(#/components/schemas/ThresholdBase)
	ThresholdBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Type  GreaterThresholdType `json:"type"`
	Value float32              `json:"value"`
}

// GreaterThresholdType defines model for GreaterThreshold.Type.
type GreaterThresholdType string

// HTTPNotificationEndpoint defines model for HTTPNotificationEndpoint.
type HTTPNotificationEndpoint struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationEndpointBase)
	NotificationEndpointBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	AuthMethod      HTTPNotificationEndpointAuthMethod `json:"authMethod"`
	ContentTemplate *string                            `json:"contentTemplate,omitempty"`

	// Customized headers.
	Headers  *HTTPNotificationEndpoint_Headers `json:"headers,omitempty"`
	Method   HTTPNotificationEndpointMethod    `json:"method"`
	Password *string                           `json:"password,omitempty"`
	Token    *string                           `json:"token,omitempty"`
	Url      string                            `json:"url"`
	Username *string                           `json:"username,omitempty"`
}

// HTTPNotificationEndpointAuthMethod defines model for HTTPNotificationEndpoint.AuthMethod.
type HTTPNotificationEndpointAuthMethod string

// HTTPNotificationEndpointMethod defines model for HTTPNotificationEndpoint.Method.
type HTTPNotificationEndpointMethod string

// Customized headers.
type HTTPNotificationEndpoint_Headers struct {
	AdditionalProperties map[string]string `json:"-"`
}

// HTTPNotificationRule defines model for HTTPNotificationRule.
type HTTPNotificationRule struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationRuleBase)
	NotificationRuleBase `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/HTTPNotificationRuleBase)
	HTTPNotificationRuleBase `yaml:",inline"`
}

// HTTPNotificationRuleBase defines model for HTTPNotificationRuleBase.
type HTTPNotificationRuleBase struct {
	Type HTTPNotificationRuleBaseType `json:"type"`
	Url  *string                      `json:"url,omitempty"`
}

// HTTPNotificationRuleBaseType defines model for HTTPNotificationRuleBase.Type.
type HTTPNotificationRuleBaseType string

// HealthCheck defines model for HealthCheck.
type HealthCheck struct {
	Checks  *[]HealthCheck    `json:"checks,omitempty"`
	Commit  *string           `json:"commit,omitempty"`
	Message *string           `json:"message,omitempty"`
	Name    string            `json:"name"`
	Status  HealthCheckStatus `json:"status"`
	Version *string           `json:"version,omitempty"`
}

// HealthCheckStatus defines model for HealthCheck.Status.
type HealthCheckStatus string

// HeatmapViewProperties defines model for HeatmapViewProperties.
type HeatmapViewProperties struct {
	AdaptiveZoomHide *bool   `json:"adaptiveZoomHide,omitempty"`
	BinSize          float32 `json:"binSize"`

	// Colors define color encoding of data into a visualization
	Colors                     []string                   `json:"colors"`
	GenerateXAxisTicks         *[]string                  `json:"generateXAxisTicks,omitempty"`
	GenerateYAxisTicks         *[]string                  `json:"generateYAxisTicks,omitempty"`
	LegendColorizeRows         *bool                      `json:"legendColorizeRows,omitempty"`
	LegendHide                 *bool                      `json:"legendHide,omitempty"`
	LegendOpacity              *float32                   `json:"legendOpacity,omitempty"`
	LegendOrientationThreshold *int                       `json:"legendOrientationThreshold,omitempty"`
	Note                       string                     `json:"note"`
	Queries                    []DashboardQuery           `json:"queries"`
	Shape                      HeatmapViewPropertiesShape `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool                      `json:"showNoteWhenEmpty"`
	TimeFormat        *string                   `json:"timeFormat,omitempty"`
	Type              HeatmapViewPropertiesType `json:"type"`
	XAxisLabel        string                    `json:"xAxisLabel"`
	XColumn           string                    `json:"xColumn"`
	XDomain           []float32                 `json:"xDomain"`
	XPrefix           string                    `json:"xPrefix"`
	XSuffix           string                    `json:"xSuffix"`
	XTickStart        *float32                  `json:"xTickStart,omitempty"`
	XTickStep         *float32                  `json:"xTickStep,omitempty"`
	XTotalTicks       *int                      `json:"xTotalTicks,omitempty"`
	YAxisLabel        string                    `json:"yAxisLabel"`
	YColumn           string                    `json:"yColumn"`
	YDomain           []float32                 `json:"yDomain"`
	YPrefix           string                    `json:"yPrefix"`
	YSuffix           string                    `json:"ySuffix"`
	YTickStart        *float32                  `json:"yTickStart,omitempty"`
	YTickStep         *float32                  `json:"yTickStep,omitempty"`
	YTotalTicks       *int                      `json:"yTotalTicks,omitempty"`
}

// HeatmapViewPropertiesShape defines model for HeatmapViewProperties.Shape.
type HeatmapViewPropertiesShape string

// HeatmapViewPropertiesType defines model for HeatmapViewProperties.Type.
type HeatmapViewPropertiesType string

// HistogramViewProperties defines model for HistogramViewProperties.
type HistogramViewProperties struct {
	BinCount int `json:"binCount"`

	// Colors define color encoding of data into a visualization
	Colors                     []DashboardColor                `json:"colors"`
	FillColumns                []string                        `json:"fillColumns"`
	LegendColorizeRows         *bool                           `json:"legendColorizeRows,omitempty"`
	LegendHide                 *bool                           `json:"legendHide,omitempty"`
	LegendOpacity              *float32                        `json:"legendOpacity,omitempty"`
	LegendOrientationThreshold *int                            `json:"legendOrientationThreshold,omitempty"`
	Note                       string                          `json:"note"`
	Position                   HistogramViewPropertiesPosition `json:"position"`
	Queries                    []DashboardQuery                `json:"queries"`
	Shape                      HistogramViewPropertiesShape    `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool                        `json:"showNoteWhenEmpty"`
	Type              HistogramViewPropertiesType `json:"type"`
	XAxisLabel        string                      `json:"xAxisLabel"`
	XColumn           string                      `json:"xColumn"`
	XDomain           []float32                   `json:"xDomain"`
}

// HistogramViewPropertiesPosition defines model for HistogramViewProperties.Position.
type HistogramViewPropertiesPosition string

// HistogramViewPropertiesShape defines model for HistogramViewProperties.Shape.
type HistogramViewPropertiesShape string

// HistogramViewPropertiesType defines model for HistogramViewProperties.Type.
type HistogramViewPropertiesType string

// A valid Flux identifier
type Identifier struct {
	Name *string `json:"name,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Declares a package import
type ImportDeclaration struct {
	// A valid Flux identifier
	As *Identifier `json:"as,omitempty"`

	// Expressions begin and end with double quote marks
	Path *StringLiteral `json:"path,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Represents indexing into an array
type IndexExpression struct {
	Array *Expression `json:"array,omitempty"`
	Index *Expression `json:"index,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Represents integer numbers
type IntegerLiteral struct {
	// Type of AST node
	Type  *NodeType `json:"type,omitempty"`
	Value *string   `json:"value,omitempty"`
}

// IsOnboarding defines model for IsOnboarding.
type IsOnboarding struct {
	// If `true`, the InfluxDB instance hasn't had initial setup;
	// `false` otherwise.
	Allowed *bool `json:"allowed,omitempty"`
}

// Label defines model for Label.
type Label struct {
	Id    *string `json:"id,omitempty"`
	Name  *string `json:"name,omitempty"`
	OrgID *string `json:"orgID,omitempty"`

	// Key-value pairs associated with this label.
	// To remove a property, send an update with an empty value (`""`) for the key.
	Properties *Label_Properties `json:"properties,omitempty"`
}

// Key-value pairs associated with this label.
// To remove a property, send an update with an empty value (`""`) for the key.
type Label_Properties struct {
	AdditionalProperties map[string]string `json:"-"`
}

// LabelCreateRequest defines model for LabelCreateRequest.
type LabelCreateRequest struct {
	Name  string `json:"name"`
	OrgID string `json:"orgID"`

	// Key-value pairs associated with this label.
	//
	// To remove a property, send an update with an empty value (`""`) for the key.
	Properties *LabelCreateRequest_Properties `json:"properties,omitempty"`
}

// Key-value pairs associated with this label.
//
// To remove a property, send an update with an empty value (`""`) for the key.
type LabelCreateRequest_Properties struct {
	AdditionalProperties map[string]string `json:"-"`
}

// LabelMapping defines model for LabelMapping.
type LabelMapping struct {
	// Label ID.
	// The ID of the label to attach.
	LabelID *string `json:"labelID,omitempty"`
}

// LabelResponse defines model for LabelResponse.
type LabelResponse struct {
	Label *Label `json:"label,omitempty"`

	// URI pointers for additional paged results.
	Links *Links `json:"links,omitempty"`
}

// LabelUpdate defines model for LabelUpdate.
type LabelUpdate struct {
	Name       *string                 `json:"name,omitempty"`
	Properties *LabelUpdate_Properties `json:"properties,omitempty"`
}

// LabelUpdate_Properties defines model for LabelUpdate.Properties.
type LabelUpdate_Properties struct {
	AdditionalProperties map[string]string `json:"-"`
}

// Labels defines model for Labels.
type Labels []Label

// LabelsResponse defines model for LabelsResponse.
type LabelsResponse struct {
	Labels *Labels `json:"labels,omitempty"`

	// URI pointers for additional paged results.
	Links *Links `json:"links,omitempty"`
}

// Flux query to be analyzed.
type LanguageRequest struct {
	// The Flux query script to be analyzed.
	Query string `json:"query"`
}

// Object type for key and column definitions
type LatLonColumn struct {
	// Column to look up Lat/Lon
	Column string `json:"column"`

	// Key to determine whether the column is tag/field
	Key string `json:"key"`
}

// Object type to define lat/lon columns
type LatLonColumns struct {
	// Object type for key and column definitions
	Lat LatLonColumn `json:"lat"`

	// Object type for key and column definitions
	Lon LatLonColumn `json:"lon"`
}

// LesserThreshold defines model for LesserThreshold.
type LesserThreshold struct {
	// Embedded struct due to allOf(#/components/schemas/ThresholdBase)
	ThresholdBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Type  LesserThresholdType `json:"type"`
	Value float32             `json:"value"`
}

// LesserThresholdType defines model for LesserThreshold.Type.
type LesserThresholdType string

// LinePlusSingleStatProperties defines model for LinePlusSingleStatProperties.
type LinePlusSingleStatProperties struct {
	AdaptiveZoomHide *bool `json:"adaptiveZoomHide,omitempty"`

	// The viewport for a View's visualizations
	Axes Axes `json:"axes"`

	// Colors define color encoding of data into a visualization
	Colors []DashboardColor `json:"colors"`

	// Indicates whether decimal places should be enforced, and how many digits it should show.
	DecimalPlaces              DecimalPlaces                               `json:"decimalPlaces"`
	GenerateXAxisTicks         *[]string                                   `json:"generateXAxisTicks,omitempty"`
	GenerateYAxisTicks         *[]string                                   `json:"generateYAxisTicks,omitempty"`
	HoverDimension             *LinePlusSingleStatPropertiesHoverDimension `json:"hoverDimension,omitempty"`
	LegendColorizeRows         *bool                                       `json:"legendColorizeRows,omitempty"`
	LegendHide                 *bool                                       `json:"legendHide,omitempty"`
	LegendOpacity              *float32                                    `json:"legendOpacity,omitempty"`
	LegendOrientationThreshold *int                                        `json:"legendOrientationThreshold,omitempty"`
	Note                       string                                      `json:"note"`
	Position                   LinePlusSingleStatPropertiesPosition        `json:"position"`
	Prefix                     string                                      `json:"prefix"`
	Queries                    []DashboardQuery                            `json:"queries"`
	ShadeBelow                 *bool                                       `json:"shadeBelow,omitempty"`
	Shape                      LinePlusSingleStatPropertiesShape           `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool `json:"showNoteWhenEmpty"`

	// StaticLegend represents the options specific to the static legend
	StaticLegend *StaticLegend                    `json:"staticLegend,omitempty"`
	Suffix       string                           `json:"suffix"`
	TimeFormat   *string                          `json:"timeFormat,omitempty"`
	Type         LinePlusSingleStatPropertiesType `json:"type"`
	XColumn      *string                          `json:"xColumn,omitempty"`
	XTickStart   *float32                         `json:"xTickStart,omitempty"`
	XTickStep    *float32                         `json:"xTickStep,omitempty"`
	XTotalTicks  *int                             `json:"xTotalTicks,omitempty"`
	YColumn      *string                          `json:"yColumn,omitempty"`
	YTickStart   *float32                         `json:"yTickStart,omitempty"`
	YTickStep    *float32                         `json:"yTickStep,omitempty"`
	YTotalTicks  *int                             `json:"yTotalTicks,omitempty"`
}

// LinePlusSingleStatPropertiesHoverDimension defines model for LinePlusSingleStatProperties.HoverDimension.
type LinePlusSingleStatPropertiesHoverDimension string

// LinePlusSingleStatPropertiesPosition defines model for LinePlusSingleStatProperties.Position.
type LinePlusSingleStatPropertiesPosition string

// LinePlusSingleStatPropertiesShape defines model for LinePlusSingleStatProperties.Shape.
type LinePlusSingleStatPropertiesShape string

// LinePlusSingleStatPropertiesType defines model for LinePlusSingleStatProperties.Type.
type LinePlusSingleStatPropertiesType string

// LineProtocolError defines model for LineProtocolError.
type LineProtocolError struct {
	// Code is the machine-readable error code.
	Code LineProtocolErrorCode `json:"code"`

	// Stack of errors that occurred during processing of the request. Useful for debugging.
	Err *string `json:"err,omitempty"`

	// First line in the request body that contains malformed data.
	Line *int32 `json:"line,omitempty"`

	// Human-readable message.
	Message *string `json:"message,omitempty"`

	// Describes the logical code operation when the error occurred. Useful for debugging.
	Op *string `json:"op,omitempty"`
}

// Code is the machine-readable error code.
type LineProtocolErrorCode string

// LineProtocolLengthError defines model for LineProtocolLengthError.
type LineProtocolLengthError struct {
	// Code is the machine-readable error code.
	Code LineProtocolLengthErrorCode `json:"code"`

	// Human-readable message.
	Message string `json:"message"`
}

// Code is the machine-readable error code.
type LineProtocolLengthErrorCode string

// URI of resource.
type Link string

// URI pointers for additional paged results.
type Links struct {
	// URI of resource.
	Next *Link `json:"next,omitempty"`

	// URI of resource.
	Prev *Link `json:"prev,omitempty"`

	// URI of resource.
	Self Link `json:"self"`
}

// LogEvent defines model for LogEvent.
type LogEvent struct {
	// A description of the event that occurred.
	Message *string `json:"message,omitempty"`

	// The ID of the task run that generated the event.
	RunID *string `json:"runID,omitempty"`

	// The time ([RFC3339Nano date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339nano-timestamp)) that the event occurred.
	Time *time.Time `json:"time,omitempty"`
}

// Represents the rule conditions that collectively evaluate to either true or false
type LogicalExpression struct {
	Left     *Expression `json:"left,omitempty"`
	Operator *string     `json:"operator,omitempty"`
	Right    *Expression `json:"right,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Logs defines model for Logs.
type Logs struct {
	Events *[]LogEvent `json:"events,omitempty"`
}

// MapVariableProperties defines model for MapVariableProperties.
type MapVariableProperties struct {
	Type   *MapVariablePropertiesType    `json:"type,omitempty"`
	Values *MapVariableProperties_Values `json:"values,omitempty"`
}

// MapVariablePropertiesType defines model for MapVariableProperties.Type.
type MapVariablePropertiesType string

// MapVariableProperties_Values defines model for MapVariableProperties.Values.
type MapVariableProperties_Values struct {
	AdditionalProperties map[string]string `json:"-"`
}

// MarkdownViewProperties defines model for MarkdownViewProperties.
type MarkdownViewProperties struct {
	Note  string                      `json:"note"`
	Shape MarkdownViewPropertiesShape `json:"shape"`
	Type  MarkdownViewPropertiesType  `json:"type"`
}

// MarkdownViewPropertiesShape defines model for MarkdownViewProperties.Shape.
type MarkdownViewPropertiesShape string

// MarkdownViewPropertiesType defines model for MarkdownViewProperties.Type.
type MarkdownViewPropertiesType string

// Object property assignment
type MemberAssignment struct {
	Init *Expression `json:"init,omitempty"`

	// Represents accessing a property of an object
	Member *MemberExpression `json:"member,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Represents accessing a property of an object
type MemberExpression struct {
	Object   *Expression  `json:"object,omitempty"`
	Property *PropertyKey `json:"property,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// MetadataBackup defines model for MetadataBackup.
type MetadataBackup struct {
	Buckets BucketMetadataManifests `json:"buckets"`
	Kv      string                  `json:"kv"`
	Sql     string                  `json:"sql"`
}

// MosaicViewProperties defines model for MosaicViewProperties.
type MosaicViewProperties struct {
	// Colors define color encoding of data into a visualization
	Colors                     []string                            `json:"colors"`
	FillColumns                []string                            `json:"fillColumns"`
	GenerateXAxisTicks         *[]string                           `json:"generateXAxisTicks,omitempty"`
	HoverDimension             *MosaicViewPropertiesHoverDimension `json:"hoverDimension,omitempty"`
	LegendColorizeRows         *bool                               `json:"legendColorizeRows,omitempty"`
	LegendHide                 *bool                               `json:"legendHide,omitempty"`
	LegendOpacity              *float32                            `json:"legendOpacity,omitempty"`
	LegendOrientationThreshold *int                                `json:"legendOrientationThreshold,omitempty"`
	Note                       string                              `json:"note"`
	Queries                    []DashboardQuery                    `json:"queries"`
	Shape                      MosaicViewPropertiesShape           `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty     bool                     `json:"showNoteWhenEmpty"`
	TimeFormat            *string                  `json:"timeFormat,omitempty"`
	Type                  MosaicViewPropertiesType `json:"type"`
	XAxisLabel            string                   `json:"xAxisLabel"`
	XColumn               string                   `json:"xColumn"`
	XDomain               []float32                `json:"xDomain"`
	XPrefix               string                   `json:"xPrefix"`
	XSuffix               string                   `json:"xSuffix"`
	XTickStart            *float32                 `json:"xTickStart,omitempty"`
	XTickStep             *float32                 `json:"xTickStep,omitempty"`
	XTotalTicks           *int                     `json:"xTotalTicks,omitempty"`
	YAxisLabel            string                   `json:"yAxisLabel"`
	YDomain               []float32                `json:"yDomain"`
	YLabelColumnSeparator *string                  `json:"yLabelColumnSeparator,omitempty"`
	YLabelColumns         *[]string                `json:"yLabelColumns,omitempty"`
	YPrefix               string                   `json:"yPrefix"`
	YSeriesColumns        []string                 `json:"ySeriesColumns"`
	YSuffix               string                   `json:"ySuffix"`
}

// MosaicViewPropertiesHoverDimension defines model for MosaicViewProperties.HoverDimension.
type MosaicViewPropertiesHoverDimension string

// MosaicViewPropertiesShape defines model for MosaicViewProperties.Shape.
type MosaicViewPropertiesShape string

// MosaicViewPropertiesType defines model for MosaicViewProperties.Type.
type MosaicViewPropertiesType string

// Node defines model for Node.
type Node interface{}

// Type of AST node
type NodeType string

// NotificationEndpoint defines model for NotificationEndpoint.
type NotificationEndpoint struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationEndpointDiscriminator)
	NotificationEndpointDiscriminator `yaml:",inline"`
}

// NotificationEndpointBase defines model for NotificationEndpointBase.
type NotificationEndpointBase struct {
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// An optional description of the notification endpoint.
	Description *string `json:"description,omitempty"`
	Id          *string `json:"id,omitempty"`
	Labels      *Labels `json:"labels,omitempty"`
	Links       *struct {
		// URI of resource.
		Labels *Link `json:"labels,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Name  string  `json:"name"`
	OrgID *string `json:"orgID,omitempty"`

	// The status of the endpoint.
	Status    *NotificationEndpointBaseStatus `json:"status,omitempty"`
	Type      NotificationEndpointType        `json:"type"`
	UpdatedAt *time.Time                      `json:"updatedAt,omitempty"`
	UserID    *string                         `json:"userID,omitempty"`
}

// The status of the endpoint.
type NotificationEndpointBaseStatus string

// NotificationEndpointDiscriminator defines model for NotificationEndpointDiscriminator.
type NotificationEndpointDiscriminator interface{}

// NotificationEndpointType defines model for NotificationEndpointType.
type NotificationEndpointType string

// NotificationEndpointUpdate defines model for NotificationEndpointUpdate.
type NotificationEndpointUpdate struct {
	Description *string                           `json:"description,omitempty"`
	Name        *string                           `json:"name,omitempty"`
	Status      *NotificationEndpointUpdateStatus `json:"status,omitempty"`
}

// NotificationEndpointUpdateStatus defines model for NotificationEndpointUpdate.Status.
type NotificationEndpointUpdateStatus string

// NotificationEndpoints defines model for NotificationEndpoints.
type NotificationEndpoints struct {
	// URI pointers for additional paged results.
	Links                 *Links                  `json:"links,omitempty"`
	NotificationEndpoints *[]NotificationEndpoint `json:"notificationEndpoints,omitempty"`
}

// NotificationRule defines model for NotificationRule.
type NotificationRule struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationRuleDiscriminator)
	NotificationRuleDiscriminator `yaml:",inline"`
}

// NotificationRuleBase defines model for NotificationRuleBase.
type NotificationRuleBase struct {
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// An optional description of the notification rule.
	Description *string `json:"description,omitempty"`
	EndpointID  string  `json:"endpointID"`

	// The notification repetition interval.
	Every         *string                            `json:"every,omitempty"`
	Id            *string                            `json:"id,omitempty"`
	Labels        *Labels                            `json:"labels,omitempty"`
	LastRunError  *string                            `json:"lastRunError,omitempty"`
	LastRunStatus *NotificationRuleBaseLastRunStatus `json:"lastRunStatus,omitempty"`

	// A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)) of the latest scheduled and completed run.
	LatestCompleted *time.Time `json:"latestCompleted,omitempty"`

	// Don't notify me more than <limit> times every <limitEvery> seconds. If set, limitEvery cannot be empty.
	Limit *int `json:"limit,omitempty"`

	// Don't notify me more than <limit> times every <limitEvery> seconds. If set, limit cannot be empty.
	LimitEvery *int `json:"limitEvery,omitempty"`
	Links      *struct {
		// URI of resource.
		Labels *Link `json:"labels,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Query *Link `json:"query,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`
	} `json:"links,omitempty"`

	// Human-readable name describing the notification rule.
	Name string `json:"name"`

	// Duration to delay after the schedule, before executing check.
	Offset *string `json:"offset,omitempty"`

	// The ID of the organization that owns this notification rule.
	OrgID string `json:"orgID"`

	// The ID of creator used to create this notification rule.
	OwnerID     *string `json:"ownerID,omitempty"`
	RunbookLink *string `json:"runbookLink,omitempty"`
	SleepUntil  *string `json:"sleepUntil,omitempty"`

	// `inactive` cancels scheduled runs and prevents manual runs of the task.
	Status TaskStatusType `json:"status"`

	// List of status rules the notification rule attempts to match.
	StatusRules []StatusRule `json:"statusRules"`

	// List of tag rules the notification rule attempts to match.
	TagRules *[]TagRule `json:"tagRules,omitempty"`

	// The ID of the task associated with this notification rule.
	TaskID    *string    `json:"taskID,omitempty"`
	UpdatedAt *time.Time `json:"updatedAt,omitempty"`
}

// NotificationRuleBaseLastRunStatus defines model for NotificationRuleBase.LastRunStatus.
type NotificationRuleBaseLastRunStatus string

// NotificationRuleDiscriminator defines model for NotificationRuleDiscriminator.
type NotificationRuleDiscriminator interface{}

// NotificationRuleUpdate defines model for NotificationRuleUpdate.
type NotificationRuleUpdate struct {
	Description *string                       `json:"description,omitempty"`
	Name        *string                       `json:"name,omitempty"`
	Status      *NotificationRuleUpdateStatus `json:"status,omitempty"`
}

// NotificationRuleUpdateStatus defines model for NotificationRuleUpdate.Status.
type NotificationRuleUpdateStatus string

// NotificationRules defines model for NotificationRules.
type NotificationRules struct {
	// URI pointers for additional paged results.
	Links             *Links              `json:"links,omitempty"`
	NotificationRules *[]NotificationRule `json:"notificationRules,omitempty"`
}

// Allows the declaration of an anonymous object within a declaration
type ObjectExpression struct {
	// Object properties
	Properties *[]Property `json:"properties,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// OnboardingRequest defines model for OnboardingRequest.
type OnboardingRequest struct {
	Bucket   string  `json:"bucket"`
	Org      string  `json:"org"`
	Password *string `json:"password,omitempty"`

	// Retention period *in nanoseconds* for the new bucket. This key's name has been misleading since OSS 2.0 GA, please transition to use `retentionPeriodSeconds`
	RetentionPeriodHrs     *int   `json:"retentionPeriodHrs,omitempty"`
	RetentionPeriodSeconds *int64 `json:"retentionPeriodSeconds,omitempty"`

	// Authentication token to set on the initial user. If not specified, the server will generate a token.
	Token    *string `json:"token,omitempty"`
	Username string  `json:"username"`
}

// OnboardingResponse defines model for OnboardingResponse.
type OnboardingResponse struct {
	Auth   *Authorization `json:"auth,omitempty"`
	Bucket *Bucket        `json:"bucket,omitempty"`
	Org    *Organization  `json:"org,omitempty"`
	User   *UserResponse  `json:"user,omitempty"`
}

// A single variable declaration
type OptionStatement struct {
	Assignment *interface{} `json:"assignment,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Organization defines model for Organization.
type Organization struct {
	CreatedAt   *time.Time `json:"createdAt,omitempty"`
	Description *string    `json:"description,omitempty"`
	Id          *string    `json:"id,omitempty"`
	Links       *struct {
		// URI of resource.
		Buckets *Link `json:"buckets,omitempty"`

		// URI of resource.
		Dashboards *Link `json:"dashboards,omitempty"`

		// URI of resource.
		Labels *Link `json:"labels,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Secrets *Link `json:"secrets,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`

		// URI of resource.
		Tasks *Link `json:"tasks,omitempty"`
	} `json:"links,omitempty"`
	Name string `json:"name"`

	// If inactive the organization is inactive.
	Status    *OrganizationStatus `json:"status,omitempty"`
	UpdatedAt *time.Time          `json:"updatedAt,omitempty"`
}

// If inactive the organization is inactive.
type OrganizationStatus string

// Organizations defines model for Organizations.
type Organizations struct {
	// URI pointers for additional paged results.
	Links *Links          `json:"links,omitempty"`
	Orgs  *[]Organization `json:"orgs,omitempty"`
}

// Represents a complete package source tree.
type Package struct {
	// Package files
	Files *[]File `json:"files,omitempty"`

	// Package name
	Package *string `json:"package,omitempty"`

	// Package import path
	Path *string `json:"path,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Defines a package identifier
type PackageClause struct {
	// A valid Flux identifier
	Name *Identifier `json:"name,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// PagerDutyNotificationEndpoint defines model for PagerDutyNotificationEndpoint.
type PagerDutyNotificationEndpoint struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationEndpointBase)
	NotificationEndpointBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ClientURL  *string `json:"clientURL,omitempty"`
	RoutingKey string  `json:"routingKey"`
}

// PagerDutyNotificationRule defines model for PagerDutyNotificationRule.
type PagerDutyNotificationRule struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationRuleBase)
	NotificationRuleBase `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/PagerDutyNotificationRuleBase)
	PagerDutyNotificationRuleBase `yaml:",inline"`
}

// PagerDutyNotificationRuleBase defines model for PagerDutyNotificationRuleBase.
type PagerDutyNotificationRuleBase struct {
	MessageTemplate string                            `json:"messageTemplate"`
	Type            PagerDutyNotificationRuleBaseType `json:"type"`
}

// PagerDutyNotificationRuleBaseType defines model for PagerDutyNotificationRuleBase.Type.
type PagerDutyNotificationRuleBaseType string

// Represents an expression wrapped in parenthesis
type ParenExpression struct {
	Expression *Expression `json:"expression,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// PasswordResetBody defines model for PasswordResetBody.
type PasswordResetBody struct {
	Password string `json:"password"`
}

// An object that contains updated bucket properties to apply.
type PatchBucketRequest struct {
	// A description of the bucket.
	Description *string `json:"description,omitempty"`

	// The name of the bucket.
	Name *string `json:"name,omitempty"`

	// Updates to rules to expire or retain data. No rules means no updates.
	RetentionRules *PatchRetentionRules `json:"retentionRules,omitempty"`
}

// PatchOrganizationRequest defines model for PatchOrganizationRequest.
type PatchOrganizationRequest struct {
	// New description to set on the organization
	Description *string `json:"description,omitempty"`

	// New name to set on the organization
	Name *string `json:"name,omitempty"`
}

// PatchRetentionRule defines model for PatchRetentionRule.
type PatchRetentionRule struct {
	// The number of seconds to keep data.
	// Default duration is `2592000` (30 days).
	// `0` represents infinite retention.
	EverySeconds int64 `json:"everySeconds"`

	// The [shard group duration](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#shard).
	// The number of seconds that each shard group covers.
	//
	// #### InfluxDB Cloud
	//
	// - Doesn't use `shardGroupDurationsSeconds`.
	//
	// #### InfluxDB OSS
	//
	// - Default value depends on the [bucket retention period](https://docs.influxdata.com/influxdb/v2.3/reference/internals/shards/#shard-group-duration).
	//
	// #### Related guides
	//
	// - InfluxDB [shards and shard groups](https://docs.influxdata.com/influxdb/v2.3/reference/internals/shards/)
	ShardGroupDurationSeconds *int64                  `json:"shardGroupDurationSeconds,omitempty"`
	Type                      *PatchRetentionRuleType `json:"type,omitempty"`
}

// PatchRetentionRuleType defines model for PatchRetentionRule.Type.
type PatchRetentionRuleType string

// Updates to rules to expire or retain data. No rules means no updates.
type PatchRetentionRules []PatchRetentionRule

// Permission defines model for Permission.
type Permission struct {
	Action   PermissionAction `json:"action"`
	Resource Resource         `json:"resource"`
}

// PermissionAction defines model for Permission.Action.
type PermissionAction string

// Call expression with pipe argument
type PipeExpression struct {
	Argument *Expression `json:"argument,omitempty"`

	// Represents a function call
	Call *CallExpression `json:"call,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Represents a specialized literal value, indicating the left hand value of a pipe expression
type PipeLiteral struct {
	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// PostBucketRequest defines model for PostBucketRequest.
type PostBucketRequest struct {
	// A description of the bucket.
	Description *string `json:"description,omitempty"`

	// The name of the bucket.
	Name string `json:"name"`

	// Organization ID.
	// The ID of the organization.
	OrgID string `json:"orgID"`

	// Retention rules to expire or retain data.
	// #### InfluxDB Cloud
	//
	// - `retentionRules` is required.
	//
	// #### InfluxDB OSS
	//
	// - `retentionRules` isn't required.
	RetentionRules *RetentionRules `json:"retentionRules,omitempty"`

	// Retention policy is an InfluxDB 1.x concept that represents the duration
	// of time that each data point in the retention policy persists. Use `rp`
	// for compatibility with InfluxDB 1.x.
	// The InfluxDB 2.x and Cloud equivalent is
	// [retention period](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#retention-period).
	Rp         *string     `json:"rp,omitempty"`
	SchemaType *SchemaType `json:"schemaType,omitempty"`
}

// PostCheck defines model for PostCheck.
type PostCheck struct {
	// Embedded struct due to allOf(#/components/schemas/CheckDiscriminator)
	CheckDiscriminator `yaml:",inline"`
}

// PostNotificationEndpoint defines model for PostNotificationEndpoint.
type PostNotificationEndpoint struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationEndpointDiscriminator)
	NotificationEndpointDiscriminator `yaml:",inline"`
}

// PostNotificationRule defines model for PostNotificationRule.
type PostNotificationRule struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationRuleDiscriminator)
	NotificationRuleDiscriminator `yaml:",inline"`
}

// PostOrganizationRequest defines model for PostOrganizationRequest.
type PostOrganizationRequest struct {
	Description *string `json:"description,omitempty"`
	Name        string  `json:"name"`
}

// The value associated with a key
type Property struct {
	Key *PropertyKey `json:"key,omitempty"`

	// Type of AST node
	Type  *NodeType   `json:"type,omitempty"`
	Value *Expression `json:"value,omitempty"`
}

// PropertyKey defines model for PropertyKey.
type PropertyKey interface{}

// Query InfluxDB with the Flux language
type Query struct {
	// Options for tabular data output.
	// Default output is [annotated CSV](https://docs.influxdata.com/influxdb/v2.3/reference/syntax/annotated-csv/#csv-response-format) with headers.
	//
	// For more information about tabular data **dialect**,
	// see [W3 metadata vocabulary for tabular data](https://www.w3.org/TR/2015/REC-tabular-metadata-20151217/#dialect-descriptions).
	Dialect *Dialect `json:"dialect,omitempty"`

	// Represents a source from a single file
	Extern *File `json:"extern,omitempty"`

	// Specifies the time that should be reported as `now` in the query.
	// Default is the server `now` time.
	Now *time.Time `json:"now,omitempty"`

	// Key-value pairs passed as parameters during query execution.
	//
	// To use parameters in your query, pass a _`query`_ with `params` references (in dot notation)--for example:
	//
	// ```json
	//   query: "from(bucket: params.mybucket) |> range(start: params.rangeStart) |> limit(n:1)"
	// ```
	//
	// and pass _`params`_ with the key-value pairs--for example:
	//
	// ```json
	//   params: {
	//     "mybucket": "environment",
	//     "rangeStart": "-30d"
	//   }
	// ```
	//
	// During query execution, InfluxDB passes _`params`_ to your script and substitutes the values.
	//
	// #### Limitations
	//
	// - If you use _`params`_, you can't use _`extern`_.
	Params *Query_Params `json:"params,omitempty"`

	// The query script to execute.
	Query string `json:"query"`

	// The type of query. Must be "flux".
	Type *QueryType `json:"type,omitempty"`
}

// The type of query. Must be "flux".
type QueryType string

// Key-value pairs passed as parameters during query execution.
//
// To use parameters in your query, pass a _`query`_ with `params` references (in dot notation)--for example:
//
// ```json
//   query: "from(bucket: params.mybucket) |> range(start: params.rangeStart) |> limit(n:1)"
// ```
//
// and pass _`params`_ with the key-value pairs--for example:
//
// ```json
//   params: {
//     "mybucket": "environment",
//     "rangeStart": "-30d"
//   }
// ```
//
// During query execution, InfluxDB passes _`params`_ to your script and substitutes the values.
//
// #### Limitations
//
// - If you use _`params`_, you can't use _`extern`_.
type Query_Params struct {
	AdditionalProperties map[string]interface{} `json:"-"`
}

// QueryEditMode defines model for QueryEditMode.
type QueryEditMode string

// QueryVariableProperties defines model for QueryVariableProperties.
type QueryVariableProperties struct {
	Type   *QueryVariablePropertiesType `json:"type,omitempty"`
	Values *struct {
		Language *string `json:"language,omitempty"`
		Query    *string `json:"query,omitempty"`
	} `json:"values,omitempty"`
}

// QueryVariablePropertiesType defines model for QueryVariableProperties.Type.
type QueryVariablePropertiesType string

// RangeThreshold defines model for RangeThreshold.
type RangeThreshold struct {
	// Embedded struct due to allOf(#/components/schemas/ThresholdBase)
	ThresholdBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Max    float32            `json:"max"`
	Min    float32            `json:"min"`
	Type   RangeThresholdType `json:"type"`
	Within bool               `json:"within"`
}

// RangeThresholdType defines model for RangeThreshold.Type.
type RangeThresholdType string

// Ready defines model for Ready.
type Ready struct {
	Started *time.Time   `json:"started,omitempty"`
	Status  *ReadyStatus `json:"status,omitempty"`
	Up      *string      `json:"up,omitempty"`
}

// ReadyStatus defines model for Ready.Status.
type ReadyStatus string

// Expressions begin and end with `/` and are regular expressions with syntax accepted by RE2
type RegexpLiteral struct {
	// Type of AST node
	Type  *NodeType `json:"type,omitempty"`
	Value *string   `json:"value,omitempty"`
}

// RemoteConnection defines model for RemoteConnection.
type RemoteConnection struct {
	AllowInsecureTLS bool    `json:"allowInsecureTLS"`
	Description      *string `json:"description,omitempty"`
	Id               string  `json:"id"`
	Name             string  `json:"name"`
	OrgID            string  `json:"orgID"`
	RemoteOrgID      string  `json:"remoteOrgID"`
	RemoteURL        string  `json:"remoteURL"`
}

// RemoteConnectionCreationRequest defines model for RemoteConnectionCreationRequest.
type RemoteConnectionCreationRequest struct {
	AllowInsecureTLS bool    `json:"allowInsecureTLS"`
	Description      *string `json:"description,omitempty"`
	Name             string  `json:"name"`
	OrgID            string  `json:"orgID"`
	RemoteAPIToken   string  `json:"remoteAPIToken"`
	RemoteOrgID      string  `json:"remoteOrgID"`
	RemoteURL        string  `json:"remoteURL"`
}

// RemoteConnectionUpdateRequest defines model for RemoteConnectionUpdateRequest.
type RemoteConnectionUpdateRequest struct {
	AllowInsecureTLS *bool   `json:"allowInsecureTLS,omitempty"`
	Description      *string `json:"description,omitempty"`
	Name             *string `json:"name,omitempty"`
	RemoteAPIToken   *string `json:"remoteAPIToken,omitempty"`
	RemoteOrgID      *string `json:"remoteOrgID,omitempty"`
	RemoteURL        *string `json:"remoteURL,omitempty"`
}

// RemoteConnections defines model for RemoteConnections.
type RemoteConnections struct {
	Remotes *[]RemoteConnection `json:"remotes,omitempty"`
}

// Describes a field that can be renamed and made visible or invisible.
type RenamableField struct {
	// The name that a field is renamed to by the user.
	DisplayName *string `json:"displayName,omitempty"`

	// The calculated name of a field.
	InternalName *string `json:"internalName,omitempty"`

	// Indicates whether this field should be visible on the table.
	Visible *bool `json:"visible,omitempty"`
}

// Replication defines model for Replication.
type Replication struct {
	CurrentQueueSizeBytes int64   `json:"currentQueueSizeBytes"`
	Description           *string `json:"description,omitempty"`
	DropNonRetryableData  *bool   `json:"dropNonRetryableData,omitempty"`
	Id                    string  `json:"id"`
	LatestErrorMessage    *string `json:"latestErrorMessage,omitempty"`
	LatestResponseCode    *int    `json:"latestResponseCode,omitempty"`
	LocalBucketID         string  `json:"localBucketID"`
	MaxQueueSizeBytes     int64   `json:"maxQueueSizeBytes"`
	Name                  string  `json:"name"`
	OrgID                 string  `json:"orgID"`
	RemoteBucketID        *string `json:"remoteBucketID,omitempty"`
	RemoteBucketName      *string `json:"remoteBucketName,omitempty"`
	RemoteID              string  `json:"remoteID"`
}

// ReplicationCreationRequest defines model for ReplicationCreationRequest.
type ReplicationCreationRequest struct {
	Description          *string `json:"description,omitempty"`
	DropNonRetryableData *bool   `json:"dropNonRetryableData,omitempty"`
	LocalBucketID        string  `json:"localBucketID"`
	MaxAgeSeconds        int64   `json:"maxAgeSeconds"`
	MaxQueueSizeBytes    int64   `json:"maxQueueSizeBytes"`
	Name                 string  `json:"name"`
	OrgID                string  `json:"orgID"`
	RemoteBucketID       *string `json:"remoteBucketID,omitempty"`
	RemoteBucketName     *string `json:"remoteBucketName,omitempty"`
	RemoteID             string  `json:"remoteID"`
}

// ReplicationUpdateRequest defines model for ReplicationUpdateRequest.
type ReplicationUpdateRequest struct {
	Description          *string `json:"description,omitempty"`
	DropNonRetryableData *bool   `json:"dropNonRetryableData,omitempty"`
	MaxAgeSeconds        *int64  `json:"maxAgeSeconds,omitempty"`
	MaxQueueSizeBytes    *int64  `json:"maxQueueSizeBytes,omitempty"`
	Name                 *string `json:"name,omitempty"`
	RemoteBucketID       *string `json:"remoteBucketID,omitempty"`
	RemoteBucketName     *string `json:"remoteBucketName,omitempty"`
	RemoteID             *string `json:"remoteID,omitempty"`
}

// Replications defines model for Replications.
type Replications struct {
	Replications *[]Replication `json:"replications,omitempty"`
}

// Resource defines model for Resource.
type Resource struct {
	// The ID of a specific resource.
	// In a `permission`, applies the permission to only the resource with this ID.
	Id *string `json:"id,omitempty"`

	// Optional: A name for the resource.
	// Not all resource types have a name field.
	Name *string `json:"name,omitempty"`

	// Optional: The name of the organization with `orgID`.
	Org *string `json:"org,omitempty"`

	// The ID of the organization that owns the resource.
	// In a `permission`, applies the permission to all resources of `type` owned by this organization.
	OrgID *string `json:"orgID,omitempty"`

	// The type of resource.
	// In a `permission`, applies the permission to all resources of this type.
	Type ResourceType `json:"type"`
}

// The type of resource.
// In a `permission`, applies the permission to all resources of this type.
type ResourceType string

// ResourceMember defines model for ResourceMember.
type ResourceMember struct {
	// Embedded struct due to allOf(#/components/schemas/UserResponse)
	UserResponse `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Role *ResourceMemberRole `json:"role,omitempty"`
}

// ResourceMemberRole defines model for ResourceMember.Role.
type ResourceMemberRole string

// ResourceMembers defines model for ResourceMembers.
type ResourceMembers struct {
	Links *struct {
		Self *string `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Users *[]ResourceMember `json:"users,omitempty"`
}

// ResourceOwner defines model for ResourceOwner.
type ResourceOwner struct {
	// Embedded struct due to allOf(#/components/schemas/UserResponse)
	UserResponse `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Role *ResourceOwnerRole `json:"role,omitempty"`
}

// ResourceOwnerRole defines model for ResourceOwner.Role.
type ResourceOwnerRole string

// ResourceOwners defines model for ResourceOwners.
type ResourceOwners struct {
	Links *struct {
		Self *string `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Users *[]ResourceOwner `json:"users,omitempty"`
}

// RestoredBucketMappings defines model for RestoredBucketMappings.
type RestoredBucketMappings struct {
	// New ID of the restored bucket
	Id            string              `json:"id"`
	Name          string              `json:"name"`
	ShardMappings BucketShardMappings `json:"shardMappings"`
}

// RetentionPolicyManifest defines model for RetentionPolicyManifest.
type RetentionPolicyManifest struct {
	Duration           int64                 `json:"duration"`
	Name               string                `json:"name"`
	ReplicaN           int                   `json:"replicaN"`
	ShardGroupDuration int64                 `json:"shardGroupDuration"`
	ShardGroups        ShardGroupManifests   `json:"shardGroups"`
	Subscriptions      SubscriptionManifests `json:"subscriptions"`
}

// RetentionPolicyManifests defines model for RetentionPolicyManifests.
type RetentionPolicyManifests []RetentionPolicyManifest

// RetentionRule defines model for RetentionRule.
type RetentionRule struct {
	// The duration in seconds for how long data will be kept in the database.
	// The default duration is 2592000 (30 days).
	// 0 represents infinite retention.
	EverySeconds int64 `json:"everySeconds"`

	// The shard group duration.
	// The duration or interval (in seconds) that each shard group covers.
	//
	// #### InfluxDB Cloud
	//
	// - Does not use `shardGroupDurationsSeconds`.
	//
	// #### InfluxDB OSS
	//
	// - Default value depends on the
	// [bucket retention period](https://docs.influxdata.com/influxdb/v2.3/v2.3/reference/internals/shards/#shard-group-duration).
	ShardGroupDurationSeconds *int64             `json:"shardGroupDurationSeconds,omitempty"`
	Type                      *RetentionRuleType `json:"type,omitempty"`
}

// RetentionRuleType defines model for RetentionRule.Type.
type RetentionRuleType string

// Retention rules to expire or retain data.
// #### InfluxDB Cloud
//
// - `retentionRules` is required.
//
// #### InfluxDB OSS
//
// - `retentionRules` isn't required.
type RetentionRules []RetentionRule

// Defines an expression to return
type ReturnStatement struct {
	Argument *Expression `json:"argument,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Routes defines model for Routes.
type Routes struct {
	Authorizations *string `json:"authorizations,omitempty"`
	Buckets        *string `json:"buckets,omitempty"`
	Dashboards     *string `json:"dashboards,omitempty"`
	External       *struct {
		StatusFeed *string `json:"statusFeed,omitempty"`
	} `json:"external,omitempty"`
	Flags *string `json:"flags,omitempty"`
	Me    *string `json:"me,omitempty"`
	Orgs  *string `json:"orgs,omitempty"`
	Query *struct {
		Analyze     *string `json:"analyze,omitempty"`
		Ast         *string `json:"ast,omitempty"`
		Self        *string `json:"self,omitempty"`
		Suggestions *string `json:"suggestions,omitempty"`
	} `json:"query,omitempty"`
	Setup   *string `json:"setup,omitempty"`
	Signin  *string `json:"signin,omitempty"`
	Signout *string `json:"signout,omitempty"`
	Sources *string `json:"sources,omitempty"`
	System  *struct {
		Debug   *string `json:"debug,omitempty"`
		Health  *string `json:"health,omitempty"`
		Metrics *string `json:"metrics,omitempty"`
	} `json:"system,omitempty"`
	Tasks     *string `json:"tasks,omitempty"`
	Telegrafs *string `json:"telegrafs,omitempty"`
	Users     *string `json:"users,omitempty"`
	Variables *string `json:"variables,omitempty"`
	Write     *string `json:"write,omitempty"`
}

// The state to record if check matches a criteria.
type RuleStatusLevel string

// Run defines model for Run.
type Run struct {
	// The time ([RFC3339Nano date/time format](https://go.dev/src/time/format.go)) the run finished executing.
	FinishedAt *time.Time `json:"finishedAt,omitempty"`

	// Flux used for the task
	Flux  *string `json:"flux,omitempty"`
	Id    *string `json:"id,omitempty"`
	Links *struct {
		Retry *string `json:"retry,omitempty"`
		Self  *string `json:"self,omitempty"`
		Task  *string `json:"task,omitempty"`
	} `json:"links,omitempty"`

	// An array of logs associated with the run.
	Log *[]LogEvent `json:"log,omitempty"`

	// The time ([RFC3339Nano date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339nano-timestamp)) the run was manually requested.
	RequestedAt *time.Time `json:"requestedAt,omitempty"`

	// The time [RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp) used for the run's `now` option.
	ScheduledFor *time.Time `json:"scheduledFor,omitempty"`

	// The time ([RFC3339Nano date/time format](https://go.dev/src/time/format.go)) the run started executing.
	StartedAt *time.Time `json:"startedAt,omitempty"`
	Status    *RunStatus `json:"status,omitempty"`
	TaskID    *string    `json:"taskID,omitempty"`
}

// RunStatus defines model for Run.Status.
type RunStatus string

// RunManually defines model for RunManually.
type RunManually struct {
	// The time [RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)
	// used for the run's `now` option.
	// Default is the server _now_ time.
	ScheduledFor *time.Time `json:"scheduledFor"`
}

// Runs defines model for Runs.
type Runs struct {
	// URI pointers for additional paged results.
	Links *Links `json:"links,omitempty"`
	Runs  *[]Run `json:"runs,omitempty"`
}

// SMTPNotificationRule defines model for SMTPNotificationRule.
type SMTPNotificationRule struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationRuleBase)
	NotificationRuleBase `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/SMTPNotificationRuleBase)
	SMTPNotificationRuleBase `yaml:",inline"`
}

// SMTPNotificationRuleBase defines model for SMTPNotificationRuleBase.
type SMTPNotificationRuleBase struct {
	BodyTemplate    *string                      `json:"bodyTemplate,omitempty"`
	SubjectTemplate string                       `json:"subjectTemplate"`
	To              string                       `json:"to"`
	Type            SMTPNotificationRuleBaseType `json:"type"`
}

// SMTPNotificationRuleBaseType defines model for SMTPNotificationRuleBase.Type.
type SMTPNotificationRuleBaseType string

// ScatterViewProperties defines model for ScatterViewProperties.
type ScatterViewProperties struct {
	AdaptiveZoomHide *bool `json:"adaptiveZoomHide,omitempty"`

	// Colors define color encoding of data into a visualization
	Colors                     []string                   `json:"colors"`
	FillColumns                []string                   `json:"fillColumns"`
	GenerateXAxisTicks         *[]string                  `json:"generateXAxisTicks,omitempty"`
	GenerateYAxisTicks         *[]string                  `json:"generateYAxisTicks,omitempty"`
	LegendColorizeRows         *bool                      `json:"legendColorizeRows,omitempty"`
	LegendHide                 *bool                      `json:"legendHide,omitempty"`
	LegendOpacity              *float32                   `json:"legendOpacity,omitempty"`
	LegendOrientationThreshold *int                       `json:"legendOrientationThreshold,omitempty"`
	Note                       string                     `json:"note"`
	Queries                    []DashboardQuery           `json:"queries"`
	Shape                      ScatterViewPropertiesShape `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool                      `json:"showNoteWhenEmpty"`
	SymbolColumns     []string                  `json:"symbolColumns"`
	TimeFormat        *string                   `json:"timeFormat,omitempty"`
	Type              ScatterViewPropertiesType `json:"type"`
	XAxisLabel        string                    `json:"xAxisLabel"`
	XColumn           string                    `json:"xColumn"`
	XDomain           []float32                 `json:"xDomain"`
	XPrefix           string                    `json:"xPrefix"`
	XSuffix           string                    `json:"xSuffix"`
	XTickStart        *float32                  `json:"xTickStart,omitempty"`
	XTickStep         *float32                  `json:"xTickStep,omitempty"`
	XTotalTicks       *int                      `json:"xTotalTicks,omitempty"`
	YAxisLabel        string                    `json:"yAxisLabel"`
	YColumn           string                    `json:"yColumn"`
	YDomain           []float32                 `json:"yDomain"`
	YPrefix           string                    `json:"yPrefix"`
	YSuffix           string                    `json:"ySuffix"`
	YTickStart        *float32                  `json:"yTickStart,omitempty"`
	YTickStep         *float32                  `json:"yTickStep,omitempty"`
	YTotalTicks       *int                      `json:"yTotalTicks,omitempty"`
}

// ScatterViewPropertiesShape defines model for ScatterViewProperties.Shape.
type ScatterViewPropertiesShape string

// ScatterViewPropertiesType defines model for ScatterViewProperties.Type.
type ScatterViewPropertiesType string

// SchemaType defines model for SchemaType.
type SchemaType string

// ScraperTargetRequest defines model for ScraperTargetRequest.
type ScraperTargetRequest struct {
	// Skip TLS verification on endpoint.
	AllowInsecure *bool `json:"allowInsecure,omitempty"`

	// The ID of the bucket to write to.
	BucketID *string `json:"bucketID,omitempty"`

	// The name of the scraper target.
	Name *string `json:"name,omitempty"`

	// The organization ID.
	OrgID *string `json:"orgID,omitempty"`

	// The type of the metrics to be parsed.
	Type *ScraperTargetRequestType `json:"type,omitempty"`

	// The URL of the metrics endpoint.
	Url *string `json:"url,omitempty"`
}

// The type of the metrics to be parsed.
type ScraperTargetRequestType string

// ScraperTargetResponse defines model for ScraperTargetResponse.
type ScraperTargetResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ScraperTargetRequest)
	ScraperTargetRequest `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// The bucket name.
	Bucket *string `json:"bucket,omitempty"`
	Id     *string `json:"id,omitempty"`
	Links  *struct {
		// URI of resource.
		Bucket *Link `json:"bucket,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Organization *Link `json:"organization,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`
	} `json:"links,omitempty"`

	// The name of the organization.
	Org *string `json:"org,omitempty"`
}

// ScraperTargetResponses defines model for ScraperTargetResponses.
type ScraperTargetResponses struct {
	Configurations *[]ScraperTargetResponse `json:"configurations,omitempty"`
}

// SecretKeys defines model for SecretKeys.
type SecretKeys struct {
	Secrets *[]string `json:"secrets,omitempty"`
}

// SecretKeysResponse defines model for SecretKeysResponse.
type SecretKeysResponse struct {
	// Embedded struct due to allOf(#/components/schemas/SecretKeys)
	SecretKeys `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Links *struct {
		Org  *string `json:"org,omitempty"`
		Self *string `json:"self,omitempty"`
	} `json:"links,omitempty"`
}

// Secrets defines model for Secrets.
type Secrets struct {
	AdditionalProperties map[string]string `json:"-"`
}

// ShardGroupManifest defines model for ShardGroupManifest.
type ShardGroupManifest struct {
	DeletedAt   *time.Time     `json:"deletedAt,omitempty"`
	EndTime     time.Time      `json:"endTime"`
	Id          int64          `json:"id"`
	Shards      ShardManifests `json:"shards"`
	StartTime   time.Time      `json:"startTime"`
	TruncatedAt *time.Time     `json:"truncatedAt,omitempty"`
}

// ShardGroupManifests defines model for ShardGroupManifests.
type ShardGroupManifests []ShardGroupManifest

// ShardManifest defines model for ShardManifest.
type ShardManifest struct {
	Id          int64       `json:"id"`
	ShardOwners ShardOwners `json:"shardOwners"`
}

// ShardManifests defines model for ShardManifests.
type ShardManifests []ShardManifest

// ShardOwner defines model for ShardOwner.
type ShardOwner struct {
	// The ID of the node that owns the shard.
	NodeID int64 `json:"nodeID"`
}

// ShardOwners defines model for ShardOwners.
type ShardOwners []ShardOwner

// SimpleTableViewProperties defines model for SimpleTableViewProperties.
type SimpleTableViewProperties struct {
	Note    string                         `json:"note"`
	Queries []DashboardQuery               `json:"queries"`
	Shape   SimpleTableViewPropertiesShape `json:"shape"`
	ShowAll bool                           `json:"showAll"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool                          `json:"showNoteWhenEmpty"`
	Type              SimpleTableViewPropertiesType `json:"type"`
}

// SimpleTableViewPropertiesShape defines model for SimpleTableViewProperties.Shape.
type SimpleTableViewPropertiesShape string

// SimpleTableViewPropertiesType defines model for SimpleTableViewProperties.Type.
type SimpleTableViewPropertiesType string

// SingleStatViewProperties defines model for SingleStatViewProperties.
type SingleStatViewProperties struct {
	// Colors define color encoding of data into a visualization
	Colors []DashboardColor `json:"colors"`

	// Indicates whether decimal places should be enforced, and how many digits it should show.
	DecimalPlaces DecimalPlaces                 `json:"decimalPlaces"`
	Note          string                        `json:"note"`
	Prefix        string                        `json:"prefix"`
	Queries       []DashboardQuery              `json:"queries"`
	Shape         SingleStatViewPropertiesShape `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool `json:"showNoteWhenEmpty"`

	// StaticLegend represents the options specific to the static legend
	StaticLegend *StaticLegend                `json:"staticLegend,omitempty"`
	Suffix       string                       `json:"suffix"`
	TickPrefix   string                       `json:"tickPrefix"`
	TickSuffix   string                       `json:"tickSuffix"`
	Type         SingleStatViewPropertiesType `json:"type"`
}

// SingleStatViewPropertiesShape defines model for SingleStatViewProperties.Shape.
type SingleStatViewPropertiesShape string

// SingleStatViewPropertiesType defines model for SingleStatViewProperties.Type.
type SingleStatViewPropertiesType string

// SlackNotificationEndpoint defines model for SlackNotificationEndpoint.
type SlackNotificationEndpoint struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationEndpointBase)
	NotificationEndpointBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// Specifies the API token string. Specify either `URL` or `Token`.
	Token *string `json:"token,omitempty"`

	// Specifies the URL of the Slack endpoint. Specify either `URL` or `Token`.
	Url *string `json:"url,omitempty"`
}

// SlackNotificationRule defines model for SlackNotificationRule.
type SlackNotificationRule struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationRuleBase)
	NotificationRuleBase `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/SlackNotificationRuleBase)
	SlackNotificationRuleBase `yaml:",inline"`
}

// SlackNotificationRuleBase defines model for SlackNotificationRuleBase.
type SlackNotificationRuleBase struct {
	Channel         *string                       `json:"channel,omitempty"`
	MessageTemplate string                        `json:"messageTemplate"`
	Type            SlackNotificationRuleBaseType `json:"type"`
}

// SlackNotificationRuleBaseType defines model for SlackNotificationRuleBase.Type.
type SlackNotificationRuleBaseType string

// Source defines model for Source.
type Source struct {
	Default            *bool              `json:"default,omitempty"`
	DefaultRP          *string            `json:"defaultRP,omitempty"`
	Id                 *string            `json:"id,omitempty"`
	InsecureSkipVerify *bool              `json:"insecureSkipVerify,omitempty"`
	Languages          *[]SourceLanguages `json:"languages,omitempty"`
	Links              *struct {
		Buckets *string `json:"buckets,omitempty"`
		Health  *string `json:"health,omitempty"`
		Query   *string `json:"query,omitempty"`
		Self    *string `json:"self,omitempty"`
	} `json:"links,omitempty"`
	MetaUrl      *string     `json:"metaUrl,omitempty"`
	Name         *string     `json:"name,omitempty"`
	OrgID        *string     `json:"orgID,omitempty"`
	Password     *string     `json:"password,omitempty"`
	SharedSecret *string     `json:"sharedSecret,omitempty"`
	Telegraf     *string     `json:"telegraf,omitempty"`
	Token        *string     `json:"token,omitempty"`
	Type         *SourceType `json:"type,omitempty"`
	Url          *string     `json:"url,omitempty"`
	Username     *string     `json:"username,omitempty"`
}

// SourceLanguages defines model for Source.Languages.
type SourceLanguages string

// SourceType defines model for Source.Type.
type SourceType string

// Sources defines model for Sources.
type Sources struct {
	Links *struct {
		Self *string `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Sources *[]Source `json:"sources,omitempty"`
}

// Stack defines model for Stack.
type Stack struct {
	CreatedAt *time.Time `json:"createdAt,omitempty"`
	Events    *[]struct {
		Description *string `json:"description,omitempty"`
		EventType   *string `json:"eventType,omitempty"`
		Name        *string `json:"name,omitempty"`
		Resources   *[]struct {
			ApiVersion   *string `json:"apiVersion,omitempty"`
			Associations *[]struct {
				Kind     *TemplateKind `json:"kind,omitempty"`
				MetaName *string       `json:"metaName,omitempty"`
			} `json:"associations,omitempty"`
			Kind  *TemplateKind `json:"kind,omitempty"`
			Links *struct {
				Self *string `json:"self,omitempty"`
			} `json:"links,omitempty"`
			ResourceID       *string `json:"resourceID,omitempty"`
			TemplateMetaName *string `json:"templateMetaName,omitempty"`
		} `json:"resources,omitempty"`
		Sources   *[]string  `json:"sources,omitempty"`
		UpdatedAt *time.Time `json:"updatedAt,omitempty"`
		Urls      *[]string  `json:"urls,omitempty"`
	} `json:"events,omitempty"`
	Id    *string `json:"id,omitempty"`
	OrgID *string `json:"orgID,omitempty"`
}

// Statement defines model for Statement.
type Statement interface{}

// StaticLegend represents the options specific to the static legend
type StaticLegend struct {
	ColorizeRows         *bool    `json:"colorizeRows,omitempty"`
	HeightRatio          *float32 `json:"heightRatio,omitempty"`
	Opacity              *float32 `json:"opacity,omitempty"`
	OrientationThreshold *int     `json:"orientationThreshold,omitempty"`
	Show                 *bool    `json:"show,omitempty"`
	ValueAxis            *string  `json:"valueAxis,omitempty"`
	WidthRatio           *float32 `json:"widthRatio,omitempty"`
}

// StatusRule defines model for StatusRule.
type StatusRule struct {
	Count *int `json:"count,omitempty"`

	// The state to record if check matches a criteria.
	CurrentLevel *RuleStatusLevel `json:"currentLevel,omitempty"`
	Period       *string          `json:"period,omitempty"`

	// The state to record if check matches a criteria.
	PreviousLevel *RuleStatusLevel `json:"previousLevel,omitempty"`
}

// Expressions begin and end with double quote marks
type StringLiteral struct {
	// Type of AST node
	Type  *NodeType `json:"type,omitempty"`
	Value *string   `json:"value,omitempty"`
}

// SubscriptionManifest defines model for SubscriptionManifest.
type SubscriptionManifest struct {
	Destinations []string `json:"destinations"`
	Mode         string   `json:"mode"`
	Name         string   `json:"name"`
}

// SubscriptionManifests defines model for SubscriptionManifests.
type SubscriptionManifests []SubscriptionManifest

// TableViewProperties defines model for TableViewProperties.
type TableViewProperties struct {
	// Colors define color encoding of data into a visualization
	Colors []DashboardColor `json:"colors"`

	// Indicates whether decimal places should be enforced, and how many digits it should show.
	DecimalPlaces DecimalPlaces `json:"decimalPlaces"`

	// fieldOptions represent the fields retrieved by the query with customization options
	FieldOptions []RenamableField         `json:"fieldOptions"`
	Note         string                   `json:"note"`
	Queries      []DashboardQuery         `json:"queries"`
	Shape        TableViewPropertiesShape `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool `json:"showNoteWhenEmpty"`
	TableOptions      struct {
		// fixFirstColumn indicates whether the first column of the table should be locked
		FixFirstColumn *bool `json:"fixFirstColumn,omitempty"`

		// Describes a field that can be renamed and made visible or invisible.
		SortBy *RenamableField `json:"sortBy,omitempty"`

		// verticalTimeAxis describes the orientation of the table by indicating whether the time axis will be displayed vertically
		VerticalTimeAxis *bool `json:"verticalTimeAxis,omitempty"`

		// Wrapping describes the text wrapping style to be used in table views
		Wrapping *TableViewPropertiesTableOptionsWrapping `json:"wrapping,omitempty"`
	} `json:"tableOptions"`

	// timeFormat describes the display format for time values according to moment.js date formatting
	TimeFormat string                  `json:"timeFormat"`
	Type       TableViewPropertiesType `json:"type"`
}

// TableViewPropertiesShape defines model for TableViewProperties.Shape.
type TableViewPropertiesShape string

// Wrapping describes the text wrapping style to be used in table views
type TableViewPropertiesTableOptionsWrapping string

// TableViewPropertiesType defines model for TableViewProperties.Type.
type TableViewPropertiesType string

// TagRule defines model for TagRule.
type TagRule struct {
	Key      *string          `json:"key,omitempty"`
	Operator *TagRuleOperator `json:"operator,omitempty"`
	Value    *string          `json:"value,omitempty"`
}

// TagRuleOperator defines model for TagRule.Operator.
type TagRuleOperator string

// Task defines model for Task.
type Task struct {
	// The ID of the authorization used when the task communicates with the query engine.
	AuthorizationID *string    `json:"authorizationID,omitempty"`
	CreatedAt       *time.Time `json:"createdAt,omitempty"`

	// [Cron expression](https://en.wikipedia.org/wiki/Cron#Overview) that defines the schedule on which the task runs. InfluxDB bases cron runs on the system time.
	Cron *string `json:"cron,omitempty"`

	// The description of the task.
	Description *string `json:"description,omitempty"`

	// An interval ([duration literal](https://docs.influxdata.com/flux/v0.x/spec/lexical-elements/#duration-literals))) at which the task runs. `every` also determines when the task first runs, depending on the specified time.
	Every *string `json:"every,omitempty"`

	// The Flux script that the task runs.
	Flux          string             `json:"flux"`
	Id            string             `json:"id"`
	Labels        *Labels            `json:"labels,omitempty"`
	LastRunError  *string            `json:"lastRunError,omitempty"`
	LastRunStatus *TaskLastRunStatus `json:"lastRunStatus,omitempty"`

	// A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/flux/v0.x/data-types/basic/time/#time-syntax)) of the latest scheduled and completed run.
	LatestCompleted *time.Time `json:"latestCompleted,omitempty"`
	Links           *struct {
		// URI of resource.
		Labels *Link `json:"labels,omitempty"`

		// URI of resource.
		Logs *Link `json:"logs,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Runs *Link `json:"runs,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`
	} `json:"links,omitempty"`

	// The name of the task.
	Name string `json:"name"`

	// A [duration](https://docs.influxdata.com/flux/v0.x/spec/lexical-elements/#duration-literals) to delay execution of the task after the scheduled time has elapsed. `0` removes the offset.
	Offset *string `json:"offset,omitempty"`

	// The name of the organization that owns the task.
	Org *string `json:"org,omitempty"`

	// The ID of the organization that owns the task.
	OrgID string `json:"orgID"`

	// The ID of the user who owns the Task.
	OwnerID *string `json:"ownerID,omitempty"`

	// `inactive` cancels scheduled runs and prevents manual runs of the task.
	Status    *TaskStatusType `json:"status,omitempty"`
	UpdatedAt *time.Time      `json:"updatedAt,omitempty"`
}

// TaskLastRunStatus defines model for Task.LastRunStatus.
type TaskLastRunStatus string

// TaskCreateRequest defines model for TaskCreateRequest.
type TaskCreateRequest struct {
	// An optional description of the task.
	Description *string `json:"description,omitempty"`

	// The Flux script to run for this task.
	Flux string `json:"flux"`

	// The name of the organization that owns this Task.
	Org *string `json:"org,omitempty"`

	// The ID of the organization that owns this Task.
	OrgID *string `json:"orgID,omitempty"`

	// `inactive` cancels scheduled runs and prevents manual runs of the task.
	Status *TaskStatusType `json:"status,omitempty"`
}

// `inactive` cancels scheduled runs and prevents manual runs of the task.
type TaskStatusType string

// TaskUpdateRequest defines model for TaskUpdateRequest.
type TaskUpdateRequest struct {
	// Update the 'cron' option in the flux script.
	Cron *string `json:"cron,omitempty"`

	// Update the description of the task.
	Description *string `json:"description,omitempty"`

	// Update the 'every' option in the flux script.
	Every *string `json:"every,omitempty"`

	// The Flux script that the task runs.
	Flux *string `json:"flux,omitempty"`

	// Update the 'name' option in the flux script.
	Name *string `json:"name,omitempty"`

	// Update the 'offset' option in the flux script.
	Offset *string `json:"offset,omitempty"`

	// `inactive` cancels scheduled runs and prevents manual runs of the task.
	Status *TaskStatusType `json:"status,omitempty"`
}

// Tasks defines model for Tasks.
type Tasks struct {
	// URI pointers for additional paged results.
	Links *Links  `json:"links,omitempty"`
	Tasks *[]Task `json:"tasks,omitempty"`
}

// Telegraf defines model for Telegraf.
type Telegraf struct {
	// Embedded struct due to allOf(#/components/schemas/TelegrafRequest)
	TelegrafRequest `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id     *string `json:"id,omitempty"`
	Labels *Labels `json:"labels,omitempty"`
	Links  *struct {
		// URI of resource.
		Labels *Link `json:"labels,omitempty"`

		// URI of resource.
		Members *Link `json:"members,omitempty"`

		// URI of resource.
		Owners *Link `json:"owners,omitempty"`

		// URI of resource.
		Self *Link `json:"self,omitempty"`
	} `json:"links,omitempty"`
}

// TelegrafPlugin defines model for TelegrafPlugin.
type TelegrafPlugin struct {
	Config      *string `json:"config,omitempty"`
	Description *string `json:"description,omitempty"`
	Name        *string `json:"name,omitempty"`
	Type        *string `json:"type,omitempty"`
}

// TelegrafPluginRequest defines model for TelegrafPluginRequest.
type TelegrafPluginRequest struct {
	Config      *string `json:"config,omitempty"`
	Description *string `json:"description,omitempty"`
	Metadata    *struct {
		Buckets *[]string `json:"buckets,omitempty"`
	} `json:"metadata,omitempty"`
	Name    *string `json:"name,omitempty"`
	OrgID   *string `json:"orgID,omitempty"`
	Plugins *[]struct {
		Alias       *string `json:"alias,omitempty"`
		Config      *string `json:"config,omitempty"`
		Description *string `json:"description,omitempty"`
		Name        *string `json:"name,omitempty"`
		Type        *string `json:"type,omitempty"`
	} `json:"plugins,omitempty"`
}

// TelegrafPlugins defines model for TelegrafPlugins.
type TelegrafPlugins struct {
	Os      *string           `json:"os,omitempty"`
	Plugins *[]TelegrafPlugin `json:"plugins,omitempty"`
	Version *string           `json:"version,omitempty"`
}

// TelegrafRequest defines model for TelegrafRequest.
type TelegrafRequest struct {
	Config      *string `json:"config,omitempty"`
	Description *string `json:"description,omitempty"`
	Metadata    *struct {
		Buckets *[]string `json:"buckets,omitempty"`
	} `json:"metadata,omitempty"`
	Name  *string `json:"name,omitempty"`
	OrgID *string `json:"orgID,omitempty"`
}

// Telegrafs defines model for Telegrafs.
type Telegrafs struct {
	Configurations *[]Telegraf `json:"configurations,omitempty"`
}

// TelegramNotificationEndpoint defines model for TelegramNotificationEndpoint.
type TelegramNotificationEndpoint struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationEndpointBase)
	NotificationEndpointBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// The ID of the telegram channel; a chat_id in https://core.telegram.org/bots/api#sendmessage .
	Channel string `json:"channel"`

	// Specifies the Telegram bot token. See https://core.telegram.org/bots#creating-a-new-bot .
	Token string `json:"token"`
}

// TelegramNotificationRule defines model for TelegramNotificationRule.
type TelegramNotificationRule struct {
	// Embedded struct due to allOf(#/components/schemas/NotificationRuleBase)
	NotificationRuleBase `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/TelegramNotificationRuleBase)
	TelegramNotificationRuleBase `yaml:",inline"`
}

// TelegramNotificationRuleBase defines model for TelegramNotificationRuleBase.
type TelegramNotificationRuleBase struct {
	// Disables preview of web links in the sent messages when "true". Defaults to "false".
	DisableWebPagePreview *bool `json:"disableWebPagePreview,omitempty"`

	// The message template as a flux interpolated string.
	MessageTemplate string `json:"messageTemplate"`

	// Parse mode of the message text per https://core.telegram.org/bots/api#formatting-options. Defaults to "MarkdownV2".
	ParseMode *TelegramNotificationRuleBaseParseMode `json:"parseMode,omitempty"`

	// The discriminator between other types of notification rules is "telegram".
	Type TelegramNotificationRuleBaseType `json:"type"`
}

// Parse mode of the message text per https://core.telegram.org/bots/api#formatting-options. Defaults to "MarkdownV2".
type TelegramNotificationRuleBaseParseMode string

// The discriminator between other types of notification rules is "telegram".
type TelegramNotificationRuleBaseType string

// Template defines model for Template.
type Template []struct {
	ApiVersion *string       `json:"apiVersion,omitempty"`
	Kind       *TemplateKind `json:"kind,omitempty"`

	// Metadata properties used for the resource when the template is applied.
	Metadata *struct {
		Name *string `json:"name,omitempty"`
	} `json:"metadata,omitempty"`

	// Configuration properties used for the resource when the template is applied.
	// Key-value pairs map to the specification for the resource.
	//
	// The following code samples show `spec` configurations for template resources:
	//
	// - A bucket:
	//
	//   ```json
	//   { "spec": {
	//       "name": "iot_center",
	//       "retentionRules": [{
	//           "everySeconds": 2.592e+06,
	//           "type": "expire"
	//         }]
	//     }
	//   }
	//   ```
	//
	// - A variable:
	//
	//   ```json
	//   { "spec": {
	//       "language": "flux",
	//       "name": "Node_Service",
	//       "query": "import \"influxdata/influxdb/v1\"\r\nv1.tagValues(bucket: \"iot_center\",
	//           tag: \"service\")",
	//       "type": "query"
	//     }
	//   }
	//   ```
	Spec *map[string]interface{} `json:"spec,omitempty"`
}

// TemplateApply defines model for TemplateApply.
type TemplateApply struct {
	// A list of `action` objects.
	// Actions let you customize how InfluxDB applies templates in the request.
	//
	// You can use the following actions to prevent creating or updating resources:
	//
	// - A `skipKind` action skips template resources of a specified `kind`.
	// - A `skipResource` action skips template resources with a specified `metadata.name`
	//   and `kind`.
	Actions *[]interface{} `json:"actions,omitempty"`

	// Only applies a dry run of the templates passed in the request.
	//
	// - Validates the template and generates a resource diff and summary.
	// - Doesn't install templates or make changes to the InfluxDB instance.
	DryRun *bool `json:"dryRun,omitempty"`

	// An object with key-value pairs that map to **environment references** in templates.
	//
	// Environment references in templates are `envRef` objects with an `envRef.key`
	// property.
	// To substitute a custom environment reference value when applying templates,
	// pass `envRefs` with the `envRef.key` and the value.
	//
	// When you apply a template, InfluxDB replaces `envRef` objects in the template
	// with the values that you provide in the `envRefs` parameter.
	// For more examples, see how to [define environment references](https://docs.influxdata.com/influxdb/v2.3/influxdb-templates/use/#define-environment-references).
	//
	// The following template fields may use environment references:
	//
	//   - `metadata.name`
	//   - `spec.endpointName`
	//   - `spec.associations.name`
	//
	// For more information about including environment references in template fields, see how to
	// [include user-definable resource names](https://docs.influxdata.com/influxdb/v2.3/influxdb-templates/create/#include-user-definable-resource-names).
	EnvRefs *TemplateApply_EnvRefs `json:"envRefs,omitempty"`

	// Organization ID.
	// InfluxDB applies templates to this organization.
	// The organization owns all resources created by the template.
	//
	// To find your organization, see how to
	// [view organizations](https://docs.influxdata.com/influxdb/v2.3/organizations/view-orgs/).
	OrgID *string `json:"orgID,omitempty"`

	// A list of URLs for template files.
	//
	// To apply a template manifest file located at a URL, pass `remotes`
	// with an array that contains the URL.
	Remotes *[]struct {
		ContentType *string `json:"contentType,omitempty"`
		Url         string  `json:"url"`
	} `json:"remotes,omitempty"`

	// An object with key-value pairs that map to **secrets** in queries.
	//
	// Queries may reference secrets stored in InfluxDB--for example,
	// the following Flux script retrieves `POSTGRES_USERNAME` and `POSTGRES_PASSWORD`
	// secrets and then uses them to connect to a PostgreSQL database:
	//
	//   ```js
	//   import "sql"
	//   import "influxdata/influxdb/secrets"
	//
	//   username = secrets.get(key: "POSTGRES_USERNAME")
	//   password = secrets.get(key: "POSTGRES_PASSWORD")
	//
	//   sql.from(
	//     driverName: "postgres",
	//     dataSourceName: "postgresql://${username}:${password}@localhost:5432",
	//     query: "SELECT * FROM example_table",
	//   )
	//   ```
	//
	// To define secret values in your `/api/v2/templates/apply` request,
	// pass the `secrets` parameter with key-value pairs--for example:
	//
	//   ```json
	//   {
	//     ...
	//     "secrets": {
	//       "POSTGRES_USERNAME": "pguser",
	//       "POSTGRES_PASSWORD": "foo"
	//     }
	//     ...
	//   }
	//   ```
	//
	// InfluxDB stores the key-value pairs as secrets that you can access with `secrets.get()`.
	// Once stored, you can't view secret values in InfluxDB.
	//
	// #### Related guides
	//
	// - [How to pass secrets when installing a template](https://docs.influxdata.com/influxdb/v2.3/influxdb-templates/use/#pass-secrets-when-installing-a-template)
	Secrets *TemplateApply_Secrets `json:"secrets,omitempty"`

	// ID of the stack to update.
	//
	// To apply templates to an existing stack in the organization, use the `stackID` parameter.
	// If you apply templates without providing a stack ID,
	// InfluxDB initializes a new stack with all new resources.
	//
	// To find a stack ID, use the InfluxDB [`/api/v2/stacks` API endpoint](#operation/ListStacks) to list stacks.
	//
	// #### Related guides
	//
	// - [Stacks](https://docs.influxdata.com/influxdb/v2.3/influxdb-templates/stacks/)
	// - [View stacks](https://docs.influxdata.com/influxdb/v2.3/influxdb-templates/stacks/view/)
	StackID *string `json:"stackID,omitempty"`

	// A template object to apply.
	// A template object has a `contents` property
	// with an array of InfluxDB resource configurations.
	//
	// Pass `template` to apply only one template object.
	// If you use `template`, you can't use the `templates` parameter.
	// If you want to apply multiple template objects, use `templates` instead.
	Template *struct {
		ContentType *string   `json:"contentType,omitempty"`
		Contents    *Template `json:"contents,omitempty"`
		Sources     *[]string `json:"sources,omitempty"`
	} `json:"template,omitempty"`

	// A list of template objects to apply.
	// A template object has a `contents` property
	// with an array of InfluxDB resource configurations.
	//
	// Use the `templates` parameter to apply multiple template objects.
	// If you use `templates`, you can't use the `template` parameter.
	Templates *[]struct {
		ContentType *string   `json:"contentType,omitempty"`
		Contents    *Template `json:"contents,omitempty"`
		Sources     *[]string `json:"sources,omitempty"`
	} `json:"templates,omitempty"`
}

// An object with key-value pairs that map to **environment references** in templates.
//
// Environment references in templates are `envRef` objects with an `envRef.key`
// property.
// To substitute a custom environment reference value when applying templates,
// pass `envRefs` with the `envRef.key` and the value.
//
// When you apply a template, InfluxDB replaces `envRef` objects in the template
// with the values that you provide in the `envRefs` parameter.
// For more examples, see how to [define environment references](https://docs.influxdata.com/influxdb/v2.3/influxdb-templates/use/#define-environment-references).
//
// The following template fields may use environment references:
//
//   - `metadata.name`
//   - `spec.endpointName`
//   - `spec.associations.name`
//
// For more information about including environment references in template fields, see how to
// [include user-definable resource names](https://docs.influxdata.com/influxdb/v2.3/influxdb-templates/create/#include-user-definable-resource-names).
type TemplateApply_EnvRefs struct {
	AdditionalProperties map[string]interface{} `json:"-"`
}

// An object with key-value pairs that map to **secrets** in queries.
//
// Queries may reference secrets stored in InfluxDB--for example,
// the following Flux script retrieves `POSTGRES_USERNAME` and `POSTGRES_PASSWORD`
// secrets and then uses them to connect to a PostgreSQL database:
//
//   ```js
//   import "sql"
//   import "influxdata/influxdb/secrets"
//
//   username = secrets.get(key: "POSTGRES_USERNAME")
//   password = secrets.get(key: "POSTGRES_PASSWORD")
//
//   sql.from(
//     driverName: "postgres",
//     dataSourceName: "postgresql://${username}:${password}@localhost:5432",
//     query: "SELECT * FROM example_table",
//   )
//   ```
//
// To define secret values in your `/api/v2/templates/apply` request,
// pass the `secrets` parameter with key-value pairs--for example:
//
//   ```json
//   {
//     ...
//     "secrets": {
//       "POSTGRES_USERNAME": "pguser",
//       "POSTGRES_PASSWORD": "foo"
//     }
//     ...
//   }
//   ```
//
// InfluxDB stores the key-value pairs as secrets that you can access with `secrets.get()`.
// Once stored, you can't view secret values in InfluxDB.
//
// #### Related guides
//
// - [How to pass secrets when installing a template](https://docs.influxdata.com/influxdb/v2.3/influxdb-templates/use/#pass-secrets-when-installing-a-template)
type TemplateApply_Secrets struct {
	AdditionalProperties map[string]string `json:"-"`
}

// TemplateChart defines model for TemplateChart.
type TemplateChart struct {
	Height     *int            `json:"height,omitempty"`
	Properties *ViewProperties `json:"properties,omitempty"`
	Width      *int            `json:"width,omitempty"`
	XPos       *int            `json:"xPos,omitempty"`
	YPos       *int            `json:"yPos,omitempty"`
}

// TemplateEnvReferences defines model for TemplateEnvReferences.
type TemplateEnvReferences []struct {
	// Default value that will be provided for the reference when no value is provided
	DefaultValue *interface{} `json:"defaultValue"`

	// Key identified as environment reference and is the key identified in the template
	EnvRefKey string `json:"envRefKey"`

	// Field the environment reference corresponds too
	ResourceField string `json:"resourceField"`

	// Value provided to fulfill reference
	Value *interface{} `json:"value"`
}

// TemplateExportByID defines model for TemplateExportByID.
type TemplateExportByID struct {
	OrgIDs *[]struct {
		OrgID           *string `json:"orgID,omitempty"`
		ResourceFilters *struct {
			ByLabel        *[]string       `json:"byLabel,omitempty"`
			ByResourceKind *[]TemplateKind `json:"byResourceKind,omitempty"`
		} `json:"resourceFilters,omitempty"`
	} `json:"orgIDs,omitempty"`
	Resources *[]struct {
		Id   string       `json:"id"`
		Kind TemplateKind `json:"kind"`

		// if defined with id, name is used for resource exported by id. if defined independently, resources strictly matching name are exported
		Name *string `json:"name,omitempty"`
	} `json:"resources,omitempty"`
	StackID *string `json:"stackID,omitempty"`
}

// TemplateExportByName defines model for TemplateExportByName.
type TemplateExportByName struct {
	OrgIDs *[]struct {
		OrgID           *string `json:"orgID,omitempty"`
		ResourceFilters *struct {
			ByLabel        *[]string       `json:"byLabel,omitempty"`
			ByResourceKind *[]TemplateKind `json:"byResourceKind,omitempty"`
		} `json:"resourceFilters,omitempty"`
	} `json:"orgIDs,omitempty"`
	Resources *[]struct {
		Kind TemplateKind `json:"kind"`
		Name string       `json:"name"`
	} `json:"resources,omitempty"`
	StackID *string `json:"stackID,omitempty"`
}

// TemplateKind defines model for TemplateKind.
type TemplateKind string

// TemplateSummary defines model for TemplateSummary.
type TemplateSummary struct {
	Diff *struct {
		Buckets *[]struct {
			Id   *string       `json:"id,omitempty"`
			Kind *TemplateKind `json:"kind,omitempty"`
			New  *struct {
				Description *string `json:"description,omitempty"`
				Name        *string `json:"name,omitempty"`

				// Retention rules to expire or retain data.
				// #### InfluxDB Cloud
				//
				// - `retentionRules` is required.
				//
				// #### InfluxDB OSS
				//
				// - `retentionRules` isn't required.
				RetentionRules *RetentionRules `json:"retentionRules,omitempty"`
			} `json:"new,omitempty"`
			Old *struct {
				Description *string `json:"description,omitempty"`
				Name        *string `json:"name,omitempty"`

				// Retention rules to expire or retain data.
				// #### InfluxDB Cloud
				//
				// - `retentionRules` is required.
				//
				// #### InfluxDB OSS
				//
				// - `retentionRules` isn't required.
				RetentionRules *RetentionRules `json:"retentionRules,omitempty"`
			} `json:"old,omitempty"`
			StateStatus      *string `json:"stateStatus,omitempty"`
			TemplateMetaName *string `json:"templateMetaName,omitempty"`
		} `json:"buckets,omitempty"`
		Checks *[]struct {
			Id               *string             `json:"id,omitempty"`
			Kind             *TemplateKind       `json:"kind,omitempty"`
			New              *CheckDiscriminator `json:"new,omitempty"`
			Old              *CheckDiscriminator `json:"old,omitempty"`
			StateStatus      *string             `json:"stateStatus,omitempty"`
			TemplateMetaName *string             `json:"templateMetaName,omitempty"`
		} `json:"checks,omitempty"`
		Dashboards *[]struct {
			Id   *string       `json:"id,omitempty"`
			Kind *TemplateKind `json:"kind,omitempty"`
			New  *struct {
				Charts      *[]TemplateChart `json:"charts,omitempty"`
				Description *string          `json:"description,omitempty"`
				Name        *string          `json:"name,omitempty"`
			} `json:"new,omitempty"`
			Old *struct {
				Charts      *[]TemplateChart `json:"charts,omitempty"`
				Description *string          `json:"description,omitempty"`
				Name        *string          `json:"name,omitempty"`
			} `json:"old,omitempty"`
			StateStatus      *string `json:"stateStatus,omitempty"`
			TemplateMetaName *string `json:"templateMetaName,omitempty"`
		} `json:"dashboards,omitempty"`
		LabelMappings *[]struct {
			LabelID                  *string `json:"labelID,omitempty"`
			LabelName                *string `json:"labelName,omitempty"`
			LabelTemplateMetaName    *string `json:"labelTemplateMetaName,omitempty"`
			ResourceID               *string `json:"resourceID,omitempty"`
			ResourceName             *string `json:"resourceName,omitempty"`
			ResourceTemplateMetaName *string `json:"resourceTemplateMetaName,omitempty"`
			ResourceType             *string `json:"resourceType,omitempty"`
			Status                   *string `json:"status,omitempty"`
		} `json:"labelMappings,omitempty"`
		Labels *[]struct {
			Id   *string       `json:"id,omitempty"`
			Kind *TemplateKind `json:"kind,omitempty"`
			New  *struct {
				Color       *string `json:"color,omitempty"`
				Description *string `json:"description,omitempty"`
				Name        *string `json:"name,omitempty"`
			} `json:"new,omitempty"`
			Old *struct {
				Color       *string `json:"color,omitempty"`
				Description *string `json:"description,omitempty"`
				Name        *string `json:"name,omitempty"`
			} `json:"old,omitempty"`
			StateStatus      *string `json:"stateStatus,omitempty"`
			TemplateMetaName *string `json:"templateMetaName,omitempty"`
		} `json:"labels,omitempty"`
		NotificationEndpoints *[]struct {
			Id               *string                            `json:"id,omitempty"`
			Kind             *TemplateKind                      `json:"kind,omitempty"`
			New              *NotificationEndpointDiscriminator `json:"new,omitempty"`
			Old              *NotificationEndpointDiscriminator `json:"old,omitempty"`
			StateStatus      *string                            `json:"stateStatus,omitempty"`
			TemplateMetaName *string                            `json:"templateMetaName,omitempty"`
		} `json:"notificationEndpoints,omitempty"`
		NotificationRules *[]struct {
			Id   *string       `json:"id,omitempty"`
			Kind *TemplateKind `json:"kind,omitempty"`
			New  *struct {
				Description     *string `json:"description,omitempty"`
				EndpointID      *string `json:"endpointID,omitempty"`
				EndpointName    *string `json:"endpointName,omitempty"`
				EndpointType    *string `json:"endpointType,omitempty"`
				Every           *string `json:"every,omitempty"`
				MessageTemplate *string `json:"messageTemplate,omitempty"`
				Name            *string `json:"name,omitempty"`
				Offset          *string `json:"offset,omitempty"`
				Status          *string `json:"status,omitempty"`
				StatusRules     *[]struct {
					CurrentLevel  *string `json:"currentLevel,omitempty"`
					PreviousLevel *string `json:"previousLevel,omitempty"`
				} `json:"statusRules,omitempty"`
				TagRules *[]struct {
					Key      *string `json:"key,omitempty"`
					Operator *string `json:"operator,omitempty"`
					Value    *string `json:"value,omitempty"`
				} `json:"tagRules,omitempty"`
			} `json:"new,omitempty"`
			Old *struct {
				Description     *string `json:"description,omitempty"`
				EndpointID      *string `json:"endpointID,omitempty"`
				EndpointName    *string `json:"endpointName,omitempty"`
				EndpointType    *string `json:"endpointType,omitempty"`
				Every           *string `json:"every,omitempty"`
				MessageTemplate *string `json:"messageTemplate,omitempty"`
				Name            *string `json:"name,omitempty"`
				Offset          *string `json:"offset,omitempty"`
				Status          *string `json:"status,omitempty"`
				StatusRules     *[]struct {
					CurrentLevel  *string `json:"currentLevel,omitempty"`
					PreviousLevel *string `json:"previousLevel,omitempty"`
				} `json:"statusRules,omitempty"`
				TagRules *[]struct {
					Key      *string `json:"key,omitempty"`
					Operator *string `json:"operator,omitempty"`
					Value    *string `json:"value,omitempty"`
				} `json:"tagRules,omitempty"`
			} `json:"old,omitempty"`
			StateStatus      *string `json:"stateStatus,omitempty"`
			TemplateMetaName *string `json:"templateMetaName,omitempty"`
		} `json:"notificationRules,omitempty"`
		Tasks *[]struct {
			Id   *string       `json:"id,omitempty"`
			Kind *TemplateKind `json:"kind,omitempty"`
			New  *struct {
				Cron        *string `json:"cron,omitempty"`
				Description *string `json:"description,omitempty"`
				Every       *string `json:"every,omitempty"`
				Name        *string `json:"name,omitempty"`
				Offset      *string `json:"offset,omitempty"`
				Query       *string `json:"query,omitempty"`
				Status      *string `json:"status,omitempty"`
			} `json:"new,omitempty"`
			Old *struct {
				Cron        *string `json:"cron,omitempty"`
				Description *string `json:"description,omitempty"`
				Every       *string `json:"every,omitempty"`
				Name        *string `json:"name,omitempty"`
				Offset      *string `json:"offset,omitempty"`
				Query       *string `json:"query,omitempty"`
				Status      *string `json:"status,omitempty"`
			} `json:"old,omitempty"`
			StateStatus      *string `json:"stateStatus,omitempty"`
			TemplateMetaName *string `json:"templateMetaName,omitempty"`
		} `json:"tasks,omitempty"`
		TelegrafConfigs *[]struct {
			Id               *string          `json:"id,omitempty"`
			Kind             *TemplateKind    `json:"kind,omitempty"`
			New              *TelegrafRequest `json:"new,omitempty"`
			Old              *TelegrafRequest `json:"old,omitempty"`
			StateStatus      *string          `json:"stateStatus,omitempty"`
			TemplateMetaName *string          `json:"templateMetaName,omitempty"`
		} `json:"telegrafConfigs,omitempty"`
		Variables *[]struct {
			Id   *string       `json:"id,omitempty"`
			Kind *TemplateKind `json:"kind,omitempty"`
			New  *struct {
				Args        *VariableProperties `json:"args,omitempty"`
				Description *string             `json:"description,omitempty"`
				Name        *string             `json:"name,omitempty"`
			} `json:"new,omitempty"`
			Old *struct {
				Args        *VariableProperties `json:"args,omitempty"`
				Description *string             `json:"description,omitempty"`
				Name        *string             `json:"name,omitempty"`
			} `json:"old,omitempty"`
			StateStatus      *string `json:"stateStatus,omitempty"`
			TemplateMetaName *string `json:"templateMetaName,omitempty"`
		} `json:"variables,omitempty"`
	} `json:"diff,omitempty"`
	Errors *[]struct {
		Fields  *[]string     `json:"fields,omitempty"`
		Indexes *[]int        `json:"indexes,omitempty"`
		Kind    *TemplateKind `json:"kind,omitempty"`
		Reason  *string       `json:"reason,omitempty"`
	} `json:"errors,omitempty"`
	Sources *[]string `json:"sources,omitempty"`
	StackID *string   `json:"stackID,omitempty"`
	Summary *struct {
		Buckets *[]struct {
			Description       *string                 `json:"description,omitempty"`
			EnvReferences     *TemplateEnvReferences  `json:"envReferences,omitempty"`
			Id                *string                 `json:"id,omitempty"`
			Kind              *TemplateKind           `json:"kind,omitempty"`
			LabelAssociations *[]TemplateSummaryLabel `json:"labelAssociations,omitempty"`
			Name              *string                 `json:"name,omitempty"`
			OrgID             *string                 `json:"orgID,omitempty"`
			RetentionPeriod   *int                    `json:"retentionPeriod,omitempty"`
			TemplateMetaName  *string                 `json:"templateMetaName,omitempty"`
		} `json:"buckets,omitempty"`
		Checks *[]struct {
			// Embedded struct due to allOf(#/components/schemas/CheckDiscriminator)
			CheckDiscriminator `yaml:",inline"`
			// Embedded fields due to inline allOf schema
			EnvReferences     *TemplateEnvReferences  `json:"envReferences,omitempty"`
			Kind              *TemplateKind           `json:"kind,omitempty"`
			LabelAssociations *[]TemplateSummaryLabel `json:"labelAssociations,omitempty"`
			TemplateMetaName  *string                 `json:"templateMetaName,omitempty"`
		} `json:"checks,omitempty"`
		Dashboards *[]struct {
			Charts            *[]TemplateChart        `json:"charts,omitempty"`
			Description       *string                 `json:"description,omitempty"`
			EnvReferences     *TemplateEnvReferences  `json:"envReferences,omitempty"`
			Id                *string                 `json:"id,omitempty"`
			Kind              *TemplateKind           `json:"kind,omitempty"`
			LabelAssociations *[]TemplateSummaryLabel `json:"labelAssociations,omitempty"`
			Name              *string                 `json:"name,omitempty"`
			OrgID             *string                 `json:"orgID,omitempty"`
			TemplateMetaName  *string                 `json:"templateMetaName,omitempty"`
		} `json:"dashboards,omitempty"`
		LabelMappings *[]struct {
			LabelID                  *string `json:"labelID,omitempty"`
			LabelName                *string `json:"labelName,omitempty"`
			LabelTemplateMetaName    *string `json:"labelTemplateMetaName,omitempty"`
			ResourceID               *string `json:"resourceID,omitempty"`
			ResourceName             *string `json:"resourceName,omitempty"`
			ResourceTemplateMetaName *string `json:"resourceTemplateMetaName,omitempty"`
			ResourceType             *string `json:"resourceType,omitempty"`
			Status                   *string `json:"status,omitempty"`
		} `json:"labelMappings,omitempty"`
		Labels                *[]TemplateSummaryLabel `json:"labels,omitempty"`
		MissingEnvRefs        *[]string               `json:"missingEnvRefs,omitempty"`
		MissingSecrets        *[]string               `json:"missingSecrets,omitempty"`
		NotificationEndpoints *[]struct {
			// Embedded struct due to allOf(#/components/schemas/NotificationEndpointDiscriminator)
			NotificationEndpointDiscriminator `yaml:",inline"`
			// Embedded fields due to inline allOf schema
			EnvReferences     *TemplateEnvReferences  `json:"envReferences,omitempty"`
			Kind              *TemplateKind           `json:"kind,omitempty"`
			LabelAssociations *[]TemplateSummaryLabel `json:"labelAssociations,omitempty"`
			TemplateMetaName  *string                 `json:"templateMetaName,omitempty"`
		} `json:"notificationEndpoints,omitempty"`
		NotificationRules *[]struct {
			Description              *string                 `json:"description,omitempty"`
			EndpointID               *string                 `json:"endpointID,omitempty"`
			EndpointTemplateMetaName *string                 `json:"endpointTemplateMetaName,omitempty"`
			EndpointType             *string                 `json:"endpointType,omitempty"`
			EnvReferences            *TemplateEnvReferences  `json:"envReferences,omitempty"`
			Every                    *string                 `json:"every,omitempty"`
			Kind                     *TemplateKind           `json:"kind,omitempty"`
			LabelAssociations        *[]TemplateSummaryLabel `json:"labelAssociations,omitempty"`
			MessageTemplate          *string                 `json:"messageTemplate,omitempty"`
			Name                     *string                 `json:"name,omitempty"`
			Offset                   *string                 `json:"offset,omitempty"`
			Status                   *string                 `json:"status,omitempty"`
			StatusRules              *[]struct {
				CurrentLevel  *string `json:"currentLevel,omitempty"`
				PreviousLevel *string `json:"previousLevel,omitempty"`
			} `json:"statusRules,omitempty"`
			TagRules *[]struct {
				Key      *string `json:"key,omitempty"`
				Operator *string `json:"operator,omitempty"`
				Value    *string `json:"value,omitempty"`
			} `json:"tagRules,omitempty"`
			TemplateMetaName *string `json:"templateMetaName,omitempty"`
		} `json:"notificationRules,omitempty"`
		Tasks *[]struct {
			Cron             *string                `json:"cron,omitempty"`
			Description      *string                `json:"description,omitempty"`
			EnvReferences    *TemplateEnvReferences `json:"envReferences,omitempty"`
			Every            *string                `json:"every,omitempty"`
			Id               *string                `json:"id,omitempty"`
			Kind             *TemplateKind          `json:"kind,omitempty"`
			Name             *string                `json:"name,omitempty"`
			Offset           *string                `json:"offset,omitempty"`
			Query            *string                `json:"query,omitempty"`
			Status           *string                `json:"status,omitempty"`
			TemplateMetaName *string                `json:"templateMetaName,omitempty"`
		} `json:"tasks,omitempty"`
		TelegrafConfigs *[]struct {
			// Embedded struct due to allOf(#/components/schemas/TelegrafRequest)
			TelegrafRequest `yaml:",inline"`
			// Embedded fields due to inline allOf schema
			EnvReferences     *TemplateEnvReferences  `json:"envReferences,omitempty"`
			Kind              *TemplateKind           `json:"kind,omitempty"`
			LabelAssociations *[]TemplateSummaryLabel `json:"labelAssociations,omitempty"`
			TemplateMetaName  *string                 `json:"templateMetaName,omitempty"`
		} `json:"telegrafConfigs,omitempty"`
		Variables *[]struct {
			Arguments         *VariableProperties     `json:"arguments,omitempty"`
			Description       *string                 `json:"description,omitempty"`
			EnvReferences     *TemplateEnvReferences  `json:"envReferences,omitempty"`
			Id                *string                 `json:"id,omitempty"`
			Kind              *TemplateKind           `json:"kind,omitempty"`
			LabelAssociations *[]TemplateSummaryLabel `json:"labelAssociations,omitempty"`
			Name              *string                 `json:"name,omitempty"`
			OrgID             *string                 `json:"orgID,omitempty"`
			TemplateMetaName  *string                 `json:"templateMetaName,omitempty"`
		} `json:"variables,omitempty"`
	} `json:"summary,omitempty"`
}

// TemplateSummaryLabel defines model for TemplateSummaryLabel.
type TemplateSummaryLabel struct {
	EnvReferences *TemplateEnvReferences `json:"envReferences,omitempty"`
	Id            *string                `json:"id,omitempty"`
	Kind          *TemplateKind          `json:"kind,omitempty"`
	Name          *string                `json:"name,omitempty"`
	OrgID         *string                `json:"orgID,omitempty"`
	Properties    *struct {
		Color       *string `json:"color,omitempty"`
		Description *string `json:"description,omitempty"`
	} `json:"properties,omitempty"`
	TemplateMetaName *string `json:"templateMetaName,omitempty"`
}

// Declares a Flux test case
type TestStatement struct {
	// Represents the declaration of a variable
	Assignment *VariableAssignment `json:"assignment,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Threshold defines model for Threshold.
type Threshold interface{}

// ThresholdBase defines model for ThresholdBase.
type ThresholdBase struct {
	// If true, only alert if all values meet threshold.
	AllValues *bool `json:"allValues,omitempty"`

	// The state to record if check matches a criteria.
	Level *CheckStatusLevel `json:"level,omitempty"`
}

// ThresholdCheck defines model for ThresholdCheck.
type ThresholdCheck struct {
	// Embedded struct due to allOf(#/components/schemas/CheckBase)
	CheckBase `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// Check repetition interval.
	Every *string `json:"every,omitempty"`

	// Duration to delay after the schedule, before executing check.
	Offset *string `json:"offset,omitempty"`

	// The template used to generate and write a status message.
	StatusMessageTemplate *string `json:"statusMessageTemplate,omitempty"`

	// List of tags to write to each status.
	Tags *[]struct {
		Key   *string `json:"key,omitempty"`
		Value *string `json:"value,omitempty"`
	} `json:"tags,omitempty"`
	Thresholds *[]Threshold       `json:"thresholds,omitempty"`
	Type       ThresholdCheckType `json:"type"`
}

// ThresholdCheckType defines model for ThresholdCheck.Type.
type ThresholdCheckType string

// Uses operators to act on a single operand in an expression
type UnaryExpression struct {
	Argument *Expression `json:"argument,omitempty"`
	Operator *string     `json:"operator,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// Represents integer numbers
type UnsignedIntegerLiteral struct {
	// Type of AST node
	Type  *NodeType `json:"type,omitempty"`
	Value *string   `json:"value,omitempty"`
}

// User defines model for User.
type User struct {
	Id      *string `json:"id,omitempty"`
	Name    string  `json:"name"`
	OauthID *string `json:"oauthID,omitempty"`

	// If inactive the user is inactive.
	Status *UserStatus `json:"status,omitempty"`
}

// If inactive the user is inactive.
type UserStatus string

// UserResponse defines model for UserResponse.
type UserResponse struct {
	// The ID of the user.
	Id    *string `json:"id,omitempty"`
	Links *struct {
		Self *string `json:"self,omitempty"`
	} `json:"links,omitempty"`

	// The name of the user.
	Name string `json:"name"`

	// The status of a user. An inactive user won't have access to resources.
	Status *UserResponseStatus `json:"status,omitempty"`
}

// The status of a user. An inactive user won't have access to resources.
type UserResponseStatus string

// Users defines model for Users.
type Users struct {
	Links *struct {
		Self *string `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Users *[]UserResponse `json:"users,omitempty"`
}

// Variable defines model for Variable.
type Variable struct {
	Arguments   VariableProperties `json:"arguments"`
	CreatedAt   *time.Time         `json:"createdAt,omitempty"`
	Description *string            `json:"description,omitempty"`
	Id          *string            `json:"id,omitempty"`
	Labels      *Labels            `json:"labels,omitempty"`
	Links       *struct {
		Labels *string `json:"labels,omitempty"`
		Org    *string `json:"org,omitempty"`
		Self   *string `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Name      string     `json:"name"`
	OrgID     string     `json:"orgID"`
	Selected  *[]string  `json:"selected,omitempty"`
	UpdatedAt *time.Time `json:"updatedAt,omitempty"`
}

// Represents the declaration of a variable
type VariableAssignment struct {
	// A valid Flux identifier
	Id   *Identifier `json:"id,omitempty"`
	Init *Expression `json:"init,omitempty"`

	// Type of AST node
	Type *NodeType `json:"type,omitempty"`
}

// VariableProperties defines model for VariableProperties.
type VariableProperties interface{}

// Variables defines model for Variables.
type Variables struct {
	Variables *[]Variable `json:"variables,omitempty"`
}

// View defines model for View.
type View struct {
	Id    *string `json:"id,omitempty"`
	Links *struct {
		Self *string `json:"self,omitempty"`
	} `json:"links,omitempty"`
	Name       string         `json:"name"`
	Properties ViewProperties `json:"properties"`
}

// ViewProperties defines model for ViewProperties.
type ViewProperties interface{}

// WritePrecision defines model for WritePrecision.
type WritePrecision string

// XYGeom defines model for XYGeom.
type XYGeom string

// XYViewProperties defines model for XYViewProperties.
type XYViewProperties struct {
	AdaptiveZoomHide *bool `json:"adaptiveZoomHide,omitempty"`

	// The viewport for a View's visualizations
	Axes Axes `json:"axes"`

	// A color mapping is an object that maps time series data to a UI color scheme to allow the UI to render graphs consistent colors across reloads.
	ColorMapping *ColorMapping `json:"colorMapping,omitempty"`

	// Colors define color encoding of data into a visualization
	Colors                     []DashboardColor                `json:"colors"`
	GenerateXAxisTicks         *[]string                       `json:"generateXAxisTicks,omitempty"`
	GenerateYAxisTicks         *[]string                       `json:"generateYAxisTicks,omitempty"`
	Geom                       XYGeom                          `json:"geom"`
	HoverDimension             *XYViewPropertiesHoverDimension `json:"hoverDimension,omitempty"`
	LegendColorizeRows         *bool                           `json:"legendColorizeRows,omitempty"`
	LegendHide                 *bool                           `json:"legendHide,omitempty"`
	LegendOpacity              *float32                        `json:"legendOpacity,omitempty"`
	LegendOrientationThreshold *int                            `json:"legendOrientationThreshold,omitempty"`
	Note                       string                          `json:"note"`
	Position                   XYViewPropertiesPosition        `json:"position"`
	Queries                    []DashboardQuery                `json:"queries"`
	ShadeBelow                 *bool                           `json:"shadeBelow,omitempty"`
	Shape                      XYViewPropertiesShape           `json:"shape"`

	// If true, will display note when empty
	ShowNoteWhenEmpty bool `json:"showNoteWhenEmpty"`

	// StaticLegend represents the options specific to the static legend
	StaticLegend *StaticLegend        `json:"staticLegend,omitempty"`
	TimeFormat   *string              `json:"timeFormat,omitempty"`
	Type         XYViewPropertiesType `json:"type"`
	XColumn      *string              `json:"xColumn,omitempty"`
	XTickStart   *float32             `json:"xTickStart,omitempty"`
	XTickStep    *float32             `json:"xTickStep,omitempty"`
	XTotalTicks  *int                 `json:"xTotalTicks,omitempty"`
	YColumn      *string              `json:"yColumn,omitempty"`
	YTickStart   *float32             `json:"yTickStart,omitempty"`
	YTickStep    *float32             `json:"yTickStep,omitempty"`
	YTotalTicks  *int                 `json:"yTotalTicks,omitempty"`
}

// XYViewPropertiesHoverDimension defines model for XYViewProperties.HoverDimension.
type XYViewPropertiesHoverDimension string

// XYViewPropertiesPosition defines model for XYViewProperties.Position.
type XYViewPropertiesPosition string

// XYViewPropertiesShape defines model for XYViewProperties.Shape.
type XYViewPropertiesShape string

// XYViewPropertiesType defines model for XYViewProperties.Type.
type XYViewPropertiesType string

// After defines model for After.
type After string

// Descending defines model for Descending.
type Descending bool

// Limit defines model for Limit.
type Limit int

// Offset defines model for Offset.
type Offset int

// TraceSpan defines model for TraceSpan.
type TraceSpan string

// AuthorizationError defines model for AuthorizationError.
type AuthorizationError struct {
	// The HTTP status code description. Default is `unauthorized`.
	Code *AuthorizationErrorCode `json:"code,omitempty"`

	// A human-readable message that may contain detail about the error.
	Message *string `json:"message,omitempty"`
}

// The HTTP status code description. Default is `unauthorized`.
type AuthorizationErrorCode string

// BadRequestError defines model for BadRequestError.
type BadRequestError Error

// GeneralServerError defines model for GeneralServerError.
type GeneralServerError Error

// InternalServerError defines model for InternalServerError.
type InternalServerError Error

// ResourceNotFoundError defines model for ResourceNotFoundError.
type ResourceNotFoundError Error

// GetAuthorizationsParams defines parameters for GetAuthorizations.
type GetAuthorizationsParams struct {
	// A user ID.
	// Only returns authorizations scoped to this user.
	UserID *string `json:"userID,omitempty"`

	// A user name.
	// Only returns authorizations scoped to this user.
	User *string `json:"user,omitempty"`

	// An organization ID. Only returns authorizations that belong to this organization.
	OrgID *string `json:"orgID,omitempty"`

	// An organization name.
	// Only returns authorizations that belong to this organization.
	Org *string `json:"org,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostAuthorizationsJSONBody defines parameters for PostAuthorizations.
type PostAuthorizationsJSONBody AuthorizationPostRequest

// PostAuthorizationsParams defines parameters for PostAuthorizations.
type PostAuthorizationsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostAuthorizationsAllParams defines type for all parameters for PostAuthorizations.
type PostAuthorizationsAllParams struct {
	PostAuthorizationsParams

	Body PostAuthorizationsJSONRequestBody
}

// DeleteAuthorizationsIDParams defines parameters for DeleteAuthorizationsID.
type DeleteAuthorizationsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteAuthorizationsIDAllParams defines type for all parameters for DeleteAuthorizationsID.
type DeleteAuthorizationsIDAllParams struct {
	DeleteAuthorizationsIDParams

	AuthID string
}

// GetAuthorizationsIDParams defines parameters for GetAuthorizationsID.
type GetAuthorizationsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetAuthorizationsIDAllParams defines type for all parameters for GetAuthorizationsID.
type GetAuthorizationsIDAllParams struct {
	GetAuthorizationsIDParams

	AuthID string
}

// PatchAuthorizationsIDJSONBody defines parameters for PatchAuthorizationsID.
type PatchAuthorizationsIDJSONBody AuthorizationUpdateRequest

// PatchAuthorizationsIDParams defines parameters for PatchAuthorizationsID.
type PatchAuthorizationsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchAuthorizationsIDAllParams defines type for all parameters for PatchAuthorizationsID.
type PatchAuthorizationsIDAllParams struct {
	PatchAuthorizationsIDParams

	AuthID string

	Body PatchAuthorizationsIDJSONRequestBody
}

// GetBucketsParams defines parameters for GetBuckets.
type GetBucketsParams struct {
	// The offset for pagination.
	// The number of records to skip.
	Offset *Offset `json:"offset,omitempty"`

	// Limits the number of records returned. Default is `20`.
	Limit *Limit `json:"limit,omitempty"`

	// Resource ID to seek from. Results are not inclusive of this ID. Use `after` instead of `offset`.
	After *After `json:"after,omitempty"`

	// Organization name.
	// The name of the organization.
	//
	// #### InfluxDB Cloud
	//
	//  - Doesn't use `org` or `orgID`.
	//  - Creates a bucket in the organization associated with the authorization (API token).
	//
	//  #### InfluxDB OSS
	//
	//  - Accepts either `org` or `orgID`.
	//  - InfluxDB creates the bucket within this organization.
	Org *string `json:"org,omitempty"`

	// Organization ID.
	// The organization ID.
	//
	// #### InfluxDB Cloud
	//
	//  - Doesn't use `org` or `orgID`.
	//  - Creates a bucket in the organization associated with the authorization (API token).
	//
	//  #### InfluxDB OSS
	//
	//  - Accepts either `org` or `orgID`.
	//  - InfluxDB creates the bucket within this organization.
	OrgID *string `json:"orgID,omitempty"`

	// Bucket name.
	// Only returns buckets with this specific name.
	Name *string `json:"name,omitempty"`

	// Bucket ID.
	// Only returns the bucket with this ID.
	Id *string `json:"id,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostBucketsJSONBody defines parameters for PostBuckets.
type PostBucketsJSONBody PostBucketRequest

// PostBucketsParams defines parameters for PostBuckets.
type PostBucketsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostBucketsAllParams defines type for all parameters for PostBuckets.
type PostBucketsAllParams struct {
	PostBucketsParams

	Body PostBucketsJSONRequestBody
}

// DeleteBucketsIDParams defines parameters for DeleteBucketsID.
type DeleteBucketsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteBucketsIDAllParams defines type for all parameters for DeleteBucketsID.
type DeleteBucketsIDAllParams struct {
	DeleteBucketsIDParams

	BucketID string
}

// GetBucketsIDParams defines parameters for GetBucketsID.
type GetBucketsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetBucketsIDAllParams defines type for all parameters for GetBucketsID.
type GetBucketsIDAllParams struct {
	GetBucketsIDParams

	BucketID string
}

// PatchBucketsIDJSONBody defines parameters for PatchBucketsID.
type PatchBucketsIDJSONBody PatchBucketRequest

// PatchBucketsIDParams defines parameters for PatchBucketsID.
type PatchBucketsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchBucketsIDAllParams defines type for all parameters for PatchBucketsID.
type PatchBucketsIDAllParams struct {
	PatchBucketsIDParams

	BucketID string

	Body PatchBucketsIDJSONRequestBody
}

// GetBucketsIDLabelsParams defines parameters for GetBucketsIDLabels.
type GetBucketsIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetBucketsIDLabelsAllParams defines type for all parameters for GetBucketsIDLabels.
type GetBucketsIDLabelsAllParams struct {
	GetBucketsIDLabelsParams

	BucketID string
}

// PostBucketsIDLabelsJSONBody defines parameters for PostBucketsIDLabels.
type PostBucketsIDLabelsJSONBody LabelMapping

// PostBucketsIDLabelsParams defines parameters for PostBucketsIDLabels.
type PostBucketsIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostBucketsIDLabelsAllParams defines type for all parameters for PostBucketsIDLabels.
type PostBucketsIDLabelsAllParams struct {
	PostBucketsIDLabelsParams

	BucketID string

	Body PostBucketsIDLabelsJSONRequestBody
}

// DeleteBucketsIDLabelsIDParams defines parameters for DeleteBucketsIDLabelsID.
type DeleteBucketsIDLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteBucketsIDLabelsIDAllParams defines type for all parameters for DeleteBucketsIDLabelsID.
type DeleteBucketsIDLabelsIDAllParams struct {
	DeleteBucketsIDLabelsIDParams

	BucketID string

	LabelID string
}

// GetBucketsIDMembersParams defines parameters for GetBucketsIDMembers.
type GetBucketsIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetBucketsIDMembersAllParams defines type for all parameters for GetBucketsIDMembers.
type GetBucketsIDMembersAllParams struct {
	GetBucketsIDMembersParams

	BucketID string
}

// PostBucketsIDMembersJSONBody defines parameters for PostBucketsIDMembers.
type PostBucketsIDMembersJSONBody AddResourceMemberRequestBody

// PostBucketsIDMembersParams defines parameters for PostBucketsIDMembers.
type PostBucketsIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostBucketsIDMembersAllParams defines type for all parameters for PostBucketsIDMembers.
type PostBucketsIDMembersAllParams struct {
	PostBucketsIDMembersParams

	BucketID string

	Body PostBucketsIDMembersJSONRequestBody
}

// DeleteBucketsIDMembersIDParams defines parameters for DeleteBucketsIDMembersID.
type DeleteBucketsIDMembersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteBucketsIDMembersIDAllParams defines type for all parameters for DeleteBucketsIDMembersID.
type DeleteBucketsIDMembersIDAllParams struct {
	DeleteBucketsIDMembersIDParams

	BucketID string

	UserID string
}

// GetBucketsIDOwnersParams defines parameters for GetBucketsIDOwners.
type GetBucketsIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetBucketsIDOwnersAllParams defines type for all parameters for GetBucketsIDOwners.
type GetBucketsIDOwnersAllParams struct {
	GetBucketsIDOwnersParams

	BucketID string
}

// PostBucketsIDOwnersJSONBody defines parameters for PostBucketsIDOwners.
type PostBucketsIDOwnersJSONBody AddResourceMemberRequestBody

// PostBucketsIDOwnersParams defines parameters for PostBucketsIDOwners.
type PostBucketsIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostBucketsIDOwnersAllParams defines type for all parameters for PostBucketsIDOwners.
type PostBucketsIDOwnersAllParams struct {
	PostBucketsIDOwnersParams

	BucketID string

	Body PostBucketsIDOwnersJSONRequestBody
}

// DeleteBucketsIDOwnersIDParams defines parameters for DeleteBucketsIDOwnersID.
type DeleteBucketsIDOwnersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteBucketsIDOwnersIDAllParams defines type for all parameters for DeleteBucketsIDOwnersID.
type DeleteBucketsIDOwnersIDAllParams struct {
	DeleteBucketsIDOwnersIDParams

	BucketID string

	UserID string
}

// GetChecksParams defines parameters for GetChecks.
type GetChecksParams struct {
	// The offset for pagination.
	// The number of records to skip.
	Offset *Offset `json:"offset,omitempty"`

	// Limits the number of records returned. Default is `20`.
	Limit *Limit `json:"limit,omitempty"`

	// Only show checks that belong to a specific organization ID.
	OrgID string `json:"orgID"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// CreateCheckJSONBody defines parameters for CreateCheck.
type CreateCheckJSONBody PostCheck

// CreateCheckAllParams defines type for all parameters for CreateCheck.
type CreateCheckAllParams struct {
	Body CreateCheckJSONRequestBody
}

// DeleteChecksIDParams defines parameters for DeleteChecksID.
type DeleteChecksIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteChecksIDAllParams defines type for all parameters for DeleteChecksID.
type DeleteChecksIDAllParams struct {
	DeleteChecksIDParams

	CheckID string
}

// GetChecksIDParams defines parameters for GetChecksID.
type GetChecksIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetChecksIDAllParams defines type for all parameters for GetChecksID.
type GetChecksIDAllParams struct {
	GetChecksIDParams

	CheckID string
}

// PatchChecksIDJSONBody defines parameters for PatchChecksID.
type PatchChecksIDJSONBody CheckPatch

// PatchChecksIDParams defines parameters for PatchChecksID.
type PatchChecksIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchChecksIDAllParams defines type for all parameters for PatchChecksID.
type PatchChecksIDAllParams struct {
	PatchChecksIDParams

	CheckID string

	Body PatchChecksIDJSONRequestBody
}

// PutChecksIDJSONBody defines parameters for PutChecksID.
type PutChecksIDJSONBody Check

// PutChecksIDParams defines parameters for PutChecksID.
type PutChecksIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PutChecksIDAllParams defines type for all parameters for PutChecksID.
type PutChecksIDAllParams struct {
	PutChecksIDParams

	CheckID string

	Body PutChecksIDJSONRequestBody
}

// GetChecksIDLabelsParams defines parameters for GetChecksIDLabels.
type GetChecksIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetChecksIDLabelsAllParams defines type for all parameters for GetChecksIDLabels.
type GetChecksIDLabelsAllParams struct {
	GetChecksIDLabelsParams

	CheckID string
}

// PostChecksIDLabelsJSONBody defines parameters for PostChecksIDLabels.
type PostChecksIDLabelsJSONBody LabelMapping

// PostChecksIDLabelsParams defines parameters for PostChecksIDLabels.
type PostChecksIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostChecksIDLabelsAllParams defines type for all parameters for PostChecksIDLabels.
type PostChecksIDLabelsAllParams struct {
	PostChecksIDLabelsParams

	CheckID string

	Body PostChecksIDLabelsJSONRequestBody
}

// DeleteChecksIDLabelsIDParams defines parameters for DeleteChecksIDLabelsID.
type DeleteChecksIDLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteChecksIDLabelsIDAllParams defines type for all parameters for DeleteChecksIDLabelsID.
type DeleteChecksIDLabelsIDAllParams struct {
	DeleteChecksIDLabelsIDParams

	CheckID string

	LabelID string
}

// GetChecksIDQueryParams defines parameters for GetChecksIDQuery.
type GetChecksIDQueryParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetChecksIDQueryAllParams defines type for all parameters for GetChecksIDQuery.
type GetChecksIDQueryAllParams struct {
	GetChecksIDQueryParams

	CheckID string
}

// GetConfigParams defines parameters for GetConfig.
type GetConfigParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetDashboardsParams defines parameters for GetDashboards.
type GetDashboardsParams struct {
	// The offset for pagination.
	// The number of records to skip.
	Offset *Offset `json:"offset,omitempty"`

	// Limits the number of records returned. Default is `20`.
	Limit      *Limit      `json:"limit,omitempty"`
	Descending *Descending `json:"descending,omitempty"`

	// A user identifier. Returns only dashboards where this user has the `owner` role.
	Owner *string `json:"owner,omitempty"`

	// The column to sort by.
	SortBy *GetDashboardsParamsSortBy `json:"sortBy,omitempty"`

	// A list of dashboard identifiers. Returns only the listed dashboards. If both `id` and `owner` are specified, only `id` is used.
	Id *[]string `json:"id,omitempty"`

	// The identifier of the organization.
	OrgID *string `json:"orgID,omitempty"`

	// The name of the organization.
	Org *string `json:"org,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetDashboardsParamsSortBy defines parameters for GetDashboards.
type GetDashboardsParamsSortBy string

// DeleteDashboardsIDParams defines parameters for DeleteDashboardsID.
type DeleteDashboardsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteDashboardsIDAllParams defines type for all parameters for DeleteDashboardsID.
type DeleteDashboardsIDAllParams struct {
	DeleteDashboardsIDParams

	DashboardID string
}

// PatchDashboardsIDJSONBody defines parameters for PatchDashboardsID.
type PatchDashboardsIDJSONBody struct {
	Cells *CellWithViewProperties `json:"cells,omitempty"`

	// optional, when provided will replace the description
	Description *string `json:"description,omitempty"`

	// optional, when provided will replace the name
	Name *string `json:"name,omitempty"`
}

// PatchDashboardsIDParams defines parameters for PatchDashboardsID.
type PatchDashboardsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchDashboardsIDAllParams defines type for all parameters for PatchDashboardsID.
type PatchDashboardsIDAllParams struct {
	PatchDashboardsIDParams

	DashboardID string

	Body PatchDashboardsIDJSONRequestBody
}

// PostDashboardsIDCellsJSONBody defines parameters for PostDashboardsIDCells.
type PostDashboardsIDCellsJSONBody CreateCell

// PostDashboardsIDCellsParams defines parameters for PostDashboardsIDCells.
type PostDashboardsIDCellsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostDashboardsIDCellsAllParams defines type for all parameters for PostDashboardsIDCells.
type PostDashboardsIDCellsAllParams struct {
	PostDashboardsIDCellsParams

	DashboardID string

	Body PostDashboardsIDCellsJSONRequestBody
}

// PutDashboardsIDCellsJSONBody defines parameters for PutDashboardsIDCells.
type PutDashboardsIDCellsJSONBody Cells

// PutDashboardsIDCellsParams defines parameters for PutDashboardsIDCells.
type PutDashboardsIDCellsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PutDashboardsIDCellsAllParams defines type for all parameters for PutDashboardsIDCells.
type PutDashboardsIDCellsAllParams struct {
	PutDashboardsIDCellsParams

	DashboardID string

	Body PutDashboardsIDCellsJSONRequestBody
}

// DeleteDashboardsIDCellsIDParams defines parameters for DeleteDashboardsIDCellsID.
type DeleteDashboardsIDCellsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteDashboardsIDCellsIDAllParams defines type for all parameters for DeleteDashboardsIDCellsID.
type DeleteDashboardsIDCellsIDAllParams struct {
	DeleteDashboardsIDCellsIDParams

	DashboardID string

	CellID string
}

// PatchDashboardsIDCellsIDJSONBody defines parameters for PatchDashboardsIDCellsID.
type PatchDashboardsIDCellsIDJSONBody CellUpdate

// PatchDashboardsIDCellsIDParams defines parameters for PatchDashboardsIDCellsID.
type PatchDashboardsIDCellsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchDashboardsIDCellsIDAllParams defines type for all parameters for PatchDashboardsIDCellsID.
type PatchDashboardsIDCellsIDAllParams struct {
	PatchDashboardsIDCellsIDParams

	DashboardID string

	CellID string

	Body PatchDashboardsIDCellsIDJSONRequestBody
}

// GetDashboardsIDCellsIDViewParams defines parameters for GetDashboardsIDCellsIDView.
type GetDashboardsIDCellsIDViewParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetDashboardsIDCellsIDViewAllParams defines type for all parameters for GetDashboardsIDCellsIDView.
type GetDashboardsIDCellsIDViewAllParams struct {
	GetDashboardsIDCellsIDViewParams

	DashboardID string

	CellID string
}

// PatchDashboardsIDCellsIDViewJSONBody defines parameters for PatchDashboardsIDCellsIDView.
type PatchDashboardsIDCellsIDViewJSONBody View

// PatchDashboardsIDCellsIDViewParams defines parameters for PatchDashboardsIDCellsIDView.
type PatchDashboardsIDCellsIDViewParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchDashboardsIDCellsIDViewAllParams defines type for all parameters for PatchDashboardsIDCellsIDView.
type PatchDashboardsIDCellsIDViewAllParams struct {
	PatchDashboardsIDCellsIDViewParams

	DashboardID string

	CellID string

	Body PatchDashboardsIDCellsIDViewJSONRequestBody
}

// GetDashboardsIDLabelsParams defines parameters for GetDashboardsIDLabels.
type GetDashboardsIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetDashboardsIDLabelsAllParams defines type for all parameters for GetDashboardsIDLabels.
type GetDashboardsIDLabelsAllParams struct {
	GetDashboardsIDLabelsParams

	DashboardID string
}

// PostDashboardsIDLabelsJSONBody defines parameters for PostDashboardsIDLabels.
type PostDashboardsIDLabelsJSONBody LabelMapping

// PostDashboardsIDLabelsParams defines parameters for PostDashboardsIDLabels.
type PostDashboardsIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostDashboardsIDLabelsAllParams defines type for all parameters for PostDashboardsIDLabels.
type PostDashboardsIDLabelsAllParams struct {
	PostDashboardsIDLabelsParams

	DashboardID string

	Body PostDashboardsIDLabelsJSONRequestBody
}

// DeleteDashboardsIDLabelsIDParams defines parameters for DeleteDashboardsIDLabelsID.
type DeleteDashboardsIDLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteDashboardsIDLabelsIDAllParams defines type for all parameters for DeleteDashboardsIDLabelsID.
type DeleteDashboardsIDLabelsIDAllParams struct {
	DeleteDashboardsIDLabelsIDParams

	DashboardID string

	LabelID string
}

// GetDashboardsIDMembersParams defines parameters for GetDashboardsIDMembers.
type GetDashboardsIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetDashboardsIDMembersAllParams defines type for all parameters for GetDashboardsIDMembers.
type GetDashboardsIDMembersAllParams struct {
	GetDashboardsIDMembersParams

	DashboardID string
}

// PostDashboardsIDMembersJSONBody defines parameters for PostDashboardsIDMembers.
type PostDashboardsIDMembersJSONBody AddResourceMemberRequestBody

// PostDashboardsIDMembersParams defines parameters for PostDashboardsIDMembers.
type PostDashboardsIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostDashboardsIDMembersAllParams defines type for all parameters for PostDashboardsIDMembers.
type PostDashboardsIDMembersAllParams struct {
	PostDashboardsIDMembersParams

	DashboardID string

	Body PostDashboardsIDMembersJSONRequestBody
}

// DeleteDashboardsIDMembersIDParams defines parameters for DeleteDashboardsIDMembersID.
type DeleteDashboardsIDMembersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteDashboardsIDMembersIDAllParams defines type for all parameters for DeleteDashboardsIDMembersID.
type DeleteDashboardsIDMembersIDAllParams struct {
	DeleteDashboardsIDMembersIDParams

	DashboardID string

	UserID string
}

// GetDashboardsIDOwnersParams defines parameters for GetDashboardsIDOwners.
type GetDashboardsIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetDashboardsIDOwnersAllParams defines type for all parameters for GetDashboardsIDOwners.
type GetDashboardsIDOwnersAllParams struct {
	GetDashboardsIDOwnersParams

	DashboardID string
}

// PostDashboardsIDOwnersJSONBody defines parameters for PostDashboardsIDOwners.
type PostDashboardsIDOwnersJSONBody AddResourceMemberRequestBody

// PostDashboardsIDOwnersParams defines parameters for PostDashboardsIDOwners.
type PostDashboardsIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostDashboardsIDOwnersAllParams defines type for all parameters for PostDashboardsIDOwners.
type PostDashboardsIDOwnersAllParams struct {
	PostDashboardsIDOwnersParams

	DashboardID string

	Body PostDashboardsIDOwnersJSONRequestBody
}

// DeleteDashboardsIDOwnersIDParams defines parameters for DeleteDashboardsIDOwnersID.
type DeleteDashboardsIDOwnersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteDashboardsIDOwnersIDAllParams defines type for all parameters for DeleteDashboardsIDOwnersID.
type DeleteDashboardsIDOwnersIDAllParams struct {
	DeleteDashboardsIDOwnersIDParams

	DashboardID string

	UserID string
}

// GetDBRPsParams defines parameters for GetDBRPs.
type GetDBRPsParams struct {
	// Specifies the organization ID to filter on
	OrgID *string `json:"orgID,omitempty"`

	// Specifies the organization name to filter on
	Org *string `json:"org,omitempty"`

	// Specifies the mapping ID to filter on
	Id *string `json:"id,omitempty"`

	// Specifies the bucket ID to filter on
	BucketID *string `json:"bucketID,omitempty"`

	// Specifies filtering on default
	Default *bool `json:"default,omitempty"`

	// Specifies the database to filter on
	Db *string `json:"db,omitempty"`

	// Specifies the retention policy to filter on
	Rp *string `json:"rp,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostDBRPJSONBody defines parameters for PostDBRP.
type PostDBRPJSONBody DBRPCreate

// PostDBRPParams defines parameters for PostDBRP.
type PostDBRPParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostDBRPAllParams defines type for all parameters for PostDBRP.
type PostDBRPAllParams struct {
	PostDBRPParams

	Body PostDBRPJSONRequestBody
}

// DeleteDBRPIDParams defines parameters for DeleteDBRPID.
type DeleteDBRPIDParams struct {
	// Specifies the organization ID of the mapping
	OrgID *string `json:"orgID,omitempty"`

	// Specifies the organization name of the mapping
	Org *string `json:"org,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteDBRPIDAllParams defines type for all parameters for DeleteDBRPID.
type DeleteDBRPIDAllParams struct {
	DeleteDBRPIDParams

	DbrpID string
}

// GetDBRPsIDParams defines parameters for GetDBRPsID.
type GetDBRPsIDParams struct {
	// Specifies the organization ID of the mapping
	OrgID *string `json:"orgID,omitempty"`

	// Specifies the organization name of the mapping
	Org *string `json:"org,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetDBRPsIDAllParams defines type for all parameters for GetDBRPsID.
type GetDBRPsIDAllParams struct {
	GetDBRPsIDParams

	DbrpID string
}

// PatchDBRPIDJSONBody defines parameters for PatchDBRPID.
type PatchDBRPIDJSONBody DBRPUpdate

// PatchDBRPIDParams defines parameters for PatchDBRPID.
type PatchDBRPIDParams struct {
	// Specifies the organization ID of the mapping
	OrgID *string `json:"orgID,omitempty"`

	// Specifies the organization name of the mapping
	Org *string `json:"org,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchDBRPIDAllParams defines type for all parameters for PatchDBRPID.
type PatchDBRPIDAllParams struct {
	PatchDBRPIDParams

	DbrpID string

	Body PatchDBRPIDJSONRequestBody
}

// PostDeleteJSONBody defines parameters for PostDelete.
type PostDeleteJSONBody DeletePredicateRequest

// PostDeleteParams defines parameters for PostDelete.
type PostDeleteParams struct {
	// The organization to delete data from.
	// If you pass both `orgID` and `org`, they must both be valid.
	//
	// #### InfluxDB Cloud
	//
	// - Doesn't require `org` or `orgID`.
	// - Deletes data from the bucket in the organization associated with the authorization (API token).
	//
	// #### InfluxDB OSS
	//
	// - Requires either `org` or `orgID`.
	Org *string `json:"org,omitempty"`

	// The name or ID of the bucket to delete data from.
	// If you pass both `bucket` and `bucketID`, `bucketID` takes precedence.
	Bucket *string `json:"bucket,omitempty"`

	// The ID of the organization to delete data from.
	// If you pass both `orgID` and `org`, they must both be valid.
	//
	// #### InfluxDB Cloud
	//
	// - Doesn't require `org` or `orgID`.
	// - Deletes data from the bucket in the organization associated with the authorization (API token).
	//
	// #### InfluxDB OSS
	//
	// - Requires either `org` or `orgID`.
	OrgID *string `json:"orgID,omitempty"`

	// The ID of the bucket to delete data from.
	// If you pass both `bucket` and `bucketID`, `bucketID` takes precedence.
	BucketID *string `json:"bucketID,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostDeleteAllParams defines type for all parameters for PostDelete.
type PostDeleteAllParams struct {
	PostDeleteParams

	Body PostDeleteJSONRequestBody
}

// GetFlagsParams defines parameters for GetFlags.
type GetFlagsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetHealthParams defines parameters for GetHealth.
type GetHealthParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetLabelsParams defines parameters for GetLabels.
type GetLabelsParams struct {
	// The organization ID.
	OrgID *string `json:"orgID,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostLabelsJSONBody defines parameters for PostLabels.
type PostLabelsJSONBody LabelCreateRequest

// PostLabelsAllParams defines type for all parameters for PostLabels.
type PostLabelsAllParams struct {
	Body PostLabelsJSONRequestBody
}

// DeleteLabelsIDParams defines parameters for DeleteLabelsID.
type DeleteLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteLabelsIDAllParams defines type for all parameters for DeleteLabelsID.
type DeleteLabelsIDAllParams struct {
	DeleteLabelsIDParams

	LabelID string
}

// GetLabelsIDParams defines parameters for GetLabelsID.
type GetLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetLabelsIDAllParams defines type for all parameters for GetLabelsID.
type GetLabelsIDAllParams struct {
	GetLabelsIDParams

	LabelID string
}

// PatchLabelsIDJSONBody defines parameters for PatchLabelsID.
type PatchLabelsIDJSONBody LabelUpdate

// PatchLabelsIDParams defines parameters for PatchLabelsID.
type PatchLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchLabelsIDAllParams defines type for all parameters for PatchLabelsID.
type PatchLabelsIDAllParams struct {
	PatchLabelsIDParams

	LabelID string

	Body PatchLabelsIDJSONRequestBody
}

// GetMeParams defines parameters for GetMe.
type GetMeParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PutMePasswordJSONBody defines parameters for PutMePassword.
type PutMePasswordJSONBody PasswordResetBody

// PutMePasswordParams defines parameters for PutMePassword.
type PutMePasswordParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PutMePasswordAllParams defines type for all parameters for PutMePassword.
type PutMePasswordAllParams struct {
	PutMePasswordParams

	Body PutMePasswordJSONRequestBody
}

// GetNotificationEndpointsParams defines parameters for GetNotificationEndpoints.
type GetNotificationEndpointsParams struct {
	// The offset for pagination.
	// The number of records to skip.
	Offset *Offset `json:"offset,omitempty"`

	// Limits the number of records returned. Default is `20`.
	Limit *Limit `json:"limit,omitempty"`

	// Only show notification endpoints that belong to specific organization ID.
	OrgID string `json:"orgID"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// CreateNotificationEndpointJSONBody defines parameters for CreateNotificationEndpoint.
type CreateNotificationEndpointJSONBody PostNotificationEndpoint

// CreateNotificationEndpointAllParams defines type for all parameters for CreateNotificationEndpoint.
type CreateNotificationEndpointAllParams struct {
	Body CreateNotificationEndpointJSONRequestBody
}

// DeleteNotificationEndpointsIDParams defines parameters for DeleteNotificationEndpointsID.
type DeleteNotificationEndpointsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteNotificationEndpointsIDAllParams defines type for all parameters for DeleteNotificationEndpointsID.
type DeleteNotificationEndpointsIDAllParams struct {
	DeleteNotificationEndpointsIDParams

	EndpointID string
}

// GetNotificationEndpointsIDParams defines parameters for GetNotificationEndpointsID.
type GetNotificationEndpointsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetNotificationEndpointsIDAllParams defines type for all parameters for GetNotificationEndpointsID.
type GetNotificationEndpointsIDAllParams struct {
	GetNotificationEndpointsIDParams

	EndpointID string
}

// PatchNotificationEndpointsIDJSONBody defines parameters for PatchNotificationEndpointsID.
type PatchNotificationEndpointsIDJSONBody NotificationEndpointUpdate

// PatchNotificationEndpointsIDParams defines parameters for PatchNotificationEndpointsID.
type PatchNotificationEndpointsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchNotificationEndpointsIDAllParams defines type for all parameters for PatchNotificationEndpointsID.
type PatchNotificationEndpointsIDAllParams struct {
	PatchNotificationEndpointsIDParams

	EndpointID string

	Body PatchNotificationEndpointsIDJSONRequestBody
}

// PutNotificationEndpointsIDJSONBody defines parameters for PutNotificationEndpointsID.
type PutNotificationEndpointsIDJSONBody NotificationEndpoint

// PutNotificationEndpointsIDParams defines parameters for PutNotificationEndpointsID.
type PutNotificationEndpointsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PutNotificationEndpointsIDAllParams defines type for all parameters for PutNotificationEndpointsID.
type PutNotificationEndpointsIDAllParams struct {
	PutNotificationEndpointsIDParams

	EndpointID string

	Body PutNotificationEndpointsIDJSONRequestBody
}

// GetNotificationEndpointsIDLabelsParams defines parameters for GetNotificationEndpointsIDLabels.
type GetNotificationEndpointsIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetNotificationEndpointsIDLabelsAllParams defines type for all parameters for GetNotificationEndpointsIDLabels.
type GetNotificationEndpointsIDLabelsAllParams struct {
	GetNotificationEndpointsIDLabelsParams

	EndpointID string
}

// PostNotificationEndpointIDLabelsJSONBody defines parameters for PostNotificationEndpointIDLabels.
type PostNotificationEndpointIDLabelsJSONBody LabelMapping

// PostNotificationEndpointIDLabelsParams defines parameters for PostNotificationEndpointIDLabels.
type PostNotificationEndpointIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostNotificationEndpointIDLabelsAllParams defines type for all parameters for PostNotificationEndpointIDLabels.
type PostNotificationEndpointIDLabelsAllParams struct {
	PostNotificationEndpointIDLabelsParams

	EndpointID string

	Body PostNotificationEndpointIDLabelsJSONRequestBody
}

// DeleteNotificationEndpointsIDLabelsIDParams defines parameters for DeleteNotificationEndpointsIDLabelsID.
type DeleteNotificationEndpointsIDLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteNotificationEndpointsIDLabelsIDAllParams defines type for all parameters for DeleteNotificationEndpointsIDLabelsID.
type DeleteNotificationEndpointsIDLabelsIDAllParams struct {
	DeleteNotificationEndpointsIDLabelsIDParams

	EndpointID string

	LabelID string
}

// GetNotificationRulesParams defines parameters for GetNotificationRules.
type GetNotificationRulesParams struct {
	// The offset for pagination.
	// The number of records to skip.
	Offset *Offset `json:"offset,omitempty"`

	// Limits the number of records returned. Default is `20`.
	Limit *Limit `json:"limit,omitempty"`

	// Only show notification rules that belong to a specific organization ID.
	OrgID string `json:"orgID"`

	// Only show notifications that belong to the specific check ID.
	CheckID *string `json:"checkID,omitempty"`

	// Only return notification rules that "would match" statuses which contain the tag key value pairs provided.
	Tag *string `json:"tag,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// CreateNotificationRuleJSONBody defines parameters for CreateNotificationRule.
type CreateNotificationRuleJSONBody PostNotificationRule

// CreateNotificationRuleAllParams defines type for all parameters for CreateNotificationRule.
type CreateNotificationRuleAllParams struct {
	Body CreateNotificationRuleJSONRequestBody
}

// DeleteNotificationRulesIDParams defines parameters for DeleteNotificationRulesID.
type DeleteNotificationRulesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteNotificationRulesIDAllParams defines type for all parameters for DeleteNotificationRulesID.
type DeleteNotificationRulesIDAllParams struct {
	DeleteNotificationRulesIDParams

	RuleID string
}

// GetNotificationRulesIDParams defines parameters for GetNotificationRulesID.
type GetNotificationRulesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetNotificationRulesIDAllParams defines type for all parameters for GetNotificationRulesID.
type GetNotificationRulesIDAllParams struct {
	GetNotificationRulesIDParams

	RuleID string
}

// PatchNotificationRulesIDJSONBody defines parameters for PatchNotificationRulesID.
type PatchNotificationRulesIDJSONBody NotificationRuleUpdate

// PatchNotificationRulesIDParams defines parameters for PatchNotificationRulesID.
type PatchNotificationRulesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchNotificationRulesIDAllParams defines type for all parameters for PatchNotificationRulesID.
type PatchNotificationRulesIDAllParams struct {
	PatchNotificationRulesIDParams

	RuleID string

	Body PatchNotificationRulesIDJSONRequestBody
}

// PutNotificationRulesIDJSONBody defines parameters for PutNotificationRulesID.
type PutNotificationRulesIDJSONBody NotificationRule

// PutNotificationRulesIDParams defines parameters for PutNotificationRulesID.
type PutNotificationRulesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PutNotificationRulesIDAllParams defines type for all parameters for PutNotificationRulesID.
type PutNotificationRulesIDAllParams struct {
	PutNotificationRulesIDParams

	RuleID string

	Body PutNotificationRulesIDJSONRequestBody
}

// GetNotificationRulesIDLabelsParams defines parameters for GetNotificationRulesIDLabels.
type GetNotificationRulesIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetNotificationRulesIDLabelsAllParams defines type for all parameters for GetNotificationRulesIDLabels.
type GetNotificationRulesIDLabelsAllParams struct {
	GetNotificationRulesIDLabelsParams

	RuleID string
}

// PostNotificationRuleIDLabelsJSONBody defines parameters for PostNotificationRuleIDLabels.
type PostNotificationRuleIDLabelsJSONBody LabelMapping

// PostNotificationRuleIDLabelsParams defines parameters for PostNotificationRuleIDLabels.
type PostNotificationRuleIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostNotificationRuleIDLabelsAllParams defines type for all parameters for PostNotificationRuleIDLabels.
type PostNotificationRuleIDLabelsAllParams struct {
	PostNotificationRuleIDLabelsParams

	RuleID string

	Body PostNotificationRuleIDLabelsJSONRequestBody
}

// DeleteNotificationRulesIDLabelsIDParams defines parameters for DeleteNotificationRulesIDLabelsID.
type DeleteNotificationRulesIDLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteNotificationRulesIDLabelsIDAllParams defines type for all parameters for DeleteNotificationRulesIDLabelsID.
type DeleteNotificationRulesIDLabelsIDAllParams struct {
	DeleteNotificationRulesIDLabelsIDParams

	RuleID string

	LabelID string
}

// GetNotificationRulesIDQueryParams defines parameters for GetNotificationRulesIDQuery.
type GetNotificationRulesIDQueryParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetNotificationRulesIDQueryAllParams defines type for all parameters for GetNotificationRulesIDQuery.
type GetNotificationRulesIDQueryAllParams struct {
	GetNotificationRulesIDQueryParams

	RuleID string
}

// GetOrgsParams defines parameters for GetOrgs.
type GetOrgsParams struct {
	// The offset for pagination.
	// The number of records to skip.
	Offset *Offset `json:"offset,omitempty"`

	// Limits the number of records returned. Default is `20`.
	Limit      *Limit      `json:"limit,omitempty"`
	Descending *Descending `json:"descending,omitempty"`

	// An organization name.
	// Only returns organizations with this name.
	Org *string `json:"org,omitempty"`

	// An organization ID.
	// Only returns the organization with this ID.
	OrgID *string `json:"orgID,omitempty"`

	// A user ID.
	// Only returns organizations where this user is a member or owner.
	UserID *string `json:"userID,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostOrgsJSONBody defines parameters for PostOrgs.
type PostOrgsJSONBody PostOrganizationRequest

// PostOrgsParams defines parameters for PostOrgs.
type PostOrgsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostOrgsAllParams defines type for all parameters for PostOrgs.
type PostOrgsAllParams struct {
	PostOrgsParams

	Body PostOrgsJSONRequestBody
}

// DeleteOrgsIDParams defines parameters for DeleteOrgsID.
type DeleteOrgsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteOrgsIDAllParams defines type for all parameters for DeleteOrgsID.
type DeleteOrgsIDAllParams struct {
	DeleteOrgsIDParams

	OrgID string
}

// GetOrgsIDParams defines parameters for GetOrgsID.
type GetOrgsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetOrgsIDAllParams defines type for all parameters for GetOrgsID.
type GetOrgsIDAllParams struct {
	GetOrgsIDParams

	OrgID string
}

// PatchOrgsIDJSONBody defines parameters for PatchOrgsID.
type PatchOrgsIDJSONBody PatchOrganizationRequest

// PatchOrgsIDParams defines parameters for PatchOrgsID.
type PatchOrgsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchOrgsIDAllParams defines type for all parameters for PatchOrgsID.
type PatchOrgsIDAllParams struct {
	PatchOrgsIDParams

	OrgID string

	Body PatchOrgsIDJSONRequestBody
}

// GetOrgsIDMembersParams defines parameters for GetOrgsIDMembers.
type GetOrgsIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetOrgsIDMembersAllParams defines type for all parameters for GetOrgsIDMembers.
type GetOrgsIDMembersAllParams struct {
	GetOrgsIDMembersParams

	OrgID string
}

// PostOrgsIDMembersJSONBody defines parameters for PostOrgsIDMembers.
type PostOrgsIDMembersJSONBody AddResourceMemberRequestBody

// PostOrgsIDMembersParams defines parameters for PostOrgsIDMembers.
type PostOrgsIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostOrgsIDMembersAllParams defines type for all parameters for PostOrgsIDMembers.
type PostOrgsIDMembersAllParams struct {
	PostOrgsIDMembersParams

	OrgID string

	Body PostOrgsIDMembersJSONRequestBody
}

// DeleteOrgsIDMembersIDParams defines parameters for DeleteOrgsIDMembersID.
type DeleteOrgsIDMembersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteOrgsIDMembersIDAllParams defines type for all parameters for DeleteOrgsIDMembersID.
type DeleteOrgsIDMembersIDAllParams struct {
	DeleteOrgsIDMembersIDParams

	OrgID string

	UserID string
}

// GetOrgsIDOwnersParams defines parameters for GetOrgsIDOwners.
type GetOrgsIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetOrgsIDOwnersAllParams defines type for all parameters for GetOrgsIDOwners.
type GetOrgsIDOwnersAllParams struct {
	GetOrgsIDOwnersParams

	OrgID string
}

// PostOrgsIDOwnersJSONBody defines parameters for PostOrgsIDOwners.
type PostOrgsIDOwnersJSONBody AddResourceMemberRequestBody

// PostOrgsIDOwnersParams defines parameters for PostOrgsIDOwners.
type PostOrgsIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostOrgsIDOwnersAllParams defines type for all parameters for PostOrgsIDOwners.
type PostOrgsIDOwnersAllParams struct {
	PostOrgsIDOwnersParams

	OrgID string

	Body PostOrgsIDOwnersJSONRequestBody
}

// DeleteOrgsIDOwnersIDParams defines parameters for DeleteOrgsIDOwnersID.
type DeleteOrgsIDOwnersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteOrgsIDOwnersIDAllParams defines type for all parameters for DeleteOrgsIDOwnersID.
type DeleteOrgsIDOwnersIDAllParams struct {
	DeleteOrgsIDOwnersIDParams

	OrgID string

	UserID string
}

// GetOrgsIDSecretsParams defines parameters for GetOrgsIDSecrets.
type GetOrgsIDSecretsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetOrgsIDSecretsAllParams defines type for all parameters for GetOrgsIDSecrets.
type GetOrgsIDSecretsAllParams struct {
	GetOrgsIDSecretsParams

	OrgID string
}

// PatchOrgsIDSecretsJSONBody defines parameters for PatchOrgsIDSecrets.
type PatchOrgsIDSecretsJSONBody Secrets

// PatchOrgsIDSecretsParams defines parameters for PatchOrgsIDSecrets.
type PatchOrgsIDSecretsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchOrgsIDSecretsAllParams defines type for all parameters for PatchOrgsIDSecrets.
type PatchOrgsIDSecretsAllParams struct {
	PatchOrgsIDSecretsParams

	OrgID string

	Body PatchOrgsIDSecretsJSONRequestBody
}

// PostOrgsIDSecretsJSONBody defines parameters for PostOrgsIDSecrets.
type PostOrgsIDSecretsJSONBody SecretKeys

// PostOrgsIDSecretsParams defines parameters for PostOrgsIDSecrets.
type PostOrgsIDSecretsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostOrgsIDSecretsAllParams defines type for all parameters for PostOrgsIDSecrets.
type PostOrgsIDSecretsAllParams struct {
	PostOrgsIDSecretsParams

	OrgID string

	Body PostOrgsIDSecretsJSONRequestBody
}

// DeleteOrgsIDSecretsIDParams defines parameters for DeleteOrgsIDSecretsID.
type DeleteOrgsIDSecretsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteOrgsIDSecretsIDAllParams defines type for all parameters for DeleteOrgsIDSecretsID.
type DeleteOrgsIDSecretsIDAllParams struct {
	DeleteOrgsIDSecretsIDParams

	OrgID string

	SecretID string
}

// PostQueryAnalyzeJSONBody defines parameters for PostQueryAnalyze.
type PostQueryAnalyzeJSONBody Query

// PostQueryAnalyzeParams defines parameters for PostQueryAnalyze.
type PostQueryAnalyzeParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan                         `json:"Zap-Trace-Span,omitempty"`
	ContentType  *PostQueryAnalyzeParamsContentType `json:"Content-Type,omitempty"`
}

// PostQueryAnalyzeParamsContentType defines parameters for PostQueryAnalyze.
type PostQueryAnalyzeParamsContentType string

// PostQueryAnalyzeAllParams defines type for all parameters for PostQueryAnalyze.
type PostQueryAnalyzeAllParams struct {
	PostQueryAnalyzeParams

	Body PostQueryAnalyzeJSONRequestBody
}

// PostQueryAstJSONBody defines parameters for PostQueryAst.
type PostQueryAstJSONBody LanguageRequest

// PostQueryAstParams defines parameters for PostQueryAst.
type PostQueryAstParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan                     `json:"Zap-Trace-Span,omitempty"`
	ContentType  *PostQueryAstParamsContentType `json:"Content-Type,omitempty"`
}

// PostQueryAstParamsContentType defines parameters for PostQueryAst.
type PostQueryAstParamsContentType string

// PostQueryAstAllParams defines type for all parameters for PostQueryAst.
type PostQueryAstAllParams struct {
	PostQueryAstParams

	Body PostQueryAstJSONRequestBody
}

// GetQuerySuggestionsParams defines parameters for GetQuerySuggestions.
type GetQuerySuggestionsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetQuerySuggestionsNameParams defines parameters for GetQuerySuggestionsName.
type GetQuerySuggestionsNameParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetQuerySuggestionsNameAllParams defines type for all parameters for GetQuerySuggestionsName.
type GetQuerySuggestionsNameAllParams struct {
	GetQuerySuggestionsNameParams

	Name string
}

// GetReadyParams defines parameters for GetReady.
type GetReadyParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetRemoteConnectionsParams defines parameters for GetRemoteConnections.
type GetRemoteConnectionsParams struct {
	// The organization ID.
	OrgID     string  `json:"orgID"`
	Name      *string `json:"name,omitempty"`
	RemoteURL *string `json:"remoteURL,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostRemoteConnectionJSONBody defines parameters for PostRemoteConnection.
type PostRemoteConnectionJSONBody RemoteConnectionCreationRequest

// PostRemoteConnectionAllParams defines type for all parameters for PostRemoteConnection.
type PostRemoteConnectionAllParams struct {
	Body PostRemoteConnectionJSONRequestBody
}

// DeleteRemoteConnectionByIDParams defines parameters for DeleteRemoteConnectionByID.
type DeleteRemoteConnectionByIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteRemoteConnectionByIDAllParams defines type for all parameters for DeleteRemoteConnectionByID.
type DeleteRemoteConnectionByIDAllParams struct {
	DeleteRemoteConnectionByIDParams

	RemoteID string
}

// GetRemoteConnectionByIDParams defines parameters for GetRemoteConnectionByID.
type GetRemoteConnectionByIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetRemoteConnectionByIDAllParams defines type for all parameters for GetRemoteConnectionByID.
type GetRemoteConnectionByIDAllParams struct {
	GetRemoteConnectionByIDParams

	RemoteID string
}

// PatchRemoteConnectionByIDJSONBody defines parameters for PatchRemoteConnectionByID.
type PatchRemoteConnectionByIDJSONBody RemoteConnectionUpdateRequest

// PatchRemoteConnectionByIDParams defines parameters for PatchRemoteConnectionByID.
type PatchRemoteConnectionByIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchRemoteConnectionByIDAllParams defines type for all parameters for PatchRemoteConnectionByID.
type PatchRemoteConnectionByIDAllParams struct {
	PatchRemoteConnectionByIDParams

	RemoteID string

	Body PatchRemoteConnectionByIDJSONRequestBody
}

// GetReplicationsParams defines parameters for GetReplications.
type GetReplicationsParams struct {
	// The organization ID.
	OrgID         string  `json:"orgID"`
	Name          *string `json:"name,omitempty"`
	RemoteID      *string `json:"remoteID,omitempty"`
	LocalBucketID *string `json:"localBucketID,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostReplicationJSONBody defines parameters for PostReplication.
type PostReplicationJSONBody ReplicationCreationRequest

// PostReplicationParams defines parameters for PostReplication.
type PostReplicationParams struct {
	// If true, validate the replication, but don't save it.
	Validate *bool `json:"validate,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostReplicationAllParams defines type for all parameters for PostReplication.
type PostReplicationAllParams struct {
	PostReplicationParams

	Body PostReplicationJSONRequestBody
}

// DeleteReplicationByIDParams defines parameters for DeleteReplicationByID.
type DeleteReplicationByIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteReplicationByIDAllParams defines type for all parameters for DeleteReplicationByID.
type DeleteReplicationByIDAllParams struct {
	DeleteReplicationByIDParams

	ReplicationID string
}

// GetReplicationByIDParams defines parameters for GetReplicationByID.
type GetReplicationByIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetReplicationByIDAllParams defines type for all parameters for GetReplicationByID.
type GetReplicationByIDAllParams struct {
	GetReplicationByIDParams

	ReplicationID string
}

// PatchReplicationByIDJSONBody defines parameters for PatchReplicationByID.
type PatchReplicationByIDJSONBody ReplicationUpdateRequest

// PatchReplicationByIDParams defines parameters for PatchReplicationByID.
type PatchReplicationByIDParams struct {
	// If true, validate the updated information, but don't save it.
	Validate *bool `json:"validate,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchReplicationByIDAllParams defines type for all parameters for PatchReplicationByID.
type PatchReplicationByIDAllParams struct {
	PatchReplicationByIDParams

	ReplicationID string

	Body PatchReplicationByIDJSONRequestBody
}

// PostValidateReplicationByIDParams defines parameters for PostValidateReplicationByID.
type PostValidateReplicationByIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostValidateReplicationByIDAllParams defines type for all parameters for PostValidateReplicationByID.
type PostValidateReplicationByIDAllParams struct {
	PostValidateReplicationByIDParams

	ReplicationID string
}

// GetResourcesParams defines parameters for GetResources.
type GetResourcesParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostRestoreBucketMetadataJSONBody defines parameters for PostRestoreBucketMetadata.
type PostRestoreBucketMetadataJSONBody BucketMetadataManifest

// PostRestoreBucketMetadataParams defines parameters for PostRestoreBucketMetadata.
type PostRestoreBucketMetadataParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostRestoreBucketMetadataAllParams defines type for all parameters for PostRestoreBucketMetadata.
type PostRestoreBucketMetadataAllParams struct {
	PostRestoreBucketMetadataParams

	Body PostRestoreBucketMetadataJSONRequestBody
}

// GetScrapersParams defines parameters for GetScrapers.
type GetScrapersParams struct {
	// Specifies the name of the scraper target.
	Name *string `json:"name,omitempty"`

	// List of scraper target IDs to return. If both `id` and `owner` are specified, only `id` is used.
	Id *[]string `json:"id,omitempty"`

	// Specifies the organization ID of the scraper target.
	OrgID *string `json:"orgID,omitempty"`

	// Specifies the organization name of the scraper target.
	Org *string `json:"org,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostScrapersJSONBody defines parameters for PostScrapers.
type PostScrapersJSONBody ScraperTargetRequest

// PostScrapersParams defines parameters for PostScrapers.
type PostScrapersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostScrapersAllParams defines type for all parameters for PostScrapers.
type PostScrapersAllParams struct {
	PostScrapersParams

	Body PostScrapersJSONRequestBody
}

// DeleteScrapersIDParams defines parameters for DeleteScrapersID.
type DeleteScrapersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteScrapersIDAllParams defines type for all parameters for DeleteScrapersID.
type DeleteScrapersIDAllParams struct {
	DeleteScrapersIDParams

	ScraperTargetID string
}

// GetScrapersIDParams defines parameters for GetScrapersID.
type GetScrapersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetScrapersIDAllParams defines type for all parameters for GetScrapersID.
type GetScrapersIDAllParams struct {
	GetScrapersIDParams

	ScraperTargetID string
}

// PatchScrapersIDJSONBody defines parameters for PatchScrapersID.
type PatchScrapersIDJSONBody ScraperTargetRequest

// PatchScrapersIDParams defines parameters for PatchScrapersID.
type PatchScrapersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchScrapersIDAllParams defines type for all parameters for PatchScrapersID.
type PatchScrapersIDAllParams struct {
	PatchScrapersIDParams

	ScraperTargetID string

	Body PatchScrapersIDJSONRequestBody
}

// GetScrapersIDLabelsParams defines parameters for GetScrapersIDLabels.
type GetScrapersIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetScrapersIDLabelsAllParams defines type for all parameters for GetScrapersIDLabels.
type GetScrapersIDLabelsAllParams struct {
	GetScrapersIDLabelsParams

	ScraperTargetID string
}

// PostScrapersIDLabelsJSONBody defines parameters for PostScrapersIDLabels.
type PostScrapersIDLabelsJSONBody LabelMapping

// PostScrapersIDLabelsParams defines parameters for PostScrapersIDLabels.
type PostScrapersIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostScrapersIDLabelsAllParams defines type for all parameters for PostScrapersIDLabels.
type PostScrapersIDLabelsAllParams struct {
	PostScrapersIDLabelsParams

	ScraperTargetID string

	Body PostScrapersIDLabelsJSONRequestBody
}

// DeleteScrapersIDLabelsIDParams defines parameters for DeleteScrapersIDLabelsID.
type DeleteScrapersIDLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteScrapersIDLabelsIDAllParams defines type for all parameters for DeleteScrapersIDLabelsID.
type DeleteScrapersIDLabelsIDAllParams struct {
	DeleteScrapersIDLabelsIDParams

	ScraperTargetID string

	LabelID string
}

// GetScrapersIDMembersParams defines parameters for GetScrapersIDMembers.
type GetScrapersIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetScrapersIDMembersAllParams defines type for all parameters for GetScrapersIDMembers.
type GetScrapersIDMembersAllParams struct {
	GetScrapersIDMembersParams

	ScraperTargetID string
}

// PostScrapersIDMembersJSONBody defines parameters for PostScrapersIDMembers.
type PostScrapersIDMembersJSONBody AddResourceMemberRequestBody

// PostScrapersIDMembersParams defines parameters for PostScrapersIDMembers.
type PostScrapersIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostScrapersIDMembersAllParams defines type for all parameters for PostScrapersIDMembers.
type PostScrapersIDMembersAllParams struct {
	PostScrapersIDMembersParams

	ScraperTargetID string

	Body PostScrapersIDMembersJSONRequestBody
}

// DeleteScrapersIDMembersIDParams defines parameters for DeleteScrapersIDMembersID.
type DeleteScrapersIDMembersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteScrapersIDMembersIDAllParams defines type for all parameters for DeleteScrapersIDMembersID.
type DeleteScrapersIDMembersIDAllParams struct {
	DeleteScrapersIDMembersIDParams

	ScraperTargetID string

	UserID string
}

// GetScrapersIDOwnersParams defines parameters for GetScrapersIDOwners.
type GetScrapersIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetScrapersIDOwnersAllParams defines type for all parameters for GetScrapersIDOwners.
type GetScrapersIDOwnersAllParams struct {
	GetScrapersIDOwnersParams

	ScraperTargetID string
}

// PostScrapersIDOwnersJSONBody defines parameters for PostScrapersIDOwners.
type PostScrapersIDOwnersJSONBody AddResourceMemberRequestBody

// PostScrapersIDOwnersParams defines parameters for PostScrapersIDOwners.
type PostScrapersIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostScrapersIDOwnersAllParams defines type for all parameters for PostScrapersIDOwners.
type PostScrapersIDOwnersAllParams struct {
	PostScrapersIDOwnersParams

	ScraperTargetID string

	Body PostScrapersIDOwnersJSONRequestBody
}

// DeleteScrapersIDOwnersIDParams defines parameters for DeleteScrapersIDOwnersID.
type DeleteScrapersIDOwnersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteScrapersIDOwnersIDAllParams defines type for all parameters for DeleteScrapersIDOwnersID.
type DeleteScrapersIDOwnersIDAllParams struct {
	DeleteScrapersIDOwnersIDParams

	ScraperTargetID string

	UserID string
}

// GetSetupParams defines parameters for GetSetup.
type GetSetupParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostSetupJSONBody defines parameters for PostSetup.
type PostSetupJSONBody OnboardingRequest

// PostSetupParams defines parameters for PostSetup.
type PostSetupParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostSetupAllParams defines type for all parameters for PostSetup.
type PostSetupAllParams struct {
	PostSetupParams

	Body PostSetupJSONRequestBody
}

// PostSigninParams defines parameters for PostSignin.
type PostSigninParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostSignoutParams defines parameters for PostSignout.
type PostSignoutParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetSourcesParams defines parameters for GetSources.
type GetSourcesParams struct {
	// The name of the organization.
	Org *string `json:"org,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostSourcesJSONBody defines parameters for PostSources.
type PostSourcesJSONBody Source

// PostSourcesParams defines parameters for PostSources.
type PostSourcesParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostSourcesAllParams defines type for all parameters for PostSources.
type PostSourcesAllParams struct {
	PostSourcesParams

	Body PostSourcesJSONRequestBody
}

// DeleteSourcesIDParams defines parameters for DeleteSourcesID.
type DeleteSourcesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteSourcesIDAllParams defines type for all parameters for DeleteSourcesID.
type DeleteSourcesIDAllParams struct {
	DeleteSourcesIDParams

	SourceID string
}

// GetSourcesIDParams defines parameters for GetSourcesID.
type GetSourcesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetSourcesIDAllParams defines type for all parameters for GetSourcesID.
type GetSourcesIDAllParams struct {
	GetSourcesIDParams

	SourceID string
}

// PatchSourcesIDJSONBody defines parameters for PatchSourcesID.
type PatchSourcesIDJSONBody Source

// PatchSourcesIDParams defines parameters for PatchSourcesID.
type PatchSourcesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchSourcesIDAllParams defines type for all parameters for PatchSourcesID.
type PatchSourcesIDAllParams struct {
	PatchSourcesIDParams

	SourceID string

	Body PatchSourcesIDJSONRequestBody
}

// GetSourcesIDBucketsParams defines parameters for GetSourcesIDBuckets.
type GetSourcesIDBucketsParams struct {
	// The name of the organization.
	Org *string `json:"org,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetSourcesIDBucketsAllParams defines type for all parameters for GetSourcesIDBuckets.
type GetSourcesIDBucketsAllParams struct {
	GetSourcesIDBucketsParams

	SourceID string
}

// GetSourcesIDHealthParams defines parameters for GetSourcesIDHealth.
type GetSourcesIDHealthParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetSourcesIDHealthAllParams defines type for all parameters for GetSourcesIDHealth.
type GetSourcesIDHealthAllParams struct {
	GetSourcesIDHealthParams

	SourceID string
}

// ListStacksParams defines parameters for ListStacks.
type ListStacksParams struct {
	// The ID of the organization that owns the stacks.
	// Only returns stacks owned by this organization.
	//
	// #### InfluxDB Cloud
	//
	// - Doesn't require this parameter;
	//   InfluxDB only returns resources allowed by the API token.
	OrgID string `json:"orgID"`

	// The stack name.
	// Finds stack `events` with this name and returns the stacks.
	//
	// Repeatable.
	// To filter for more than one stack name,
	// repeat this parameter with each name--for example:
	//
	// - `http://localhost:8086/api/v2/stacks?&orgID=INFLUX_ORG_ID&name=project-stack-0&name=project-stack-1`
	Name *string `json:"name,omitempty"`

	// The stack ID.
	// Only returns stacks with this ID.
	//
	// Repeatable.
	// To filter for more than one stack ID,
	// repeat this parameter with each ID--for example:
	//
	// - `http://localhost:8086/api/v2/stacks?&orgID=INFLUX_ORG_ID&stackID=09bd87cd33be3000&stackID=09bef35081fe3000`
	StackID *string `json:"stackID,omitempty"`
}

// CreateStackJSONBody defines parameters for CreateStack.
type CreateStackJSONBody struct {
	Description *string   `json:"description,omitempty"`
	Name        *string   `json:"name,omitempty"`
	OrgID       *string   `json:"orgID,omitempty"`
	Urls        *[]string `json:"urls,omitempty"`
}

// CreateStackAllParams defines type for all parameters for CreateStack.
type CreateStackAllParams struct {
	Body CreateStackJSONRequestBody
}

// DeleteStackParams defines parameters for DeleteStack.
type DeleteStackParams struct {
	// The identifier of the organization.
	OrgID string `json:"orgID"`
}

// DeleteStackAllParams defines type for all parameters for DeleteStack.
type DeleteStackAllParams struct {
	DeleteStackParams

	StackId string
}

// ReadStackAllParams defines type for all parameters for ReadStack.
type ReadStackAllParams struct {
	StackId string
}

// UpdateStackJSONBody defines parameters for UpdateStack.
type UpdateStackJSONBody struct {
	AdditionalResources *[]struct {
		Kind             string  `json:"kind"`
		ResourceID       string  `json:"resourceID"`
		TemplateMetaName *string `json:"templateMetaName,omitempty"`
	} `json:"additionalResources,omitempty"`
	Description  *string   `json:"description"`
	Name         *string   `json:"name"`
	TemplateURLs *[]string `json:"templateURLs"`
}

// UpdateStackAllParams defines type for all parameters for UpdateStack.
type UpdateStackAllParams struct {
	StackId string

	Body UpdateStackJSONRequestBody
}

// UninstallStackAllParams defines type for all parameters for UninstallStack.
type UninstallStackAllParams struct {
	StackId string
}

// GetTasksParams defines parameters for GetTasks.
type GetTasksParams struct {
	// Task name.
	// Only returns tasks with this name.
	// Different tasks may have the same name.
	Name *string `json:"name,omitempty"`

	// Task ID.
	// Only returns tasks created after this task.
	After *string `json:"after,omitempty"`

	// User ID.
	// Only returns tasks owned by this user.
	User *string `json:"user,omitempty"`

	// Organization name.
	// Only returns tasks owned by this organization.
	Org *string `json:"org,omitempty"`

	// Organization ID.
	// Only returns tasks owned by this organization.
	OrgID *string `json:"orgID,omitempty"`

	// Task status (`active` or `inactive`).
	// Only returns tasks with this status.
	Status *GetTasksParamsStatus `json:"status,omitempty"`

	// Limits the number of tasks returned.
	// The minimum is `1`, the maximum is `500`, and the default is `100`.
	Limit *int `json:"limit,omitempty"`

	// Task type (`basic` or `system`).
	//
	// The default (`system`) response contains all the metadata properties for tasks.
	// To reduce the payload size, pass `basic` to omit some task properties (`flux`, `createdAt`, `updatedAt`) from the response.
	Type *GetTasksParamsType `json:"type,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTasksParamsStatus defines parameters for GetTasks.
type GetTasksParamsStatus string

// GetTasksParamsType defines parameters for GetTasks.
type GetTasksParamsType string

// PostTasksJSONBody defines parameters for PostTasks.
type PostTasksJSONBody TaskCreateRequest

// PostTasksParams defines parameters for PostTasks.
type PostTasksParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTasksAllParams defines type for all parameters for PostTasks.
type PostTasksAllParams struct {
	PostTasksParams

	Body PostTasksJSONRequestBody
}

// DeleteTasksIDParams defines parameters for DeleteTasksID.
type DeleteTasksIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteTasksIDAllParams defines type for all parameters for DeleteTasksID.
type DeleteTasksIDAllParams struct {
	DeleteTasksIDParams

	TaskID string
}

// GetTasksIDParams defines parameters for GetTasksID.
type GetTasksIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTasksIDAllParams defines type for all parameters for GetTasksID.
type GetTasksIDAllParams struct {
	GetTasksIDParams

	TaskID string
}

// PatchTasksIDJSONBody defines parameters for PatchTasksID.
type PatchTasksIDJSONBody TaskUpdateRequest

// PatchTasksIDParams defines parameters for PatchTasksID.
type PatchTasksIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchTasksIDAllParams defines type for all parameters for PatchTasksID.
type PatchTasksIDAllParams struct {
	PatchTasksIDParams

	TaskID string

	Body PatchTasksIDJSONRequestBody
}

// GetTasksIDLabelsParams defines parameters for GetTasksIDLabels.
type GetTasksIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTasksIDLabelsAllParams defines type for all parameters for GetTasksIDLabels.
type GetTasksIDLabelsAllParams struct {
	GetTasksIDLabelsParams

	TaskID string
}

// PostTasksIDLabelsJSONBody defines parameters for PostTasksIDLabels.
type PostTasksIDLabelsJSONBody LabelMapping

// PostTasksIDLabelsParams defines parameters for PostTasksIDLabels.
type PostTasksIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTasksIDLabelsAllParams defines type for all parameters for PostTasksIDLabels.
type PostTasksIDLabelsAllParams struct {
	PostTasksIDLabelsParams

	TaskID string

	Body PostTasksIDLabelsJSONRequestBody
}

// DeleteTasksIDLabelsIDParams defines parameters for DeleteTasksIDLabelsID.
type DeleteTasksIDLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteTasksIDLabelsIDAllParams defines type for all parameters for DeleteTasksIDLabelsID.
type DeleteTasksIDLabelsIDAllParams struct {
	DeleteTasksIDLabelsIDParams

	TaskID string

	LabelID string
}

// GetTasksIDLogsParams defines parameters for GetTasksIDLogs.
type GetTasksIDLogsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTasksIDLogsAllParams defines type for all parameters for GetTasksIDLogs.
type GetTasksIDLogsAllParams struct {
	GetTasksIDLogsParams

	TaskID string
}

// GetTasksIDMembersParams defines parameters for GetTasksIDMembers.
type GetTasksIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTasksIDMembersAllParams defines type for all parameters for GetTasksIDMembers.
type GetTasksIDMembersAllParams struct {
	GetTasksIDMembersParams

	TaskID string
}

// PostTasksIDMembersJSONBody defines parameters for PostTasksIDMembers.
type PostTasksIDMembersJSONBody AddResourceMemberRequestBody

// PostTasksIDMembersParams defines parameters for PostTasksIDMembers.
type PostTasksIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTasksIDMembersAllParams defines type for all parameters for PostTasksIDMembers.
type PostTasksIDMembersAllParams struct {
	PostTasksIDMembersParams

	TaskID string

	Body PostTasksIDMembersJSONRequestBody
}

// DeleteTasksIDMembersIDParams defines parameters for DeleteTasksIDMembersID.
type DeleteTasksIDMembersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteTasksIDMembersIDAllParams defines type for all parameters for DeleteTasksIDMembersID.
type DeleteTasksIDMembersIDAllParams struct {
	DeleteTasksIDMembersIDParams

	TaskID string

	UserID string
}

// GetTasksIDOwnersParams defines parameters for GetTasksIDOwners.
type GetTasksIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTasksIDOwnersAllParams defines type for all parameters for GetTasksIDOwners.
type GetTasksIDOwnersAllParams struct {
	GetTasksIDOwnersParams

	TaskID string
}

// PostTasksIDOwnersJSONBody defines parameters for PostTasksIDOwners.
type PostTasksIDOwnersJSONBody AddResourceMemberRequestBody

// PostTasksIDOwnersParams defines parameters for PostTasksIDOwners.
type PostTasksIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTasksIDOwnersAllParams defines type for all parameters for PostTasksIDOwners.
type PostTasksIDOwnersAllParams struct {
	PostTasksIDOwnersParams

	TaskID string

	Body PostTasksIDOwnersJSONRequestBody
}

// DeleteTasksIDOwnersIDParams defines parameters for DeleteTasksIDOwnersID.
type DeleteTasksIDOwnersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteTasksIDOwnersIDAllParams defines type for all parameters for DeleteTasksIDOwnersID.
type DeleteTasksIDOwnersIDAllParams struct {
	DeleteTasksIDOwnersIDParams

	TaskID string

	UserID string
}

// GetTasksIDRunsParams defines parameters for GetTasksIDRuns.
type GetTasksIDRunsParams struct {
	// A task run ID. Only returns runs created after this run.
	After *string `json:"after,omitempty"`

	// Limits the number of task runs returned. Default is `100`.
	Limit *int `json:"limit,omitempty"`

	// A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)).
	// Only returns runs scheduled after this time.
	AfterTime *time.Time `json:"afterTime,omitempty"`

	// A timestamp ([RFC3339 date/time format](https://docs.influxdata.com/influxdb/v2.3/reference/glossary/#rfc3339-timestamp)).
	// Only returns runs scheduled before this time.
	BeforeTime *time.Time `json:"beforeTime,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTasksIDRunsAllParams defines type for all parameters for GetTasksIDRuns.
type GetTasksIDRunsAllParams struct {
	GetTasksIDRunsParams

	TaskID string
}

// PostTasksIDRunsJSONBody defines parameters for PostTasksIDRuns.
type PostTasksIDRunsJSONBody RunManually

// PostTasksIDRunsParams defines parameters for PostTasksIDRuns.
type PostTasksIDRunsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTasksIDRunsAllParams defines type for all parameters for PostTasksIDRuns.
type PostTasksIDRunsAllParams struct {
	PostTasksIDRunsParams

	TaskID string

	Body PostTasksIDRunsJSONRequestBody
}

// DeleteTasksIDRunsIDParams defines parameters for DeleteTasksIDRunsID.
type DeleteTasksIDRunsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteTasksIDRunsIDAllParams defines type for all parameters for DeleteTasksIDRunsID.
type DeleteTasksIDRunsIDAllParams struct {
	DeleteTasksIDRunsIDParams

	TaskID string

	RunID string
}

// GetTasksIDRunsIDParams defines parameters for GetTasksIDRunsID.
type GetTasksIDRunsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTasksIDRunsIDAllParams defines type for all parameters for GetTasksIDRunsID.
type GetTasksIDRunsIDAllParams struct {
	GetTasksIDRunsIDParams

	TaskID string

	RunID string
}

// GetTasksIDRunsIDLogsParams defines parameters for GetTasksIDRunsIDLogs.
type GetTasksIDRunsIDLogsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTasksIDRunsIDLogsAllParams defines type for all parameters for GetTasksIDRunsIDLogs.
type GetTasksIDRunsIDLogsAllParams struct {
	GetTasksIDRunsIDLogsParams

	TaskID string

	RunID string
}

// PostTasksIDRunsIDRetryJSONBody defines parameters for PostTasksIDRunsIDRetry.
type PostTasksIDRunsIDRetryJSONBody map[string]interface{}

// PostTasksIDRunsIDRetryParams defines parameters for PostTasksIDRunsIDRetry.
type PostTasksIDRunsIDRetryParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTasksIDRunsIDRetryAllParams defines type for all parameters for PostTasksIDRunsIDRetry.
type PostTasksIDRunsIDRetryAllParams struct {
	PostTasksIDRunsIDRetryParams

	TaskID string

	RunID string

	Body PostTasksIDRunsIDRetryJSONRequestBody
}

// GetTelegrafPluginsParams defines parameters for GetTelegrafPlugins.
type GetTelegrafPluginsParams struct {
	// The type of plugin desired.
	Type *string `json:"type,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTelegrafsParams defines parameters for GetTelegrafs.
type GetTelegrafsParams struct {
	// The organization ID the Telegraf config belongs to.
	OrgID *string `json:"orgID,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTelegrafsJSONBody defines parameters for PostTelegrafs.
type PostTelegrafsJSONBody TelegrafPluginRequest

// PostTelegrafsParams defines parameters for PostTelegrafs.
type PostTelegrafsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTelegrafsAllParams defines type for all parameters for PostTelegrafs.
type PostTelegrafsAllParams struct {
	PostTelegrafsParams

	Body PostTelegrafsJSONRequestBody
}

// DeleteTelegrafsIDParams defines parameters for DeleteTelegrafsID.
type DeleteTelegrafsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteTelegrafsIDAllParams defines type for all parameters for DeleteTelegrafsID.
type DeleteTelegrafsIDAllParams struct {
	DeleteTelegrafsIDParams

	TelegrafID string
}

// GetTelegrafsIDParams defines parameters for GetTelegrafsID.
type GetTelegrafsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan                  `json:"Zap-Trace-Span,omitempty"`
	Accept       *GetTelegrafsIDParamsAccept `json:"Accept,omitempty"`
}

// GetTelegrafsIDParamsAccept defines parameters for GetTelegrafsID.
type GetTelegrafsIDParamsAccept string

// GetTelegrafsIDAllParams defines type for all parameters for GetTelegrafsID.
type GetTelegrafsIDAllParams struct {
	GetTelegrafsIDParams

	TelegrafID string
}

// PutTelegrafsIDJSONBody defines parameters for PutTelegrafsID.
type PutTelegrafsIDJSONBody TelegrafPluginRequest

// PutTelegrafsIDParams defines parameters for PutTelegrafsID.
type PutTelegrafsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PutTelegrafsIDAllParams defines type for all parameters for PutTelegrafsID.
type PutTelegrafsIDAllParams struct {
	PutTelegrafsIDParams

	TelegrafID string

	Body PutTelegrafsIDJSONRequestBody
}

// GetTelegrafsIDLabelsParams defines parameters for GetTelegrafsIDLabels.
type GetTelegrafsIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTelegrafsIDLabelsAllParams defines type for all parameters for GetTelegrafsIDLabels.
type GetTelegrafsIDLabelsAllParams struct {
	GetTelegrafsIDLabelsParams

	TelegrafID string
}

// PostTelegrafsIDLabelsJSONBody defines parameters for PostTelegrafsIDLabels.
type PostTelegrafsIDLabelsJSONBody LabelMapping

// PostTelegrafsIDLabelsParams defines parameters for PostTelegrafsIDLabels.
type PostTelegrafsIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTelegrafsIDLabelsAllParams defines type for all parameters for PostTelegrafsIDLabels.
type PostTelegrafsIDLabelsAllParams struct {
	PostTelegrafsIDLabelsParams

	TelegrafID string

	Body PostTelegrafsIDLabelsJSONRequestBody
}

// DeleteTelegrafsIDLabelsIDParams defines parameters for DeleteTelegrafsIDLabelsID.
type DeleteTelegrafsIDLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteTelegrafsIDLabelsIDAllParams defines type for all parameters for DeleteTelegrafsIDLabelsID.
type DeleteTelegrafsIDLabelsIDAllParams struct {
	DeleteTelegrafsIDLabelsIDParams

	TelegrafID string

	LabelID string
}

// GetTelegrafsIDMembersParams defines parameters for GetTelegrafsIDMembers.
type GetTelegrafsIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTelegrafsIDMembersAllParams defines type for all parameters for GetTelegrafsIDMembers.
type GetTelegrafsIDMembersAllParams struct {
	GetTelegrafsIDMembersParams

	TelegrafID string
}

// PostTelegrafsIDMembersJSONBody defines parameters for PostTelegrafsIDMembers.
type PostTelegrafsIDMembersJSONBody AddResourceMemberRequestBody

// PostTelegrafsIDMembersParams defines parameters for PostTelegrafsIDMembers.
type PostTelegrafsIDMembersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTelegrafsIDMembersAllParams defines type for all parameters for PostTelegrafsIDMembers.
type PostTelegrafsIDMembersAllParams struct {
	PostTelegrafsIDMembersParams

	TelegrafID string

	Body PostTelegrafsIDMembersJSONRequestBody
}

// DeleteTelegrafsIDMembersIDParams defines parameters for DeleteTelegrafsIDMembersID.
type DeleteTelegrafsIDMembersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteTelegrafsIDMembersIDAllParams defines type for all parameters for DeleteTelegrafsIDMembersID.
type DeleteTelegrafsIDMembersIDAllParams struct {
	DeleteTelegrafsIDMembersIDParams

	TelegrafID string

	UserID string
}

// GetTelegrafsIDOwnersParams defines parameters for GetTelegrafsIDOwners.
type GetTelegrafsIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetTelegrafsIDOwnersAllParams defines type for all parameters for GetTelegrafsIDOwners.
type GetTelegrafsIDOwnersAllParams struct {
	GetTelegrafsIDOwnersParams

	TelegrafID string
}

// PostTelegrafsIDOwnersJSONBody defines parameters for PostTelegrafsIDOwners.
type PostTelegrafsIDOwnersJSONBody AddResourceMemberRequestBody

// PostTelegrafsIDOwnersParams defines parameters for PostTelegrafsIDOwners.
type PostTelegrafsIDOwnersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostTelegrafsIDOwnersAllParams defines type for all parameters for PostTelegrafsIDOwners.
type PostTelegrafsIDOwnersAllParams struct {
	PostTelegrafsIDOwnersParams

	TelegrafID string

	Body PostTelegrafsIDOwnersJSONRequestBody
}

// DeleteTelegrafsIDOwnersIDParams defines parameters for DeleteTelegrafsIDOwnersID.
type DeleteTelegrafsIDOwnersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteTelegrafsIDOwnersIDAllParams defines type for all parameters for DeleteTelegrafsIDOwnersID.
type DeleteTelegrafsIDOwnersIDAllParams struct {
	DeleteTelegrafsIDOwnersIDParams

	TelegrafID string

	UserID string
}

// ExportTemplateJSONBody defines parameters for ExportTemplate.
type ExportTemplateJSONBody interface{}

// ExportTemplateAllParams defines type for all parameters for ExportTemplate.
type ExportTemplateAllParams struct {
	Body ExportTemplateJSONRequestBody
}

// GetUsersParams defines parameters for GetUsers.
type GetUsersParams struct {
	// The offset for pagination.
	// The number of records to skip.
	Offset *Offset `json:"offset,omitempty"`

	// Limits the number of records returned. Default is `20`.
	Limit *Limit `json:"limit,omitempty"`

	// Resource ID to seek from. Results are not inclusive of this ID. Use `after` instead of `offset`.
	After *After  `json:"after,omitempty"`
	Name  *string `json:"name,omitempty"`
	Id    *string `json:"id,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostUsersJSONBody defines parameters for PostUsers.
type PostUsersJSONBody User

// PostUsersParams defines parameters for PostUsers.
type PostUsersParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostUsersAllParams defines type for all parameters for PostUsers.
type PostUsersAllParams struct {
	PostUsersParams

	Body PostUsersJSONRequestBody
}

// DeleteUsersIDParams defines parameters for DeleteUsersID.
type DeleteUsersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteUsersIDAllParams defines type for all parameters for DeleteUsersID.
type DeleteUsersIDAllParams struct {
	DeleteUsersIDParams

	UserID string
}

// GetUsersIDParams defines parameters for GetUsersID.
type GetUsersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetUsersIDAllParams defines type for all parameters for GetUsersID.
type GetUsersIDAllParams struct {
	GetUsersIDParams

	UserID string
}

// PatchUsersIDJSONBody defines parameters for PatchUsersID.
type PatchUsersIDJSONBody User

// PatchUsersIDParams defines parameters for PatchUsersID.
type PatchUsersIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchUsersIDAllParams defines type for all parameters for PatchUsersID.
type PatchUsersIDAllParams struct {
	PatchUsersIDParams

	UserID string

	Body PatchUsersIDJSONRequestBody
}

// PostUsersIDPasswordJSONBody defines parameters for PostUsersIDPassword.
type PostUsersIDPasswordJSONBody PasswordResetBody

// PostUsersIDPasswordParams defines parameters for PostUsersIDPassword.
type PostUsersIDPasswordParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostUsersIDPasswordAllParams defines type for all parameters for PostUsersIDPassword.
type PostUsersIDPasswordAllParams struct {
	PostUsersIDPasswordParams

	UserID string

	Body PostUsersIDPasswordJSONRequestBody
}

// GetVariablesParams defines parameters for GetVariables.
type GetVariablesParams struct {
	// The name of the organization.
	Org *string `json:"org,omitempty"`

	// The organization ID.
	OrgID *string `json:"orgID,omitempty"`

	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostVariablesJSONBody defines parameters for PostVariables.
type PostVariablesJSONBody Variable

// PostVariablesParams defines parameters for PostVariables.
type PostVariablesParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostVariablesAllParams defines type for all parameters for PostVariables.
type PostVariablesAllParams struct {
	PostVariablesParams

	Body PostVariablesJSONRequestBody
}

// DeleteVariablesIDParams defines parameters for DeleteVariablesID.
type DeleteVariablesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteVariablesIDAllParams defines type for all parameters for DeleteVariablesID.
type DeleteVariablesIDAllParams struct {
	DeleteVariablesIDParams

	VariableID string
}

// GetVariablesIDParams defines parameters for GetVariablesID.
type GetVariablesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetVariablesIDAllParams defines type for all parameters for GetVariablesID.
type GetVariablesIDAllParams struct {
	GetVariablesIDParams

	VariableID string
}

// PatchVariablesIDJSONBody defines parameters for PatchVariablesID.
type PatchVariablesIDJSONBody Variable

// PatchVariablesIDParams defines parameters for PatchVariablesID.
type PatchVariablesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PatchVariablesIDAllParams defines type for all parameters for PatchVariablesID.
type PatchVariablesIDAllParams struct {
	PatchVariablesIDParams

	VariableID string

	Body PatchVariablesIDJSONRequestBody
}

// PutVariablesIDJSONBody defines parameters for PutVariablesID.
type PutVariablesIDJSONBody Variable

// PutVariablesIDParams defines parameters for PutVariablesID.
type PutVariablesIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PutVariablesIDAllParams defines type for all parameters for PutVariablesID.
type PutVariablesIDAllParams struct {
	PutVariablesIDParams

	VariableID string

	Body PutVariablesIDJSONRequestBody
}

// GetVariablesIDLabelsParams defines parameters for GetVariablesIDLabels.
type GetVariablesIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// GetVariablesIDLabelsAllParams defines type for all parameters for GetVariablesIDLabels.
type GetVariablesIDLabelsAllParams struct {
	GetVariablesIDLabelsParams

	VariableID string
}

// PostVariablesIDLabelsJSONBody defines parameters for PostVariablesIDLabels.
type PostVariablesIDLabelsJSONBody LabelMapping

// PostVariablesIDLabelsParams defines parameters for PostVariablesIDLabels.
type PostVariablesIDLabelsParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// PostVariablesIDLabelsAllParams defines type for all parameters for PostVariablesIDLabels.
type PostVariablesIDLabelsAllParams struct {
	PostVariablesIDLabelsParams

	VariableID string

	Body PostVariablesIDLabelsJSONRequestBody
}

// DeleteVariablesIDLabelsIDParams defines parameters for DeleteVariablesIDLabelsID.
type DeleteVariablesIDLabelsIDParams struct {
	// OpenTracing span context
	ZapTraceSpan *TraceSpan `json:"Zap-Trace-Span,omitempty"`
}

// DeleteVariablesIDLabelsIDAllParams defines type for all parameters for DeleteVariablesIDLabelsID.
type DeleteVariablesIDLabelsIDAllParams struct {
	DeleteVariablesIDLabelsIDParams

	VariableID string

	LabelID string
}

// PostAuthorizationsJSONRequestBody defines body for PostAuthorizations for application/json ContentType.
type PostAuthorizationsJSONRequestBody PostAuthorizationsJSONBody

// PatchAuthorizationsIDJSONRequestBody defines body for PatchAuthorizationsID for application/json ContentType.
type PatchAuthorizationsIDJSONRequestBody PatchAuthorizationsIDJSONBody

// PostBucketsJSONRequestBody defines body for PostBuckets for application/json ContentType.
type PostBucketsJSONRequestBody PostBucketsJSONBody

// PatchBucketsIDJSONRequestBody defines body for PatchBucketsID for application/json ContentType.
type PatchBucketsIDJSONRequestBody PatchBucketsIDJSONBody

// PostBucketsIDLabelsJSONRequestBody defines body for PostBucketsIDLabels for application/json ContentType.
type PostBucketsIDLabelsJSONRequestBody PostBucketsIDLabelsJSONBody

// PostBucketsIDMembersJSONRequestBody defines body for PostBucketsIDMembers for application/json ContentType.
type PostBucketsIDMembersJSONRequestBody PostBucketsIDMembersJSONBody

// PostBucketsIDOwnersJSONRequestBody defines body for PostBucketsIDOwners for application/json ContentType.
type PostBucketsIDOwnersJSONRequestBody PostBucketsIDOwnersJSONBody

// CreateCheckJSONRequestBody defines body for CreateCheck for application/json ContentType.
type CreateCheckJSONRequestBody CreateCheckJSONBody

// PatchChecksIDJSONRequestBody defines body for PatchChecksID for application/json ContentType.
type PatchChecksIDJSONRequestBody PatchChecksIDJSONBody

// PutChecksIDJSONRequestBody defines body for PutChecksID for application/json ContentType.
type PutChecksIDJSONRequestBody PutChecksIDJSONBody

// PostChecksIDLabelsJSONRequestBody defines body for PostChecksIDLabels for application/json ContentType.
type PostChecksIDLabelsJSONRequestBody PostChecksIDLabelsJSONBody

// PatchDashboardsIDJSONRequestBody defines body for PatchDashboardsID for application/json ContentType.
type PatchDashboardsIDJSONRequestBody PatchDashboardsIDJSONBody

// PostDashboardsIDCellsJSONRequestBody defines body for PostDashboardsIDCells for application/json ContentType.
type PostDashboardsIDCellsJSONRequestBody PostDashboardsIDCellsJSONBody

// PutDashboardsIDCellsJSONRequestBody defines body for PutDashboardsIDCells for application/json ContentType.
type PutDashboardsIDCellsJSONRequestBody PutDashboardsIDCellsJSONBody

// PatchDashboardsIDCellsIDJSONRequestBody defines body for PatchDashboardsIDCellsID for application/json ContentType.
type PatchDashboardsIDCellsIDJSONRequestBody PatchDashboardsIDCellsIDJSONBody

// PatchDashboardsIDCellsIDViewJSONRequestBody defines body for PatchDashboardsIDCellsIDView for application/json ContentType.
type PatchDashboardsIDCellsIDViewJSONRequestBody PatchDashboardsIDCellsIDViewJSONBody

// PostDashboardsIDLabelsJSONRequestBody defines body for PostDashboardsIDLabels for application/json ContentType.
type PostDashboardsIDLabelsJSONRequestBody PostDashboardsIDLabelsJSONBody

// PostDashboardsIDMembersJSONRequestBody defines body for PostDashboardsIDMembers for application/json ContentType.
type PostDashboardsIDMembersJSONRequestBody PostDashboardsIDMembersJSONBody

// PostDashboardsIDOwnersJSONRequestBody defines body for PostDashboardsIDOwners for application/json ContentType.
type PostDashboardsIDOwnersJSONRequestBody PostDashboardsIDOwnersJSONBody

// PostDBRPJSONRequestBody defines body for PostDBRP for application/json ContentType.
type PostDBRPJSONRequestBody PostDBRPJSONBody

// PatchDBRPIDJSONRequestBody defines body for PatchDBRPID for application/json ContentType.
type PatchDBRPIDJSONRequestBody PatchDBRPIDJSONBody

// PostDeleteJSONRequestBody defines body for PostDelete for application/json ContentType.
type PostDeleteJSONRequestBody PostDeleteJSONBody

// PostLabelsJSONRequestBody defines body for PostLabels for application/json ContentType.
type PostLabelsJSONRequestBody PostLabelsJSONBody

// PatchLabelsIDJSONRequestBody defines body for PatchLabelsID for application/json ContentType.
type PatchLabelsIDJSONRequestBody PatchLabelsIDJSONBody

// PutMePasswordJSONRequestBody defines body for PutMePassword for application/json ContentType.
type PutMePasswordJSONRequestBody PutMePasswordJSONBody

// CreateNotificationEndpointJSONRequestBody defines body for CreateNotificationEndpoint for application/json ContentType.
type CreateNotificationEndpointJSONRequestBody CreateNotificationEndpointJSONBody

// PatchNotificationEndpointsIDJSONRequestBody defines body for PatchNotificationEndpointsID for application/json ContentType.
type PatchNotificationEndpointsIDJSONRequestBody PatchNotificationEndpointsIDJSONBody

// PutNotificationEndpointsIDJSONRequestBody defines body for PutNotificationEndpointsID for application/json ContentType.
type PutNotificationEndpointsIDJSONRequestBody PutNotificationEndpointsIDJSONBody

// PostNotificationEndpointIDLabelsJSONRequestBody defines body for PostNotificationEndpointIDLabels for application/json ContentType.
type PostNotificationEndpointIDLabelsJSONRequestBody PostNotificationEndpointIDLabelsJSONBody

// CreateNotificationRuleJSONRequestBody defines body for CreateNotificationRule for application/json ContentType.
type CreateNotificationRuleJSONRequestBody CreateNotificationRuleJSONBody

// PatchNotificationRulesIDJSONRequestBody defines body for PatchNotificationRulesID for application/json ContentType.
type PatchNotificationRulesIDJSONRequestBody PatchNotificationRulesIDJSONBody

// PutNotificationRulesIDJSONRequestBody defines body for PutNotificationRulesID for application/json ContentType.
type PutNotificationRulesIDJSONRequestBody PutNotificationRulesIDJSONBody

// PostNotificationRuleIDLabelsJSONRequestBody defines body for PostNotificationRuleIDLabels for application/json ContentType.
type PostNotificationRuleIDLabelsJSONRequestBody PostNotificationRuleIDLabelsJSONBody

// PostOrgsJSONRequestBody defines body for PostOrgs for application/json ContentType.
type PostOrgsJSONRequestBody PostOrgsJSONBody

// PatchOrgsIDJSONRequestBody defines body for PatchOrgsID for application/json ContentType.
type PatchOrgsIDJSONRequestBody PatchOrgsIDJSONBody

// PostOrgsIDMembersJSONRequestBody defines body for PostOrgsIDMembers for application/json ContentType.
type PostOrgsIDMembersJSONRequestBody PostOrgsIDMembersJSONBody

// PostOrgsIDOwnersJSONRequestBody defines body for PostOrgsIDOwners for application/json ContentType.
type PostOrgsIDOwnersJSONRequestBody PostOrgsIDOwnersJSONBody

// PatchOrgsIDSecretsJSONRequestBody defines body for PatchOrgsIDSecrets for application/json ContentType.
type PatchOrgsIDSecretsJSONRequestBody PatchOrgsIDSecretsJSONBody

// PostOrgsIDSecretsJSONRequestBody defines body for PostOrgsIDSecrets for application/json ContentType.
type PostOrgsIDSecretsJSONRequestBody PostOrgsIDSecretsJSONBody

// PostQueryAnalyzeJSONRequestBody defines body for PostQueryAnalyze for application/json ContentType.
type PostQueryAnalyzeJSONRequestBody PostQueryAnalyzeJSONBody

// PostQueryAstJSONRequestBody defines body for PostQueryAst for application/json ContentType.
type PostQueryAstJSONRequestBody PostQueryAstJSONBody

// PostRemoteConnectionJSONRequestBody defines body for PostRemoteConnection for application/json ContentType.
type PostRemoteConnectionJSONRequestBody PostRemoteConnectionJSONBody

// PatchRemoteConnectionByIDJSONRequestBody defines body for PatchRemoteConnectionByID for application/json ContentType.
type PatchRemoteConnectionByIDJSONRequestBody PatchRemoteConnectionByIDJSONBody

// PostReplicationJSONRequestBody defines body for PostReplication for application/json ContentType.
type PostReplicationJSONRequestBody PostReplicationJSONBody

// PatchReplicationByIDJSONRequestBody defines body for PatchReplicationByID for application/json ContentType.
type PatchReplicationByIDJSONRequestBody PatchReplicationByIDJSONBody

// PostRestoreBucketMetadataJSONRequestBody defines body for PostRestoreBucketMetadata for application/json ContentType.
type PostRestoreBucketMetadataJSONRequestBody PostRestoreBucketMetadataJSONBody

// PostScrapersJSONRequestBody defines body for PostScrapers for application/json ContentType.
type PostScrapersJSONRequestBody PostScrapersJSONBody

// PatchScrapersIDJSONRequestBody defines body for PatchScrapersID for application/json ContentType.
type PatchScrapersIDJSONRequestBody PatchScrapersIDJSONBody

// PostScrapersIDLabelsJSONRequestBody defines body for PostScrapersIDLabels for application/json ContentType.
type PostScrapersIDLabelsJSONRequestBody PostScrapersIDLabelsJSONBody

// PostScrapersIDMembersJSONRequestBody defines body for PostScrapersIDMembers for application/json ContentType.
type PostScrapersIDMembersJSONRequestBody PostScrapersIDMembersJSONBody

// PostScrapersIDOwnersJSONRequestBody defines body for PostScrapersIDOwners for application/json ContentType.
type PostScrapersIDOwnersJSONRequestBody PostScrapersIDOwnersJSONBody

// PostSetupJSONRequestBody defines body for PostSetup for application/json ContentType.
type PostSetupJSONRequestBody PostSetupJSONBody

// PostSourcesJSONRequestBody defines body for PostSources for application/json ContentType.
type PostSourcesJSONRequestBody PostSourcesJSONBody

// PatchSourcesIDJSONRequestBody defines body for PatchSourcesID for application/json ContentType.
type PatchSourcesIDJSONRequestBody PatchSourcesIDJSONBody

// CreateStackJSONRequestBody defines body for CreateStack for application/json ContentType.
type CreateStackJSONRequestBody CreateStackJSONBody

// UpdateStackJSONRequestBody defines body for UpdateStack for application/json ContentType.
type UpdateStackJSONRequestBody UpdateStackJSONBody

// PostTasksJSONRequestBody defines body for PostTasks for application/json ContentType.
type PostTasksJSONRequestBody PostTasksJSONBody

// PatchTasksIDJSONRequestBody defines body for PatchTasksID for application/json ContentType.
type PatchTasksIDJSONRequestBody PatchTasksIDJSONBody

// PostTasksIDLabelsJSONRequestBody defines body for PostTasksIDLabels for application/json ContentType.
type PostTasksIDLabelsJSONRequestBody PostTasksIDLabelsJSONBody

// PostTasksIDMembersJSONRequestBody defines body for PostTasksIDMembers for application/json ContentType.
type PostTasksIDMembersJSONRequestBody PostTasksIDMembersJSONBody

// PostTasksIDOwnersJSONRequestBody defines body for PostTasksIDOwners for application/json ContentType.
type PostTasksIDOwnersJSONRequestBody PostTasksIDOwnersJSONBody

// PostTasksIDRunsJSONRequestBody defines body for PostTasksIDRuns for application/json ContentType.
type PostTasksIDRunsJSONRequestBody PostTasksIDRunsJSONBody

// PostTasksIDRunsIDRetryJSONRequestBody defines body for PostTasksIDRunsIDRetry for application/json ContentType.
type PostTasksIDRunsIDRetryJSONRequestBody PostTasksIDRunsIDRetryJSONBody

// PostTelegrafsJSONRequestBody defines body for PostTelegrafs for application/json ContentType.
type PostTelegrafsJSONRequestBody PostTelegrafsJSONBody

// PutTelegrafsIDJSONRequestBody defines body for PutTelegrafsID for application/json ContentType.
type PutTelegrafsIDJSONRequestBody PutTelegrafsIDJSONBody

// PostTelegrafsIDLabelsJSONRequestBody defines body for PostTelegrafsIDLabels for application/json ContentType.
type PostTelegrafsIDLabelsJSONRequestBody PostTelegrafsIDLabelsJSONBody

// PostTelegrafsIDMembersJSONRequestBody defines body for PostTelegrafsIDMembers for application/json ContentType.
type PostTelegrafsIDMembersJSONRequestBody PostTelegrafsIDMembersJSONBody

// PostTelegrafsIDOwnersJSONRequestBody defines body for PostTelegrafsIDOwners for application/json ContentType.
type PostTelegrafsIDOwnersJSONRequestBody PostTelegrafsIDOwnersJSONBody

// ExportTemplateJSONRequestBody defines body for ExportTemplate for application/json ContentType.
type ExportTemplateJSONRequestBody ExportTemplateJSONBody

// PostUsersJSONRequestBody defines body for PostUsers for application/json ContentType.
type PostUsersJSONRequestBody PostUsersJSONBody

// PatchUsersIDJSONRequestBody defines body for PatchUsersID for application/json ContentType.
type PatchUsersIDJSONRequestBody PatchUsersIDJSONBody

// PostUsersIDPasswordJSONRequestBody defines body for PostUsersIDPassword for application/json ContentType.
type PostUsersIDPasswordJSONRequestBody PostUsersIDPasswordJSONBody

// PostVariablesJSONRequestBody defines body for PostVariables for application/json ContentType.
type PostVariablesJSONRequestBody PostVariablesJSONBody

// PatchVariablesIDJSONRequestBody defines body for PatchVariablesID for application/json ContentType.
type PatchVariablesIDJSONRequestBody PatchVariablesIDJSONBody

// PutVariablesIDJSONRequestBody defines body for PutVariablesID for application/json ContentType.
type PutVariablesIDJSONRequestBody PutVariablesIDJSONBody

// PostVariablesIDLabelsJSONRequestBody defines body for PostVariablesIDLabels for application/json ContentType.
type PostVariablesIDLabelsJSONRequestBody PostVariablesIDLabelsJSONBody

// Getter for additional properties for ColorMapping. Returns the specified
// element and whether it was found
func (a ColorMapping) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for ColorMapping
func (a *ColorMapping) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for ColorMapping to handle AdditionalProperties
func (a *ColorMapping) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for ColorMapping to handle AdditionalProperties
func (a ColorMapping) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for Flags. Returns the specified
// element and whether it was found
func (a Flags) Get(fieldName string) (value interface{}, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for Flags
func (a *Flags) Set(fieldName string, value interface{}) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]interface{})
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for Flags to handle AdditionalProperties
func (a *Flags) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]interface{})
		for fieldName, fieldBuf := range object {
			var fieldVal interface{}
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for Flags to handle AdditionalProperties
func (a Flags) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for FluxSuggestion_Params. Returns the specified
// element and whether it was found
func (a FluxSuggestion_Params) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for FluxSuggestion_Params
func (a *FluxSuggestion_Params) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for FluxSuggestion_Params to handle AdditionalProperties
func (a *FluxSuggestion_Params) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for FluxSuggestion_Params to handle AdditionalProperties
func (a FluxSuggestion_Params) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for HTTPNotificationEndpoint_Headers. Returns the specified
// element and whether it was found
func (a HTTPNotificationEndpoint_Headers) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for HTTPNotificationEndpoint_Headers
func (a *HTTPNotificationEndpoint_Headers) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for HTTPNotificationEndpoint_Headers to handle AdditionalProperties
func (a *HTTPNotificationEndpoint_Headers) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for HTTPNotificationEndpoint_Headers to handle AdditionalProperties
func (a HTTPNotificationEndpoint_Headers) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for Label_Properties. Returns the specified
// element and whether it was found
func (a Label_Properties) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for Label_Properties
func (a *Label_Properties) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for Label_Properties to handle AdditionalProperties
func (a *Label_Properties) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for Label_Properties to handle AdditionalProperties
func (a Label_Properties) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for LabelCreateRequest_Properties. Returns the specified
// element and whether it was found
func (a LabelCreateRequest_Properties) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for LabelCreateRequest_Properties
func (a *LabelCreateRequest_Properties) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for LabelCreateRequest_Properties to handle AdditionalProperties
func (a *LabelCreateRequest_Properties) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for LabelCreateRequest_Properties to handle AdditionalProperties
func (a LabelCreateRequest_Properties) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for LabelUpdate_Properties. Returns the specified
// element and whether it was found
func (a LabelUpdate_Properties) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for LabelUpdate_Properties
func (a *LabelUpdate_Properties) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for LabelUpdate_Properties to handle AdditionalProperties
func (a *LabelUpdate_Properties) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for LabelUpdate_Properties to handle AdditionalProperties
func (a LabelUpdate_Properties) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for MapVariableProperties_Values. Returns the specified
// element and whether it was found
func (a MapVariableProperties_Values) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for MapVariableProperties_Values
func (a *MapVariableProperties_Values) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for MapVariableProperties_Values to handle AdditionalProperties
func (a *MapVariableProperties_Values) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for MapVariableProperties_Values to handle AdditionalProperties
func (a MapVariableProperties_Values) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for Query_Params. Returns the specified
// element and whether it was found
func (a Query_Params) Get(fieldName string) (value interface{}, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for Query_Params
func (a *Query_Params) Set(fieldName string, value interface{}) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]interface{})
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for Query_Params to handle AdditionalProperties
func (a *Query_Params) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]interface{})
		for fieldName, fieldBuf := range object {
			var fieldVal interface{}
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for Query_Params to handle AdditionalProperties
func (a Query_Params) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for Secrets. Returns the specified
// element and whether it was found
func (a Secrets) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for Secrets
func (a *Secrets) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for Secrets to handle AdditionalProperties
func (a *Secrets) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for Secrets to handle AdditionalProperties
func (a Secrets) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for TemplateApply_EnvRefs. Returns the specified
// element and whether it was found
func (a TemplateApply_EnvRefs) Get(fieldName string) (value interface{}, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for TemplateApply_EnvRefs
func (a *TemplateApply_EnvRefs) Set(fieldName string, value interface{}) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]interface{})
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for TemplateApply_EnvRefs to handle AdditionalProperties
func (a *TemplateApply_EnvRefs) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]interface{})
		for fieldName, fieldBuf := range object {
			var fieldVal interface{}
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for TemplateApply_EnvRefs to handle AdditionalProperties
func (a TemplateApply_EnvRefs) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}

// Getter for additional properties for TemplateApply_Secrets. Returns the specified
// element and whether it was found
func (a TemplateApply_Secrets) Get(fieldName string) (value string, found bool) {
	if a.AdditionalProperties != nil {
		value, found = a.AdditionalProperties[fieldName]
	}
	return
}

// Setter for additional properties for TemplateApply_Secrets
func (a *TemplateApply_Secrets) Set(fieldName string, value string) {
	if a.AdditionalProperties == nil {
		a.AdditionalProperties = make(map[string]string)
	}
	a.AdditionalProperties[fieldName] = value
}

// Override default JSON handling for TemplateApply_Secrets to handle AdditionalProperties
func (a *TemplateApply_Secrets) UnmarshalJSON(b []byte) error {
	object := make(map[string]json.RawMessage)
	err := json.Unmarshal(b, &object)
	if err != nil {
		return err
	}

	if len(object) != 0 {
		a.AdditionalProperties = make(map[string]string)
		for fieldName, fieldBuf := range object {
			var fieldVal string
			err := json.Unmarshal(fieldBuf, &fieldVal)
			if err != nil {
				return fmt.Errorf("error unmarshaling field %s: %w", fieldName, err)
			}
			a.AdditionalProperties[fieldName] = fieldVal
		}
	}
	return nil
}

// Override default JSON handling for TemplateApply_Secrets to handle AdditionalProperties
func (a TemplateApply_Secrets) MarshalJSON() ([]byte, error) {
	var err error
	object := make(map[string]json.RawMessage)

	for fieldName, field := range a.AdditionalProperties {
		object[fieldName], err = json.Marshal(field)
		if err != nil {
			return nil, fmt.Errorf("error marshaling '%s': %w", fieldName, err)
		}
	}
	return json.Marshal(object)
}
