// Code generated by go-swagger; DO NOT EDIT.

package recording_rules

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateRecordingRuleReader is a Reader for the UpdateRecordingRule structure.
type UpdateRecordingRuleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateRecordingRuleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateRecordingRuleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewUpdateRecordingRuleUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateRecordingRuleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateRecordingRuleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateRecordingRuleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /recording-rules] updateRecordingRule", response, response.Code())
	}
}

// NewUpdateRecordingRuleOK creates a UpdateRecordingRuleOK with default headers values
func NewUpdateRecordingRuleOK() *UpdateRecordingRuleOK {
	return &UpdateRecordingRuleOK{}
}

/*
UpdateRecordingRuleOK describes a response with status code 200, with default header values.

(empty)
*/
type UpdateRecordingRuleOK struct {
	Payload *models.RecordingRuleJSON
}

// IsSuccess returns true when this update recording rule Ok response has a 2xx status code
func (o *UpdateRecordingRuleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update recording rule Ok response has a 3xx status code
func (o *UpdateRecordingRuleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update recording rule Ok response has a 4xx status code
func (o *UpdateRecordingRuleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update recording rule Ok response has a 5xx status code
func (o *UpdateRecordingRuleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update recording rule Ok response a status code equal to that given
func (o *UpdateRecordingRuleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update recording rule Ok response
func (o *UpdateRecordingRuleOK) Code() int {
	return 200
}

func (o *UpdateRecordingRuleOK) Error() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleOk  %+v", 200, o.Payload)
}

func (o *UpdateRecordingRuleOK) String() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleOk  %+v", 200, o.Payload)
}

func (o *UpdateRecordingRuleOK) GetPayload() *models.RecordingRuleJSON {
	return o.Payload
}

func (o *UpdateRecordingRuleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RecordingRuleJSON)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRecordingRuleUnauthorized creates a UpdateRecordingRuleUnauthorized with default headers values
func NewUpdateRecordingRuleUnauthorized() *UpdateRecordingRuleUnauthorized {
	return &UpdateRecordingRuleUnauthorized{}
}

/*
UpdateRecordingRuleUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateRecordingRuleUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update recording rule unauthorized response has a 2xx status code
func (o *UpdateRecordingRuleUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update recording rule unauthorized response has a 3xx status code
func (o *UpdateRecordingRuleUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update recording rule unauthorized response has a 4xx status code
func (o *UpdateRecordingRuleUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update recording rule unauthorized response has a 5xx status code
func (o *UpdateRecordingRuleUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update recording rule unauthorized response a status code equal to that given
func (o *UpdateRecordingRuleUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update recording rule unauthorized response
func (o *UpdateRecordingRuleUnauthorized) Code() int {
	return 401
}

func (o *UpdateRecordingRuleUnauthorized) Error() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleUnauthorized  %+v", 401, o.Payload)
}

func (o *UpdateRecordingRuleUnauthorized) String() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleUnauthorized  %+v", 401, o.Payload)
}

func (o *UpdateRecordingRuleUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateRecordingRuleUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRecordingRuleForbidden creates a UpdateRecordingRuleForbidden with default headers values
func NewUpdateRecordingRuleForbidden() *UpdateRecordingRuleForbidden {
	return &UpdateRecordingRuleForbidden{}
}

/*
UpdateRecordingRuleForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateRecordingRuleForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update recording rule forbidden response has a 2xx status code
func (o *UpdateRecordingRuleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update recording rule forbidden response has a 3xx status code
func (o *UpdateRecordingRuleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update recording rule forbidden response has a 4xx status code
func (o *UpdateRecordingRuleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update recording rule forbidden response has a 5xx status code
func (o *UpdateRecordingRuleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update recording rule forbidden response a status code equal to that given
func (o *UpdateRecordingRuleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update recording rule forbidden response
func (o *UpdateRecordingRuleForbidden) Code() int {
	return 403
}

func (o *UpdateRecordingRuleForbidden) Error() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleForbidden  %+v", 403, o.Payload)
}

func (o *UpdateRecordingRuleForbidden) String() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleForbidden  %+v", 403, o.Payload)
}

func (o *UpdateRecordingRuleForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateRecordingRuleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRecordingRuleNotFound creates a UpdateRecordingRuleNotFound with default headers values
func NewUpdateRecordingRuleNotFound() *UpdateRecordingRuleNotFound {
	return &UpdateRecordingRuleNotFound{}
}

/*
UpdateRecordingRuleNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type UpdateRecordingRuleNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update recording rule not found response has a 2xx status code
func (o *UpdateRecordingRuleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update recording rule not found response has a 3xx status code
func (o *UpdateRecordingRuleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update recording rule not found response has a 4xx status code
func (o *UpdateRecordingRuleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update recording rule not found response has a 5xx status code
func (o *UpdateRecordingRuleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update recording rule not found response a status code equal to that given
func (o *UpdateRecordingRuleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update recording rule not found response
func (o *UpdateRecordingRuleNotFound) Code() int {
	return 404
}

func (o *UpdateRecordingRuleNotFound) Error() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleNotFound  %+v", 404, o.Payload)
}

func (o *UpdateRecordingRuleNotFound) String() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleNotFound  %+v", 404, o.Payload)
}

func (o *UpdateRecordingRuleNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateRecordingRuleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateRecordingRuleInternalServerError creates a UpdateRecordingRuleInternalServerError with default headers values
func NewUpdateRecordingRuleInternalServerError() *UpdateRecordingRuleInternalServerError {
	return &UpdateRecordingRuleInternalServerError{}
}

/*
UpdateRecordingRuleInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateRecordingRuleInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update recording rule internal server error response has a 2xx status code
func (o *UpdateRecordingRuleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update recording rule internal server error response has a 3xx status code
func (o *UpdateRecordingRuleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update recording rule internal server error response has a 4xx status code
func (o *UpdateRecordingRuleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update recording rule internal server error response has a 5xx status code
func (o *UpdateRecordingRuleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update recording rule internal server error response a status code equal to that given
func (o *UpdateRecordingRuleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update recording rule internal server error response
func (o *UpdateRecordingRuleInternalServerError) Code() int {
	return 500
}

func (o *UpdateRecordingRuleInternalServerError) Error() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateRecordingRuleInternalServerError) String() string {
	return fmt.Sprintf("[PUT /recording-rules][%d] updateRecordingRuleInternalServerError  %+v", 500, o.Payload)
}

func (o *UpdateRecordingRuleInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateRecordingRuleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
