---
canonical: https://grafana.com/docs/grafana/latest/alerting/manage-notifications/
description: Manage your alerts by creating silences, mute timings, and more
keywords:
  - grafana
  - alert
  - notifications
labels:
  products:
    - cloud
    - enterprise
    - oss
menuTitle: Manage
title: Manage your alerts
weight: 130
refs:
  mute-timings:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/manage-notifications/mute-timings/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/manage-notifications/mute-timings/
  view-alert-rules:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/manage-notifications/view-alert-rules/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/manage-notifications/view-alert-rules/
  declare-incident-from-firing-alert:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/manage-notifications/declare-incident-from-alert/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/manage-notifications/declare-incident-from-alert/
  view-state-health:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/manage-notifications/view-state-health/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/manage-notifications/view-state-health/
  create-silence:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/alerting/manage-notifications/create-silence/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana-cloud/alerting-and-irm/alerting/manage-notifications/create-silence/
---

# Manage your alerts

Once you have set up your alert rules, contact points, and notification policies, you can use Grafana Alerting to:

[Create silences](ref:create-silence)

[Create mute timings](ref:mute-timings)

[Declare incidents from firing alerts](ref:declare-incident-from-firing-alert)

[View the state and health of alert rules](ref:view-state-health)

[View and filter alert rules](ref:view-alert-rules)
