/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	context "context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	apiregistrationv1beta1 "k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1"
	scheme "k8s.io/kube-aggregator/pkg/client/clientset_generated/clientset/scheme"
)

// APIServicesGetter has a method to return a APIServiceInterface.
// A group's client should implement this interface.
type APIServicesGetter interface {
	APIServices() APIServiceInterface
}

// APIServiceInterface has methods to work with APIService resources.
type APIServiceInterface interface {
	Create(ctx context.Context, aPIService *apiregistrationv1beta1.APIService, opts v1.CreateOptions) (*apiregistrationv1beta1.APIService, error)
	Update(ctx context.Context, aPIService *apiregistrationv1beta1.APIService, opts v1.UpdateOptions) (*apiregistrationv1beta1.APIService, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, aPIService *apiregistrationv1beta1.APIService, opts v1.UpdateOptions) (*apiregistrationv1beta1.APIService, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*apiregistrationv1beta1.APIService, error)
	List(ctx context.Context, opts v1.ListOptions) (*apiregistrationv1beta1.APIServiceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *apiregistrationv1beta1.APIService, err error)
	APIServiceExpansion
}

// aPIServices implements APIServiceInterface
type aPIServices struct {
	*gentype.ClientWithList[*apiregistrationv1beta1.APIService, *apiregistrationv1beta1.APIServiceList]
}

// newAPIServices returns a APIServices
func newAPIServices(c *ApiregistrationV1beta1Client) *aPIServices {
	return &aPIServices{
		gentype.NewClientWithList[*apiregistrationv1beta1.APIService, *apiregistrationv1beta1.APIServiceList](
			"apiservices",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *apiregistrationv1beta1.APIService { return &apiregistrationv1beta1.APIService{} },
			func() *apiregistrationv1beta1.APIServiceList { return &apiregistrationv1beta1.APIServiceList{} },
			gentype.PrefersProtobuf[*apiregistrationv1beta1.APIService](),
		),
	}
}
