// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Preferences Spec defines model for Spec.
//
// swagger:model Preferences
type Preferences struct {

	// cookie preferences
	CookiePreferences *CookiePreferences `json:"cookiePreferences,omitempty"`

	// UID for the home dashboard
	HomeDashboardUID string `json:"homeDashboardUID,omitempty"`

	// Selected language (beta)
	Language string `json:"language,omitempty"`

	// query history
	QueryHistory *QueryHistoryPreference `json:"queryHistory,omitempty"`

	// Theme light, dark, empty is default
	Theme string `json:"theme,omitempty"`

	// The timezone selection
	// TODO: this should use the timezone defined in common
	Timezone string `json:"timezone,omitempty"`

	// WeekStart day of the week (sunday, monday, etc)
	WeekStart string `json:"weekStart,omitempty"`
}

// Validate validates this preferences
func (m *Preferences) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCookiePreferences(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQueryHistory(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Preferences) validateCookiePreferences(formats strfmt.Registry) error {
	if swag.IsZero(m.CookiePreferences) { // not required
		return nil
	}

	if m.CookiePreferences != nil {
		if err := m.CookiePreferences.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cookiePreferences")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cookiePreferences")
			}
			return err
		}
	}

	return nil
}

func (m *Preferences) validateQueryHistory(formats strfmt.Registry) error {
	if swag.IsZero(m.QueryHistory) { // not required
		return nil
	}

	if m.QueryHistory != nil {
		if err := m.QueryHistory.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("queryHistory")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("queryHistory")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this preferences based on the context it is used
func (m *Preferences) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCookiePreferences(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQueryHistory(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Preferences) contextValidateCookiePreferences(ctx context.Context, formats strfmt.Registry) error {

	if m.CookiePreferences != nil {

		if swag.IsZero(m.CookiePreferences) { // not required
			return nil
		}

		if err := m.CookiePreferences.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cookiePreferences")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cookiePreferences")
			}
			return err
		}
	}

	return nil
}

func (m *Preferences) contextValidateQueryHistory(ctx context.Context, formats strfmt.Registry) error {

	if m.QueryHistory != nil {

		if swag.IsZero(m.QueryHistory) { // not required
			return nil
		}

		if err := m.QueryHistory.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("queryHistory")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("queryHistory")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Preferences) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Preferences) UnmarshalBinary(b []byte) error {
	var res Preferences
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
