// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewAddUserRoleParams creates a new AddUserRoleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAddUserRoleParams() *AddUserRoleParams {
	return &AddUserRoleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAddUserRoleParamsWithTimeout creates a new AddUserRoleParams object
// with the ability to set a timeout on a request.
func NewAddUserRoleParamsWithTimeout(timeout time.Duration) *AddUserRoleParams {
	return &AddUserRoleParams{
		timeout: timeout,
	}
}

// NewAddUserRoleParamsWithContext creates a new AddUserRoleParams object
// with the ability to set a context for a request.
func NewAddUserRoleParamsWithContext(ctx context.Context) *AddUserRoleParams {
	return &AddUserRoleParams{
		Context: ctx,
	}
}

// NewAddUserRoleParamsWithHTTPClient creates a new AddUserRoleParams object
// with the ability to set a custom HTTPClient for a request.
func NewAddUserRoleParamsWithHTTPClient(client *http.Client) *AddUserRoleParams {
	return &AddUserRoleParams{
		HTTPClient: client,
	}
}

/*
AddUserRoleParams contains all the parameters to send to the API endpoint

	for the add user role operation.

	Typically these are written to a http.Request.
*/
type AddUserRoleParams struct {

	// Body.
	Body *models.AddUserRoleCommand

	// UserID.
	//
	// Format: int64
	UserID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the add user role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddUserRoleParams) WithDefaults() *AddUserRoleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the add user role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AddUserRoleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the add user role params
func (o *AddUserRoleParams) WithTimeout(timeout time.Duration) *AddUserRoleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the add user role params
func (o *AddUserRoleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the add user role params
func (o *AddUserRoleParams) WithContext(ctx context.Context) *AddUserRoleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the add user role params
func (o *AddUserRoleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the add user role params
func (o *AddUserRoleParams) WithHTTPClient(client *http.Client) *AddUserRoleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the add user role params
func (o *AddUserRoleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the add user role params
func (o *AddUserRoleParams) WithBody(body *models.AddUserRoleCommand) *AddUserRoleParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the add user role params
func (o *AddUserRoleParams) SetBody(body *models.AddUserRoleCommand) {
	o.Body = body
}

// WithUserID adds the userID to the add user role params
func (o *AddUserRoleParams) WithUserID(userID int64) *AddUserRoleParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the add user role params
func (o *AddUserRoleParams) SetUserID(userID int64) {
	o.UserID = userID
}

// WriteToRequest writes these params to a swagger request
func (o *AddUserRoleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param userId
	if err := r.SetPathParam("userId", swag.FormatInt64(o.UserID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
