// Code generated by go-swagger; DO NOT EDIT.

package datasource_permissions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeletePermissionsReader is a Reader for the DeletePermissions structure.
type DeletePermissionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeletePermissionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeletePermissionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDeletePermissionsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeletePermissionsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeletePermissionsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /datasources/{datasourceId}/permissions/{permissionId}] deletePermissions", response, response.Code())
	}
}

// NewDeletePermissionsOK creates a DeletePermissionsOK with default headers values
func NewDeletePermissionsOK() *DeletePermissionsOK {
	return &DeletePermissionsOK{}
}

/*
DeletePermissionsOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeletePermissionsOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete permissions Ok response has a 2xx status code
func (o *DeletePermissionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete permissions Ok response has a 3xx status code
func (o *DeletePermissionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete permissions Ok response has a 4xx status code
func (o *DeletePermissionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete permissions Ok response has a 5xx status code
func (o *DeletePermissionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete permissions Ok response a status code equal to that given
func (o *DeletePermissionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete permissions Ok response
func (o *DeletePermissionsOK) Code() int {
	return 200
}

func (o *DeletePermissionsOK) Error() string {
	return fmt.Sprintf("[DELETE /datasources/{datasourceId}/permissions/{permissionId}][%d] deletePermissionsOk  %+v", 200, o.Payload)
}

func (o *DeletePermissionsOK) String() string {
	return fmt.Sprintf("[DELETE /datasources/{datasourceId}/permissions/{permissionId}][%d] deletePermissionsOk  %+v", 200, o.Payload)
}

func (o *DeletePermissionsOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeletePermissionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePermissionsUnauthorized creates a DeletePermissionsUnauthorized with default headers values
func NewDeletePermissionsUnauthorized() *DeletePermissionsUnauthorized {
	return &DeletePermissionsUnauthorized{}
}

/*
DeletePermissionsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeletePermissionsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete permissions unauthorized response has a 2xx status code
func (o *DeletePermissionsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete permissions unauthorized response has a 3xx status code
func (o *DeletePermissionsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete permissions unauthorized response has a 4xx status code
func (o *DeletePermissionsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete permissions unauthorized response has a 5xx status code
func (o *DeletePermissionsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete permissions unauthorized response a status code equal to that given
func (o *DeletePermissionsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete permissions unauthorized response
func (o *DeletePermissionsUnauthorized) Code() int {
	return 401
}

func (o *DeletePermissionsUnauthorized) Error() string {
	return fmt.Sprintf("[DELETE /datasources/{datasourceId}/permissions/{permissionId}][%d] deletePermissionsUnauthorized  %+v", 401, o.Payload)
}

func (o *DeletePermissionsUnauthorized) String() string {
	return fmt.Sprintf("[DELETE /datasources/{datasourceId}/permissions/{permissionId}][%d] deletePermissionsUnauthorized  %+v", 401, o.Payload)
}

func (o *DeletePermissionsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeletePermissionsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePermissionsForbidden creates a DeletePermissionsForbidden with default headers values
func NewDeletePermissionsForbidden() *DeletePermissionsForbidden {
	return &DeletePermissionsForbidden{}
}

/*
DeletePermissionsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeletePermissionsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete permissions forbidden response has a 2xx status code
func (o *DeletePermissionsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete permissions forbidden response has a 3xx status code
func (o *DeletePermissionsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete permissions forbidden response has a 4xx status code
func (o *DeletePermissionsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete permissions forbidden response has a 5xx status code
func (o *DeletePermissionsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete permissions forbidden response a status code equal to that given
func (o *DeletePermissionsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete permissions forbidden response
func (o *DeletePermissionsForbidden) Code() int {
	return 403
}

func (o *DeletePermissionsForbidden) Error() string {
	return fmt.Sprintf("[DELETE /datasources/{datasourceId}/permissions/{permissionId}][%d] deletePermissionsForbidden  %+v", 403, o.Payload)
}

func (o *DeletePermissionsForbidden) String() string {
	return fmt.Sprintf("[DELETE /datasources/{datasourceId}/permissions/{permissionId}][%d] deletePermissionsForbidden  %+v", 403, o.Payload)
}

func (o *DeletePermissionsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeletePermissionsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeletePermissionsNotFound creates a DeletePermissionsNotFound with default headers values
func NewDeletePermissionsNotFound() *DeletePermissionsNotFound {
	return &DeletePermissionsNotFound{}
}

/*
DeletePermissionsNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeletePermissionsNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete permissions not found response has a 2xx status code
func (o *DeletePermissionsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete permissions not found response has a 3xx status code
func (o *DeletePermissionsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete permissions not found response has a 4xx status code
func (o *DeletePermissionsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete permissions not found response has a 5xx status code
func (o *DeletePermissionsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete permissions not found response a status code equal to that given
func (o *DeletePermissionsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete permissions not found response
func (o *DeletePermissionsNotFound) Code() int {
	return 404
}

func (o *DeletePermissionsNotFound) Error() string {
	return fmt.Sprintf("[DELETE /datasources/{datasourceId}/permissions/{permissionId}][%d] deletePermissionsNotFound  %+v", 404, o.Payload)
}

func (o *DeletePermissionsNotFound) String() string {
	return fmt.Sprintf("[DELETE /datasources/{datasourceId}/permissions/{permissionId}][%d] deletePermissionsNotFound  %+v", 404, o.Payload)
}

func (o *DeletePermissionsNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeletePermissionsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
