// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Folder folder
//
// swagger:model Folder
type Folder struct {

	// access control
	AccessControl Metadata `json:"accessControl,omitempty"`

	// can admin
	CanAdmin bool `json:"canAdmin,omitempty"`

	// can delete
	CanDelete bool `json:"canDelete,omitempty"`

	// can edit
	CanEdit bool `json:"canEdit,omitempty"`

	// can save
	CanSave bool `json:"canSave,omitempty"`

	// created
	// Format: date-time
	Created strfmt.DateTime `json:"created,omitempty"`

	// created by
	CreatedBy string `json:"createdBy,omitempty"`

	// has Acl
	HasACL bool `json:"hasAcl,omitempty"`

	// id
	ID int64 `json:"id,omitempty"`

	// only used if nested folders are enabled
	ParentUID string `json:"parentUid,omitempty"`

	// the parent folders starting from the root going down
	Parents []*Folder `json:"parents"`

	// title
	Title string `json:"title,omitempty"`

	// uid
	UID string `json:"uid,omitempty"`

	// updated
	// Format: date-time
	Updated strfmt.DateTime `json:"updated,omitempty"`

	// updated by
	UpdatedBy string `json:"updatedBy,omitempty"`

	// url
	URL string `json:"url,omitempty"`

	// version
	Version int64 `json:"version,omitempty"`
}

// Validate validates this folder
func (m *Folder) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccessControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdated(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Folder) validateAccessControl(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessControl) { // not required
		return nil
	}

	if m.AccessControl != nil {
		if err := m.AccessControl.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("accessControl")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("accessControl")
			}
			return err
		}
	}

	return nil
}

func (m *Folder) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(m.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("created", "body", "date-time", m.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Folder) validateParents(formats strfmt.Registry) error {
	if swag.IsZero(m.Parents) { // not required
		return nil
	}

	for i := 0; i < len(m.Parents); i++ {
		if swag.IsZero(m.Parents[i]) { // not required
			continue
		}

		if m.Parents[i] != nil {
			if err := m.Parents[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parents" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("parents" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Folder) validateUpdated(formats strfmt.Registry) error {
	if swag.IsZero(m.Updated) { // not required
		return nil
	}

	if err := validate.FormatOf("updated", "body", "date-time", m.Updated.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this folder based on the context it is used
func (m *Folder) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccessControl(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Folder) contextValidateAccessControl(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.AccessControl) { // not required
		return nil
	}

	if err := m.AccessControl.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("accessControl")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("accessControl")
		}
		return err
	}

	return nil
}

func (m *Folder) contextValidateParents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Parents); i++ {

		if m.Parents[i] != nil {

			if swag.IsZero(m.Parents[i]) { // not required
				return nil
			}

			if err := m.Parents[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("parents" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("parents" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Folder) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Folder) UnmarshalBinary(b []byte) error {
	var res Folder
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
