// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewSetUserRolesParams creates a new SetUserRolesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSetUserRolesParams() *SetUserRolesParams {
	return &SetUserRolesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSetUserRolesParamsWithTimeout creates a new SetUserRolesParams object
// with the ability to set a timeout on a request.
func NewSetUserRolesParamsWithTimeout(timeout time.Duration) *SetUserRolesParams {
	return &SetUserRolesParams{
		timeout: timeout,
	}
}

// NewSetUserRolesParamsWithContext creates a new SetUserRolesParams object
// with the ability to set a context for a request.
func NewSetUserRolesParamsWithContext(ctx context.Context) *SetUserRolesParams {
	return &SetUserRolesParams{
		Context: ctx,
	}
}

// NewSetUserRolesParamsWithHTTPClient creates a new SetUserRolesParams object
// with the ability to set a custom HTTPClient for a request.
func NewSetUserRolesParamsWithHTTPClient(client *http.Client) *SetUserRolesParams {
	return &SetUserRolesParams{
		HTTPClient: client,
	}
}

/*
SetUserRolesParams contains all the parameters to send to the API endpoint

	for the set user roles operation.

	Typically these are written to a http.Request.
*/
type SetUserRolesParams struct {

	// Body.
	Body *models.SetUserRolesCommand

	// UserID.
	//
	// Format: int64
	UserID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the set user roles params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetUserRolesParams) WithDefaults() *SetUserRolesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the set user roles params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SetUserRolesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the set user roles params
func (o *SetUserRolesParams) WithTimeout(timeout time.Duration) *SetUserRolesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the set user roles params
func (o *SetUserRolesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the set user roles params
func (o *SetUserRolesParams) WithContext(ctx context.Context) *SetUserRolesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the set user roles params
func (o *SetUserRolesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the set user roles params
func (o *SetUserRolesParams) WithHTTPClient(client *http.Client) *SetUserRolesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the set user roles params
func (o *SetUserRolesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the set user roles params
func (o *SetUserRolesParams) WithBody(body *models.SetUserRolesCommand) *SetUserRolesParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the set user roles params
func (o *SetUserRolesParams) SetBody(body *models.SetUserRolesCommand) {
	o.Body = body
}

// WithUserID adds the userID to the set user roles params
func (o *SetUserRolesParams) WithUserID(userID int64) *SetUserRolesParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the set user roles params
func (o *SetUserRolesParams) SetUserID(userID int64) {
	o.UserID = userID
}

// WriteToRequest writes these params to a swagger request
func (o *SetUserRolesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param userId
	if err := r.SetPathParam("userId", swag.FormatInt64(o.UserID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
