/*
 * Copyright (c) 2006 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Neither the name of the Advanced Micro Devices, Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 */

 /*
  * Cimarron default video coefficients.
  */

long CimarronVideoFilter256[][2] = {
    {0x10000000, 0x00000000},          /*     0, 4096,    0,    0 */
    {0x10008008, 0x00000008},          /*    -8, 4096,    8,    0 */
    {0x10008010, 0x80010011},          /*   -16, 4096,   17,   -1 */
    {0x10008019, 0x8001001A},          /*   -25, 4096,   26,   -1 */
    {0x10008021, 0x80020023},          /*   -33, 4096,   35,   -2 */
    {0x0FFF8029, 0x8003002D},          /*   -41, 4095,   45,   -3 */
    {0x0FFE8031, 0x80030036},          /*   -49, 4094,   54,   -3 */
    {0x0FFC8038, 0x80040040},          /*   -56, 4092,   64,   -4 */
    {0x0FFB8040, 0x8005004A},          /*   -64, 4091,   74,   -5 */
    {0x0FF88047, 0x80050054},          /*   -71, 4088,   84,   -5 */
    {0x0FF6804E, 0x8006005E},          /*   -78, 4086,   94,   -6 */
    {0x0FF48055, 0x80070068},          /*   -85, 4084,  104,   -7 */
    {0x0FF0805C, 0x80070073},          /*   -92, 4080,  115,   -7 */
    {0x0FEE8063, 0x8008007D},          /*   -99, 4078,  125,   -8 */
    {0x0FEA8069, 0x80090088},          /*  -105, 4074,  136,   -9 */
    {0x0FE78070, 0x800A0093},          /*  -112, 4071,  147,  -10 */
    {0x0FE28076, 0x800A009E},          /*  -118, 4066,  158,  -10 */
    {0x0FDD807C, 0x800B00AA},          /*  -124, 4061,  170,  -11 */
    {0x0FD98082, 0x800C00B5},          /*  -130, 4057,  181,  -12 */
    {0x0FD48088, 0x800D00C1},          /*  -136, 4052,  193,  -13 */
    {0x0FCE808E, 0x800D00CD},          /*  -142, 4046,  205,  -13 */
    {0x0FC88093, 0x800E00D9},          /*  -147, 4040,  217,  -14 */
    {0x0FC38099, 0x800F00E5},          /*  -153, 4035,  229,  -15 */
    {0x0FBD809E, 0x801000F1},          /*  -158, 4029,  241,  -16 */
    {0x0FB680A3, 0x801000FD},          /*  -163, 4022,  253,  -16 */
    {0x0FAF80A8, 0x8011010A},          /*  -168, 4015,  266,  -17 */
    {0x0FA880AD, 0x80120117},          /*  -173, 4008,  279,  -18 */
    {0x0FA180B2, 0x80130124},          /*  -178, 4001,  292,  -19 */
    {0x0F9980B6, 0x80140131},          /*  -182, 3993,  305,  -20 */
    {0x0F9280BB, 0x8015013E},          /*  -187, 3986,  318,  -21 */
    {0x0F8880BF, 0x8015014C},          /*  -191, 3976,  332,  -21 */
    {0x0F8080C3, 0x80160159},          /*  -195, 3968,  345,  -22 */
    {0x0F7880C8, 0x80170167},          /*  -200, 3960,  359,  -23 */
    {0x0F6E80CB, 0x80180175},          /*  -203, 3950,  373,  -24 */
    {0x0F6580CF, 0x80190183},          /*  -207, 3941,  387,  -25 */
    {0x0F5C80D3, 0x801A0191},          /*  -211, 3932,  401,  -26 */
    {0x0F5280D7, 0x801B01A0},          /*  -215, 3922,  416,  -27 */
    {0x0F4880DA, 0x801C01AE},          /*  -218, 3912,  430,  -28 */
    {0x0F3D80DD, 0x801D01BD},          /*  -221, 3901,  445,  -29 */
    {0x0F3280E0, 0x801E01CC},          /*  -224, 3890,  460,  -30 */
    {0x0F2880E4, 0x801F01DB},          /*  -228, 3880,  475,  -31 */
    {0x0F1C80E6, 0x802001EA},          /*  -230, 3868,  490,  -32 */
    {0x0F1180E9, 0x802101F9},          /*  -233, 3857,  505,  -33 */
    {0x0F0480EB, 0x80210208},          /*  -235, 3844,  520,  -33 */
    {0x0EFA80EF, 0x80230218},          /*  -239, 3834,  536,  -35 */
    {0x0EEC80F0, 0x80230227},          /*  -240, 3820,  551,  -35 */
    {0x0EE080F3, 0x80240237},          /*  -243, 3808,  567,  -36 */
    {0x0ED380F5, 0x80250247},          /*  -245, 3795,  583,  -37 */
    {0x0EC780F7, 0x80270257},          /*  -247, 3783,  599,  -39 */
    {0x0EB980F9, 0x80280268},          /*  -249, 3769,  616,  -40 */
    {0x0EAC80FB, 0x80290278},          /*  -251, 3756,  632,  -41 */
    {0x0E9E80FD, 0x802A0289},          /*  -253, 3742,  649,  -42 */
    {0x0E9080FE, 0x802B0299},          /*  -254, 3728,  665,  -43 */
    {0x0E838100, 0x802D02AA},          /*  -256, 3715,  682,  -45 */
    {0x0E758102, 0x802E02BB},          /*  -258, 3701,  699,  -46 */
    {0x0E668103, 0x802F02CC},          /*  -259, 3686,  716,  -47 */
    {0x0E568104, 0x803002DE},          /*  -260, 3670,  734,  -48 */
    {0x0E498106, 0x803202EF},          /*  -262, 3657,  751,  -50 */
    {0x0E398107, 0x80330301},          /*  -263, 3641,  769,  -51 */
    {0x0E298108, 0x80340313},          /*  -264, 3625,  787,  -52 */
    {0x0E1A8109, 0x80360325},          /*  -265, 3610,  805,  -54 */
    {0x0E0B810A, 0x80370336},          /*  -266, 3595,  822,  -55 */
    {0x0DFA810A, 0x80380348},          /*  -266, 3578,  840,  -56 */
    {0x0DEA810B, 0x803A035B},          /*  -267, 3562,  859,  -58 */
    {0x0DDA810C, 0x803B036D},          /*  -268, 3546,  877,  -59 */
    {0x0DCA810C, 0x803D037F},          /*  -268, 3530,  895,  -61 */
    {0x0DB7810B, 0x803E0392},          /*  -267, 3511,  914,  -62 */
    {0x0DA7810C, 0x804003A5},          /*  -268, 3495,  933,  -64 */
    {0x0D95810C, 0x804103B8},          /*  -268, 3477,  952,  -65 */
    {0x0D85810C, 0x804303CA},          /*  -268, 3461,  970,  -67 */
    {0x0D73810C, 0x804403DD},          /*  -268, 3443,  989,  -68 */
    {0x0D61810C, 0x804603F1},          /*  -268, 3425, 1009,  -70 */
    {0x0D50810C, 0x80480404},          /*  -268, 3408, 1028,  -72 */
    {0x0D3E810C, 0x80490417},          /*  -268, 3390, 1047,  -73 */
    {0x0D2C810C, 0x804B042B},          /*  -268, 3372, 1067,  -75 */
    {0x0D1B810C, 0x804D043E},          /*  -268, 3355, 1086,  -77 */
    {0x0D07810B, 0x804E0452},          /*  -267, 3335, 1106,  -78 */
    {0x0CF5810B, 0x80500466},          /*  -267, 3317, 1126,  -80 */
    {0x0CE2810A, 0x8052047A},          /*  -266, 3298, 1146,  -82 */
    {0x0CCF810A, 0x8053048E},          /*  -266, 3279, 1166,  -83 */
    {0x0CBC8109, 0x805504A2},          /*  -265, 3260, 1186,  -85 */
    {0x0CA98108, 0x805704B6},          /*  -264, 3241, 1206,  -87 */
    {0x0C968108, 0x805904CB},          /*  -264, 3222, 1227,  -89 */
    {0x0C838107, 0x805B04DF},          /*  -263, 3203, 1247,  -91 */
    {0x0C6F8106, 0x805C04F3},          /*  -262, 3183, 1267,  -92 */
    {0x0C5B8105, 0x805E0508},          /*  -261, 3163, 1288,  -94 */
    {0x0C478104, 0x8060051D},          /*  -260, 3143, 1309,  -96 */
    {0x0C348103, 0x80620531},          /*  -259, 3124, 1329,  -98 */
    {0x0C1F8102, 0x80640547},          /*  -258, 3103, 1351, -100 */
    {0x0C0C8101, 0x8066055B},          /*  -257, 3084, 1371, -102 */
    {0x0BF88100, 0x80680570},          /*  -256, 3064, 1392, -104 */
    {0x0BE380FE, 0x806A0585},          /*  -254, 3043, 1413, -106 */
    {0x0BCF80FD, 0x806C059A},          /*  -253, 3023, 1434, -108 */
    {0x0BBA80FC, 0x806E05B0},          /*  -252, 3002, 1456, -110 */
    {0x0BA480F9, 0x807005C5},          /*  -249, 2980, 1477, -112 */
    {0x0B8F80F8, 0x807205DB},          /*  -248, 2959, 1499, -114 */
    {0x0B7A80F6, 0x807405F0},          /*  -246, 2938, 1520, -116 */
    {0x0B6580F5, 0x80760606},          /*  -245, 2917, 1542, -118 */
    {0x0B4F80F3, 0x8077061B},          /*  -243, 2895, 1563, -119 */
    {0x0B3A80F2, 0x80790631},          /*  -242, 2874, 1585, -121 */
    {0x0B2480F0, 0x807B0647},          /*  -240, 2852, 1607, -123 */
    {0x0B0F80EE, 0x807D065C},          /*  -238, 2831, 1628, -125 */
    {0x0AF980ED, 0x807F0673},          /*  -237, 2809, 1651, -127 */
    {0x0AE480EB, 0x80810688},          /*  -235, 2788, 1672, -129 */
    {0x0ACE80E9, 0x8084069F},          /*  -233, 2766, 1695, -132 */
    {0x0AB980E7, 0x808606B4},          /*  -231, 2745, 1716, -134 */
    {0x0AA380E6, 0x808806CB},          /*  -230, 2723, 1739, -136 */
    {0x0A8D80E4, 0x808A06E1},          /*  -228, 2701, 1761, -138 */
    {0x0A7780E2, 0x808C06F7},          /*  -226, 2679, 1783, -140 */
    {0x0A6180E0, 0x808E070D},          /*  -224, 2657, 1805, -142 */
    {0x0A4B80DE, 0x80910724},          /*  -222, 2635, 1828, -145 */
    {0x0A3580DC, 0x8093073A},          /*  -220, 2613, 1850, -147 */
    {0x0A1F80DA, 0x80950750},          /*  -218, 2591, 1872, -149 */
    {0x0A0880D8, 0x80970767},          /*  -216, 2568, 1895, -151 */
    {0x09F280D6, 0x8099077D},          /*  -214, 2546, 1917, -153 */
    {0x09DD80D4, 0x809C0793},          /*  -212, 2525, 1939, -156 */
    {0x09C680D2, 0x809E07AA},          /*  -210, 2502, 1962, -158 */
    {0x09B080D0, 0x80A007C0},          /*  -208, 2480, 1984, -160 */
    {0x099980CE, 0x80A207D7},          /*  -206, 2457, 2007, -162 */
    {0x098380CB, 0x80A507ED},          /*  -203, 2435, 2029, -165 */
    {0x096C80C9, 0x80A70804},          /*  -201, 2412, 2052, -167 */
    {0x095680C7, 0x80A9081A},          /*  -199, 2390, 2074, -169 */
    {0x094080C5, 0x80AB0830},          /*  -197, 2368, 2096, -171 */
    {0x092980C3, 0x80AE0848},          /*  -195, 2345, 2120, -174 */
    {0x091380C1, 0x80B0085E},          /*  -193, 2323, 2142, -176 */
    {0x08FC80BE, 0x80B20874},          /*  -190, 2300, 2164, -178 */
    {0x08E580BC, 0x80B4088B},          /*  -188, 2277, 2187, -180 */
    {0x08D080BB, 0x80B708A2},          /*  -187, 2256, 2210, -183 */
    {0x08B980B9, 0x80B908B9},          /*  -185, 2233, 2233, -185 */
    {0x08A380B7, 0x80BB08CF},          /*  -183, 2211, 2255, -187 */
    {0x088B80B4, 0x80BC08E5},          /*  -180, 2187, 2277, -188 */
    {0x087480B2, 0x80BE08FC},          /*  -178, 2164, 2300, -190 */
    {0x085E80B0, 0x80C10913},          /*  -176, 2142, 2323, -193 */
    {0x084880AE, 0x80C30929},          /*  -174, 2120, 2345, -195 */
    {0x083080AB, 0x80C50940},          /*  -171, 2096, 2368, -197 */
    {0x081A80A9, 0x80C70956},          /*  -169, 2074, 2390, -199 */
    {0x080480A7, 0x80C9096C},          /*  -167, 2052, 2412, -201 */
    {0x07ED80A5, 0x80CB0983},          /*  -165, 2029, 2435, -203 */
    {0x07D780A2, 0x80CE0999},          /*  -162, 2007, 2457, -206 */
    {0x07C080A0, 0x80D009B0},          /*  -160, 1984, 2480, -208 */
    {0x07AA809E, 0x80D209C6},          /*  -158, 1962, 2502, -210 */
    {0x0793809C, 0x80D409DD},          /*  -156, 1939, 2525, -212 */
    {0x077D8099, 0x80D609F2},          /*  -153, 1917, 2546, -214 */
    {0x07668097, 0x80D80A09},          /*  -151, 1894, 2569, -216 */
    {0x074F8095, 0x80DA0A20},          /*  -149, 1871, 2592, -218 */
    {0x073A8093, 0x80DC0A35},          /*  -147, 1850, 2613, -220 */
    {0x07238091, 0x80DE0A4C},          /*  -145, 1827, 2636, -222 */
    {0x070C808E, 0x80E00A62},          /*  -142, 1804, 2658, -224 */
    {0x06F7808C, 0x80E20A77},          /*  -140, 1783, 2679, -226 */
    {0x06E0808A, 0x80E40A8E},          /*  -138, 1760, 2702, -228 */
    {0x06CA8088, 0x80E60AA4},          /*  -136, 1738, 2724, -230 */
    {0x06B48086, 0x80E70AB9},          /*  -134, 1716, 2745, -231 */
    {0x069E8084, 0x80E90ACF},          /*  -132, 1694, 2767, -233 */
    {0x06878081, 0x80EB0AE5},          /*  -129, 1671, 2789, -235 */
    {0x0672807F, 0x80ED0AFA},          /*  -127, 1650, 2810, -237 */
    {0x065C807D, 0x80EE0B0F},          /*  -125, 1628, 2831, -238 */
    {0x0646807B, 0x80F00B25},          /*  -123, 1606, 2853, -240 */
    {0x06308079, 0x80F20B3B},          /*  -121, 1584, 2875, -242 */
    {0x061A8077, 0x80F30B50},          /*  -119, 1562, 2896, -243 */
    {0x06068076, 0x80F50B65},          /*  -118, 1542, 2917, -245 */
    {0x05F08074, 0x80F60B7A},          /*  -116, 1520, 2938, -246 */
    {0x05DB8072, 0x80F80B8F},          /*  -114, 1499, 2959, -248 */
    {0x05C58070, 0x80F90BA4},          /*  -112, 1477, 2980, -249 */
    {0x05B1806E, 0x80FC0BB9},          /*  -110, 1457, 3001, -252 */
    {0x059B806C, 0x80FD0BCE},          /*  -108, 1435, 3022, -253 */
    {0x0586806A, 0x80FE0BE2},          /*  -106, 1414, 3042, -254 */
    {0x05718068, 0x81000BF7},          /*  -104, 1393, 3063, -256 */
    {0x055C8066, 0x81010C0B},          /*  -102, 1372, 3083, -257 */
    {0x05478064, 0x81020C1F},          /*  -100, 1351, 3103, -258 */
    {0x05328062, 0x81030C33},          /*   -98, 1330, 3123, -259 */
    {0x051D8060, 0x81040C47},          /*   -96, 1309, 3143, -260 */
    {0x0508805E, 0x81050C5B},          /*   -94, 1288, 3163, -261 */
    {0x04F3805C, 0x81060C6F},          /*   -92, 1267, 3183, -262 */
    {0x04E0805B, 0x81070C82},          /*   -91, 1248, 3202, -263 */
    {0x04CB8059, 0x81080C96},          /*   -89, 1227, 3222, -264 */
    {0x04B68057, 0x81080CA9},          /*   -87, 1206, 3241, -264 */
    {0x04A28055, 0x81090CBC},          /*   -85, 1186, 3260, -265 */
    {0x048E8053, 0x810A0CCF},          /*   -83, 1166, 3279, -266 */
    {0x047A8052, 0x810A0CE2},          /*   -82, 1146, 3298, -266 */
    {0x04668050, 0x810B0CF5},          /*   -80, 1126, 3317, -267 */
    {0x0451804E, 0x810B0D08},          /*   -78, 1105, 3336, -267 */
    {0x043E804D, 0x810C0D1B},          /*   -77, 1086, 3355, -268 */
    {0x042B804B, 0x810C0D2C},          /*   -75, 1067, 3372, -268 */
    {0x04178049, 0x810C0D3E},          /*   -73, 1047, 3390, -268 */
    {0x04038048, 0x810C0D51},          /*   -72, 1027, 3409, -268 */
    {0x03F08046, 0x810C0D62},          /*   -70, 1008, 3426, -268 */
    {0x03DD8044, 0x810C0D73},          /*   -68,  989, 3443, -268 */
    {0x03CA8043, 0x810C0D85},          /*   -67,  970, 3461, -268 */
    {0x03B78041, 0x810C0D96},          /*   -65,  951, 3478, -268 */
    {0x03A48040, 0x810C0DA8},          /*   -64,  932, 3496, -268 */
    {0x0391803E, 0x810B0DB8},          /*   -62,  913, 3512, -267 */
    {0x0380803D, 0x810C0DC9},          /*   -61,  896, 3529, -268 */
    {0x036D803B, 0x810C0DDA},          /*   -59,  877, 3546, -268 */
    {0x035B803A, 0x810B0DEA},          /*   -58,  859, 3562, -267 */
    {0x03488038, 0x810A0DFA},          /*   -56,  840, 3578, -266 */
    {0x03368037, 0x810A0E0B},          /*   -55,  822, 3595, -266 */
    {0x03248036, 0x81090E1B},          /*   -54,  804, 3611, -265 */
    {0x03128034, 0x81080E2A},          /*   -52,  786, 3626, -264 */
    {0x03018033, 0x81070E39},          /*   -51,  769, 3641, -263 */
    {0x02EF8032, 0x81060E49},          /*   -50,  751, 3657, -262 */
    {0x02DE8030, 0x81040E56},          /*   -48,  734, 3670, -260 */
    {0x02CC802F, 0x81030E66},          /*   -47,  716, 3686, -259 */
    {0x02BB802E, 0x81020E75},          /*   -46,  699, 3701, -258 */
    {0x02AA802D, 0x81000E83},          /*   -45,  682, 3715, -256 */
    {0x0299802B, 0x80FE0E90},          /*   -43,  665, 3728, -254 */
    {0x0288802A, 0x80FD0E9F},          /*   -42,  648, 3743, -253 */
    {0x02778029, 0x80FB0EAD},          /*   -41,  631, 3757, -251 */
    {0x02678028, 0x80F90EBA},          /*   -40,  615, 3770, -249 */
    {0x02568027, 0x80F70EC8},          /*   -39,  598, 3784, -247 */
    {0x02468025, 0x80F50ED4},          /*   -37,  582, 3796, -245 */
    {0x02368024, 0x80F30EE1},          /*   -36,  566, 3809, -243 */
    {0x02268023, 0x80F00EED},          /*   -35,  550, 3821, -240 */
    {0x02188023, 0x80EF0EFA},          /*   -35,  536, 3834, -239 */
    {0x02078021, 0x80EB0F05},          /*   -33,  519, 3845, -235 */
    {0x01F98021, 0x80E90F11},          /*   -33,  505, 3857, -233 */
    {0x01EA8020, 0x80E60F1C},          /*   -32,  490, 3868, -230 */
    {0x01DC801F, 0x80E40F27},          /*   -31,  476, 3879, -228 */
    {0x01CD801E, 0x80E00F31},          /*   -30,  461, 3889, -224 */
    {0x01BE801D, 0x80DD0F3C},          /*   -29,  446, 3900, -221 */
    {0x01AF801C, 0x80DA0F47},          /*   -28,  431, 3911, -218 */
    {0x01A1801B, 0x80D70F51},          /*   -27,  417, 3921, -215 */
    {0x0192801A, 0x80D30F5B},          /*   -26,  402, 3931, -211 */
    {0x01848019, 0x80CF0F64},          /*   -25,  388, 3940, -207 */
    {0x01768018, 0x80CB0F6D},          /*   -24,  374, 3949, -203 */
    {0x01688017, 0x80C80F77},          /*   -23,  360, 3959, -200 */
    {0x015A8016, 0x80C30F7F},          /*   -22,  346, 3967, -195 */
    {0x014D8015, 0x80BF0F87},          /*   -21,  333, 3975, -191 */
    {0x013F8015, 0x80BB0F91},          /*   -21,  319, 3985, -187 */
    {0x01328014, 0x80B60F98},          /*   -20,  306, 3992, -182 */
    {0x01258013, 0x80B20FA0},          /*   -19,  293, 4000, -178 */
    {0x01188012, 0x80AD0FA7},          /*   -18,  280, 4007, -173 */
    {0x010B8011, 0x80A80FAE},          /*   -17,  267, 4014, -168 */
    {0x00FE8010, 0x80A30FB5},          /*   -16,  254, 4021, -163 */
    {0x00F28010, 0x809E0FBC},          /*   -16,  242, 4028, -158 */
    {0x00E6800F, 0x80990FC2},          /*   -15,  230, 4034, -153 */
    {0x00DA800E, 0x80930FC7},          /*   -14,  218, 4039, -147 */
    {0x00CE800D, 0x808E0FCD},          /*   -13,  206, 4045, -142 */
    {0x00C2800D, 0x80880FD3},          /*   -13,  194, 4051, -136 */
    {0x00B6800C, 0x80820FD8},          /*   -12,  182, 4056, -130 */
    {0x00AB800B, 0x807C0FDC},          /*   -11,  171, 4060, -124 */
    {0x009F800A, 0x80760FE1},          /*   -10,  159, 4065, -118 */
    {0x0094800A, 0x80700FE6},          /*   -10,  148, 4070, -112 */
    {0x00898009, 0x80690FE9},          /*    -9,  137, 4073, -105 */
    {0x007E8008, 0x80630FED},          /*    -8,  126, 4077,  -99 */
    {0x00748007, 0x805C0FEF},          /*    -7,  116, 4079,  -92 */
    {0x00698007, 0x80550FF3},          /*    -7,  105, 4083,  -85 */
    {0x005F8006, 0x804E0FF5},          /*    -6,   95, 4085,  -78 */
    {0x00558005, 0x80470FF7},          /*    -5,   85, 4087,  -71 */
    {0x004B8005, 0x80400FFA},          /*    -5,   75, 4090,  -64 */
    {0x00418004, 0x80380FFB},          /*    -4,   65, 4091,  -56 */
    {0x00378003, 0x80310FFD},          /*    -3,   55, 4093,  -49 */
    {0x002E8003, 0x80290FFE},          /*    -3,   46, 4094,  -41 */
    {0x00238002, 0x80211000},          /*    -2,   35, 4096,  -33 */
    {0x001A8001, 0x80191000},          /*    -1,   26, 4096,  -25 */
    {0x00118001, 0x80101000},          /*    -1,   17, 4096,  -16 */
    {0x00080000, 0x80081000},          /*     0,    8, 4096,   -8 */
};

long CimarronVideoFilter128[][2] = {
    {0x10000000, 0x00000000},          /*     0, 4096,    0,    0 */
    {0x10018011, 0x80010011},          /*   -17, 4097,   17,   -1 */
    {0x10008021, 0x80020023},          /*   -33, 4096,   35,   -2 */
    {0x0FFE8031, 0x80030036},          /*   -49, 4094,   54,   -3 */
    {0x0FFB8040, 0x8005004A},          /*   -64, 4091,   74,   -5 */
    {0x0FF6804E, 0x8006005E},          /*   -78, 4086,   94,   -6 */
    {0x0FF0805C, 0x80070073},          /*   -92, 4080,  115,   -7 */
    {0x0FEB806A, 0x80090088},          /*  -106, 4075,  136,   -9 */
    {0x0FE18076, 0x800A009F},          /*  -118, 4065,  159,  -10 */
    {0x0FD98082, 0x800C00B5},          /*  -130, 4057,  181,  -12 */
    {0x0FCE808E, 0x800D00CD},          /*  -142, 4046,  205,  -13 */
    {0x0FC38099, 0x800F00E5},          /*  -153, 4035,  229,  -15 */
    {0x0FB680A4, 0x801000FE},          /*  -164, 4022,  254,  -16 */
    {0x0FA880AD, 0x80120117},          /*  -173, 4008,  279,  -18 */
    {0x0F9A80B7, 0x80140131},          /*  -183, 3994,  305,  -20 */
    {0x0F8980C0, 0x8015014C},          /*  -192, 3977,  332,  -21 */
    {0x0F7880C8, 0x80170167},          /*  -200, 3960,  359,  -23 */
    {0x0F6680D0, 0x80190183},          /*  -208, 3942,  387,  -25 */
    {0x0F5280D7, 0x801B01A0},          /*  -215, 3922,  416,  -27 */
    {0x0F3E80DE, 0x801D01BD},          /*  -222, 3902,  445,  -29 */
    {0x0F2880E4, 0x801F01DB},          /*  -228, 3880,  475,  -31 */
    {0x0F1180EA, 0x802101FA},          /*  -234, 3857,  506,  -33 */
    {0x0EF880EE, 0x80220218},          /*  -238, 3832,  536,  -34 */
    {0x0EDF80F3, 0x80240238},          /*  -243, 3807,  568,  -36 */
    {0x0EC680F7, 0x80270258},          /*  -247, 3782,  600,  -39 */
    {0x0EAB80FB, 0x80290279},          /*  -251, 3755,  633,  -41 */
    {0x0E9080FF, 0x802B029A},          /*  -255, 3728,  666,  -43 */
    {0x0E748102, 0x802E02BC},          /*  -258, 3700,  700,  -46 */
    {0x0E588105, 0x803102DE},          /*  -261, 3672,  734,  -49 */
    {0x0E388107, 0x80330302},          /*  -263, 3640,  770,  -51 */
    {0x0E1A8109, 0x80360325},          /*  -265, 3610,  805,  -54 */
    {0x0DFB810B, 0x80390349},          /*  -267, 3579,  841,  -57 */
    {0x0DDB810C, 0x803C036D},          /*  -268, 3547,  877,  -60 */
    {0x0DBA810D, 0x803F0392},          /*  -269, 3514,  914,  -63 */
    {0x0D98810E, 0x804203B8},          /*  -270, 3480,  952,  -66 */
    {0x0D74810D, 0x804503DE},          /*  -269, 3444,  990,  -69 */
    {0x0D50810D, 0x80480405},          /*  -269, 3408, 1029,  -72 */
    {0x0D2C810C, 0x804B042B},          /*  -268, 3372, 1067,  -75 */
    {0x0D08810C, 0x804F0453},          /*  -268, 3336, 1107,  -79 */
    {0x0CE3810B, 0x8052047A},          /*  -267, 3299, 1146,  -82 */
    {0x0CBD810A, 0x805604A3},          /*  -266, 3261, 1187,  -86 */
    {0x0C968108, 0x805904CB},          /*  -264, 3222, 1227,  -89 */
    {0x0C708107, 0x805D04F4},          /*  -263, 3184, 1268,  -93 */
    {0x0C488105, 0x8061051E},          /*  -261, 3144, 1310,  -97 */
    {0x0C208103, 0x80640547},          /*  -259, 3104, 1351, -100 */
    {0x0BF78100, 0x80680571},          /*  -256, 3063, 1393, -104 */
    {0x0BCF80FE, 0x806C059B},          /*  -254, 3023, 1435, -108 */
    {0x0BA480FA, 0x807005C6},          /*  -250, 2980, 1478, -112 */
    {0x0B7A80F7, 0x807405F1},          /*  -247, 2938, 1521, -116 */
    {0x0B4F80F4, 0x8077061C},          /*  -244, 2895, 1564, -119 */
    {0x0B2580F1, 0x807C0648},          /*  -241, 2853, 1608, -124 */
    {0x0AFA80ED, 0x80800673},          /*  -237, 2810, 1651, -128 */
    {0x0ACF80EA, 0x8084069F},          /*  -234, 2767, 1695, -132 */
    {0x0AA380E6, 0x808806CB},          /*  -230, 2723, 1739, -136 */
    {0x0A7880E2, 0x808D06F7},          /*  -226, 2680, 1783, -141 */
    {0x0A4C80DF, 0x80910724},          /*  -223, 2636, 1828, -145 */
    {0x0A2080DB, 0x80960751},          /*  -219, 2592, 1873, -150 */
    {0x09F480D7, 0x809A077D},          /*  -215, 2548, 1917, -154 */
    {0x09C780D2, 0x809F07AA},          /*  -210, 2503, 1962, -159 */
    {0x099A80CE, 0x80A307D7},          /*  -206, 2458, 2007, -163 */
    {0x096D80CA, 0x80A70804},          /*  -202, 2413, 2052, -167 */
    {0x094180C6, 0x80AC0831},          /*  -198, 2369, 2097, -172 */
    {0x091380C1, 0x80B0085E},          /*  -193, 2323, 2142, -176 */
    {0x08E780BE, 0x80B5088C},          /*  -190, 2279, 2188, -181 */
    {0x08B980B9, 0x80B908B9},          /*  -185, 2233, 2233, -185 */
    {0x088C80B5, 0x80BE08E7},          /*  -181, 2188, 2279, -190 */
    {0x085E80B0, 0x80C10913},          /*  -176, 2142, 2323, -193 */
    {0x083180AC, 0x80C60941},          /*  -172, 2097, 2369, -198 */
    {0x080480A7, 0x80CA096D},          /*  -167, 2052, 2413, -202 */
    {0x07D780A3, 0x80CE099A},          /*  -163, 2007, 2458, -206 */
    {0x07AA809F, 0x80D209C7},          /*  -159, 1962, 2503, -210 */
    {0x077D809A, 0x80D709F4},          /*  -154, 1917, 2548, -215 */
    {0x07518096, 0x80DB0A20},          /*  -150, 1873, 2592, -219 */
    {0x07248091, 0x80DF0A4C},          /*  -145, 1828, 2636, -223 */
    {0x06F7808D, 0x80E20A78},          /*  -141, 1783, 2680, -226 */
    {0x06CA8088, 0x80E60AA4},          /*  -136, 1738, 2724, -230 */
    {0x069E8084, 0x80EA0AD0},          /*  -132, 1694, 2768, -234 */
    {0x06738080, 0x80ED0AFA},          /*  -128, 1651, 2810, -237 */
    {0x0647807C, 0x80F10B26},          /*  -124, 1607, 2854, -241 */
    {0x061B8077, 0x80F40B50},          /*  -119, 1563, 2896, -244 */
    {0x05F18074, 0x80F70B7A},          /*  -116, 1521, 2938, -247 */
    {0x05C68070, 0x80FA0BA4},          /*  -112, 1478, 2980, -250 */
    {0x059C806C, 0x80FE0BCE},          /*  -108, 1436, 3022, -254 */
    {0x05728068, 0x81000BF6},          /*  -104, 1394, 3062, -256 */
    {0x05478064, 0x81030C20},          /*  -100, 1351, 3104, -259 */
    {0x051E8061, 0x81050C48},          /*   -97, 1310, 3144, -261 */
    {0x04F4805D, 0x81070C70},          /*   -93, 1268, 3184, -263 */
    {0x04CB8059, 0x81080C96},          /*   -89, 1227, 3222, -264 */
    {0x04A38056, 0x810A0CBD},          /*   -86, 1187, 3261, -266 */
    {0x047A8052, 0x810B0CE3},          /*   -82, 1146, 3299, -267 */
    {0x0453804F, 0x810C0D08},          /*   -79, 1107, 3336, -268 */
    {0x042B804B, 0x810C0D2C},          /*   -75, 1067, 3372, -268 */
    {0x04048048, 0x810D0D51},          /*   -72, 1028, 3409, -269 */
    {0x03DE8045, 0x810D0D74},          /*   -69,  990, 3444, -269 */
    {0x03B88042, 0x810E0D98},          /*   -66,  952, 3480, -270 */
    {0x0393803F, 0x810D0DB9},          /*   -63,  915, 3513, -269 */
    {0x036E803C, 0x810C0DDA},          /*   -60,  878, 3546, -268 */
    {0x03498039, 0x810B0DFB},          /*   -57,  841, 3579, -267 */
    {0x03258036, 0x81090E1A},          /*   -54,  805, 3610, -265 */
    {0x03018033, 0x81070E39},          /*   -51,  769, 3641, -263 */
    {0x02DE8031, 0x81050E58},          /*   -49,  734, 3672, -261 */
    {0x02BC802E, 0x81020E74},          /*   -46,  700, 3700, -258 */
    {0x0299802B, 0x80FF0E91},          /*   -43,  665, 3729, -255 */
    {0x02788029, 0x80FB0EAC},          /*   -41,  632, 3756, -251 */
    {0x02578027, 0x80F70EC7},          /*   -39,  599, 3783, -247 */
    {0x02378024, 0x80F30EE0},          /*   -36,  567, 3808, -243 */
    {0x02178022, 0x80EE0EF9},          /*   -34,  535, 3833, -238 */
    {0x01FA8021, 0x80EA0F11},          /*   -33,  506, 3857, -234 */
    {0x01DC801F, 0x80E40F27},          /*   -31,  476, 3879, -228 */
    {0x01BE801D, 0x80DE0F3D},          /*   -29,  446, 3901, -222 */
    {0x01A1801B, 0x80D70F51},          /*   -27,  417, 3921, -215 */
    {0x01848019, 0x80D00F65},          /*   -25,  388, 3941, -208 */
    {0x01688017, 0x80C80F77},          /*   -23,  360, 3959, -200 */
    {0x014D8015, 0x80C00F88},          /*   -21,  333, 3976, -192 */
    {0x01328014, 0x80B70F99},          /*   -20,  306, 3993, -183 */
    {0x01188012, 0x80AD0FA7},          /*   -18,  280, 4007, -173 */
    {0x00FF8010, 0x80A40FB5},          /*   -16,  255, 4021, -164 */
    {0x00E6800F, 0x80990FC2},          /*   -15,  230, 4034, -153 */
    {0x00CE800D, 0x808E0FCD},          /*   -13,  206, 4045, -142 */
    {0x00B6800C, 0x80820FD8},          /*   -12,  182, 4056, -130 */
    {0x00A0800A, 0x80760FE0},          /*   -10,  160, 4064, -118 */
    {0x00898009, 0x806A0FEA},          /*    -9,  137, 4074, -106 */
    {0x00748007, 0x805C0FEF},          /*    -7,  116, 4079,  -92 */
    {0x005F8006, 0x804E0FF5},          /*    -6,   95, 4085,  -78 */
    {0x004B8005, 0x80400FFA},          /*    -5,   75, 4090,  -64 */
    {0x00378003, 0x80310FFD},          /*    -3,   55, 4093,  -49 */
    {0x00238002, 0x80211000},          /*    -2,   35, 4096,  -33 */
    {0x00118001, 0x80111001},          /*    -1,   17, 4097,  -17 */
    {0x10000000, 0x00000000},          /*     0, 4096,    0,    0 */
    {0x10018011, 0x80010011},          /*   -17, 4097,   17,   -1 */
    {0x10008021, 0x80020023},          /*   -33, 4096,   35,   -2 */
    {0x0FFE8031, 0x80030036},          /*   -49, 4094,   54,   -3 */
    {0x0FFB8040, 0x8005004A},          /*   -64, 4091,   74,   -5 */
    {0x0FF6804E, 0x8006005E},          /*   -78, 4086,   94,   -6 */
    {0x0FF0805C, 0x80070073},          /*   -92, 4080,  115,   -7 */
    {0x0FEB806A, 0x80090088},          /*  -106, 4075,  136,   -9 */
    {0x0FE18076, 0x800A009F},          /*  -118, 4065,  159,  -10 */
    {0x0FD98082, 0x800C00B5},          /*  -130, 4057,  181,  -12 */
    {0x0FCE808E, 0x800D00CD},          /*  -142, 4046,  205,  -13 */
    {0x0FC38099, 0x800F00E5},          /*  -153, 4035,  229,  -15 */
    {0x0FB680A4, 0x801000FE},          /*  -164, 4022,  254,  -16 */
    {0x0FA880AD, 0x80120117},          /*  -173, 4008,  279,  -18 */
    {0x0F9A80B7, 0x80140131},          /*  -183, 3994,  305,  -20 */
    {0x0F8980C0, 0x8015014C},          /*  -192, 3977,  332,  -21 */
    {0x0F7880C8, 0x80170167},          /*  -200, 3960,  359,  -23 */
    {0x0F6680D0, 0x80190183},          /*  -208, 3942,  387,  -25 */
    {0x0F5280D7, 0x801B01A0},          /*  -215, 3922,  416,  -27 */
    {0x0F3E80DE, 0x801D01BD},          /*  -222, 3902,  445,  -29 */
    {0x0F2880E4, 0x801F01DB},          /*  -228, 3880,  475,  -31 */
    {0x0F1180EA, 0x802101FA},          /*  -234, 3857,  506,  -33 */
    {0x0EF880EE, 0x80220218},          /*  -238, 3832,  536,  -34 */
    {0x0EDF80F3, 0x80240238},          /*  -243, 3807,  568,  -36 */
    {0x0EC680F7, 0x80270258},          /*  -247, 3782,  600,  -39 */
    {0x0EAB80FB, 0x80290279},          /*  -251, 3755,  633,  -41 */
    {0x0E9080FF, 0x802B029A},          /*  -255, 3728,  666,  -43 */
    {0x0E748102, 0x802E02BC},          /*  -258, 3700,  700,  -46 */
    {0x0E588105, 0x803102DE},          /*  -261, 3672,  734,  -49 */
    {0x0E388107, 0x80330302},          /*  -263, 3640,  770,  -51 */
    {0x0E1A8109, 0x80360325},          /*  -265, 3610,  805,  -54 */
    {0x0DFB810B, 0x80390349},          /*  -267, 3579,  841,  -57 */
    {0x0DDB810C, 0x803C036D},          /*  -268, 3547,  877,  -60 */
    {0x0DBA810D, 0x803F0392},          /*  -269, 3514,  914,  -63 */
    {0x0D98810E, 0x804203B8},          /*  -270, 3480,  952,  -66 */
    {0x0D74810D, 0x804503DE},          /*  -269, 3444,  990,  -69 */
    {0x0D50810D, 0x80480405},          /*  -269, 3408, 1029,  -72 */
    {0x0D2C810C, 0x804B042B},          /*  -268, 3372, 1067,  -75 */
    {0x0D08810C, 0x804F0453},          /*  -268, 3336, 1107,  -79 */
    {0x0CE3810B, 0x8052047A},          /*  -267, 3299, 1146,  -82 */
    {0x0CBD810A, 0x805604A3},          /*  -266, 3261, 1187,  -86 */
    {0x0C968108, 0x805904CB},          /*  -264, 3222, 1227,  -89 */
    {0x0C708107, 0x805D04F4},          /*  -263, 3184, 1268,  -93 */
    {0x0C488105, 0x8061051E},          /*  -261, 3144, 1310,  -97 */
    {0x0C208103, 0x80640547},          /*  -259, 3104, 1351, -100 */
    {0x0BF78100, 0x80680571},          /*  -256, 3063, 1393, -104 */
    {0x0BCF80FE, 0x806C059B},          /*  -254, 3023, 1435, -108 */
    {0x0BA480FA, 0x807005C6},          /*  -250, 2980, 1478, -112 */
    {0x0B7A80F7, 0x807405F1},          /*  -247, 2938, 1521, -116 */
    {0x0B4F80F4, 0x8077061C},          /*  -244, 2895, 1564, -119 */
    {0x0B2580F1, 0x807C0648},          /*  -241, 2853, 1608, -124 */
    {0x0AFA80ED, 0x80800673},          /*  -237, 2810, 1651, -128 */
    {0x0ACF80EA, 0x8084069F},          /*  -234, 2767, 1695, -132 */
    {0x0AA380E6, 0x808806CB},          /*  -230, 2723, 1739, -136 */
    {0x0A7880E2, 0x808D06F7},          /*  -226, 2680, 1783, -141 */
    {0x0A4C80DF, 0x80910724},          /*  -223, 2636, 1828, -145 */
    {0x0A2080DB, 0x80960751},          /*  -219, 2592, 1873, -150 */
    {0x09F480D7, 0x809A077D},          /*  -215, 2548, 1917, -154 */
    {0x09C780D2, 0x809F07AA},          /*  -210, 2503, 1962, -159 */
    {0x099A80CE, 0x80A307D7},          /*  -206, 2458, 2007, -163 */
    {0x096D80CA, 0x80A70804},          /*  -202, 2413, 2052, -167 */
    {0x094180C6, 0x80AC0831},          /*  -198, 2369, 2097, -172 */
    {0x091380C1, 0x80B0085E},          /*  -193, 2323, 2142, -176 */
    {0x08E780BE, 0x80B5088C},          /*  -190, 2279, 2188, -181 */
    {0x08B980B9, 0x80B908B9},          /*  -185, 2233, 2233, -185 */
    {0x088C80B5, 0x80BE08E7},          /*  -181, 2188, 2279, -190 */
    {0x085E80B0, 0x80C10913},          /*  -176, 2142, 2323, -193 */
    {0x083180AC, 0x80C60941},          /*  -172, 2097, 2369, -198 */
    {0x080480A7, 0x80CA096D},          /*  -167, 2052, 2413, -202 */
    {0x07D780A3, 0x80CE099A},          /*  -163, 2007, 2458, -206 */
    {0x07AA809F, 0x80D209C7},          /*  -159, 1962, 2503, -210 */
    {0x077D809A, 0x80D709F4},          /*  -154, 1917, 2548, -215 */
    {0x07518096, 0x80DB0A20},          /*  -150, 1873, 2592, -219 */
    {0x07248091, 0x80DF0A4C},          /*  -145, 1828, 2636, -223 */
    {0x06F7808D, 0x80E20A78},          /*  -141, 1783, 2680, -226 */
    {0x06CA8088, 0x80E60AA4},          /*  -136, 1738, 2724, -230 */
    {0x069E8084, 0x80EA0AD0},          /*  -132, 1694, 2768, -234 */
    {0x06738080, 0x80ED0AFA},          /*  -128, 1651, 2810, -237 */
    {0x0647807C, 0x80F10B26},          /*  -124, 1607, 2854, -241 */
    {0x061B8077, 0x80F40B50},          /*  -119, 1563, 2896, -244 */
    {0x05F18074, 0x80F70B7A},          /*  -116, 1521, 2938, -247 */
    {0x05C68070, 0x80FA0BA4},          /*  -112, 1478, 2980, -250 */
    {0x059C806C, 0x80FE0BCE},          /*  -108, 1436, 3022, -254 */
    {0x05728068, 0x81000BF6},          /*  -104, 1394, 3062, -256 */
    {0x05478064, 0x81030C20},          /*  -100, 1351, 3104, -259 */
    {0x051E8061, 0x81050C48},          /*   -97, 1310, 3144, -261 */
    {0x04F4805D, 0x81070C70},          /*   -93, 1268, 3184, -263 */
    {0x04CB8059, 0x81080C96},          /*   -89, 1227, 3222, -264 */
    {0x04A38056, 0x810A0CBD},          /*   -86, 1187, 3261, -266 */
    {0x047A8052, 0x810B0CE3},          /*   -82, 1146, 3299, -267 */
    {0x0453804F, 0x810C0D08},          /*   -79, 1107, 3336, -268 */
    {0x042B804B, 0x810C0D2C},          /*   -75, 1067, 3372, -268 */
    {0x04048048, 0x810D0D51},          /*   -72, 1028, 3409, -269 */
    {0x03DE8045, 0x810D0D74},          /*   -69,  990, 3444, -269 */
    {0x03B88042, 0x810E0D98},          /*   -66,  952, 3480, -270 */
    {0x0393803F, 0x810D0DB9},          /*   -63,  915, 3513, -269 */
    {0x036E803C, 0x810C0DDA},          /*   -60,  878, 3546, -268 */
    {0x03498039, 0x810B0DFB},          /*   -57,  841, 3579, -267 */
    {0x03258036, 0x81090E1A},          /*   -54,  805, 3610, -265 */
    {0x03018033, 0x81070E39},          /*   -51,  769, 3641, -263 */
    {0x02DE8031, 0x81050E58},          /*   -49,  734, 3672, -261 */
    {0x02BC802E, 0x81020E74},          /*   -46,  700, 3700, -258 */
    {0x0299802B, 0x80FF0E91},          /*   -43,  665, 3729, -255 */
    {0x02788029, 0x80FB0EAC},          /*   -41,  632, 3756, -251 */
    {0x02578027, 0x80F70EC7},          /*   -39,  599, 3783, -247 */
    {0x02378024, 0x80F30EE0},          /*   -36,  567, 3808, -243 */
    {0x02178022, 0x80EE0EF9},          /*   -34,  535, 3833, -238 */
    {0x01FA8021, 0x80EA0F11},          /*   -33,  506, 3857, -234 */
    {0x01DC801F, 0x80E40F27},          /*   -31,  476, 3879, -228 */
    {0x01BE801D, 0x80DE0F3D},          /*   -29,  446, 3901, -222 */
    {0x01A1801B, 0x80D70F51},          /*   -27,  417, 3921, -215 */
    {0x01848019, 0x80D00F65},          /*   -25,  388, 3941, -208 */
    {0x01688017, 0x80C80F77},          /*   -23,  360, 3959, -200 */
    {0x014D8015, 0x80C00F88},          /*   -21,  333, 3976, -192 */
    {0x01328014, 0x80B70F99},          /*   -20,  306, 3993, -183 */
    {0x01188012, 0x80AD0FA7},          /*   -18,  280, 4007, -173 */
    {0x00FF8010, 0x80A40FB5},          /*   -16,  255, 4021, -164 */
    {0x00E6800F, 0x80990FC2},          /*   -15,  230, 4034, -153 */
    {0x00CE800D, 0x808E0FCD},          /*   -13,  206, 4045, -142 */
    {0x00B6800C, 0x80820FD8},          /*   -12,  182, 4056, -130 */
    {0x00A0800A, 0x80760FE0},          /*   -10,  160, 4064, -118 */
    {0x00898009, 0x806A0FEA},          /*    -9,  137, 4074, -106 */
    {0x00748007, 0x805C0FEF},          /*    -7,  116, 4079,  -92 */
    {0x005F8006, 0x804E0FF5},          /*    -6,   95, 4085,  -78 */
    {0x004B8005, 0x80400FFA},          /*    -5,   75, 4090,  -64 */
    {0x00378003, 0x80310FFD},          /*    -3,   55, 4093,  -49 */
    {0x00238002, 0x80211000},          /*    -2,   35, 4096,  -33 */
    {0x00118001, 0x80111001},          /*    -1,   17, 4097,  -17 */
};
