/*
 * kgraft_patch_bsc1110233
 *
 * Fix for CVE-2018-17182, bsc#1110233
 *
 *  Upstream commit:
 *  7a9cdebdcc17 ("mm: get rid of vmacache_flush_all() entirely")
 *
 *  SLE12(-SP1) commit:
 *  87c2bc500f79fbea82c36b362e5db5b16572552d
 *
 *  SLE12-SP2 and -SP3 commit:
 *  148d880a3b1ad3360a45a56d07370fff6b12b528
 *
 *  SLE15 commit:
 *  85bf27e4c22b632c384fcafc1d46cb9b84c6f15d
 *
 *
 *  Copyright (c) 2018 SUSE
 *  Author: Nicolai Stange <nstange@suse.de>
 *
 *  Based on the original Linux kernel code. Other copyrights apply.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include <linux/kernel.h>
#include <linux/vmacache.h>
#include "kgr_patch_bsc1110233.h"

#if IS_ENABLED(CONFIG_DEBUG_VM_VMACACHE)
#error "Live patch supports only CONFIG_DEBUG_VM_VMACACHE=n"
#endif

/* patched */
void kgr_vmacache_flush_all(struct mm_struct *mm)
{
	struct task_struct *g, *p;

	count_vm_vmacache_event(VMACACHE_FULL_FLUSHES);

	/*
	 * Fix CVE-2018-17182
	 *  -10 lines
	 */
	rcu_read_lock();
	for_each_process_thread(g, p) {
		/*
		 * Only flush the vmacache pointers as the
		 * mm seqnum is already set and curr's will
		 * be set upon invalidation when the next
		 * lookup is done.
		 */
		if (mm == p->mm)
			vmacache_flush(p);
	}
	rcu_read_unlock();
}
