#ifndef _KGR_PATCH_BSC1099306_KVM_H
#define _KGR_PATCH_BSC1099306_KVM_H

#if IS_ENABLED(CONFIG_X86_64) && IS_ENABLED(CONFIG_KVM)

#include <linux/kvm_types.h>

int __kgr_patch_bsc1099306_kvm_init(void);
void __kgr_patch_bsc1099306_kvm_cleanup(void);


struct x86_emulate_ctxt;
struct x86_exception;

int kgr_kvm_write_guest_virt_system(struct x86_emulate_ctxt *ctxt,
				    gva_t addr, void *val,
				    unsigned int bytes,
				    struct x86_exception *exception);
int kgr_x86_emulate_instruction(struct kvm_vcpu *vcpu,
				unsigned long cr2,
				int emulation_type,
				void *insn,
				int insn_len);
int kgr_kvm_arch_vcpu_ioctl_run(struct kvm_vcpu *vcpu, struct kvm_run *kvm_run);
void kgr_kvm_arch_sched_in(struct kvm_vcpu *vcpu, int cpu);
void kgr_kvm_arch_vcpu_free(struct kvm_vcpu *vcpu);
struct kvm_vcpu *kgr_kvm_arch_vcpu_create(struct kvm *kvm,
					  unsigned int id);
int kgr_kvm_mmu_page_fault(struct kvm_vcpu *vcpu, gva_t cr2, u32 error_code,
			   void *insn, int insn_len);

#define __KGR_PATCH_BSC1099306_KVM_FUNCS				\
	KGR_PATCH_OBJ(kvm_write_guest_virt_system,			\
			kgr_kvm_write_guest_virt_system, "kvm"),	\
	KGR_PATCH_OBJ(x86_emulate_instruction,				\
			kgr_x86_emulate_instruction, "kvm"),		\
	KGR_PATCH_OBJ(kvm_arch_vcpu_ioctl_run,				\
			kgr_kvm_arch_vcpu_ioctl_run, "kvm"),		\
	KGR_PATCH_OBJ(kvm_arch_sched_in,				\
			kgr_kvm_arch_sched_in, "kvm"),			\
	KGR_PATCH_OBJ(kvm_arch_vcpu_free, kgr_kvm_arch_vcpu_free,	\
							"kvm"),	\
	KGR_PATCH_OBJ(kvm_arch_vcpu_create, kgr_kvm_arch_vcpu_create,	\
							"kvm"),	\
	KGR_PATCH_OBJ(kvm_mmu_page_fault, kgr_kvm_mmu_page_fault,	\
							"kvm"),	\


#endif /* IS_ENABLED(CONFIG_X86_64) && IS_ENABLED(CONFIG_KVM) */

#endif /* _KGR_PATCH_BSC1099306_KVM_H */
