#ifndef _BSC1099306_H
#define _BSC1099306_H

#include <linux/percpu.h>
#include <asm/processor.h>
#include <asm/cpufeature.h>

DECLARE_PER_CPU(bool, kgr_kvm_cpu_l1tf_flush_l1d);

struct kvm_vcpu;

static inline bool kgr_never_needs_l1d_flush(void)
{
	return (static_cpu_has(X86_FEATURE_HYPERVISOR) ||
		boot_cpu_data.x86_vendor != X86_VENDOR_INTEL);
}

void kgr_set_vcpu_unconfined(struct kvm_vcpu *vcpu, gfp_t gfp_flags);

bool kgr_get_and_clear_vcpu_unconfined(struct kvm_vcpu *vcpu, gfp_t gfp_flags);

void kgr_free_vcpu_unconfined_shadow(struct kvm_vcpu *vcpu);

#endif /* _BSC1099306_H */
